//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "StdAfx.h"
#include "SettingsSaver.h"
#include "PartFile.h"
#include "emule.h"
#include "Log.h" // for AddLogLine()
#include "Preferences.h" // for thePrefs
#include "emuledlg.h" // for theApp.emuledlg


CSettingsSaver::CSettingsSaver(void){}
CSettingsSaver::~CSettingsSaver(void){}

void CSettingsSaver::DeleteFile(CPartFile* file)
{
	CString datafilepath;
	datafilepath.Format(_T("%s\\%s.sivka"), thePrefs.GetTempDir(), file->GetPartMetFileName());
	if(_tremove(datafilepath)) if (errno != ENOENT)
		AddLogLine(true,_T("Failed to delete %s, you will need to do this by hand"),datafilepath);
}

void CSettingsSaver::LoadSettings(CPartFile* file)
{
	SettingsList daten;
	CString datafilepath;
	bool versioncheck = false;
	
	datafilepath.Format(_T("%s\\%s.sivka"), thePrefs.GetTempDir(), file->GetPartMetFileName());

	CString strLine;
	CStdioFile f;
	if (!f.Open(datafilepath, CFile::modeReadWrite | CFile::typeText))
		return;
	while(f.ReadString(strLine))
	{
		if (strLine.GetAt(0) == '#')
		{
			if (strLine.GetAt(1) == 'v' && strLine.GetAt(2) == '2' )
				versioncheck = true;
			continue;
		}
		
		int pos = strLine.Find(_T('\0'));
		if (pos == -1)
			continue;
		CString strData = strLine.Left(pos);
		CSettingsData* newdata = new CSettingsData(_ttol(strData));
		daten.AddTail(newdata);
	}
	f.Close();

	if(!versioncheck || daten.GetCount() < 18)
		return;

	POSITION pos = daten.GetHeadPosition();
	if(!pos)
		return;

	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 50 && ((CSettingsData*)daten.GetAt(pos))->uData <= 2000)
		file->SetMaxSourcesPerFile(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetMaxSourcesPerFile(thePrefs.GetMaxSourcesPerFileDefault());
		
	daten.GetNext(pos); 
	if( ((CSettingsData*)daten.GetAt(pos))->uData == 0 || ((CSettingsData*)daten.GetAt(pos))->uData == 1)
		file->SetEnableAutoHL(((CSettingsData*)daten.GetAt(pos))->uData>0);
	else
		file->SetEnableAutoHL(thePrefs.GetEnableAutoHLDefault());
	

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 0 && ((CSettingsData*)daten.GetAt(pos))->uData <= 60000)
		file->SetAutoHL_Timer(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetAutoHL_Timer(thePrefs.GetAutoHL_TimerDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData == 0 || ((CSettingsData*)daten.GetAt(pos))->uData == 1)
		file->SetEnableAutoDropNNS(((CSettingsData*)daten.GetAt(pos))->uData>0);
	else
		file->SetEnableAutoDropNNS(thePrefs.GetEnableAutoDropNNSDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 0 && ((CSettingsData*)daten.GetAt(pos))->uData <= 60000)
		file->SetAutoNNS_Timer(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetAutoNNS_Timer(thePrefs.GetAutoNNS_TimerDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 50 && ((CSettingsData*)daten.GetAt(pos))->uData <= 100)
		file->SetMaxRemoveNNSLimit(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetMaxRemoveNNSLimit(thePrefs.GetMaxRemoveNNSLimitDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData == 0 || ((CSettingsData*)daten.GetAt(pos))->uData == 1)
		file->SetEnableAutoDropFQS(((CSettingsData*)daten.GetAt(pos))->uData>0);
	else
		file->SetEnableAutoDropFQS(thePrefs.GetEnableAutoDropFQSDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 0 && ((CSettingsData*)daten.GetAt(pos))->uData <= 60000)
		file->SetAutoFQS_Timer(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetAutoFQS_Timer(thePrefs.GetAutoFQS_TimerDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 50 && ((CSettingsData*)daten.GetAt(pos))->uData <= 100)
		file->SetMaxRemoveFQSLimit(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetMaxRemoveFQSLimit(thePrefs.GetMaxRemoveFQSLimitDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData == 0 || ((CSettingsData*)daten.GetAt(pos))->uData == 1)
		file->SetEnableAutoDropQRS(((CSettingsData*)daten.GetAt(pos))->uData>0);
	else
		file->SetEnableAutoDropQRS(thePrefs.GetEnableAutoDropQRSDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 0 && ((CSettingsData*)daten.GetAt(pos))->uData <= 60000)
		file->SetAutoHQRS_Timer(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetAutoHQRS_Timer(thePrefs.GetAutoHQRS_TimerDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 1000 && ((CSettingsData*)daten.GetAt(pos))->uData <= 10000)
		file->SetMaxRemoveQRS(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetMaxRemoveQRS(thePrefs.GetMaxRemoveQRSDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 50 && ((CSettingsData*)daten.GetAt(pos))->uData <= 100)
		file->SetMaxRemoveQRSLimit(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetMaxRemoveQRSLimit(thePrefs.GetMaxRemoveQRSLimitDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData == 0 || ((CSettingsData*)daten.GetAt(pos))->uData == 1)
		file->SetNNSSound(((CSettingsData*)daten.GetAt(pos))->uData>0);
	else
		file->SetNNSSound(thePrefs.GetNNSSoundDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData == 0 || ((CSettingsData*)daten.GetAt(pos))->uData == 1)
		file->SetFQSSound(((CSettingsData*)daten.GetAt(pos))->uData>0);
	else
		file->SetFQSSound(thePrefs.GetFQSSoundDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData == 0 || ((CSettingsData*)daten.GetAt(pos))->uData == 1)
		file->SetQRSSound(((CSettingsData*)daten.GetAt(pos))->uData>0);
	else
		file->SetQRSSound(thePrefs.GetQRSSoundDefault());

	daten.GetNext(pos);
	if( ((CSettingsData*)daten.GetAt(pos))->uData >= 900000 && ((CSettingsData*)daten.GetAt(pos))->uData <= 3600000)
		file->SetReaskServer4SRC(((CSettingsData*)daten.GetAt(pos))->uData);
	else
		file->SetReaskServer4SRC(thePrefs.GetReaskServer4SRCDefault());

	daten.GetNext(pos); 
	if( ((CSettingsData*)daten.GetAt(pos))->uData == 0 || ((CSettingsData*)daten.GetAt(pos))->uData == 1)
		file->SetEnableZeroFilledTest(((CSettingsData*)daten.GetAt(pos))->uData>0);
	else
		file->SetEnableZeroFilledTest(thePrefs.GetEnableZeroFilledTestDefault());

	while (!daten.IsEmpty()) 
		delete daten.RemoveHead();
}

void CSettingsSaver::SaveSettings(CPartFile* file)
{
	CString datafilepath;
	datafilepath.Format(_T("%s\\%s.sivka"), thePrefs.GetTempDir(), file->GetPartMetFileName());
	
	CString strLine;
	CStdioFile f;

	if (!f.Open(datafilepath, CFile::modeCreate | CFile::modeWrite | CFile::typeText))
		return;

	f.WriteString(_T("#Sivka File Settings:\n"));
	f.WriteString(_T("#v2\n"));
	strLine.Format(_T("%u\n"), file->GetMaxSourcesPerFile());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetEnableAutoHL());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetAutoHL_Timer());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetEnableAutoDropNNS());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetAutoNNS_Timer());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetMaxRemoveNNSLimit());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetEnableAutoDropFQS());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetAutoFQS_Timer());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetMaxRemoveFQSLimit());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetEnableAutoDropQRS());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetAutoHQRS_Timer());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetMaxRemoveQRS());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetMaxRemoveQRSLimit());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetNNSSound());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetFQSSound());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetQRSSound());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetReaskServer4SRC());
	f.WriteString(strLine);
	strLine.Format(_T("%u\n"), file->GetEnableZeroFilledTest());
	f.WriteString(strLine);
	
	f.Close();
}
