//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

class CPPgSivkaSettings : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgSivkaSettings)

public:
	CPPgSivkaSettings();
	virtual ~CPPgSivkaSettings();
	enum { IDD = IDD_PPG_SIVKASETTINGS }; // Dialog Data

protected:
	virtual void DoDataExchange(CDataExchange* pDX); // DDX/DDV support
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	DECLARE_MESSAGE_MAP()

public:
	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	void Localize(void);
	void LoadSettings(void);
	
//	afx_msg void OnEnChangeHideOverShares();
	
	afx_msg void OnLoadReleaseBonus();
	afx_msg void OnBnClickedReleaseBonus();

	afx_msg void OnLoadWQueueOverflow();
	afx_msg void OnBnClickedWQueueOverflow();
	afx_msg void OnBnClickedWQueueOverflow_FR_VS_REL();

	afx_msg void OnLoadSourcesRequestThreshold();
	afx_msg void OnBnClickedSourcesRequestThreshold();
	
	afx_msg void OnBnClickedModified() { SetModified();}
	afx_msg void OnEnChangeModified() { SetModified();}

private:
	void ShowUpDRUpSlotsValues();
	void ShowPushSmallFileValues();
	void ShowReAskFileSRCValues();
	CString FillWithZeros(uint32);
};