//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "emule.h"
#include "PPgSivkaSettings2.h"
#include "OtherFunctions.h" // for GetResString()
#include "Preferences.h" // for thePrefs
#include "LanCast.h" //added by sivka [moosetea: -LanCast-]

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(CPPgSivkaSettings2, CPropertyPage)
CPPgSivkaSettings2::CPPgSivkaSettings2()
	: CPropertyPage(CPPgSivkaSettings2::IDD)
{
}

CPPgSivkaSettings2::~CPPgSivkaSettings2()
{
}

void CPPgSivkaSettings2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgSivkaSettings2, CPropertyPage)

	ON_BN_CLICKED(IDC_PW_FILTER, EnDisableFilterLANIPs)
	ON_BN_CLICKED(IDC_LANCAST_LBL, EnDisableLanCast)
	ON_EN_CHANGE(IDC_LANCAST_PORT, OnEnChangeModified)

END_MESSAGE_MAP()


// CPPgSivkaSettings2 message handlers

BOOL CPPgSivkaSettings2::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgSivkaSettings2::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
		
		if(thePrefs.filterLANIPs)
			CheckDlgButton(IDC_PW_FILTER,1);
		else
			CheckDlgButton(IDC_PW_FILTER,0);
		ShowHideLanCast();

		if(thePrefs.bLanCast)
			CheckDlgButton(IDC_LANCAST_LBL,1);
		else
			CheckDlgButton(IDC_LANCAST_LBL,0);
		ShowHideLanCastSettings();

		strBuffer.Format(_T("%u"), thePrefs.uiLanCastPort);
		GetDlgItem(IDC_LANCAST_PORT)->SetWindowText(strBuffer);
	}
}

BOOL CPPgSivkaSettings2::OnApply()
{
	CString strBuffer;

	if(IsDlgButtonChecked(IDC_PW_FILTER))
		thePrefs.filterLANIPs = true;
	else
		thePrefs.filterLANIPs = false;
	
	if(IsDlgButtonChecked(IDC_LANCAST_LBL) && !IsDlgButtonChecked(IDC_PW_FILTER)){
		thePrefs.bLanCast = true;
		theApp.lancast->Start();
	}
	else {
		thePrefs.bLanCast = false;
		theApp.lancast->Stop();
	}

	if(GetDlgItem(IDC_LANCAST_PORT)->GetWindowTextLength())
	{
		GetDlgItem(IDC_LANCAST_PORT)->GetWindowText(strBuffer);
		if(_ttoi(strBuffer) >= 1024 && _ttoi(strBuffer) <= 65535)
			thePrefs.uiLanCastPort = _ttoi(strBuffer);
	}
	
	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgSivkaSettings2::Localize(void)
{	
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PPG_SIVKASETTINGS2));
		GetDlgItem(IDC_PW_FILTER)->SetWindowText(GetResString(IDS_PW_FILTER));
		GetDlgItem(IDC_LANCAST_LBL)->SetWindowText(GetResString(IDS_LANCAST_LBL));
		GetDlgItem(IDC_LANCAST_PORT_LBL)->SetWindowText(GetResString(IDS_LANCAST_PORT_LBL));
	}
}

void CPPgSivkaSettings2::EnDisableFilterLANIPs(void)
{
	ShowHideLanCast();
	ShowHideLanCastSettings();
	SetModified();
}

void CPPgSivkaSettings2::ShowHideLanCast(void)
{
	if(IsDlgButtonChecked(IDC_PW_FILTER))
		GetDlgItem(IDC_LANCAST_LBL)->EnableWindow(false);
	else
		GetDlgItem(IDC_LANCAST_LBL)->EnableWindow(true);
}

void CPPgSivkaSettings2::EnDisableLanCast(void)
{
	ShowHideLanCastSettings();
	SetModified();
}

void CPPgSivkaSettings2::ShowHideLanCastSettings(void)
{
	if(IsDlgButtonChecked(IDC_LANCAST_LBL) && !IsDlgButtonChecked(IDC_PW_FILTER)){
		GetDlgItem(IDC_LANCAST_PORT)->EnableWindow(true);
		GetDlgItem(IDC_LANCAST_PORT_LBL)->EnableWindow(true);
	}
	else {
		GetDlgItem(IDC_LANCAST_PORT)->EnableWindow(false);
		GetDlgItem(IDC_LANCAST_PORT_LBL)->EnableWindow(false);
	}
}
