//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include <math.h> // for sqrtf()
#include "emule.h"
#include "PPgSivkaSettings.h"
#include "OtherFunctions.h" // for GetResString()
#include "PartFile.h" // for PARTSIZE
#include "Preferences.h" // for thePrefs
#include "opcodes.h" // for UNLIMITED

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(CPPgSivkaSettings, CPropertyPage)
CPPgSivkaSettings::CPPgSivkaSettings()
	: CPropertyPage(CPPgSivkaSettings::IDD)
{
}

CPPgSivkaSettings::~CPPgSivkaSettings()
{
}

void CPPgSivkaSettings::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgSivkaSettings, CPropertyPage)

//	ON_BN_CLICKED(IDC_SELECTIVESHARE, OnBnClickedModified)
//	ON_EN_CHANGE(IDC_HIDEOVERSHARES, OnEnChangeHideOverShares)

	ON_WM_HSCROLL()

	ON_BN_CLICKED(IDC_RELEASE_BONUS, OnBnClickedReleaseBonus)
	ON_BN_CLICKED(IDC_RELEASE_BONUS1, OnBnClickedModified)
	ON_BN_CLICKED(IDC_RELEASE_BONUS2, OnBnClickedModified)
	ON_BN_CLICKED(IDC_RELEASE_BONUS3, OnBnClickedModified)
	ON_BN_CLICKED(IDC_RELEASE_BONUS4, OnBnClickedModified)
	ON_BN_CLICKED(IDC_RELEASE_BONUS5, OnBnClickedModified)

	ON_BN_CLICKED(IDC_WAITINGQUEUE_OVERFLOW, OnBnClickedWQueueOverflow)
	ON_BN_CLICKED(IDC_WAITINGQUEUE_OVERFLOW_FR, OnBnClickedWQueueOverflow_FR_VS_REL)
	ON_BN_CLICKED(IDC_WAITINGQUEUE_OVERFLOW_VS, OnBnClickedWQueueOverflow_FR_VS_REL)
	ON_BN_CLICKED(IDC_WAITINGQUEUE_OVERFLOW_REL, OnBnClickedWQueueOverflow_FR_VS_REL)

	ON_EN_CHANGE(IDC_PUSHSMALLFILES, OnEnChangeModified)

	ON_BN_CLICKED(IDC_SRCREQTHRESHOLD, OnBnClickedSourcesRequestThreshold)
	ON_EN_CHANGE(IDC_SRCREQTHRESHOLD1, OnEnChangeModified)
	ON_EN_CHANGE(IDC_SRCREQTHRESHOLD2, OnEnChangeModified)
	
	ON_BN_CLICKED(IDC_REASKSRCAFTERIPCHANGE, OnBnClickedModified) // [Maella/sivka: -ReAsk SRCs after IP Change-]
	ON_BN_CLICKED(IDC_REWARD_SI_CLIENT, OnBnClickedModified)
	ON_BN_CLICKED(IDC_HASHTHIEF_PROTECTION, OnBnClickedModified)
	ON_BN_CLICKED(IDC_RECONNECTLOWID, OnBnClickedModified) // [Tarod]

END_MESSAGE_MAP()


// CPPgSivkaSettings message handlers

BOOL CPPgSivkaSettings::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgSivkaSettings::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
		
		// Hide OverShares
		//strBuffer.Format(_T("%d"), thePrefs.hideOS);
		//GetDlgItem(IDC_HIDEOVERSHARES)->SetWindowText(strBuffer);
		//if(thePrefs.IsSelectiveShareEnabled() && thePrefs.GetHideOvershares())
		//	CheckDlgButton(IDC_SELECTIVESHARE,1);
		//else
		//	CheckDlgButton(IDC_SELECTIVESHARE,0);
		//GetDlgItem(IDC_SELECTIVESHARE)->EnableWindow(thePrefs.GetHideOvershares());

		// added by sivka [sivka: -Upload Slots and Upload Datarate Per Client-]
		UINT MaxUpSpeed = (thePrefs.maxupload==UNLIMITED)?thePrefs.maxGraphUploadRate:thePrefs.maxupload;
		((CSliderCtrl*)GetDlgItem(IDC_UP_SLOTS_SLIDER))->SetRange(1,MaxUpSpeed<3?1:(MaxUpSpeed>255?255:(MaxUpSpeed-1)),TRUE);
		((CSliderCtrl*)GetDlgItem(IDC_UP_SLOTS_SLIDER))->SetPos(thePrefs.UpSlotsPerClient-1);
		ShowUpDRUpSlotsValues();

		// added by sivka [sivka: -Release Priority-]
		uint32 priority = thePrefs.GetReleaseBonus();
		if(priority == 16)
		{
			CheckDlgButton(IDC_RELEASE_BONUS5,1);
			CheckDlgButton(IDC_RELEASE_BONUS,1);
			OnLoadReleaseBonus();
		}
		else if(priority == 8)
		{
			CheckDlgButton(IDC_RELEASE_BONUS4,1);
			CheckDlgButton(IDC_RELEASE_BONUS,1);
			OnLoadReleaseBonus();
		}
		else if(priority == 4)
		{
			CheckDlgButton(IDC_RELEASE_BONUS3,1);
			CheckDlgButton(IDC_RELEASE_BONUS,1);
			OnLoadReleaseBonus();
		}
		else if(priority == 2)
		{
			CheckDlgButton(IDC_RELEASE_BONUS2,1);
			CheckDlgButton(IDC_RELEASE_BONUS,1);
			OnLoadReleaseBonus();
		}
		else if(priority == 1)
		{
			CheckDlgButton(IDC_RELEASE_BONUS1,1);
			CheckDlgButton(IDC_RELEASE_BONUS,1);
			OnLoadReleaseBonus();
		}
		else
		{
			CheckDlgButton(IDC_RELEASE_BONUS5,0);
			CheckDlgButton(IDC_RELEASE_BONUS4,0);
			CheckDlgButton(IDC_RELEASE_BONUS3,0);
			CheckDlgButton(IDC_RELEASE_BONUS2,0);
			CheckDlgButton(IDC_RELEASE_BONUS1,0);
			CheckDlgButton(IDC_RELEASE_BONUS,0);
			OnLoadReleaseBonus();
		}
		// end [sivka: -Release Priority-]
		
		// added by sivka [sivka: -WaitingQueue Overflow-]
		if(thePrefs.IsWQueueOverflow())
			CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW,1);
		else
			CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW,0);
		if(thePrefs.IsWQueueOverflowFR())
			CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_FR,1);
		else
			CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_FR,0);
		if(thePrefs.IsWQueueOverflowVS())
			CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_VS,1);
		else
			CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_VS,0);
		if(thePrefs.IsWQueueOverflowREL())
			CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_REL,1);
		else
			CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_REL,0);
		OnLoadWQueueOverflow();
		// end [sivka: -WaitingQueue Overflow-]
		
		// added by sivka [sivka: -Push Small Files-]
		((CSliderCtrl*)GetDlgItem(IDC_PUSHSMALLFILES_SLIDER))->SetRange(1, PARTSIZE, TRUE);
		((CSliderCtrl*)GetDlgItem(IDC_PUSHSMALLFILES_SLIDER))->SetPos(thePrefs.uPushSmallFiles);
		ShowPushSmallFileValues();

		// added by sivka [Timer for Reask File Sources]
		((CSliderCtrl*)GetDlgItem(IDC_REASKFILESRC_SLIDER))->SetRange(FILEREASKTIME/1000, 3300, TRUE); // 55 mins
		((CSliderCtrl*)GetDlgItem(IDC_REASKFILESRC_SLIDER))->SetPos(thePrefs.uReAskFileSRC/1000);
		ShowReAskFileSRCValues();

		//added by sivka [safe CPU time and check for aggressivity - improved]
		if(thePrefs.bClientUpRequestLog)
			CheckDlgButton(IDC_SRCREQTHRESHOLD,1);
		else
			CheckDlgButton(IDC_SRCREQTHRESHOLD,0);
		strBuffer.Format(_T("%d"),thePrefs.uiClientUpRequestAsk);
		GetDlgItem(IDC_SRCREQTHRESHOLD1)->SetWindowText(strBuffer);
		strBuffer.Format(_T("%d"),(thePrefs.uiClientUpRequestTime/60000));
		GetDlgItem(IDC_SRCREQTHRESHOLD2)->SetWindowText(strBuffer);
		OnLoadSourcesRequestThreshold();

		//added by sivka [Maella/sivka: -ReAsk SRCs after IP Change-]
		if(thePrefs.bReAskSRCAfterIPChange)
			CheckDlgButton(IDC_REASKSRCAFTERIPCHANGE,1);
		else
			CheckDlgButton(IDC_REASKSRCAFTERIPCHANGE,0);

		if(thePrefs.IsRewardOnlySIClients())
			CheckDlgButton(IDC_REWARD_SI_CLIENT,1);
		else
			CheckDlgButton(IDC_REWARD_SI_CLIENT,0);

		if(thePrefs.IsHashThiefProtectionEnabled())
			CheckDlgButton(IDC_HASHTHIEF_PROTECTION,1);
		else
			CheckDlgButton(IDC_HASHTHIEF_PROTECTION,0);
		GetDlgItem(IDC_HASHTHIEF_PROTECTION)->EnableWindow(false); // added by sivka
		CheckDlgButton(IDC_HASHTHIEF_PROTECTION,0); // added by sivka

		if(thePrefs.reconnect_low_id) //added by sivka [Tarod]
			CheckDlgButton(IDC_RECONNECTLOWID,1);
		else
			CheckDlgButton(IDC_RECONNECTLOWID,0);
	}
}

BOOL CPPgSivkaSettings::OnApply()
{
	CString strBuffer;

	// Hide OverShares
	//if(GetDlgItem(IDC_HIDEOVERSHARES)->GetWindowTextLength())
	//{
	//	GetDlgItem(IDC_HIDEOVERSHARES)->GetWindowText(strBuffer);
	//	if(_ttoi(strBuffer) >= 0 && _ttoi(strBuffer) <= 255)
	//		thePrefs.hideOS = _ttoi(strBuffer);
	//}
	//if(IsDlgButtonChecked(IDC_SELECTIVESHARE) && thePrefs.hideOS > 0)
	//	thePrefs.selectiveShare = 1;
	//else
	//	thePrefs.selectiveShare = 0;

	// added by sivka [sivka: -Upload Slots and Upload Datarate Per Client-]
	thePrefs.UpSlotsPerClient = ((CSliderCtrl*)GetDlgItem(IDC_UP_SLOTS_SLIDER))->GetPos()+1;
	
	// added by sivka [sivka: -Release Priority-]
	if(IsDlgButtonChecked(IDC_RELEASE_BONUS5))
		thePrefs.SetReleaseBonus(16);
	else if(IsDlgButtonChecked(IDC_RELEASE_BONUS4))
		thePrefs.SetReleaseBonus(8);
	else if(IsDlgButtonChecked(IDC_RELEASE_BONUS3))
		thePrefs.SetReleaseBonus(4);
	else if(IsDlgButtonChecked(IDC_RELEASE_BONUS2))
		thePrefs.SetReleaseBonus(2);
	else if(IsDlgButtonChecked(IDC_RELEASE_BONUS1))
		thePrefs.SetReleaseBonus(1);
	else
		thePrefs.SetReleaseBonus(0);
	// end [sivka: -Release Priority-]

	// added by sivka [sivka: -WaitingQueue Overflow-]
	if(IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW))
		thePrefs.SetWQueueOverflow(true);
	else
		thePrefs.SetWQueueOverflow(false);
	if(IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_FR))
		thePrefs.SetWQueueOverflowFR(true);
	else
		thePrefs.SetWQueueOverflowFR(false);
	if(IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_VS))
		thePrefs.SetWQueueOverflowVS(true);
	else
		thePrefs.SetWQueueOverflowVS(false);
	if(IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_REL))
		thePrefs.SetWQueueOverflowREL(true);
	else
		thePrefs.SetWQueueOverflowREL(false);
	// end [sivka: -WaitingQueue Overflow-]

	// added by sivka [sivka: -Push Small Files-]
	((CSliderCtrl*)GetDlgItem(IDC_PUSHSMALLFILES_SLIDER))->SetRange(1, PARTSIZE, TRUE);
	thePrefs.uPushSmallFiles = ((CSliderCtrl*)GetDlgItem(IDC_PUSHSMALLFILES_SLIDER))->GetPos();
		
	// added by sivka [Timer for Reask File Sources]
	((CSliderCtrl*)GetDlgItem(IDC_REASKFILESRC_SLIDER))->SetRange(FILEREASKTIME/1000, 3300, TRUE); // 55 mins
	thePrefs.uReAskFileSRC = (((CSliderCtrl*)GetDlgItem(IDC_REASKFILESRC_SLIDER))->GetPos())*1000;

	//added by sivka [safe CPU time and check for aggressivity - improved]
	if(IsDlgButtonChecked(IDC_SRCREQTHRESHOLD))
		thePrefs.bClientUpRequestLog = true;
	else
		thePrefs.bClientUpRequestLog = false;
	if(GetDlgItem(IDC_SRCREQTHRESHOLD1)->GetWindowTextLength())
	{
		GetDlgItem(IDC_SRCREQTHRESHOLD1)->GetWindowText(strBuffer);
		if( _ttoi(strBuffer) <= 5 )
			thePrefs.uiClientUpRequestAsk = 5;
		else if( _ttoi(strBuffer) >= 15 )
			thePrefs.uiClientUpRequestAsk = 15;
		else
			thePrefs.uiClientUpRequestAsk = _ttoi(strBuffer);
	}
	if(GetDlgItem(IDC_SRCREQTHRESHOLD2)->GetWindowTextLength())
	{
		GetDlgItem(IDC_SRCREQTHRESHOLD2)->GetWindowText(strBuffer);
		if( _ttoi(strBuffer) <= 5 )
			thePrefs.uiClientUpRequestTime = 300000;
		else if( _ttoi(strBuffer) >= 12 )
			thePrefs.uiClientUpRequestTime = 720000;
		else
			thePrefs.uiClientUpRequestTime = (_ttoi(strBuffer)*60000);
	}

	//added by sivka [Maella/sivka: -ReAsk SRCs after IP Change-]
	if(IsDlgButtonChecked(IDC_REASKSRCAFTERIPCHANGE))
		thePrefs.bReAskSRCAfterIPChange = true;
	else
		thePrefs.bReAskSRCAfterIPChange = false;

	if(IsDlgButtonChecked(IDC_REWARD_SI_CLIENT))
		thePrefs.SetRewardOnlySIClients(true);
	else
		thePrefs.SetRewardOnlySIClients(false);

	if(IsDlgButtonChecked(IDC_HASHTHIEF_PROTECTION))
		thePrefs.SetHashThiefProtectionEnabled(true);
	else
		thePrefs.SetHashThiefProtectionEnabled(false);

	if(IsDlgButtonChecked(IDC_RECONNECTLOWID)) //added by sivka [Tarod]
		thePrefs.reconnect_low_id = true;
	else
		thePrefs.reconnect_low_id = false;
		
	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgSivkaSettings::Localize(void)
{	
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PPG_SIVKASETTINGS));
//    		GetDlgItem(IDC_SELECTIVESHARE)->SetWindowText(GetResString(IDS_SELECTIVESHARE));
//	  		GetDlgItem(IDC_HIDEOVERSHARES_LABEL)->SetWindowText(GetResString(IDS_HIDEOVERSHARES_LABEL));
		GetDlgItem(IDC_UP_SLOTS_LABEL)->SetWindowText(GetResString(IDS_UP_SLOTS_LABEL));
		GetDlgItem(IDC_UP_DR_PER_CLIENT_LABEL)->SetWindowText(GetResString(IDS_UP_DR_PER_CLIENT_LABEL));
		GetDlgItem(IDC_RELEASE_BONUS)->SetWindowText(GetResString(IDS_RELEASE_BONUS));
		GetDlgItem(IDC_PUSHSMALLFILES_LABEL)->SetWindowText(GetResString(IDS_PUSHSMALLFILES_LABEL));
		GetDlgItem(IDC_REASKFILESRC_LABEL)->SetWindowText(GetResString(IDS_REASKFILESRC_LABEL));
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW)->SetWindowText(GetResString(IDS_WAITINGQUEUE_OVERFLOW));
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_FR)->SetWindowText(GetResString(IDS_WAITINGQUEUE_OVERFLOW_FR));
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_VS)->SetWindowText(GetResString(IDS_WAITINGQUEUE_OVERFLOW_VS));
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_REL)->SetWindowText(GetResString(IDS_WAITINGQUEUE_OVERFLOW_REL));
		GetDlgItem(IDC_SRCREQTHRESHOLD)->SetWindowText(GetResString(IDS_SRCREQTHRESHOLD));
		GetDlgItem(IDC_SRCREQTHRESHOLD_LBL1)->SetWindowText(GetResString(IDS_SRCREQTHRESHOLD_LBL1));
		GetDlgItem(IDC_SRCREQTHRESHOLD_LBL2)->SetWindowText(GetResString(IDS_SRCREQTHRESHOLD_LBL2));
		GetDlgItem(IDC_REASKSRCAFTERIPCHANGE)->SetWindowText(GetResString(IDS_REASKSRCAFTERIPCHANGE));
		GetDlgItem(IDC_REWARD_SI_CLIENT)->SetWindowText(GetResString(IDS_REWARD_SI_CLIENT));
		GetDlgItem(IDC_HASHTHIEF_PROTECTION)->SetWindowText(GetResString(IDS_HASHTHIEF_PROTECTION));
		GetDlgItem(IDC_RECONNECTLOWID)->SetWindowText(GetResString(IDS_RECONNECTLOWID));
	}
}

// added by sivka [sivka: -Hide OverShares-)
//void CPPgSivkaSettings::OnEnChangeHideOverShares()
//{
//	CString strBuffer;
//	if(GetDlgItem(IDC_HIDEOVERSHARES)->GetWindowTextLength())
//	{
//		GetDlgItem(IDC_HIDEOVERSHARES)->GetWindowText(strBuffer);
//		GetDlgItem(IDC_SELECTIVESHARE)->EnableWindow(_ttoi(strBuffer));
//	}	
//	SetModified();
//}

// added by sivka [sivka: -Release Priority-]
void CPPgSivkaSettings::OnLoadReleaseBonus()
{
	GetDlgItem(IDC_RELEASE_BONUS1)->EnableWindow(IsDlgButtonChecked(IDC_RELEASE_BONUS));
	GetDlgItem(IDC_RELEASE_BONUS2)->EnableWindow(IsDlgButtonChecked(IDC_RELEASE_BONUS));
	GetDlgItem(IDC_RELEASE_BONUS3)->EnableWindow(IsDlgButtonChecked(IDC_RELEASE_BONUS));
	GetDlgItem(IDC_RELEASE_BONUS4)->EnableWindow(IsDlgButtonChecked(IDC_RELEASE_BONUS));
	GetDlgItem(IDC_RELEASE_BONUS5)->EnableWindow(IsDlgButtonChecked(IDC_RELEASE_BONUS));
}

void CPPgSivkaSettings::OnBnClickedReleaseBonus()
{
	if(IsDlgButtonChecked(IDC_RELEASE_BONUS))
	{
		GetDlgItem(IDC_RELEASE_BONUS1)->EnableWindow(true);
		GetDlgItem(IDC_RELEASE_BONUS2)->EnableWindow(true);
		GetDlgItem(IDC_RELEASE_BONUS3)->EnableWindow(true);
		GetDlgItem(IDC_RELEASE_BONUS4)->EnableWindow(true);
		GetDlgItem(IDC_RELEASE_BONUS5)->EnableWindow(true);
	}
	else
	{
		CheckDlgButton(IDC_RELEASE_BONUS1,0);
		CheckDlgButton(IDC_RELEASE_BONUS2,0);
		CheckDlgButton(IDC_RELEASE_BONUS3,0);
		CheckDlgButton(IDC_RELEASE_BONUS4,0);
		CheckDlgButton(IDC_RELEASE_BONUS5,0);
		GetDlgItem(IDC_RELEASE_BONUS1)->EnableWindow(false);
		GetDlgItem(IDC_RELEASE_BONUS2)->EnableWindow(false);
		GetDlgItem(IDC_RELEASE_BONUS3)->EnableWindow(false);
		GetDlgItem(IDC_RELEASE_BONUS4)->EnableWindow(false);
		GetDlgItem(IDC_RELEASE_BONUS5)->EnableWindow(false);
	}
	SetModified();
}
// end [sivka: -Release Priority-]

// added by sivka [sivka: -WaitingQueue Overflow-]
void CPPgSivkaSettings::OnLoadWQueueOverflow()
{
	if(!(IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW)
	|| IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_FR)
	|| IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_VS)
	|| IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_REL)))
	{
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW,0);
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_FR,0);
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_VS,0);
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_REL,0);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_FR)->EnableWindow(false);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_VS)->EnableWindow(false);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_REL)->EnableWindow(false);
	}
	else
	{
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW,1);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_FR)->EnableWindow(true);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_VS)->EnableWindow(true);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_REL)->EnableWindow(true);
	}
}

void CPPgSivkaSettings::OnBnClickedWQueueOverflow()
{
	if(IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW))
	{
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_FR)->EnableWindow(true);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_VS)->EnableWindow(true);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_REL)->EnableWindow(true);
	}
	else
	{
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_FR,0);
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_VS,0);
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_REL,0);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_FR)->EnableWindow(false);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_VS)->EnableWindow(false);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_REL)->EnableWindow(false);
	}
	SetModified();
}
void CPPgSivkaSettings::OnBnClickedWQueueOverflow_FR_VS_REL()
{
	if(!(IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_FR)
	|| IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_VS)
	|| IsDlgButtonChecked(IDC_WAITINGQUEUE_OVERFLOW_REL)))
	{
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW,0);
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_FR,0);
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_VS,0);
		CheckDlgButton(IDC_WAITINGQUEUE_OVERFLOW_REL,0);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_FR)->EnableWindow(false);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_VS)->EnableWindow(false);
		GetDlgItem(IDC_WAITINGQUEUE_OVERFLOW_REL)->EnableWindow(false);
	}
	SetModified();
}
// end [sivka: -WaitingQueue Overflow-]

// [sivka: -Sources Threshold-]
void CPPgSivkaSettings::OnLoadSourcesRequestThreshold()
{
	if(IsDlgButtonChecked(IDC_SRCREQTHRESHOLD)==0)
	{
		GetDlgItem(IDC_SRCREQTHRESHOLD1)->EnableWindow(false);
		GetDlgItem(IDC_SRCREQTHRESHOLD_LBL1)->EnableWindow(false);
		GetDlgItem(IDC_SRCREQTHRESHOLD2)->EnableWindow(false);
		GetDlgItem(IDC_SRCREQTHRESHOLD_LBL2)->EnableWindow(false);
	}
	else
	{
		GetDlgItem(IDC_SRCREQTHRESHOLD1)->EnableWindow(true);
		GetDlgItem(IDC_SRCREQTHRESHOLD_LBL1)->EnableWindow(true);
		GetDlgItem(IDC_SRCREQTHRESHOLD2)->EnableWindow(true);
		GetDlgItem(IDC_SRCREQTHRESHOLD_LBL2)->EnableWindow(true);
	}
}
void CPPgSivkaSettings::OnBnClickedSourcesRequestThreshold()
{
	OnLoadSourcesRequestThreshold();
	SetModified();
}
// end [sivka: -Sources Threshold-]

// added by sivka [sivka: -Upload Slots and Upload Datarate Per Client-]
void CPPgSivkaSettings::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified(TRUE);
	if( pScrollBar == (CScrollBar*)GetDlgItem(IDC_UP_SLOTS_SLIDER) )
		ShowUpDRUpSlotsValues();
	if( pScrollBar == (CScrollBar*)GetDlgItem(IDC_PUSHSMALLFILES_SLIDER) )
		ShowPushSmallFileValues();
	if( pScrollBar == (CScrollBar*)GetDlgItem(IDC_REASKFILESRC_SLIDER) )
		ShowReAskFileSRCValues();
	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

// added by sivka [sivka: -Upload Slots and Upload Datarate Per Client-]
void CPPgSivkaSettings::ShowUpDRUpSlotsValues()
{
	CString strBuffer;
	strBuffer.Format(_T("%u+1"), ((CSliderCtrl*)GetDlgItem(IDC_UP_SLOTS_SLIDER))->GetPos());
	GetDlgItem(IDC_UP_SLOTS)->SetWindowText(strBuffer);
	if(thePrefs.maxupload==UNLIMITED){
		if(thePrefs.maxGraphUploadRate==UNLIMITED)
			strBuffer=_T("UNLIMITED");
		else
			strBuffer.Format(_T("%s - %s"),CastItoXBytes((UINT)((thePrefs.maxGraphUploadRate*1024)/(((CSliderCtrl*)GetDlgItem(IDC_UP_SLOTS_SLIDER))->GetPos()+1))),CastItoXBytes((UINT)((thePrefs.maxGraphUploadRate*1024)/((CSliderCtrl*)GetDlgItem(IDC_UP_SLOTS_SLIDER))->GetPos())));
	}
	else
		strBuffer.Format(_T("%s - %s"),CastItoXBytes((UINT)((thePrefs.maxupload*1024)/(((CSliderCtrl*)GetDlgItem(IDC_UP_SLOTS_SLIDER))->GetPos()+1))),CastItoXBytes((UINT)((thePrefs.maxupload*1024)/((CSliderCtrl*)GetDlgItem(IDC_UP_SLOTS_SLIDER))->GetPos())));
	GetDlgItem(IDC_UP_DR_PER_CLIENT)->SetWindowText(strBuffer);
}

// added by sivka [sivka: -Push Small Files-]
void CPPgSivkaSettings::ShowPushSmallFileValues()
{
	GetDlgItem(IDC_PUSHSMALLFILES)->SetWindowText(CastItoXBytes((UINT)((CSliderCtrl*)GetDlgItem(IDC_PUSHSMALLFILES_SLIDER))->GetPos()));
}

// added by sivka [sivka: -Fill with Zeros-]
CString CPPgSivkaSettings::FillWithZeros(uint32 units)
{
	CString temp;
	if(units<10) temp.Format(_T("00%i"),units);
	else if(units<100) temp.Format(_T("0%i"),units);
	else temp.Format(_T("%i"),units);
	return temp;
}

// added by sivka [Timer for Reask File Sources]
void CPPgSivkaSettings::ShowReAskFileSRCValues()
{
	GetDlgItem(IDC_REASKFILESRC)->SetWindowText(CastSecondsToHM(((CSliderCtrl*)GetDlgItem(IDC_REASKFILESRC_SLIDER))->GetPos()));
}
