//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "emule.h"
#include "PPgSivkaFileDefaults.h"
#include "OtherFunctions.h" // for GetResString()
#include "Scheduler.h" //to save maxsourceperfile
#include "Preferences.h" // for thePrefs

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(CPPgSivkaFileDefaults, CPropertyPage)
CPPgSivkaFileDefaults::CPPgSivkaFileDefaults()
	: CPropertyPage(CPPgSivkaFileDefaults::IDD)
{
}

CPPgSivkaFileDefaults::~CPPgSivkaFileDefaults()
{
}

void CPPgSivkaFileDefaults::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgSivkaFileDefaults, CPropertyPage)
	ON_EN_CHANGE(IDC_HARDLIMIT, OnEnChangeModified)

	ON_BN_CLICKED(IDC_AHL_TIMERLABEL, OnBnClickedEnableAutoHL)
	ON_EN_CHANGE(IDC_AHL_TIMER, OnEnChangeModified)

	ON_BN_CLICKED(IDC_REMOVENNSLIMITLABEL, OnBnClickedEnableAutoNNS)
	ON_EN_CHANGE(IDC_NNS_TIMER, OnEnChangeModified)
	ON_EN_CHANGE(IDC_MAXREMOVENNSLIMIT, OnEnChangeModified)
	ON_BN_CLICKED(IDC_REMOVENNSSOUND, OnBnClickedModified)

	ON_BN_CLICKED(IDC_REMOVEFQSLIMITLABEL, OnBnClickedEnableAutoFQS)
	ON_EN_CHANGE(IDC_FQS_TIMER, OnEnChangeModified)
	ON_EN_CHANGE(IDC_MAXREMOVEFQSLIMIT, OnEnChangeModified)
	ON_BN_CLICKED(IDC_REMOVEFQSSOUND, OnBnClickedModified)

	ON_BN_CLICKED(IDC_REMOVEQRSLIMITLABEL, OnBnClickedEnableAutoQRS)
	ON_EN_CHANGE(IDC_HQRS_TIMER, OnEnChangeModified)
	ON_EN_CHANGE(IDC_REMOVEQRS, OnEnChangeModified)
	ON_EN_CHANGE(IDC_MAXREMOVEQRSLIMIT, OnEnChangeModified)
	ON_BN_CLICKED(IDC_REMOVEQRSSOUND, OnBnClickedModified)
	
	ON_EN_CHANGE(IDC_REASKSERVER4SRC, OnEnChangeModified)
	
	ON_BN_CLICKED(IDC_ENABLE_ZERO_FILLED_TEST, OnBnClickedModified)
END_MESSAGE_MAP()

BOOL CPPgSivkaFileDefaults::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgSivkaFileDefaults::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
		
		strBuffer.Format(_T("%d"), thePrefs.maxsourcesperfiledefault);
		GetDlgItem(IDC_HARDLIMIT)->SetWindowText(strBuffer);
		
		CheckDlgButton(IDC_AHL_TIMERLABEL, thePrefs.m_EnableAutoHLDefault);
		strBuffer.Format(_T("%d"), thePrefs.m_AutoHL_TimerDefault/1000);
		GetDlgItem(IDC_AHL_TIMER)->SetWindowText(strBuffer);
		OnLoadEnableAutoHL();

		CheckDlgButton(IDC_REMOVENNSLIMITLABEL, thePrefs.m_EnableAutoDropNNSDefault);
		strBuffer.Format(_T("%d"), thePrefs.m_AutoNNS_TimerDefault/1000);
		GetDlgItem(IDC_NNS_TIMER)->SetWindowText(strBuffer);
		strBuffer.Format(_T("%d"), thePrefs.m_MaxRemoveNNSLimitDefault);
		GetDlgItem(IDC_MAXREMOVENNSLIMIT)->SetWindowText(strBuffer);
		CheckDlgButton(IDC_REMOVENNSSOUND, thePrefs.m_NNSSoundDefault);
		OnLoadEnableAutoNNS();

		CheckDlgButton(IDC_REMOVEFQSLIMITLABEL, thePrefs.m_EnableAutoDropFQSDefault);
		strBuffer.Format(_T("%d"), thePrefs.m_AutoFQS_TimerDefault/1000);
		GetDlgItem(IDC_FQS_TIMER)->SetWindowText(strBuffer);
		strBuffer.Format(_T("%d"), thePrefs.m_MaxRemoveFQSLimitDefault);
		GetDlgItem(IDC_MAXREMOVEFQSLIMIT)->SetWindowText(strBuffer);
		CheckDlgButton(IDC_REMOVEFQSSOUND, thePrefs.m_FQSSoundDefault);
		OnLoadEnableAutoFQS();

		CheckDlgButton(IDC_REMOVEQRSLIMITLABEL, thePrefs.m_EnableAutoDropQRSDefault);
		strBuffer.Format(_T("%d"), thePrefs.m_AutoHQRS_TimerDefault/1000);
		GetDlgItem(IDC_HQRS_TIMER)->SetWindowText(strBuffer);
		strBuffer.Format(_T("%d"), thePrefs.m_MaxRemoveQRSDefault);
		GetDlgItem(IDC_REMOVEQRS)->SetWindowText(strBuffer);
		strBuffer.Format(_T("%d"), thePrefs.m_MaxRemoveQRSLimitDefault);
		GetDlgItem(IDC_MAXREMOVEQRSLIMIT)->SetWindowText(strBuffer);
		CheckDlgButton(IDC_REMOVEQRSSOUND, thePrefs.m_QRSSoundDefault);
		OnLoadEnableAutoQRS();

		strBuffer.Format(_T("%d"), thePrefs.m_ReaskServer4SRCDefault/60000);
		GetDlgItem(IDC_REASKSERVER4SRC)->SetWindowText(strBuffer);
		
		CheckDlgButton(IDC_ENABLE_ZERO_FILLED_TEST, thePrefs.m_EnableZeroFilledTestDefault);
		
	}
}

BOOL CPPgSivkaFileDefaults::OnApply()
{
	CString strBuffer;

	if(GetDlgItem(IDC_HARDLIMIT)->GetWindowTextLength())
	{
		GetDlgItem(IDC_HARDLIMIT)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 50 && _ttoi(strBuffer) <= 2000)
			thePrefs.maxsourcesperfiledefault = _ttoi(strBuffer);
	}

	thePrefs.m_EnableAutoHLDefault = IsDlgButtonChecked(IDC_AHL_TIMERLABEL)>0;
	if(GetDlgItem(IDC_AHL_TIMER)->GetWindowTextLength() && thePrefs.m_EnableAutoHLDefault)
	{
		GetDlgItem(IDC_AHL_TIMER)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 0 && _ttoi(strBuffer) <= 60)
			thePrefs.m_AutoHL_TimerDefault = _ttoi(strBuffer)*1000;
	}

	thePrefs.m_EnableAutoDropNNSDefault = IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL)>0;
	if(GetDlgItem(IDC_NNS_TIMER)->GetWindowTextLength() && thePrefs.m_EnableAutoDropNNSDefault)
	{
		GetDlgItem(IDC_NNS_TIMER)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 0 && _ttoi(strBuffer) <= 60)
			thePrefs.m_AutoNNS_TimerDefault = _ttoi(strBuffer)*1000;
	}
	if(GetDlgItem(IDC_MAXREMOVENNSLIMIT)->GetWindowTextLength() && thePrefs.m_EnableAutoDropNNSDefault)
	{
		GetDlgItem(IDC_MAXREMOVENNSLIMIT)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 50 && _ttoi(strBuffer) <= 100)
			thePrefs.m_MaxRemoveNNSLimitDefault = _ttoi(strBuffer);
	}

	thePrefs.m_EnableAutoDropFQSDefault = IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL)>0;
	if(GetDlgItem(IDC_FQS_TIMER)->GetWindowTextLength() && thePrefs.m_EnableAutoDropFQSDefault)
	{
		GetDlgItem(IDC_FQS_TIMER)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 0 && _ttoi(strBuffer) <= 60)
			thePrefs.m_AutoFQS_TimerDefault = _ttoi(strBuffer)*1000;
	}
	if(GetDlgItem(IDC_MAXREMOVEFQSLIMIT)->GetWindowTextLength() && thePrefs.m_EnableAutoDropFQSDefault)
	{
		GetDlgItem(IDC_MAXREMOVEFQSLIMIT)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 50 && _ttoi(strBuffer) <= 100)
			thePrefs.m_MaxRemoveFQSLimitDefault = _ttoi(strBuffer);
	}

	thePrefs.m_EnableAutoDropQRSDefault = IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL)>0;
	if(GetDlgItem(IDC_HQRS_TIMER)->GetWindowTextLength() && thePrefs.m_EnableAutoDropQRSDefault)
	{
		GetDlgItem(IDC_HQRS_TIMER)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 0 && _ttoi(strBuffer) <= 60)
			thePrefs.m_AutoHQRS_TimerDefault = _ttoi(strBuffer)*1000;
	}
	if(GetDlgItem(IDC_REMOVEQRS)->GetWindowTextLength() && thePrefs.m_EnableAutoDropQRSDefault)
	{
		GetDlgItem(IDC_REMOVEQRS)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 1000 && _ttoi(strBuffer) <= 10000)
			thePrefs.m_MaxRemoveQRSDefault = _ttoi(strBuffer);
	}
	if(GetDlgItem(IDC_MAXREMOVEQRSLIMIT)->GetWindowTextLength() && thePrefs.m_EnableAutoDropQRSDefault)
	{
		GetDlgItem(IDC_MAXREMOVEQRSLIMIT)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 50 && _ttoi(strBuffer) <= 100)
			thePrefs.m_MaxRemoveQRSLimitDefault = _ttoi(strBuffer);
	}

	thePrefs.m_NNSSoundDefault = IsDlgButtonChecked(IDC_REMOVENNSSOUND)>0;
	thePrefs.m_FQSSoundDefault = IsDlgButtonChecked(IDC_REMOVEFQSSOUND)>0;
	thePrefs.m_QRSSoundDefault = IsDlgButtonChecked(IDC_REMOVEQRSSOUND)>0;

	if(GetDlgItem(IDC_REASKSERVER4SRC)->GetWindowTextLength())
	{
		GetDlgItem(IDC_REASKSERVER4SRC)->GetWindowText(strBuffer);
		if (_ttoi(strBuffer) >= 15 && _ttoi(strBuffer) <= 60)
			thePrefs.m_ReaskServer4SRCDefault = _ttoi(strBuffer)*60000;
	}

	thePrefs.m_EnableZeroFilledTestDefault = IsDlgButtonChecked(IDC_ENABLE_ZERO_FILLED_TEST)>0;

	theApp.scheduler->SaveOriginals(); //to save maxsourceperfile
	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgSivkaFileDefaults::Localize(void)
{	
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PPG_SIVKAFILEDEFAULTS));
		GetDlgItem(IDC_HARDLIMIT_LABEL)->SetWindowText(GetResString(IDS_HARDLIMIT_LABEL));
		GetDlgItem(IDC_AHL_TIMERLABEL)->SetWindowText(GetResString(IDS_AHL_TIMERLABEL));
		GetDlgItem(IDC_NNS_TIMERLABEL)->SetWindowText(GetResString(IDS_NNS_TIMERLABEL));
		GetDlgItem(IDC_REMOVENNSLIMITLABEL)->SetWindowText(GetResString(IDS_REMOVENNSLIMITLABEL));
		GetDlgItem(IDC_FQS_TIMERLABEL)->SetWindowText(GetResString(IDS_FQS_TIMERLABEL));
		GetDlgItem(IDC_REMOVEFQSLIMITLABEL)->SetWindowText(GetResString(IDS_REMOVEFQSLIMITLABEL));
		GetDlgItem(IDC_HQRS_TIMERLABEL)->SetWindowText(GetResString(IDS_HQRS_TIMERLABEL));
		GetDlgItem(IDC_REMOVEQRSLABEL)->SetWindowText(GetResString(IDS_REMOVEQRSLABEL));
		GetDlgItem(IDC_REMOVEQRSLIMITLABEL)->SetWindowText(GetResString(IDS_REMOVEQRSLIMITLABEL));
		GetDlgItem(IDC_REMOVENNSSOUND)->SetWindowText(GetResString(IDS_REMOVENNSSOUND));
		GetDlgItem(IDC_REMOVEFQSSOUND)->SetWindowText(GetResString(IDS_REMOVEFQSSOUND));
		GetDlgItem(IDC_REMOVEQRSSOUND)->SetWindowText(GetResString(IDS_REMOVEQRSSOUND));
		GetDlgItem(IDC_REASKSERVER4SRCLABEL)->SetWindowText(GetResString(IDS_REASKSERVER4SRCLABEL));
		GetDlgItem(IDC_ENABLE_ZERO_FILLED_TEST)->SetWindowText(GetResString(IDS_ENABLE_ZERO_FILLED_TEST));
	}
}

void CPPgSivkaFileDefaults::OnBnClickedEnableAutoHL()
{
	GetDlgItem(IDC_AHL_TIMER)->EnableWindow(IsDlgButtonChecked(IDC_AHL_TIMERLABEL));
	SetModified();
}
void CPPgSivkaFileDefaults::OnLoadEnableAutoHL()
{
	GetDlgItem(IDC_AHL_TIMER)->EnableWindow(IsDlgButtonChecked(IDC_AHL_TIMERLABEL));
}

void CPPgSivkaFileDefaults::OnBnClickedEnableAutoNNS()
{
	GetDlgItem(IDC_NNS_TIMERLABEL)->EnableWindow(IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL));
	GetDlgItem(IDC_NNS_TIMER)->EnableWindow(IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL));
	GetDlgItem(IDC_MAXREMOVENNSLIMIT)->EnableWindow(IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL));
	GetDlgItem(IDC_REMOVENNSSOUND)->EnableWindow(IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL));
	SetModified();
}
void CPPgSivkaFileDefaults::OnLoadEnableAutoNNS()
{
	GetDlgItem(IDC_NNS_TIMERLABEL)->EnableWindow(IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL));
	GetDlgItem(IDC_NNS_TIMER)->EnableWindow(IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL));
	GetDlgItem(IDC_MAXREMOVENNSLIMIT)->EnableWindow(IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL));
	GetDlgItem(IDC_REMOVENNSSOUND)->EnableWindow(IsDlgButtonChecked(IDC_REMOVENNSLIMITLABEL));
}

void CPPgSivkaFileDefaults::OnBnClickedEnableAutoFQS()
{
	GetDlgItem(IDC_FQS_TIMERLABEL)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL));
	GetDlgItem(IDC_FQS_TIMER)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL));
	GetDlgItem(IDC_MAXREMOVEFQSLIMIT)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL));
	GetDlgItem(IDC_REMOVEFQSSOUND)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL));
	SetModified();
}
void CPPgSivkaFileDefaults::OnLoadEnableAutoFQS()
{
	GetDlgItem(IDC_FQS_TIMERLABEL)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL));
	GetDlgItem(IDC_FQS_TIMER)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL));
	GetDlgItem(IDC_MAXREMOVEFQSLIMIT)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL));
	GetDlgItem(IDC_REMOVEFQSSOUND)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEFQSLIMITLABEL));
}

void CPPgSivkaFileDefaults::OnBnClickedEnableAutoQRS()
{
	GetDlgItem(IDC_HQRS_TIMERLABEL)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_HQRS_TIMER)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_REMOVEQRSLABEL)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_REMOVEQRS)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_MAXREMOVEQRSLIMIT)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_REMOVEQRSSOUND)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	SetModified();
}
void CPPgSivkaFileDefaults::OnLoadEnableAutoQRS()
{
	GetDlgItem(IDC_HQRS_TIMERLABEL)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_HQRS_TIMER)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_REMOVEQRSLABEL)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_REMOVEQRS)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_MAXREMOVEQRSLIMIT)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
	GetDlgItem(IDC_REMOVEQRSSOUND)->EnableWindow(IsDlgButtonChecked(IDC_REMOVEQRSLIMITLABEL));
}
