// moosetea: LanCast

#pragma once
//#include "Loggable.h"

class CKnownFile;
class Packet;

class CLanCast : public CAsyncSocket//, public CLoggable
{
public:
	CLanCast();
	~CLanCast();

	virtual void OnReceive(int nErrorCode);
	bool SendPacket(Packet* packet);

	void Start();
	void Stop();

	bool IsLanIP(UINT dwUserIP);

private:

	void BroadcastHash(CKnownFile* cur_file);
	void ReceiveHash(char* pachPacket, UINT nSize);

	BOOL JoinGroup(CString, UINT, UINT, BOOL);
	BOOL LeaveGroup();

	void SetLoopBack(BOOL);
	BOOL CreateSendingSocket(UINT, BOOL);
	BOOL CreateReceivingSocket(LPCTSTR, UINT);

	void static CALLBACK UDPTimerProc(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime);
	bool ProcessPacket(char* packet, UINT size, uint8 opcode);
		//(char* packet, int16 size, int8 opcode, char* host, uint16 port);

private:

	struct multicast_interface {
		UINT address;
		UINT subnet;
	};

	CList<multicast_interface> interface_list;
	addrinfo *m_aiList;
	SOCKADDR_IN m_saHostGroup;	// SOCKADDR structure to hold IP/Port of the Host group to send data to it

	CAsyncSocket m_SendSocket;	// Socket for sending data to the host group

	bool bStarted;
	UINT udp_timer;												// Timer to fire packet sends
};

