#include "stdafx.h"
#include "emule.h"
#include "TransferDlg.h"
#include "emuledlg.h"
#include "PPgSaint.h"
#include "resource.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "UserMsgs.h"
#include "opcodes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CPPgSaint dialog

IMPLEMENT_DYNAMIC(CPPgSaint, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgSaint, CPropertyPage)
	ON_BN_CLICKED(IDC_DONTSHAREXT_LBL, OnSettingsChangeExt)// X: [DSE] - [DontShareExt]
	ON_EN_CHANGE(IDC_DONTSHAREXT, OnSettingsChange)// X: [DSE] - [DontShareExt]
	ON_BN_CLICKED(IDC_SHOWRUNTIMEONTITLE, OnSettingsChange) //angvil Show runtime on title
	ON_BN_CLICKED(IDC_SHOWCPU, OnSettingsChange) // show cpu/ram useage
	// X-Ray :: ReleaseBonus :: Start
	ON_BN_CLICKED(IDC_SA_RELEASE_CHK, OnBnClickedReleaseBonus)
	ON_BN_CLICKED(IDC_SA_RELEASE_6H, OnSettingsChange)
	ON_BN_CLICKED(IDC_SA_RELEASE_12H, OnSettingsChange)
	ON_BN_CLICKED(IDC_SA_RELEASE_1D, OnSettingsChange)
	ON_BN_CLICKED(IDC_SA_RELEASE_2D, OnSettingsChange)
	ON_BN_CLICKED(IDC_SA_RELEASE_4D, OnSettingsChange)
	ON_BN_CLICKED(IDC_SA_RELEASE_8D, OnSettingsChange)
	// X-Ray :: ReleaseBonus :: End
END_MESSAGE_MAP()

CPPgSaint::CPPgSaint()
	: CPropertyPage(CPPgSaint::IDD)
{
}

CPPgSaint::~CPPgSaint()
{
}

void CPPgSaint::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	
}

void CPPgSaint::LoadSettings(void)
{
	CheckDlgButton(IDC_DONTSHAREXT_LBL,thePrefs.dontsharext);// X: [DSE] - [DontShareExt]
	GetDlgItem(IDC_DONTSHAREXT)->EnableWindow(thePrefs.dontsharext);
	SetDlgItemText(IDC_DONTSHAREXT,thePrefs.shareExt);
	//angvil Show runtime on title
	if(thePrefs.m_bShowRuntimeOnTitle)
		CheckDlgButton(IDC_SHOWRUNTIMEONTITLE,1);
	else
		CheckDlgButton(IDC_SHOWRUNTIMEONTITLE,0);
	// ==> CPU/MEM usage [$ick$/Stulle] - angvil
	if(thePrefs.m_bSysInfo)
		CheckDlgButton(IDC_SHOWCPU,1);
	else
		CheckDlgButton(IDC_SHOWCPU,0);
	// <== CPU/MEM usage [$ick$/Stulle] - angvil
	// X-Ray :: ReleaseBonus :: Start
	const bool bRelBonus = thePrefs.GetUseReleaseBonus() && thePrefs.SaveUploadQueueWaitTime();
	switch(thePrefs.GetReleaseBonus()){
		case 1:
			CheckDlgButton(IDC_SA_RELEASE_CHK, bRelBonus);
			CheckDlgButton(IDC_SA_RELEASE_6H, bRelBonus);
			break;
		case 2:
			CheckDlgButton(IDC_SA_RELEASE_CHK, bRelBonus);
			CheckDlgButton(IDC_SA_RELEASE_12H, bRelBonus);
			break;
		case 4:
			CheckDlgButton(IDC_SA_RELEASE_CHK, bRelBonus);
			CheckDlgButton(IDC_SA_RELEASE_1D, bRelBonus);
			break;
		case 8:
			CheckDlgButton(IDC_SA_RELEASE_CHK, bRelBonus);
			CheckDlgButton(IDC_SA_RELEASE_2D, bRelBonus);
			break;
		case 16:
			CheckDlgButton(IDC_SA_RELEASE_CHK, bRelBonus);
			CheckDlgButton(IDC_SA_RELEASE_4D, bRelBonus);
			break;
		case 32:
			CheckDlgButton(IDC_SA_RELEASE_CHK, bRelBonus);
			CheckDlgButton(IDC_SA_RELEASE_8D, bRelBonus);
			break;
		case 0:
		default:
			CheckDlgButton(IDC_SA_RELEASE_CHK, false);
			CheckDlgButton(IDC_SA_RELEASE_6H, false);
			CheckDlgButton(IDC_SA_RELEASE_12H, false);
			CheckDlgButton(IDC_SA_RELEASE_1D, false);
			CheckDlgButton(IDC_SA_RELEASE_2D, false);
			CheckDlgButton(IDC_SA_RELEASE_4D, false);
			CheckDlgButton(IDC_SA_RELEASE_8D, false);
			break;
	}

	GetDlgItem(IDC_SA_RELEASE_6H)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_SA_RELEASE_12H)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_SA_RELEASE_1D)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_SA_RELEASE_2D)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_SA_RELEASE_4D)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_SA_RELEASE_8D)->EnableWindow(bRelBonus);
	// X-Ray :: ReleaseBonus :: End


}


BOOL CPPgSaint::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	Localize();
	LoadSettings();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


BOOL CPPgSaint::OnApply()
{
	thePrefs.dontsharext=IsDlgButtonChecked(IDC_DONTSHAREXT_LBL)!=0;// X: [DSE] - [DontShareExt]
	if(thePrefs.dontsharext){
		GetDlgItemText(IDC_DONTSHAREXT,thePrefs.shareExt);
		thePrefs.shareExt.MakeLower();
		SetDlgItemText(IDC_DONTSHAREXT,thePrefs.shareExt);
	}
	
	//angvil Show runtime on title
	if (IsDlgButtonChecked(IDC_SHOWRUNTIMEONTITLE))
		thePrefs.m_bShowRuntimeOnTitle = true;
	else
		thePrefs.m_bShowRuntimeOnTitle = false;
	// ==> CPU/MEM usage [$ick$/Stulle] - Stulle
	if (IsDlgButtonChecked(IDC_SHOWCPU))
		thePrefs.m_bSysInfo = true;
	else
		thePrefs.m_bSysInfo = false;
	// <== CPU/MEM usage [$ick$/Stulle] - Stulle
	// X-Ray :: ReleaseBonus :: Start
	if(IsDlgButtonChecked(IDC_SA_RELEASE_CHK)){
		thePrefs.SetUseReleaseBonus(true);
		if(IsDlgButtonChecked(IDC_SA_RELEASE_8D))
			thePrefs.SetReleaseBonus(32);
		else if(IsDlgButtonChecked(IDC_SA_RELEASE_4D))
			thePrefs.SetReleaseBonus(16);
		else if(IsDlgButtonChecked(IDC_SA_RELEASE_2D))
			thePrefs.SetReleaseBonus(8);
		else if(IsDlgButtonChecked(IDC_SA_RELEASE_1D))
			thePrefs.SetReleaseBonus(4);
		else if(IsDlgButtonChecked(IDC_SA_RELEASE_12H))
			thePrefs.SetReleaseBonus(2);
		else if(IsDlgButtonChecked(IDC_SA_RELEASE_6H))
			thePrefs.SetReleaseBonus(1);
		else
			thePrefs.SetReleaseBonus(0);
	} else {
		thePrefs.SetUseReleaseBonus(false);
		thePrefs.SetReleaseBonus(0);
	}
	// X-Ray :: ReleaseBonus :: End
	SetModified(FALSE);
	LoadSettings();
	return CPropertyPage::OnApply();
}
/*BOOL CPPgSaint::OnKillActive()
{
	// if prop page is closed by pressing VK_ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	return CPropertyPage::OnKillActive();
}*/
void CPPgSaint::Localize(void)
{
	if(m_hWnd)
	{
		SetDlgItemText(IDC_DONTSHAREXT_LBL,GetResString(IDS_DONTSHAREXT));// X: [DSE] - [DontShareExt]
		GetDlgItem(IDC_SHOWRUNTIMEONTITLE)->SetWindowText(GetResString(IDS_SHOWRUNTIMEONTITLE));
		GetDlgItem(IDC_SA_1)->SetWindowText(GetResString(IDS_SA_1));
		GetDlgItem(IDC_SA_2)->SetWindowText(GetResString(IDS_SA_2));
		GetDlgItem(IDC_SHOWCPU)->SetWindowText(GetResString(IDS_SHOWCPU));
		// X-Ray :: ReleaseBonus :: Start
		GetDlgItem(IDC_SA_RELEASE_G)->SetWindowText(GetResString(IDS_SA_RELEASE_G));
		GetDlgItem(IDC_SA_RELEASE_CHK)->SetWindowText(GetResString(IDS_SA_RELEASE_CHK));
		GetDlgItem(IDC_SA_RELEASE_6H)->SetWindowText(GetResString(IDS_SA_RELEASE_6H));
		GetDlgItem(IDC_SA_RELEASE_12H)->SetWindowText(GetResString(IDS_SA_RELEASE_12H));
		GetDlgItem(IDC_SA_RELEASE_1D)->SetWindowText(GetResString(IDS_SA_RELEASE_1D));
		GetDlgItem(IDC_SA_RELEASE_2D)->SetWindowText(GetResString(IDS_SA_RELEASE_2D));
		GetDlgItem(IDC_SA_RELEASE_4D)->SetWindowText(GetResString(IDS_SA_RELEASE_4D));
		GetDlgItem(IDC_SA_RELEASE_8D)->SetWindowText(GetResString(IDS_SA_RELEASE_8D));
		// X-Ray :: ReleaseBonus :: End
	}
}

/*void CPPgSaint::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified(TRUE);

	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);

}*/
BOOL CPPgSaint::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

// => X: [DSE] - [DontShareExt]
void CPPgSaint::OnSettingsChangeExt()
{

	GetDlgItem(IDC_DONTSHAREXT)->EnableWindow(IsDlgButtonChecked(IDC_DONTSHAREXT_LBL));
	OnSettingsChange();
}
// <= X: [DSE] - [DontShareExt]

void CPPgSaint::OnBnClickedReleaseBonus()
{
	if(IsDlgButtonChecked(IDC_SA_RELEASE_CHK)) {
		GetDlgItem(IDC_SA_RELEASE_6H)->EnableWindow(true);
		GetDlgItem(IDC_SA_RELEASE_12H)->EnableWindow(true);
		GetDlgItem(IDC_SA_RELEASE_1D)->EnableWindow(true);
		GetDlgItem(IDC_SA_RELEASE_2D)->EnableWindow(true);
		GetDlgItem(IDC_SA_RELEASE_4D)->EnableWindow(true);
		GetDlgItem(IDC_SA_RELEASE_8D)->EnableWindow(true);
		CheckDlgButton(IDC_SA_RELEASE_6H, true);
	} else {
		CheckDlgButton(IDC_SA_RELEASE_6H, false);
		CheckDlgButton(IDC_SA_RELEASE_12H, false);
		CheckDlgButton(IDC_SA_RELEASE_1D, false);
		CheckDlgButton(IDC_SA_RELEASE_2D, false);
		CheckDlgButton(IDC_SA_RELEASE_4D, false);
		CheckDlgButton(IDC_SA_RELEASE_8D, false);
		GetDlgItem(IDC_SA_RELEASE_6H)->EnableWindow(false);
		GetDlgItem(IDC_SA_RELEASE_12H)->EnableWindow(false);
		GetDlgItem(IDC_SA_RELEASE_1D)->EnableWindow(false);
		GetDlgItem(IDC_SA_RELEASE_2D)->EnableWindow(false);
		GetDlgItem(IDC_SA_RELEASE_4D)->EnableWindow(false);
		GetDlgItem(IDC_SA_RELEASE_8D)->EnableWindow(false);
	}
	SetModified();
}
// X-Ray :: ReleaseBonus :: End
