// SharedFileInfoDlg.cpp : implementation file
//


#include "stdafx.h"
#include "emule.h"
#include "KnownFile.h"
#include "SharedFileInfoDlg.h"
#include "emuledlg.h"
#include "OtherFunctions.h"
#include "UserMsgs.h"

// <CB Mod : SharedFileInfo>
#ifdef CB_MOD_TRACEUPLOADS_ENABLED

// CSharedFileInfoDlg dialog

IMPLEMENT_DYNAMIC(CSharedFileInfoDlg, CResizablePage)
CSharedFileInfoDlg::CSharedFileInfoDlg()
	: CResizablePage(CSharedFileInfoDlg::IDD)
{
	//m_psp.pszTitle = GetResString(IDS_);;
	//m_psp.dwFlags |= PSP_USETITLE;
	m_paFiles = NULL;
}

CSharedFileInfoDlg::~CSharedFileInfoDlg()
{	
	m_timer = 0;
}

void CSharedFileInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
#ifdef CB_MOD_TRACEUPLOADS_ENABLED
	DDX_Control(pDX, IDC_CLIENTLIST, m_ClientUploadedListCtrl);
#endif
}


BEGIN_MESSAGE_MAP(CSharedFileInfoDlg, CResizablePage)
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()


// CSharedFileInfoDlg message handlers
BOOL CSharedFileInfoDlg::OnInitDialog()
{ 
	CResizablePage::OnInitDialog(); 
	InitWindowStyles(this);

	AddAnchor(IDC_CLIENTLIST,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_STATS_TEXT,BOTTOM_LEFT,BOTTOM_RIGHT);
	
#ifdef CB_MOD_TRACEUPLOADS_ENABLED
	m_ClientUploadedListCtrl.Init();
#endif

	Localize(); 

	// start time for calling 'RefreshData'
	VERIFY( (m_timer = SetTimer(301, 5000, 0)) != NULL );

	return TRUE; 
} 

void CSharedFileInfoDlg::Localize(void)
{ 
	
} 

LRESULT CSharedFileInfoDlg::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}

BOOL CSharedFileInfoDlg::OnSetActive()
{
	if (!CResizablePage::OnSetActive())
		return FALSE;
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
	return TRUE;
}

void CSharedFileInfoDlg::RefreshData() {


	CString s;
	uint64 sum = 0;
	
	m_ClientUploadedListCtrl.DeleteAllItems();
	for (int i=0; i<m_paFiles->GetSize(); i++) {
		CKnownFile* file = STATIC_DOWNCAST(CKnownFile, (*m_paFiles)[i]);	
		for (POSITION pos = file->m_UploadedClientList.GetHeadPosition(); pos != NULL; )
		{ 
			CUploadedClient *client = file->m_UploadedClientList.GetNext(pos);
			m_ClientUploadedListCtrl.AddClient(client);
		}
		sum += file->statistic.GetTransferred();
	}
	
	s.Format(_T("Uploaded during this session %s"), CastItoXBytes(sum, false, false));
	GetDlgItem(IDC_STATS_TEXT)->SetWindowText(s);

}

void CSharedFileInfoDlg::OnTimer(UINT /*nIDEvent*/)
{
	RefreshData();
}

#endif
// </CB Mod : SharedFileInfo>
