// UploadedClient.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "UploadedClient.h"
#include "ClientCredits.h"


// CUploadedClient

CUploadedClient::CUploadedClient(CUpDownClient *upclient, const CKnownFile *file)
{
	m_file = file;
	m_Name = upclient->GetUserName();
	m_SoftVersion = upclient->GetClientSoftVer();
	m_ModString = upclient->GetClientModVer();
	m_Rating = (float)upclient->GetScore(false,upclient->IsDownloading(),true);
	m_StartTime = ::GetTickCount();
	m_Duration = upclient->GetUpStartTimeDelay();
	m_Uploaded = upclient->GetQueueSessionUp();
	m_TotalUploaded = upclient->GetTransferredUp();
	m_TotalDownloaded = upclient->GetTransferredDown();

#ifdef CB_MOD_RRR_ENABLED
	if (upclient->Credits()) {
		m_WaitedTime = upclient->Credits()->GetSUQWT(upclient->GetIP())/1000;
		m_RRR = upclient->Credits()->GetRRR();
	}
#endif
}

CUploadedClient::~CUploadedClient()
{
}

#ifdef CB_MOD_RRR_ENABLED
CString CUploadedClient::GetRRRString() const {
	// m_RRR is a snapshot of the conditions when the client was served.
	// We cannot have a pointer to the client credit structure in order to get RRR info, as these may be outdated
	// So this is a clone of ClientCredits function
	CString s;

	s.Empty();
	if (m_RRR & (1<<RRR_VERSION))
		s.Append(_T("[V]"));
	if (m_RRR & (1<<RRR_GPL))
		s.Append(_T("[G]"));
	if (m_RRR & (1<<RRR_ILLEGAL))
		s.Append(_T("[I]"));
	if (m_RRR & (1<<RRR_FW))
		s.Append(_T("[F]"));
	if (m_RRR & (1<<RRR_SUI))
		s.Append(_T("[S]"));
	if (m_RRR & (1<<RRR_RATIO))
		s.Append(_T("[R]"));

	return s;
}
#endif

// CUploadedClient member functions
