//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "QueueListCtrl.h"
#include "OtherFunctions.h"
#include "MenuCmds.h"
#include "ClientDetailDialog.h"
#include "Exceptions.h"
#include "KademliaWnd.h"
#include "emuledlg.h"
#include "FriendList.h"
#include "UploadQueue.h"
#include "UpDownClient.h"
#include "TransferWnd.h"
#include "MemDC.h"
#include "SharedFileList.h"
#include "ClientCredits.h"
#include "PartFile.h"
#include "ChatWnd.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/Kademlia/Prefs.h"
#include "kademlia/net/KademliaUDPListener.h"
#include "Log.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CQueueListCtrl, CMuleListCtrl)

BEGIN_MESSAGE_MAP(CQueueListCtrl, CMuleListCtrl)
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOLORCHANGE()
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclk)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetDispInfo)
END_MESSAGE_MAP()

CQueueListCtrl::CQueueListCtrl()
	: CListCtrlItemWalk(this)
{
	SetGeneralPurposeFind(true, false);

	// Barry - Refresh the queue every 10 secs
	VERIFY( (m_hTimer = ::SetTimer(NULL, NULL, 10000, QueueUpdateTimer)) != NULL );
	if (thePrefs.GetVerbose() && !m_hTimer)
		AddDebugLogLine(true,_T("Failed to create 'queue list control' timer - %s"),GetErrorMessage(GetLastError()));
}

void CQueueListCtrl::Init()
{
	SetName(_T("QueueListCtrl"));

	CImageList ilDummyImageList; //dummy list for getting the proper height of listview entries
	ilDummyImageList.Create(1, theApp.GetSmallSytemIconSize().cy,theApp.m_iDfltImageListColorFlags|ILC_MASK, 1, 1); 
	SetImageList(&ilDummyImageList, LVSIL_SMALL);
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	ilDummyImageList.Detach();

	SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);

	InsertColumn(0,GetResString(IDS_QL_USERNAME),LVCFMT_LEFT,150,0);
	InsertColumn(1,GetResString(IDS_FILE),LVCFMT_LEFT,275,1);
	InsertColumn(2,GetResString(IDS_FILEPRIO),LVCFMT_LEFT,110,2);
	InsertColumn(3,GetResString(IDS_QL_RATING),LVCFMT_LEFT,60,3);
	InsertColumn(4,GetResString(IDS_SCORE),LVCFMT_LEFT,60,4);
	InsertColumn(5,GetResString(IDS_ASKED),LVCFMT_LEFT,60,5);
	InsertColumn(6,GetResString(IDS_LASTSEEN),LVCFMT_LEFT,110,6);
	InsertColumn(7,GetResString(IDS_ENTERQUEUE),LVCFMT_LEFT,110,7);
	InsertColumn(8,GetResString(IDS_BANNED),LVCFMT_LEFT,60,8);
	InsertColumn(9,GetResString(IDS_UPSTATUS),LVCFMT_LEFT,100,9);
	InsertColumn(10,GetResString(IDS_SOFTWARE_LABEL),LVCFMT_LEFT,100,10);
	InsertColumn(11,GetResString(IDS_MODVERSION_LABEL),LVCFMT_LEFT,100,11);

	// <CB Mod : QueueListInfo>
#ifdef CB_MOD_EXTRAINFO_ENABLED
	InsertColumn(12,GetResString(IDS_DL_SIZE),LVCFMT_LEFT,100,12);
	InsertColumn(13,GetResString(IDS_IPNUMBER),LVCFMT_LEFT,100,13);
	InsertColumn(14,GetResString(IDS_RANK),LVCFMT_LEFT,60,14);
#endif
	// </CB Mod : QueueListInfo

	SetAllIcons();
	Localize();
	LoadSettings();
	// Barry - Use preferred sort order from preferences
	SetSortArrow();
	SortItems(SortProc, GetSortItem() + (GetSortAscending() ? 0:100));
}

CQueueListCtrl::~CQueueListCtrl()
{
	if (m_hTimer)
		VERIFY( ::KillTimer(NULL, m_hTimer) );
}

void CQueueListCtrl::OnSysColorChange()
{
	CMuleListCtrl::OnSysColorChange();
	SetAllIcons();
}

void CQueueListCtrl::SetAllIcons()
{
	imagelist.DeleteImageList();
	imagelist.Create(16,16,theApp.m_iDfltImageListColorFlags|ILC_MASK,0,1);
	imagelist.SetBkColor(CLR_NONE);
	imagelist.Add(CTempIconLoader(_T("ClientEDonkey")));
	imagelist.Add(CTempIconLoader(_T("ClientCompatible")));
	imagelist.Add(CTempIconLoader(_T("ClientEDonkeyPlus")));
	imagelist.Add(CTempIconLoader(_T("ClientCompatiblePlus")));
	imagelist.Add(CTempIconLoader(_T("Friend")));
	imagelist.Add(CTempIconLoader(_T("ClientMLDonkey")));
	imagelist.Add(CTempIconLoader(_T("ClientMLDonkeyPlus")));
	imagelist.Add(CTempIconLoader(_T("ClientEDonkeyHybrid")));
	imagelist.Add(CTempIconLoader(_T("ClientEDonkeyHybridPlus")));
	imagelist.Add(CTempIconLoader(_T("ClientShareaza")));
	imagelist.Add(CTempIconLoader(_T("ClientShareazaPlus")));
	imagelist.Add(CTempIconLoader(_T("ClientAMule")));
	imagelist.Add(CTempIconLoader(_T("ClientAMulePlus")));
	imagelist.Add(CTempIconLoader(_T("ClientLPhant")));
	imagelist.Add(CTempIconLoader(_T("ClientLPhantPlus")));
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("ClientSecureOvl"))), 1);
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("OverlayObfu"))), 2);
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("OverlaySecureObfu"))), 3);
}

void CQueueListCtrl::Localize()
{
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;

	if(pHeaderCtrl->GetItemCount() != 0) {
		CString strRes;

		strRes = GetResString(IDS_QL_USERNAME);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(0, &hdi);

		strRes = GetResString(IDS_FILE);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(1, &hdi);

		strRes = GetResString(IDS_FILEPRIO);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(2, &hdi);

		strRes = GetResString(IDS_QL_RATING);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(3, &hdi);

		strRes = GetResString(IDS_SCORE);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(4, &hdi);

		strRes = GetResString(IDS_ASKED);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(5, &hdi);

		strRes = GetResString(IDS_LASTSEEN);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(6, &hdi);

		strRes = GetResString(IDS_ENTERQUEUE);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(7, &hdi);

		strRes = GetResString(IDS_BANNED);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(8, &hdi);
		
		strRes = GetResString(IDS_UPSTATUS);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(9, &hdi);
		
		strRes = GetResString(IDS_SOFTWARE_LABEL);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(10, &hdi);
		
		strRes = GetResString(IDS_MODVERSION_LABEL);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(11, &hdi);

		// <CB Mod : QueueListInfo>
#ifdef CB_MOD_EXTRAINFO_ENABLED
		strRes = GetResString(IDS_DL_SIZE);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(12, &hdi);

		strRes = GetResString(IDS_IPNUMBER);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(13, &hdi);
		
		strRes = GetResString(IDS_RANK);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(14, &hdi);
#endif
		// </CB Mod : QueueListInfo
		}
}

void CQueueListCtrl::AddClient(/*const*/ CUpDownClient* client, bool resetclient)
{
	if (resetclient && client){
		client->SetWaitStartTime();
		client->SetAskedCount(1);
    } else if( client ) {
        // Clients that have been put back "first" on queue (that is, they
        // get to keep its waiting time since before they started upload), are
        // recognized by having an ask count of 0.
        client->SetAskedCount(0);
	}

	if (!theApp.emuledlg->IsRunning())
		return;
	if (thePrefs.IsQueueListDisabled())
		return;

	int iItemCount = GetItemCount();
	
	// <CB Mod : QueueListInfo : QR>
#ifdef CB_MOD_EXTRAINFO_ENABLED
	client->m_QR = iItemCount + 1;
#endif
	// </CB Mod : QueueListInfo : QR>

	int iItem = InsertItem(LVIF_TEXT|LVIF_PARAM,iItemCount,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)client);
	Update(iItem);
	theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2OnQueue, iItemCount+1);
}

void CQueueListCtrl::RemoveClient(const CUpDownClient* client)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	int result = FindItem(&find);
	if (result != -1) {
		DeleteItem(result);
		theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2OnQueue);
	}
}

void CQueueListCtrl::RefreshClient(const CUpDownClient* client)
{
	// There is some type of timing issue here.. If you click on item in the queue or upload and leave
	// the focus on it when you exit the cient, it breaks on line 854 of emuleDlg.cpp.. 
	// I added this IsRunning() check to this function and the DrawItem method and
	// this seems to keep it from crashing. This is not the fix but a patch until
	// someone points out what is going wrong.. Also, it will still assert in debug mode..
	if (!theApp.emuledlg->IsRunning())
		return;

	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	int result = FindItem(&find);
	if (result != -1)
		Update(result);
}

#define DLC_DT_TEXT (DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS)

void CQueueListCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if (!theApp.emuledlg->IsRunning())
		return;
	if (!lpDrawItemStruct->itemData)
		return;
	
	// <CB Mod : Optimization : by SiroB>
#ifdef CB_MOD_OPTIMIZATIONS_ENABLED
	RECT clientRect;
	GetClientRect(&clientRect);
	CRect cur_rec = lpDrawItemStruct->rcItem;
	if (cur_rec.top >= clientRect.bottom || cur_rec.bottom <= clientRect.top)
		return;
#endif
	// </CB Mod : Optimization : by SiroB>
	
	// <CB Mod : ClientQueue : colors>
#ifndef CB_MOD_ENHANCEDINTERFACE_ENABLED
	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this) || (GetStyle() & LVS_SHOWSELALWAYS));
	if (lpDrawItemStruct->itemState & ODS_SELECTED) {
		if (bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());
	const CUpDownClient* client = (CUpDownClient*)lpDrawItemStruct->itemData;
#else
	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this) || (GetStyle() & LVS_SHOWSELALWAYS));
	COLORREF lineBackColor = m_crWindow;
	const CUpDownClient* client = (CUpDownClient*)lpDrawItemStruct->itemData;
	CKnownFile* file = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());

	if (!file)
		return; //add some crashing when updating but file was removed

	if (lpDrawItemStruct->itemState & ODS_SELECTED) {
		if(bCtrlFocused) { // If the window is focused darker colours are chosen
			if (file->GetPowerShared())
				lineBackColor = POWERSHARED_BACK_SELECTED;
#ifdef CB_MOD_NEWPRIORITIES_ENABLED
			else if (file->IsSuperRelease())
				lineBackColor = SUPERRELEASE_BACK_SELECTED;
#endif
#ifdef CB_MOD_SFP_ENABLED
			else if (thePrefs.SmallFilePush() && file->IsSFP())
				lineBackColor = SMALLPUSHED_BACK_SELECTED;
#endif
			else
				lineBackColor = m_crHighlight;
		} else { // Window not on focus, slightly lighter colours
			if (file->GetPowerShared()) 
				lineBackColor = POWERSHARED_BACK_SELECTED_UF;
#ifdef CB_MOD_NEWPRIORITIES_ENABLED
			else if (file->IsSuperRelease())
				lineBackColor = SUPERRELEASE_BACK_SELECTED_UF;
#endif
#ifdef CB_MOD_SFP_ENABLED
			else if (thePrefs.SmallFilePush() && file->IsSmallFile())
				lineBackColor = SMALLPUSHED_BACK_SELECTED_UF;
#endif
			else
				lineBackColor = m_crNoHighlight;
		}
	} else {
		if (file->GetPowerShared())
			lineBackColor = POWERSHARED_BACK_NORMAL;
#ifdef CB_MOD_NEWPRIORITIES_ENABLED
		else if (file->IsSuperRelease())
			lineBackColor = SUPERRELEASE_BACK_NORMAL;
#endif
#ifdef CB_MOD_SFP_ENABLED
		else if (thePrefs.SmallFilePush() && file->IsSFP())
			lineBackColor = SMALLPUSHED_BACK_NORMAL;
#endif
		else
			lineBackColor = m_crWindowTextBk;
	}
	odc->SetBkColor(lineBackColor);
#endif
	// </CB Mod : ClientQueue : colors>
	
	// <CB Mod : Optimization : by Xman>
#ifdef CB_MOD_OPTIMIZATIONS_ENABLED
	COLORREF crOldBackColor = odc->GetBkColor();
#endif
	// </CB Mod : Optimization : by Xman>
	CMemDC dc(odc, &lpDrawItemStruct->rcItem);
	CFont* pOldFont = dc.SelectObject(GetFont());
	// <CB Mod : Optimization : by SiroB>
#ifndef CB_MOD_OPTIMIZATIONS_ENABLED
	CRect cur_rec(lpDrawItemStruct->rcItem);
#endif
	// </CB Mod : Optimization : by SiroB>
	COLORREF crOldTextColor = dc.SetTextColor((lpDrawItemStruct->itemState & ODS_SELECTED) ? m_crHighlightText : m_crWindowText);

	int iOldBkMode;
	if (m_crWindowTextBk == CLR_NONE){
		DefWindowProc(WM_ERASEBKGND, (WPARAM)(HDC)dc, 0);
		iOldBkMode = dc.SetBkMode(TRANSPARENT);
	}
	else
		iOldBkMode = OPAQUE;

	// <CB Mod : ClientQueue : colors>
#ifndef CB_MOD_ENHANCEDINTERFACE_ENABLED
	CKnownFile* file = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());
#endif
	// </CB Mod : ClientQueue : colors>

	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	cur_rec.right = cur_rec.left - 8;
	cur_rec.left += 4;
	CString buffer;

	// <CB Mod : CreditSystem>
	float clientrating = 0;
	// </CB Mod : CreditSystem>

	for(int iCurrent = 0; iCurrent < iCount; iCurrent++){
		int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
		if( !IsColumnHidden(iColumn) ){
			cur_rec.right += GetColumnWidth(iColumn);
			switch(iColumn){
				case 0:{
					uint8 image;

					// <CB Mod : CreditSystem>
#ifdef CB_MOD_FINECS_ENABLED
					clientrating = client->credits->GetScoreRatio(client->GetIP(), client);
#else
					clientrating = client->credits->GetScoreRatio(client->GetIP());
#endif
					// </CB Mod : CreditSystem>

					if (client->IsFriend())
						image = 4;
					else if (client->GetClientSoft() == SO_EDONKEYHYBRID){
						// <CB Mod : CreditSystem>
						if ( clientrating > 1)
						// </CB Mod : CreditSystem>
							image = 8;
						else
							image = 7;
					}
					else if (client->GetClientSoft() == SO_MLDONKEY){
						// <CB Mod : CreditSystem>
						if ( clientrating > 1)
						// </CB Mod : CreditSystem>
							image = 6;
						else
							image = 5;
					}
					else if (client->GetClientSoft() == SO_SHAREAZA){
						// <CB Mod : CreditSystem>
						if ( clientrating > 1)
						// </CB Mod : CreditSystem>
							image = 10;
						else
							image = 9;
					}
					else if (client->GetClientSoft() == SO_AMULE){
						// <CB Mod : CreditSystem>
						if ( clientrating > 1)
						// </CB Mod : CreditSystem>
							image = 12;
						else
							image = 11;
					}
					else if (client->GetClientSoft() == SO_LPHANT){
						// <CB Mod : CreditSystem>
						if ( clientrating > 1)
						// </CB Mod : CreditSystem>
							image = 14;
						else
							image = 13;
					}
					else if (client->ExtProtocolAvailable()){
						// <CB Mod : CreditSystem>
						if ( clientrating > 1)
						// </CB Mod : CreditSystem>
							image = 3;
						else
							image = 1;
					}
					else{
						// <CB Mod : CreditSystem>
						if ( clientrating > 1)
						// </CB Mod : CreditSystem>
							image = 2;
						else
							image = 0;
					}
					uint32 nOverlayImage = 0;
					if ((client->Credits() && client->Credits()->GetCurrentIdentState(client->GetIP()) == IS_IDENTIFIED))
						nOverlayImage |= 1;
					if (client->IsObfuscatedConnectionEstablished())
						nOverlayImage |= 2;
					int iIconPosY = (cur_rec.Height() > 16) ? ((cur_rec.Height() - 16) / 2) : 1;
					POINT point = {cur_rec.left, cur_rec.top + iIconPosY};
					imagelist.Draw(dc,image, point, ILD_NORMAL | INDEXTOOVERLAYMASK(nOverlayImage));
					buffer = client->GetUserName();
					cur_rec.left +=20;
					dc.DrawText(buffer,buffer.GetLength(),&cur_rec,DLC_DT_TEXT);
					cur_rec.left -=20;
					break;
				}
				case 1:
					if(file)
						buffer = file->GetFileName();
					else
						buffer = _T("?");
					break;
				case 2:
					if(file){
						// <CB Mod : UploadFilePriority>
#ifndef CB_MOD_NEWPRIORITIES_ENABLED
						switch (file->GetUpPriority()) {
							case PR_VERYLOW : {
								buffer = GetResString(IDS_PRIOVERYLOW);
								break; }
							case PR_LOW : {
								if( file->IsAutoUpPriority() )
									buffer = GetResString(IDS_PRIOAUTOLOW);
								else
									buffer = GetResString(IDS_PRIOLOW);
								break; }
							case PR_NORMAL : {
								if( file->IsAutoUpPriority() )
									buffer = GetResString(IDS_PRIOAUTONORMAL);
								else
									buffer = GetResString(IDS_PRIONORMAL);
								break; }
							case PR_HIGH : {
								if( file->IsAutoUpPriority() )
									buffer = GetResString(IDS_PRIOAUTOHIGH);
								else
									buffer = GetResString(IDS_PRIOHIGH);
								break; }
							case PR_VERYHIGH : {
								buffer = GetResString(IDS_PRIORELEASE);
								break; }
							default:
								buffer.Empty();
						}
						
						if(file->GetPowerShared()) {
							CString tempString = GetResString(IDS_POWERSHARE_PREFIX);
							tempString.Append(_T(" "));
							tempString.Append(buffer);
							buffer.Empty(); // Is this line necessary?
							buffer = tempString;
						}
#else
						
						if (file->IsSuperRelease()) {
							buffer.Format (_T("%s"), GetResString(IDS_SUPERREL_PREFIX));
						} else {
							buffer.Format (_T("%i"),  file->GetUpPriority());
							if (file->IsAutoUpPriority()) {
								buffer.Append (_T(" "));
								buffer.Append (GetResString(IDS_PRIOAUTO));
							}
							if (file->GetPowerShared()) {
								buffer.Append (_T(" "));
								buffer.Append (GetResString(IDS_POWERSHARE_PREFIX));
							}
						}
#endif
					// </CB Mod : UploadFilePriority>
					}
					else
						buffer = _T("?");
					break;
				case 3: {
					// <CB Mod : Client Extended Info>
#ifdef CB_MOD_EXTRAINFO_ENABLED
					if (client->IsFriend() && client->GetFriendSlot()) {
						buffer.Format(_T("%s"),GetResString(IDS_FRIENDSLOT));
					} else {
#endif
					// </CB Mod : Client Extended Info>
						buffer.Format(_T("%i"),client->GetScore(false,false,true));
					
					// <CB Mod : Client Extended Info>
#ifdef CB_MOD_EXTRAINFO_ENABLED
					}
					sint64 diff = client->credits->GetUploadedTotal() - client->credits->GetDownloadedTotal();
					if (client->credits) {
						if (diff >= 0)
							buffer.AppendFormat(_T("  [Diff: %s]"), CastItoXBytes((uint32)diff, false, false));
						else
							buffer.AppendFormat(_T("  [Diff: -%s]"), CastItoXBytes((uint32)-diff, false, false));

#ifdef CB_MOD_BESTSHARE_ENABLED
						if (client->credits->GetBonusTime() > 0) {
							buffer.AppendFormat(_T(" /BS:x%i"), theApp.uploadqueue->GetBestShareMultiplier((int)-diff/PARTSIZE));
						}
#endif
					}
#endif
					// </CB Mod : Client Extended Info>
				}
					break;
				case 4: {

					// <CB Mod : Client Extended Info>
#ifdef CB_MOD_ENHANCEDINTERFACE_ENABLED
					if (client->IsFriend() && client->GetFriendSlot()) {
						buffer.Format(_T("%s"),GetResString(IDS_FRIENDSLOT));
					} else {
#endif
					// </CB Mod : Client Extended Info>

						if (client->HasLowID()) {
							if (client->m_dwWouldHaveGottenUploadSlotIfNotLowIdTick)
								buffer.Format(_T("%i **** Awaited reconnect %s"),client->GetScore(false), CastSecondsToHM((::GetTickCount()-client->m_dwWouldHaveGottenUploadSlotIfNotLowIdTick)/1000));
							else
								buffer.Format(_T("%i (%s)"),client->GetScore(false), GetResString(IDS_IDLOW));
						}
						else
							buffer.Format(_T("%i"),client->GetScore(false));
#ifdef CB_MOD_ENHANCEDINTERFACE_ENABLED
					}
#endif
					}
					break;
				case 5:
					buffer.Format(_T("%i"),client->GetAskedCount());
					break;
				case 6:
					buffer = CastSecondsToHM((::GetTickCount() - client->GetLastUpRequest())/1000);
					break;
				case 7:
// <CB Mod : BestShare : Date 18.07.07>
#ifdef CB_MOD_BESTSHARE_ENABLED
					if (client && client->credits && client->credits->GetBonusTime() > 0)
						buffer.Format(_T("%s (+ %s)"), CastSecondsToHM((::GetTickCount() - client->GetWaitStartTime())/1000), CastSecondsToHM(client->credits->GetBonusTime()/1000));
					else
						buffer = CastSecondsToHM((::GetTickCount() - client->GetWaitStartTime())/1000);
#else
					buffer = CastSecondsToHM((::GetTickCount() - client->GetWaitStartTime())/1000);
#endif
// </CB Mod : BestShare : Date 18.07.07>
					break;
				case 8:
					if(client->IsBanned())
						buffer = GetResString(IDS_YES);
					else
						buffer = GetResString(IDS_NO);
					break;
				case 9:
					if( client->GetUpPartCount()){
						cur_rec.bottom--;
						cur_rec.top++;
						client->DrawUpStatusBar(dc,&cur_rec,false,thePrefs.UseFlatBar());
						cur_rec.bottom++;
						cur_rec.top--;
					}
					break;
                case 10:
					buffer = client->GetClientSoftVer();
                    break;
                case 11:
					buffer = client->GetClientModVer();
                    break;

				// <CB Mod : QueueListInfo>
#ifdef CB_MOD_EXTRAINFO_ENABLED
				case 12:
					if(file) {
						buffer = CastItoXBytes(file->GetFileSize(), false, false);
						dc->DrawText(buffer, buffer.GetLength(), &cur_rec, DLC_DT_TEXT|DT_RIGHT);
					}
					break;

				case 13:
					buffer = ipstr (client->GetIP());
					break;

				case 14:
					buffer.Format(_T("%i"), client->m_QR);
#endif
				// </CB Mod : QueueListInfo>
			}
			
			// <CB Mod : QueueListInfo>
#ifdef CB_MOD_EXTRAINFO_ENABLED
			if( iColumn != 9 && iColumn != 0 && iColumn != 12)
#else
			if( iColumn != 9 && iColumn != 0)
#endif
			// </CB Mod : QueueListInfo>
				dc.DrawText(buffer,buffer.GetLength(),&cur_rec,DLC_DT_TEXT);
				
			// <CB Mod : Optimization : by Xman>
#if defined(CB_MOD_ENHANCEDINTERFACE_ENABLED) && defined(CB_MOD_OPTIMIZATIONS_ENABLED)
			dc.SetBkColor(crOldBackColor); //Xman SuperRelease //Xman show LowIDs
#endif
			// </CB Mod : Optimization : by Xman>
				
			cur_rec.left += GetColumnWidth(iColumn);
		}
	}

	// draw rectangle around selected item(s)
	if (lpDrawItemStruct->itemState & ODS_SELECTED)
	{
		RECT outline_rec = lpDrawItemStruct->rcItem;

		outline_rec.top--;
		outline_rec.bottom++;
		dc.FrameRect(&outline_rec, &CBrush(GetBkColor()));
		outline_rec.top++;
		outline_rec.bottom--;
		outline_rec.left++;
		outline_rec.right--;

		if(bCtrlFocused)
			dc.FrameRect(&outline_rec, &CBrush(m_crFocusLine));
		else
			dc.FrameRect(&outline_rec, &CBrush(m_crNoFocusLine));
	}
	
	if (m_crWindowTextBk == CLR_NONE)
		dc.SetBkMode(iOldBkMode);
	dc.SelectObject(pOldFont);
	dc.SetTextColor(crOldTextColor);
}

void CQueueListCtrl::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	const CUpDownClient* client = (iSel != -1) ? (CUpDownClient*)GetItemData(iSel) : NULL;

	CTitleMenu ClientMenu;
	ClientMenu.CreatePopupMenu();
	ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true);
	ClientMenu.AppendMenu(MF_STRING | (client ? MF_ENABLED : MF_GRAYED), MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("CLIENTDETAILS"));
	ClientMenu.SetDefaultItem(MP_DETAIL);
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && !client->IsFriend()) ? MF_ENABLED : MF_GRAYED), MP_ADDFRIEND, GetResString(IDS_ADDFRIEND), _T("ADDFRIEND"));
		
	// <CB Mod : Friend Management : Easy Remove>
#ifdef CB_MOD_EASYFRIENDSLOT_ENABLED
	ClientMenu.AppendMenu(MF_STRING | (client && client->IsFriend() ? MF_ENABLED : MF_GRAYED), MP_REMOVEFRIEND, GetResString(IDS_REMOVEFRIEND), _T("DELETEFRIEND"));
#endif
	// </CB Mod : Friend Management : Easy Remove>
	
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE"));
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetViewSharedFilesSupport()) ? MF_ENABLED : MF_GRAYED), MP_SHOWLIST, GetResString(IDS_VIEWFILES), _T("VIEWFILES"));
	if (thePrefs.IsExtControlsEnabled())
		ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->IsBanned()) ? MF_ENABLED : MF_GRAYED), MP_UNBAN, GetResString(IDS_UNBAN));
	if (Kademlia::CKademlia::IsRunning() && !Kademlia::CKademlia::IsConnected())
		ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetKadPort()!=0) ? MF_ENABLED : MF_GRAYED), MP_BOOT, GetResString(IDS_BOOTSTRAP));
	ClientMenu.AppendMenu(MF_STRING | (GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED), MP_FIND, GetResString(IDS_FIND), _T("Search"));

	// <CB Mod : Friend Management : Easy FriendSlot>
#ifdef CB_MOD_EASYFRIENDSLOT_ENABLED
	ClientMenu.AppendMenu(MF_SEPARATOR);
	ClientMenu.AppendMenu(MF_STRING, MP_FRIENDSLOT, GetResString(IDS_FRIENDSLOT), _T("FRIENDSLOT"));
	ClientMenu.EnableMenuItem(MP_FRIENDSLOT, (client)?MF_ENABLED:MF_GRAYED);
	ClientMenu.CheckMenuItem(MP_FRIENDSLOT, (client && client->GetFriendSlot())? MF_CHECKED : MF_UNCHECKED);
#endif
	// <CB Mod : Friend Management : Easy FriendSlot>

	// <CB Mod : ForceCheck>
#if defined(CB_MOD_ILLEGALMODSFILTER_ENABLED) && defined(_DEBUG)
	ClientMenu.AppendMenu(MF_SEPARATOR);
	ClientMenu.AppendMenu(MF_STRING, MP_FORCECLIENTCHECK, _T("Force Check"), NULL);
#endif
	// <CB Mod : ForceCheck>

	GetPopupMenuPos(*this, point);
	ClientMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
}

BOOL CQueueListCtrl::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
	wParam = LOWORD(wParam);

	switch (wParam)
	{
		case MP_FIND:
			OnFindStart();
			return TRUE;
	}

	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1){
		CUpDownClient* client = (CUpDownClient*)GetItemData(iSel);
	
		// <CB Mod : ContextMenu>
#ifdef CB_MOD_GENERALFIXES_ENABLED
		// It may happen that the client is removed from the queue when the a selection has been done
		if (!client)
			return true;
#endif
		// </CB Mod : ContextMenu>

		switch (wParam){
			case MP_SHOWLIST:
				client->RequestSharedFileList();
				break;
			case MP_MESSAGE:
				theApp.emuledlg->chatwnd->StartSession(client);
				break;
			case MP_ADDFRIEND:
				if (theApp.friendlist->AddFriend(client))
					Update(iSel);
				break;
			case MP_UNBAN:
				if (client->IsBanned()){
					client->UnBan();
					Update(iSel);
				}
				break;
			case MP_DETAIL:
			case MPG_ALTENTER:
			case IDA_ENTER:
			{
				CClientDetailDialog dialog(client, this);
				dialog.DoModal();
				break;
			}
			case MP_BOOT:
				if (client->GetKadPort())
					Kademlia::CKademlia::Bootstrap(ntohl(client->GetIP()), client->GetKadPort(), (client->GetKadVersion() > 1));
				break;

			// <CB Mod : Friend Management : Easy FriendSlot>
#ifdef CB_MOD_EASYFRIENDSLOT_ENABLED
			case MP_FRIENDSLOT:
				theApp.friendlist->AddFriend(client);
				if (client->GetFriendSlot())
					client->SetFriendSlot(false);
				else
					client->SetFriendSlot(true);
				Update(iSel);
				break;

			case MP_REMOVEFRIEND:
				if (client && client->IsFriend() && client->m_Friend != NULL) {
					theApp.friendlist->RemoveFriend(client->m_Friend);
					Update(iSel);	
				}
				break;
#endif
			// </CB Mod : Friend Management : Easy FriendSlot>


			// <CB Mod : ForceCheck>
#if defined(CB_MOD_ILLEGALMODSFILTER_ENABLED) && defined(_DEBUG)
			case MP_FORCECLIENTCHECK:
				client->CheckForGPLEvilDoer();
				break;
#endif
			// </CB Mod : ForceCheck>
		}
	}
	return true;
} 

void CQueueListCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){

	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// Barry - Store sort order in preferences
	// Determine ascending based on whether already sorted on this column
	bool sortAscending = (GetSortItem()!= pNMListView->iSubItem) ? true : !GetSortAscending();


	// <CB Mod : 4-way sorting : Date 19.08.07>>
#ifdef CB_MOD_EXTRAINFO_ENABLED
	int adder=0;
	int index = pNMListView->iSubItem - 3;
	if (pNMListView->iSubItem==3) {
		ASSERT( index < ARRSIZE(sortstat) );
		if (!sortAscending)
			sortstat[index] = !sortstat[index];
		adder = sortstat[index] ? 0 : 50;
	}

	// Sort table
	UpdateSortHistory(pNMListView->iSubItem + adder + (sortAscending ? 0:100), 100);
	if (adder==0)	
		SetSortArrow(pNMListView->iSubItem, sortAscending); 
	else
		SetSortArrow(pNMListView->iSubItem, sortAscending ? arrowDoubleUp : arrowDoubleDown);
	SortItems(SortProc, pNMListView->iSubItem + adder + (sortAscending ? 0:100));

#else
	// Sort table
	UpdateSortHistory(pNMListView->iSubItem + (sortAscending ? 0:100), 100);
	SetSortArrow(pNMListView->iSubItem, sortAscending);
	SortItems(SortProc, pNMListView->iSubItem + (sortAscending ? 0:100));
#endif
	// </CB Mod : 4-way sorting>



	*pResult = 0;
}

int CQueueListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	const CUpDownClient* item1 = (CUpDownClient*)lParam1;
	const CUpDownClient* item2 = (CUpDownClient*)lParam2;
	int iResult=0;
	switch(lParamSort){
		case 0: 
			if(item1->GetUserName() && item2->GetUserName())
				iResult=CompareLocaleStringNoCase(item1->GetUserName(), item2->GetUserName());
			else if(item1->GetUserName())
				iResult=1;
			else
				iResult=-1;
			break;
		case 100:
			if(item2->GetUserName() && item1->GetUserName())
				iResult=CompareLocaleStringNoCase(item2->GetUserName(), item1->GetUserName());
			else if(item2->GetUserName())
				iResult=1;
			else
				iResult=-1;
			break;
		
		case 1: {
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				iResult=CompareLocaleStringNoCase(file1->GetFileName(), file2->GetFileName());
			else if( file1 == NULL )
				iResult=1;
			else
				iResult=-1;
			break;
		}
		case 101: {
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				iResult=CompareLocaleStringNoCase(file2->GetFileName(), file1->GetFileName());
			else if( file1 == NULL )
				iResult=1;
			else
				iResult=-1;
			break;
		}
		
		case 2:
        case 102: {
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL)) {
				if(item1->GetPowerShared() == true && item2->GetPowerShared() == false)
					iResult = 1;
				else if(item1->GetPowerShared() == false && item2->GetPowerShared() == true)
					iResult = -1;
			else
				// <CB Mod : UploadFilePriority>
#ifdef CB_MOD_NEWPRIORITIES_ENABLED
				iResult = file1->GetUpPriority() > file2->GetUpPriority() ? 1 : -1;
#else
				iResult=((file1->GetUpPriority()==PR_VERYLOW) ? -1 : file1->GetUpPriority()) - ((file2->GetUpPriority()==PR_VERYLOW) ? -1 : file2->GetUpPriority());
#endif
				// </CB Mod : UploadFilePriority>

				if(lParamSort == 102) {
					iResult = -iResult;
				}
			} else if( file1 == NULL )
				iResult=1;
			else
				iResult=-1;

			break;
		}

		case 3: 
		// </CB Mod : Friend Management : Sorting : 03.02.08>
#ifdef CB_MOD_EXTRAINFO_ENABLED
			if (item1->GetFriendSlot() && !item2->GetFriendSlot()) {
				iResult = 1;
			} else if (!item1->GetFriendSlot() && item2->GetFriendSlot()) {
				iResult = -1;
			} else
				// Both or none have friendslot assigned
#endif
	// </CB Mod : Friend slot sorting>
			iResult=CompareUnsigned(item1->GetScore(false,false,true), item2->GetScore(false,false,true));
			break;
		case 103: 
			iResult=CompareUnsigned(item2->GetScore(false,false,true), item1->GetScore(false,false,true));
			break;
	
	// <CB Mod : 4-way sorting : Date 19.08.07>
#ifdef CB_MOD_EXTRAINFO_ENABLED
		case 53:
		case 153:
		{
			sint64 diff1 = item1->credits->GetUploadedTotal()-item1->credits->GetDownloadedTotal();
			sint64 diff2 = item2->credits->GetUploadedTotal()-item2->credits->GetDownloadedTotal();
			iResult = 0;
			if (item1->credits && item2->credits) {
				if (diff1 > diff2)
					iResult = 1;
				else if (diff1 < diff2)
					iResult = -1;
			}
			if (lParamSort == 153)
				iResult = -iResult;
		}
		break;
		
#endif
	// </CB Mod : 4-way sorting>

		case 4: 
    case 104: {
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL)) {
				if(item1->GetPowerShared() == true && item2->GetPowerShared() == false)
					iResult = 1;
				else if(item1->GetPowerShared() == false && item2->GetPowerShared() == true)
					iResult = -1;
				else if(item1->GetPowerShared() == true && item2->GetPowerShared() == true)

					// <CB Mod : UploadFilePriority>
#ifdef CB_MOD_NEWPRIORITIES_ENABLED
					iResult = file1->GetUpPriority() > file2->GetUpPriority() ? 1 : -1;
#else
					iResult = ((file1->GetUpPriority()==PR_VERYLOW) ? -1 : file1->GetUpPriority()) - ((file2->GetUpPriority()==PR_VERYLOW) ? -1 : file2->GetUpPriority());
#endif
					// </CB Mod : UploadFilePriority>

				else
					iResult = 0;

				if(lParamSort == 104) {
					iResult = -iResult;
				}
			} else if( file1 == NULL )
				iResult = 1;
			else
				iResult = -1;

			if(iResult == 0) {
				iResult=CompareUnsigned(item1->GetScore(false), item2->GetScore(false));
				if(lParamSort == 104) {
					iResult = -iResult;
				}
			}
			break;
        }

		case 5: 
			iResult=item1->GetAskedCount() - item2->GetAskedCount();
			break;
		case 105: 
			iResult=item2->GetAskedCount() - item1->GetAskedCount();
			break;
		
		case 6: 
			iResult=item1->GetLastUpRequest() - item2->GetLastUpRequest();
			break;
		case 106: 
			iResult=item2->GetLastUpRequest() - item1->GetLastUpRequest();
			break;
		
		case 7: 
			iResult=item1->GetWaitStartTime() - item2->GetWaitStartTime();
			break;
		case 107: 
			iResult=item2->GetWaitStartTime() - item1->GetWaitStartTime();
			break;
		
		case 8: 
			iResult=item1->IsBanned() - item2->IsBanned();
			break;
		case 108: 
			iResult=item2->IsBanned() - item1->IsBanned();
			break;
		
		case 9: 
			iResult=item1->GetUpPartCount() - item2->GetUpPartCount();
			break;
		case 109: 
			iResult=item2->GetUpPartCount() - item1->GetUpPartCount();
			break;

        case 10:
		case 110: 
		// <CB Mod : Fix>
			if(!item1->GetClientSoftVer().IsEmpty() && !item2->GetClientSoftVer().IsEmpty()) {
				iResult = _tcsicmp(item1->GetClientSoftVer(), item2->GetClientSoftVer());

                if(lParamSort == 110) {
                    iResult = -iResult;
                }
		    } else if(item1->GetClientSoftVer())
			    iResult =  1;
		    else
			    iResult =  -1;

            break;

        case 11:
		case 111: 
		  if(!item1->GetClientModVer().IsEmpty() && !item2->GetClientModVer().IsEmpty()) {
				iResult = _tcsicmp(item1->GetClientModVer(), item2->GetClientModVer());

				if(lParamSort == 111) {
					iResult = -iResult;
				}
		  } else
				if (item1->GetClientModVer().IsEmpty())
					iResult =  1;
				else if (item2->GetClientModVer().IsEmpty())
					iResult =  -1;
				else
					iResult = 0; // keep peers sorted as for latest sort critera
		// </CB Mod : Fix>

      break;

		// <CB Mod : QueueListInfo : Sort>
#ifdef CB_MOD_EXTRAINFO_ENABLED
		case 12: // File size ascending
		{
			CKnownFile *file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile *file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				return CompareUnsigned64((uint64)file1->GetFileSize(), (uint64)file2->GetFileSize());
		}
		case 112: // File size descending
		{
			CKnownFile *file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile *file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				return CompareUnsigned64((uint64)file2->GetFileSize(), (uint64)file1->GetFileSize());
		}

		case 13: // IP Number ascending
		{
			uint32 ip1 = ntohl(item1->GetIP());
			uint32 ip2 = ntohl(item2->GetIP());
			if(ip1 > ip2)
				return 1;
			else if (ip1 < ip2)
				return -1;
			else
				return 0;
		}
		case 113: // IP Number descending
		{
			uint32 ip1 = ntohl(item1->GetIP());
			uint32 ip2 = ntohl(item2->GetIP());
			if(ip1 > ip2)
				return -1;
			else if (ip1 < ip2)
				return 1;
			else
				return 0;
		}

		case 14: // QR value ascending
		{
			return item1->m_QR - item2->m_QR;
		}
		case 114: // QR value descending
		{
			return item2->m_QR - item1->m_QR;
		}
#endif
		// </CB Mod : QueueListInfo : Sort>

		default:
			iResult=0;
			break;
	}
	int dwNextSort;
	//call secondary sortorder, if this one results in equal
	//(Note: yes I know this call is evil OO wise, but better than changing a lot more code, while we have only one instance anyway - might be fixed later)
	if (iResult == 0 && (dwNextSort = theApp.emuledlg->transferwnd->queuelistctrl.GetNextSortOrder(lParamSort)) != (-1)){
		iResult= SortProc(lParam1, lParam2, dwNextSort);
	}

	return iResult;

}

// Barry - Refresh the queue every 10 secs
void CALLBACK CQueueListCtrl::QueueUpdateTimer(HWND /*hwnd*/, UINT /*uiMsg*/, UINT /*idEvent*/, DWORD /*dwTime*/)
{
	// NOTE: Always handle all type of MFC exceptions in TimerProcs - otherwise we'll get mem leaks
	try
	{
		if (   !theApp.emuledlg->IsRunning() // Don't do anything if the app is shutting down - can cause unhandled exceptions
			|| !thePrefs.GetUpdateQueueList()
			|| theApp.emuledlg->activewnd != theApp.emuledlg->transferwnd
			|| !theApp.emuledlg->transferwnd->queuelistctrl.IsWindowVisible() )
			return;

		const CUpDownClient* update = theApp.uploadqueue->GetNextClient(NULL);
		while( update )
		{
			theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(update);
			update = theApp.uploadqueue->GetNextClient(update);
		}
	}
	CATCH_DFLT_EXCEPTIONS(_T("CQueueListCtrl::QueueUpdateTimer"))
}

void CQueueListCtrl::ShowQueueClients()
{
	DeleteAllItems(); 
	CUpDownClient* update = theApp.uploadqueue->GetNextClient(NULL);
	while( update )
	{
		AddClient(update, false);
		update = theApp.uploadqueue->GetNextClient(update);
	}
}

void CQueueListCtrl::ShowSelectedUserDetails()
{
	POINT point;
	::GetCursorPos(&point);
	CPoint p = point; 
    ScreenToClient(&p); 
    int it = HitTest(p); 
    if (it == -1)
		return;

	SetItemState(-1, 0, LVIS_SELECTED);
	SetItemState(it, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	SetSelectionMark(it);   // display selection mark correctly!

	CUpDownClient* client = (CUpDownClient*)GetItemData(GetSelectionMark());
	if (client){
		CClientDetailDialog dialog(client, this);
		dialog.DoModal();
	}
}

void CQueueListCtrl::OnNMDblclk(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1) {
		CUpDownClient* client = (CUpDownClient*)GetItemData(iSel);
		if (client){
			CClientDetailDialog dialog(client, this);
			dialog.DoModal();
		}
	}
	*pResult = 0;
}

void CQueueListCtrl::OnGetDispInfo(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);

	if (theApp.emuledlg->IsRunning()){
		// Although we have an owner drawn listview control we store the text for the primary item in the listview, to be
		// capable of quick searching those items via the keyboard. Because our listview items may change their contents,
		// we do this via a text callback function. The listview control will send us the LVN_DISPINFO notification if
		// it needs to know the contents of the primary item.
		//
		// But, the listview control sends this notification all the time, even if we do not search for an item. At least
		// this notification is only sent for the visible items and not for all items in the list. Though, because this
		// function is invoked *very* often, no *NOT* put any time consuming code here in.

		if (pDispInfo->item.mask & LVIF_TEXT){
			const CUpDownClient* pClient = reinterpret_cast<CUpDownClient*>(pDispInfo->item.lParam);
			if (pClient != NULL){
				switch (pDispInfo->item.iSubItem){
					case 0:
						if (pClient->GetUserName() != NULL && pDispInfo->item.cchTextMax > 0){
							_tcsncpy(pDispInfo->item.pszText, pClient->GetUserName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
		}
	}
	*pResult = 0;
}