//this file is part of NeoMule
//Copyright (C)2006-2008 David Xanatos ( XanatosDavid@googlemail.com / http://NeoMule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

#include "opcodes.h"

// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
/*
* Konstanten
*/

#ifndef NEO_DEFAULTS
#define NEO_DEFAULTS

// NEO: OCC - [ObelixConnectionControl]
#define VAL_CON_CTR_MIN	50
#define VAL_CON_CTR_DEF	75
#define VAL_CON_CTR_MAX	85
// NEO: OCC END

// NEO: SCM - [SmartConnectionManagement]
#define VAL_CON_MAN_MIN	1.0F
#define VAL_CON_MAN_DEF	2.0F
#define VAL_CON_MAN_MAX	10.0F
// NEO: SCM END

// NEO: NCC - [NeoConnectionChecker]
#define VAL_CON_CHK_MIN	3
#define VAL_CON_CHK_DEF	5
#define VAL_CON_CHK_MAX	10
// NEO: NCC END

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
#define VAL_BC_TIME_DOWN_MIN	1
#define VAL_BC_TIME_DOWN_DEF	20
#define VAL_BC_TIME_DOWN_MAX	250	

#define VAL_BC_TIME_UP_MIN		1
#define VAL_BC_TIME_UP_DEF		10
#define VAL_BC_TIME_UP_MAX		250	

#define VAL_DOWNLOAD_BUFFER_MIN	4*1024
#define VAL_DOWNLOAD_BUFFER_DEF	65*1024
#define VAL_DOWNLOAD_BUFFER_MAX	1024*1024

#define VAL_UPLOAD_BUFFER_MIN	4*1024
#define VAL_UPLOAD_BUFFER_DEF	8*1024
#define VAL_UPLOAD_BUFFER_MAX	1024*1024

#define VAL_MAX_RESERVED_SLOTS_MIN	1
#define VAL_MAX_RESERVED_SLOTS_DEF	2
#define VAL_MAX_RESERVED_SLOTS_MAX	10

#define VAL_INCREASE_TRICKLE_SPEED_MIN	0.1F
#define VAL_INCREASE_TRICKLE_SPEED_DEF	0.5F
#define VAL_INCREASE_TRICKLE_SPEED_MAX	2.0F

 #ifdef BW_MOD// NEO: BM - [BandwidthModeration]
#define VAL_RELEASE_SLOT_SPEED_MIN	2.0F
#define VAL_RELEASE_SLOT_SPEED_DEF	5.0F
#define VAL_RELEASE_SLOT_SPEED_MAX	20.0F

#define VAL_RELEASE_BANDWIDTH_PERCENTAGE_MIN	10.0F
#define VAL_RELEASE_BANDWIDTH_PERCENTAGE_DEF	75.0F
#define VAL_RELEASE_BANDWIDTH_PERCENTAGE_MAX	90.0F

#define VAL_FRIEND_SLOT_SPEED_MIN	2.0F
#define VAL_FRIEND_SLOT_SPEED_DEF	3.0F
#define VAL_FRIEND_SLOT_SPEED_MAX	10.0F

#define VAL_FRIEND_BANDWIDTH_PERCENTAGE_MIN		10.0F
#define VAL_FRIEND_BANDWIDTH_PERCENTAGE_DEF		25.0F
#define VAL_FRIEND_BANDWIDTH_PERCENTAGE_MAX		80.0F
 #endif // BW_MOD // NEO: BM END

#define VAL_MAX_UL_SLOTS_MIN	3
#define VAL_MAX_UL_SLOTS_DEF	250
#define VAL_MAX_UL_SLOTS_MAX	250

#define VAL_MIN_UL_SLOTS_MIN	2
#define VAL_MIN_UL_SLOTS_DEF	2
#define VAL_MIN_UL_SLOTS_MAX	20

#define VAL_UL_PER_SLOTS_MIN	2.0F
#define VAL_UL_PER_SLOTS_DEF	3.0F
#define VAL_UL_PER_SLOTS_MAX	10.0F

#define VAL_DYN_UP_GOING_UP_DIVIDER_MIN	100
#define VAL_DYN_UP_GOING_UP_DIVIDER_DEF	1000
#define VAL_DYN_UP_GOING_UP_DIVIDER_MAX	10000

#define VAL_DYN_UP_GOING_DOWN_DIVIDER_MIN	200
#define VAL_DYN_UP_GOING_DOWN_DIVIDER_DEF	2000
#define VAL_DYN_UP_GOING_DOWN_DIVIDER_MAX	20000

#define VAL_BASE_PING_UP_MIN 10
#define VAL_BASE_PING_UP_DEF 100
#define VAL_BASE_PING_UP_MAX 10000

#define VAL_PING_UP_TOLERANCE_MIN 1
#define VAL_PING_UP_TOLERANCE_DEF 12
#define VAL_PING_UP_TOLERANCE_MAX 24

#define VAL_PING_UP_PROZENT_MIN 50
#define VAL_PING_UP_PROZENT_DEF 500
#define VAL_PING_UP_PROZENT_MAX 5000

#define VAL_DYN_DOWN_GOING_UP_DIVIDER_MIN	200
#define VAL_DYN_DOWN_GOING_UP_DIVIDER_DEF	2000
#define VAL_DYN_DOWN_GOING_UP_DIVIDER_MAX	20000

#define VAL_DYN_DOWN_GOING_DOWN_DIVIDER_MIN	400
#define VAL_DYN_DOWN_GOING_DOWN_DIVIDER_DEF	4000
#define VAL_DYN_DOWN_GOING_DOWN_DIVIDER_MAX	40000

#define VAL_BASE_PING_DOWN_MIN 20
#define VAL_BASE_PING_DOWN_DEF 200
#define VAL_BASE_PING_DOWN_MAX 20000

#define VAL_PING_DOWN_TOLERANCE_MIN 1
#define VAL_PING_DOWN_TOLERANCE_DEF 12
#define VAL_PING_DOWN_TOLERANCE_MAX 24

#define VAL_PING_DOWN_PROZENT_MIN 100
#define VAL_PING_DOWN_PROZENT_DEF 1000
#define VAL_PING_DOWN_PROZENT_MAX 10000
#endif // NEO_BC // NEO: NBC END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]

#define VAL_LAN_DOWNLOAD_BUFFER_MIN	4*1024
#define VAL_LAN_DOWNLOAD_BUFFER_DEF	512*1024
#define VAL_LAN_DOWNLOAD_BUFFER_MAX	1024*1024

#define VAL_LAN_UPLOAD_BUFFER_MIN	4*1024
#define VAL_LAN_UPLOAD_BUFFER_DEF	512*1024
#define VAL_LAN_UPLOAD_BUFFER_MAX	1024*1024

#define VAL_MAX_LAN_UPLOAD_SLOTS_MIN	10
#define VAL_MAX_LAN_UPLOAD_SLOTS_DEF	50
#define VAL_MAX_LAN_UPLOAD_SLOTS_MAX	100

#define	VAL_UPLOAD_PER_LAN_SLOTS_MIN	10
#define	VAL_UPLOAD_PER_LAN_SLOTS_DEF	100

#define MIN_AUTO_BROADCAST_LAN_FILES	1 // sec
#define DEF_AUTO_BROADCAST_LAN_FILES	5
#define MAX_AUTO_BROADCAST_LAN_FILES	15

#define MIN_LC_INTERVALS				MIN2S(1)
#define DEF_LC_INTERVALS				MIN2S(10)
#define MAX_LC_INTERVALS				MIN2S(60)

#define MIN_LAN_SOURCE_REASK_TIME		MIN2S(1)
#define DEF_LAN_SOURCE_REASK_TIME		MIN2S(3)
#define MAX_LAN_SOURCE_REASK_TIME		MIN2S(10)

#define MIN_LAN_NNP_SOURCE_REASK_TIME	MIN2S(10)
#define DEF_LAN_NNP_SOURCE_REASK_TIME	MIN2S(30)
#define MAX_LAN_NNP_SOURCE_REASK_TIME	MIN2S(120)

#endif //LANCAST // NEO: NLC END

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
#define	MIN_VOODOO_RECONNECT_TIME	MIN2S(3)
#define	DEF_VOODOO_RECONNECT_TIME	MIN2S(5)
#define	MAX_VOODOO_RECONNECT_TIME	MIN2S(50)

#define	MIN_VOODOO_SEARCH	MIN2S(10)
#define	DEF_VOODOO_SEARCH	MIN2S(60)
#define	MAX_VOODOO_SEARCH	MIN2S(180)
#endif // VOODOO // NEO: VOODOO END

// NEO: QS - [QuickStart]
#define TIM_QUICK_START_MIN		3
#define TIM_QUICK_START_DEF		15
#define TIM_QUICK_START_MAX		30

#define VAL_QUICK_START_PF_MIN	10
#define VAL_QUICK_START_PF_DEF	30
#define VAL_QUICK_START_PF_MAX	180
// NEO: QS END

// NEO: RKF - [RecheckKadFirewalled]
#define TIM_RECHECK_KAD_FIREWALLED_MIN	2
#define TIM_RECHECK_KAD_FIREWALLED_DEF	15
#define TIM_RECHECK_KAD_FIREWALLED_MAX	30
// NEO: RKF END

// NEO: RLD - [ReconnectOnLowID]
#define VAL_RECONNECT_ON_LOWID_TRYS_MIN 1
#define VAL_RECONNECT_ON_LOWID_TRYS_DEF 3
#define VAL_RECONNECT_ON_LOWID_TRYS_MAX 5
// NEO: RLD END

// NEO: IPS - [InteligentPartSharing]
#define MIN_INTELIGENT_PART_SHARING_TIMER	MIN2S(1)
#define DEF_INTELIGENT_PART_SHARING_TIMER	MIN2S(30)
#define MAX_INTELIGENT_PART_SHARING_TIMER	MIN2S(120)

#define MIN_MAX_PROZENT_TO_HIDE				1
#define DEF_MAX_PROZENT_TO_HIDE				75
#define MAX_MAX_PROZENT_TO_HIDE				100

// OverAvalibly
#define MIN_HIDE_OVER_AVALIBLY_VALUE_1		(int)(1.10F*100.0F)
#define DEF_HIDE_OVER_AVALIBLY_VALUE_1		(int)(2.0F*100.0F)
#define MAX_HIDE_OVER_AVALIBLY_VALUE_1		(int)(20.0F*100.0F)

#define MIN_HIDE_OVER_AVALIBLY_VALUE_2		(int)(1.0F*100.0F)
#define DEF_HIDE_OVER_AVALIBLY_VALUE_2		(int)(5.0F*100.0F)
#define MAX_HIDE_OVER_AVALIBLY_VALUE_2		(int)(30.0F*100.0F)

#define MIN_BLOCK_HIGH_OVER_AVALIBLY_FACTOR	(int)(1.0F*100.0F)
#define DEF_BLOCK_HIGH_OVER_AVALIBLY_FACTOR	(int)(3.0F*100.0F)
#define MAX_BLOCK_HIGH_OVER_AVALIBLY_FACTOR	(int)(10.0F*100.0F)

// OverShared
#define MIN_HIDE_OVER_SHARED_VALUE_1		(int)(1.10F*100.0F)
#define DEF_HIDE_OVER_SHARED_VALUE_1		(int)(4.0F*100.0F)
#define MAX_HIDE_OVER_SHARED_VALUE_1		(int)(20.0F*100.0F)

#define MIN_HIDE_OVER_SHARED_VALUE_2		(int)(1.0F*100.0F)
#define DEF_HIDE_OVER_SHARED_VALUE_2		(int)(5.0F*100.0F)
#define MAX_HIDE_OVER_SHARED_VALUE_2		(int)(30.0F*100.0F)

#define MIN_BLOCK_HIGH_OVER_SHARED_FACTOR	(int)(1.0F*100.0F)
#define DEF_BLOCK_HIGH_OVER_SHARED_FACTOR	(int)(3.0F*100.0F)
#define MAX_BLOCK_HIGH_OVER_SHARED_FACTOR	(int)(10.0F*100.0F)

// DontHideUnderAvalibly
#define MIN_DONT_HIDEUNDER_AVALIBLY_VALUE_1	(int)(1.10F*100.0F)
#define DEF_DONT_HIDEUNDER_AVALIBLY_VALUE_1	(int)(2.0F*100.0F)
#define MAX_DONT_HIDEUNDER_AVALIBLY_VALUE_1	(int)(20.0F*100.0F)

#define MIN_DONT_HIDEUNDER_AVALIBLY_VALUE_2	(int)(1.0F*100.0F)
#define DEF_DONT_HIDEUNDER_AVALIBLY_VALUE_2	(int)(5.0F*100.0F)
#define MAX_DONT_HIDEUNDER_AVALIBLY_VALUE_2	(int)(30.0F*100.0F)

// Other
#define MIN_SHOW_ALWAYS_SOME_PARTS_VALUE	1
#define DEF_SHOW_ALWAYS_SOME_PARTS_VALUE	2
#define MAX_SHOW_ALWAYS_SOME_PARTS_VALUE	10
// NEO: IPS END

// NEO: SRS - [SmartReleaseSharing]
#define MIN_RELEASE_TIMER					MIN2S(1)
#define DEF_RELEASE_TIMER					MIN2S(10)
#define MAX_RELEASE_TIMER					MIN2S(60)

#define MIN_RELEASE_LEVEL					2
#define DEF_RELEASE_LEVEL					10
#define MAX_RELEASE_LEVEL					200

// release limit in %
#define MIN_RELEASE_LIMIT_HIGH				100
#define DEF_RELEASE_LIMIT_HIGH				200
#define MAX_RELEASE_LIMIT_HIGH				1000

#define MIN_RELEASE_LIMIT_LOW				MIN_RELEASE_LIMIT_HIGH/2
#define DEF_RELEASE_LIMIT_LOW				DEF_RELEASE_LIMIT_HIGH/2
#define MAX_RELEASE_LIMIT_LOW				MAX_RELEASE_LIMIT_HIGH/2


#define MIN_RELEASE_LIMIT_COMPLETE_HIGH		100
#define DEF_RELEASE_LIMIT_COMPLETE_HIGH		200
#define MAX_RELEASE_LIMIT_COMPLETE_HIGH		1000

#define MIN_RELEASE_LIMIT_COMPLETE_LOW		MIN_RELEASE_LIMIT_COMPLETE_HIGH/2
#define DEF_RELEASE_LIMIT_COMPLETE_LOW		DEF_RELEASE_LIMIT_COMPLETE_HIGH/2
#define MAX_RELEASE_LIMIT_COMPLETE_LOW		MAX_RELEASE_LIMIT_COMPLETE_HIGH/2

// source limit
#define MIN_SOURCE_LIMIT_HIGH				5
#define DEF_SOURCE_LIMIT_HIGH				20
#define MAX_SOURCE_LIMIT_HIGH				200

#define MIN_SOURCE_LIMIT_LOW				MIN_SOURCE_LIMIT_HIGH/2
#define DEF_SOURCE_LIMIT_LOW				DEF_SOURCE_LIMIT_HIGH/2
#define MAX_SOURCE_LIMIT_LOW				MAX_SOURCE_LIMIT_HIGH/2


#define MIN_SOURCE_LIMIT_COMPLETE_HIGH		5
#define DEF_SOURCE_LIMIT_COMPLETE_HIGH		10
#define MAX_SOURCE_LIMIT_COMPLETE_HIGH		200

#define MIN_SOURCE_LIMIT_COMPLETE_LOW		MIN_SOURCE_LIMIT_COMPLETE_HIGH/2
#define DEF_SOURCE_LIMIT_COMPLETE_LOW		DEF_SOURCE_LIMIT_COMPLETE_HIGH/2
#define MAX_SOURCE_LIMIT_COMPLETE_LOW		MAX_SOURCE_LIMIT_COMPLETE_HIGH/2
// NEO: SRS END


// NEO: SRS - [SmartReleaseSharing]
#define MIN_RELEASE_CHUNKS		1
#define DEF_RELEASE_CHUNKS		2
#define MAX_RELEASE_CHUNKS		3

#define MIN_RELEASE_SLOT_LIMIT	1
#define DEF_RELEASE_SLOT_LIMIT	4
#define MAX_RELEASE_SLOT_LIMIT	20
// NEO: SRS END

// NEO: NMFS - [NiceMultiFriendSlots]
#define MIN_FRIEND_SLOT_LIMIT	1
#define DEF_FRIEND_SLOT_LIMIT	2
#define MAX_FRIEND_SLOT_LIMIT	10
// NEO: NMFS END

// NEO: TQ - [TweakUploadQueue]
#define MIN_QUEUE_OVERFLOW		1
#define DEF_QUEUE_OVERFLOW		25
#define MAX_QUEUE_OVERFLOW		100
// NEO: TQ END

// NEO: PRSF - [PushSmallRareFiles]
#define MIN_PUSH_SMALL_FILES	1
#define DEF_PUSH_SMALL_FILES	9
#define MAX_PUSH_SMALL_FILES	18

#define MIN_PUSH_RARE_FILES		4
#define DEF_PUSH_RARE_FILES		10
#define MAX_PUSH_RARE_FILES		25

#define MIN_PUSH_RATIO_FILES	2
#define DEF_PUSH_RATIO_FILES	10
#define MAX_PUSH_RATIO_FILES	20
// NEO: PRSF END

#ifdef BW_MOD // NEO: BM - [BandwidthModeration]
#define MIN_FRIEND_SLOT_SPEED				2.0F
#define DEF_FRIEND_SLOT_SPEED				3.0F
#define MAX_FRIEND_SLOT_SPEED				10.0F

#define MIN_FRIEND_BANDWIDTH_PERCENTAGE		10.0F
#define DEF_FRIEND_BANDWIDTH_PERCENTAGE		25.0F
#define MAX_FRIEND_BANDWIDTH_PERCENTAGE		50.0F

#define MIN_RELEASE_SLOT_SPEED				2.0F
#define DEF_RELEASE_SLOT_SPEED				5.0F
#define MAX_RELEASE_SLOT_SPEED				15.0F

#define MIN_RELEASE_BANDWIDTH_PERCENTAGE	25.0F
#define DEF_RELEASE_BANDWIDTH_PERCENTAGE	50.0F
#define MAX_RELEASE_BANDWIDTH_PERCENTAGE	75.0F
#endif // BW_MOD // NEO: BM END


// NEO: SRT - [SourceRequestTweaks]
// General
#define MIN_SOURCE_LIMIT				10
#define DEF_SOURCE_LIMIT				400
#define MAX_SOURCE_LIMIT				4000

// Management
#define MIN_SWAP_LIMIT					8
#define DEF_SWAP_LIMIT					FCFG_AUT // 320
#define MAX_SWAP_LIMIT					(MAX_SOURCE_LIMIT * 9 / 10)

//XS
#define MIN_XS_LIMIT					9
#define DEF_XS_LIMIT					FCFG_AUT // 360
#define MAX_XS_LIMIT					MAX_SOURCES_FILE_SOFT

#define MIN_XS_INTERVALS				DEF_XS_INTERVALS	
#define DEF_XS_INTERVALS				MS2SEC(SOURCECLIENTREASKF)
#define MAX_XS_INTERVALS				DEF_XS_INTERVALS*2

#define MIN_XS_CLIENT_INTERVALS			DEF_XS_CLIENT_INTERVALS
#define DEF_XS_CLIENT_INTERVALS			MS2SEC(SOURCECLIENTREASKS)
#define MAX_XS_CLIENT_INTERVALS			DEF_XS_CLIENT_INTERVALS*3

#define MIN_XS_CLEINT_DELAY				DEF_XS_CLEINT_DELAY
#define DEF_XS_CLEINT_DELAY				MINCOMMONPENALTY
#define MAX_XS_CLEINT_DELAY				DEF_XS_CLEINT_DELAY*2

#define MIN_XS_RARE_LIMIT				DEF_XS_RARE_LIMIT/5
#define DEF_XS_RARE_LIMIT				RARE_FILE
#define MAX_XS_RARE_LIMIT				DEF_XS_RARE_LIMIT

//SVR
#define MIN_SVR_LIMIT					9
#define DEF_SVR_LIMIT					FCFG_AUT // 360
#define MAX_SVR_LIMIT					MAX_SOURCES_FILE_SOFT

#define MIN_SVR_INTERVALS				DEF_SVR_INTERVALS
#define DEF_SVR_INTERVALS				MS2SEC(SERVERREASKTIME)
#define MAX_SVR_INTERVALS				DEF_SVR_INTERVALS*2

//KAD
#define MIN_KAD_LIMIT					5
#define DEF_KAD_LIMIT					FCFG_AUT // 40
#define MAX_KAD_LIMIT					MAX_SOURCES_FILE_UDP

#define MIN_KAD_INTERVALS				DEF_KAD_INTERVALS
#define DEF_KAD_INTERVALS				MS2SEC(KADEMLIAREASKTIME)
#define MAX_KAD_INTERVALS				DEF_KAD_INTERVALS*2

#define MIN_KAD_MAX_FILES				DEF_KAD_MAX_FILES/2
#define DEF_KAD_MAX_FILES				KADEMLIATOTALFILE
#define MAX_KAD_MAX_FILES				DEF_KAD_MAX_FILES

#define MIN_KAD_REPEAT_DELAY			DEF_KAD_REPEAT_DELAY
#define DEF_KAD_REPEAT_DELAY			7
#define MAX_KAD_REPEAT_DELAY			DEF_KAD_REPEAT_DELAY*2

//UDP
#define MIN_UDP_LIMIT					5
#define DEF_UDP_LIMIT					FCFG_AUT // 40
#define MAX_UDP_LIMIT					MAX_SOURCES_FILE_UDP

#define MIN_UDP_INTERVALS				MAX_UDP_INTERVALS
#define DEF_UDP_INTERVALS				MS2SEC(UDPSERVERREASKTIME)
#define MAX_UDP_INTERVALS				DEF_UDP_INTERVALS*2

#define MIN_UDP_GLOBAL_INTERVALS		DEF_UDP_GLOBAL_INTERVALS
#define DEF_UDP_GLOBAL_INTERVALS		MS2SEC(UDPSERVERREASKTIME)
#define MAX_UDP_GLOBAL_INTERVALS		MIN_UDP_GLOBAL_INTERVALS*2

#define MIN_UDP_FILES_PER_SERVER		34
#define DEF_UDP_FILES_PER_SERVER		35
#define MAX_UDP_FILES_PER_SERVER		34*2 // why do we setd 35 requests at once, we send so 34 to ine server and 1 to an other server, lets allow to send 2 full 34 packets
// NEO: SRT END

// NEO: XSC - [ExtremeSourceCache]
#define MIN_SOURCE_CACHE_LIMIT			10
#define DEF_SOURCE_CACHE_LIMIT			FCFG_AUT
#define MAX_SOURCE_CACHE_LIMIT			MAX_SOURCE_LIMIT/5

#define MIN_SOURCE_CACHE_TIME			MIN2S(5)
#define DEF_SOURCE_CACHE_TIME			MIN2S(20)
#define MAX_SOURCE_CACHE_TIME			MIN2S(40)
// NEO: XSC END

// NEO: OCC - [ObelixConnectionControl]
#define	MIN_OBELIX_CONNECTION_CONTROL	50
#define DEF_OBELIX_CONNECTION_CONTROL	75
#define MAX_OBELIX_CONNECTION_CONTROL	90
// NEO: OCC END

// NEO: ASL - [AutoSoftLock]
#define	MIN_AUTO_SOFT_LOCK_LIMIT		5
#define DEF_AUTO_SOFT_LOCK_LIMIT		20
#define MAX_AUTO_SOFT_LOCK_LIMIT		200
// NEO: ASL END

// NEO: AHL - [AutoHardLimit]
#define	MIN_AUTO_HARD_LIMIT_TIME		20
#define DEF_AUTO_HARD_LIMIT_TIME		40
#define MAX_AUTO_HARD_LIMIT_TIME		120
// NEO: AHL END

// NEO: CSL - [CategorySourceLimit]
#define MIN_CATEGORY_SOURCE_LIMIT_LIMIT	50
#define DEF_CATEGORY_SOURCE_LIMIT_LIMIT	1000
#define MAX_CATEGORY_SOURCE_LIMIT_LIMIT	20000

#define MIN_CATEGORY_SOURCE_LIMIT_TIME	30
#define DEF_CATEGORY_SOURCE_LIMIT_TIME	50
#define MAX_CATEGORY_SOURCE_LIMIT_TIME	150
// NEO: CSL END

// NEO: GSL - [GlobalSourceLimit]
#define	MIN_GLOBAL_SOURCE_LIMIT_LIMIT	100
#define DEF_GLOBAL_SOURCE_LIMIT_LIMIT	2000
#define MAX_GLOBAL_SOURCE_LIMIT_LIMIT	40000

#define	MIN_GLOBAL_SOURCE_LIMIT_TIME	30
#define DEF_GLOBAL_SOURCE_LIMIT_TIME	50
#define MAX_GLOBAL_SOURCE_LIMIT_TIME	150
// NEO: GSL END

#define	MIN_MIN_SOURCE_PER_FILE			10
#define DEF_MIN_SOURCE_PER_FILE			200
#define MAX_MIN_SOURCE_PER_FILE			400

// NEO: TCR - [TCPConnectionRetry]
#define MIN_TCP_CONNECTION_RETRY		0
#define DEF_TCP_CONNECTION_RETRY		2
#define MAX_TCP_CONNECTION_RETRY		3
// NEO: TCR END

// NEO: DRT - [DownloadReaskTweaks]
#define MIN_SPREAD_REASK_TIME			MIN2S(1)
#define DEF_SPREAD_REASK_TIME			MIN2S(2)
#define MAX_SPREAD_REASK_TIME			MIN2S(3)

#define MIN_SOURCE_REASK_TIME			DEF_SOURCE_REASK_TIME
#define DEF_SOURCE_REASK_TIME			MS2SEC(FILEREASKTIME)
#define MAX_SOURCE_REASK_TIME			(DEF_SOURCE_REASK_TIME*2) - MAX_SPREAD_REASK_TIME - MIN2S(3) // we must make sure we dont drop out of his queue

#define MIN_FULLQ_SOURCE_REASK_TIME		DEF_FULLQ_SOURCE_REASK_TIME
#define DEF_FULLQ_SOURCE_REASK_TIME		MS2SEC(FILEREASKTIME)
#define MAX_FULLQ_SOURCE_REASK_TIME		DEF_FULLQ_SOURCE_REASK_TIME*4

#define MIN_NNP_SOURCE_REASK_TIME		DEF_NNP_SOURCE_REASK_TIME
#define DEF_NNP_SOURCE_REASK_TIME		MS2SEC(FILEREASKTIME)*2
#define MAX_NNP_SOURCE_REASK_TIME		DEF_NNP_SOURCE_REASK_TIME*4
// NEO: DRT END

// NEO: SDT - [SourcesDropTweaks]
#define MIN_DROP_TIME					MIN2S(30)
#define DEF_DROP_TIME					MIN2S(60)
#define MAX_DROP_TIME					HR2S(4)

//Bad
#define MIN_BAD_SOURCE_LIMIT_1			MIN_SOURCE_LIMIT*8/10
#define DEF_BAD_SOURCE_LIMIT_1			FCFG_AUT // 320
#define MAX_BAD_SOURCE_LIMIT_1			MAX_SOURCE_LIMIT*8/10

#define MIN_BAD_SOURCE_LIMIT_2			5
#define DEF_BAD_SOURCE_LIMIT_2			15
#define MAX_BAD_SOURCE_LIMIT_2			25

#define MIN_BAD_SOURCE_LIMIT_3			MIN_SOURCE_LIMIT/2
#define DEF_BAD_SOURCE_LIMIT_3			FCFG_AUT // 80
#define MAX_BAD_SOURCE_LIMIT_3			MAX_SOURCE_LIMIT/2

#define MIN_BAD_SOURCE_DROP_TIME_1		(10)
#define DEF_BAD_SOURCE_DROP_TIME_1		(30)
#define MAX_BAD_SOURCE_DROP_TIME_1		(50)

#define MIN_BAD_SOURCE_DROP_TIME_2		MIN2S(1)
#define DEF_BAD_SOURCE_DROP_TIME_2		HR2S(1)
#define MAX_BAD_SOURCE_DROP_TIME_2		HR2S(6)

#define MIN_BAD_SOURCE_DROP_TIME_3		MIN2S(30)
#define DEF_BAD_SOURCE_DROP_TIME_3		HR2S(1)
#define MAX_BAD_SOURCE_DROP_TIME_3		HR2S(6)

//NNP
#define MIN_NNP_SOURCE_LIMIT_1			MIN_SOURCE_LIMIT*8/10
#define DEF_NNP_SOURCE_LIMIT_1			FCFG_AUT // 320
#define MAX_NNP_SOURCE_LIMIT_1			MAX_SOURCE_LIMIT*8/10

#define MIN_NNP_SOURCE_LIMIT_2			15
#define DEF_NNP_SOURCE_LIMIT_2			25
#define MAX_NNP_SOURCE_LIMIT_2			50

#define MIN_NNP_SOURCE_LIMIT_3			MIN_SOURCE_LIMIT/2
#define DEF_NNP_SOURCE_LIMIT_3			FCFG_AUT // 80
#define MAX_NNP_SOURCE_LIMIT_3			MAX_SOURCE_LIMIT/2

#define MIN_NNP_SOURCE_DROP_TIME_1		(20)
#define DEF_NNP_SOURCE_DROP_TIME_1		(40)
#define MAX_NNP_SOURCE_DROP_TIME_1		(60)

#define MIN_NNP_SOURCE_DROP_TIME_2		MIN2S(1)
#define DEF_NNP_SOURCE_DROP_TIME_2		HR2S(1)
#define MAX_NNP_SOURCE_DROP_TIME_2		HR2S(6)

#define MIN_NNP_SOURCE_DROP_TIME_3		MIN2S(30)
#define DEF_NNP_SOURCE_DROP_TIME_3		HR2S(1)
#define MAX_NNP_SOURCE_DROP_TIME_3		HR2S(6)

//FullQ
#define MIN_FULLQ_SOURCE_LIMIT_1		MIN_SOURCE_LIMIT*8/10
#define DEF_FULLQ_SOURCE_LIMIT_1		FCFG_AUT // 320
#define MAX_FULLQ_SOURCE_LIMIT_1		MAX_SOURCE_LIMIT*8/10

#define MIN_FULLQ_SOURCE_LIMIT_2		15
#define DEF_FULLQ_SOURCE_LIMIT_2		25
#define MAX_FULLQ_SOURCE_LIMIT_2		50

#define MIN_FULLQ_SOURCE_LIMIT_3		MIN_SOURCE_LIMIT/2
#define DEF_FULLQ_SOURCE_LIMIT_3		FCFG_AUT // 80
#define MAX_FULLQ_SOURCE_LIMIT_3		MAX_SOURCE_LIMIT/2

#define MIN_FULLQ_SOURCE_DROP_TIME_1	(40)
#define DEF_FULLQ_SOURCE_DROP_TIME_1	(60)
#define MAX_FULLQ_SOURCE_DROP_TIME_1	(80)

#define MIN_FULLQ_SOURCE_DROP_TIME_2	MIN2S(1)
#define DEF_FULLQ_SOURCE_DROP_TIME_2	HR2S(1)
#define MAX_FULLQ_SOURCE_DROP_TIME_2	HR2S(6)

#define MIN_FULLQ_SOURCE_DROP_TIME_3	MIN2S(30)
#define DEF_FULLQ_SOURCE_DROP_TIME_3	HR2S(1)
#define MAX_FULLQ_SOURCE_DROP_TIME_3	HR2S(6)

//HighQ
#define MIN_HIGHQ_SOURCE_LIMIT_1		MIN_SOURCE_LIMIT*9/10
#define DEF_HIGHQ_SOURCE_LIMIT_1		FCFG_AUT // 360
#define MAX_HIGHQ_SOURCE_LIMIT_1		MAX_SOURCE_LIMIT*9/10

#define MIN_HIGHQ_SOURCE_LIMIT_2		25
#define DEF_HIGHQ_SOURCE_LIMIT_2		50
#define MAX_HIGHQ_SOURCE_LIMIT_2		75

#define MIN_HIGHQ_SOURCE_LIMIT_3		MIN_SOURCE_LIMIT/2
#define DEF_HIGHQ_SOURCE_LIMIT_3		FCFG_AUT // 80
#define MAX_HIGHQ_SOURCE_LIMIT_3		MAX_SOURCE_LIMIT/2

#define MIN_HIGHQ_SOURCE_DROP_TIME_1	(50)
#define DEF_HIGHQ_SOURCE_DROP_TIME_1	(90)
#define MAX_HIGHQ_SOURCE_DROP_TIME_1	(100)

#define MIN_HIGHQ_SOURCE_DROP_TIME_2	MIN2S(1)
#define DEF_HIGHQ_SOURCE_DROP_TIME_2	HR2S(1)
#define MAX_HIGHQ_SOURCE_DROP_TIME_2	HR2S(6)

#define MIN_HIGHQ_SOURCE_DROP_TIME_3	MIN2S(30)
#define DEF_HIGHQ_SOURCE_DROP_TIME_3	HR2S(1)
#define MAX_HIGHQ_SOURCE_DROP_TIME_3	HR2S(6)

#define MIN_HIGHQ_SOURCE_MAX_RANK_1		1000
#define DEF_HIGHQ_SOURCE_MAX_RANK_1		4000
#define MAX_HIGHQ_SOURCE_MAX_RANK_1		5000

#define MIN_HIGHQ_SOURCE_MAX_RANK_2		30
#define DEF_HIGHQ_SOURCE_MAX_RANK_2		60
#define MAX_HIGHQ_SOURCE_MAX_RANK_2		80

// dead source list
#define MIN_DEAD_TIME					DEF_DEAD_TIME
#define DEF_DEAD_TIME					15
#define MAX_DEAD_TIME					DEF_DEAD_TIME*4

#define MIN_DEAD_TIME_FW_MILTU			DEF_DEAD_TIME_FW_MILTU
#define DEF_DEAD_TIME_FW_MILTU			2
#define MAX_DEAD_TIME_FW_MILTU			DEF_DEAD_TIME_FW_MILTU*2

#define MIN_GLOBAL_DEAD_TIME			DEF_GLOBAL_DEAD_TIME
#define DEF_GLOBAL_DEAD_TIME			45
#define MAX_GLOBAL_DEAD_TIME			DEF_GLOBAL_DEAD_TIME*2

#define MIN_GLOBAL_DEAD_TIME_FW_MILTU	DEF_GLOBAL_DEAD_TIME_FW_MILTU
#define DEF_GLOBAL_DEAD_TIME_FW_MILTU	1
#define MAX_GLOBAL_DEAD_TIME_FW_MILTU	DEF_GLOBAL_DEAD_TIME_FW_MILTU*4
// NEO: SDT END

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
#define MIN_SOURCE_STORAGE_LIMIT		MIN_SOURCE_LIMIT
#define DEF_SOURCE_STORAGE_LIMIT		FCFG_AUT // 400
#define MAX_SOURCE_STORAGE_LIMIT		MAX_SOURCE_LIMIT

#define MIN_AUTO_SAVE_SOURCES_INTERVALS	MIN2S(15)
#define DEF_AUTO_SAVE_SOURCES_INTERVALS	MIN2S(30)
#define MAX_AUTO_SAVE_SOURCES_INTERVALS	MIN2S(120)

#define MIN_LOADED_SOURCE_CLEAN_UP_TIME	MIN2S(15)
#define DEF_LOADED_SOURCE_CLEAN_UP_TIME	MIN2S(30)
#define MAX_LOADED_SOURCE_CLEAN_UP_TIME	MIN2S(120)

#define MIN_SOURCE_STORAGE_REASK_LIMIT	5
#define DEF_SOURCE_STORAGE_REASK_LIMIT	FCFG_AUT // 100
#define MAX_SOURCE_STORAGE_REASK_LIMIT	250

 #ifdef NEO_SA // NEO: NSA - [NeoSourceAnalyzer]
#define MIN_REASK_PROPABILITY			10
#define DEF_REASK_PROPABILITY			10
#define MAX_REASK_PROPABILITY			75

#define MIN_UNPREDICTED_REASK_PROPABILITY	40
#define DEF_UNPREDICTED_REASK_PROPABILITY	50
#define MAX_UNPREDICTED_REASK_PROPABILITY	75
 #endif // NEO_SA // NEO: NSA END

#define MIN_AUTO_REASK_STORED_SOURCES_DELAY	0
#define DEF_AUTO_REASK_STORED_SOURCES_DELAY MIN2S(3)
#define MAX_AUTO_REASK_STORED_SOURCES_DELAY MIN2S(15)

#define MIN_STORED_SOURCE_GROUP_INTERVALS	10
#define DEF_STORED_SOURCE_GROUP_INTERVALS	20
#define MAX_STORED_SOURCE_GROUP_INTERVALS	120

#define MIN_STORED_SOURCE_GROUP_SIZE		3
#define DEF_STORED_SOURCE_GROUP_SIZE		20
#define MAX_STORED_SOURCE_GROUP_SIZE		120
#endif // NEO_SS // NEO: NSS END

#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
#define MIN_TABLE_AMOUT_TO_STORE	20
#define DEF_TABLE_AMOUT_TO_STORE	50
#define MAX_TABLE_AMOUT_TO_STORE	100

#define MIN_SOURCE_EXPIRATION_TIME	DAY2S(10)
#define DEF_SOURCE_EXPIRATION_TIME	DAY2S(30)
#define MAX_SOURCE_EXPIRATION_TIME	DAY2S(100)

#define MIN_FILE_EXPIRATION_TIME	DAY2S(3)
#define DEF_FILE_EXPIRATION_TIME	DAY2S(10)
#define MAX_FILE_EXPIRATION_TIME	DAY2S(30)

#define MIN_IGNORE_UNREACHABLE_INTERVAL MIN2S(30)
#define DEF_IGNORE_UNREACHABLE_INTERVAL MIN2S(60)
#define MAX_IGNORE_UNREACHABLE_INTERVAL MIN2S(180)

#define MIN_IGNORE_UNDEFINED_INTERVAL MIN2S(30)
#define DEF_IGNORE_UNDEFINED_INTERVAL MIN2S(120)
#define MAX_IGNORE_UNDEFINED_INTERVAL MIN2S(250)
#endif // NEO_CD // NEO: NCD END

#ifdef NEO_SA // NEO: NSA - [NeoSourceAnalyzer]
#define MIN_ANALISIS_INTERVALS	HR2S(2)
#define DEF_ANALISIS_INTERVALS	HR2S(6)
#define MAX_ANALISIS_INTERVALS	HR2S(24)

#define MIN_TABLE_AMOUT_TO_ANALISE	10
#define DEF_TABLE_AMOUT_TO_ANALISE	25
#define MAX_TABLE_AMOUT_TO_ANALISE	50

#define MIN_PRIORITY_GAP_RATIO	(int)(0.7F*100.0F)
#define DEF_PRIORITY_GAP_RATIO	(int)(0.6F*100.0F)
#define MAX_PRIORITY_GAP_RATIO  (int)(0.5F*100.0F)

#define MIN_MAX_GAP_SIZE	10
#define DEF_MAX_GAP_SIZE	20
#define MAX_MAX_GAP_SIZE	40

#define MIN_MAX_GAP_TIME	HR2S(2)
#define DEF_MAX_GAP_TIME	HR2S(6)
#define MAX_MAX_GAP_TIME	HR2S(12)

#define MIN_MAX_MIDLE_DISCREPANCE_HIGH	(int)(2.0F*100.0F)
#define DEF_MAX_MIDLE_DISCREPANCE_HIGH	(int)(4.0F*100.0F)
#define MAX_MAX_MIDLE_DISCREPANCE_HIGH	(int)(5.0F*100.0F)

#define MIN_MAX_MIDLE_DISCREPANCE_LOW	(int)(1.5F*100.0F)
#define DEF_MAX_MIDLE_DISCREPANCE_LOW	(int)(2.0F*100.0F)
#define MAX_MAX_MIDLE_DISCREPANCE_LOW	(int)(3.0F*100.0F)
		
#define MIN_DUAL_LINKED_TABLE_GRAVITY	2
#define DEF_DUAL_LINKED_TABLE_GRAVITY	2
#define MAX_DUAL_LINKED_TABLE_GRAVITY	4

#define MIN_VAL_ENHANCED_FACTOR	(int)(0.8F*100.0F)
#define DEF_VAL_ENHANCED_FACTOR	(int)(2.0F*100.0F)
#define MAX_VAL_ENHANCED_FACTOR	(int)(4.0F*100.0F)

#define MIN_FRESH_SOURCE_TRESHOLD	MIN2S(30)
#define DEF_FRESH_SOURCE_TRESHOLD	MIN2S(60)
#define MAX_FRESH_SOURCE_TRESHOLD	MIN2S(120)

#define MIN_TEMPORAL_IP_BORDERLINE	HR2S(6)
#define DEF_TEMPORAL_IP_BORDERLINE	HR2S(24)
#define MAX_TEMPORAL_IP_BORDERLINE	HR2S(48)

#define MIN_LAST_SEEN_DURATION_THRESHOLD	(int)(1.0F*100.0F)
#define DEF_LAST_SEEN_DURATION_THRESHOLD	(int)(3.0F*100.0F)
#define MAX_LAST_SEEN_DURATION_THRESHOLD	(int)(4.0F*100.0F)
		
#define MIN_LINK_TIME_THRESHOLD	MIN2S(30)
#define DEF_LINK_TIME_THRESHOLD	MIN2S(60)
#define MAX_LINK_TIME_THRESHOLD	MIN2S(120)

#define MIN_RELIABLE_TIME	HR2S(12)
#define DEF_RELIABLE_TIME	HR2S(18)
#define MAX_RELIABLE_TIME	HR2S(24)
#endif // NEO_SA // NEO: NSA END

#endif NEO_DEFAULTS

// NEO: NCFG END <-- Xanatos --