//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "HelpIDs.h"
#include "Opcodes.h"
#include "shellapi.h"
#include "Windows.h"
#include "PPgCredit.h"
#include "ClientCredits.h"
#include "PPgTweaks.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgCredit, CPropertyPage)

CPPgCredit::CPPgCredit()
	: CPropertyPage(CPPgCredit::IDD)
{
}

CPPgCredit::~CPPgCredit()
{
}

void CPPgCredit::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgCredit, CPropertyPage)

	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_BUTTON2, OnBnClickedButton2)
	ON_BN_CLICKED(IDC_RADIO1, OnBnClickedRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnBnClickedRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnBnClickedRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnBnClickedRadio4)
	ON_BN_CLICKED(IDC_RADIO5, OnBnClickedRadio5)
	ON_BN_CLICKED(IDC_ANTINICKTHIEF, OnBnClickedAntinickthief)
	ON_BN_CLICKED(IDC_ANTIMODTHIEF, OnBnClickedAntimodthief)
END_MESSAGE_MAP()


// CPPgCredit message handlers

BOOL CPPgCredit::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	LoadSettings();
	Localize();
	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgCredit::LoadSettings(void)
{	//Loads settings for preferences
	if(!thePrefs.UseCreditSystem()){
						  GetDlgItem(IDC_BUTTON2)->EnableWindow(true);
						  }
	//Equate protects thePrefs value from an exit without change equating a null value of creditsystem
	switch(creditsystem = thePrefs.creditsystem_tk4){
			case 0:	 CheckDlgButton(IDC_RADIO1, true);//eMule Std
					 break;
			case 1:	 CheckDlgButton(IDC_RADIO2, true);//Lovelace
					 break;
			case 2:	 CheckDlgButton(IDC_RADIO3, true);//Eastshare
					 break;
			case 3:
			default: CheckDlgButton(IDC_RADIO4, true);//TK4
					 break;
			case 4:  CheckDlgButton(IDC_RADIO5, true);//FINE
					 break;
	      }
	//Set antinickthief & antimodthief  state. Fix for 1.3c uninitilized local variables
	((CButton*)GetDlgItem(IDC_ANTINICKTHIEF))->SetCheck(antinick = thePrefs.AntiNickThief);
	((CButton*)GetDlgItem(IDC_ANTIMODTHIEF))->SetCheck(antimod = thePrefs.AntiModThief);
}

BOOL CPPgCredit::OnApply()
{	
    thePrefs.creditsystem_tk4 = creditsystem;
    thePrefs.AntiNickThief = antinick;
    thePrefs.AntiModThief = antimod;
	SetModified(TRUE);
	return CPropertyPage::OnApply();
}

void CPPgCredit::Localize(void)
{
	if(m_hWnd)
	{//Set dialog text
 	 GetDlgItem(IDC_STATIC_CREDITSTATUS)->SetWindowText(GetResString(IDS_STATIC_CREDITSTATUS));
	 if(thePrefs.UseCreditSystem()) GetDlgItem(IDC_STATIC_CREDITONOFF)->SetWindowText(GetResString(IDS_STATIC_CREDITON));
	   else {//If credit system is off disable all creditsytem related dialog items
		     GetDlgItem(IDC_STATIC_CREDITONOFF)->SetWindowText(GetResString(IDS_STATIC_CREDITOFF));
			 GetDlgItem(IDC_STATIC_CS)->EnableWindow(false);
			 GetDlgItem(IDC_RADIO1)->EnableWindow(false);
			 GetDlgItem(IDC_RADIO2)->EnableWindow(false);
			 GetDlgItem(IDC_RADIO3)->EnableWindow(false);
			 GetDlgItem(IDC_RADIO4)->EnableWindow(false);
			 GetDlgItem(IDC_RADIO5)->EnableWindow(false);
			 GetDlgItem(IDC_COMMENT1)->EnableWindow(false);
			 GetDlgItem(IDC_COMMENT2)->EnableWindow(false);
			 GetDlgItem(IDC_COMMENT3)->EnableWindow(false);
			 GetDlgItem(IDC_COMMENT4)->EnableWindow(false);
			 GetDlgItem(IDC_COMMENT5)->EnableWindow(false);
			}
	   
	 GetDlgItem(IDC_CREDIT_STATUS)->SetWindowText(GetResString(IDS_CREDIT_STATUS));
	 GetDlgItem(IDC_BUTTON2)->SetWindowText(GetResString(IDS_BUTTON2));
	 GetDlgItem(IDC_STATIC_CS)->SetWindowText(GetResString(IDS_STATIC_CS));
	 GetDlgItem(IDC_RADIO1)->SetWindowText(GetResString(IDS_RADIO1));
	 GetDlgItem(IDC_RADIO2)->SetWindowText(GetResString(IDS_RADIO2));
	 GetDlgItem(IDC_RADIO3)->SetWindowText(GetResString(IDS_RADIO3));
	 GetDlgItem(IDC_RADIO4)->SetWindowText(GetResString(IDS_RADIO4));
 	 GetDlgItem(IDC_RADIO5)->SetWindowText(GetResString(IDS_RADIO5));
	 GetDlgItem(IDC_COMMENT1)->SetWindowText(GetResString(IDS_COMMENT1));
	 GetDlgItem(IDC_COMMENT2)->SetWindowText(GetResString(IDS_COMMENT2));
	 GetDlgItem(IDC_COMMENT3)->SetWindowText(GetResString(IDS_COMMENT3));
	 GetDlgItem(IDC_COMMENT4)->SetWindowText(GetResString(IDS_COMMENT4));
	 GetDlgItem(IDC_COMMENT5)->SetWindowText(GetResString(IDS_COMMENT5));
	 GetDlgItem(IDC_ANTINICKTHIEF)->SetWindowText(GetResString(IDS_ANTINICKTHIEF));
	 GetDlgItem(IDC_ANTIMODTHIEF)->SetWindowText(GetResString(IDS_ANTIMODTHIEF));
     }
}



void CPPgCredit::OnHelp()
{
//	theApp.ShowHelp(eMule_FAQ_Preferences_VS);
}

BOOL CPPgCredit::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgCredit::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

void CPPgCredit::OnBnClickedButton2()
{//one click enable
  thePrefs.SetCreditSystem(true);//Turn on credit system
  GetDlgItem(IDC_STATIC_CREDITONOFF)->SetWindowText(GetResString(IDS_STATIC_CREDITON));//change text dialog
  GetDlgItem(IDC_BUTTON2)->EnableWindow(false); //disable button
  GetDlgItem(IDC_STATIC_CS)->EnableWindow(true);
  GetDlgItem(IDC_RADIO1)->EnableWindow(true);
  GetDlgItem(IDC_RADIO2)->EnableWindow(true);
  GetDlgItem(IDC_RADIO3)->EnableWindow(true);
  GetDlgItem(IDC_RADIO4)->EnableWindow(true);
  GetDlgItem(IDC_RADIO5)->EnableWindow(true);
  GetDlgItem(IDC_COMMENT1)->EnableWindow(true);
  GetDlgItem(IDC_COMMENT2)->EnableWindow(true);
  GetDlgItem(IDC_COMMENT3)->EnableWindow(true);
  GetDlgItem(IDC_COMMENT4)->EnableWindow(true);
  GetDlgItem(IDC_COMMENT5)->EnableWindow(true);
 
}

void CPPgCredit::OnBnClickedRadio1()
{   //Set credit system 0 std system
	creditsystem = 0;
	SetModified(TRUE);

}
void CPPgCredit::OnBnClickedRadio2()
{   //Set credit system 1 Lovelace
	creditsystem = 1;
	SetModified(TRUE);

}
void CPPgCredit::OnBnClickedRadio3()
{   //Set credit system 2 Eastshare
	creditsystem = 2;
	SetModified(TRUE);

}
void CPPgCredit::OnBnClickedRadio4()
{   //Set credit system 3 TK4 - Default
	creditsystem = 3;
	SetModified(TRUE);

}

void CPPgCredit::OnBnClickedRadio5()
{
 //Set credit system 4 FINE
	creditsystem = 4;
	SetModified(TRUE);
}

void CPPgCredit::OnBnClickedAntinickthief()
{//enable/disable Wizard's anti-nick thief
 if(IsDlgButtonChecked(IDC_ANTINICKTHIEF)) antinick = true;
   else antinick = false;
 SetModified(TRUE);
}

void CPPgCredit::OnBnClickedAntimodthief()
{//enable/disable Wizard's anti-mod thief
 if(IsDlgButtonChecked(IDC_ANTIMODTHIEF)) antimod = true;
   else antimod = false;
 SetModified(TRUE);
}
