//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "neo/modeless.h"
#include "enbitmap.h"
#include "GDIPlusUtil.h" // X: [GPUI] - [GDI Plus UI]
/*
enum EGraphType{
	GT_RECT,
	GT_ELLIPSE
};
*/
class CSpeedGraph
{
public:
	CSpeedGraph(); 
	~CSpeedGraph();
	void Init(/*EGraphType _type, */bool _overlap, const CRect&_region, INT unit, ARGB c_Color1, ARGB c_Color2);
	void InitArray();
	bool Set_TrafficValue(uint32 value);
	void DrawGraph(Graphics&g);
private:
	uint32* TrafficStats;
	uint_ptr	TrafficEntries;
	CRect	region;
	ARGB	Color1;
	ARGB	Color2;
	int		lastvalid;
	//EGraphType	type;
	bool	overlap;
public:
	uint32	m_ui_MaxAmount;
};

// CSpeedGraphWnd dialog
class CMainFrameDropTarget;

class CSpeedGraphWnd : public CModDialog
{
	//DECLARE_DYNCREATE(CSpeedGraphWnd)

public:
	CSpeedGraphWnd();   // standard constructor
	virtual ~CSpeedGraphWnd();
	enum { IDD = IDD_SPEEDGRAPH };
	// X-Ray :: Speedgraph :: Start 
	void Update_TrafficGraph();
	void SetUSpeedMeterRange(uint32 iValue){m_co_UpTrafficGraph.m_ui_MaxAmount = iValue*1024;}
	void SetDSpeedMeterRange(uint32 iValue){m_co_DownTrafficGraph.m_ui_MaxAmount = iValue*1024;}
	// X-Ray :: Speedgraph :: End
	void LoadConfiguration(LPCTSTR pszFilePath);

protected:	
	virtual BOOL OnInitDialog();
	DECLARE_MESSAGE_MAP()
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* /*pWnd*/, CPoint point);
	afx_msg void OnDestroy();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	void CreateDefaultImage();
	void DrawWindow();
	CSpeedGraph m_co_UpTrafficGraph;
	CSpeedGraph m_co_DownTrafficGraph;
	CMainFrameDropTarget* m_pDropTarget;
	CEnBitmap m_bgimg;
	BLENDFUNCTION blendPixelFunction;
	CString StrText;
	CPoint	ptText;
	ARGB	ColorText;
	REAL	TextSize;
	bool	textoverlap;

};
