//this file is part of eMule
//Copyright (C)2010 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "emuleDlg.h"
#include "PPgMOD2.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Opcodes.h"
/*
// NEO: PP - [Family filter] -- Xanatos -->
#include "InputBox.h"
#include "MD5Sum.h"
#include "Knownfile.h"
// NEO: PP END <-- Xanatos --
*/
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgMOD2, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgMOD2, CPropertyPage)
/*
	//Ackronic START - Aggiunto da Aenarion[ITA] - Family Filter
	ON_BN_CLICKED(IDC_FF_CHK, OnClickButton)
	ON_BN_CLICKED(IDC_FF2_CHK, OnSettingsChange)
	ON_BN_CLICKED(IDC_CHANGE_PASSFF, OnBnClickedChangePassff)
	//Ackronic END - Aggiunto da Aenarion[ITA] - Family Filter
	ON_BN_CLICKED(IDC_CHKLOWIDNOTIFIER, OnSettingsChange)//Low-id notifier

// Contrib - invisible mode
	// eF-Mod :: InvisibleMode
	ON_CBN_SELCHANGE(IDC_INVISIBLE_MODE_SELECT_COMBO, OnSettingsChange) 
	ON_CBN_SELCHANGE(IDC_INVISIBLE_MODE_KEY_COMBO, OnCbnSelchangeKeymodcombo) 
	ON_BN_CLICKED(IDC_INVISIBLE_MODE, OnBoxesChange) 
	ON_BN_CLICKED(IDC_INVISIBLE_ONSTART, OnBoxesChange)	//>>> [ionix] - StartUp InvisibleMode Enhancement
	// eF-Mod end
// <-------- invisible mode
*/
	ON_WM_HSCROLL()
	ON_WM_DESTROY()

END_MESSAGE_MAP()

CPPgMOD2::CPPgMOD2()
	: CPropertyPage(CPPgMOD2::IDD)
{
	Slots = thePrefs.GetSlots(); //>>> taz::Slot Control
}

CPPgMOD2::~CPPgMOD2()
{
}

void CPPgMOD2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_UP_SLOTS_SLIDER, m_ctlSlots);
}

BOOL CPPgMOD2::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
/*
// Contrib - invisible mode
	// eF-Mod :: InvisibleMode
	// Add keys to ComboBox 
	for(int i='A'; i<='Z'; i++) 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_SELECT_COMBO))->AddString(CString((TCHAR)(i))); 
	for(int i='0'; i<='9'; i++) 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_SELECT_COMBO))->AddString(CString((TCHAR)(i))); 
	// eF-Mod end
// <-------- invisible mode
*/
	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgMOD2::LoadSettings(void)
{
	if (m_hWnd)
	{
/*
		//DkD - [lowid notifier] by chamblard
		CheckDlgButton(IDC_CHKLOWIDNOTIFIER, thePrefs.m_bShowLowID);
		//Ackronic START - Aggiunto da Aenarion[ITA] - Family Filter
		CheckDlgButton(IDC_FF_CHK, thePrefs.m_bFamilyFilter);
		CheckDlgButton(IDC_FF2_CHK, thePrefs.m_bFakeFilter);
		GetDlgItem(IDC_CHANGE_PASSFF)->EnableWindow(thePrefs.m_isPWProtShow);
		//Ackronic END - Aggiunto da Aenarion[ITA] - Family Filter
*/
//>>> taz::Slot Control
		uint32 MaxUpSpeed = (thePrefs.maxupload==UNLIMITED)?thePrefs.GetMaxGraphUploadRate(true):thePrefs.maxupload;
		m_ctlSlots.SetRange(1, (int) floor(MaxUpSpeed / 1.5));
		Slots = thePrefs.GetSlots();
		m_ctlSlots.SetPos(Slots);
//<<< taz::Slot Control
/*
// Contrib - invisible mode
	// eF-Mod :: InvisibleMode
		m_iActualKeyModifier = thePrefs.GetInvisibleModeHKKeyModifier(); 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_SELECT_COMBO))->SelectString(-1, CString(thePrefs.GetInvisibleModeHKKey())); 
		if (!thePrefs.GetInvisibleMode()){ 
			GetDlgItem(IDC_INVISIBLE_MODE_SELECT_STATIC)->EnableWindow(false); 
			GetDlgItem(IDC_INVISIBLE_MODE_MODIFIER_STATIC)->EnableWindow(false); 
			GetDlgItem(IDC_INVISIBLE_MODE_KEY_STATIC)->EnableWindow(false); 
			GetDlgItem(IDC_INVISIBLE_MODE_SYMBOL_STATIC)->EnableWindow(false); 
			GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO)->EnableWindow(false); 
			GetDlgItem(IDC_INVISIBLE_MODE_SELECT_COMBO)->EnableWindow(false); 
			CheckDlgButton(IDC_INVISIBLE_MODE, 0); 
			GetDlgItem(IDC_INVISIBLE_ONSTART)->EnableWindow(false); 
		} else 
			CheckDlgButton(IDC_INVISIBLE_MODE, 1); 

		CheckDlgButton(IDC_INVISIBLE_ONSTART, thePrefs.IsStartInvisible());
		// eF-Mod end
// <-------- invisible mode
*/
	}
}

BOOL CPPgMOD2::OnApply()
{
	if (!UpdateData())
		return FALSE;

///////////
//>>> taz::Slot Control
	thePrefs.SetSlots(Slots);
//>>> taz::adjust (if upload connection setting changed)
	uint32 MaxUpSpeed = (thePrefs.maxupload==UNLIMITED)?thePrefs.GetMaxGraphUploadRate(true):thePrefs.maxupload;
	m_ctlSlots.SetRange(1, (int) floor(MaxUpSpeed / 1.5) , TRUE);
	Slots = thePrefs.GetSlots();
	m_ctlSlots.SetPos(Slots);

	CString temp;

	temp.Format(L"%u", Slots);
	GetDlgItem(IDC_UP_SLOTS)->SetWindowText(temp);
	if(Slots == 1)
		temp.Format(L"%s", GetResString(IDS_MOD_SLOTFOCUS));
	else {
		temp.Format(L"%u",(MaxUpSpeed*1024)/Slots);
		GetDlgItem(IDC_UP_DR_PER_CLIENT2)->SetWindowText(L"bps");
	}
	GetDlgItem(IDC_UP_DR_PER_CLIENT)->SetWindowText(temp);
//<<< taz::adjust
//<<< taz::Slot Control
///////////
/*
	GetDlgItem(IDC_CHANGE_PASSFF)->EnableWindow(thePrefs.m_isPWProtShow);

	//DkD - [lowid notifier] by chamblard
	thePrefs.m_bShowLowID = IsDlgButtonChecked(IDC_CHKLOWIDNOTIFIER)!= 0;
	//Ackronic START - Aggiunto da Aenarion[ITA] - Family Filter
	thePrefs.m_bFakeFilter = IsDlgButtonChecked(IDC_FF2_CHK) != 0;
	//Ackronic END - Aggiunto da Aenarion[ITA] - Family Filter

// Contrib - invisible mode
	// eF-Mod :: InvisibleMode
	CString sKey; 
	((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_SELECT_COMBO))->GetLBText(((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_SELECT_COMBO))->GetCurSel(), sKey); 
	if (IsDlgButtonChecked(IDC_INVISIBLE_MODE)!=0) 
		thePrefs.SetInvisibleMode(true,m_iActualKeyModifier,(char)sKey[0]); 
	else 
		thePrefs.SetInvisibleMode(false,m_iActualKeyModifier,(char)sKey[0]); 

	thePrefs.m_bStartInvisible = IsDlgButtonChecked(IDC_INVISIBLE_ONSTART)!=0;
	// eF-Mod end
// <-------- invisible mode
*/
	SetModified(FALSE);
	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgMOD2::Localize(void)
{
	if (m_hWnd)
	{
/*
		//Ackronic START - Aggiunto da Aenarion[ITA] - Family Filter
        GetDlgItem(IDC_FF_GROUP)->SetWindowText(GetResString(IDS_FF_GROUP));

// Contrib - family filter
		GetDlgItem(IDC_FF_CHK)->SetWindowText(GetResString(IDS_ACTIVATE_FF));
//		GetDlgItem(IDC_FF_LBL)->SetWindowText(GetResString(IDS_FILTERED_EXPRESSIONS_FF));
		GetDlgItem(IDC_CHANGE_PASSFF)->SetWindowText(GetResString(IDS_CHANGE_PASSFF));
// <-------- family filter

// Contrib - trash filter
		GetDlgItem(IDC_FF2_CHK)->SetWindowText(GetResString(IDS_ACTIVATE_FF2));
// <-------- trash filter

		//Ackronic END  - Aggiunto da Aenarion[ITA] - Family Filter

		//DkD - [lowid notifier] by chamblard
        GetDlgItem(IDC_CHKLOWIDNOTIFIER)->SetWindowText(GetResString(IDS_ACTIVATELOWIDNOTIFIER));
*/
//>>> taz::Slot Control
		//Upload slots
/*
		if(Slots == 1)
			GetDlgItem(IDC_UP_DR_PER_CLIENT2)->SetWindowText(L"");
		else
			GetDlgItem(IDC_UP_DR_PER_CLIENT2)->SetWindowText(L"bps");
*/
		GetDlgItem(IDC_UP_SLOTS_LABEL)->SetWindowText(GetResString(IDS_UP_SLOTS));
		GetDlgItem(IDC_UP_DR_PER_CLIENT_LABEL)->SetWindowText(GetResString(IDS_UP_SPEED_PER_CLIENT));
		//end up slots

		CString temp;
		uint32 MaxUpSpeed = (thePrefs.maxupload==UNLIMITED)?thePrefs.GetMaxGraphUploadRate(true):thePrefs.maxupload;
		Slots = thePrefs.GetSlots();

		temp.Format(L"%u", Slots);
		GetDlgItem(IDC_UP_SLOTS)->SetWindowText(temp);
		if(Slots == 1)
			temp.Format(L"%s", GetResString(IDS_MOD_SLOTFOCUS));
		else {
			temp.Format(L"%u",(MaxUpSpeed*1024)/Slots);
			GetDlgItem(IDC_UP_DR_PER_CLIENT2)->SetWindowText(L"bps");
		}
		GetDlgItem(IDC_UP_DR_PER_CLIENT)->SetWindowText(temp);
//<<< taz::Slot Control
/*
// Contrib - invisible mode
		// eF-Mod :: InvisibleMode
		// Add key modifiers to ComboBox 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->ResetContent(); 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->AddString(GetResString(IDS_CTRLKEY)); 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->AddString(GetResString(IDS_ALTKEY)); 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->AddString(GetResString(IDS_SHIFTKEY)); 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->AddString(GetResString(IDS_CTRLKEY) + L" + " + GetResString(IDS_ALTKEY)); 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->AddString(GetResString(IDS_CTRLKEY) + L" + " + GetResString(IDS_SHIFTKEY)); 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->AddString(GetResString(IDS_ALTKEY) + L" + " + GetResString(IDS_SHIFTKEY)); 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->AddString(GetResString(IDS_CTRLKEY) + L" + " + GetResString(IDS_ALTKEY) + L" + " + GetResString(IDS_SHIFTKEY)); 

		CString key_modifier; 
		if (m_iActualKeyModifier & MOD_CONTROL) 
			key_modifier=GetResString(IDS_CTRLKEY); 
		if (m_iActualKeyModifier & MOD_ALT){ 
			if (!key_modifier.IsEmpty()) key_modifier += L" + "; 
			key_modifier+=GetResString(IDS_ALTKEY); 
		} 
		if (m_iActualKeyModifier & MOD_SHIFT){ 
			if (!key_modifier.IsEmpty()) key_modifier += L" + "; 
			key_modifier+=GetResString(IDS_SHIFTKEY); 
		} 
		((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->SelectString(-1,key_modifier); 

		GetDlgItem(IDC_INVISIBLE_MODE_GROUP_BOX)->SetWindowText(GetResString(IDS_INVMODE_GROUP)); 
		GetDlgItem(IDC_INVISIBLE_MODE)->SetWindowText(GetResString(IDS_INVMODE)); 
		GetDlgItem(IDC_INVISIBLE_MODE_SELECT_STATIC)->SetWindowText(GetResString(IDS_INVMODE_HOTKEY)); 
		GetDlgItem(IDC_INVISIBLE_MODE_MODIFIER_STATIC)->SetWindowText(GetResString(IDS_INVMODE_MODKEY)); 
		GetDlgItem(IDC_INVISIBLE_MODE_KEY_STATIC)->SetWindowText(GetResString(IDS_INVMODE_VKEY)); 
		GetDlgItem(IDC_INVISIBLE_ONSTART)->SetWindowText(GetResString(IDS_INVMODE_ONSTART)); 
		// eF-Mod end
// <-------- invisible mode
*/
	}
}

//>>> taz::slot control
void CPPgMOD2::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	SetModified(TRUE);

	if (pScrollBar->GetSafeHwnd() == m_ctlSlots.m_hWnd)
	{
		Slots = (uint16)m_ctlSlots.GetPos();
		CString temp;

		temp.Format(L"%u",Slots);
		GetDlgItem(IDC_UP_SLOTS)->SetWindowText(temp);
		if(Slots == 1){
			GetDlgItem(IDC_UP_DR_PER_CLIENT2)->SetWindowText(L"");
			temp.Format(GetResString(IDS_MOD_SLOTFOCUS));
		}else{
			uint32 MaxUpSpeed = (thePrefs.maxupload==UNLIMITED)?thePrefs.GetMaxGraphUploadRate(true):thePrefs.maxupload;

			GetDlgItem(IDC_UP_DR_PER_CLIENT2)->SetWindowText(L"bps");
			temp.Format(L"%u",(MaxUpSpeed*1024)/Slots);
		}
		GetDlgItem(IDC_UP_DR_PER_CLIENT)->SetWindowText(temp);
/*
		temp.Format(L"%u",Slots);
		GetDlgItem(IDC_UP_SLOTS)->SetWindowText(temp);
		if(Slots == 1){
			temp.Format(L"%s", GetResString(IDS_MOD_SLOTFOCUS));
		}
		else{
			uint32 MaxUpSpeed = (thePrefs.maxupload==UNLIMITED)?thePrefs.maxGraphUploadRate:thePrefs.maxupload;

			temp.Format(L"%u bps", (MaxUpSpeed*1024)/Slots);
		}
		GetDlgItem(IDC_UP_DR_PER_CLIENT)->SetWindowText(temp);
*/
		SetModified(TRUE);
	}

	UpdateData(false);
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}
//<<< taz::Slot Control
/*
void CPPgMOD2::OnClickButton()
{
	if(thePrefs.m_sPassFF.IsEmpty() || !thePrefs.m_isPWProtShow){

	InputBox inputbox1;
	CString pass1 = L"";

	inputbox1.SetLabels(GetResString(IDS_FAMILY_FILTER),GetResString(IDS_NEWPASS), L"");
	inputbox1.SetPassword(true);

	if (inputbox1.DoModal() == IDOK)
		pass1=inputbox1.GetInput();
	else
		return;

	if(pass1.GetLength() > 0)
	{
		thePrefs.SetPWProtShow(true);
		thePrefs.m_sPassFF=MD5Sum(pass1).GetHash().GetBuffer(0);
	}
	else
		return;

	}

	if(thePrefs.m_isPWProtShow==true)
	{
		InputBox inputbox;
		CString pass;
		inputbox.SetLabels(GetResString(IDS_FAMILY_FILTER),GetResString(IDS_CONFIRMPASS), L"");
		inputbox.SetPassword(true);
		if (inputbox.DoModal() == IDOK && inputbox.GetInput().GetLength() > 0){
			pass=inputbox.GetInput();
			pass=MD5Sum(pass).GetHash().GetBuffer(0);

			if(thePrefs.GetPassFF() == pass){
				thePrefs.m_bFamilyFilter = IsDlgButtonChecked(IDC_FF_CHK) !=0;
				SetModified(TRUE);
			}
			else SetModified(FALSE);
		}
		else SetModified(FALSE);
	}
}

void CPPgMOD2::OnBnClickedChangePassff()
{
	if(thePrefs.m_sPassFF.IsEmpty() || !thePrefs.m_isPWProtShow)
	{
		AfxMessageBox(GetResString(IDS_NONCEPASS) ,MB_OK);
		return;
	}
	InputBox inputbox;
	CString pass;
	inputbox.SetLabels(GetResString(IDS_FAMILY_FILTER),GetResString(IDS_CHANGEPASS), L"");
	inputbox.SetPassword(true);
	if (inputbox.DoModal() == IDOK) {

		if(inputbox.GetInput().GetLength() > 0){
			pass=inputbox.GetInput();
			pass=MD5Sum(pass).GetHash().GetBuffer(0);

			if(thePrefs.GetPassFF() == pass){
				InputBox inputbox1;
				CString pass1 = L"";
				inputbox1.SetLabels(GetResString(IDS_FAMILY_FILTER),GetResString(IDS_CHANGEORDELETEPASS), L"");
				inputbox1.SetPassword(true);

				if (inputbox1.DoModal() == IDOK){
					pass1=inputbox1.GetInput();
				}
				else
					return;

				if(pass1.GetLength() > 0)
				{
					thePrefs.m_sPassFF=MD5Sum(pass1).GetHash().GetBuffer(0);
				}
			}
		}
	}
}

// Contrib - invisible mode
// eF-Mod :: InvisibleMode
void CPPgMOD2::SetBoxes() 
{     
	bool bImode = IsDlgButtonChecked(IDC_INVISIBLE_MODE)!=0; 

	GetDlgItem(IDC_INVISIBLE_MODE_SELECT_STATIC)->EnableWindow(bImode); 
	GetDlgItem(IDC_INVISIBLE_MODE_MODIFIER_STATIC)->EnableWindow(bImode); 
	GetDlgItem(IDC_INVISIBLE_MODE_KEY_STATIC)->EnableWindow(bImode); 
	GetDlgItem(IDC_INVISIBLE_MODE_SYMBOL_STATIC)->EnableWindow(bImode); 
	GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO)->EnableWindow(bImode); 
	GetDlgItem(IDC_INVISIBLE_MODE_SELECT_COMBO)->EnableWindow(bImode); 
	GetDlgItem(IDC_INVISIBLE_ONSTART)->EnableWindow(bImode); 

	SetModified(); 
} 

void CPPgMOD2::OnCbnSelchangeKeymodcombo() 
{ 
	CString sKeyMod; 

	((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->GetLBText(((CComboBox*)GetDlgItem(IDC_INVISIBLE_MODE_KEY_COMBO))->GetCurSel(), sKeyMod); 
	m_iActualKeyModifier = 0; 
	if (sKeyMod.Find(GetResString(IDS_CTRLKEY))!=-1) 
		m_iActualKeyModifier |= MOD_CONTROL; 
	if (sKeyMod.Find(GetResString(IDS_ALTKEY))!=-1) 
		m_iActualKeyModifier |= MOD_ALT; 
	if (sKeyMod.Find(GetResString(IDS_SHIFTKEY))!=-1) 
		m_iActualKeyModifier |= MOD_SHIFT; 

	SetModified(); 
} 
// eF-Mod end
// <-------- invisible mode
*/