//////////////////////////////////////////////////////////////////////////
// This is a clean prefpage with a treeoption control 
// I avoided unnecessary code obfuscation as good as possible
#include "stdafx.h"
#include "emule.h"
#include "PPgeMuleFuture.h"
#include "./AntiLeech/Modname.h"
#include "UserMsgs.h"
#include "otherfunctions.h"
#include "UploadQueue.h" // VQB: fullChunk
//>>> WiZaRd::AutoHL
#include "PartFile.h"
#include "DownloadQueue.h" 
//<<< WiZaRd::AutoHL
#ifdef MOD_FUNCTIONS
//>>> WiZaRd::PNCheck/EMF
#include "eMuleFuture.h"
#include "ChatWnd.h"
#include "FriendListCtrl.h"
//<<< WiZaRd::PNCheck/EMF
#endif
#include "emuleDlg.h" //>>> WiZaRd::PNCheck/EMF
#include "MenuCmds.h" //>>> WiZaRd::PNCheck/EMF //>>> WiZaRd:EMF Link
#include "./ConChecker/ConChecker.h" //>>> WiZaRd::ConChecker [eWombat]
#include "EMF/IP2Country.h"	//>>> shadow2004::IP2Country [EastShare]
//>>> WiZaRd::XP-Menues
#include "TransferDlg.h"
#include "DownloadListCtrl.h"
#include "SearchDlg.h"
#include "SearchListCtrl.h"
#include "SharedFilesWnd.h"
#include "SharedFilesCtrl.h"
#include "SharedDirsTreeCtrl.h"
//<<< WiZaRd::XP-Menues

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef MOD_FUNCTIONS
#define HIDDEN_PASSWORD		(L"*****") //>>> WiZaRd::PNCheck/EMF
#endif

///////////////////////////////////////////////////////////////////////////////
// CPPgeMuleFuture dialog

IMPLEMENT_DYNAMIC(CPPgeMuleFuture, CPropertyPage)
BEGIN_MESSAGE_MAP(CPPgeMuleFuture, CPropertyPage)
	ON_WM_DESTROY()
	ON_MESSAGE(UM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgeMuleFuture::CPPgeMuleFuture()
: CPropertyPage(CPPgeMuleFuture::IDD)
, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	m_bInitializedTreeOpts = false;
	Nullify();
}

CPPgeMuleFuture::~CPPgeMuleFuture()
{
}

void CPPgeMuleFuture::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EMULEFUTURE_OPTS, m_ctrlTreeOptions);
	CString buffer;
	if (!m_bInitializedTreeOpts)
	{
		int iImgDynup = 8;
		int iImgConnection = 8;
#ifdef MOD_FUNCTIONS
		int iImgWiZ = 8;
#endif
		int iImgEmulate = 8;
		int iImgAutoHL = 8;
		int iImgDisplay = 8;
		int iImgXPMenu = 8;			//>>> shadow2004::XPMenu [TPT]
		int iImgXPMenuStyle = 8;	//>>> shadow2004::XPMenu [TPT]
		int iImgDiB = 8;		//>>> WiZaRd/shadow2004::DL in Bold
		int	iImgI2C = 8;		//>>> shadow2004::IP2Country [EastShare]
		int	iImgSLS = 8;		//>>> JvA::SLS [enkeyDEV]
		int iImgFDC = 8;		//>>> shadow2004::FDC [BlueSonicBoy]
		int iImgSystem = 8; 
//>>> WiZaRd::IntelliFlush
		int iImgFileBuffer = 8;
//<<< WiZaRd::IntelliFlush

		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml)
		{
			iImgDynup		=	piml->Add(CTempIconLoader(L"UPLOAD"));
			iImgConnection	=	piml->Add(CTempIconLoader(L"connection"));
#ifdef MOD_FUNCTIONS
			iImgWiZ			=	piml->Add(CTempIconLoader(L"WIZARD"));
#endif
			iImgEmulate		=	piml->Add(CTempIconLoader(L"EMULATE"));
			iImgAutoHL		=	piml->Add(CTempIconLoader(L"PRIO_AUTO"));
			iImgDisplay		=	piml->Add(CTempIconLoader(L"DISPLAY"));
			iImgXPMenu		=	piml->Add(CTempIconLoader(L"SAMEMOD"));	//>>> shadow2004::XPMenu [TPT]
			iImgXPMenuStyle	=	piml->Add(CTempIconLoader(L"DISPLAY"));	//>>> shadow2004::XPMenu [TPT]
			iImgDiB			=	piml->Add(CTempIconLoader(L"BOLD")); //>>> WiZaRd/shadow2004::DL in Bold
			iImgI2C			=	piml->Add(CTempIconLoader(L"SEARCHMETHOD_GLOBAL")); //>>> shadow2004::IP2Country [EastShare]
			iImgSLS			=	piml->Add(CTempIconLoader(L"SLS"));	//>>> JvA::SLS [enkeyDEV]
			iImgFDC			=	piml->Add(CTempIconLoader(L"SPAM"));	//>>> shadow2004::FDC [BlueSonicBoy]
			iImgSystem		=	piml->Add(CTempIconLoader(L"TWEAK"));
			iImgFileBuffer	=	piml->Add(CTempIconLoader(L"HARDDISK")); //>>> WiZaRd::IntelliFlush
		}

#ifdef MOD_FUNCTIONS
//>>> WiZaRd::PNCheck/EMF
		m_htiEMFSupport = m_ctrlTreeOptions.InsertGroup(MOD_BOARD_URL, iImgWiZ, TVI_ROOT);
		m_htiUserName = m_ctrlTreeOptions.InsertItem(GetResString(IDS_QL_USERNAME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiEMFSupport);
		m_ctrlTreeOptions.AddEditBox(m_htiUserName, RUNTIME_CLASS(CTreeOptionsEditEx));
		m_htiUserPW = m_ctrlTreeOptions.InsertItem(GetResString(IDS_WS_PASS), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiEMFSupport);
		m_ctrlTreeOptions.AddEditBox(m_htiUserPW, RUNTIME_CLASS(CTreeOptionsEditEx));
		CTreeOptionsItemData* data = (CTreeOptionsItemData*)m_ctrlTreeOptions.GetItemData(m_htiUserPW);
		if(data)
			data->m_bPassword = true;
		else
			ASSERT(0);
		m_htiCheckPNs = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMF_CHECKPNS), m_htiEMFSupport, m_bCheckPNs);
		m_htiFriendsEntry = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMF_FRIENDSOPT), m_htiEMFSupport, m_bFriendsEntry);
		m_htiAutoUpdateFriends = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMF_AUTOUPDATEFRIENDS), m_htiEMFSupport, m_bAutoUpdateFriends);
//<<< WiZaRd::PNCheck/EMF
#endif

		//////////////////////////////////////////////////////////////////////////
		// System tweaks
		//
		m_htiSystemGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SYSTEM), iImgSystem, TVI_ROOT);
//>>> WiZaRd::IntelliFlush
		m_htiFileBufferGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_FILEBUFFER), iImgFileBuffer, m_htiSystemGroup);
		buffer.Format(L"%s [%s]", GetResString(IDS_FILEBUFFERSIZE), GetResString(IDS_KBYTES));
		m_htiFileBufferSize = m_ctrlTreeOptions.InsertItem(buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFileBufferGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFileBufferSize, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiFileBufferTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_FILEBUFFER_TIME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFileBufferGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFileBufferTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
//		m_htiIntelliFlushCheck = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_FILEBUFFER_INTELLI), m_htiFileBufferGroup, m_bIntelliFlush || m_iFileBufferTime < 1 || m_iFileBufferTime > 5);
//<<< WiZaRd::IntelliFlush
//>>> taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
		m_htiASFUGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_ASFU), iImgConnection, m_htiSystemGroup);
		m_htiASFURadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_ASFU_METHOD), iImgSystem, m_htiASFUGroup);
		m_htiASFUOff = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_OFF), m_htiASFURadio, m_uiDirectoryWatcherMode == ASFU_OFF);
		m_htiASFUOn = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_ASFU_DEFAULT), m_htiASFURadio, m_uiDirectoryWatcherMode == ASFU_DEFAULT);
		m_htiASFUfreq1 = m_ctrlTreeOptions.InsertItem(GetResString(IDS_ASFU_FREQ1), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiASFUOn);
		m_ctrlTreeOptions.AddEditBox(m_htiASFUfreq1, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiASFUSimple = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_ASFU_SIMPLE), m_htiASFURadio, m_uiDirectoryWatcherMode == ASFU_SIMPLE);
		m_htiASFUfreq2 = m_ctrlTreeOptions.InsertItem(GetResString(IDS_ASFU_FREQ2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiASFUSimple);
		m_ctrlTreeOptions.AddEditBox(m_htiASFUfreq2, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
//>>> WiZaRd::ConChecker [eWombat]
		m_htiConcheckerGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_CONCHECKER), iImgConnection, m_htiSystemGroup);
		m_htiConcheckerActive = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CONCHECKER_ACTIVE), m_htiConcheckerGroup, m_bConcheckerActive);
		m_htiConcheckerPingtypeRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_CONCHECKER_PINGMETHOD), iImgSystem, m_htiConcheckerGroup);
		m_htiConcheckerPingICMP = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CONCHECKER_ICMP), m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype == 0);
		m_htiConcheckerPingRAW = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CONCHECKER_RAW), m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype == 1);
		m_htiConcheckerTTL = m_ctrlTreeOptions.InsertItem(GetResString(IDS_CONCHECKER_TTL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiConcheckerGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiConcheckerTTL, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiConcheckerPingtimeout = m_ctrlTreeOptions.InsertItem(GetResString(IDS_CONCHECKER_TIMEOUT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiConcheckerGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiConcheckerPingtimeout, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< WiZaRd::ConChecker [eWombat]

		/////////////////////////////////////////////////////////////////////////////
		// More tweaks group
		//
		m_htiMoreTweaksGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PW_MISC), iImgConnection, TVI_ROOT);
		m_htiMultipleInstances = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MULTIPLE_INSTANCES), m_htiMoreTweaksGroup, m_bMultipleInstances);
//>>> WiZaRd::Small File Slot
		m_htiSmallFileSize = m_ctrlTreeOptions.InsertItem(GetResString(IDS_SMALL_FILE_SIZE), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiMoreTweaksGroup); 
		m_ctrlTreeOptions.AddEditBox(m_htiSmallFileSize, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< WiZaRd::Small File Slot
//>>> WiZaRd::Intelligent SOTN
		m_htiSOTNRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SOTN), iImgDynup, m_htiMoreTweaksGroup);				
		m_htiSOTNOFF = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_GLOBAL_OFF), m_htiSOTNRadio, m_iSOTN == 0);
		m_htiSOTNON = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_GLOBAL_ON), m_htiSOTNRadio, m_iSOTN == 1);
		m_htiSOTNPerFile = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PER_FILE), m_htiSOTNRadio, m_iSOTN == 2);
//<<< WiZaRd::Intelligent SOTN
//>>> WiZaRd::AutoHL
		m_htiAutoHL = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_AUTOHL), iImgAutoHL, m_htiMoreTweaksGroup);
		m_htiUseAutoHLRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_USE_AUTOHL), iImgDynup, m_htiAutoHL);
		m_htiUseAutoHLOff = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_GLOBAL_OFF), m_htiUseAutoHLRadio, m_iUseAutoHL == 0);
		m_htiUseAutoHLOn = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_GLOBAL_ON), m_htiUseAutoHLRadio, m_iUseAutoHL == 1);
		m_htiUseAutoHLPerFile = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PER_FILE), m_htiUseAutoHLRadio, m_iUseAutoHL == 2);
		m_htiMaxSources = m_ctrlTreeOptions.InsertItem(GetResString(IDS_MAX_SOURCES), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL);
		m_ctrlTreeOptions.AddEditBox(m_htiMaxSources, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMaxPerFileSources = m_ctrlTreeOptions.InsertItem(GetResString(IDS_MAX_PERFILESOURCES), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL);
		m_ctrlTreeOptions.AddEditBox(m_htiMaxPerFileSources, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMinPerFileSources = m_ctrlTreeOptions.InsertItem(GetResString(IDS_MIN_PERFILESOURCES), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL);
		m_ctrlTreeOptions.AddEditBox(m_htiMinPerFileSources, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAHLUpdate = m_ctrlTreeOptions.InsertItem(GetResString(IDS_AHL_UPDATETIME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL);
		m_ctrlTreeOptions.AddEditBox(m_htiAHLUpdate, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< WiZaRd::AutoHL
//>>> WiZaRd::Payback first	
		m_htiPaybackFirstRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PAYBACK_FIRST), iImgDynup, m_htiMoreTweaksGroup);
		m_htiPaybackDisabled = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DISABLED), m_htiPaybackFirstRadio, m_iPaybackFirst == 0);
		m_htiPaybackConst = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_CONST), m_htiPaybackFirstRadio, m_iPaybackFirst == 1);
		m_htiPaybackVar = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_VAR), m_htiPaybackFirstRadio, m_iPaybackFirst == 2);
		m_htiPaybackAuto = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_AUTO), m_htiPaybackFirstRadio, m_iPaybackFirst == 3);
//<<< WiZaRd::Payback first
//>>> Spike2::Emulate other
		m_htiEmulateGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_EMULATE), iImgEmulate, m_htiMoreTweaksGroup);
		m_htiEmulateEdonkey = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_EDONKEY), m_htiEmulateGroup, m_bEmulateEdonkey);
		m_htiEmulateEdonkeyHybrid = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_EDONKEYHYBRID), m_htiEmulateGroup, m_bEmulateEdonkeyHybrid);
		m_htiEmulateMLdonkey = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_MLDONKEY), m_htiEmulateGroup, m_bEmulateMLdonkey);
		m_htiEmulateShareaza = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_SHAREAZA), m_htiEmulateGroup, m_bEmulateShareaza);
		m_htiEmulateLphant = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_LPHANT), m_htiEmulateGroup, m_bEmulateLphant);
//<<< Spike2::Emulate other
//>>> JvA::SLS [enkeyDEV]
		m_htiSLSGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SLSLABEL), iImgSLS, m_htiMoreTweaksGroup);
		m_htiSLSCheck		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SLSCHECKLABEL), m_htiSLSGroup, m_bSLSCheck);
		m_htiSLSActivationLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLSACTIVATIONLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSLSGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiSLSActivationLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiSLSSaveValue	= m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLSSAVEVALUE), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSLSGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiSLSSaveValue, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< JvA::SLS [enkeyDEV]
//>>> shadow2004::FDC [BlueSonicBoy]
		m_htiFDCGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_FDCGROUP), iImgFDC, m_htiMoreTweaksGroup);
		m_htiFDCEnabled		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_FDCENABLE), m_htiFDCGroup, m_bFDCEnabled);
		m_htiFDCDouble		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_FDCDOUBLE), m_htiFDCGroup, m_bFDCDouble);
		m_htiFDCSensitivity = m_ctrlTreeOptions.InsertItem(GetResString(IDS_FDCSENSE), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFDCGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFDCSensitivity, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< shadow2004::FDC [BlueSonicBoy]
		m_htiEnableMultiQueue = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MULTIQUEUE), m_htiMoreTweaksGroup, m_bEnableMultiQueue); //>>> taz::One-queue-per-file
//>>> taz::Variable corrupted blocks ban threshold [Spike2]
		m_htiBanThreshold = m_ctrlTreeOptions.InsertItem(GetResString(IDS_BanThreshold), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiMoreTweaksGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiBanThreshold, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< taz::Variable corrupted blocks ban threshold [Spike2]
//>>> taz::Version Check
		m_htiModVersionCheck = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MODVERSIONCHECK), m_htiMoreTweaksGroup, m_bModVersionCheck);
		m_htiModBetaCheck = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MODBETACHECK), m_htiMoreTweaksGroup, m_bModBetaCheck);
//<<< taz::Version Check

		/////////////////////////////////////////////////////////////////////////////
		// Display group
		//
		m_htiDisplayGroup	= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PW_DISPLAY), iImgDisplay, TVI_ROOT);
//>>> shadow2004::XPMenu [TPT]
		m_htiXPLabel		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_XPMENU_GROUP), iImgXPMenu, m_htiDisplayGroup);
		m_htiXPStyleLabel	= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_XPMENU_STYLEGROUP), iImgXPMenuStyle, m_htiXPLabel);
		m_htiXPStyle1		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_XPMENU_STYLE_0), m_htiXPStyleLabel, m_iXPMenuStyle == 0);
		m_htiXPStyle2		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_XPMENU_STYLE_1), m_htiXPStyleLabel, m_iXPMenuStyle == 1);
		m_htiXPStyle3		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_XPMENU_STYLE_2), m_htiXPStyleLabel, m_iXPMenuStyle == 2);
		m_htiXPSideBar		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_XPMENU_SIDEBAR), m_htiXPLabel, m_bXPSideBar);
		m_htiXPBitmap		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_XPMENU_BITMAP), m_htiXPLabel, m_bXPBitmap);
//<<< shadow2004::XPMenu [TPT]
//>>> WiZaRd/shadow2004::DL in Bold
		m_htiDiBLabel		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DIBLABEL), iImgDiB, m_htiDisplayGroup);
		m_htiDiBNothing		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DIBNOTHING), m_htiDiBLabel, m_iDownloadInBold == 0);
		m_htiDiBClients		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DIBCLIENTS), m_htiDiBLabel, m_iDownloadInBold == 1);
		m_htiDiBFiles		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DIBFILES), m_htiDiBLabel, m_iDownloadInBold == 2);
		m_htiDiBBoth		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DIBBOTH), m_htiDiBLabel, m_iDownloadInBold == 3);
//<<< WiZaRd/shadow2004::DL in Bold
//>>> shadow2004::IP2Country [EastShare]
		m_htiI2CGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_IP2COUNTRY), iImgI2C, m_htiDisplayGroup);
		m_htiI2C2Letter		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_2LETTERS), m_htiI2CGroup, m_iI2CCaption == 0);
		m_htiI2C3Letter		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_3LETTERS), m_htiI2CGroup, m_iI2CCaption == 1);
		m_htiI2CFullCaption	= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_FULLCAPTION), m_htiI2CGroup, m_iI2CCaption == 2);
		m_htiI2CShowFlag	= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_IP2COUNTRY_SHOWFLAGS), m_htiI2CGroup, m_bI2CShowFlag);
//<<< shadow2004::IP2Country [EastShare]
//>>> WiZaRd::minRQR [WiZaRd]
		m_htiMinRQR			= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MINRQR_ENABLE), m_htiDisplayGroup, m_bUseMinRQR);
//<<< WiZaRd::minRQR [WiZaRd]
//>>> WiZaRd::ResourceBars
		m_htiShowResouceBars= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_RESOURCEBARS_ENABLE), m_htiDisplayGroup, m_bShowResourceBars);
//<<< WiZaRd::ResourceBars

#ifdef MOD_FUNCTIONS
		m_ctrlTreeOptions.Expand(m_htiEMFSupport, TVE_EXPAND);
#endif
		m_ctrlTreeOptions.Expand(m_htiSystemGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiMoreTweaksGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiDisplayGroup, TVE_EXPAND);
//>>> taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
		m_ctrlTreeOptions.Expand(m_htiASFURadio, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiASFUOn, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiASFUSimple, TVE_EXPAND);
//<<< taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]

#ifdef MOD_FUNCTIONS
		m_ctrlTreeOptions.SetItemState(m_htiEMFSupport, TVIS_BOLD, TVIS_BOLD);
#endif
		m_ctrlTreeOptions.SetItemState(m_htiSystemGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiMoreTweaksGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiDisplayGroup, TVIS_BOLD, TVIS_BOLD);

//>>> WiZaRd::IntelliFlush
//		m_ctrlTreeOptions.Expand(m_htiFileBufferGroup, TVE_EXPAND);
		m_ctrlTreeOptions.SetItemState(m_htiFileBufferGroup, TVIS_BOLD, TVIS_BOLD);
//<<< WiZaRd::IntelliFlush
//>>> taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
		m_ctrlTreeOptions.SetItemState(m_htiASFUGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiASFURadio, TVIS_BOLD, TVIS_BOLD);
//<<< taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
//>>> WiZaRd::ConChecker [eWombat]
		m_ctrlTreeOptions.SetItemState(m_htiConcheckerGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiConcheckerPingtypeRadio, TVE_EXPAND);
		m_ctrlTreeOptions.SetItemState(m_htiConcheckerPingtypeRadio, TVIS_BOLD, TVIS_BOLD);
//<<< WiZaRd::ConChecker [eWombat]
		m_ctrlTreeOptions.SetItemState(m_htiSOTNRadio, TVIS_BOLD, TVIS_BOLD); //>>> WiZaRd::Intelligent SOTN
//>>> WiZaRd::AutoHL
//		m_ctrlTreeOptions.Expand(m_htiAutoHL, TVE_EXPAND);
		m_ctrlTreeOptions.SetItemState(m_htiAutoHL, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiUseAutoHLRadio, TVE_EXPAND);
		m_ctrlTreeOptions.SetItemState(m_htiUseAutoHLRadio, TVIS_BOLD, TVIS_BOLD);
//<<< WiZaRd::AutoHL
//>>> WiZaRd::Payback first	
		m_ctrlTreeOptions.SetItemState(m_htiPaybackFirstRadio, TVIS_BOLD, TVIS_BOLD);
//		m_ctrlTreeOptions.Expand(m_htiPaybackFirstRadio, TVE_EXPAND);
//<<< WiZaRd::Payback first
//>>> Spike2::Emulate other
//		m_ctrlTreeOptions.Expand(m_htiEmulateGroup, TVE_EXPAND);
		m_ctrlTreeOptions.SetItemState(m_htiEmulateGroup, TVIS_BOLD, TVIS_BOLD);
//<<< Spike2::Emulate other
//>>> shadow2004::XPMenu [TPT]
		m_ctrlTreeOptions.SetItemState(m_htiXPLabel, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiXPStyleLabel, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiXPStyleLabel, TVE_EXPAND);
//<<< shadow2004::XPMenu [TPT]
//>>> WiZaRd/shadow2004::DL in Bold
//		m_ctrlTreeOptions.Expand(m_htiDiBLabel, TVE_EXPAND);
		m_ctrlTreeOptions.SetItemState(m_htiDiBLabel, TVIS_BOLD, TVIS_BOLD);
//<<< WiZaRd/shadow2004::DL in Bold
//>>> shadow2004::IP2Country [EastShare]
		m_ctrlTreeOptions.SetItemState(m_htiI2CGroup, TVIS_BOLD, TVIS_BOLD);
//<<< shadow2004::IP2Country [EastShare]
//>>> JvA::SLS [enkeyDEV]
		m_ctrlTreeOptions.SetItemState(m_htiSLSGroup, TVIS_BOLD, TVIS_BOLD);
//<<< JvA::SLS [enkeyDEV]
//>>> shadow2004::FDC [BlueSonicBoy]
		m_ctrlTreeOptions.SetItemState(m_htiFDCGroup, TVIS_BOLD, TVIS_BOLD);
//<<< shadow2004::FDC [BlueSonicBoy]

		m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
		m_bInitializedTreeOpts = true;
	}

#ifdef MOD_FUNCTIONS
//>>> WiZaRd::PNCheck/EMF
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiUserName, m_sUserName);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiUserPW, m_sUserPW);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiCheckPNs, m_bCheckPNs);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiFriendsEntry, m_bFriendsEntry);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiAutoUpdateFriends, m_bAutoUpdateFriends);
	BOOL bAuth = thePrefs.IsAuthenticated() ? TRUE : FALSE;
	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiCheckPNs, bAuth);
	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiFriendsEntry, bAuth);
	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiAutoUpdateFriends, bAuth);
//<<< WiZaRd::PNCheck/EMF
#endif

	//////////////////////////////////////////////////////////////////////////
	// System tweaks
	//
//>>> WiZaRd::IntelliFlush
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiFileBufferSize, m_iFileBufferSize);
	DDV_MinMaxInt(pDX, m_iFileBufferSize, 256, 30*1024); //kB!
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiFileBufferTime, m_iFileBufferTime);
	DDV_MinMaxInt(pDX, m_iFileBufferTime, 0, 60); //minutes!
//	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiIntelliFlushCheck, m_bIntelliFlush);	
// 	if(m_iFileBufferTime < 1 || m_iFileBufferTime > 5) 
// 	{		
// 		m_ctrlTreeOptions.SetCheckBox(m_htiIntelliFlushCheck, TRUE);
// 		m_ctrlTreeOptions.SetCheckBoxEnable(m_htiIntelliFlushCheck, FALSE);
// 	}
// 	else
// 	{		
// 		m_ctrlTreeOptions.SetCheckBox(m_htiIntelliFlushCheck, m_bIntelliFlush);
// 		m_ctrlTreeOptions.SetCheckBoxEnable(m_htiIntelliFlushCheck, TRUE);
// 	}
//<<< WiZaRd::IntelliFlush
//>>> taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiASFURadio, m_uiDirectoryWatcherMode); 
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiASFUfreq1, m_uiASFUfreq1);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiASFUfreq2, m_uiASFUfreq2);
//	DDV_MinMaxInt(pDX, m_uiASFUfreq, 0, 120);
//<<< taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
//>>> WiZaRd::ConChecker [eWombat]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiConcheckerActive, m_bConcheckerActive);	
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiConcheckerTTL, m_iConcheckerTTL);
	DDV_MinMaxInt(pDX, m_iConcheckerTTL, 8, 64);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiConcheckerPingtimeout, m_iConcheckerPingtimeout);
	DDV_MinMaxInt(pDX, m_iConcheckerPingtimeout, 1, 64);
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype); 
//<<< WiZaRd::ConChecker [eWombat]

	/////////////////////////////////////////////////////////////////////////////
	// More tweaks group
	//
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiMultipleInstances, m_bMultipleInstances);
//>>> WiZaRd::Small File Slot
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiSmallFileSize, m_uiSmallFileSize);
	DDV_MinMaxInt(pDX, m_uiSmallFileSize, 50, 2048);
//<<< WiZaRd::Small File Slot
//>>> WiZaRd::Intelligent SOTN
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiSOTNRadio, m_iSOTN);
//<<< WiZaRd::Intelligent SOTN
//>>> WiZaRd::AutoHL
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiUseAutoHLRadio, m_iUseAutoHL); 
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiMaxSources, m_iMaxSources);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiMaxPerFileSources, m_iMaxPerFileSources);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiMinPerFileSources, m_iMinPerFileSources);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiAHLUpdate, m_iAHLUpdate);
	DDV_MinMaxInt(pDX, m_iMaxSources, 1500, _UI16_MAX);
	DDV_MinMaxInt(pDX, m_iMaxPerFileSources, 150, _UI16_MAX);
	DDV_MinMaxInt(pDX, m_iMinPerFileSources, 25, _UI16_MAX);
	DDV_MinMaxInt(pDX, m_iAHLUpdate, 10, 600);
//<<< WiZaRd::AutoHL
//>>> WiZaRd::Payback first	
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiPaybackFirstRadio, m_iPaybackFirst); 
//<<< WiZaRd::Payback first
//>>> Spike2::Emulate other
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateEdonkey, m_bEmulateEdonkey);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateEdonkeyHybrid, m_bEmulateEdonkeyHybrid);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateMLdonkey, m_bEmulateMLdonkey);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateShareaza, m_bEmulateShareaza);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateLphant, m_bEmulateLphant);
//<<< Spike2::Emulate other
//>>> JvA::SLS [enkeyDEV]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiSLSCheck, m_bSLSCheck);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiSLSActivationLimit, m_iSLSActivationLimit);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiSLSSaveValue, m_iSLSSaveValue);
	DDV_MinMaxInt(pDX, m_iSLSActivationLimit, 0, 100);
	DDV_MinMaxInt(pDX, m_iSLSSaveValue, 0, 50);
//<<< JvA::SLS [enkeyDEV]
//>>> shadow2004::FDC [BlueSonicBoy]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiFDCEnabled, m_bFDCEnabled);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiFDCDouble, m_bFDCDouble);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiFDCSensitivity, m_iFDCSense);
	DDV_MinMaxInt(pDX, m_iFDCSense, 6, 30);
//<<< shadow2004::FDC [BlueSonicBoy]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEnableMultiQueue, m_bEnableMultiQueue); //>>> taz::One-queue-per-file
//>>> taz::Variable corrupted blocks ban threshold [Spike2]
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiBanThreshold, m_iBanThreshold);
	DDV_MinMaxInt(pDX, m_iBanThreshold, 10, 32);
//<<< taz::Variable corrupted blocks ban threshold [Spike2]
//>>> taz::Version Check
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiModVersionCheck, m_bModVersionCheck);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiModBetaCheck, m_bModBetaCheck);
	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiModVersionCheck, m_bModBetaCheck ? FALSE : TRUE);
//<<< taz::Version Check

	/////////////////////////////////////////////////////////////////////////////
	// Display group
	//
//>>> shadow2004::XPMenu [TPT]
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiXPStyleLabel, m_iXPMenuStyle);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiXPSideBar, m_bXPSideBar);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiXPBitmap, m_bXPBitmap);
//<<< shadow2004::XPMenu [TPT]
//>>> WiZaRd/shadow2004::DL in Bold
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiDiBLabel, m_iDownloadInBold);
//<<< WiZaRd/shadow2004::DL in Bold
//>>> shadow2004::IP2Country [EastShare]
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiI2CGroup, m_iI2CCaption);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiI2CShowFlag, m_bI2CShowFlag);
//<<< shadow2004::IP2Country [EastShare]
//>>> WiZaRd::minRQR [WiZaRd]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiMinRQR, m_bUseMinRQR);
//<<< WiZaRd::minRQR [WiZaRd]
//>>> WiZaRd::ResourceBars
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiShowResouceBars, m_bShowResourceBars);
//<<< WiZaRd::ResourceBars
}

BOOL CPPgeMuleFuture::OnInitDialog()
{
	m_bMultipleInstances = theApp.GetProfileInt(L"eMule", L"IgnoreInstances", 0) != 0;
	m_uiSmallFileSize = thePrefs.GetSmallFileSize(); //>>> WiZaRd::Small File Slot
//>>> WiZaRd::IntelliFlush
	m_iFileBufferSize = thePrefs.GetFileBufferSize()/1024; //kB!
	m_iFileBufferTime = thePrefs.GetFileBufferFlushTime()/60/1000; //minutes!
//	m_bIntelliFlush = m_iFileBufferTime < 1 || m_iFileBufferTime > 5 || thePrefs.IsUseIntelliFlush();
//<<< WiZaRd::IntelliFlush
//>>> taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
	m_uiDirectoryWatcherMode = thePrefs.GetDirectoryWatcherMode();	
	m_uiASFUfreq1 = 0;
	m_uiASFUfreq2 = 60;
	if(m_uiDirectoryWatcherMode == ASFU_DEFAULT)
		m_uiASFUfreq1 = thePrefs.GetASFUfreq();
	else if(m_uiDirectoryWatcherMode == ASFU_SIMPLE)
		m_uiASFUfreq2 = thePrefs.GetASFUfreq();
//<<< taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
//>>> WiZaRd::ConChecker [eWombat]
	m_bConcheckerActive = thePrefs.GetCheckCon();	
	m_iConcheckerTTL = thePrefs.GetPingTTL();
	m_iConcheckerPingtimeout = thePrefs.GetPingTimeout();
	m_iConcheckerPingtype = thePrefs.GetICMP() ? 0 : 1; 
//<<< WiZaRd::ConChecker [eWombat]
//>>> WiZaRd::Intelligent SOTN
	m_iSOTN = thePrefs.IsShareOnlyTheNeed() == -1 ? 2 : thePrefs.IsShareOnlyTheNeed();
//<<< WiZaRd::Intelligent SOTN
//>>> WiZaRd::AutoHL
	m_iUseAutoHL = thePrefs.IsUseAutoHL() == -1 ? 2 : thePrefs.IsUseAutoHL();
	m_iMaxSources = thePrefs.GetMaxSourcesHL();
	m_iMaxPerFileSources = thePrefs.GetMaxAutoHL();
	m_iMinPerFileSources = thePrefs.GetMinAutoHL();
	m_iAHLUpdate = thePrefs.GetAutoHLUpdateTimer();
//<<< WiZaRd::AutoHL
//>>> WiZaRd::Payback first	
	m_iPaybackFirst = thePrefs.GetPaybackFirst();
//<<< WiZaRd::Payback first
//>>> Spike2::Emulate other
	m_bEmulateEdonkey = thePrefs.IsEmueDonkey();
	m_bEmulateEdonkeyHybrid = thePrefs.IsEmueDonkeyHybrid();
	m_bEmulateMLdonkey = thePrefs.IsEmuMLDonkey();
	m_bEmulateShareaza = thePrefs.IsEmuShareaza();
	m_bEmulateLphant = thePrefs.IsEmuLphant();
//<<< Spike2::Emulate other
#ifdef MOD_FUNCTIONS
//>>> WiZaRd::PNCheck/EMF
	m_sUserName = thePrefs.GetUserName();
	m_sUserPW = HIDDEN_PASSWORD;
	m_bCheckPNs = thePrefs.IsCheckPNCount(true);
	m_bFriendsEntry = thePrefs.IsFriendlistEntry(true);
	m_bAutoUpdateFriends = thePrefs.IsAutoUpdateFriendList(true);
//<<< WiZaRd::PNCheck/EMF
#endif
//>>> shadow2004::XPMenu [TPT]
	m_iXPMenuStyle = thePrefs.GetXPMenuStyle();
	m_bXPSideBar = thePrefs.GetXPSideBar();
	m_bXPBitmap = thePrefs.GetXPBitmap();
//<<< shadow2004::XPMenu [TPT]
//>>> WiZaRd/shadow2004::DL in Bold
	m_iDownloadInBold = 0;
	if(thePrefs.GetShowActiveClientsBold())
		m_iDownloadInBold = 1;
	if(thePrefs.GetShowActiveFilesBold())
		m_iDownloadInBold = m_iDownloadInBold + 2;
//<<< WiZaRd/shadow2004::DL in Bold
//>>> shadow2004::IP2Country [EastShare]
	m_iI2CCaption = thePrefs.GetIP2CountryNameMode();
	m_bI2CShowFlag = thePrefs.IsIP2CountryShowFlag();
//<<< shadow2004::IP2Country [EastShare]
//>>> JvA::SLS [enkeyDEV]
	m_bSLSCheck = thePrefs.UseSaveLoadSources();
	m_iSLSActivationLimit = thePrefs.GetActivationLimitSLS();
	m_iSLSSaveValue = thePrefs.GetSourcesToSaveSLS();
//<<< JvA::SLS [enkeyDEV]
//>>> shadow2004::FDC [BlueSonicBoy]
	m_bFDCEnabled		= thePrefs.GetFDCEnabled();
	m_bFDCDouble		= thePrefs.GetFDCDoubleEnabled();
	m_iFDCSense			= 100 - thePrefs.GetFDCSensitivity();
//<<< shadow2004::FDC [BlueSonicBoy]
//>>> WiZaRd::minRQR [WiZaRd
	m_bUseMinRQR = thePrefs.ShowMinRQR();
//<<< WiZaRd::minRQR [WiZaRd]
//>>> WiZaRd::ResourceBars
	m_bShowResourceBars = thePrefs.ShowResourceBars();
//<<< WiZaRd::ResourceBars
	m_bEnableMultiQueue = thePrefs.GetEnableMultiQueue(); //>>> taz::One-queue-per-file
	m_iBanThreshold = thePrefs.GetBANTHRES(); //>>> taz::Variable corrupted blocks ban threshold [Spike2]
//>>> taz::Version Check
	m_bModVersionCheck = thePrefs.UpdateNotifyMod();
	m_bModBetaCheck = thePrefs.UpdateNotifyBeta();
//<<< taz::Version Check

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	m_ctrlTreeOptions.SetItemHeight(m_ctrlTreeOptions.GetItemHeight() + 2);

	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgeMuleFuture::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	return CPropertyPage::OnKillActive();
}

BOOL CPPgeMuleFuture::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

    SetModified(FALSE);

	theApp.WriteProfileInt(L"eMule", L"IgnoreInstances", m_bMultipleInstances ? 1 : 0);
//>>> WiZaRd::Small File Slot
	thePrefs.SetSmallFileSize((uint16)m_uiSmallFileSize);
//<<< WiZaRd::Small File Slot
//>>> WiZaRd::IntelliFlush
	thePrefs.SetFileBufferSize(m_iFileBufferSize*1024);
	thePrefs.SetFileBufferFlushTime(m_iFileBufferTime*60*1000);
//	thePrefs.SetUseIntelliFlush(m_bIntelliFlush || m_iFileBufferTime < 1 || m_iFileBufferTime > 5);
//<<< WiZaRd::IntelliFlush
//>>> taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
	const bool bReset = (thePrefs.GetDirectoryWatcherMode() != m_uiDirectoryWatcherMode 
		&& (thePrefs.GetDirectoryWatcherMode() == ASFU_DEFAULT || m_uiDirectoryWatcherMode == ASFU_DEFAULT))		
		|| (m_uiDirectoryWatcherMode == ASFU_DEFAULT && m_uiASFUfreq1 != (int)thePrefs.GetASFUfreq());
	thePrefs.SetDirectoryWatcherMode((uint8)m_uiDirectoryWatcherMode);	
	switch(m_uiDirectoryWatcherMode)
	{
		case ASFU_DEFAULT:
			m_uiASFUfreq1 = min(max(0, m_uiASFUfreq1), 120); //seconds...
			thePrefs.SetASFUfreq(m_uiASFUfreq1);
			break;
		case ASFU_SIMPLE:
			m_uiASFUfreq2 = min(max(30, m_uiASFUfreq2), 1440); //minutes...
			thePrefs.SetASFUfreq(m_uiASFUfreq2);
			break;
		default:
			thePrefs.SetASFUfreq(60); //basically no need to set anything...
			break;
	}	
	if(bReset)
		theApp.ResetDirectoryWatcher();
//<<< taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
//>>> WiZaRd::ConChecker [eWombat]
	const bool bSetPrefs = m_iConcheckerTTL != thePrefs.GetPingTTL()
		|| m_iConcheckerPingtimeout != thePrefs.GetPingTimeout()
		|| (uint8)m_iConcheckerPingtype != (thePrefs.GetICMP() ? 0 : 1);
	thePrefs.SetPingTTL((uint8)m_iConcheckerTTL);
	thePrefs.SetPingTimeout((uint8)m_iConcheckerPingtimeout);
	thePrefs.SetICMP(m_iConcheckerPingtype == 0); 
	if(m_bConcheckerActive != thePrefs.GetCheckCon())
	{
		thePrefs.SetCheckCon(m_bConcheckerActive);
		if(m_bConcheckerActive)
			theApp.conchecker.Start();
		else
			theApp.conchecker.Stop();
	}
	else if(bSetPrefs)
		theApp.conchecker.SetPreferences();
//<<< WiZaRd::ConChecker [eWombat]
//>>> WiZaRd::Intelligent SOTN
	thePrefs.SetShareOnlyTheNeed(m_iSOTN == 2 ? -1 : m_iSOTN);
//<<< WiZaRd::Intelligent SOTN
//>>> WiZaRd::AutoHL
	if(thePrefs.IsUseAutoHL() != m_iUseAutoHL-1)
	{
		thePrefs.SetUseAutoHL((sint8)(m_iUseAutoHL == 2 ? -1 : m_iUseAutoHL));
		if(thePrefs.IsUseAutoHL() == 0) //globally disabled
		{
			for(UINT i = 0; i < (UINT)theApp.downloadqueue->GetFileCount(); ++i)
				theApp.downloadqueue->GetFileByIndex(i)->SetPrivateMaxSources(thePrefs.GetMaxSourcePerFileDefault());
		}
	}
	thePrefs.SetMaxSourcesHL((uint16)m_iMaxSources);
	thePrefs.SetMaxAutoHL((uint16)m_iMaxPerFileSources);
	thePrefs.SetMinAutoHL((uint16)m_iMinPerFileSources);
	thePrefs.SetAutoHLUpdateTimer((uint16)m_iAHLUpdate);
//<<< WiZaRd::AutoHL
//>>> WiZaRd::Payback first	
	thePrefs.SetPaybackFirst((uint8)m_iPaybackFirst);
//<<< WiZaRd::Payback first
//>>> Spike2::Emulate other
	thePrefs.SetEmueDonkey(m_bEmulateEdonkey);
	thePrefs.SetEmueDonkeyHybrid(m_bEmulateEdonkeyHybrid);
	thePrefs.SetEmuMLDonkey(m_bEmulateMLdonkey);
	thePrefs.SetEmuShareaza(m_bEmulateShareaza);
	thePrefs.SetEmuLphant(m_bEmulateLphant);
//<<< Spike2::Emulate other
#ifdef MOD_FUNCTIONS
//>>> WiZaRd::PNCheck/EMF
	if(m_sUserPW != HIDDEN_PASSWORD || m_sUserName != thePrefs.GetUserName())
		thePrefs.SetUserPWCombo(m_sUserName, (m_sUserPW != HIDDEN_PASSWORD) ? m_sUserPW : thePrefs.GetUserPW());
 	m_sUserPW = HIDDEN_PASSWORD;
// 	m_ctrlTreeOptions.SetEditText(m_htiUserPW, m_sUserPW);
	if(m_bCheckPNs != thePrefs.IsCheckPNCount(true))
	{
		thePrefs.SetCheckPNCount(m_bCheckPNs);
		if(thePrefs.IsCheckPNCount(false)) //we are authed and want to get info about new pm...
			DoPNCheck();
	}
	if(m_bFriendsEntry != thePrefs.IsFriendlistEntry(true))
	{
		thePrefs.SetFriendlistEntry(m_bFriendsEntry);
		if(thePrefs.IsFriendlistEntry(false)) //we are authed and want to enter...
			DoFriendListEntry(true);
		else if(!m_bFriendsEntry) //the entry was disabled...
			DoFriendListEntry(false);
	}
	if(m_bAutoUpdateFriends != thePrefs.IsAutoUpdateFriendList(true))
	{
		thePrefs.SetAutoUpdateFriendList(m_bAutoUpdateFriends);
		if(thePrefs.IsAutoUpdateFriendList(false))
			//theApp.emuledlg->chatwnd->m_FriendListCtrl.SendMessage(WM_COMMAND, MP_EMF_LOADFRIENDS, 0);
			DoFriendListUpdate();
	}
//<<< WiZaRd::PNCheck/EMF
#endif
//>>> shadow2004::XPMenu [TPT]
//>>> WiZaRd::XP-Menues
	bool bUpdate = thePrefs.GetXPMenuStyle() != (uint8)m_iXPMenuStyle
		|| thePrefs.GetXPSideBar() != m_bXPSideBar
		|| thePrefs.GetXPBitmap() != m_bXPBitmap;	
//<<< WiZaRd::XP-Menues
	thePrefs.SetXPMenuStyle((uint8)m_iXPMenuStyle);
	thePrefs.SetXPSideBar(m_bXPSideBar);
	thePrefs.SetXPBitmap(m_bXPBitmap);
//>>> WiZaRd::XP-Menues
	if(bUpdate)
	{
		theApp.emuledlg->transferwnd->GetDownloadList()->CreateMenues();
		theApp.emuledlg->searchwnd->CreateMenus();
		theApp.emuledlg->sharedfileswnd->sharedfilesctrl.CreateMenues();
		theApp.emuledlg->sharedfileswnd->m_ctlSharedDirTree.CreateMenues();
	}
//<<< WiZaRd::XP-Menues
//<<< shadow2004::XPMenu [TPT]
	thePrefs.SetShowActiveDownloadsBold((uint8)m_iDownloadInBold);	//>>> WiZaRd/shadow2004::DL in Bold
//>>> shadow2004::IP2Country [EastShare]
	//Check if ip2country is loaded at this point
	if (!theApp.ip2country->IsIP2Country())
		theApp.ip2country->Load();
	thePrefs.SetIP2CountryNameMode((uint8)m_iI2CCaption);
	thePrefs.SetIP2CountryShowFlag(m_bI2CShowFlag);
	theApp.ip2country->Refresh();//refresh passive windows
//<<< shadow2004::IP2Country [EastShare]
//>>> JvA::SLS [enkeyDEV]
	thePrefs.SetSaveLoadSource(m_bSLSCheck);
	thePrefs.SetActivationLimitSLS((uint8)m_iSLSActivationLimit);
	thePrefs.SetSourcesToSaveSLS((uint8)m_iSLSSaveValue);
//<<< JvA::SLS [enkeyDEV]
//>>> shadow2004::FDC [BlueSonicBoy]
	thePrefs.SetFDCEnabled(m_bFDCEnabled);
	thePrefs.SetFDCDoubleEnabled(m_bFDCDouble);
	thePrefs.SetFDCSensitivity(100 - (uint8)m_iFDCSense);
//<<< shadow2004::FDC [BlueSonicBoy]
//>>> WiZaRd::minRQR [WiZaRd]
	if(thePrefs.ShowMinRQR() != m_bUseMinRQR)
	{
		thePrefs.SetMinRQR(m_bUseMinRQR);
		theApp.emuledlg->transferwnd->GetDownloadList()->Localize();
	}
//<<< WiZaRd::minRQR [WiZaRd]
//>>> WiZaRd::ResourceBars
	if(thePrefs.ShowResourceBars() != m_bShowResourceBars)
	{
		thePrefs.SetShowResourceBars(m_bShowResourceBars);
		theApp.emuledlg->transferwnd->ToggleBars();
	}
//<<< WiZaRd::ResourceBars
	thePrefs.SetEnableMultiQueue(m_bEnableMultiQueue); //>>> taz::One-queue-per-file
	thePrefs.SetBANTHRES((uint8) m_iBanThreshold); //>>> taz::Variable corrupted blocks ban threshold [Spike2]
//>>> taz::Version Check
	thePrefs.SetUpdateNotifyBeta(m_bModBetaCheck && m_bModVersionCheck);
	thePrefs.SetUpdateNotifyMod(m_bModVersionCheck);
//<<< taz::Version Check

	return CPropertyPage::OnApply();
}

void CPPgeMuleFuture::Localize(void)
{	
	if(m_hWnd)
	{
		CString buffer;
		SetWindowText(MOD_VERSION);

		if (m_htiMoreTweaksGroup) m_ctrlTreeOptions.SetItemText(m_htiMoreTweaksGroup, GetResString(IDS_PW_MISC));
		if (m_htiMultipleInstances) m_ctrlTreeOptions.SetItemText(m_htiMultipleInstances, GetResString(IDS_MULTIPLE_INSTANCES));
		if (m_htiSmallFileSize) m_ctrlTreeOptions.SetEditLabel(m_htiSmallFileSize, GetResString(IDS_SMALL_FILE_SIZE)); //>>> WiZaRd::Small File Slot
//>>> WiZaRd::ConChecker [eWombat]
		if (m_htiConcheckerGroup)		m_ctrlTreeOptions.SetItemText(m_htiConcheckerGroup, GetResString(IDS_CONCHECKER));
		if (m_htiConcheckerActive)		m_ctrlTreeOptions.SetItemText(m_htiConcheckerActive, GetResString(IDS_CONCHECKER_ACTIVE));
		if (m_htiConcheckerPingtypeRadio) m_ctrlTreeOptions.SetItemText(m_htiConcheckerPingtypeRadio, GetResString(IDS_CONCHECKER_PINGMETHOD));
		if (m_htiConcheckerPingICMP)	m_ctrlTreeOptions.SetItemText(m_htiConcheckerPingICMP, GetResString(IDS_CONCHECKER_ICMP));
		if (m_htiConcheckerPingRAW)		m_ctrlTreeOptions.SetItemText(m_htiConcheckerPingRAW, GetResString(IDS_CONCHECKER_RAW));
		if (m_htiConcheckerTTL)			m_ctrlTreeOptions.SetEditLabel(m_htiConcheckerTTL, GetResString(IDS_CONCHECKER_TTL));
		if (m_htiConcheckerPingtimeout) m_ctrlTreeOptions.SetEditLabel(m_htiConcheckerPingtimeout, GetResString(IDS_CONCHECKER_TIMEOUT));
//<<< WiZaRd::ConChecker [eWombat]
//>>> taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
		if (m_htiASFUGroup)			m_ctrlTreeOptions.SetItemText(m_htiASFUGroup, GetResString(IDS_ASFU));
		if (m_htiASFURadio)			m_ctrlTreeOptions.SetItemText(m_htiASFURadio, GetResString(IDS_ASFU_METHOD));
		if (m_htiASFUOff)			m_ctrlTreeOptions.SetItemText(m_htiASFUOff, GetResString(IDS_OFF));
		if (m_htiASFUOn)			m_ctrlTreeOptions.SetItemText(m_htiASFUOn, GetResString(IDS_ASFU_DEFAULT));
		if (m_htiASFUfreq1)			m_ctrlTreeOptions.SetEditLabel(m_htiASFUfreq1, GetResString(IDS_ASFU_FREQ1));
		if (m_htiASFUSimple)		m_ctrlTreeOptions.SetItemText(m_htiASFUSimple, GetResString(IDS_ASFU_SIMPLE));
		if (m_htiASFUfreq2)			m_ctrlTreeOptions.SetEditLabel(m_htiASFUfreq2, GetResString(IDS_ASFU_FREQ2));		
//<<< taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
//>>> WiZaRd::IntelliFlush
		if (m_htiSystemGroup) m_ctrlTreeOptions.SetItemText(m_htiSystemGroup, GetResString(IDS_SYSTEM));
		if (m_htiFileBufferGroup) m_ctrlTreeOptions.SetItemText(m_htiFileBufferGroup, GetResString(IDS_FILEBUFFER));
		if (m_htiFileBufferSize) 
		{
			buffer.Format(L"%s [%s]", GetResString(IDS_FILEBUFFERSIZE), GetResString(IDS_KBYTES));
			m_ctrlTreeOptions.SetEditLabel(m_htiFileBufferSize, buffer);
		}
		if (m_htiFileBufferTime)	m_ctrlTreeOptions.SetEditLabel(m_htiFileBufferTime, GetResString(IDS_FILEBUFFER_TIME));
//		if (m_htiIntelliFlushCheck) m_ctrlTreeOptions.SetItemText(m_htiIntelliFlushCheck, GetResString(IDS_FILEBUFFER_INTELLI));
//<<< WiZaRd::IntelliFlush
//>>> WiZaRd::Intelligent SOTN
		if (m_htiSOTNRadio)		m_ctrlTreeOptions.SetItemText(m_htiSOTNRadio, GetResString(IDS_SOTN));
		if (m_htiSOTNOFF)		m_ctrlTreeOptions.SetItemText(m_htiSOTNOFF, GetResString(IDS_GLOBAL_OFF));
		if (m_htiSOTNON)		m_ctrlTreeOptions.SetItemText(m_htiSOTNON, GetResString(IDS_GLOBAL_ON));
		if (m_htiSOTNPerFile)	m_ctrlTreeOptions.SetItemText(m_htiSOTNPerFile, GetResString(IDS_PER_FILE));
//<<< WiZaRd::Intelligent SOTN
//>>> WiZaRd::AutoHL
		if (m_htiAutoHL) m_ctrlTreeOptions.SetItemText(m_htiAutoHL, GetResString(IDS_AUTOHL));
		if (m_htiUseAutoHLRadio) m_ctrlTreeOptions.SetItemText(m_htiUseAutoHLRadio, GetResString(IDS_USE_AUTOHL));		
		if (m_htiUseAutoHLOff) m_ctrlTreeOptions.SetItemText(m_htiUseAutoHLOff, GetResString(IDS_GLOBAL_OFF));
		if (m_htiUseAutoHLOn) m_ctrlTreeOptions.SetItemText(m_htiUseAutoHLOn, GetResString(IDS_GLOBAL_ON));
		if (m_htiUseAutoHLPerFile) m_ctrlTreeOptions.SetItemText(m_htiUseAutoHLPerFile, GetResString(IDS_PER_FILE));
		if (m_htiMaxSources) m_ctrlTreeOptions.SetEditLabel(m_htiMaxSources, GetResString(IDS_MAX_SOURCES));
		if (m_htiMaxPerFileSources) m_ctrlTreeOptions.SetEditLabel(m_htiMaxPerFileSources, GetResString(IDS_MAX_PERFILESOURCES));
		if (m_htiMinPerFileSources) m_ctrlTreeOptions.SetEditLabel(m_htiMinPerFileSources, GetResString(IDS_MIN_PERFILESOURCES));
		if (m_htiAHLUpdate) m_ctrlTreeOptions.SetEditLabel(m_htiAHLUpdate, GetResString(IDS_AHL_UPDATETIME));
//<<< WiZaRd::AutoHL
//>>> WiZaRd::Payback first	
		if (m_htiPaybackFirstRadio) m_ctrlTreeOptions.SetItemText(m_htiPaybackFirstRadio, GetResString(IDS_PAYBACK_FIRST));
		if (m_htiPaybackDisabled) m_ctrlTreeOptions.SetItemText(m_htiPaybackDisabled, GetResString(IDS_DISABLED));
		if (m_htiPaybackConst) m_ctrlTreeOptions.SetItemText(m_htiPaybackConst, GetResString(IDS_PAYBACK_FIRST_CONST));
		if (m_htiPaybackVar) m_ctrlTreeOptions.SetItemText(m_htiPaybackVar, GetResString(IDS_PAYBACK_FIRST_VAR));
		if (m_htiPaybackAuto) m_ctrlTreeOptions.SetItemText(m_htiPaybackAuto, GetResString(IDS_PAYBACK_FIRST_AUTO));
//<<< WiZaRd::Payback first
//>>> Spike2::Emulate other
		if (m_htiEmulateGroup) m_ctrlTreeOptions.SetItemText(m_htiEmulateGroup, GetResString(IDS_EMULATE));
		if (m_htiEmulateEdonkey) m_ctrlTreeOptions.SetItemText(m_htiEmulateEdonkey, GetResString(IDS_EMU_EDONKEY));
		if (m_htiEmulateEdonkeyHybrid) m_ctrlTreeOptions.SetItemText(m_htiEmulateEdonkeyHybrid, GetResString(IDS_EMU_EDONKEYHYBRID));
		if (m_htiEmulateMLdonkey) m_ctrlTreeOptions.SetItemText(m_htiEmulateMLdonkey, GetResString(IDS_EMU_MLDONKEY));
		if (m_htiEmulateShareaza) m_ctrlTreeOptions.SetItemText(m_htiEmulateShareaza, GetResString(IDS_EMU_SHAREAZA));
		if (m_htiEmulateLphant) m_ctrlTreeOptions.SetItemText(m_htiEmulateLphant, GetResString(IDS_EMU_LPHANT));
//<<< Spike2::Emulate other
#ifdef MOD_FUNCTIONS
//>>> WiZaRd::PNCheck/EMF
		if (m_htiUserName) m_ctrlTreeOptions.SetEditLabel(m_htiUserName, GetResString(IDS_QL_USERNAME));
		if (m_htiUserPW) m_ctrlTreeOptions.SetEditLabel(m_htiUserPW, GetResString(IDS_WS_PASS));
		if (m_htiCheckPNs) m_ctrlTreeOptions.SetItemText(m_htiCheckPNs, GetResString(IDS_EMF_CHECKPNS));
		if (m_htiFriendsEntry) m_ctrlTreeOptions.SetItemText(m_htiFriendsEntry, GetResString(IDS_EMF_FRIENDSOPT));
		if (m_htiAutoUpdateFriends) m_ctrlTreeOptions.SetItemText(m_htiAutoUpdateFriends, GetResString(IDS_EMF_AUTOUPDATEFRIENDS));
//<<< WiZaRd::PNCheck/EMF
#endif
		if(m_htiDisplayGroup) m_ctrlTreeOptions.SetItemText(m_htiDisplayGroup, GetResString(IDS_PW_DISPLAY));
//>>> shadow2004::XPMenu [TPT]
		if(m_htiXPLabel) m_ctrlTreeOptions.SetItemText(m_htiXPLabel, GetResString(IDS_XPMENU_GROUP));
		if(m_htiXPStyleLabel) m_ctrlTreeOptions.SetItemText(m_htiXPStyleLabel, GetResString(IDS_XPMENU_STYLEGROUP));
		if(m_htiXPStyle1) m_ctrlTreeOptions.SetItemText(m_htiXPStyle1, GetResString(IDS_XPMENU_STYLE_0));
		if(m_htiXPStyle2) m_ctrlTreeOptions.SetItemText(m_htiXPStyle2, GetResString(IDS_XPMENU_STYLE_1));
		if(m_htiXPStyle3) m_ctrlTreeOptions.SetItemText(m_htiXPStyle3, GetResString(IDS_XPMENU_STYLE_2));
		if(m_htiXPSideBar) m_ctrlTreeOptions.SetItemText(m_htiXPSideBar, GetResString(IDS_XPMENU_SIDEBAR));
		if(m_htiXPBitmap) m_ctrlTreeOptions.SetItemText(m_htiXPBitmap, GetResString(IDS_XPMENU_BITMAP));
//<<< shadow2004::XPMenu [TPT]
//>>> WiZaRd/shadow2004::DL in Bold
		if(m_htiDiBLabel) m_ctrlTreeOptions.SetItemText(m_htiDiBLabel, GetResString(IDS_DIBLABEL));
		if(m_htiDiBNothing) m_ctrlTreeOptions.SetItemText(m_htiDiBNothing, GetResString(IDS_DIBNOTHING));
		if(m_htiDiBClients) m_ctrlTreeOptions.SetItemText(m_htiDiBClients, GetResString(IDS_DIBCLIENTS));
		if(m_htiDiBFiles) m_ctrlTreeOptions.SetItemText(m_htiDiBFiles, GetResString(IDS_DIBFILES));
		if(m_htiDiBBoth) m_ctrlTreeOptions.SetItemText(m_htiDiBBoth, GetResString(IDS_DIBBOTH));
//<<< WiZaRd/shadow2004::DL in Bold
//>>> shadow2004::IP2Country [EastShare]
		if(m_htiI2CGroup) m_ctrlTreeOptions.SetItemText(m_htiI2CGroup, GetResString(IDS_IP2COUNTRY));
		if(m_htiI2C2Letter) m_ctrlTreeOptions.SetItemText(m_htiI2C2Letter, GetResString(IDS_IP2COUNTRY_2LETTERS));
		if(m_htiI2C3Letter) m_ctrlTreeOptions.SetItemText(m_htiI2C3Letter, GetResString(IDS_IP2COUNTRY_3LETTERS));
		if(m_htiI2CFullCaption) m_ctrlTreeOptions.SetItemText(m_htiI2CFullCaption, GetResString(IDS_IP2COUNTRY_FULLCAPTION));
		if(m_htiI2CShowFlag) m_ctrlTreeOptions.SetItemText(m_htiI2CShowFlag, GetResString(IDS_IP2COUNTRY_SHOWFLAGS));
//<<< shadow2004::IP2Country [EastShare]
//>>> JvA::SLS [enkeyDEV]
		if(m_htiSLSGroup) m_ctrlTreeOptions.SetItemText(m_htiSLSGroup, GetResString(IDS_SLSLABEL));
		if(m_htiSLSCheck) m_ctrlTreeOptions.SetItemText(m_htiSLSCheck, GetResString(IDS_SLSCHECKLABEL));
		if(m_htiSLSActivationLimit) m_ctrlTreeOptions.SetEditLabel(m_htiSLSActivationLimit, GetResString(IDS_SLSACTIVATIONLABEL));
		if(m_htiSLSSaveValue) m_ctrlTreeOptions.SetEditLabel(m_htiSLSSaveValue, GetResString(IDS_SLSSAVEVALUE));
//<<< JvA::SLS [enkeyDEV]
//>>> WiZaRd::minRQR [WiZaRd]
		if(m_htiMinRQR) m_ctrlTreeOptions.SetItemText(m_htiMinRQR, GetResString(IDS_MINRQR_ENABLE));
//<<< WiZaRd::minRQR [WiZaRd]
//>>> WiZaRd::ResourceBars
		if(m_htiShowResouceBars) m_ctrlTreeOptions.SetItemText(m_htiShowResouceBars, GetResString(IDS_RESOURCEBARS_ENABLE));
//<<< WiZaRd::ResourceBars
//>>> shadow2004::FDC [BlueSonicBoy]
		if(m_htiFDCGroup) m_ctrlTreeOptions.SetItemText(m_htiFDCGroup, GetResString(IDS_FDCGROUP));
		if(m_htiFDCEnabled)	m_ctrlTreeOptions.SetItemText(m_htiFDCEnabled, GetResString(IDS_FDCENABLE));
		if(m_htiFDCDouble) m_ctrlTreeOptions.SetItemText(m_htiFDCDouble, GetResString(IDS_FDCDOUBLE));
		if(m_htiFDCSensitivity) m_ctrlTreeOptions.SetEditLabel(m_htiFDCSensitivity, GetResString(IDS_FDCSENSE));
//<<< shadow2004::FDC [BlueSonicBoy]
		if (m_htiEnableMultiQueue) m_ctrlTreeOptions.SetItemText(m_htiEnableMultiQueue, GetResString(IDS_MULTIQUEUE)); //>>> taz::One-queue-per-file
		if (m_htiBanThreshold) m_ctrlTreeOptions.SetEditLabel(m_htiBanThreshold, GetResString(IDS_BanThreshold)); //>>> taz::Variable corrupted blocks ban threshold [Spike2]
//>>> taz::Version Check
		if (m_htiModVersionCheck) m_ctrlTreeOptions.SetItemText(m_htiModVersionCheck, GetResString(IDS_MODVERSIONCHECK));
		if (m_htiModBetaCheck) m_ctrlTreeOptions.SetItemText(m_htiModBetaCheck, GetResString(IDS_MODBETACHECK));
//<<< taz::Version Check
	}
}

void CPPgeMuleFuture::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	Nullify();

	CPropertyPage::OnDestroy();
}

LRESULT CPPgeMuleFuture::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	if (wParam == IDC_EMULEFUTURE_OPTS)
	{
		//TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		//(void*) pton;

		SetModified();
	}
	return 0;
}

void CPPgeMuleFuture::OnHelp()
{
//>>> WiZaRd:EMF Link
	theApp.emuledlg->SendMessage(WM_COMMAND, MP_HM_LINK4, 0);
//<<< WiZaRd:EMF Link	
}

BOOL CPPgeMuleFuture::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgeMuleFuture::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

//all variables are to be reset in here
void	CPPgeMuleFuture::Nullify()
{
	m_htiMoreTweaksGroup = NULL;

	m_htiMultipleInstances = NULL;
	m_bMultipleInstances = false;

//>>> WiZaRd::Small File Slot
	m_htiSmallFileSize = NULL;
	m_uiSmallFileSize = 0;
//<<< WiZaRd::Small File Slot
//>>> WiZaRd::Intelligent SOTN
	m_htiSOTNRadio = NULL;
	m_htiSOTNON = NULL;
	m_htiSOTNOFF = NULL;
	m_htiSOTNPerFile = NULL;
	m_iSOTN = -1;
//<<< WiZaRd::Intelligent SOTN
//>>> WiZaRd::AutoHL
	m_htiAutoHL = NULL;

	m_htiUseAutoHLRadio = NULL;
	m_htiUseAutoHLPerFile = NULL;
	m_htiUseAutoHLOn = NULL;
	m_htiUseAutoHLOff = NULL;
	m_iUseAutoHL = 0;

	m_htiMaxSources = NULL;
	m_iMaxSources = 0;

	m_htiMaxPerFileSources = NULL;
	m_iMaxPerFileSources = 0;

	m_htiMinPerFileSources = NULL;
	m_iMinPerFileSources = 0;

	m_htiAHLUpdate = NULL;
	m_iAHLUpdate = 0;
//<<< WiZaRd::AutoHL
//>>> WiZaRd::Payback first	
	m_htiPaybackFirstRadio = NULL;
	m_htiPaybackDisabled = NULL;
	m_htiPaybackConst = NULL;
	m_htiPaybackVar = NULL;
	m_htiPaybackAuto = NULL;
	m_iPaybackFirst = 0;
//<<< WiZaRd::Payback first
//>>> Spike2::Emulate other
	m_htiEmulateGroup = NULL;

	m_htiEmulateEdonkey = NULL;
	m_htiEmulateEdonkeyHybrid = NULL;
	m_htiEmulateMLdonkey = NULL;
	m_htiEmulateShareaza = NULL;
	m_htiEmulateLphant = NULL;
//<<< Spike2::Emulate other
#ifdef MOD_FUNCTIONS
//>>> WiZaRd::PNCheck/EMF
	m_htiEMFSupport = NULL;
	m_htiUserName = NULL;
	m_htiUserPW = NULL;
	m_htiCheckPNs = NULL;
	m_htiFriendsEntry = NULL;
	m_htiAutoUpdateFriends = NULL;

	m_sUserName = L"";
	m_sUserPW = L"";
	m_bCheckPNs = false;
	m_bFriendsEntry = false;
	m_bAutoUpdateFriends = false;
//<<< WiZaRd::PNCheck/EMF
#endif
	m_htiDisplayGroup = NULL;
//>>> shadow2004::XPMenu [TPT]
	m_htiXPLabel = NULL;
	m_htiXPStyleLabel = NULL;
	m_htiXPStyle1 = NULL;
	m_htiXPStyle2 = NULL;
	m_htiXPStyle3 = NULL;
	m_htiXPSideBar = NULL;
	m_htiXPBitmap = NULL;
	m_iXPMenuStyle = 0;
	m_bXPSideBar = false;
	m_bXPBitmap = false;
//<<< shadow2004::XPMenu [TPT]
//>>> WiZaRd/shadow2004::DL in Bold
	m_htiDiBLabel = NULL;
	m_htiDiBNothing = NULL;
	m_htiDiBClients = NULL;
	m_htiDiBFiles = NULL;
	m_htiDiBBoth = NULL;
	m_iDownloadInBold = 0;
//<<< WiZaRd/shadow2004::DL in Bold
//>>> shadow2004::IP2Country [EastShare]
	m_htiI2CGroup = NULL;
	m_htiI2C2Letter = NULL;
	m_htiI2C3Letter = NULL;
	m_htiI2CFullCaption = NULL;
	m_htiI2CShowFlag = NULL;
	m_iI2CCaption = 0;
	m_bI2CShowFlag = false;
//<<< shadow2004::IP2Country [EastShare]
//>>> WiZaRd::IntelliFlush
	m_htiSystemGroup = NULL;
	m_htiFileBufferGroup = NULL;
	m_htiFileBufferSize = NULL;
	m_htiFileBufferTime = NULL;
//	m_htiIntelliFlushCheck = NULL;
	m_iFileBufferSize = 0;
	m_iFileBufferTime = 0;
//	m_bIntelliFlush = false;
//<<< WiZaRd::IntelliFlush
//>>> taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
	m_htiASFUGroup = NULL;
	m_htiASFUGroup = NULL;
	m_htiASFUOff = NULL;
	m_htiASFUOn = NULL;
	m_htiASFUSimple = NULL;
	m_htiASFUfreq1 = NULL;
	m_htiASFUfreq2 = NULL;
	m_uiDirectoryWatcherMode = ASFU_OFF;
	m_uiASFUfreq1 = 0;
	m_uiASFUfreq2 = 0;
//<<< taz::Automatic shared files updater [MoNKi/Stulle/WiZaRd]
//>>> WiZaRd::ConChecker [eWombat]
	m_htiConcheckerGroup = NULL;
	m_htiConcheckerActive = NULL;
	m_htiConcheckerPingtypeRadio = NULL;
	m_htiConcheckerPingICMP = NULL;
	m_htiConcheckerPingRAW = NULL;
	m_htiConcheckerTTL = NULL;
	m_htiConcheckerPingtimeout = NULL;
	m_bConcheckerActive = false;
	m_iConcheckerPingtype = 0;
	m_iConcheckerTTL = 0;
	m_iConcheckerPingtimeout = 0;
//<<< WiZaRd::ConChecker [eWombat]
//>>> JvA::SLS [enkeyDEV]
	m_htiSLSGroup = NULL;
	m_htiSLSCheck = NULL;
	m_htiSLSActivationLimit = NULL;
	m_htiSLSSaveValue = NULL;
	m_bSLSCheck = false;
	m_iSLSActivationLimit = 0;
	m_iSLSSaveValue = 0;
//<<< JvA::SLS [enkeyDEV]
//>>> shadow2004::FDC [BlueSonicBoy]
	m_htiFDCGroup		= NULL;
	m_htiFDCEnabled		= NULL;
	m_htiFDCDouble		= NULL;
	m_htiFDCSensitivity = NULL;
	m_bFDCEnabled		= false;
	m_bFDCDouble		= false;
	m_iFDCSense			= 0;
//<<< shadow2004::FDC [BlueSonicBoy]
//>>> WiZaRd::minRQR [WiZaRd]
	m_htiMinRQR = NULL;
	m_bUseMinRQR = false;
//<<< WiZaRd::minRQR [WiZaRd]
//>>> WiZaRd::ResourceBars
	m_htiShowResouceBars = NULL;
	m_bShowResourceBars = false;
//<<< WiZaRd::ResourceBars
//>>> taz::One-queue-per-file
	m_htiEnableMultiQueue = NULL;
	m_bEnableMultiQueue = false;
//<<< taz::One-queue-per-file
	m_htiBanThreshold = NULL; //>>> taz::Variable corrupted blocks ban threshold [Spike2]
//>>> taz::Version Check
	m_htiModVersionCheck = NULL;
	m_htiModBetaCheck = NULL;
//<<< taz::Version Check
}