#pragma once
#include "PPgGeneral.h"
#include "PPgConnection.h"
#include "PPgServer.h"
#include "PPgDirectories.h"
#include "PPgFiles.h"
#include "PPgStats.h"
#include "PPgNotify.h"
#include "PPgTweaks.h"
#include "PPgDisplay.h"
#include "PPgSecurity.h"
#include "PPgProxy.h"
#include "PPgMessages.h"
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
#include "PPgDebug.h"
#endif
#include "otherfunctions.h"
#include "TreePropSheet.h"
#include "./EMF/PPgeMuleFuture.h"	//>>> WiZaRd::eMuleFuture-Prefspage
#include "MOD/PPgMOD2.h" //>>> taz::MOD options
#include "./EMF/PPgUpdates.h"		//>>> shadow2004::Updates-Prefspage
#include "./EMF/PPgIPFilter.h"		//>>> shadow2004::IPFilter-Prefspage
#include "./EMF/SlideBar.h"			//>>> WiZaRd::SlideBar [eMule+]
#include "./EMF/KCSideBannerWnd.h"	//>>> Spike2::Prefs Side Banner [TPT]

//>>> WiZaRd::SlideBar [eMule+]
#define IDC_PREFS_SLIDEBAR	5011	//note: this *should* be unique!
#define PREF_PARENT_CLASS	CPropertySheet
//#define PREF_PARENT_CLASS	CTreePropSheet
//<<< WiZaRd::SlideBar [eMule+]

//>>> shadow2004::Tabbed Prefs [TPT] reworked
enum enumPrefencesItems
{
	// Category: basic options
	PW_GENERAL = 0,	
	PW_DISPLAY,
	PW_CONNECTION,
	PW_SERVER,
	PW_DIRECTORY,
	PW_FILES,

	// Category: advanced options
	PW_PROXY,
	PW_NOTIFY,
	PW_STATISTIC,
	PW_MESSAGES,
	PW_SECURITY,
	PW_TWEAKS,
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	PW_DEBUG,
#endif

	// Category: mod options
	PW_EMULEFUTURE,
	PW_MOD2, //>>> taz::MOD options
	PW_UPDATES,
	// no Category, tabbed pages
	PW_IPFILTER
};

#define LastPage PW_UPDATES
//<<< shadow2004::Tabbed Prefs [TPT] reworked

class CPreferencesDlg : public PREF_PARENT_CLASS
{
	DECLARE_DYNAMIC(CPreferencesDlg)

public:
	CPreferencesDlg();
	virtual ~CPreferencesDlg();
	
	CPPgGeneral		m_wndGeneral;
	CPPgConnection	m_wndConnection;
	CPPgServer		m_wndServer;
	CPPgDirectories	m_wndDirectories;
	CPPgFiles		m_wndFiles;
	CPPgStats		m_wndStats;
	CPPgNotify		m_wndNotify;
	CPPgTweaks		m_wndTweaks;
	CPPgDisplay		m_wndDisplay;
	CPPgSecurity	m_wndSecurity;
	CPPgProxy		m_wndProxy;
	CPPgMessages	m_wndMessages;
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	CPPgDebug		m_wndDebug;
#endif
	CPPgeMuleFuture	m_wndeMuleFuture;	//>>> WiZaRd::eMuleFuture-Prefspage
	CPPgMOD2 m_wndMOD2; //>>> taz::MOD options
	CPPgUpdates		m_wndUpdates;		//>>> shadow2004::Updates-Prefspage
	CPPgIPFilter	m_wndIPFilter;		//>>> shadow2004::IPFilter-Prefspage
//>>> WiZaRd::SlideBar [eMule+]
	CImageList		m_ImageList;
	CSlideBar		m_SlideBar;
//<<< WiZaRd::SlideBar [eMule+]

	void Localize();
	void SetStartPage(UINT uStartPageID);
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	void SwitchTab(int page);

	int	StartPageUpdates;
//<<< shadow2004::Tabbed Prefs [TPT] reworked

protected:
//>>> shadow2004::Tabbed Prefs [TPT] reworked
//	LPCTSTR m_pPshStartPage;
	INT m_nActiveWnd;
//<<< shadow2004::Tabbed Prefs [TPT] reworked
	bool m_bSaveIniFile;

	virtual BOOL OnInitDialog();
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT	OnSlideBarSelChanged(WPARAM wParam, LPARAM lParam); //>>> WiZaRd::SlideBar [eMule+]
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
//>>> Spike2::Prefs Side Banner [TPT]
	CKCSideBannerWnd m_banner;
//<<< Spike2::Prefs Side Banner [TPT]
};
