//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
#include <string.h>



class CCppKeywordLookup

{
public:

	struct HashNode
	{
		wchar_t * key;
		unsigned long hash;
		size_t link;
		size_t entries;
		char
 data;
	};

protected:
	const static HashNode m_data[352];
	const static size_t m_size = 320;
	const static size_t m_tableSize = 154;

public:

	static unsigned long Hash( const wchar_t * sz )
	{
		unsigned long hash;
		hash = 0;
		while ( *sz != 0 )
		{
			hash = (hash<<3)+hash+(*sz);
			sz++;
		}
		return hash;
	}

	static const HashNode * Lookup( const wchar_t * key )
	{
		unsigned long hash;
		const HashNode * p;
		unsigned long index;
		hash = Hash(key);
		index = hash % m_size;
		p = &m_data[index];
		while (p->key)
		{
			if (p->hash==hash && !wcscmp(key, p->key))
				break;

			if (p->link)
			{
				p = &m_data[p->link];
			}
			else
			{
				p = 0;
				break;
			}
		}

		if (p && p->key)
			return p;
		return NULL;
	}
};

const CCppKeywordLookup
::HashNode CCppKeywordLookup
::m_data[352] =
{
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__value", 0x03650243, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__builtin_isfloat", 0x951d2c86, 0, 0, 0
 },
	{ L"__w64", 0x000ab907, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__cdecl", 0x03632109, 0, 0, 0
 },
	{ L"explicit", 0x2109580a, 0, 0, 0
 },
	{ L"int", 0x0000258b, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__int16", 0x0363da10, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"new", 0x000026d2, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__if_not_exists", 0x38c9ff94, 0, 0, 0
 },
	{ L"__stdcall", 0x12ed8495, 0, 0, 0
 },
	{ L"__restrict", 0xa9a671d6, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"const_cast", 0x2e5e6419, 0, 0, 0
 },
	{ L"__uuidof", 0x1e8e211a, 320, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"unsigned", 0x254a5cdd, 0, 0, 0
 },
	{ L"extern", 0x006872de, 321, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"wchar_t", 0x0429d5e0, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"namespace", 0x39bf91e5, 322, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"const", 0x000b4ca7, 323, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"asm", 0x00002329, 0, 0, 0
 },
	{ L"__thiscall", 0xaa47736a, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"do", 0x000003f3, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__try", 0x000aba75, 0, 0, 0
 },
	{ L"xor_eq", 0x0078a2b6, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__nounwind", 0xa8d4dd78, 0, 0, 0
 },
	{ L"typedef", 0x042628b9, 0, 0, 0
 },
	{ L"void", 0x0001773a, 324, 1, 0
 },
	{ L"__int64", 0x0363da3b, 325, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"auto", 0x00013dc1, 0, 0, 0
 },
	{ L"signed", 0x00736d02, 0, 0, 0
 },
	{ L"__multiple_inheritance", 0x71a83643, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__FUNCTION__", 0x8057694a, 326, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"operator", 0x2398ea8c, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"catch", 0x000b2613, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__based", 0x03630355, 0, 0, 0
 },
	{ L"reinterpret_cast", 0x7c1a48d6, 327, 1, 0
 },
	{ L"if", 0x00000417, 328, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__delegate", 0xa5a0c0d9, 0, 0, 0
 },
	{ L"switch", 0x0074db5a, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__inline", 0x1e82a7dd, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"for", 0x0000249f, 329, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"cdecl", 0x000b29e3, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"not", 0x00002729, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"private", 0x03fee6eb, 330, 2, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__asm", 0x000ab46f, 0, 0, 0
 },
	{ L"bitor", 0x000b23b0, 0, 0, 0
 },
	{ L"goto", 0x00014cf1, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"double", 0x0066a733, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__event", 0x036387f8, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"mutable", 0x03ea253a, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__pragma", 0x1e893cfe, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"friend", 0x0068a040, 332, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__STDC__", 0x1e6bbc82, 0, 0, 0
 },
	{ L"__TIME__", 0x1e6ba383, 333, 1, 0
 },
	{ L"template", 0x24b3bc04, 0, 0, 0
 },
	{ L"_WCHAR_T_DEFINED", 0xe2efb485, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__forceinline", 0x3c22bf8c, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__novtordisp", 0x6bcd510e, 334, 1, 0
 },
	{ L"__hook", 0x00606b0f, 0, 0, 0
 },
	{ L"return", 0x00724790, 335, 2, 0
 },
	{ L"__single_inheritance", 0x22487011, 337, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__LINE__", 0x1e647114, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__resume", 0x1e89f4d7, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"or", 0x00000459, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__sealed", 0x1e8aa51c, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"sizeof", 0x0073a0a0, 0, 0, 0
 },
	{ L"union", 0x000d1561, 338, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__builtin_alignof", 0x94d63d24, 339, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__wchar_t", 0x12ff08e6, 0, 0, 0
 },
	{ L"__box", 0x000ab4a7, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"_NATIVE_WCHAR_T_DEFINED", 0xd0434ceb, 0, 0, 0
 },
	{ L"__assume", 0x1e7c0a6c, 0, 0, 0
 },
	{ L"register", 0x241bc32d, 0, 0, 0
 },
	{ L"float", 0x000b90ae, 340, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"long", 0x00015af0, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__abstract", 0xa4b56872, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"enum", 0x000146f5, 341, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__BOOL_DEFINED", 0xb3fb1eb8, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__feacpBreak", 0x92de20ba, 342, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__nodefault", 0xeee80ac0, 0, 0, 0
 },
	{ L"__identifier", 0xd7188001, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"virtual", 0x04285947, 0, 0, 0
 },
	{ L"and_eq", 0x0063a808, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"case", 0x00013d0c, 343, 1, 0
 },
	{ L"break", 0x000b380d, 344, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__super", 0x0364ef15, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__SPREFIX", 0x11c76a17, 0, 0, 0
 },
	{ L"__gc", 0x00013098, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__CURSOR__", 0x9b9d12da, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"static", 0x007477e0, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"true", 0x000172e8, 0, 0, 0
 },
	{ L"while", 0x000d3769, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__compileBreak", 0xe0eef3ec, 345, 1, 0
 },
	{ L"continue", 0x202d692d, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__fastcall", 0xa61a0b70, 0, 0, 0
 },
	{ L"__declspec", 0xa5997eb1, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"compl", 0x000b4c33, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__finally", 0x127b2e35, 346, 2, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__ptr32", 0x03649df9, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"or_eq", 0x000c837e, 0, 0, 0
 },
	{ L"__except", 0x1e7ff2bf, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"bitand", 0x00643d02, 0, 0, 0
 },
	{ L"delete", 0x00658e83, 0, 0, 0
 },
	{ L"bool", 0x00013e84, 348, 1, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"inline", 0x006af787, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"using", 0x000d238e, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"xor", 0x00002a51, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__nogc", 0x00607bd5, 349, 2, 0
 },
	{ L"__ptr64", 0x03649e16, 0, 0, 0
 },
	{ L"public", 0x0071ddd7, 351, 1, 0
 },
	{ L"__TIMESTAMP__", 0xc992e518, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__DATE__", 0x1e5c7fda, 0, 0, 0
 },
	{ L"typename", 0x25578a5b, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"this", 0x00016f60, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__interface", 0xe24dd527, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"char", 0x00013eae, 0, 0, 0
 },
	{ L"try", 0x0000292f, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"and", 0x000022f3, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"default", 0x03915e75, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ 0, 0x00000000, 0, 0,  },
	{ L"else", 0x00014639, 0, 0, 0
 },
	{ L"protected", 0x43d6297a, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__COUNTER__", 0x76e3eebc, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"class", 0x000b3ffe, 0, 0, 0
 },
	{ 0, 0x00000000, 0, 0,  },
	{ L"__unhook", 0x1e8d6e5a, 0, 0, 0
  },
	{ L"__int32", 0x0363da1e, 0, 0, 0
  },
	{ L"__APREFIX", 0x11357325, 0, 0, 0
  },
	{ L"typeid", 0x007604a7, 0, 0, 0
  },
	{ L"__raise", 0x03649aba, 0, 0, 0
  },
	{ L"false", 0x000b70fb, 0, 0, 0
  },
	{ L"__FSTREXP", 0x11610b4a, 0, 0, 0
  },
	{ L"__alignof", 0x1254e816, 0, 0, 0
  },
	{ L"__try_cast", 0xaaa4f517, 0, 0, 0
  },
	{ L"dynamic_cast", 0xe8be69df, 0, 0, 0
  },
	{ L"__leave", 0x036409eb, 331, 0, 0
  },
	{ L"__property", 0xa979c36b, 0, 0, 0
  },
	{ L"__LPREFIX", 0x118ea680, 0, 0, 0
  },
	{ L"__FUNCSIG__", 0x80099ac3, 0, 0, 0
  },
	{ L"not_eq", 0x006fa5ce, 0, 0, 0
  },
	{ L"short", 0x000cd310, 336, 0, 0
  },
	{ L"volatile", 0x25947c50, 0, 0, 0
  },
	{ L"__int8", 0x00606d91, 0, 0, 0
  },
	{ L"__cplusplus", 0xd34885e1, 0, 0, 0
  },
	{ L"__int128", 0x1e82aaa4, 0, 0, 0
  },
	{ L"__virtual_inheritance", 0x134e026e, 0, 0, 0
  },
	{ L"struct", 0x0074a875, 0, 0, 0
  },
	{ L"static_cast", 0xf0a122ba, 0, 0, 0
  },
	{ L"throw", 0x000ced8c, 0, 0, 0
  },
	{ L"__unaligned", 0x0083484d, 0, 0, 0
  },
	{ L"__FILE__", 0x1e5f036c, 0, 0, 0
  },
	{ L"__nontemporal", 0xb55ccaf5, 347, 0, 0
  },
	{ L"__typeof", 0x1e8db535, 0, 0, 0
  },
	{ L"__if_exists", 0xdf5c5744, 0, 0, 0
  },
	{ L"__pin", 0x000ab8d5, 350, 0, 0
  },
	{ L"__FUNCDNAME__", 0x82940455, 0, 0, 0
  },
	{ L"__probability", 0x978fc797, 0, 0, 0
  },
};

