#pragma once
#include "Ping.h"

#define CONSTATE_NULL			0
#define CONSTATE_ONLINE			1
#define CONSTATE_OFFLINE		2
#define CONSTATE_BLOCKED		3

//saves a bit of RAM :)
#define cmd_step	0
#define cmd_exit	1
#define cmd_num		2

namespace WombatAgent
{
	class CConChecker
	{
	public:
		CConChecker();
		~CConChecker();
		void		SetPreferences();

	private:
		static UINT ThreadProc(LPVOID pParam);

	protected:
		void		Signal(const WPARAM wParam, const LPARAM lParam);
		bool		m_bRun;

		DWORD		m_dwState;

		HANDLE		m_hThread;
		HANDLE		m_hEvent[cmd_num];
		HANDLE		m_hKilled;

		CPing		ping;
		CMutex		m_StateLock;

	public:
		bool		Start();
		bool		Stop(const bool bWait = false);
		bool		IsActive() const;
		void		Process(const DWORD& dwTime);
		DWORD		GetState();	
//
//Pinger components
//
	public:
		//>>> Spike2::ConChecker [eWombat] :
		// The following line isn't needed, because Spooky-Mode is not implemented.
		//bool		SpookyAvailable() {return (m_dwIP!=0 && thePrefs.GetCheckCon());}
		DWORD		GetIP() const		{return m_dwIP;}
		BOOL		Check(const bool bInitial = false);

	protected:
		bool		ActivePing();
		BOOL		PassivePing();
		bool		m_bSettingsChanged;
		bool		m_bICMP;

		DWORD		m_nCounter;
		DWORD		m_dwIP;
		DWORD		m_dwLastCheck;

		uint16		m_nPingTimeout;
		uint8		m_nPingTTL;

		CMutex		m_DataLock;
	};
}

extern const UINT UWM_CONCHECKER;