//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//>>> shadow2004::Updates-Prefspage
#include "stdafx.h"
#include "emule.h"
#include "EMF/PPgUpdates.h"
#include "OtherFunctions.h"
#include "emuledlg.h"
#include "HelpIDs.h"
//>>> shadow2004::IP2Country [EastShare]
#include "Preferences.h"
#include "EMF/IP2Country.h"
//<<< shadow2004::IP2Country [EastShare]
#include "./AntiLeech/Modname.h"
#include "MenuCmds.h" //>>> WiZaRd:EMF Link
#include "EMF/ModIconMapping.h"	//>>> shadow2004::ModIconDLL Update
#include "preferencesdlg.h"		//>>> shadow2004::Tabbed Prefs [TPT] reworked

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgUpdates, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgUpdates, CPropertyPage)
//>>> shadow2004::IP2Country [EastShare]
	ON_BN_CLICKED(IDC_UPDATES_I2CSTARTUP, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORI2C, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORI2CVERFILE, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATES_I2CUPDATE, OnBnClickedI2CUpdate)
	ON_BN_CLICKED(IDC_UPDATES_I2CRESET, OnBnClickedResetI2CURL)
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
	ON_BN_CLICKED(IDC_UPDATES_MIMSTARTUP, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORMIM, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATES_MIMUPDATE, OnBnClickedMIMUpdate)
	ON_BN_CLICKED(IDC_UPDATES_MIMRESET, OnBnClickedResetMIMURL)
//<<< shadow2004::ModIconDLL Update
	ON_WM_HELPINFO()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_UPDATES_1, OnTcnSelchangeTabUpdates1)	//>>> shadow2004::Tabbed Prefs [TPT] reworked
END_MESSAGE_MAP()

CPPgUpdates::CPPgUpdates()
	: CPropertyPage(CPPgUpdates::IDD)
{
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("WEB")));
	m_imageList.Add(CTempIconLoader(_T("IPFILTER")));
//<<< shadow2004::Tabbed Prefs [TPT] reworked
}

CPPgUpdates::~CPPgUpdates()
{
}

void CPPgUpdates::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_UPDATES_1, m_tabCtr);	//>>> shadow2004::Tabbed Prefs [TPT] reworked
}

BOOL CPPgUpdates::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	InitTab(true);
	m_tabCtr.SetCurSel(0);
//<<< shadow2004::Tabbed Prefs [TPT] reworked
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgUpdates::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
//>>> shadow2004::IP2Country [EastShare]
		CheckDlgButton(IDC_UPDATES_I2CSTARTUP, thePrefs.IsAutoUpdateIP2CountryEnabled());
		GetDlgItem(IDC_UPDATES_URLFORI2C)->SetWindowText(thePrefs.GetIP2CountryUpdateURL());
		GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->SetWindowText(thePrefs.GetIP2CountryUpdateVerURL());
		strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
		GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
		CheckDlgButton(IDC_UPDATES_MIMSTARTUP, thePrefs.IsAutoUpdateModIconDllEnabled());
		GetDlgItem(IDC_UPDATES_URLFORMIM)->SetWindowText(thePrefs.GetModIconDllUpdateURL());
		GetDlgItem(IDC_UPDATES_MIMVERSION)->SetWindowText(theApp.theModIconMap->GetVersionString());
//<<< shadow2004::ModIconDLL Update
	}
}

BOOL CPPgUpdates::OnApply()
{
//>>> shadow2004::IP2Country [EastShare]
	thePrefs.SetAutoUpdateIP2Country(IsDlgButtonChecked(IDC_UPDATES_I2CSTARTUP)!=0);
	GetDlgItem(IDC_UPDATES_URLFORI2C)->GetWindowText(thePrefs.m_strIP2CountryUpdateURL);
	GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->GetWindowText(thePrefs.m_strIP2CountryUpdateVerURL);
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
	thePrefs.SetAutoUpdateModIconDll(IsDlgButtonChecked(IDC_UPDATES_MIMSTARTUP)!=0);
	GetDlgItem(IDC_UPDATES_URLFORMIM)->GetWindowText(thePrefs.m_strModIconDllUpdateURL);
//>>> shadow2004::ModIconDLL Update

	SetModified(FALSE);
	
	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgUpdates::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_UPDATES));
//>>> shadow2004::IP2Country [EastShare]
		GetDlgItem(IDC_UPDATES_I2CGROUP)->SetWindowText(GetResString(IDS_UPDATES_I2CLABEL));
		GetDlgItem(IDC_UPDATES_I2CSTARTUP)->SetWindowText(GetResString(IDS_UPDATES_I2CAUTO));
		GetDlgItem(IDC_UPDATES_URLFORI2CLABEL)->SetWindowText(GetResString(IDS_UPDATES_I2CURLLABEL));
		GetDlgItem(IDC_UPDATES_URLFORI2CVERFILELABEL)->SetWindowText(GetResString(IDS_UPDATES_I2CURLVERLABEL));
		GetDlgItem(IDC_UPDATES_I2CRESET)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_UPDATES_I2CUPDATE)->SetWindowText(GetResString(IDS_SV_UPDATE));
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
		GetDlgItem(IDC_UPDATES_MIMGROUP)->SetWindowText(GetResString(IDS_UPDATES_MIMLABEL));
		GetDlgItem(IDC_UPDATES_MIMSTARTUP)->SetWindowText(GetResString(IDS_UPDATES_MIMAUTO));
		GetDlgItem(IDC_UPDATES_URLFORMIMLABEL)->SetWindowText(GetResString(IDS_UPDATES_MIMURLLABEL));
		GetDlgItem(IDC_UPDATES_MIMRESET)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_UPDATES_MIMUPDATE)->SetWindowText(GetResString(IDS_SV_UPDATE));
//<<< shadow2004::ModIconDLL Update
	}
}

void CPPgUpdates::OnHelp()
{
//>>> WiZaRd:EMF Link
	theApp.emuledlg->SendMessage(WM_COMMAND, MP_HM_LINK4, 0);
//<<< WiZaRd:EMF Link	
}

BOOL CPPgUpdates::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgUpdates::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

//>>> shadow2004::IP2Country [EastShare]
void CPPgUpdates::OnBnClickedI2CUpdate()
{
	OnApply();
	theApp.ip2country->UpdateIP2CountryURL();
	CString strBuffer;
	strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
	GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
}

void CPPgUpdates::OnBnClickedResetI2CURL()
{
	CString strBuffer = IP2COUNTRY_DEFAULT_URL;
	GetDlgItem(IDC_UPDATES_URLFORI2C)->SetWindowText(strBuffer);
	strBuffer = IP2COUNTRY_DEFAULT_VERURL;
	GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->SetWindowText(strBuffer);
	thePrefs.SetIP2CountryVersion(0);
	strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
	GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
}
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
void CPPgUpdates::OnBnClickedMIMUpdate()
{
	OnApply();
	theApp.theModIconMap->Update();
	GetDlgItem(IDC_UPDATES_MIMVERSION)->SetWindowText(theApp.theModIconMap->GetVersionString());
}

void CPPgUpdates::OnBnClickedResetMIMURL()
{
	GetDlgItem(IDC_UPDATES_URLFORMIM)->SetWindowText(MODICONDLL_DEFAULT_URL);
}
//<<< shadow2004::ModIconDLL Update

//>>> shadow2004::Tabbed Prefs [TPT] reworked
void CPPgUpdates::InitTab(const bool firstinit, const int Page)
{
	if (firstinit) 
	{
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Updates1, GetResString(IDS_UPDATES), 0, (LPARAM)Updates1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Updates2, GetResString(IDS_IPFILTER), 1, (LPARAM)Updates2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgUpdates::OnTcnSelchangeTabUpdates1(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
//<<< shadow2004::Tabbed Prefs [TPT] reworked