//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PreferencesDlg.h"

// Contrib - MOD
#include "./AntiLeech/Modname.h"
// <-------- MOD

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// Contrib - SlideBar
//IMPLEMENT_DYNAMIC(CPreferencesDlg, CTreePropSheet)

//BEGIN_MESSAGE_MAP(CPreferencesDlg, CTreePropSheet)
IMPLEMENT_DYNAMIC(CPreferencesDlg, PREF_PARENT_CLASS)

BEGIN_MESSAGE_MAP(CPreferencesDlg, PREF_PARENT_CLASS)
// <-------- SlideBar

	ON_WM_DESTROY()
	ON_WM_HELPINFO()

// Contrib - SlideBar
	ON_MESSAGE(WM_SBN_SELCHANGED, OnSlideBarSelChanged) //>>> WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

END_MESSAGE_MAP()

CPreferencesDlg::CPreferencesDlg()
{
	m_psh.dwFlags &= ~PSH_HASHELP;
	m_wndGeneral.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDisplay.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndConnection.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDirectories.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndFiles.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndStats.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndIRC.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndWebServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndTweaks.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndSecurity.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndScheduler.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndProxy.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndMessages.m_psp.dwFlags &= ~PSH_HASHELP;

// Contrib - MOD
	m_wndMOD.m_psp.dwFlags &= ~PSH_HASHELP;
// <-------- MOD

// By Taz - MOD
	m_wndMOD2.m_psp.dwFlags &= ~PSH_HASHELP;
// <------- MOD

// Contrib - Updates-Prefspage
	m_wndUpdates.m_psp.dwFlags &= ~PSH_HASHELP;		//>>> shadow2004::Updates-Prefspage
// <-------- Updates-Prefspage

// Contrib - IPFilter-Prefspage
	m_wndIPFilter.m_psp.dwFlags &= ~PSH_HASHELP;	//>>> shadow2004::IPFilter-Prefspage
// <-------- IPFilter-Prefspage

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_wndDebug.m_psp.dwFlags &= ~PSH_HASHELP;
#endif

// Contrib - SlideBar
//>>> WiZaRd::SlideBar [eMule+]
	EnableStackedTabs(FALSE);
/*
	CTreePropSheet::SetPageIcon(&m_wndGeneral, _T("Preferences"));
	CTreePropSheet::SetPageIcon(&m_wndDisplay, _T("DISPLAY"));
	CTreePropSheet::SetPageIcon(&m_wndConnection, _T("CONNECTION"));
	CTreePropSheet::SetPageIcon(&m_wndProxy, _T("PROXY"));
	CTreePropSheet::SetPageIcon(&m_wndServer, _T("SERVER"));
	CTreePropSheet::SetPageIcon(&m_wndDirectories, _T("FOLDERS"));
	CTreePropSheet::SetPageIcon(&m_wndFiles, _T("Transfer"));
	CTreePropSheet::SetPageIcon(&m_wndNotify, _T("NOTIFICATIONS"));
	CTreePropSheet::SetPageIcon(&m_wndStats, _T("STATISTICS"));
	CTreePropSheet::SetPageIcon(&m_wndIRC, _T("IRC"));
	CTreePropSheet::SetPageIcon(&m_wndSecurity, _T("SECURITY"));
	CTreePropSheet::SetPageIcon(&m_wndScheduler, _T("SCHEDULER"));
	CTreePropSheet::SetPageIcon(&m_wndWebServer, _T("WEB"));
	CTreePropSheet::SetPageIcon(&m_wndTweaks, _T("TWEAK"));
	CTreePropSheet::SetPageIcon(&m_wndMessages, _T("MESSAGES"));

// Contrib - MOD
	CTreePropSheet::SetPageIcon(&m_wndMOD, L"SAMEMOD");
// <-------- MOD

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	CTreePropSheet::SetPageIcon(&m_wndDebug, _T("Preferences"));
#endif

*/
//<<< WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

	//basics:
	AddPage(&m_wndGeneral);
	AddPage(&m_wndDisplay);
	AddPage(&m_wndConnection);
//	AddPage(&m_wndProxy);
	AddPage(&m_wndServer);
	AddPage(&m_wndDirectories);
	AddPage(&m_wndFiles);

	//advanced:
	AddPage(&m_wndProxy);
	AddPage(&m_wndNotify);
	AddPage(&m_wndStats);
	AddPage(&m_wndIRC);
	AddPage(&m_wndMessages);
	AddPage(&m_wndSecurity);
	AddPage(&m_wndScheduler);
	AddPage(&m_wndWebServer);
	AddPage(&m_wndTweaks);
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	AddPage(&m_wndDebug);
#endif

// Contrib - EMF
	//mod:
// Contrib - MOD
	AddPage(&m_wndMOD);
// <-------- MOD

// By Taz - MOD
	AddPage(&m_wndMOD2);
// <------- MOD

// Contrib - Updates-Prefspage
	AddPage(&m_wndUpdates);		//>>> shadow2004::Updates-Prefspage
// <-------- Updates-Prefspage

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
// Add tabbed pages here

// Contrib - IPFilter-Prefspage
	AddPage(&m_wndIPFilter);	//>>> shadow2004::IPFilter-Prefspage	// Updates - 2
// <-------- IPFilter-Prefspage

	StartPageUpdates = 0;
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs
// <-------- EMF

// Contrib - SlideBar
//>>> WiZaRd::SlideBar [eMule+]
/*
	// The height of the option dialog is already too large for 640x480. To show as much as
	// possible we do not show a page caption (which is an decorative element only anyway).
	SetTreeViewMode(TRUE, GetSystemMetrics(SM_CYSCREEN) >= 600, TRUE);
	SetTreeWidth(170);
*/
//<<< WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
//	m_pPshStartPage = NULL;
	m_nActiveWnd = 0;
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

	m_bSaveIniFile = false;
}

CPreferencesDlg::~CPreferencesDlg()
{

// Contrib - Tabbed Prefs
	m_ImageList.DeleteImageList(); //>>> WiZaRd::SlideBar [eMule+]
// <-------- Tabbed Prefs

}

void CPreferencesDlg::OnDestroy()
{

// Contrib - SlideBar
//	CTreePropSheet::OnDestroy();
	PREF_PARENT_CLASS::OnDestroy();
// <-------- SlideBar

	if (m_bSaveIniFile)
	{
		thePrefs.Save();
		m_bSaveIniFile = false;
	}

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
//	m_pPshStartPage = GetPage(GetActiveIndex())->m_psp.pszTemplate;
	m_nActiveWnd = GetActiveIndex();

	if(m_nActiveWnd == PW_IPFILTER)
		m_nActiveWnd = PW_UPDATES;
//>>> shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

}

BOOL CPreferencesDlg::OnInitDialog()
{

// Contrib - SlideBar
//>>> WiZaRd::SlideBar [eMule+]
	m_SlideBar.CreateEx(WS_EX_CLIENTEDGE, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(0, 0, 0, 0), this, IDC_PREFS_SLIDEBAR);
	m_SlideBar.SetImageList(&m_ImageList);
	m_SlideBar.SetHAlignCaption(DT_CENTER);

//	Sets a bold font for the group buttons
	CFont* pGroupFont = m_SlideBar.GetGroupFont();
	ASSERT_VALID(pGroupFont);
	LOGFONT logFont;
	pGroupFont->GetLogFont(&logFont);
	logFont.lfWeight *= 2;
	if (logFont.lfWeight > FW_BLACK)
		logFont.lfWeight = FW_BLACK;
	pGroupFont->DeleteObject();
	pGroupFont->CreateFontIndirect(&logFont);
	ASSERT_VALID(pGroupFont);
//<<< WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

	ASSERT( !m_bSaveIniFile );

// Contrib - SlideBar
//	BOOL bResult = CTreePropSheet::OnInitDialog();
	BOOL bResult = PREF_PARENT_CLASS::OnInitDialog();
// <-------- SlideBar

	InitWindowStyles(this);

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
/*
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		if (GetPage(i)->m_psp.pszTemplate == m_pPshStartPage)
		{
			SetActivePage(i);
			break;
		}
	}
*/
	SetActivePage(m_nActiveWnd);
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

// Contrib - Side Banner

// By Taz - fix
	if (!thePrefs.GetRTLWindowsLayout())
// <------- fix

	{
//>>> Spike2::Prefs Side Banner [TPT]
	CBitmap bmp;
	bmp.LoadBitmap(IDB_BANNER);
	m_banner.SetTexture((HBITMAP)bmp.Detach());
	m_banner.SetFillFlag(KCSB_FILL_TEXTURE);
	m_banner.SetSize(74);
	m_banner.SetTitle(_T(""));
	m_banner.SetCaption(_T(""));
	m_banner.Attach(this, KCSB_ATTACH_RIGHT);
//<<< Spike2::Prefs Side Banner [TPT]
	}
// <-------- Side Banner

	Localize();

// Contrib - SlideBar
	m_SlideBar.SetFocus(); //>>> WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

	return bResult;
}

// Contrib - SlideBar
//>>> WiZaRd::SlideBar [eMule+]
LRESULT CPreferencesDlg::OnSlideBarSelChanged(WPARAM /*wParam*/, LPARAM /*lParam*/)
{
	int iCurrentGlobalSel = m_SlideBar.GetGlobalSelectedItem();

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	if(iCurrentGlobalSel == PW_UPDATES && StartPageUpdates == 1)
		iCurrentGlobalSel = PW_IPFILTER;
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

	SetActivePage(iCurrentGlobalSel);

	CListBoxST* pListBox = m_SlideBar.GetGroupListBox(m_SlideBar.GetSelectedGroupIndex());
	ASSERT_VALID(pListBox);

	CString strCurrentItemText;
	pListBox->GetText(pListBox->GetCurSel(), strCurrentItemText);

	CString strCurrentGroupText = m_SlideBar.GetGroupName(m_SlideBar.GetSelectedGroupIndex());
	strCurrentGroupText.Remove('&');

	CString strTitle = RemoveAmbersand(GetResString(IDS_EM_PREFS));
	SetWindowText(strTitle + _T(" -> ") + strCurrentGroupText + _T(" -> ") + strCurrentItemText);

	pListBox->SetFocus();

	return TRUE;
}
//<<< WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

void CPreferencesDlg::Localize()
{

// Contrib - SlideBar
//>>> WiZaRd::SlideBar [eMule+]
	m_ImageList.DeleteImageList();
	m_ImageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 0, 1);
	//basics:
	m_ImageList.Add(CTempIconLoader(_T("PREFERENCES")));
	m_ImageList.Add(CTempIconLoader(_T("DISPLAY")));
	m_ImageList.Add(CTempIconLoader(_T("CONNECTION")));
	m_ImageList.Add(CTempIconLoader(_T("SERVER")));
	m_ImageList.Add(CTempIconLoader(_T("FOLDERS")));
	m_ImageList.Add(CTempIconLoader(_T("TRANSFER")));

	//advanced:
	m_ImageList.Add(CTempIconLoader(_T("PROXY")));
	m_ImageList.Add(CTempIconLoader(_T("NOTIFICATIONS")));
	m_ImageList.Add(CTempIconLoader(_T("STATISTICS")));
	m_ImageList.Add(CTempIconLoader(_T("IRC")));
	m_ImageList.Add(CTempIconLoader(_T("MESSAGE")));
	m_ImageList.Add(CTempIconLoader(_T("SECURITY")));
	m_ImageList.Add(CTempIconLoader(_T("SCHEDULER")));
	m_ImageList.Add(CTempIconLoader(_T("WEB")));
	int iTweak = m_ImageList.Add(CTempIconLoader(_T("TWEAK")));
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_ImageList.Add(CTempIconLoader(_T("PREFERENCES")));
#endif

	//mod:
	int iEMF = m_ImageList.Add(CTempIconLoader(L"SAMEMOD")); //>>> WiZaRd::eMuleFuture-Prefspage

// By Taz - MOD
	m_ImageList.Add(CTempIconLoader(L"SAMEMOD")); //>>> MOD2
// <------- MOD

	m_ImageList.Add(CTempIconLoader(L"WEB"));				//>>> shadow2004::Updates-Prefspage
	//m_ImageList.Add(CTempIconLoader(_T("IPFILTER")));			//>>> shadow2004::IPFilter-Prefspage
//<<< WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

	SetTitle(RemoveAmbersand(GetResString(IDS_EM_PREFS)));

	m_wndGeneral.Localize();
	m_wndDisplay.Localize();
	m_wndConnection.Localize();
	m_wndServer.Localize();
	m_wndDirectories.Localize();
	m_wndFiles.Localize();
	m_wndStats.Localize();
	m_wndNotify.Localize();
	m_wndIRC.Localize();
	m_wndSecurity.Localize();
	m_wndTweaks.Localize();
	m_wndWebServer.Localize();
	m_wndScheduler.Localize();
	m_wndProxy.Localize();
	m_wndMessages.Localize();

// Contrib - MOD
	m_wndMOD.Localize();
// <-------- MOD

// By Taz - MOD
	m_wndMOD2.Localize();
// <------- MOD

// Contrib - Updates-Prefspage
	m_wndUpdates.Localize();		//>>> shadow2004::Updates-Prefspage
// <-------- Updates-Prefspage

// Contrib - IPFilter-Prefspage
	m_wndIPFilter.Localize();		//>>> shadow2004::IPFilter-Prefspage
// <-------- IPFilter-Prefspage

	int c = 0;

// Contrib - SlideBar
//>>> WiZaRd::SlideBar [eMule+]
/*
	CTreeCtrl* pTree = GetPageTreeControl();
	if (pTree)
	{
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_GENERAL)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_DISPLAY)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_CONNECTION)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_PROXY)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_SERVER)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_DIR)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_FILES)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_EKDEV_OPTIONS)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_STATSSETUPINFO)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_IRC)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_MESSAGESCOMMENTS)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_SECURITY)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_SCHEDULER)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_WS)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_TWEAK)));

// Contrib - Mod
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(theApp.m_strModShortName));
// <-------- Mod

	#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
		pTree->SetItemText(GetPageTreeItem(c++), _T("Debug"));
	#endif
	}

	UpdateCaption();
*/
	m_SlideBar.ResetContent();

	//basics:
	int iGroup = m_SlideBar.AddGroup(GetResString(IDS_LD_BASICOPT), 0);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_GENERAL), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_DISPLAY), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_CONNECTION), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_SERVER), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_DIR), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_FILES), iGroup, c++);

	//advanced:
	iGroup = m_SlideBar.AddGroup(GetResString(IDS_LD_ADVANCEDOPT), iTweak);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_PROXY), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_EKDEV_OPTIONS), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_STATSSETUPINFO), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_IRC), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_MESSAGESCOMMENTS), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_SECURITY), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_SCHEDULER), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_WS), iGroup, c++);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_TWEAK), iGroup, c++);
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_SlideBar.AddGroupItem(_T("Debug"), iGroup, c++);
#endif

	//mod:

// Contrib - MOD
	CString	temp_STR;

// By Taz - shorter name
//	iGroup = m_SlideBar.AddGroup(MOD_VERSION_PLAIN, iEMF);
//	temp_STR.Format(L"%s I", MOD_VERSION_PLAIN);
	iGroup = m_SlideBar.AddGroup(theApp.m_strModShortName, iEMF);
	temp_STR.Format(L"%s I", theApp.m_strModShortName);
// <------- shorter name

	m_SlideBar.AddGroupItem(temp_STR, iGroup, c++);					//>>> WiZaRd::eMuleFuture-Prefspage
	temp_STR.Append(L"I");
	m_SlideBar.AddGroupItem(temp_STR, iGroup, c++);					//>>> MOD2
// <-------- MOD

	m_SlideBar.AddGroupItem(GetResString(IDS_UPDATES), iGroup, c++);	//>>> shadow2004::Updates-Prefspage
	//m_SlideBar.AddGroupItem(GetResString(IDS_IPFILTER), iGroup, c++);	//>>> shadow2004::IPFilter-Prefspage

	int width = m_SlideBar.GetGreaterStringWidth();
	width+=60;

	CRect rectOld;
	m_SlideBar.GetWindowRect(rectOld);

	int xoffset, yoffset;
	if(IsWindowVisible())
	{
		yoffset=0;
		xoffset=width-rectOld.Width();
	}
	else
	{
		xoffset=width-rectOld.Width()+10;
		GetActivePage()->GetWindowRect(rectOld);
		ScreenToClient (rectOld);
		yoffset = -rectOld.top;
	}
	GetWindowRect(rectOld);
	SetWindowPos(NULL,0,0,rectOld.Width()+xoffset,rectOld.Height()+yoffset,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
	CTabCtrl* tab = GetTabControl();
	tab->GetWindowRect (rectOld);
	ScreenToClient (rectOld);
	tab->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	CPropertyPage* activepage = GetActivePage();
	activepage->GetWindowRect(rectOld);
	ScreenToClient (rectOld);
	activepage->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	GetClientRect(rectOld);
	m_SlideBar.SetWindowPos(NULL, 6, 6, width, rectOld.Height() - 12, SWP_NOZORDER | SWP_NOACTIVATE);
	int _PropSheetButtons[] = {IDOK, IDCANCEL, ID_APPLY_NOW, IDHELP };
	CWnd* PropSheetButton;
	for (int i = 0; i < sizeof (_PropSheetButtons) / sizeof(_PropSheetButtons[0]); i++)
	{
		if ((PropSheetButton = GetDlgItem(_PropSheetButtons[i])) != NULL)
		{
			PropSheetButton->GetWindowRect (rectOld);
			ScreenToClient (rectOld);
			PropSheetButton->SetWindowPos (NULL, rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
		}
	}
	tab->ShowWindow(SW_HIDE);

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	m_SlideBar.SelectGlobalItem(m_nActiveWnd);
/*	bool bFound = false;
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		if (GetPage(i)->m_psp.pszTemplate == m_pPshStartPage)
		{
			m_SlideBar.SelectGlobalItem(i);
			bFound = true;
			break;
		}
	}
	if(!bFound)
		m_SlideBar.SelectGlobalItem(0); */
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

	OnSlideBarSelChanged(NULL, NULL);
	m_banner.UpdateSize(); //>>> Spike2::Prefs Side Banner [TPT]
	CenterWindow();
//<<< WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

}

void CPreferencesDlg::OnHelp()
{
	int iCurSel = GetActiveIndex();
	if (iCurSel >= 0)
	{
		CPropertyPage* pPage = GetPage(iCurSel);
		if (pPage)
		{
			HELPINFO hi = {0};
			hi.cbSize = sizeof hi;
			hi.iContextType = HELPINFO_WINDOW;
			hi.iCtrlId = 0;
			hi.hItemHandle = pPage->m_hWnd;
			hi.dwContextId = 0;
			pPage->SendMessage(WM_HELP, 0, (LPARAM)&hi);
			return;
		}
	}

	theApp.ShowHelp(0, HELP_CONTENTS);
}

BOOL CPreferencesDlg::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	if (wParam == IDOK || wParam == ID_APPLY_NOW)
		m_bSaveIniFile = true;
	return __super::OnCommand(wParam, lParam);
}

BOOL CPreferencesDlg::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

void CPreferencesDlg::SetStartPage(UINT uStartPageID)
{

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
//	m_pPshStartPage = MAKEINTRESOURCE(uStartPageID);
	m_nActiveWnd = uStartPageID;
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

}

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
void CPreferencesDlg::SwitchTab(int Page)
{
	if(m_hWnd && IsWindowVisible())
	{
		CPropertyPage* activepage = GetActivePage();

		if (activepage == &m_wndUpdates || activepage == &m_wndIPFilter)
		{
			StartPageUpdates = Page;
			if (Page == 0)
			{
				SetActivePage(&m_wndUpdates);
				m_wndUpdates.InitTab(false,0);
			}
			else if (Page == 1)
			{
				SetActivePage(&m_wndIPFilter);
				m_wndIPFilter.InitTab(false,1);
			}
		}
	}
}
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

