//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "UploadQueue.h"
#include "Packets.h"
#include "KnownFile.h"
#include "ListenSocket.h"
#include "Exceptions.h"
#include "Scheduler.h"
#include "PerfLog.h"
#include "UploadBandwidthThrottler.h"
#include "ClientList.h"
#include "LastCommonRouteFinder.h"
#include "DownloadQueue.h"
#include "FriendList.h"
#include "Statistics.h"
#include "MMServer.h"
#include "OtherFunctions.h"
#include "UpDownClient.h"
#include "SharedFileList.h"
#include "KnownFileList.h"
#include "Sockets.h"
#include "ClientCredits.h"
#include "Server.h"
#include "ServerList.h"
#include "WebServer.h"
#include "emuledlg.h"
#include "ServerWnd.h"
#include "TransferWnd.h"
#include "SearchDlg.h"
#include "StatisticsDlg.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/Kademlia/Prefs.h"
#include "Log.h"
#include "collection.h"

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
#include "./AntiLeech/ClientAnalyzer.h" //>>> WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// By Taz - fix (moved to opcodes.h)
/*
// Contrib - slot control
//>>> Add2Up Timer
#define UPLOAD_RETALIATIONTIME		SEC2MS(15)		//was: 10
#define MIN_NEXTSLOT_WAITTIME		SEC2MS(5)		//was:  3
#define MIN_NEXTSLOT_WAITTIME_LOW	SEC2MS(5)		//was:  1
//<<< Add2Up Timer
// <-------- slot control
*/
// <------- fix

// Contrib - Automatic Firewalled Retries
//>>> WiZaRd::Automatic Firewalled Retries
static	uint8	m_iFirewalledRetries = 0;
static	DWORD	m_dwFirewalledTimer = NULL;
//<<< WiZaRd::Automatic Firewalled Retries
// <-------- Automatic Firewalled Retries

static uint32 counter, sec, statsave;
static UINT s_uSaveStatistics = 0;
// -khaos--+++> Added iupdateconnstats...
static uint32 igraph, istats, iupdateconnstats;
// <-----khaos-


CUploadQueue::CUploadQueue()
{

// Contrib - Automatic Firewalled Retries
	m_dwFirewalledTimer = ::GetTickCount(); //>>> WiZaRd::Automatic Firewalled Retries
// <-------- Automatic Firewalled Retries

	VERIFY( (h_timer = SetTimer(0,0,100,UploadTimer)) != NULL );
	if (thePrefs.GetVerbose() && !h_timer)
		AddDebugLogLine(true,_T("Failed to create 'upload queue' timer - %s"),GetErrorMessage(GetLastError()));

// Contrib - slot control
	m_uiFellBelowSlotsNeeded = 0; //>>> Add2Up Timer
// <-------- slot control

	datarate = 0;
	counter=0;
	successfullupcount = 0;
	failedupcount = 0;
	totaluploadtime = 0;
	m_nLastStartUpload = 0;
	statsave=0;
	// -khaos--+++>
	iupdateconnstats=0;
	// <-----khaos-
	m_dwRemovedClientByScore = ::GetTickCount();
    m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = 0;
    m_MaxActiveClients = 0;
    m_MaxActiveClientsShortTime = 0;

    m_lastCalculatedDataRateTick = 0;
    m_avarage_dr_sum = 0;
    friendDatarate = 0;

    m_dwLastResortedUploadSlots = 0;
}

/**
 * Find the highest ranking client in the waiting queue, and return it.
 *
 * Low id client are ranked as lowest possible, unless they are currently connected.
 * A low id client that is not connected, but would have been ranked highest if it
 * had been connected, gets a flag set. This flag means that the client should be
 * allowed to get an upload slot immediately once it connects.
 *
 * @return address of the highest ranking client.
 */
CUpDownClient* CUploadQueue::FindBestClientInQueue()
{

// Contrib - optimization
//>>> WiZaRd::Optimization
/*
	POSITION toadd = 0;
	POSITION toaddlow = 0;
	uint32	bestscore = 0;
	uint32  bestlowscore = 0;
    CUpDownClient* newclient = NULL;
    CUpDownClient* lowclient = NULL;

	POSITION pos1, pos2;
	for (pos1 = waitinglist.GetHeadPosition();( pos2 = pos1 ) != NULL;)
	{
		waitinglist.GetNext(pos1);
		CUpDownClient* cur_client =	waitinglist.GetAt(pos2);
		//While we are going through this list.. Lets check if a client appears to have left the network..
		ASSERT ( cur_client->GetLastUpRequest() );


// Contrib - optimization requpfile
		//MORPH - Changed by SiRoB, Optimization requpfile
//		if ((::GetTickCount() - cur_client->GetLastUpRequest() > MAX_PURGEQUEUETIME) || !theApp.sharedfiles->GetFileByID(cur_client->GetUploadFileID()) )
		if ((::GetTickCount() - cur_client->GetLastUpRequest() > MAX_PURGEQUEUETIME) || !cur_client->CheckAndGetReqUpFile())
// <-------- optimization requpfile

		{
			//This client has either not been seen in a long time, or we no longer share the file he wanted anymore..
			cur_client->ClearWaitStartTime();
			RemoveFromWaitingQueue(pos2,true);
			continue;
		}
        else
        {
		    // finished clearing

// Contrib - Inform Clients after IP Change
			// ==> Inform Clients after IP Change - Stulle
			// Once we are here we cleaned up the waiting queue and can proceed sending
			// our ip to every client that did not get it.
			// This function should be called often enough and even if it isn't, waiting
			// clients usually do not get to know our new IP!
			if(cur_client->GetSendIP())
				cur_client->SendIPChange();
			// <== Inform Clients after IP Change - Stulle
// <-------- Inform Clients after IP Change

		    uint32 cur_score = cur_client->GetScore(false);

		    if ( cur_score > bestscore)
		    {
                // cur_client is more worthy than current best client that is ready to go (connected).

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
				//if our upload tries failed at least 3 times in a row we will only grant a slot while being connected already
				//that way, we hopefully ensure a successful upload session
				if(cur_client->GetAntiLeechData()
					&& cur_client->GetAntiLeechData()->GetBadULSessions() > 2)
				{
					if(cur_client->socket && cur_client->socket->IsConnected())
					{
						bestscore = cur_score;
						toadd = pos2;
						newclient = waitinglist.GetAt(toadd);
					}
					continue;
				}
#endif
// <-------- ClientAnalyzer

                if(!cur_client->HasLowID() || (cur_client->socket && cur_client->socket->IsConnected())) {
                    // this client is a HighID or a lowID client that is ready to go (connected)
                    // and it is more worthy
			        bestscore = cur_score;
			        toadd = pos2;
                    newclient = waitinglist.GetAt(toadd);
                } 
				else if(!cur_client->m_bAddNextConnect) 
				{
                    // this client is a lowID client that is not ready to go (not connected)
    
                    // now that we know this client is not ready to go, compare it to the best not ready client
                    // the best not ready client may be better than the best ready client, so we need to check
                    // against that client
			        if (cur_score > bestlowscore)
			        {
                        // it is more worthy, keep it
				        bestlowscore = cur_score;
				        toaddlow = pos2;
                        lowclient = waitinglist.GetAt(toaddlow);
			        }
                }
            } 
		}
	}
	
	if (bestlowscore > bestscore && lowclient)
		lowclient->m_bAddNextConnect = true;

    if (!toadd)
		return NULL;
    else
	    return waitinglist.GetAt(toadd);
*/

	//while I'm at it I cleaned this up a bit...
	//just to mention it... the official client has a bug here
	//we will search for a client with score > 0... now IF the extreme rare case
	//happens that we have only GPL breakers in queue then NOONE will ever be added...
	uint32	bestscore = 0;
	uint32  bestlowscore = 0;
	CUpDownClient* newclient = NULL;
	CUpDownClient* lowclient = NULL;

// Contrib - PowerShare
//>>> WiZaRd::PowerShare
	CUpDownClient* friendclient = NULL;
	uint32	bestscorePS = 0;
	uint32  bestlowscorePS = 0;
	CUpDownClient* newclientPS = NULL;
	CUpDownClient* lowclientPS = NULL;
//<<< WiZaRd::PowerShare
// <-------- PowerShare

	for (POSITION pos1 = waitinglist.GetHeadPosition(); pos1 != NULL;)
	{
		POSITION pos2 = pos1;
		CUpDownClient* cur_client =	waitinglist.GetNext(pos1);

// Contrib - optimization requpfile
		//MORPH - Changed by SiRoB, Optimization requpfile
		/*
		CKnownFile* file = theApp.sharedfiles->GetFileByID(cur_client->GetUploadFileID());
		*/
		CKnownFile* file = cur_client->CheckAndGetReqUpFile();
// <-------- optimization requpfile

		//While we are going through this list.. Lets check if a client appears to have left the network..
		ASSERT ( cur_client->GetLastUpRequest() );

// Contrib - fiX unfair client treatment
//>>> WiZaRd::FiX unfair client treatment [http://forum.emule-project.net/index.php?showtopic=116699]
/*
		if ((::GetTickCount() - cur_client->GetLastUpRequest() > MAX_PURGEQUEUETIME) || !file )
*/
		if ((::GetTickCount() - cur_client->GetLastUpRequest() > MAX_PURGEQUEUETIME))
//<<< WiZaRd::FiX unfair client treatment [http://forum.emule-project.net/index.php?showtopic=116699]
// <-------- fiX unfair client treatment

		{
			//This client has either not been seen in a long time, or we no longer share the file he wanted anymore..
			cur_client->ClearWaitStartTime();
			RemoveFromWaitingQueue(pos2,true);

// By Taz - fix
			if (!file && cur_client->Credits()) // client gone & we don't share the file - fresh start
				cur_client->Credits()->ClearWaitStartTime();
// <------- fix

			continue;
		}

// Contrib - fiX unfair client treatment
//>>> WiZaRd::FiX unfair client treatment [http://forum.emule-project.net/index.php?showtopic=116699]
		if(file == NULL)
			continue;
//<<< WiZaRd::FiX unfair client treatment [http://forum.emule-project.net/index.php?showtopic=116699]
// <-------- fiX unfair client treatment

// Contrib - Startup Flood Prevention
//>>> WiZaRd::Startup Flood Prevention
		//Requested by James R. Bath
		//http://forum.emule-project.net/index.php?showtopic=101181
		if(::GetTickCount() - cur_client->GetWaitStartTime() < SEC2MS(30)) //30secs are enough
			continue;
//<<< WiZaRd::Startup Flood Prevention
// <-------- Startup Flood Prevention

// Contrib - PowerShare
//>>> WiZaRd::PowerShare
		if(cur_client->GetFriendSlot())
			friendclient = cur_client;
		if(friendclient)
			continue;
//<<< WiZaRd::PowerShare
// <-------- PowerShare

		// finished clearing

// Contrib - Inform Clients after IP Change
		// ==> Inform Clients after IP Change - Stulle
		// Once we are here we cleaned up the waiting queue and can proceed sending
		// our ip to every client that did not get it.
		// This function should be called often enough and even if it isn't, waiting
		// clients usually do not get to know our new IP!
		if(cur_client->GetSendIP())
			cur_client->SendIPChange();
		// <== Inform Clients after IP Change - Stulle
// <-------- Inform Clients after IP Change

		const uint32 cur_score = cur_client->GetScore(false);

// Contrib - PowerShare
//>>> WiZaRd::PowerShare
		if(cur_client->IsPowerShared())

		{

			if (cur_score > bestscorePS)
			{
				// cur_client is more worthy than current best client that is ready to go (connected).

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
				//if our upload tries failed at least 3 times in a row we will only grant a slot while being connected already
				//that way, we hopefully ensure a successful upload session
				if(cur_client->GetAntiLeechData()
					&& cur_client->GetAntiLeechData()->GetBadULSessions() > 2)
				{
					if(cur_client->socket && cur_client->socket->IsConnected())
					{
						bestscorePS = cur_score;
						newclientPS = cur_client;
					}
					continue;
				}
#endif
// <-------- ClientAnalyzer

				if(!cur_client->HasLowID() || (cur_client->socket && cur_client->socket->IsConnected()))
				{
					// this client is a HighID or a lowID client that is ready to go (connected)
					// and it is more worthy
					bestscorePS = cur_score;
					newclientPS = cur_client;
				}
				else if(!cur_client->m_bAddNextConnect)
				{
					// this client is a lowID client that is not ready to go (not connected)

					// now that we know this client is not ready to go, compare it to the best not ready client
					// the best not ready client may be better than the best ready client, so we need to check
					// against that client
					if (cur_score > bestlowscorePS)
					{
						// it is more worthy, keep it
						bestlowscorePS = cur_score;
						lowclientPS = cur_client;
					}
				}
			}
		}
		else
		{
//<<< WiZaRd::PowerShare
// <-------- PowerShare

			if (cur_score > bestscore)
			{
				// cur_client is more worthy than current best client that is ready to go (connected).

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
				//if our upload tries failed at least 3 times in a row we will only grant a slot while being connected already
				//that way, we hopefully ensure a successful upload session
				if(cur_client->GetAntiLeechData()
					&& cur_client->GetAntiLeechData()->GetBadULSessions() > 2)
				{
					if(cur_client->socket && cur_client->socket->IsConnected())
					{
						bestscore = cur_score;
						newclient = cur_client;
					}
					continue;
				}
#endif
// <-------- ClientAnalyzer

				if(!cur_client->HasLowID() || (cur_client->socket && cur_client->socket->IsConnected()))
				{
					// this client is a HighID or a lowID client that is ready to go (connected)
					// and it is more worthy
					bestscore = cur_score;
					newclient = cur_client;
				}
				else if(!cur_client->m_bAddNextConnect)
				{
					// this client is a lowID client that is not ready to go (not connected)

					// now that we know this client is not ready to go, compare it to the best not ready client
					// the best not ready client may be better than the best ready client, so we need to check
					// against that client

					if (cur_score > bestlowscore)
					{
						// it is more worthy, keep it
						bestlowscore = cur_score;
						lowclient = cur_client;
					}
				}
			}
		}
	}

// Contrib - PowerShare
//>>> WiZaRd::PowerShare
	if (bestlowscorePS > bestscorePS && lowclientPS)
		lowclientPS->m_bAddNextConnect = true;
	else
//<<< WiZaRd::PowerShare
// <-------- PowerShare

	if (bestlowscore > bestscore && lowclient)
		lowclient->m_bAddNextConnect = true;

// Contrib - PowerShare
//>>> WiZaRd::PowerShare
	if(friendclient)
		return friendclient;
	if(newclientPS)
		return newclientPS;
//<<< WiZaRd::PowerShare
// <-------- PowerShare

	return newclient;

//<<< WiZaRd::Optimization
// <-------- optimization

}

void CUploadQueue::InsertInUploadingList(CUpDownClient* newclient) 
{
	//Lets make sure any client that is added to the list has this flag reset!
	newclient->m_bAddNextConnect = false;
    // Add it last
    theApp.uploadBandwidthThrottler->AddToStandardList(uploadinglist.GetCount(), newclient->GetFileUploadSocket());
	uploadinglist.AddTail(newclient);
    newclient->SetSlotNumber(uploadinglist.GetCount());
}

bool CUploadQueue::AddUpNextClient(LPCTSTR pszReason, CUpDownClient* directadd){
	CUpDownClient* newclient = NULL;
	// select next client or use given client
	if (!directadd)
	{
        newclient = FindBestClientInQueue();

        if(newclient)
		{
		    RemoveFromWaitingQueue(newclient, true);

// Contrib - optimization
// WiZaRd
/*
		    theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
*/
			theApp.emuledlg->transferwnd->ShowQueueCount();
// <-------- optimization

        }
	}
	else 
		newclient = directadd;

    if(newclient == NULL) 
        return false;

// By Taz - auto full chunk
/*
	if (!thePrefs.TransferFullChunks())
		UpdateMaxClientScore(); // refresh score caching, now that the highest score is removed
*/
// <------- auto full chunk

	if (IsDownloading(newclient))
		return false;

    if(pszReason && thePrefs.GetLogUlDlEvents())
        AddDebugLogLine(false, _T("Adding client to upload list: %s Client: %s"), pszReason, newclient->DbgGetClientInfo());

	if (newclient->HasCollectionUploadSlot() && directadd == NULL){
		ASSERT( false );
		newclient->SetCollectionUploadSlot(false);
	}

	// tell the client that we are now ready to upload
	if (!newclient->socket || !newclient->socket->IsConnected())
	{
		newclient->SetUploadState(US_CONNECTING);
		if (!newclient->TryToConnect(true))
			return false;
	}
	else
	{
		if (thePrefs.GetDebugClientTCPLevel() > 0)
			DebugSend("OP__AcceptUploadReq", newclient);
		Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
		theStats.AddUpDataOverheadFileRequest(packet->size);
		newclient->SendPacket(packet, true);
		newclient->SetUploadState(US_UPLOADING);
	}
	newclient->SetUpStartTime();
	newclient->ResetSessionUp();

// Contrib - auto full chunk
	newclient->ResetRemainingUp();	// VQB: fullChunk
// <-------- auto full chunk

    InsertInUploadingList(newclient);

    m_nLastStartUpload = ::GetTickCount();
	
	// statistic

// Contrib - optimization requpfile
	//MORPH START - Adde by SiRoB, Optimization requpfile
	/*
	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)newclient->GetUploadFileID());
	*/
	CKnownFile* reqfile = newclient->CheckAndGetReqUpFile();
	//MORPH END   - Adde by SiRoB, Optimization requpfile
// <-------- optimization requpfile

	if (reqfile)
		reqfile->statistic.AddAccepted();
		
	theApp.emuledlg->transferwnd->uploadlistctrl.AddClient(newclient);

	return true;
}

void CUploadQueue::UpdateActiveClientsInfo(DWORD curTick) {
    // Save number of active clients for statistics
    uint32 tempHighest = theApp.uploadBandwidthThrottler->GetHighestNumberOfFullyActivatedSlotsSinceLastCallAndReset();

// By Taz - optimize empty
/*    
    if(thePrefs.GetLogUlDlEvents() && theApp.uploadBandwidthThrottler->GetStandardListSize() > (uint32)uploadinglist.GetSize()) {
        // debug info, will remove this when I'm done.
        //AddDebugLogLine(false, _T("UploadQueue: Error! Throttler has more slots than UploadQueue! Throttler: %i UploadQueue: %i Tick: %i"), theApp.uploadBandwidthThrottler->GetStandardListSize(), uploadinglist.GetSize(), ::GetTickCount());
    }
*/
// <------- optimize
	
	if(tempHighest > (uint32)uploadinglist.GetSize()+1) {
        tempHighest = uploadinglist.GetSize()+1;
	}

    m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = tempHighest;

    // save some data about number of fully active clients
    uint32 tempMaxRemoved = 0;
    while(!activeClients_tick_list.IsEmpty() && !activeClients_list.IsEmpty() && curTick-activeClients_tick_list.GetHead() > 20*1000) {
        activeClients_tick_list.RemoveHead();
	    uint32 removed = activeClients_list.RemoveHead();

        if(removed > tempMaxRemoved) {
            tempMaxRemoved = removed;
        }
    }

	activeClients_list.AddTail(m_iHighestNumberOfFullyActivatedSlotsSinceLastCall);
    activeClients_tick_list.AddTail(curTick);

    if(activeClients_tick_list.GetSize() > 1) {
        uint32 tempMaxActiveClients = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        uint32 tempMaxActiveClientsShortTime = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        POSITION activeClientsTickPos = activeClients_tick_list.GetTailPosition();
        POSITION activeClientsListPos = activeClients_list.GetTailPosition();
        while(activeClientsListPos != NULL && (tempMaxRemoved > tempMaxActiveClients && tempMaxRemoved >= m_MaxActiveClients || curTick - activeClients_tick_list.GetAt(activeClientsTickPos) < 10 * 1000)) {
            DWORD activeClientsTickSnapshot = activeClients_tick_list.GetAt(activeClientsTickPos);
            uint32 activeClientsSnapshot = activeClients_list.GetAt(activeClientsListPos);

            if(activeClientsSnapshot > tempMaxActiveClients) {
                tempMaxActiveClients = activeClientsSnapshot;
            }

            if(activeClientsSnapshot > tempMaxActiveClientsShortTime && curTick - activeClientsTickSnapshot < 10 * 1000) {
                tempMaxActiveClientsShortTime = activeClientsSnapshot;
            }

            activeClients_tick_list.GetPrev(activeClientsTickPos);
            activeClients_list.GetPrev(activeClientsListPos);
        }

        if(tempMaxRemoved >= m_MaxActiveClients || tempMaxActiveClients > m_MaxActiveClients) {
            m_MaxActiveClients = tempMaxActiveClients;
        }

        m_MaxActiveClientsShortTime = tempMaxActiveClientsShortTime;
    } else {
        m_MaxActiveClients = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        m_MaxActiveClientsShortTime = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
    }
}

/**
 * Maintenance method for the uploading slots. It adds and removes clients to the
 * uploading list. It also makes sure that all the uploading slots' Sockets always have
 * enough packets in their queues, etc.
 *
 * This method is called approximately once every 100 milliseconds.
 */
void CUploadQueue::Process() {

// Contrib - fix
// WiZaRd
/*
    DWORD curTick = ::GetTickCount();
*/
    const DWORD curTick = ::GetTickCount();
// <-------- fix

    UpdateActiveClientsInfo(curTick);

	if (ForceNewClient()){
        // There's not enough open uploads. Open another one.
        AddUpNextClient(_T("Not enough open upload slots for current ul speed"));
	}

    // The loop that feeds the upload slots with data.
	POSITION pos = uploadinglist.GetHeadPosition();
	while(pos != NULL){
        // Get the client. Note! Also updates pos as a side effect.
		CUpDownClient* cur_client = uploadinglist.GetNext(pos);
		if (thePrefs.m_iDbgHeap >= 2)
			ASSERT_VALID(cur_client);
		//It seems chatting or friend slots can get stuck at times in upload.. This needs looked into..
		if (!cur_client->socket)
		{
			RemoveFromUploadQueue(cur_client, _T("Uploading to client without socket? (CUploadQueue::Process)"));
			if(cur_client->Disconnected(_T("CUploadQueue::Process"))){
				delete cur_client;
			}
		} else {
            cur_client->SendBlockData();
        }
	}

    // Save used bandwidth for speed calculations
	uint64 sentBytes = theApp.uploadBandwidthThrottler->GetNumberOfSentBytesSinceLastCallAndReset();
	avarage_dr_list.AddTail(sentBytes);
    m_avarage_dr_sum += sentBytes;

    (void)theApp.uploadBandwidthThrottler->GetNumberOfSentBytesOverheadSinceLastCallAndReset();

    avarage_friend_dr_list.AddTail(theStats.sessionSentBytesToFriend);

    // Save time beetween each speed snapshot
    avarage_tick_list.AddTail(curTick);

    // don't save more than 30 secs of data
    while(avarage_tick_list.GetCount() > 3 && !avarage_friend_dr_list.IsEmpty() && ::GetTickCount()-avarage_tick_list.GetHead() > 30*1000) {
   	    m_avarage_dr_sum -= avarage_dr_list.RemoveHead();
        avarage_friend_dr_list.RemoveHead();
        avarage_tick_list.RemoveHead();
    }

// Contrib - L2HAC
//>>> Spike2::L2HAC [enkeyDEV]
	static DWORD dwLastL2HACCheck = ::GetTickCount();
	if (theApp.IsFirewalled()
		&& curTick - dwLastL2HACCheck > MIN2MS(1)) //do not check TOO often... parsing the whole waitinglist is expensive!
	{
		dwLastL2HACCheck = curTick;
		for (POSITION pos = waitinglist.GetHeadPosition(); pos;)
		{
			CUpDownClient* cur_client = waitinglist.GetNext(pos);
			if (cur_client->IsL2HACEnabled()
				&& cur_client->GetLastL2HACExecution()
				//&& cur_client->GetL2HACTime() // this is already checked in AddClientToQueue
				&& (curTick - cur_client->GetLastL2HACExecution()) > cur_client->GetL2HACTime())
			{
				if (theApp.listensocket->TooManySockets() && !(cur_client->socket && cur_client->socket->IsConnected()) )
					cur_client->SetLastL2HACExecution(curTick - cur_client->GetL2HACTime() + (uint32)ROUND(((float)rand()/RAND_MAX)*300000));
				else
				{
					cur_client->EnableL2HAC(false);
					//if (!cur_client->HasLowID() && cur_client->GetL2HACTime()) // this is already checked in AddClientToQueue
					cur_client->TryToConnect();
				}
			}
		}
	}
//<<< Spike2::L2HAC [enkeyDEV]
// <-------- L2HAC

};

bool CUploadQueue::AcceptNewClient(bool addOnNextConnect)
{
	uint32 curUploadSlots = (uint32)uploadinglist.GetCount();

	//We allow ONE extra slot to be created to accommodate lowID users.
	//This is because we skip these users when it was actually their turn
	//to get an upload slot..
	if(addOnNextConnect && curUploadSlots > 0)
		curUploadSlots--;		

    return AcceptNewClient(curUploadSlots);
}

bool CUploadQueue::AcceptNewClient(uint32 curUploadSlots){
	// check if we can allow a new client to start downloading from us

// By Taz - slot control
/*
	if (curUploadSlots < MIN_UP_CLIENTS_ALLOWED)
*/
	if (curUploadSlots < MIN_UP_CLIENTS_ALLOWED || curUploadSlots < thePrefs.GetSlots())
// <------- slot control

	{

// Contrib - fix logging
		if(thePrefs.GetLogUlDlEvents())
			AddDebugLogLine(false, L"Accepted new client: Min UP clients=%u Requested Slots=%u", MIN_UP_CLIENTS_ALLOWED, thePrefs.GetSlots());
// <-------- fix

// Contrib - slot control
		m_uiFellBelowSlotsNeeded = 0; //>>> Add2Up Timer - reset
// <-------- slot control

		return true;
	}

// By Taz - slot control
	if (thePrefs.GetSlots() > 1) // already opened number of requested slot due to above
	{
		m_uiFellBelowSlotsNeeded = 0; //>>> Add2Up Timer - reset
		return false;
	}
// <------- slot control

// Contrib - slot control
	const DWORD dwCurTick = ::GetTickCount();
	const UINT MaxSpeed = (UINT)(thePrefs.IsDynUpEnabled()?theApp.lastCommonRouteFinder->GetUpload():thePrefs.GetMaxUpload()*1024);

// By Taz - moved here
	const UINT datarate = GetDatarate();
// <------- moved

// By Taz - adjust
    UINT upPerClient = UPLOAD_CLIENT_DATARATE;

    // if throttler doesn't require another slot, go with a slightly more restrictive method
	if( MaxSpeed > 20*1024 )
		upPerClient += datarate/43;

	if( upPerClient > 7680 )
		upPerClient = 7680;
// <------- adjust

	if(dwCurTick - m_nLastStartUpload < MIN_NEXTSLOT_WAITTIME
		|| curUploadSlots >= MAX_UP_CLIENTS_ALLOWED
// By Taz - adjust
/*
		|| curUploadSlots * 3072 >= MaxSpeed) //hard coded final limit
		|| curUploadSlots * 7680 >= MaxSpeed) //hard coded final limit
*/
//XXX		|| datarate >= MaxSpeed) //hard coded final limit
		|| curUploadSlots * upPerClient >= MaxSpeed) //hard coded final limit
// <------- adjust

	{
		m_uiFellBelowSlotsNeeded = 0; //>>> Add2Up Timer - reset
		return false;
	}

//>>> TRICKLE ORIENTATION
	//length minus active equals the trickle slot count
	UINT curTrickles = 0;
	if((UINT)GetUploadQueueLength() > GetActiveUploadsCount()) //could there be something wrong?
		curTrickles = GetUploadQueueLength() - GetActiveUploadsCount();

	//if we have no trickle slots then we know that not all BW is used up...
	//so I try to estimate the needed trickles and check for them instead to use "fixed" values
	UINT WantedTrickles = 0;

// By Taz - moved up
/*
	const UINT datarate = GetDatarate();
*/
// <------- moved

// By Taz - fix
/*
	if(datarate < 25600) //less then 25k UL? use 1 trickle...
		WantedTrickles = 1;
	else if(datarate < 102400) //less then 100k UL? use 1 per 25kB
		WantedTrickles = datarate/25600;
	else //really high UL! use 1 per 35kB
		WantedTrickles = datarate/35840;
*/
	if(MaxSpeed < 25600) //less then 25k UL? use 1 trickle...
		WantedTrickles = 1;
	else if(datarate < 102400) //less then 100k UL? use 1 per 25kB
		WantedTrickles = MaxSpeed/25600;
	else //really high UL! use 1 per 35kB
		WantedTrickles = MaxSpeed/35840;
// <------- fix

	//check for slot focus... as speed is concentrated we need more trickles...
//	if(thePrefs.GetSlots() == 1)
//		++WantedTrickles;

	if(curTrickles < WantedTrickles)
	{
		//we do not return true but instead set our timer here
		if(!m_uiFellBelowSlotsNeeded)
		{
			m_uiFellBelowSlotsNeeded = dwCurTick+UPLOAD_RETALIATIONTIME; //give up to UPLOAD_RETALIATIONTIME to regain speed
			return false;
		}
		//only add to up if X seconds passed and still a new slot is requested
		else if(dwCurTick > m_uiFellBelowSlotsNeeded)
		{
			m_uiFellBelowSlotsNeeded = 0; //>>> Add2Up Timer - reset
			return true;
		}
		//otherwise... nope, not yet ;)
		return false;
	}
	//otherwise... nope, not yet ;)
	m_uiFellBelowSlotsNeeded = 0;
	return false;
//<<< TRICKLE ORIENTATION
/*
	uint16 MaxSpeed;
    if (thePrefs.IsDynUpEnabled())
        MaxSpeed = (uint16)(theApp.lastCommonRouteFinder->GetUpload()/1024);
    else
		MaxSpeed = thePrefs.GetMaxUpload();
	
	if (curUploadSlots >= MAX_UP_CLIENTS_ALLOWED ||
        curUploadSlots >= 4 &&
        (
         curUploadSlots >= (datarate/UPLOAD_CHECK_CLIENT_DR) ||
         curUploadSlots >= ((uint32)MaxSpeed)*1024/UPLOAD_CLIENT_DATARATE ||
         (
          thePrefs.GetMaxUpload() == UNLIMITED &&
          !thePrefs.IsDynUpEnabled() &&
          thePrefs.GetMaxGraphUploadRate(true) > 0 &&
          curUploadSlots >= ((uint32)thePrefs.GetMaxGraphUploadRate(false))*1024/UPLOAD_CLIENT_DATARATE
         )
        )
    ) // max number of clients to allow for all circumstances
	    return false;

	return true;
*/
// <-------- slot control

}

bool CUploadQueue::ForceNewClient(bool allowEmptyWaitingQueue) {
    if(!allowEmptyWaitingQueue && waitinglist.GetSize() <= 0)
        return false;

// Contrib - slot control
// XXX
	if(::GetTickCount() - m_nLastStartUpload < MIN_NEXTSLOT_WAITTIME_LOW)
/*
	if (::GetTickCount() - m_nLastStartUpload < 1000 && datarate < 102400 )
*/
// <-------- slot control

		return false;

	uint32 curUploadSlots = (uint32)uploadinglist.GetCount();

// Contrib - optimization WiZaRd (already within AcceptNewClient)
/*
	if (curUploadSlots < MIN_UP_CLIENTS_ALLOWED)
		return true;
*/
// <-------- optimization

// Contrib - fix WiZaRd
	return(theApp.lastCommonRouteFinder->AcceptNewClient() && AcceptNewClient(curUploadSlots)); // UploadSpeedSense can veto a new slot if USS enabled
/*
// Contrib - fix WiZaRd
//    if(!AcceptNewClient(curUploadSlots) || !theApp.lastCommonRouteFinder->AcceptNewClient()) { // UploadSpeedSense can veto a new slot if USS enabled
	if(!theApp.lastCommonRouteFinder->AcceptNewClient() || !AcceptNewClient(curUploadSlots)) { // UploadSpeedSense can veto a new slot if USS enabled
// <-------- fix

		return false;
    }

	uint16 MaxSpeed;
    if (thePrefs.IsDynUpEnabled())
        MaxSpeed = (uint16)(theApp.lastCommonRouteFinder->GetUpload()/1024);
    else
		MaxSpeed = thePrefs.GetMaxUpload();

	uint32 upPerClient = UPLOAD_CLIENT_DATARATE;

    // if throttler doesn't require another slot, go with a slightly more restrictive method
	if( MaxSpeed > 20 || MaxSpeed == UNLIMITED)
		upPerClient += datarate/43;

	if( upPerClient > 7680 )
		upPerClient = 7680;

	//now the final check

	if ( MaxSpeed == UNLIMITED )
	{

// By Taz - fix
//		if (curUploadSlots < (datarate/upPerClient))
		if (curUploadSlots * upPerClient < datarate)
// <------- fix

			return true;
	}
	else{
		uint16 nMaxSlots;
		if (MaxSpeed > 12)
			nMaxSlots = (uint16)(((float)(MaxSpeed*1024)) / upPerClient);
		else if (MaxSpeed > 7)
			nMaxSlots = MIN_UP_CLIENTS_ALLOWED + 2;
		else if (MaxSpeed > 3)
			nMaxSlots = MIN_UP_CLIENTS_ALLOWED + 1;
		else
			nMaxSlots = MIN_UP_CLIENTS_ALLOWED;

// By Taz - fix logging
//		AddLogLine(true,"maxslots=%u, upPerClient=%u, datarateslot=%u|%u|%u",nMaxSlots,upPerClient,datarate/UPLOAD_CHECK_CLIENT_DR, datarate, UPLOAD_CHECK_CLIENT_DR);
		if(thePrefs.GetLogUlDlEvents())
			AddDebugLogLine(false, L"maxslots=%u, curUploadSlots=%u, upPerClient=%u, datarate=%u", nMaxSlots, curUploadSlots, upPerClient, datarate);
// <------- fix

		if ( curUploadSlots < nMaxSlots )
		{
			return true;
		}
	}

    if(m_iHighestNumberOfFullyActivatedSlotsSinceLastCall > (uint32)uploadinglist.GetSize()) {
        // uploadThrottler requests another slot. If throttler says it needs another slot, we will allow more slots
        // than what we require ourself. Never allow more slots than to give each slot high enough average transfer speed, though (checked above).
        //if(thePrefs.GetLogUlDlEvents() && waitinglist.GetSize() > 0)
        //    AddDebugLogLine(false, _T("UploadQueue: Added new slot since throttler needs it. m_iHighestNumberOfFullyActivatedSlotsSinceLastCall: %i uploadinglist.GetSize(): %i tick: %i"), m_iHighestNumberOfFullyActivatedSlotsSinceLastCall, uploadinglist.GetSize(), ::GetTickCount());
        return true;
    }

    //nope
	return false;
*/
// <-------- fix

}
    
CUploadQueue::~CUploadQueue(){
	if (h_timer)
		KillTimer(0,h_timer);
}

CUpDownClient* CUploadQueue::GetWaitingClientByIP_UDP(uint32 dwIP, uint16 nUDPPort, bool bIgnorePortOnUniqueIP, bool* pbMultipleIPs){
	CUpDownClient* pMatchingIPClient = NULL;
	uint32 cMatches = 0;
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;){
		CUpDownClient* cur_client = waitinglist.GetNext(pos);
		if (dwIP == cur_client->GetIP() && nUDPPort == cur_client->GetUDPPort())
			return cur_client;
		else if (dwIP == cur_client->GetIP() && bIgnorePortOnUniqueIP){
			pMatchingIPClient = cur_client;
			cMatches++;
		}
	}
	if (pbMultipleIPs != NULL)
		*pbMultipleIPs = cMatches > 1;

	if (pMatchingIPClient != NULL && cMatches == 1)
		return pMatchingIPClient;
	else
		return NULL;
}

CUpDownClient* CUploadQueue::GetWaitingClientByIP(uint32 dwIP){
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;){
		CUpDownClient* cur_client = waitinglist.GetNext(pos);
		if (dwIP == cur_client->GetIP())
			return cur_client;
	}
	return 0;
}

/**
 * Add a client to the waiting queue for uploads.
 *
 * @param client address of the client that should be added to the waiting queue
 *
 * @param bIgnoreTimelimit don't check time limit to possibly ban the client.
 */
void CUploadQueue::AddClientToQueue(CUpDownClient* client, bool bIgnoreTimelimit)
{
	//This is to keep users from abusing the limits we put on lowID callbacks.
	//1)Check if we are connected to any network and that we are a lowID.
	//(Although this check shouldn't matter as they wouldn't have found us..
	// But, maybe I'm missing something, so it's best to check as a precaution.)
	//2)Check if the user is connected to Kad. We do allow all Kad Callbacks.
	//3)Check if the user is in our download list or a friend..
	//We give these users a special pass as they are helping us..
	//4)Are we connected to a server? If we are, is the user on the same server?
	//TCP lowID callbacks are also allowed..
	//5)If the queue is very short, allow anyone in as we want to make sure
	//our upload is always used.
	if (theApp.IsConnected() 
		&& theApp.IsFirewalled()
		&& !client->GetKadPort()
		&& client->GetDownloadState() == DS_NONE 
		&& !client->IsFriend()
		&& theApp.serverconnect
		&& !theApp.serverconnect->IsLocalServer(client->GetServerIP(),client->GetServerPort())
		&& GetWaitingUserCount() > 50)
		return;
	client->AddAskedCount();
	client->SetLastUpRequest();

// Contrib - optimization
// WiZaRd

// Contrib - optimization requpfile
	//MORPH START - Adde by SiRoB, Optimization requpfile
	/*
	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)client->GetUploadFileID());
	*/
	CKnownFile* reqfile = client->CheckAndGetReqUpFile();
	//MORPH END   - Adde by SiRoB, Optimization requpfile
// <-------- optimization requpfile

	if(reqfile == NULL)
		return; //should never happen, just in case, though...
// <-------- optimization

// Contrib - ClientAnalyzer
//>>> WiZaRd::ClientAnalyzer
#ifdef CLIENTANALYZER
	if(client->GetRequestFile() == reqfile && client->IsCompleteSource())
	{
		if(client->GetAntiLeechData())
			client->GetAntiLeechData()->SetBadForThisSession(AT_FILEFAKER);
		return; //nope - come back later...
	}
#endif
//<<< WiZaRd::ClientAnalyzer
// <-------- ClientAnalyzer

	if (!bIgnoreTimelimit)
		client->AddRequestCount(client->GetUploadFileID());
	if (client->IsBanned())
		return;

// Contrib - L2HAC
//>>> Spike2::L2HAC [enkeyDEV]
	client->SetLastL2HACExecution();
	if (!client->HasLowID() && client->GetL2HACSupport()) 
		client->EnableL2HAC(true);
//<<< Spike2::L2HAC [enkeyDEV]
// <-------- L2HAC

// Contrib - fix
//>>> WiZaRd::FiX
	//moved here... that way we count the request even in case of an eary return (but still not if the request comes from a banned client)
	// statistic values
	reqfile->statistic.AddRequest();
//<<< WiZaRd::FiX
// <-------- fix

	uint16 cSameIP = 0;
	// check for double
	POSITION pos1, pos2;
	for (pos1 = waitinglist.GetHeadPosition();( pos2 = pos1 ) != NULL;)
	{
		waitinglist.GetNext(pos1);
		CUpDownClient* cur_client= waitinglist.GetAt(pos2);
		if (cur_client == client)
		{	
			if (client->m_bAddNextConnect && AcceptNewClient(client->m_bAddNextConnect))
			{
				//Special care is given to lowID clients that missed their upload slot
				//due to the saving bandwidth on callbacks.
				if(thePrefs.GetLogUlDlEvents())
					AddDebugLogLine(true, _T("Adding ****lowid when reconnecting. Client: %s"), client->DbgGetClientInfo());
				client->m_bAddNextConnect = false;
				RemoveFromWaitingQueue(client, true);
				// statistic values // TODO: Maybe we should change this to count each request for a file only once and ignore reasks

// Contrib - fix
// WiZaRd
/*
// Contrib - optimization requpfile
	//MORPH START - Adde by SiRoB, Optimization requpfile
//				CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)client->GetUploadFileID());
				CKnownFile* reqfile = client->CheckAndGetReqUpFile();
	//MORPH END   - Adde by SiRoB, Optimization requpfile
// <-------- optimization requpfile

				if (reqfile)
					reqfile->statistic.AddRequest();
*/
// <-------- fix

				AddUpNextClient(_T("Adding ****lowid when reconnecting."), client);
				return;
			}
			client->SendRankingInfo();
			theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(client);
			return;			
		}
		else if ( client->Compare(cur_client) ) 
		{
			theApp.clientlist->AddTrackClient(client); // in any case keep track of this client

			// another client with same ip:port or hash
			// this happens only in rare cases, because same userhash / ip:ports are assigned to the right client on connecting in most cases
			if (cur_client->credits != NULL && cur_client->credits->GetCurrentIdentState(cur_client->GetIP()) == IS_IDENTIFIED)
			{
				//cur_client has a valid secure hash, don't remove him
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false, GetResString(IDS_SAMEUSERHASH), client->GetUserName(), cur_client->GetUserName(), client->GetUserName());
				return;
			}
			if (client->credits != NULL && client->credits->GetCurrentIdentState(client->GetIP()) == IS_IDENTIFIED)
			{
				//client has a valid secure hash, add him remove other one
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false, GetResString(IDS_SAMEUSERHASH), client->GetUserName(), cur_client->GetUserName(), cur_client->GetUserName());

// Contrib - SUQWT
				// ==> SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
				waitinglist.GetAt(pos2)->ClearWaitStartTime();
				// <== SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
// <-------- SUQWT

				RemoveFromWaitingQueue(pos2,true);
				if (!cur_client->socket)
				{
					if(cur_client->Disconnected(_T("AddClientToQueue - same userhash 1")))
						delete cur_client;
				}
			}
			else
			{
				// remove both since we do not know who the bad one is
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false, GetResString(IDS_SAMEUSERHASH), client->GetUserName() ,cur_client->GetUserName(), _T("Both"));

// Contrib - SUQWT
				// ==> SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
				waitinglist.GetAt(pos2)->ClearWaitStartTime();
				// <== SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
// <-------- SUQWT

				RemoveFromWaitingQueue(pos2,true);	
				if (!cur_client->socket)
				{
					if(cur_client->Disconnected(_T("AddClientToQueue - same userhash 2")))
						delete cur_client;
				}
				return;
			}
		}
		else if (client->GetIP() == cur_client->GetIP())
		{
			// same IP, different port, different userhash
			cSameIP++;
		}
	}
	if (cSameIP >= 3)
	{
		// do not accept more than 3 clients from the same IP
		if (thePrefs.GetVerbose())
			DEBUG_ONLY( AddDebugLogLine(false,_T("%s's (%s) request to enter the queue was rejected, because of too many clients with the same IP"), client->GetUserName(), ipstr(client->GetConnectIP())) );
		return;
	}
	else if (theApp.clientlist->GetClientsFromIP(client->GetIP()) >= 3)
	{
		if (thePrefs.GetVerbose())
			DEBUG_ONLY( AddDebugLogLine(false,_T("%s's (%s) request to enter the queue was rejected, because of too many clients with the same IP (found in TrackedClientsList)"), client->GetUserName(), ipstr(client->GetConnectIP())) );
		return;
	}
	// done

	// statistic values // TODO: Maybe we should change this to count each request for a file only once and ignore reasks

// Contrib - optimization
// WiZaRd
/*
// Contrib - optimization requpfile
	//MORPH START - Adde by SiRoB, Optimization requpfile
//	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)client->GetUploadFileID());
	CKnownFile* reqfile = client->CheckAndGetReqUpFile();
	//MORPH END   - Adde by SiRoB, Optimization requpfile
// <-------- optimization requpfile

	if (reqfile)
		reqfile->statistic.AddRequest();
*/
// <-------- optimization

	// emule collection will bypass the queue
	if (reqfile != NULL && CCollection::HasCollectionExtention(reqfile->GetFileName()) && reqfile->GetFileSize() < (uint64)MAXPRIORITYCOLL_SIZE
		&& !client->IsDownloading() && client->socket != NULL && client->socket->IsConnected())
	{
		client->SetCollectionUploadSlot(true);
		RemoveFromWaitingQueue(client, true);
		AddUpNextClient(_T("Collection Priority Slot"), client);
		return;
	}
	else
		client->SetCollectionUploadSlot(false);

   // cap the list
    // the queue limit in prefs is only a soft limit. Hard limit is 25% higher, to let in powershare clients and other
    // high ranking clients after soft limit has been reached

// Contrib - fix
//>>> WiZaRd::QueueSize FiX
/*
    uint32 softQueueLimit = thePrefs.GetQueueSize();
    uint32 hardQueueLimit = thePrefs.GetQueueSize() + max(thePrefs.GetQueueSize()/4, 200);
*/
	//this makes eMule to keep the PROPER limit that is set via preferences
	//by default: 
	//softlimit = pref-limit
	//hardlimit = soft + 25% of soft but at least 200
	//now (fixed):	
	//hardlimit = preflimit
	//softlimit = 80% of hard but at least 200
	uint32 hardQueueLimit = thePrefs.GetQueueSize();
	uint32 softQueueLimit = (uint32)(thePrefs.GetQueueSize()*0.8f);
	if(hardQueueLimit - softQueueLimit < 200)
		softQueueLimit = hardQueueLimit-200;    
//<<< WiZaRd::QueueSize FiX
// <-------- fix

    // if soft queue limit has been reached, only let in high ranking clients

// Contrib - InfiniteQueue
	if (!thePrefs.IsInfiniteQueueEnabled())//>>> shadow2004::InfiniteQueue [SLUGFILLER]
// <-------- InfiniteQueue

    if ((uint32)waitinglist.GetCount() >= hardQueueLimit ||
        (uint32)waitinglist.GetCount() >= softQueueLimit && // soft queue limit is reached
        (client->IsFriend() && client->GetFriendSlot()) == false && // client is not a friend with friend slot

// Contrib - PowerShare
//>>> WiZaRd::PowerShare
			!client->IsPowerShared() && //>>> WiZaRd::PowerShare
//<<< WiZaRd::PowerShare
// <-------- PowerShare

        client->GetCombinedFilePrioAndCredit() < GetAverageCombinedFilePrioAndCredit()) { // and client has lower credits/wants lower prio file than average client in queue

        // then block client from getting on queue
		return;
	}
	if (client->IsDownloading())
	{

// Contrib - Don't allow file hot swapping
		if (thePrefs.CloseMaellaBackdoor()){
			RemoveFromUploadQueue(client, _T("wrong file"),true);
			client->SendOutOfPartReqsAndAddToWaitingQueue();

// Contrib - SUQWT (soft "punish")
// X-Ray :: Argos
			client->SetWaitStartTime(); // X-Ray :: SUQWT
// <-------- SUQWT

			return;
		}
// <-------- Don't allow file hot swapping

		// he's already downloading and wants probably only another file
		if (thePrefs.GetDebugClientTCPLevel() > 0)
			DebugSend("OP__AcceptUploadReq", client);
		Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
		theStats.AddUpDataOverheadFileRequest(packet->size);
		client->SendPacket(packet, true);
		return;
	}

// Contrib - SUQWT
	// ==> SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
	if (client->Credits() != NULL)
	{
		if (client->GetGiveWaittimeBack())
		{
			client->Credits()->SetSecWaitStartTime(100);
			client->SetGiveWaittimeBack(false);
//			AddDebugLogLine(false, _T("client had waitingtime: %s 100% recovered, client: %s"), CastSecondsToHM((::GetTickCount() - client->GetWaitStartTime())/1000),client->DbgGetClientInfo());
		}
		else
			client->Credits()->SetSecWaitStartTime();
	}
	// <== SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
// <-------- SUQWT

// Contrib - fix
//>>> WiZaRd::Startup Flood Prevention
	//Requested by James R. Bath
	//http://forum.emule-project.net/index.php?showtopic=101181
/*
	if (waitinglist.IsEmpty() && ForceNewClient(true))
	{

// By Taz - fix not needed due to SUQWT code above
// Contrib - fix fox88 ( http://forum.emule-project.net/index.php?showtopic=145197 )
//		client->SetWaitStartTime(); //added
// <-------- fix
// <------- fix

		AddUpNextClient(_T("Direct add with empty queue."), client);
	}
	else
*/
//<<< WiZaRd::Startup Flood Prevention
// <-------- fix

	{
		waitinglist.AddTail(client);
		client->SetUploadState(US_ONUPLOADQUEUE);
		theApp.emuledlg->transferwnd->queuelistctrl.AddClient(client,true);

// Contrib - optimization
// WiZaRd
/*
		theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
*/
		theApp.emuledlg->transferwnd->ShowQueueCount();
// <------- optimization

		client->SendRankingInfo();
	}
}

float CUploadQueue::GetAverageCombinedFilePrioAndCredit() {
    DWORD curTick = ::GetTickCount();

    if (curTick - m_dwLastCalculatedAverageCombinedFilePrioAndCredit > 5*1000) {
        m_dwLastCalculatedAverageCombinedFilePrioAndCredit = curTick;

        // TODO: is there a risk of overflow? I don't think so...
        double sum = 0;
	    for (POSITION pos = waitinglist.GetHeadPosition(); pos != NULL; /**/){
		    CUpDownClient* cur_client =	waitinglist.GetNext(pos);
            sum += cur_client->GetCombinedFilePrioAndCredit();
        }
        m_fAverageCombinedFilePrioAndCredit = (float)(sum/waitinglist.GetSize());
    }

    return m_fAverageCombinedFilePrioAndCredit;
}

bool CUploadQueue::RemoveFromUploadQueue(CUpDownClient* client, LPCTSTR pszReason, bool updatewindow, bool earlyabort){
    bool result = false;
    uint32 slotCounter = 1;
	for (POSITION pos = uploadinglist.GetHeadPosition();pos != 0;){
        POSITION curPos = pos;
        CUpDownClient* curClient = uploadinglist.GetNext(pos);
		if (client == curClient){

// Contrib - fix zz
            if(client->socket) {
			    if (thePrefs.GetDebugClientTCPLevel() > 0)
				    DebugSend("OP__OutOfPartReqs", client);
			    Packet* pCancelTransferPacket = new Packet(OP_OUTOFPARTREQS, 0);
			    theStats.AddUpDataOverheadFileRequest(pCancelTransferPacket->size);
			    client->socket->SendPacket(pCancelTransferPacket,true,true);
            }
// <-------- fix

			if (updatewindow)
				theApp.emuledlg->transferwnd->uploadlistctrl.RemoveClient(client);

			if (thePrefs.GetLogUlDlEvents())
                AddDebugLogLine(DLP_DEFAULT, true,_T("Removing client from upload list: %s Client: %s Transferred: %s SessionUp: %s QueueSessionPayload: %s In buffer: %s Req blocks: %i File: %s"), pszReason==NULL ? _T("") : pszReason, client->DbgGetClientInfo(), CastSecondsToHM( client->GetUpStartTimeDelay()/1000), CastItoXBytes(client->GetSessionUp(), false, false), CastItoXBytes(client->GetQueueSessionPayloadUp(), false, false), CastItoXBytes(client->GetPayloadInBuffer()), client->GetNumberOfRequestedBlocksInQueue(), (theApp.sharedfiles->GetFileByID(client->GetUploadFileID())?theApp.sharedfiles->GetFileByID(client->GetUploadFileID())->GetFileName():_T("")));
            client->m_bAddNextConnect = false;
			uploadinglist.RemoveAt(curPos);

            bool removed = theApp.uploadBandwidthThrottler->RemoveFromStandardList(client->socket);
            bool pcRemoved = theApp.uploadBandwidthThrottler->RemoveFromStandardList((CClientReqSocket*)client->m_pPCUpSocket);
			(void)removed;
			(void)pcRemoved;
            //if(thePrefs.GetLogUlDlEvents() && !(removed || pcRemoved)) {
            //    AddDebugLogLine(false, _T("UploadQueue: Didn't find socket to delete. Adress: 0x%x"), client->socket);
            //}

			if(client->GetSessionUp() > 0) {

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
				if(client->pAntiLeechData)
					client->pAntiLeechData->AddULSession(false);
#endif
// <-------- ClientAnalyzer

				++successfullupcount;
				totaluploadtime += client->GetUpStartTimeDelay()/1000;
            } else if(earlyabort == false)
			{

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
				if(client->pAntiLeechData)
					client->pAntiLeechData->AddULSession(true);
#endif
// <-------- ClientAnalyzer

				++failedupcount;
			}

// Contrib - optimization requpfile
		//MORPH START - Adde by SiRoB, Optimization requpfile
		/*
            CKnownFile* requestedFile = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());
		*/
		CKnownFile* requestedFile = client->CheckAndGetReqUpFile();
		//MORPH END   - Adde by SiRoB, Optimization requpfile
// <-------- optimization requpfile

            if(requestedFile != NULL) {
                requestedFile->UpdatePartsInfo();
            }
			theApp.clientlist->AddTrackClient(client); // Keep track of this client
			client->SetUploadState(US_NONE);
			client->ClearUploadBlockRequests();
			client->SetCollectionUploadSlot(false);

            m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = 0;

// Contrib - SUQWT
			// ==> SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
			if (client->Credits()!=NULL) {
				/* // no need to check this since the call is commented anyways
				if(earlyabort == true)
				{
					//client->Credits()->SaveUploadQueueWaitTime();
				}
				else if(client->GetSessionUp() < PARTSIZE)
				*/
				if(client->GetSessionUp() < PARTSIZE)
				{
					uint32 waitingtime= (uint32)(client->GetWaitTime() );
					int keeppct = (int)(100 * client->GetSessionUp()/PARTSIZE);
					if(keeppct < 10)
						keeppct = 10; // min 10% penalty
					keeppct = 100 - keeppct;
					client->Credits()->SaveUploadQueueWaitTime(keeppct);
					client->Credits()->SetSecWaitStartTime(keeppct);
					client->SetGiveWaittimeBack(true);
					AddDebugLogLine(false, _T("giving client bonus. old waitingtime: %s, new waitingtime: %s, client: %s"), CastSecondsToHM(waitingtime/1000), CastSecondsToHM((::GetTickCount() - client->GetWaitStartTime())/1000),client->DbgGetClientInfo());
				}
				else
				{
					client->Credits()->ClearUploadQueueWaitTime();
					client->Credits()->ClearWaitStartTime();
				}
			}
			// <== SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
// <-------- SUQWT

			result = true;
        } else {
            curClient->SetSlotNumber(slotCounter);
            slotCounter++;
        }
	}
	return result;
}

uint32 CUploadQueue::GetAverageUpTime(){
	if( successfullupcount ){
		return totaluploadtime/successfullupcount;
	}
	return 0;
}

bool CUploadQueue::RemoveFromWaitingQueue(CUpDownClient* client, bool updatewindow){
	POSITION pos = waitinglist.Find(client);
	if (pos){
		RemoveFromWaitingQueue(pos,updatewindow);
		return true;
	}
	else
		return false;
}

void CUploadQueue::RemoveFromWaitingQueue(POSITION pos, bool updatewindow){	
	CUpDownClient* todelete = waitinglist.GetAt(pos);
	waitinglist.RemoveAt(pos);
	if (updatewindow) {
		theApp.emuledlg->transferwnd->queuelistctrl.RemoveClient(todelete);

// Contrib - optimization
//>>> WiZaRd::FiX
/*
		theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
*/
		theApp.emuledlg->transferwnd->ShowQueueCount();
//<<< WiZaRd::FiX
// <-------- optimization

	}

// Contrib - SUQWT
	// ==> SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
	if (theApp.clientcredits->IsSaveUploadQueueWaitTime()){
		todelete->Credits()->SaveUploadQueueWaitTime();
	}
	// <== SUQWT [Moonlight/EastShare/ MorphXT] - Stulle
// <-------- SUQWT

	todelete->m_bAddNextConnect = false;
	todelete->SetUploadState(US_NONE);
}

void CUploadQueue::UpdateMaxClientScore()
{
	m_imaxscore=0;
	for(POSITION pos = waitinglist.GetHeadPosition(); pos != 0; ) {
		uint32 score = waitinglist.GetNext(pos)->GetScore(true, false);
		if(score > m_imaxscore )
			m_imaxscore=score;
	}
}

bool CUploadQueue::CheckForTimeOver(CUpDownClient* client){
	//If we have nobody in the queue, do NOT remove the current uploads..
	//This will save some bandwidth and some unneeded swapping from upload/queue/upload..
	if ( waitinglist.IsEmpty() || client->GetFriendSlot() )
		return false;
	
	if(client->HasCollectionUploadSlot()){
		CKnownFile* pDownloadingFile = theApp.sharedfiles->GetFileByID(client->requpfileid);
		if(pDownloadingFile == NULL)
			return true;
		if (CCollection::HasCollectionExtention(pDownloadingFile->GetFileName()) && pDownloadingFile->GetFileSize() < (uint64)MAXPRIORITYCOLL_SIZE)
			return false;
		else{
			if (thePrefs.GetLogUlDlEvents())
				AddDebugLogLine(DLP_HIGH, false, _T("%s: Upload session ended - client with Collection Slot tried to request blocks from another file"), client->GetUserName());
			return true;
		}
	}
	
// By Taz - auto full chunk
/*
	if (!thePrefs.TransferFullChunks()){
	    if( client->GetUpStartTimeDelay() > SESSIONMAXTIME){ // Try to keep the clients from downloading for ever
		    if (thePrefs.GetLogUlDlEvents())
			    AddDebugLogLine(DLP_LOW, false, _T("%s: Upload session ended due to max time %s."), client->GetUserName(), CastSecondsToHM(SESSIONMAXTIME/1000));
		    return true;
	    }

		// Cache current client score
		const uint32 score = client->GetScore(true, true);

		// Check if another client has a bigger score
		if (score < GetMaxClientScore() && m_dwRemovedClientByScore < GetTickCount()) {
			if (thePrefs.GetLogUlDlEvents())
				AddDebugLogLine(DLP_VERYLOW, false, _T("%s: Upload session ended due to score."), client->GetUserName());
			//Set timer to prevent to many uploadslot getting kick do to score.
			//Upload slots are delayed by a min of 1 sec and the maxscore is reset every 5 sec.
			//So, I choose 6 secs to make sure the maxscore it updated before doing this again.
			m_dwRemovedClientByScore = GetTickCount()+SEC2MS(6);
			return true;
		}
	}
	else{
*/
	{
// <------- auto full chunk

		// Allow the client to download a specified amount per session

// Contrib - auto full chunk
/*
		if( client->GetQueueSessionPayloadUp() > SESSIONMAXTRANS ){
*/
		if(/*!client->GetFriendSlot() && */client->GetRemainingUp() <= 0) 	// VQB: fullChunk
		{
// <-------- auto full chunk

			if (thePrefs.GetLogUlDlEvents())
				AddDebugLogLine(DLP_DEFAULT, false, _T("%s: Upload session ended due to max transferred amount. %s"), client->GetUserName(), CastItoXBytes(SESSIONMAXTRANS, false, false));
			return true;
		}
	}
	return false;
}

void CUploadQueue::DeleteAll(){
	waitinglist.RemoveAll();
	uploadinglist.RemoveAll();
    // PENDING: Remove from UploadBandwidthThrottler as well!
}

UINT CUploadQueue::GetWaitingPosition(CUpDownClient* client)
{

// Contrib - optimization
	//MORPH - Changed by SiRoB, Optimization
	/*
	if (!IsOnUploadQueue(client))
	*/
	ASSERT((client->GetUploadState() == US_ONUPLOADQUEUE) == IsOnUploadQueue(client));
	if (client->GetUploadState() != US_ONUPLOADQUEUE)
// <-------- optimization

		return 0;
	UINT rank = 1;
	UINT myscore = client->GetScore(false);

// Contrib - PowerShare
	bool bPSCheck = client->IsPowerShared(); //>>> WiZaRd::PowerShare
// <-------- PowerShare

	for (POSITION pos = waitinglist.GetHeadPosition(); pos != 0; ){

// Contrib - PowerShare
//>>> WiZaRd::PowerShare
		CUpDownClient* cur_src = waitinglist.GetNext(pos);
		if(((!bPSCheck || cur_src->IsPowerShared())

// Contrib - One-queue-per-file
			|| (thePrefs.GetEnableMultiQueue() && md4cmp(client->GetUploadFileID(), cur_src->GetUploadFileID()) == 0)) // Maella -One-queue-per-file- (idea bloodymad)
// <-------- One-queue-per-file

			&& cur_src->GetScore(false) > myscore)
/*
		if (waitinglist.GetNext(pos)->GetScore(false) > myscore)
*/
//<<< WiZaRd::PowerShare
// <-------- PowerShare

			rank++;
	}
	return rank;
}

VOID CALLBACK CUploadQueue::UploadTimer(HWND /*hwnd*/, UINT /*uMsg*/, UINT_PTR /*idEvent*/, DWORD /*dwTime*/)
{
	// NOTE: Always handle all type of MFC exceptions in TimerProcs - otherwise we'll get mem leaks
	try
	{
		// Barry - Don't do anything if the app is shutting down - can cause unhandled exceptions
		if (!theApp.emuledlg->IsRunning())
			return;

// Contrib - optimization
		const DWORD curTick = ::GetTickCount(); //cache it...
// <-------- optimization

// Contrib - Connection Checker
//>>> Spike2::ConChecker [eWombat]
		theApp.conchecker.Process(curTick);
//<<< Spike2::ConChecker [eWombat]
// <-------- Connection Checker

// Contrib - SafeHash
		// SLUGFILLER: SafeHash - let eMule start first
		if (theApp.emuledlg->status != 255)
			return;
		// SLUGFILLER: SafeHash
// <-------- SafeHash

        // Elandal:ThreadSafeLogging -->
        // other threads may have queued up log lines. This prints them.
        theApp.HandleDebugLogQueue();
        theApp.HandleLogQueue();
        // Elandal: ThreadSafeLogging <--

		// ZZ:UploadSpeedSense -->

// Contrib - zz bandwidth control
/*
		theApp.lastCommonRouteFinder->SetPrefs(thePrefs.IsDynUpEnabled(), 
			theApp.uploadqueue->GetDatarate(), 
			thePrefs.GetMinUpload()*1024, 
			(thePrefs.GetMaxUpload() != 0) ? thePrefs.GetMaxUpload() * 1024 : thePrefs.GetMaxGraphUploadRate(false) * 1024, 
			thePrefs.IsDynUpUseMillisecondPingTolerance(), 
			(thePrefs.GetDynUpPingTolerance() > 100) ? ((thePrefs.GetDynUpPingTolerance() - 100) / 100.0f) : 0, 
			thePrefs.GetDynUpPingToleranceMilliseconds(), 
			thePrefs.GetDynUpGoingUpDivider(), 
			thePrefs.GetDynUpGoingDownDivider(), 
			thePrefs.GetDynUpNumberOfPings(), 
			20); // PENDING: Hard coded min pLowestPingAllowed
*/
		theApp.lastCommonRouteFinder->SetPrefs(thePrefs.IsDynUpEnabled(), 
			theApp.uploadqueue->GetDatarate(), 
			thePrefs.GetMinUpload()*1024, 
			(thePrefs.GetMaxUpload() != 0) ? thePrefs.GetMaxUpload() * 1024 : thePrefs.GetMaxGraphUploadRate(false) * 1024, 
			thePrefs.IsDynUpUseMillisecondPingTolerance(), 
			thePrefs.GetDynUpPingTolerance() / 100.0f,
			thePrefs.GetDynUpPingToleranceMilliseconds(), 
			thePrefs.GetDynUpGoingUpDivider(), 
			thePrefs.GetDynUpGoingDownDivider(), 
			thePrefs.GetDynUpNumberOfPings(), 
			10,  // PENDING: Hard coded min pLowestPingAllowed
            theApp.uploadqueue->GetActiveUploadsCount() > (UINT)theApp.uploadqueue->GetUploadQueueLength());
// <-------- zz bandwidth control

		// ZZ:UploadSpeedSense <--

        theApp.uploadqueue->Process();
		theApp.downloadqueue->Process();
		if (thePrefs.ShowOverhead()){
			theStats.CompUpDatarateOverhead();
			theStats.CompDownDatarateOverhead();
		}
		counter++;

		// one second
		if (counter >= 10){
			counter=0;

			// try to use different time intervals here to not create any disk-IO bottle necks by saving all files at once
			theApp.clientcredits->Process();	// 13 minutes
			theApp.serverlist->Process();		// 17 minutes
			theApp.knownfiles->Process();		// 11 minutes

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
			theApp.antileechlist->Process();	// 18 minutes  //>>> WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

			theApp.friendlist->Process();		// 19 minutes
			theApp.clientlist->Process();
			theApp.sharedfiles->Process();
			if( Kademlia::CKademlia::IsRunning() )
			{
				Kademlia::CKademlia::Process();
				if(Kademlia::CKademlia::GetPrefs()->HasLostConnection())
				{
					Kademlia::CKademlia::Stop();
					theApp.emuledlg->ShowConnectionState();
				}
			}
			if( theApp.serverconnect->IsConnecting() && !theApp.serverconnect->IsSingleConnect() )
				theApp.serverconnect->TryAnotherConnectionRequest();

			theApp.listensocket->UpdateConnectionsStatus();
			if (thePrefs.WatchClipboard4ED2KLinks()) {
				// TODO: Remove this from here. This has to be done with a clipboard chain
				// and *not* with a timer!!
				theApp.SearchClipboard();
			}

			if (theApp.serverconnect->IsConnecting())
				theApp.serverconnect->CheckForTimeout();

			// -khaos--+++> Update connection stats...
			iupdateconnstats++;
			// 2 seconds
			if (iupdateconnstats>=2) {
				iupdateconnstats=0;
				theStats.UpdateConnectionStats((float)theApp.uploadqueue->GetDatarate()/1024, (float)theApp.downloadqueue->GetDatarate()/1024);
			}
			// <-----khaos-

			// display graphs
			if (thePrefs.GetTrafficOMeterInterval()>0) {
				igraph++;

				if (igraph >= (uint32)(thePrefs.GetTrafficOMeterInterval()) ) {
					igraph=0;
					//theApp.emuledlg->statisticswnd->SetCurrentRate((float)(theApp.uploadqueue->Getavgupload()/theApp.uploadqueue->Getavg())/1024,(float)(theApp.uploadqueue->Getavgdownload()/theApp.uploadqueue->Getavg())/1024);
					theApp.emuledlg->statisticswnd->SetCurrentRate((float)(theApp.uploadqueue->GetDatarate())/1024,(float)(theApp.downloadqueue->GetDatarate())/1024);
					//theApp.uploadqueue->Zeroavg();
				}
			}
			if (theApp.emuledlg->activewnd == theApp.emuledlg->statisticswnd && theApp.emuledlg->IsWindowVisible() )  {
				// display stats
				if (thePrefs.GetStatsInterval()>0) {
					istats++;

					if (istats >= (uint32)(thePrefs.GetStatsInterval()) ) {
						istats=0;
						theApp.emuledlg->statisticswnd->ShowStatistics();
					}
				}
			}

            theApp.uploadqueue->UpdateDatarates();
            
            //save rates every second
			theStats.RecordRate();

// Contrib - Extended clean-up
			theApp.clientlist->CleanUpClientList(); //Maella -Extended clean-up II-
// <-------- Extended clean-up

			// mobilemule sockets
			theApp.mmserver->Process();

			// ZZ:UploadSpeedSense -->
            theApp.emuledlg->ShowPing();

            bool gotEnoughHosts = theApp.clientlist->GiveClientsForTraceRoute();
            if(gotEnoughHosts == false) {
                theApp.serverlist->GiveServersForTraceRoute();
            }
			// ZZ:UploadSpeedSense <--

			if (theApp.emuledlg->IsTrayIconToFlash())
				theApp.emuledlg->ShowTransferRate(true);

            sec++;
			// *** 5 seconds **********************************************
			if (sec >= 5) {
#ifdef _DEBUG
				if (thePrefs.m_iDbgHeap > 0 && !AfxCheckMemory())
					AfxDebugBreak();
#endif

				sec = 0;
				theApp.listensocket->Process();

// Contrib - QuickStart
				theApp.downloadqueue->ProcessQuickStart(); // NEO: QS - [QuickStart] <-- Xanatos --
// <-------- QuickStart

// Contrib - optimization
				if(thePrefs.IsOnlineSignatureEnabled())
// <-------- optimization

				theApp.OnlineSig(); // Added By Bouc7 
				if (!theApp.emuledlg->IsTrayIconToFlash())
					theApp.emuledlg->ShowTransferRate();
				thePrefs.EstimateMaxUploadCap(theApp.uploadqueue->GetDatarate()/1024);
				
// Contrib - Automatic Firewalled Retries
//>>> WiZaRd::Automatic Firewalled Retries
				//15 retries = 30 mins!
#define MAX_FIREWALLED_RETRIES	15
				if(curTick - m_dwFirewalledTimer > MIN2MS(2))
				{
					m_dwFirewalledTimer = curTick;
					if(Kademlia::CKademlia::IsConnected() && Kademlia::CKademlia::IsFirewalled())
					{
						if(m_iFirewalledRetries < MAX_FIREWALLED_RETRIES)
						{
							theApp.QueueLogLineEx(LOG_WARNING, L"Rechecking firewalled status - try %u out of %u...", m_iFirewalledRetries + 1, MAX_FIREWALLED_RETRIES);
							// Refresh der Portmappings ? [shadow2004]
							// some routers seems to loose the settings after a while
							Kademlia::CKademlia::RecheckFirewalled();
						}
						else if(m_iFirewalledRetries == MAX_FIREWALLED_RETRIES)
							theApp.QueueLogLineEx(LOG_ERROR, L"Rechecking firewalled status failed %u times - stopping checks...", MAX_FIREWALLED_RETRIES);
						m_iFirewalledRetries++;
					}
					else
						m_iFirewalledRetries = 0;
				}
//<<< WiZaRd::Automatic Firewalled Retries
// <-------- Automatic Firewalled Retries

// By Taz - auto full chunk
/*
				if (!thePrefs.TransferFullChunks())
					theApp.uploadqueue->UpdateMaxClientScore();
*/
// <------- auto full chunk

				// update cat-titles with downloadinfos only when needed
				if (thePrefs.ShowCatTabInfos() && 
					theApp.emuledlg->activewnd == theApp.emuledlg->transferwnd && 
					theApp.emuledlg->IsWindowVisible()) 
						theApp.emuledlg->transferwnd->UpdateCatTabTitles(false);
				
				if (thePrefs.IsSchedulerEnabled())
					theApp.scheduler->Check();

// Contrib - optimization
// WiZaRd
/*
                theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2Uploading, -1);
*/
				theApp.emuledlg->transferwnd->UpdateListCount(wnd2Uploading);
// <------- optimization

			}

			statsave++;
			// *** 60 seconds *********************************************
			if (statsave >= 60) {
				statsave=0;

				if (thePrefs.GetWSIsEnabled())
					theApp.webserver->UpdateSessionCount();

				theApp.serverconnect->KeepConnectionAlive();

				if (thePrefs.GetPreventStandby())
					theApp.ResetStandByIdleTimer(); // Reset Windows idle standby timer if necessary
			}

			s_uSaveStatistics++;
			if (s_uSaveStatistics >= thePrefs.GetStatsSaveInterval())
			{
				s_uSaveStatistics = 0;
				thePrefs.SaveStats();
			}
		}

		// need more accuracy here. don't rely on the 'sec' and 'statsave' helpers.
		thePerfLog.LogSamples();
	}
	CATCH_DFLT_EXCEPTIONS(_T("CUploadQueue::UploadTimer"))
}

CUpDownClient* CUploadQueue::GetNextClient(const CUpDownClient* lastclient){
	if (waitinglist.IsEmpty())
		return 0;
	if (!lastclient)
		return waitinglist.GetHead();
	POSITION pos = waitinglist.Find(const_cast<CUpDownClient*>(lastclient));
	if (!pos){
		TRACE("Error: CUploadQueue::GetNextClient");
		return waitinglist.GetHead();
	}
	waitinglist.GetNext(pos);
	if (!pos)
		return NULL;
	else
		return waitinglist.GetAt(pos);
}

void CUploadQueue::UpdateDatarates() {
    // Calculate average datarate
    if(::GetTickCount()-m_lastCalculatedDataRateTick > 500) {
        m_lastCalculatedDataRateTick = ::GetTickCount();

        if(avarage_dr_list.GetSize() >= 2 && (avarage_tick_list.GetTail() > avarage_tick_list.GetHead())) {
	        datarate = (UINT)(((m_avarage_dr_sum - avarage_dr_list.GetHead())*1000) / (avarage_tick_list.GetTail() - avarage_tick_list.GetHead()));
            friendDatarate = (UINT)(((avarage_friend_dr_list.GetTail() - avarage_friend_dr_list.GetHead())*1000) / (avarage_tick_list.GetTail() - avarage_tick_list.GetHead()));
        }
    }
}

uint32 CUploadQueue::GetDatarate() {
    return datarate;
}

uint32 CUploadQueue::GetToNetworkDatarate() {
    if(datarate > friendDatarate) {
        return datarate - friendDatarate;
    } else {
        return 0;
    }
}

void CUploadQueue::ReSortUploadSlots(bool force) {
    DWORD curtick = ::GetTickCount();
    if(force ||  curtick - m_dwLastResortedUploadSlots >= 10*1000) {
        m_dwLastResortedUploadSlots = curtick;

        theApp.uploadBandwidthThrottler->Pause(true);

    	CTypedPtrList<CPtrList, CUpDownClient*> tempUploadinglist;

        // Remove all clients from uploading list and store in tempList
        POSITION ulpos = uploadinglist.GetHeadPosition();
        while (ulpos != NULL) {
            POSITION curpos = ulpos;
            uploadinglist.GetNext(ulpos);

            // Get and remove the client from upload list.
		    CUpDownClient* cur_client = uploadinglist.GetAt(curpos);

            uploadinglist.RemoveAt(curpos);

            // Remove the found Client from UploadBandwidthThrottler
            theApp.uploadBandwidthThrottler->RemoveFromStandardList(cur_client->socket);
            theApp.uploadBandwidthThrottler->RemoveFromStandardList((CClientReqSocket*)cur_client->m_pPCUpSocket);

            tempUploadinglist.AddTail(cur_client);
        }

        // Remove one at a time from temp list and reinsert in correct position in uploading list
        POSITION tempPos = tempUploadinglist.GetHeadPosition();
        while(tempPos != NULL) {
            POSITION curpos = tempPos;
            tempUploadinglist.GetNext(tempPos);

            // Get and remove the client from upload list.
		    CUpDownClient* cur_client = tempUploadinglist.GetAt(curpos);

            tempUploadinglist.RemoveAt(curpos);

            // This will insert in correct place
            InsertInUploadingList(cur_client);
        }

        theApp.uploadBandwidthThrottler->Pause(false);
    }
}

// Contrib - auto full chunk
// VQB: fullChunk
void CUploadQueue::UpdateRemainingUp()
{
	for(POSITION pos = uploadinglist.GetHeadPosition(); pos;)
		uploadinglist.GetNext(pos)->UpdateRemainingUp();
}
// VQB: fullChunk
// <-------- auto full chunk