//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "emuleDlg.h"
#include "PPgMOD3.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Opcodes.h"
#include "ServerWnd.h"//Ackronic - AcKroNiC/EneTec Servers Filter

// By Taz - ASFv2
#include "ServerListCtrl.h"
// <------- ASFv2

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgMOD3, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgMOD3, CPropertyPage)
	//Ackronic START - AcKroNiC/EneTec Servers Filter
	ON_EN_CHANGE(IDC_FILTERNAME, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERDESC, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERUSERVAL, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERFILEVAL, OnSettingsChange)
	ON_BN_CLICKED(IDC_ASF_AUTOFILTER , OnSettingsChange)
	ON_BN_CLICKED(IDC_STATIC,OnBnClickedAckHelp)
	//Ackronic END - AcKroNiC/EneTec Servers Filter

// By Taz - ASFv2
	ON_BN_CLICKED(IDC_ASF_ON, OnBnClickedASF_ON)
	ON_BN_CLICKED(IDC_SERVERANALYZER_ON, OnBnClickedSERVERANALYZER_ON)
	ON_BN_CLICKED(IDC_ASF_AUTOFILTER, OnSettingsChange)
// <------- ASFv2

	//Ackronic START - Links
	ON_BN_CLICKED(IDC_ACKHELP,OnBnClickedAckHelp)

// Contrib - fix
	ON_BN_CLICKED(IDC_ACKHELP2,OnBnClickedAckHelp2)//Mulo da Soma - restore 3button-link now pointing to AcKroNiC WiKi
// <-------- fix

	ON_BN_CLICKED(IDC_ACKHELP3,OnBnClickedAckHelp3)
	//Ackronic END - Links

	//ON_WM_HELPINFO()
	ON_WM_HSCROLL()
	ON_WM_DESTROY()
END_MESSAGE_MAP()

CPPgMOD3::CPPgMOD3()
	: CPropertyPage(CPPgMOD3::IDD)
{

// By Taz - ASFv2
	m_iFilter = (thePrefs.ASF_ON() ? 0 : 1);
// <------- ASFv2

}

CPPgMOD3::~CPPgMOD3()
{
}

void CPPgMOD3::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

// By Taz - ASFv2
	DDX_Radio(pDX, IDC_ASF_ON, m_iFilter);
// <------- ASFv2

}

BOOL CPPgMOD3::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgMOD3::LoadSettings(void)
{
	//Ackronic START: AcKroNiC/EneTec Servers Filter
	GetDlgItem(IDC_FILTERNAME)->SetWindowText(thePrefs.ServerFilterVal);
	GetDlgItem(IDC_FILTERDESC)->SetWindowText(thePrefs.ServerFilterDesc);
	SetDlgItemInt(IDC_FILTERUSERVAL, thePrefs.ServerFilterByUsers, FALSE);
	SetDlgItemInt(IDC_FILTERFILEVAL, thePrefs.ServerFilterByFiles, FALSE);

// By Taz - ASFv2
	m_iFilter = (thePrefs.ASF_ON() ? 0 : 1);
	GetDlgItem(IDC_ASF_AUTOFILTER)->EnableWindow(thePrefs.ASF_ON());
	CheckRadioButton(IDC_ASF_AUTOFILTER, IDC_SERVERANALYZER_ON, IDC_ASF_AUTOFILTER + m_iFilter);

	if(!thePrefs.ASF_ON())
		thePrefs.SetASF_AutoFilter(false);
// <------- ASFv2

	if(thePrefs.ASF_AutoFilter())
		CheckDlgButton(IDC_ASF_AUTOFILTER,1);
	else
		CheckDlgButton(IDC_ASF_AUTOFILTER,0);
	//Ackronic END: AcKroNiC/EneTec Servers Filter
}

BOOL CPPgMOD3::OnApply()
{
	if (!UpdateData())
		return FALSE;

	//Ackronic START - AcKroNiC/EneTec Servers Filter
	GetDlgItem(IDC_FILTERNAME)->GetWindowText(thePrefs.ServerFilterVal,ARRSIZE(thePrefs.ServerFilterVal));
	GetDlgItem(IDC_FILTERDESC)->GetWindowText(thePrefs.ServerFilterDesc,ARRSIZE(thePrefs.ServerFilterDesc));

	thePrefs.ServerFilterByUsers = GetDlgItemInt(IDC_FILTERUSERVAL, NULL, FALSE);
	if (thePrefs.ServerFilterByUsers < 0)
		thePrefs.ServerFilterByUsers = 0;
	else if (thePrefs.ServerFilterByUsers > 1000000000)
		thePrefs.ServerFilterByUsers = 1000000000;

	thePrefs.ServerFilterByFiles = GetDlgItemInt(IDC_FILTERFILEVAL, NULL, FALSE);
	if (thePrefs.ServerFilterByFiles < 0)
		thePrefs.ServerFilterByFiles = 0;
	else if (thePrefs.ServerFilterByFiles > 1000000000)
		thePrefs.ServerFilterByFiles = 1000000000;

// By Taz - ASFv2
	if (thePrefs.ASF_ON()!= (m_iFilter == 0)){
		theApp.emuledlg->serverwnd->serverlistctrl.ShowServers();
		thePrefs.SetASF(m_iFilter == 0);
	}
// <------- ASFv2

	thePrefs.SetASF_AutoFilter(IsDlgButtonChecked(IDC_ASF_AUTOFILTER)!=0);

	if(thePrefs.ASF_AutoFilter())
		theApp.emuledlg->serverwnd->OnBnClickedServerFilterDlg();

	theApp.emuledlg->serverwnd->GetDlgItem(IDC_SRVFILTER_BTN)->EnableWindow(thePrefs.ASF_ON() && !thePrefs.ASF_AutoFilter());
	//Ackronic END - AcKroNiC/EneTec Servers Filter

	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgMOD3::Localize(void)
{
	if (m_hWnd)
	{

		//Ackronic START - Links
		GetDlgItem(IDC_ACKHELP)->SetWindowText(GetResString(IDS_ACKHELP));

// Contrib - fix
		GetDlgItem(IDC_ACKHELP2)->SetWindowText(GetResString(IDS_ACKHELP2));//Mulo da Soma - Restore 3 button-link now pointing to AcKroNiC WiKi
// <-------- fix

		GetDlgItem(IDC_ACKHELP3)->SetWindowText(GetResString(IDS_ACKHELP3));
		//Ackronic END - Links
		//Ackronic START - AcKroNiC/EneTec Servers Filter
		GetDlgItem(IDC_FILTERNAMELABEL)->SetWindowText(GetResString(IDS_FILTERNAMELABEL));
		GetDlgItem(IDC_FILTERDESCLABEL)->SetWindowText(GetResString(IDS_FILTERDESCLABEL));
		GetDlgItem(IDC_FILTERUSER)->SetWindowText(GetResString(IDS_FILTERUSERS_DESC));
		GetDlgItem(IDC_FILTERUSER2)->SetWindowText(GetResString(IDS_LUSERS));
		GetDlgItem(IDC_FILTERFILE)->SetWindowText(GetResString(IDS_FILTERUSERS_DESC));
		GetDlgItem(IDC_FILTERFILE2)->SetWindowText(GetResString(IDS_FILES));
		GetDlgItem(IDC_ASF_AUTOFILTER)->SetWindowText(GetResString(IDS_ASF_AUTOFILTER));
		//Ackronic END - AcKroNiC/EneTec Servers Filter

// By Taz - ASFv2
		GetDlgItem(IDC_ASF_ON)->SetWindowText(GetResString(IDS_ASF_ON));
		GetDlgItem(IDC_SERVERANALYZER_ON)->SetWindowText(GetResString(IDS_SERVERANALYZER_ON));
		GetDlgItem(IDC_ASF_AUTOFILTER)->SetWindowText(GetResString(IDS_ASF_AUTOFILTER));
// <------- ASFv2

	}
}
//Ackronic START - Links
void CPPgMOD3::OnBnClickedAckHelp()
{

// Contrib - fix
/*
TCHAR link[64];
_tcscpy (link, _T("http://www.ackronic.net/ackws/guida/helpack4.html"));

ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
void CPPgMOD3::OnBnClickedAckHelp3()
{
TCHAR link[64];
_tcscpy (link, _T("http://www.emulesecurity.net/"));
*/
TCHAR link[128];//Mulo da Soma - add more blanks in text-area
_tcscpy (link, L"http://www.ackronic.net/ackws/smf/index.php?cat=105");//Mulo da Soma - now link points to new guide link
ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
void CPPgMOD3::OnBnClickedAckHelp2()
{
TCHAR link[128];//Add by Mulo da Soma - new text-area about 3 link-button
_tcscpy (link, L"http://wiki.darkforge.eu/wiki/index.php?title=EMule_AcKroNiC_Wiki_ITA");//added by Mulo da Soma - restore 3 link-button pointing to AcKroNiC WiKi
ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
void CPPgMOD3::OnBnClickedAckHelp3()
{
TCHAR link[128];//Mulo da Soma - add more blanks in text-area
_tcscpy (link, L"http://www.ackronic.net/ackws/smf/index.php?board=40.0");//changed by Mulo da Soma - now link points to AcKroNiC forum
// <-------- fix

ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
//Ackronic END - Links

// By Taz - ASFv2
void CPPgMOD3::OnBnClickedASF_ON(){
	GetDlgItem(IDC_ASF_AUTOFILTER)->EnableWindow(TRUE);
	CheckRadioButton(IDC_ASF_AUTOFILTER, IDC_SERVERANALYZER_ON, IDC_ASF_AUTOFILTER);
	m_iFilter = 0;
	OnSettingsChange();
}

void CPPgMOD3::OnBnClickedSERVERANALYZER_ON(){
	GetDlgItem(IDC_ASF_AUTOFILTER)->EnableWindow(FALSE);
	CheckRadioButton(IDC_ASF_AUTOFILTER, IDC_SERVERANALYZER_ON, IDC_ASF_AUTOFILTER + 1);
	m_iFilter = 1;
	OnSettingsChange();
}
// <------- ASFv2
