#pragma once
#include "PPgGeneral.h"
#include "PPgConnection.h"
#include "PPgServer.h"
#include "PPgDirectories.h"
#include "PPgFiles.h"
#include "PPgStats.h"
#include "PPgNotify.h"
#include "PPgIRC.h"
#include "PPgTweaks.h"
#include "PPgDisplay.h"
#include "PPgSecurity.h"
#include "PPgWebServer.h"
#include "PPgScheduler.h"
#include "PPgProxy.h"
#include "PPgMessages.h"
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
#include "PPgDebug.h"
#endif
#include "otherfunctions.h"
#include "TreePropSheet.h"

// Contrib - MOD
#include "MOD/PPgMOD.h"
// <-------- MOD

// By Taz - MOD
#include "MOD/PPgMOD2.h"
// <------- MOD

// By Taz - ASF
#include "MOD/PPgMOD3.h"
// <------- ASF

// Contrib - Updates-Prefspage
#include "./EMF/PPgUpdates.h"		//>>> shadow2004::Updates-Prefspage
// <-------- Updates-Prefspage

// Contrib - IPFilter-Prefspage
#include "./EMF/PPgIPFilter.h"		//>>> shadow2004::IPFilter-Prefspage
// <-------- IPFilter-Prefspage

// Contrib - SlideBar
#include "./EMF/SlideBar.h"			//>>> WiZaRd::SlideBar [eMule+]
#include "./EMF/KCSideBannerWnd.h"	//>>> Spike2::Prefs Side Banner [TPT]

//>>> WiZaRd::SlideBar [eMule+]

// By Taz - fix
//#define IDC_PREFS_SLIDEBAR	111	//note: this *should* be unique!
// <------- fix

#define PREF_PARENT_CLASS	CPropertySheet
//#define PREF_PARENT_CLASS	CTreePropSheet
//<<< WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

// By Taz - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
enum enumPrefencesItems
{
	// Category: basic options
	PW_GENERAL = 0,
	PW_DISPLAY,
	PW_CONNECTION,
	PW_SERVER,
	PW_DIRECTORY,
	PW_FILES,

	// Category: advanced options
	PW_PROXY,
	PW_NOTIFY,
	PW_STATISTIC,
	PW_IRC,
	PW_MESSAGES,
	PW_SECURITY,
	PW_SCHEDULER,
	PW_WEB,
	PW_TWEAKS,
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	PW_DEBUG,
#endif

	// Category: mod options
	PW_MOD

// By Taz - MOD
	,PW_MOD2
// <------- MOD

// By Taz - ASF
	,PW_MOD3
// <------- ASF

	,PW_UPDATES
	// no Category, tabbed pages
	,PW_IPFILTER
};

//#define LastPage PW_MOD
#define LastPage PW_UPDATES
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <------- Tabbed Prefs

// Contrib - SlideBar
//class CPreferencesDlg : public CTreePropSheet
class CPreferencesDlg : public PREF_PARENT_CLASS
// <-------- SlideBar

{
	DECLARE_DYNAMIC(CPreferencesDlg)

public:
	CPreferencesDlg();
	virtual ~CPreferencesDlg();
	
	CPPgGeneral		m_wndGeneral;
	CPPgConnection	m_wndConnection;
	CPPgServer		m_wndServer;
	CPPgDirectories	m_wndDirectories;
	CPPgFiles		m_wndFiles;
	CPPgStats		m_wndStats;
	CPPgNotify		m_wndNotify;
	CPPgIRC			m_wndIRC;
	CPPgTweaks		m_wndTweaks;
	CPPgDisplay		m_wndDisplay;
	CPPgSecurity	m_wndSecurity;
	CPPgWebServer	m_wndWebServer;
	CPPgScheduler	m_wndScheduler;
	CPPgProxy		m_wndProxy;
	CPPgMessages	m_wndMessages;
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	CPPgDebug		m_wndDebug;
#endif

// Contrib - MOD
	CPPgMOD	m_wndMOD;
// <-------- MOD

// By Taz - MOD
	CPPgMOD2 m_wndMOD2;
// <------- MOD

// By Taz - ASF
	CPPgMOD3 m_wndMOD3;
// <------- ASF

// Contrib - Updates-Prefspage
	CPPgUpdates		m_wndUpdates;		//>>> shadow2004::Updates-Prefspage
// <-------- Updates-Prefspage

// Contrib - IPFilter-Prefspage
	CPPgIPFilter	m_wndIPFilter;		//>>> shadow2004::IPFilter-Prefspage
// <-------- IPFilter-Prefspage

// Contrib - SlideBar
//>>> WiZaRd::SlideBar [eMule+]
	CImageList		m_ImageList;
	CSlideBar		m_SlideBar;
//<<< WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

	void Localize();
	void SetStartPage(UINT uStartPageID);

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	void SwitchTab(int page);

	int	StartPageUpdates;
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

protected:

// Contrib - Tabbed Prefs
//>>> shadow2004::Tabbed Prefs [TPT] reworked
//	LPCTSTR m_pPshStartPage;
	INT m_nActiveWnd;
//<<< shadow2004::Tabbed Prefs [TPT] reworked
// <-------- Tabbed Prefs

	bool m_bSaveIniFile;

	virtual BOOL OnInitDialog();
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();

// Contrib - SlideBar
	afx_msg LRESULT	OnSlideBarSelChanged(WPARAM wParam, LPARAM lParam); //>>> WiZaRd::SlideBar [eMule+]
// <-------- SlideBar

	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

// Contrib - SlideBar
//>>> Spike2::Prefs Side Banner [TPT]
	CKCSideBannerWnd m_banner;
//<<< Spike2::Prefs Side Banner [TPT]
// <-------- SlideBar

};
