//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif
#include "resource.h"

// Contrib - Connection Checker
#include ".\EMF\ConChecker.h" //>>> Spike2::ConChecker [eWombat]
// <-------- Connection Checker

// Contrib - SafeHash
#include ".\Mod\ReadWriteLock.h"	// SLUGFILLER: SafeHash
// <-------- SafeHash

// By Taz - Easy ModVersion
//#define	DEFAULT_NICK		thePrefs.GetHomepageBaseURL()
#define	DEFAULT_NICK		(L"UsEr")
// <------- Easy ModVersion

#define	DEFAULT_TCP_PORT_OLD	4662
#define	DEFAULT_UDP_PORT_OLD	(DEFAULT_TCP_PORT_OLD+10)

#define PORTTESTURL			_T("http://porttest.emule-project.net/connectiontest.php?tcpport=%i&udpport=%i&lang=%i")

class CSearchList;
class CUploadQueue;
class CListenSocket;
class CDownloadQueue;
class CScheduler;
class UploadBandwidthThrottler;
class LastCommonRouteFinder;
class CemuleDlg;
class CClientList;
class CKnownFileList;
class CServerConnect;
class CServerList;
class CSharedFileList;
class CClientCreditsList;

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
class CAntiLeechDataList; //>>> WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

// Contrib - ModIcon
class CModIconMapper; //>>> WiZaRd::ModIconMappings
// <-------- ModIcon

class CFriendList;
class CClientUDPSocket;
class CIPFilter;
class CWebServer;
class CMMServer;
class CAbstractFile;
class CUpDownClient;
class CPeerCacheFinder;
class CFirewallOpener;
class CUPnPImplWrapper;

// Contrib - SysInfo
class CSysInfo; //>>> WiZaRd::SysInfo
// <-------- SysInfo

// Contrib - IP2Country
class CIP2Country; //>>> shadow2004::IP2Country [EastShare]
// <-------- IP2Country

struct SLogItem;

enum AppState{
	APP_STATE_RUNNING = 0,
   	APP_STATE_SHUTTINGDOWN,
	APP_STATE_DONE
};

class CemuleApp : public CWinApp
{
public:
	CemuleApp(LPCTSTR lpszAppName = NULL);

	// ZZ:UploadSpeedSense -->
    UploadBandwidthThrottler* uploadBandwidthThrottler;
    LastCommonRouteFinder* lastCommonRouteFinder;
	// ZZ:UploadSpeedSense <--
	CemuleDlg*			emuledlg;
	CClientList*		clientlist;
	CKnownFileList*		knownfiles;
	CServerConnect*		serverconnect;
	CServerList*		serverlist;	
	CSharedFileList*	sharedfiles;
	CSearchList*		searchlist;
	CListenSocket*		listensocket;
	CUploadQueue*		uploadqueue;
	CDownloadQueue*		downloadqueue;
	CClientCreditsList*	clientcredits;

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
	CAntiLeechDataList* antileechlist; //>>> WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

// Contrib - SysInfo
	CSysInfo*			pSysInfo; //>>> WiZaRd::SysInfo
// <-------- SysInfo

// Contrib - ModIcon
	CModIconMapper*		theModIconMap; //>>> WiZaRd::ModIconMappings
// <-------- ModIcon

	CFriendList*		friendlist;
	CClientUDPSocket*	clientudp;
	CIPFilter*			ipfilter;
	CWebServer*			webserver;
	CScheduler*			scheduler;
	CMMServer*			mmserver;
	CPeerCacheFinder*	m_pPeerCache;
	CFirewallOpener*	m_pFirewallOpener;
	CUPnPImplWrapper*	m_pUPnPFinder;

// Contrib - IP2Country
	CIP2Country*		ip2country;  //>>> shadow2004::IP2Country [EastShare]
// <-------- IP2Country

	HANDLE				m_hMutexOneInstance;
	int					m_iDfltImageListColorFlags;
	CFont				m_fontHyperText;
	CFont				m_fontDefaultBold;
	CFont				m_fontSymbol;
	CFont				m_fontLog;
	CFont				m_fontChatEdit;
	CBrush				m_brushBackwardDiagonal;
	static const UINT	m_nVersionMjr;
	static const UINT	m_nVersionMin;
	static const UINT	m_nVersionUpd;
	static const UINT	m_nVersionBld;
	DWORD				m_dwProductVersionMS;
	DWORD				m_dwProductVersionLS;
	CString				m_strCurVersionLong;
	CString				m_strCurVersionLongDbg;
	UINT				m_uCurVersionShort;
	UINT				m_uCurVersionCheck;
	ULONGLONG			m_ullComCtrlVer;
	AppState			m_app_state; // defines application state for shutdown 
	CMutex				hashing_mut;

// Contrib - SafeHash
	CReadWriteLock		m_threadlock;	// SLUGFILLER: SafeHash - This will ensure eMule goes last
// <-------- SafeHash

	CString*			pstrPendingLink;
	COPYDATASTRUCT		sendstruct;

// Contrib - remove unused AICH-hashes
	//Xman remove unused AICH-hashes
	volatile bool				m_AICH_Is_synchronizing;
// <-------- remove unused AICH-hashes

// Implementierung
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	virtual BOOL IsIdleMessage(MSG *pMsg);

// Contrib - optimization
// leuk_he
	virtual BOOL OnIdle(LONG lCount);
// <-------- optimization

	// ed2k link functions

// Contrib - Check already downloaded files
	//Xman [MoNKi: -Check already downloaded files-]
	/*
	void		AddEd2kLinksToDownload(CString strLinks, int cat);
	*/
	void		AddEd2kLinksToDownload(CString strLinks, int cat, bool askIfAlreadyDownloaded = false);
	//Xman end
// <-------- Check already downloaded files

	void		SearchClipboard();
	void		IgnoreClipboardLinks(CString strLinks) {m_strLastClipboardContents = strLinks;}

// Contrib - SCC
	// ==> Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
	/*
	void		PasteClipboard(int cat = 0);
	*/
	void		PasteClipboard(int cat = -1);
	// <== Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
// <-------- SCC

	bool		IsEd2kFileLinkInClipboard();
	bool		IsEd2kServerLinkInClipboard();
	bool		IsEd2kLinkInClipboard(LPCSTR pszLinkType, int iLinkTypeLen);
	LPCTSTR		GetProfileFile()		{ return m_pszProfileName; }

	CString		CreateED2kSourceLink(const CAbstractFile* f);
//	CString		CreateED2kHostnameSourceLink(const CAbstractFile* f);
	CString		CreateKadSourceLink(const CAbstractFile* f);

	// clipboard (text)
	bool		CopyTextToClipboard(CString strText);
	CString		CopyTextFromClipboard();

	void		OnlineSig();
	void		UpdateReceivedBytes(uint32 bytesToAdd);
	void		UpdateSentBytes(uint32 bytesToAdd, bool sentToFriend = false);
	int			GetFileTypeSystemImageIdx(LPCTSTR pszFilePath, int iLength = -1, bool bNormalsSize = false);
	HIMAGELIST	GetSystemImageList() { return m_hSystemImageList; }
	HIMAGELIST	GetBigSystemImageList() { return m_hBigSystemImageList; }
	CSize		GetSmallSytemIconSize() { return m_sizSmallSystemIcon; }
	CSize		GetBigSytemIconSize() { return m_sizBigSystemIcon; }
	void		CreateBackwardDiagonalBrush();
	void		CreateAllFonts();
	const CString &GetDefaultFontFaceName();
	bool		IsPortchangeAllowed();
	bool		IsConnected();
	bool		IsFirewalled();
	bool		CanDoCallback( CUpDownClient *client );
	uint32		GetID();
	uint32		GetPublicIP(bool bIgnoreKadIP = false) const;	// return current (valid) public IP or 0 if unknown
	void		SetPublicIP(const uint32 dwIP);
	void		ResetStandByIdleTimer();

	// because nearly all icons we are loading are 16x16, the default size is specified as 16 and not as 32 nor LR_DEFAULTSIZE
	HICON		LoadIcon(LPCTSTR lpszResourceName, int cx = 16, int cy = 16, UINT uFlags = LR_DEFAULTCOLOR) const;
	HICON		LoadIcon(UINT nIDResource) const;
	HBITMAP		LoadImage(LPCTSTR lpszResourceName, LPCTSTR pszResourceType) const;
	HBITMAP		LoadImage(UINT nIDResource, LPCTSTR pszResourceType) const;
	bool		LoadSkinColor(LPCTSTR pszKey, COLORREF& crColor) const;
	bool		LoadSkinColorAlt(LPCTSTR pszKey, LPCTSTR pszAlternateKey, COLORREF& crColor) const;
	CString		GetSkinFileItem(LPCTSTR lpszResourceName, LPCTSTR pszResourceType) const;
	void		ApplySkin(LPCTSTR pszSkinProfile);
	void		EnableRTLWindowsLayout();
	void		DisableRTLWindowsLayout();
	void		UpdateDesktopColorDepth();
	void		UpdateLargeIconSize();
	bool		IsVistaThemeActive() const;

	bool		GetLangHelpFilePath(CString& strResult);
	void		SetHelpFilePath(LPCTSTR pszHelpFilePath);
	void		ShowHelp(UINT uTopic, UINT uCmd = HELP_CONTEXT);
	bool		ShowWebHelp(UINT uTopic);

    // Elandal:ThreadSafeLogging -->
    // thread safe log calls
    void			QueueDebugLogLine(bool bAddToStatusBar, LPCTSTR line,...);
    void			QueueDebugLogLineEx(UINT uFlags, LPCTSTR line,...);
    void			HandleDebugLogQueue();
    void			ClearDebugLogQueue(bool bDebugPendingMsgs = false);

	void			QueueLogLine(bool bAddToStatusBar, LPCTSTR line,...);
    void			QueueLogLineEx(UINT uFlags, LPCTSTR line,...);
    void			HandleLogQueue();
    void			ClearLogQueue(bool bDebugPendingMsgs = false);
    // Elandal:ThreadSafeLogging <--

	bool			DidWeAutoStart() { return m_bAutoStart; }

protected:
	bool ProcessCommandline();
	void SetTimeOnTransfer();
	static BOOL CALLBACK SearchEmuleWindow(HWND hWnd, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnHelp();

	HIMAGELIST m_hSystemImageList;
	CMapStringToPtr m_aExtToSysImgIdx;
	CSize m_sizSmallSystemIcon;

	HIMAGELIST m_hBigSystemImageList;
	CMapStringToPtr m_aBigExtToSysImgIdx;
	CSize m_sizBigSystemIcon;

	CString		m_strDefaultFontFaceName;
	bool		m_bGuardClipboardPrompt;
	CString		m_strLastClipboardContents;

    // Elandal:ThreadSafeLogging -->
    // thread safe log calls
    CCriticalSection m_queueLock;
    CTypedPtrList<CPtrList, SLogItem*> m_QueueDebugLog;
    CTypedPtrList<CPtrList, SLogItem*> m_QueueLog;
    // Elandal:ThreadSafeLogging <--

	uint32 m_dwPublicIP;
	bool m_bAutoStart;

private:
    UINT     m_wTimerRes;

// By Contrib - Winsock2
//>>> Spike2::Winsock2 [eWombat]
protected:
	bool	m_bWinSock2;
public:
	bool	WinSock2() const	{return m_bWinSock2;}
	WSADATA	m_wsaData;
//<<< Spike2::Winsock2 [eWombat]
// <--------	Winsock2

// Contrib - ModVersionSystem
//>>> WiZaRd::ModVersionSystem
public:
	CString		m_strModVersion;
	static const UINT	m_nModVersionMjr;
	static const UINT	m_nModVersionMin;
	static const UINT	m_nModVersionUpd;
	static const UINT	m_nModVersionBld;
//<<< WiZaRd::ModVersionSystem

// By Taz - shorter Name
	CString		m_strModShortName;
// <------- shorter Name

// <-------- ModVersionSystem

// Contrib - folder ICONS
public:
	// Commander - Added: Custom incoming folder icon [emulEspaa] - Start
	void	AddIncomingFolderIcon();
	void	RemoveIncomingFolderIcon();
	void	AddTempFolderIcon();
	void	RemoveTempFolderIcon();
	BOOL	IsCustomIncomingFolderIcon();
	// Commander - Added: Custom incoming folder icon [emulEspaa] - End
// <-------- folder ICONS

// Contrib - drop sources
	// ==> auto drop immunity - Stulle
public:
	DWORD	GetReAskTick()	{return m_dwReAskTick;}
	void	SetReAskTick(DWORD in) {m_dwReAskTick = in;}
private:
	DWORD	m_dwReAskTick;
	// <== auto drop immunity - Stulle
// <-------- drop sources

// Contrib - Connection Checker
	// ==> Connection Checker [eWombat/WiZaRd] - Stulle
private:
	uint32			m_nConnectionState;
public:
	uint32			GetConnectionState()					{return m_nConnectionState;}
	void			SetConnectionState(uint32 state)		{m_nConnectionState=state;}
	void			InitConChecker(void);
	WombatAgent::CConChecker    conchecker;
	// <== Connection Checker [eWombat/WiZaRd] - Stulle
// <-------- Connection Checker

// Contrib - Inform Clients after IP Change
	// ==> Inform Clients after IP Change - Stulle
public:
	void			CheckIdChange();
private:
	uint32			m_uLastValidID[3];
	DWORD			m_dwLastIpCheckDetected;
	// <== Inform Clients after IP Change - Stulle
// <-------- Inform Clients after IP Change

// Contrib - Automatic shared files updater
	// ==> Automatic shared files updater [MoNKi] - Stulle
private:
	static CEvent*				m_directoryWatcherCloseEvent;
	static CEvent*				m_directoryWatcherReloadEvent;
	static CCriticalSection		m_directoryWatcherCS;
	static UINT					CheckDirectoryForChangesThread(LPVOID pParam);
public:
	void ResetDirectoryWatcher();
	void EndDirectoryWatcher();
	void DirectoryWatcherExternalReload();
	// <== Automatic shared files updater [MoNKi] - Stulle
// <-------- Automatic shared files updater

};

extern CemuleApp theApp;


//////////////////////////////////////////////////////////////////////////////
// CTempIconLoader

class CTempIconLoader
{
public:
	// because nearly all icons we are loading are 16x16, the default size is specified as 16 and not as 32 nor LR_DEFAULTSIZE
	CTempIconLoader(LPCTSTR pszResourceID, int cx = 16, int cy = 16, UINT uFlags = LR_DEFAULTCOLOR);
	CTempIconLoader(UINT uResourceID, int cx = 16, int cy = 16, UINT uFlags = LR_DEFAULTCOLOR);

// Contrib - fix
	CTempIconLoader(HANDLE handle); //>>> WiZaRd::FiX for IP2Country and other custom lists [Rapid Mule]
// <-------- fix

	~CTempIconLoader();

	operator HICON() const{
		return this == NULL ? NULL : m_hIcon;
	}

protected:
	HICON m_hIcon;
};
