//this file is part of eMule beba
//Copyright (C)2005-2008 RaJiL( RaJiL@planetarajil.com / http://planetarajil.com)
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "stdafx.h"
#include "emule.h"
#include "UserMsgs.h"
#include "PPgRaJiL.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "eMuleDlg.h"
#include "PreferencesDlg.h"
#include "opcodes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// CPPG_RAJIL dialog

IMPLEMENT_DYNAMIC(CPPG_RAJIL, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPG_RAJIL, CPropertyPage)
	ON_WM_HSCROLL()
	ON_WM_DESTROY()
	ON_MESSAGE(UM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPG_RAJIL::CPPG_RAJIL()
	: CPropertyPage(CPPG_RAJIL::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	m_bInitializedTreeOpts = false;
	m_htiUploadTweaks = NULL;
	m_htiDownloadTweaks = NULL;
	// << [RaJiL:-Slot Focus-]
	m_htiGfocus = NULL;
	m_htiSlotFocusDisable = NULL;
	m_htiSlotFocusEnable = NULL;
	m_iSlotFocus = 0;
	// >> [RaJiL:-Slot Focus-]

	//<< [RaJiL:-Payback First-]
	m_htiPaybackFirstRadio = NULL;
	m_htiPaybackDisabled  = NULL;
	m_htiPaybackConst  = NULL;
	m_htiPaybackVar = NULL;
	m_htiPaybackAuto = NULL;
	m_iPaybackFirst = 0;
	//>> [RaJiL:-Payback First-]

	//<< [RaJiL:-Reask sources after IP change-]
	m_htiReaskSrcAfterIPChange = NULL;
	m_bReaskSrcAfterIPChange = false;
	m_htiReaskFileSrc = NULL;
	m_iReaskFileSrc = 0;
	//>> [RaJiL:-Reask sources after IP change-]
}

CPPG_RAJIL::~CPPG_RAJIL()
{
}

void CPPG_RAJIL::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_RaJiL_OPC, m_ctrlTreeOptions);

	if (!m_bInitializedTreeOpts) {

		int iImgUploadTweaks = 8;
		int iImgDownloadTweaks = 8;
		int iImgConnec = 8;
		int iImgReaskTweaks = 8;

		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml) {
			iImgUploadTweaks = piml->Add(CTempIconLoader(_T("UPLOAD")));
			iImgDownloadTweaks = piml->Add(CTempIconLoader(_T("DOWNLOAD")));
			iImgConnec=	piml->Add(CTempIconLoader(_T("CONNECTION")));
			iImgReaskTweaks = piml->Add(CTempIconLoader(_T("REASK")));
		}

	///////////////////////////////////////////////////////////////////////////7
	// UPLOAD SECCTION
    m_htiUploadTweaks = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_UPLOAD_TWEAKS), iImgUploadTweaks, TVI_ROOT);
	// << [RaJiL:-Slot Focus-]
	m_htiGfocus = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SLOTFOCUS_MAIN), iImgConnec, m_htiUploadTweaks);
	m_htiSlotFocusEnable = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_SLOT_FOCUS_ENABLE), m_htiGfocus , m_iSlotFocus == 0);
	m_htiSlotFocusDisable = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_SLOT_FOCUS), m_htiGfocus , m_iSlotFocus == 1);
	// >> [RaJiL:-Slot Focus-]
	//<< [RaJiL:-Payback First-]
	m_htiPaybackFirstRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PAYBACK_FIRST), iImgUploadTweaks, m_htiUploadTweaks);
	m_htiPaybackDisabled = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DISABLED), m_htiPaybackFirstRadio, m_iPaybackFirst == 0);
	m_htiPaybackConst = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_CONST), m_htiPaybackFirstRadio, m_iPaybackFirst == 1);
	m_htiPaybackVar = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_VAR), m_htiPaybackFirstRadio, m_iPaybackFirst == 2);
	m_htiPaybackAuto = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_AUTO), m_htiPaybackFirstRadio, m_iPaybackFirst == 3);
	//<< [RaJiL:-Payback First-]

	////////////////////////////////////////////////////////////////////////////
	// DOWNLOAD SECCTION

	m_htiDownloadTweaks = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DOWNLOAD_TWEAKS), iImgDownloadTweaks, TVI_ROOT);
	//<< [RaJiL:-Reask sources after IP change-]
	m_htiReaskTweaks = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_REASK_TWEAKS), iImgReaskTweaks, m_htiDownloadTweaks);
	m_htiReaskSrcAfterIPChange = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_REASK_SRC_AFTER_IP_CHANGE), m_htiReaskTweaks, m_bReaskSrcAfterIPChange);
	m_htiReaskFileSrc = m_ctrlTreeOptions.InsertItem(GetResString(IDS_REASK_FILE_SRC), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiReaskTweaks);
	m_ctrlTreeOptions.AddEditBox(m_htiReaskFileSrc, RUNTIME_CLASS(CNumTreeOptionsEdit));
	//>> [RaJiL:-Reask sources after IP change-]

	m_ctrlTreeOptions.SetItemState(m_htiUploadTweaks, TVIS_BOLD, TVIS_BOLD);
	m_ctrlTreeOptions.SetItemState(m_htiDownloadTweaks, TVIS_BOLD, TVIS_BOLD);
	m_ctrlTreeOptions.Expand(m_htiUploadTweaks, TVE_EXPAND);
	m_ctrlTreeOptions.Expand(m_htiDownloadTweaks, TVE_EXPAND);
	m_bInitializedTreeOpts = true;
	}
	// << [RaJiL:-Slot Focus-]
	DDX_TreeRadio(pDX, IDC_RaJiL_OPC, m_htiGfocus, m_iSlotFocus); 
	// >> [RaJiL:-Slot Focus-]
	//<< [RaJiL:-Payback First-]	
	DDX_TreeRadio(pDX, IDC_RaJiL_OPC, m_htiPaybackFirstRadio, m_iPaybackFirst); 
	//<< [RaJiL:-Payback First-]
	//<< [RaJiL:-Reask sources after IP change-]
	DDX_TreeCheck(pDX, IDC_RaJiL_OPC, m_htiReaskSrcAfterIPChange, m_bReaskSrcAfterIPChange);
	DDX_TreeEdit(pDX, IDC_RaJiL_OPC, m_htiReaskFileSrc, m_iReaskFileSrc);
	DDV_MinMaxInt(pDX, m_iReaskFileSrc, 29, 55);
	//>> [RaJiL:-Reask sources after IP change-]

}
void CPPG_RAJIL::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_RAJIL));
		if (m_htiUploadTweaks)  m_ctrlTreeOptions.SetItemText(m_htiUploadTweaks, GetResString(IDS_UPLOAD_TWEAKS));		
		// << [RaJiL:-Slot Focus-]
		if (m_htiGfocus)  m_ctrlTreeOptions.SetItemText(m_htiGfocus, GetResString(IDS_SLOTFOCUS_MAIN));
		if (m_htiSlotFocusEnable)  m_ctrlTreeOptions.SetItemText(m_htiSlotFocusEnable , GetResString(IDS_SLOT_FOCUS_ENABLE));
		if (m_htiSlotFocusDisable)  m_ctrlTreeOptions.SetItemText(m_htiSlotFocusDisable ,GetResString(IDS_SLOT_FOCUS));
		// >> [RaJiL:-Slot Focus-]
		//<< [RaJiL:-Payback First-]
		if (m_htiPaybackFirstRadio) m_ctrlTreeOptions.SetItemText(m_htiPaybackFirstRadio, GetResString(IDS_PAYBACK_FIRST));
		if (m_htiPaybackDisabled) m_ctrlTreeOptions.SetItemText(m_htiPaybackDisabled, GetResString(IDS_DISABLED));
		if (m_htiPaybackConst) m_ctrlTreeOptions.SetItemText(m_htiPaybackConst, GetResString(IDS_PAYBACK_FIRST_CONST));
		if (m_htiPaybackVar) m_ctrlTreeOptions.SetItemText(m_htiPaybackVar, GetResString(IDS_PAYBACK_FIRST_VAR));
		if (m_htiPaybackAuto) m_ctrlTreeOptions.SetItemText(m_htiPaybackAuto, GetResString(IDS_PAYBACK_FIRST_AUTO));
		//<< [RaJiL:-Payback First-]

		if (m_htiDownloadTweaks)  m_ctrlTreeOptions.SetItemText(m_htiDownloadTweaks, GetResString(IDS_DOWNLOAD_TWEAKS));
		//<< [RaJiL:-Reask sources after IP change-]
		if (m_htiReaskTweaks)  m_ctrlTreeOptions.SetItemText(m_htiReaskTweaks, GetResString(IDS_REASK_TWEAKS));
		if (m_htiReaskSrcAfterIPChange) m_ctrlTreeOptions.SetItemText(m_htiReaskSrcAfterIPChange, GetResString(IDS_REASK_SRC_AFTER_IP_CHANGE));
		if (m_htiReaskFileSrc) m_ctrlTreeOptions.SetEditLabel(m_htiReaskFileSrc, GetResString(IDS_REASK_FILE_SRC));
		//>> [RaJiL:-Reask sources after IP change-]
	}

}

BOOL CPPG_RAJIL::OnInitDialog()
{
	
	m_iSlotFocus = thePrefs.GetSlotFocus();		// << [RaJiL:-Slot Focus-]	
	m_iPaybackFirst = thePrefs.GetPaybackFirst(); //<< [RaJiL:-Payback First-]
	//<< [RaJiL:-Reask sources after IP change-]
	m_bReaskSrcAfterIPChange = thePrefs.GetReaskSrcAfterIPChange();
	m_iReaskFileSrc = (thePrefs.GetReaskTimeDif() + FILEREASKTIME)/60000;
	//> [RaJiL:-Reask sources after IP change-]
	
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	Localize();
	return TRUE;
}

BOOL CPPG_RAJIL::OnApply(){

	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	thePrefs.SetSlotFocus(m_iSlotFocus);// << [RaJiL:-Slot Focus-]
	thePrefs.SetPaybackFirst((uint8)m_iPaybackFirst); //<< [RaJiL:-Payback First-]
	//<< [RaJiL:-Reask sources after IP change-]
	thePrefs.SetReaskSrcAfterIPChange(m_bReaskSrcAfterIPChange);
	thePrefs.SetReaskTimeDif((m_iReaskFileSrc-29)*60000);
	//>> [RaJiL:-Reask sources after IP change-]
	
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

LRESULT CPPG_RAJIL::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM /*lParam*/)
{
	if (wParam == IDC_RaJiL_OPC)
		SetModified();
	return 0;
}

void CPPG_RAJIL::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	m_htiUploadTweaks = NULL;
	m_htiDownloadTweaks = NULL;
	// << [RaJiL:-Slot Focus-]
	m_htiGfocus = NULL;
	m_htiSlotFocusDisable = NULL;
	m_htiSlotFocusEnable = NULL;
	m_iSlotFocus = 0;
	// >> [RaJiL:-Slot Focus-]

	//<< [RaJiL:-Payback First-]
	m_htiPaybackFirstRadio = NULL;
	m_htiPaybackDisabled  = NULL;
	m_htiPaybackConst  = NULL;
	m_htiPaybackVar = NULL;
	m_htiPaybackAuto = NULL;
	m_iPaybackFirst = 0;
	//>> [RaJiL:-Payback First-]

	//<< [RaJiL:-Reask sources after IP change-]
	m_htiReaskSrcAfterIPChange = NULL;
	m_bReaskSrcAfterIPChange = false;
	m_htiReaskFileSrc = NULL;
	m_iReaskFileSrc = 0;
	//<< [RaJiL:-Reask sources after IP change-]

	CPropertyPage::OnDestroy();
}


