//////////////////////////////////////////////////////////////////////////
// This is a clean prefpage with a treeoption control
// I avoided unnecessary code obfuscation as good as possible
#include "stdafx.h"
#include "emule.h"
#include "Mod/PPgMOD.h"
#include "AntiLeech/Modname.h"
#include "UserMsgs.h"
#include "otherfunctions.h"

#include "Preferences.h"
#include "opcodes.h"

// Contrib - EMF Link
#include "emuleDlg.h"
#include "MenuCmds.h"
// <-------- EMF Link

// Contrib - IP2Country
#include "EMF/IP2Country.h"	//>>> shadow2004::IP2Country [EastShare]
// <-------- IP2Country

// Contrib - Advanced official preferences
#include "langids.h"
// <-------- Advanced official preferences

// Contrib - Connection Checker
#include "./EMF/ConChecker.h" //>>> WiZaRd::ConChecker [eWombat]
// <-------- Connection Checker

// Contrib - Global HL
#include "Log.h" //MORPH - Added by Stulle, Global Source Limit
#include "DownloadQueue.h" //MORPH - Added by Stulle, Global Source Limit
// <-------- Global HL

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CPPgMOD dialog

IMPLEMENT_DYNAMIC(CPPgMOD, CPropertyPage)
BEGIN_MESSAGE_MAP(CPPgMOD, CPropertyPage)
	ON_WM_DESTROY()
	ON_MESSAGE(UM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgMOD::CPPgMOD()
: CPropertyPage(CPPgMOD::IDD)
, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	m_bInitializedTreeOpts = false;
	Nullify();
}

CPPgMOD::~CPPgMOD()
{
}

void CPPgMOD::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);
	CString buffer;
	if (!m_bInitializedTreeOpts)
	{

// Contrib - Mod Options arangement
		int iImgSystem = 8;
		int iImgUM = 8; // default icon
		int iImgDM = 8;
		int iImgConnection = 8;
		int iImgDisplay = 8;	//>>> shadow2004::Toolbar
// <-------- Mod Options arangement

//		int iImgEmulate = 8;

// Contrib - IP2Country
		int	iImgI2C = 8;		//>>> shadow2004::IP2Country [EastShare]
// <-------- IP2Country

// Contrib - SLS
		int	iImgSLS = 8;		//>>> JvA::SLS [enkeyDEV]
// <-------- SLS

// Contrib - IntelliFlush
//>>> WiZaRd::IntelliFlush
		int iImgFileBuffer = 8;
//<<< WiZaRd::IntelliFlush
// <-------- IntelliFlush

// Contrib - drop sources
		int iImgDropDefaults = 8;
// <-------- drop sources

// Contrib - SCC
		int iImgSCC = 8;
		int iImgDlMode = 8;
// <-------- SCC

// By Taz - download color
		int iImgDownloadColor = 8;
// <------- download color

// Contrib - QuickStart
		int iImgQS = 8;// NEO: QS - [QuickStart]
// <-------- QuickStart

// By Taz - ban
		int	iImgBan = 8;
// <------- ban

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
		int iImgDynyp = 8;
#endif
// <-------- ClientAnalyzer

		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml)
		{

// By Taz - Mod Options arangement
			iImgSystem		=	piml->Add(CTempIconLoader(L"TWEAK"));
			iImgUM = piml->Add(CTempIconLoader(L"UPLOAD"));
			iImgDM = piml->Add(CTempIconLoader(L"DOWNLOAD"));
			iImgConnection	=	piml->Add(CTempIconLoader(L"connection"));
			iImgDisplay		=	piml->Add(CTempIconLoader(L"DISPLAY")); //>>> shadow2004::Toolbar
// <------- Mod Options arangement

// Contrib - IP2Country
			iImgI2C			=		piml->Add(CTempIconLoader(L"SEARCHMETHOD_GLOBAL")); //>>> shadow2004::IP2Country [EastShare]
// <-------- IP2Country

//			iImgEmulate		=		piml->Add(CTempIconLoader(L"EMULATE"));
// Contrib - SLS
			iImgSLS			=		piml->Add(CTempIconLoader(L"SLS"));	//>>> JvA::SLS [enkeyDEV]
// <-------- SLS

// Contrib - IntelliFlush
//>>> WiZaRd::IntelliFlush
			iImgFileBuffer	=		piml->Add(CTempIconLoader(L"HARDDISK"));
//<<< WiZaRd::IntelliFlush
// <-------- IntelliFlush

// Contrib - drop sources
			iImgDropDefaults = piml->Add(CTempIconLoader(L"DROPDEFAULTS"));
// <-------- drop sources

// Contrib - SCC
			iImgSCC = 				piml->Add(CTempIconLoader(L"CATEGORY"));
			iImgDlMode = 			piml->Add(CTempIconLoader(L"DLMODE"));
// <-------- SCC

// By Taz - download color
			iImgDownloadColor	= 	piml->Add(CTempIconLoader(L"COLOUR"));
// <------- download color

// Contrib - QuickStart
			iImgQS 				=	piml->Add(CTempIconLoader(L"QUICKSTART"));// NEO: QS - [QuickStart]
// <-------- QuickStart

// By Taz - ban
			iImgBan				=	piml->Add(CTempIconLoader(L"DELETEFRIEND"));
// <------- ban

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
			iImgDynyp 			=	piml->Add(CTempIconLoader(L"upload"));
#endif
// <-------- ClientAnalyzer

		}

		//////////////////////////////////////////////////////////////////////////
		// System tweaks
		//
		m_htiSystemGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SYSTEM), iImgSystem, TVI_ROOT);

// Contrib - IntelliFlush
//>>> WiZaRd::IntelliFlush
		m_htiFileBufferGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_FILEBUFFER), iImgFileBuffer, m_htiSystemGroup);
		buffer.Format(_T("%s [%s]"), GetResString(IDS_FILEBUFFERSIZE), GetResString(IDS_KBYTES));
		m_htiFileBufferSize = m_ctrlTreeOptions.InsertItem(buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFileBufferGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFileBufferSize, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiFileBufferTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_FILEBUFFER_TIME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFileBufferGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFileBufferTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiIntelliFlushCheck = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_FILEBUFFER_INTELLI), m_htiFileBufferGroup, m_bIntelliFlush || m_iFileBufferTime < 1 || m_iFileBufferTime > 5);
//<<< WiZaRd::IntelliFlush
// Contrib - IntelliFlush

// Contrib - SLS
// Contrib - Automatic shared files updater
		m_htiAUTO_SHARED_UPDATER = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_AUTO_SHARED_UPDATER), m_htiSystemGroup, m_bAUTO_SHARED_UPDATER);
// <-------- Automatic shared files updater

// Contrib - Connection Checker
//>>> WiZaRd::ConChecker [eWombat]
		m_htiConcheckerGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_CONCHECKER), iImgConnection, m_htiSystemGroup);
		m_htiConcheckerActive = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CONCHECKER_ACTIVE), m_htiConcheckerGroup, m_bConcheckerActive);
		m_htiConcheckerPingtypeRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_CONCHECKER_PINGMETHOD), iImgSystem, m_htiConcheckerGroup);
		m_htiConcheckerPingICMP = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CONCHECKER_ICMP), m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype == 0);
		m_htiConcheckerPingRAW = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CONCHECKER_RAW), m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype == 1);
		m_htiConcheckerTTL = m_ctrlTreeOptions.InsertItem(GetResString(IDS_CONCHECKER_TTL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiConcheckerGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiConcheckerTTL, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiConcheckerPingtimeout = m_ctrlTreeOptions.InsertItem(GetResString(IDS_CONCHECKER_TIMEOUT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiConcheckerGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiConcheckerPingtimeout, RUNTIME_CLASS(CNumTreeOptionsEdit));
//		m_ctrlTreeOptions.SetItemState(m_htiConcheckerGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiConcheckerPingtypeRadio, TVE_EXPAND);
//		m_ctrlTreeOptions.SetItemState(m_htiConcheckerPingtypeRadio, TVIS_BOLD, TVIS_BOLD);
//<<< WiZaRd::ConChecker [eWombat]
// <-------- Connection Checker

// Contrib - QuickStart
// NEO: QS - [QuickStart]
		m_htiQuickStart = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_QUICK_START),iImgQS, m_htiSystemGroup);
		m_htiQuickStartEnable = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_X_QUICK_START_ENABLE),m_htiQuickStart, m_bQuickStart);
		m_htiQuickStartOnIPChange = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_X_QUICK_START_ON_ID_CHANGE),m_htiQuickStart,m_bQuickStartOnIPChange);// NEO: QS - [QuickStart]
		m_htiQuickStartTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_TIME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
		m_ctrlTreeOptions.AddEditBox(m_htiQuickStartTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiQuickMaxConperFive = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_MAXPER5), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
		m_ctrlTreeOptions.AddEditBox(m_htiQuickMaxConperFive, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiQuickMaxHalfOpen = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_MAXHALF), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
		m_ctrlTreeOptions.AddEditBox(m_htiQuickMaxHalfOpen, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiQuickMaxConnections = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_MAXCON), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
		m_ctrlTreeOptions.AddEditBox(m_htiQuickMaxConnections, RUNTIME_CLASS(CNumTreeOptionsEdit));
// NEO: QS END
// <-------- QuickStart

// Contrib - version check
		m_htiModVersionCheck = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MODVERSIONCHECK), m_htiSystemGroup, m_bModVersionCheck);
		m_htiModBetaCheck = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MODBETACHECK), m_htiSystemGroup, m_bModBetaCheck);
// <-------- version check

		/////////////////////////////////////////////////////////////////////////////
		// Download Management group
		//

// Contrib - Mod Options arangement
		m_htiDM = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DM), iImgDM, TVI_ROOT);
// <-------- Mod Options arangement

// Contrib - SLS
//>>> JvA::SLS [enkeyDEV]
		m_htiSLSGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SLSLABEL), iImgSLS, m_htiDM);
		m_htiSLSCheck		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SLSCHECKLABEL), m_htiSLSGroup, m_bSLSCheck);
		m_htiSLSActivationLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLSACTIVATIONLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSLSGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiSLSActivationLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiSLSSaveValue	= m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLSSAVEVALUE), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSLSGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiSLSSaveValue, RUNTIME_CLASS(CNumTreeOptionsEdit));
//		m_ctrlTreeOptions.SetItemState(m_htiSLSGroup, TVIS_BOLD, TVIS_BOLD);
//<<< JvA::SLS [enkeyDEV]
// <-------- SLS

// Contrib - retry connection attempts
		m_htiRetryConnectionAttempts = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_RETRYCONNECTIONATTEMPTS), m_htiDM, m_bRetryConnectionAttempts);
// <-------- retry connection attempts

// Contrib - Inform Clients after IP Change
		m_htiIsreaskSourceAfterIPChange = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_RSAIC), m_htiDM, m_bIsreaskSourceAfterIPChange);
// <-------- Inform Clients after IP Change

// Contrib - drop sources
		// ==> drop sources - Stulle
		m_htiDropDefaults = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DROP_DEFAULTS), iImgDropDefaults, m_htiDM);
		m_htiAutoNNS = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_AUTO_NNS), m_htiDropDefaults, m_bEnableAutoDropNNSDefault);
		m_htiAutoNNSTimer = m_ctrlTreeOptions.InsertItem(GetResString(IDS_NNS_TIMERLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoNNS);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoNNSTimer, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoNNSLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_REMOVENNSLIMITLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoNNS);
		m_ctrlTreeOptions.Expand(m_htiAutoNNS, TVE_EXPAND);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoNNSLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoFQS = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_AUTO_FQS), m_htiDropDefaults, m_bEnableAutoDropFQSDefault);
		m_htiAutoFQSTimer = m_ctrlTreeOptions.InsertItem(GetResString(IDS_FQS_TIMERLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoFQS);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoFQSTimer, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoFQSLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_REMOVEFQSLIMITLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoFQS);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoFQSLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_ctrlTreeOptions.Expand(m_htiAutoFQS, TVE_EXPAND);
		m_htiAutoQRS = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_AUTO_QRS), m_htiDropDefaults, m_bEnableAutoDropQRSDefault);
		m_htiAutoQRSTimer = m_ctrlTreeOptions.InsertItem(GetResString(IDS_HQRS_TIMERLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoQRS);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoQRSTimer, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoQRSMax = m_ctrlTreeOptions.InsertItem(GetResString(IDS_REMOVEQRSLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoQRS);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoQRSMax, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoQRSLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_REMOVEQRSLIMITLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoQRS);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoQRSLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_ctrlTreeOptions.Expand(m_htiAutoQRS, TVE_EXPAND);
		// <== drop sources - Stulle
// <-------- drop sources

// Contrib - SCC
		// ==> Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
		m_htiSCC = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SCC), iImgSCC, m_htiDM);
		m_htiDlMode = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DL_MODE_DEFAULT), iImgDlMode, m_htiSCC);
		m_htiDlNone = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DL_NONE), m_htiDlMode, m_iDlMode == 0);
		m_htiDlAlph = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DOWNLOAD_ALPHABETICAL), m_htiDlMode, m_iDlMode == 1);
		m_htiDlLP = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_LP), m_htiDlMode, m_iDlMode == 2);
		m_htiShowCatNames = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_SHOWCATNAME), m_htiSCC, m_bShowCatNames);
		m_htiSelectCat = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_SHOWSELCATDLG), m_htiSCC, m_bSelectCat);
		m_htiUseAutoCat = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_USEAUTOCAT), m_htiSCC, m_bUseAutoCat);
		m_htiUseActiveCat = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_USEACTIVE), m_htiSCC, m_bUseActiveCat);
		m_htiAutoSetResOrder = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_AUTORESUMEORD), m_htiSCC, m_bAutoSetResOrder);
		m_htiSmallFileDLPush = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_SMALLFILEDLPUSH), m_htiSCC, m_bSmallFileDLPush);
		m_htiResumeFileInNewCat = m_ctrlTreeOptions.InsertItem(GetResString(IDS_CAT_STARTFILESONADD), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSCC);
		m_ctrlTreeOptions.AddEditBox(m_htiResumeFileInNewCat, RUNTIME_CLASS(CNumTreeOptionsEdit));
		// <== Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
// <-------- SCC

// Contrib - Global HL
		//MORPH START - Added by Stulle, Global Source Limit
		m_htiGlobalHlGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_GLOBAL_HL), iImgI2C, m_htiDM);
		m_htiGlobalHL = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SUC_ENABLED), m_htiGlobalHlGroup, m_bGlobalHL);
		m_htiGlobalHlLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_GLOBAL_HL_LIMIT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiGlobalHlGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiGlobalHlLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		//MORPH END   - Added by Stulle, Global Source Limit
// <-------- Global HL

// Contrib - corrupted blocks ban threshold
		m_htiBanThreshold = m_ctrlTreeOptions.InsertItem(GetResString(IDS_BanThreshold), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDM);
		m_ctrlTreeOptions.AddEditBox(m_htiBanThreshold, RUNTIME_CLASS(CNumTreeOptionsEdit));
// <-------- corrupted blocks ban threshold

		/////////////////////////////////////////////////////////////////////////////
		// Upload Management group
		//

// Contrib - Mod Options arangement
		m_htiUM = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_UM), iImgUM, TVI_ROOT);
// <-------- Mod Options arangement

/*
// Contrib - SlotControl
		m_htiSlotSpeed = m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLOT_SPEED), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiUM);
		m_ctrlTreeOptions.AddEditBox(m_htiSlotSpeed, RUNTIME_CLASS(CNumTreeOptionsEdit));
// <-------- SlotControl
*/

// Contrib - Inform Clients after IP Change
		m_htiInformQueuedClientsAfterIPChange = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_IQCAOC), m_htiUM, m_bInformQueuedClientsAfterIPChange);
// <-------- Inform Clients after IP Change

// Contrib - One-queue-per-file
		m_htiEnableMultiQueue = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MULTIQUEUE), m_htiUM, m_bEnableMultiQueue);
// <-------- One-queue-per-file

// By Taz - ban
		m_htiBan = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_BAN_CONTROL), iImgBan, m_htiUM);
		m_htiBanVagaa = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_BANVAGAA), m_htiBan, m_bBanVagaa);
		m_htiBanBS = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_BANBS), m_htiBan, m_bBanBS);
		m_htiBanAJ = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_BANAJ), m_htiBan, m_bBanAJ);
		m_htiBanCommunity = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_BANCOMMUNITY), m_htiBan, m_bBanCommunity);
		m_htiBanCorrupt = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_BANCORRUPT), m_htiBan, m_bBanCorrupt);
// <------- ban

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
//>>> WiZaRd::ClientAnalyzer
		m_htiCreditSystem = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_USECREDITSYSTEM), iImgDynyp, m_htiUM);
		m_htiCSNone = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CS_NONE), m_htiCreditSystem, m_iCreditSystem == 0);
		m_htiCSOffi = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CS_OFFI), m_htiCreditSystem, m_iCreditSystem == 1);
		m_htiCSAnalyzer = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CS_ANALYZER), m_htiCreditSystem, m_iCreditSystem == 2);
		m_ctrlTreeOptions.Expand(m_htiCreditSystem, TVE_EXPAND);
//		m_ctrlTreeOptions.SetItemState(m_htiCSAnalyzer, TVIS_BOLD, TVIS_BOLD);
//<<< WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

		/////////////////////////////////////////////////////////////////////////////
		// Display group
		//

// Contrib - Mod Options arangement
		m_htiDisplayGroup	= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PW_DISPLAY), iImgDisplay, TVI_ROOT);
// <-------- Mod Options arangement

// Contrib - minRQR
//>>> WiZaRd::minRQR [WiZaRd]
		m_htiMinRQR			= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MINRQR_ENABLE), m_htiDisplayGroup, m_bUseMinRQR);
//<<< WiZaRd::minRQR [WiZaRd]
// <-------- minRQR

// Contrib - Client Percentage
		m_htiShowClientPercentage = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SHOW_CLIENT_PERCENTAGE), m_htiDisplayGroup, m_bShowClientPercentage);
// <-------- Client Percentage

// Contrib - IP2Country
//>>> shadow2004::IP2Country [EastShare]
		m_htiI2CGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_IP2COUNTRY), iImgI2C, m_htiDisplayGroup);
		m_htiI2C2Letter		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_2LETTERS), m_htiI2CGroup, m_iI2CCaption == 0);
		m_htiI2C3Letter		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_3LETTERS), m_htiI2CGroup, m_iI2CCaption == 1);
		m_htiI2CFullCaption	= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_FULLCAPTION), m_htiI2CGroup, m_iI2CCaption == 2);
		m_htiI2CShowFlag	= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_IP2COUNTRY_SHOWFLAGS), m_htiI2CGroup, m_bI2CShowFlag);
//		m_ctrlTreeOptions.SetItemState(m_htiI2CGroup, TVIS_BOLD, TVIS_BOLD);
//<<< shadow2004::IP2Country [EastShare]
// <-------- IP2Country

// By Taz - download color
		m_htiDownloadColor			= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DOWNLOAD_COLOR), iImgDownloadColor, m_htiDisplayGroup);
		m_htiRedDownload			= m_ctrlTreeOptions.InsertItem(GetResString(IDS_RED_DOWNLOAD), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDownloadColor);
		m_ctrlTreeOptions.AddEditBox(m_htiRedDownload, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiGreenDownload			= m_ctrlTreeOptions.InsertItem(GetResString(IDS_GREEN_DOWNLOAD), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDownloadColor);
		m_ctrlTreeOptions.AddEditBox(m_htiGreenDownload, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiBlueDownload			= m_ctrlTreeOptions.InsertItem(GetResString(IDS_BLUE_DOWNLOAD), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDownloadColor);
		m_ctrlTreeOptions.AddEditBox(m_htiBlueDownload, RUNTIME_CLASS(CNumTreeOptionsEdit));
// <------- download color

// Contrib - Global HL
		m_htiShowGlobalHL = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SHOW_GLOBAL_HL), m_htiDisplayGroup, m_bShowGlobalHL); // show global HL - Stulle
		m_htiShowFileHLconst = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SHOW_FILE_HL_CONST), m_htiDisplayGroup, m_bShowFileHLconst); // show HL per file constantly
// <-------- Global HL

// Contrib - Advanced official preferences
		if (thePrefs.GetLanguageID() == LANGID_HE_IL)
			m_hti_m_bRTLWindowsLayout=m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_RTLWINDOWSLAYOUT),m_htiDisplayGroup,m_bRTLWindowsLayout);
// <-------- Advanced official preferences

		/////////////////////////////////////////////////////////////////////////////
		// Misc group
		//

		m_htiMoreTweaksGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PW_MISC), iImgConnection, TVI_ROOT);

// Contrib - remove unused AICH-hashes
		m_htiremove_unused_AICH_hashes = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_REMEMBERAICH), m_htiMoreTweaksGroup, m_bremove_unused_AICH_hashes);
// <-------- remove unused AICH-hashes

		m_ctrlTreeOptions.SetItemState(m_htiSystemGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiSystemGroup, TVE_EXPAND);

// Contrib - Mod Options arangement
		m_ctrlTreeOptions.SetItemState(m_htiDM, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiDM, TVE_EXPAND);
		m_ctrlTreeOptions.SetItemState(m_htiUM, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiUM, TVE_EXPAND);
// <-------- Mod Options arangement

		m_ctrlTreeOptions.SetItemState(m_htiDisplayGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiDisplayGroup, TVE_EXPAND);

// By Taz - download color
		m_ctrlTreeOptions.Expand(m_htiDownloadColor, TVE_EXPAND);
// <------- download color

		m_ctrlTreeOptions.SetItemState(m_htiMoreTweaksGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.Expand(m_htiMoreTweaksGroup, TVE_EXPAND);

		m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
		m_bInitializedTreeOpts = true;
	}

	//////////////////////////////////////////////////////////////////////////
	// System tweaks
	//

//	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiMultipleInstances, m_bMultipleInstances);

// Contrib - IntelliFlush
//>>> WiZaRd::IntelliFlush
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiFileBufferSize, m_iFileBufferSize);
	DDV_MinMaxInt(pDX, m_iFileBufferSize, 256, 30*1024); //kB!
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiFileBufferTime, m_iFileBufferTime);
	DDV_MinMaxInt(pDX, m_iFileBufferTime, 0, 60); //minutes!
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiIntelliFlushCheck, m_bIntelliFlush);
	if(m_iFileBufferTime < 1 || m_iFileBufferTime > 5)
	{
		m_ctrlTreeOptions.SetCheckBox(m_htiIntelliFlushCheck, TRUE);
		m_ctrlTreeOptions.SetCheckBoxEnable(m_htiIntelliFlushCheck, FALSE);
	}
	else
	{
		m_ctrlTreeOptions.SetCheckBox(m_htiIntelliFlushCheck, m_bIntelliFlush);
		m_ctrlTreeOptions.SetCheckBoxEnable(m_htiIntelliFlushCheck, TRUE);
	}
//<<< WiZaRd::IntelliFlush
// <-------- IntelliFlush

// Contrib - Automatic shared files updater
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAUTO_SHARED_UPDATER, m_bAUTO_SHARED_UPDATER);
// <-------- Automatic shared files updater

// Contrib - Connection Checker
//>>> WiZaRd::ConChecker [eWombat]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiConcheckerActive, m_bConcheckerActive);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiConcheckerTTL, m_iConcheckerTTL);
	DDV_MinMaxInt(pDX, m_iConcheckerTTL, 8, 64);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiConcheckerPingtimeout, m_iConcheckerPingtimeout);
	DDV_MinMaxInt(pDX, m_iConcheckerPingtimeout, 1, 64);
	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype);
//<<< WiZaRd::ConChecker [eWombat]
// <-------- Connection Checker

// Contrib - QuickStart
// NEO: QS - [QuickStart]
	DDX_TreeCheck(pDX,IDC_MOD_OPTS, m_htiQuickStartEnable, m_bQuickStart);
	DDX_TreeCheck(pDX,IDC_MOD_OPTS, m_htiQuickStartOnIPChange, m_bQuickStartOnIPChange); // NEO: QS - [QuickStart]
	DDX_TreeEdit(pDX,IDC_MOD_OPTS, m_htiQuickStartTime, m_iQuickStartTime);
	DDX_TreeEdit(pDX,IDC_MOD_OPTS, m_htiQuickMaxConperFive, m_iQuickMaxConperFive);
	DDX_TreeEdit(pDX,IDC_MOD_OPTS, m_htiQuickMaxHalfOpen, m_iQuickMaxHalfOpen);
	DDX_TreeEdit(pDX,IDC_MOD_OPTS, m_htiQuickMaxConnections, m_iQuickMaxConnections);
// NEO: QS END
// <-------- QuickStart

// Contrib - version check
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiModVersionCheck, m_bModVersionCheck);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiModBetaCheck, m_bModBetaCheck);
	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiModVersionCheck, m_bModBetaCheck ? FALSE : TRUE);
// <-------- version check

	/////////////////////////////////////////////////////////////////////////////
	// Download Management group
	//

// Contrib - SLS
//>>> JvA::SLS [enkeyDEV]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSLSCheck, m_bSLSCheck);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiSLSActivationLimit, m_iSLSActivationLimit);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiSLSSaveValue, m_iSLSSaveValue);
	DDV_MinMaxInt(pDX, m_iSLSActivationLimit, 0, 100);
	DDV_MinMaxInt(pDX, m_iSLSSaveValue, 0, 50);
//<<< JvA::SLS [enkeyDEV]
// <-------- SLS

// Contrib - retry connection attempts
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiRetryConnectionAttempts, m_bRetryConnectionAttempts);
// <-------- retry connection attempts

// Contrib - Inform Clients after IP Change
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiIsreaskSourceAfterIPChange, m_bIsreaskSourceAfterIPChange);
// <-------- Inform Clients after IP Change

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiCreditSystem, m_iCreditSystem); //>>> WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

// Contrib - drop sources
	// ==> drop sources - Stulle
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoNNS, m_bEnableAutoDropNNSDefault);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiAutoNNSTimer, m_iAutoNNS_TimerDefault);
	DDV_MinMaxInt(pDX, m_iAutoNNS_TimerDefault, 0, 60);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiAutoNNSLimit, m_iMaxRemoveNNSLimitDefault);
	DDV_MinMaxInt(pDX, m_iMaxRemoveNNSLimitDefault, 50, 100);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoFQS, m_bEnableAutoDropFQSDefault);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiAutoFQSTimer, m_iAutoFQS_TimerDefault);
	DDV_MinMaxInt(pDX, m_iAutoFQS_TimerDefault, 0, 60);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiAutoFQSLimit, m_iMaxRemoveFQSLimitDefault);
	DDV_MinMaxInt(pDX, m_iMaxRemoveFQSLimitDefault, 50, 100);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoQRS, m_bEnableAutoDropQRSDefault);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiAutoQRSTimer, m_iAutoHQRS_TimerDefault);
	DDV_MinMaxInt(pDX, m_iAutoHQRS_TimerDefault, 0, 60);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiAutoQRSMax, m_iMaxRemoveQRSDefault);
	DDV_MinMaxInt(pDX, m_iMaxRemoveQRSDefault, 2500, 10000);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiAutoQRSLimit, m_iMaxRemoveQRSLimitDefault);
	DDV_MinMaxInt(pDX, m_iMaxRemoveQRSLimitDefault, 50, 100);
	// <== drop sources - Stulle
// <-------- drop sources

// Contrib - SCC
	// ==> Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDlMode, (int &)m_iDlMode);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiResumeFileInNewCat, m_iResumeFileInNewCat);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowCatNames, m_bShowCatNames);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSelectCat, m_bSelectCat);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseActiveCat, m_bUseActiveCat);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoSetResOrder, m_bAutoSetResOrder);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSmallFileDLPush, m_bSmallFileDLPush);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseAutoCat, m_bUseAutoCat);
	// <== Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
// <-------- SCC

// Contrib - Global HL
	//MORPH START - Added by Stulle, Global Source Limit
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiGlobalHL, m_bGlobalHL);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiGlobalHlLimit, m_iGlobalHL);
	DDV_MinMaxInt(pDX, m_iGlobalHL, 1000, MAX_GSL);
	//MORPH END   - Added by Stulle, Global Source Limit
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowGlobalHL, m_bShowGlobalHL); // show global HL - Stulle
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowFileHLconst, m_bShowFileHLconst); // show HL per file constantly
// <-------- Global HL

// Contrib - corrupted blocks ban threshold
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiBanThreshold, m_iBanThreshold);
	DDV_MinMaxInt(pDX, m_iBanThreshold, 5, 32);
// <-------- corrupted blocks ban threshold

	/////////////////////////////////////////////////////////////////////////////
	// Upload Management group
	//

// Contrib - Inform Clients after IP Change
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiInformQueuedClientsAfterIPChange, m_bInformQueuedClientsAfterIPChange);
// <-------- Inform Clients after IP Change

// Contrib - One-queue-per-file
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiEnableMultiQueue, m_bEnableMultiQueue);
// <-------- One-queue-per-file

/*
// Contrib - SlotControl
	DDX_Text(pDX, IDC_MOD_OPTS, m_htiSlotSpeed, m_fSlotSpeed);
	DDV_MinMaxFloat(pDX, m_fSlotSpeed, 0.0F, CalculateMaxSlotSpeed());
// <-------- SlotControl
*/

// By Taz - ban
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiBanVagaa, m_bBanVagaa);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiBanBS, m_bBanBS);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiBanAJ, m_bBanAJ);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiBanCommunity, m_bBanCommunity);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiBanCorrupt, m_bBanCorrupt);
// <------- ban

	/////////////////////////////////////////////////////////////////////////////
	// Display group
	//

// Contrib - minRQR
//>>> WiZaRd::minRQR [WiZaRd]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiMinRQR, m_bUseMinRQR);
//<<< WiZaRd::minRQR [WiZaRd]
// <-------- minRQR

// Contrib - Client Percentage
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowClientPercentage, m_bShowClientPercentage);
// <-------- Client Percentage

// Contrib - IP2Country
//>>> shadow2004::IP2Country [EastShare]
	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiI2CGroup, m_iI2CCaption);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiI2CShowFlag, m_bI2CShowFlag);
//<<< shadow2004::IP2Country [EastShare]
// <-------- IP2Country

// By Taz - download color
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiRedDownload, m_iDownloadRed);
	DDV_MinMaxInt(pDX, m_iDownloadRed, 0, 192);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiGreenDownload, m_iDownloadGreen);
	DDV_MinMaxInt(pDX, m_iDownloadGreen, 0, 192);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiBlueDownload, m_iDownloadBlue);
	DDV_MinMaxInt(pDX, m_iDownloadBlue, 0, 192);
// <------- download color

// Contrib - Advanced official preferences
	if (thePrefs.GetLanguageID() == LANGID_HE_IL){
		if (m_hti_m_bRTLWindowsLayout == NULL)
			m_hti_m_bRTLWindowsLayout=m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_RTLWINDOWSLAYOUT),m_htiDisplayGroup,m_bRTLWindowsLayout);
		DDX_TreeCheck(pDX,IDC_MOD_OPTS,m_hti_m_bRTLWindowsLayout,m_bRTLWindowsLayout);
	}
// <-------- Advanced official preferences

	/////////////////////////////////////////////////////////////////////////////
	// Misc group
	//

// Contrib - remove unused AICH-hashes
	DDX_TreeCheck(pDX,IDC_MOD_OPTS, m_htiremove_unused_AICH_hashes, m_bremove_unused_AICH_hashes);
// <-------- remove unused AICH-hashes

}

BOOL CPPgMOD::OnInitDialog()
{
//	m_bMultipleInstances = theApp.GetProfileInt(_T("eMule"), _T("IgnoreInstances"), 0) != 0;

// Contrib - IntelliFlush
//>>> WiZaRd::IntelliFlush
	m_iFileBufferSize = thePrefs.GetFileBufferSize()/1024; //kB!
	m_iFileBufferTime = thePrefs.GetFileBufferFlushTime()/60/1000; //minutes!
	m_bIntelliFlush = m_iFileBufferTime < 1 || m_iFileBufferTime > 5 || thePrefs.IsUseIntelliFlush();
//<<< WiZaRd::IntelliFlush
// <-------- IntelliFlush

// Contrib - Connection Checker
//>>> WiZaRd::ConChecker [eWombat]
	m_bConcheckerActive = thePrefs.GetCheckCon();
	m_iConcheckerTTL = thePrefs.GetPingTTL();
	m_iConcheckerPingtimeout = thePrefs.GetPingTimeout();
	m_iConcheckerPingtype = thePrefs.GetICMP() ? 0 : 1;
//<<< WiZaRd::ConChecker [eWombat]
// <-------- Connection Checker

// Contrib - QuickStart
	// NEO: QS - [QuickStart]
	m_bQuickStart = thePrefs.m_bQuickStart;
	m_bQuickStartOnIPChange = thePrefs.m_bQuickStartOnIPChange; // NEO: QS - [QuickStart]
	m_iQuickStartTime = thePrefs.m_iQuickStartTime;
	m_iQuickMaxConperFive = thePrefs.m_iQuickMaxConperFive;
	m_iQuickMaxHalfOpen = thePrefs.m_iQuickMaxHalfOpen;
	m_iQuickMaxConnections = thePrefs.m_iQuickMaxConnections;
	// NEO: QS END
// <-------- QuickStart

// Contrib - retry connection attempts
	m_bRetryConnectionAttempts = thePrefs.retryconnectionattempts;
// <-------- retry connection attempts

// Contrib - Automatic shared files updater
		m_bAUTO_SHARED_UPDATER = thePrefs.GetDirectoryWatcher();
// <-------- Automatic shared files updater

// Contrib - SLS
//>>> JvA::SLS [enkeyDEV]
	m_bSLSCheck = thePrefs.UseSaveLoadSources();
	m_iSLSActivationLimit = thePrefs.GetActivationLimitSLS();
	m_iSLSSaveValue = thePrefs.GetSourcesToSaveSLS();
//<<< JvA::SLS [enkeyDEV]
// <-------- SLS

// Contrib - Global HL
	// ==> Global Source Limit - Stulle
	m_bGlobalHL = thePrefs.IsUseGlobalHL();
	m_iGlobalHL = thePrefs.GetGlobalHL();
	// <== Global Source Limit - Stulle
	m_bShowGlobalHL = thePrefs.GetShowGlobalHL(); // show global HL - Stulle
	m_bShowFileHLconst = thePrefs.GetShowFileHLconst(); // show HL per file constantly
// <-------- Global HL

// Contrib - retry connection attempts
	m_bRetryConnectionAttempts = thePrefs.retryconnectionattempts;
// <-------- retry connection attempts

// Contrib - drop sources
	// ==> drop sources - Stulle
	m_bEnableAutoDropNNSDefault = thePrefs.m_EnableAutoDropNNSDefault;
	m_iAutoNNS_TimerDefault = (thePrefs.m_AutoNNS_TimerDefault/1000);
	m_iMaxRemoveNNSLimitDefault = thePrefs.m_MaxRemoveNNSLimitDefault;
	m_bEnableAutoDropFQSDefault = thePrefs.m_EnableAutoDropFQSDefault;
	m_iAutoFQS_TimerDefault = (thePrefs.m_AutoFQS_TimerDefault/1000);
	m_iMaxRemoveFQSLimitDefault = thePrefs.m_MaxRemoveFQSLimitDefault;
	m_bEnableAutoDropQRSDefault = thePrefs.m_EnableAutoDropQRSDefault;
	m_iAutoHQRS_TimerDefault = (thePrefs.m_AutoHQRS_TimerDefault/1000);
	m_iMaxRemoveQRSDefault = thePrefs.m_MaxRemoveQRSDefault;
	m_iMaxRemoveQRSLimitDefault = thePrefs.m_MaxRemoveQRSLimitDefault;
	// <== drop sources - Stulle
// <-------- drop sources

// Contrib - SCC
	// ==> Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
	m_iDlMode = thePrefs.GetDlMode();
	m_bShowCatNames = thePrefs.ShowCatNameInDownList();
	m_bSelectCat = thePrefs.SelectCatForNewDL();
	m_bUseActiveCat = thePrefs.UseActiveCatForLinks();
	m_bAutoSetResOrder = thePrefs.AutoSetResumeOrder();
	m_bSmallFileDLPush = thePrefs.SmallFileDLPush();
	m_iResumeFileInNewCat = thePrefs.StartDLInEmptyCats();
	m_bUseAutoCat = thePrefs.UseAutoCat();
	// <== Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
// <-------- SCC

// Contrib - Inform Clients after IP Change
	m_bIsreaskSourceAfterIPChange = thePrefs.IsRASAIC();
	m_bInformQueuedClientsAfterIPChange = thePrefs.IsIQCAOC();
// <-------- Inform Clients after IP Change

// Contrib - One-queue-per-file
	m_bEnableMultiQueue = thePrefs.GetEnableMultiQueue();
// <-------- One-queue-per-file

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
	m_iCreditSystem = thePrefs.UseCreditSystem(); //>>> WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

/*
// Contrib - SlotControl
	thePrefs.CheckSlotSpeed();
	m_fSlotSpeed = thePrefs.GetSlotSpeed();
// <-------- SlotControl
*/

// Contrib - corrupted blocks ban threshold
	m_iBanThreshold = thePrefs.GetBANTHRES();
// <-------- corrupted blocks ban threshold

// By Taz - ban
	m_bBanVagaa = thePrefs.BanVagaa();
	m_bBanBS = thePrefs.BanBS();
	m_bBanAJ = thePrefs.BanAJ();
	m_bBanCommunity = thePrefs.BanCommunity();
	m_bBanCorrupt = thePrefs.BanCorrupt();
// <------- ban

// Contrib - minRQR
//>>> WiZaRd::minRQR [WiZaRd
	m_bUseMinRQR = thePrefs.ShowMinRQR();
//<<< WiZaRd::minRQR [WiZaRd]
// <-------- minRQR

// Contrib - Client Percentage
	m_bShowClientPercentage = thePrefs.GetShowClientPercentage();
// <-------- Client Percentage

// Contrib - IP2Country
//>>> shadow2004::IP2Country [EastShare]
	m_iI2CCaption = thePrefs.GetIP2CountryNameMode();
	m_bI2CShowFlag = thePrefs.IsIP2CountryShowFlag();
//<<< shadow2004::IP2Country [EastShare]
// <-------- IP2Country

// By Taz - download color
	m_iDownloadRed = thePrefs.GetDownloadRed();
	m_iDownloadGreen = thePrefs.GetDownloadGreen();
	m_iDownloadBlue = thePrefs.GetDownloadBlue();
// <------- download color

// By Taz - Advanced official preferences
	if (thePrefs.GetLanguageID() == LANGID_HE_IL)
		m_bRTLWindowsLayout=thePrefs.m_bRTLWindowsLayout;
// <------- Advanced official preferences

// Contrib - remove unused AICH-hashes
	m_bremove_unused_AICH_hashes = thePrefs.GetRememberAICH();
// <-------- remove unused AICH-hashes

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	m_ctrlTreeOptions.SetItemHeight(m_ctrlTreeOptions.GetItemHeight() + 2);

	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgMOD::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

BOOL CPPgMOD::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

    SetModified(FALSE);

//	theApp.WriteProfileInt(_T("eMule"), _T("IgnoreInstances"), m_bMultipleInstances ? 1 : 0);

// Contrib - IntelliFlush
//>>> WiZaRd::IntelliFlush
	thePrefs.SetFileBufferSize(m_iFileBufferSize*1024);
	thePrefs.SetFileBufferFlushTime(m_iFileBufferTime*60*1000);
	thePrefs.SetUseIntelliFlush(m_bIntelliFlush || m_iFileBufferTime < 1 || m_iFileBufferTime > 5);
//<<< WiZaRd::IntelliFlush
// <-------- IntelliFlush

// Contrib - Automatic shared files updater
	// ==> Automatic shared files updater [MoNKi] - Stulle
	if(m_bAUTO_SHARED_UPDATER != thePrefs.GetDirectoryWatcher()){
		thePrefs.SetDirectoryWatcher(m_bAUTO_SHARED_UPDATER);
		theApp.ResetDirectoryWatcher();
	}
	// <== Automatic shared files updater [MoNKi] - Stulle
// <-------- Automatic shared files updater

// Contrib - Connection Checker
//>>> WiZaRd::ConChecker [eWombat]
	const bool bSetPrefs = m_iConcheckerTTL != thePrefs.GetPingTTL()
		|| m_iConcheckerPingtimeout != thePrefs.GetPingTimeout()
		|| (uint8)m_iConcheckerPingtype != (thePrefs.GetICMP() ? 0 : 1);
	thePrefs.SetPingTTL((uint8)m_iConcheckerTTL);
	thePrefs.SetPingTimeout((uint8)m_iConcheckerPingtimeout);
	thePrefs.SetICMP(m_iConcheckerPingtype == 0);
	if(m_bConcheckerActive != thePrefs.GetCheckCon())
	{
		thePrefs.SetCheckCon(m_bConcheckerActive);
		if(m_bConcheckerActive)
			theApp.conchecker.Start();
		else
			theApp.conchecker.Stop();
	}
	else if(bSetPrefs)
		theApp.conchecker.SetPreferences();
//<<< WiZaRd::ConChecker [eWombat]
// <-------- Connection Checker

// Contrib - QuickStart
	// NEO: QS - [QuickStart]
	thePrefs.m_bQuickStart = m_bQuickStart;
	thePrefs.m_bQuickStartOnIPChange = m_bQuickStartOnIPChange; // NEO: QS - [QuickStart]
	if(m_iQuickStartTime > 18)
		thePrefs.m_iQuickStartTime = 18;
	else	if(m_iQuickStartTime < 8)
				thePrefs.m_iQuickStartTime = 8;
			else thePrefs.m_iQuickStartTime = m_iQuickStartTime;
	//thePrefs.m_iQuickStartTimePerFile = m_iQuickStartTimePerFile;
	if(m_iQuickMaxConperFive > 200)
		thePrefs.m_iQuickMaxConperFive = 200;
	else	if(m_iQuickMaxConperFive < 5)
				thePrefs.m_iQuickMaxConperFive = 5;
			else thePrefs.m_iQuickMaxConperFive = m_iQuickMaxConperFive;
	if(m_iQuickMaxHalfOpen > 100)
		thePrefs.m_iQuickMaxHalfOpen = 100;
	else	if(m_iQuickMaxHalfOpen < 2)
				thePrefs.m_iQuickMaxHalfOpen = 2;
			else thePrefs.m_iQuickMaxHalfOpen = m_iQuickMaxHalfOpen;
	if(m_iQuickMaxConnections > 4000)
		thePrefs.m_iQuickMaxConnections = 4000;
	else	if(m_iQuickMaxConnections < 200)
				thePrefs.m_iQuickMaxConnections = 200;
			else thePrefs.m_iQuickMaxConnections = m_iQuickMaxConnections;
	// NEO: QS END
// <-------- QuickStart

// Contrib - version check
	thePrefs.SetUpdateNotifyBeta(m_bModBetaCheck && m_bModVersionCheck);
	thePrefs.SetUpdateNotifyMod(m_bModVersionCheck || m_bModBetaCheck);
// <-------- version check

// Contrib - SLS
//>>> JvA::SLS [enkeyDEV]
	thePrefs.SetSaveLoadSource(m_bSLSCheck);
	thePrefs.SetActivationLimitSLS((uint8)m_iSLSActivationLimit);
	thePrefs.SetSourcesToSaveSLS((uint8)m_iSLSSaveValue);
//<<< JvA::SLS [enkeyDEV]
// <-------- SLS

// Contrib - Global HL
	thePrefs.ShowGlobalHL = m_bShowGlobalHL; // show global HL - Stulle
	thePrefs.ShowFileHLconst = m_bShowFileHLconst; // show HL per file constantly
	// ==> Global Source Limit - Stulle
	if (thePrefs.GetGlobalHL() != (UINT)m_iGlobalHL ||
		thePrefs.IsUseGlobalHL() != m_bGlobalHL)
	{
		thePrefs.m_bGlobalHL = m_bGlobalHL;
		thePrefs.m_uGlobalHL = m_iGlobalHL;
		if(m_bGlobalHL && theApp.downloadqueue->GetPassiveMode())
		{
			theApp.downloadqueue->SetPassiveMode(false);
			theApp.downloadqueue->SetUpdateHlTime(50000); // 50 sec
			AddDebugLogLine(true,L"{GSL} Global Source Limit settings have changed! Disabled PassiveMode!");
		}
	}
	// <== Global Source Limit - Stulle
// <-------- Global HL

// Contrib - retry connection attempts
	thePrefs.retryconnectionattempts = m_bRetryConnectionAttempts;
// <-------- retry connection attempts

// Contrib - drop sources
	// ==> drop sources - Stulle
	thePrefs.m_EnableAutoDropNNSDefault = m_bEnableAutoDropNNSDefault;
	thePrefs.m_AutoNNS_TimerDefault = (m_iAutoNNS_TimerDefault*1000);
	thePrefs.m_MaxRemoveNNSLimitDefault = (uint16)m_iMaxRemoveNNSLimitDefault;
	thePrefs.m_EnableAutoDropFQSDefault = m_bEnableAutoDropFQSDefault;
	thePrefs.m_AutoFQS_TimerDefault = (m_iAutoFQS_TimerDefault*1000);
	thePrefs.m_MaxRemoveFQSLimitDefault = (uint16)m_iMaxRemoveFQSLimitDefault;
	thePrefs.m_EnableAutoDropQRSDefault = m_bEnableAutoDropQRSDefault;
	thePrefs.m_AutoHQRS_TimerDefault = (m_iAutoHQRS_TimerDefault*1000);
	thePrefs.m_MaxRemoveQRSDefault = (uint16)m_iMaxRemoveQRSDefault;
	thePrefs.m_MaxRemoveQRSLimitDefault = (uint16)m_iMaxRemoveQRSLimitDefault;
	// <== drop sources - Stulle
// <-------- drop sources

// Contrib - SCC
	// ==> Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
	thePrefs.dlMode = (uint8)m_iDlMode;
	thePrefs.m_bShowCatNames = m_bShowCatNames;
	thePrefs.m_bSelCatOnAdd = m_bSelectCat;
	thePrefs.m_bActiveCatDefault = m_bUseActiveCat;
	thePrefs.m_bAutoSetResumeOrder = m_bAutoSetResOrder;
	thePrefs.m_bSmallFileDLPush = m_bSmallFileDLPush;
	thePrefs.m_iStartDLInEmptyCats = (uint8)m_iResumeFileInNewCat;
	thePrefs.m_bUseAutoCat = m_bUseAutoCat;
	// <== Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
// <-------- SCC

// Contrib - Inform Clients after IP Change
	thePrefs.SetRASAIC(m_bIsreaskSourceAfterIPChange);
	thePrefs.SetIQCAOC(m_bInformQueuedClientsAfterIPChange);
// <-------- Inform Clients after IP Change

// Contrib - One-queue-per-file
	thePrefs.SetEnableMultiQueue(m_bEnableMultiQueue);
// <-------- One-queue-per-file

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
	thePrefs.SetCreditSystem((uint8) m_iCreditSystem); //>>> WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

/*
// Contrib - SlotControl
	thePrefs.SetSlotSpeed(m_fSlotSpeed);
	thePrefs.CheckSlotSpeed();
	m_fSlotSpeed = thePrefs.GetSlotSpeed();
// <-------- SlotControl
*/

// Contrib - corrupted blocks ban threshold
	thePrefs.SetBANTHRES((uint8) m_iBanThreshold);
// <-------- corrupted blocks ban threshold

// Contrib - ban
	thePrefs.SetBanVagaa(m_bBanVagaa);
	thePrefs.SetBanBS(m_bBanBS);
	thePrefs.SetBanAJ(m_bBanAJ);
	thePrefs.SetBanCommunity(m_bBanCommunity);
	thePrefs.SetBanCorrupt(m_bBanCorrupt);
// <-------- ban

// Contrib - minRQR
//>>> WiZaRd::minRQR [WiZaRd]
	thePrefs.SetMinRQR(m_bUseMinRQR);
//<<< WiZaRd::minRQR [WiZaRd]
// <-------- minRQR

// Contrib - Client Percentage
	thePrefs.SetShowClientPercentage(m_bShowClientPercentage);
// <-------- Client Percentage

// Contrib - IP2Country
//>>> shadow2004::IP2Country [EastShare]
	//Check if ip2country is loaded at this point
	if (!theApp.ip2country->IsIP2Country())
		theApp.ip2country->Load();
	thePrefs.SetIP2CountryNameMode((uint8)m_iI2CCaption);
	thePrefs.SetIP2CountryShowFlag(m_bI2CShowFlag);
	theApp.ip2country->Refresh();//refresh passive windows
//<<< shadow2004::IP2Country [EastShare]
// <-------- IP2Country

// By Taz - download color
	thePrefs.SetDownloadRed((uint8) m_iDownloadRed);
	thePrefs.SetDownloadGreen((uint8) m_iDownloadGreen);
	thePrefs.SetDownloadBlue((uint8) m_iDownloadBlue);
// <------- download color

// Contrib - Advanced official preferences
	if (thePrefs.GetLanguageID() == LANGID_HE_IL && thePrefs.m_bRTLWindowsLayout != m_bRTLWindowsLayout){
		thePrefs.m_bRTLWindowsLayout=m_bRTLWindowsLayout;
		AfxMessageBox(GetResString(IDS_SETTINGCHANGED_RESTART));
	}
// <-------- Advanced official preferences

// Contrib - remove unused AICH-hashes
	thePrefs.SetRememberAICH(m_bremove_unused_AICH_hashes);
// <-------- remove unused AICH-hashes

	return CPropertyPage::OnApply();
}

void CPPgMOD::Localize(void)
{
	if(m_hWnd)
	{
		CString buffer;
		SetWindowText(MOD_VERSION);

// Contrib - version check
		if (m_htiModVersionCheck) m_ctrlTreeOptions.SetItemText(m_htiModVersionCheck, GetResString(IDS_MODVERSIONCHECK));
		if (m_htiModBetaCheck) m_ctrlTreeOptions.SetItemText(m_htiModBetaCheck, GetResString(IDS_MODBETACHECK));
// <-------- version check

// Contrib - Mod Options arangement
		if (m_htiSystemGroup) m_ctrlTreeOptions.SetItemText(m_htiSystemGroup, GetResString(IDS_SYSTEM));
		if (m_htiDM) m_ctrlTreeOptions.SetItemText(m_htiDM, GetResString(IDS_DM));
		if (m_htiUM) m_ctrlTreeOptions.SetItemText(m_htiUM, GetResString(IDS_UM));
		if(m_htiDisplayGroup) m_ctrlTreeOptions.SetItemText(m_htiDisplayGroup, GetResString(IDS_PW_DISPLAY));
// <-------- Mod Options arangement

// Contrib - IntelliFlush
//>>> WiZaRd::IntelliFlush
		if (m_htiFileBufferGroup) m_ctrlTreeOptions.SetItemText(m_htiFileBufferGroup, GetResString(IDS_FILEBUFFER));
		if (m_htiFileBufferSize)
		{
			buffer.Format(_T("%s [%s]"), GetResString(IDS_FILEBUFFERSIZE), GetResString(IDS_KBYTES));
			m_ctrlTreeOptions.SetEditLabel(m_htiFileBufferSize, buffer);
		}
		if (m_htiFileBufferTime)	m_ctrlTreeOptions.SetEditLabel(m_htiFileBufferTime, GetResString(IDS_FILEBUFFER_TIME));
		if (m_htiIntelliFlushCheck) m_ctrlTreeOptions.SetItemText(m_htiIntelliFlushCheck, GetResString(IDS_FILEBUFFER_INTELLI));
//<<< WiZaRd::IntelliFlush
// <-------- IntelliFlush

// Contrib - Automatic shared files updater
		if (m_htiAUTO_SHARED_UPDATER) m_ctrlTreeOptions.SetItemText(m_htiAUTO_SHARED_UPDATER, GetResString(IDS_AUTO_SHARED_UPDATER));
// <-------- Automatic shared files updater

// Contrib - SLS
//>>> JvA::SLS [enkeyDEV]
		if(m_htiSLSGroup) m_ctrlTreeOptions.SetItemText(m_htiSLSGroup, GetResString(IDS_SLSLABEL));
		if(m_htiSLSCheck) m_ctrlTreeOptions.SetItemText(m_htiSLSCheck, GetResString(IDS_SLSCHECKLABEL));
		if(m_htiSLSActivationLimit) m_ctrlTreeOptions.SetEditLabel(m_htiSLSActivationLimit, GetResString(IDS_SLSACTIVATIONLABEL));
		if(m_htiSLSSaveValue) m_ctrlTreeOptions.SetEditLabel(m_htiSLSSaveValue, GetResString(IDS_SLSSAVEVALUE));
//<<< JvA::SLS [enkeyDEV]
// <-------- SLS

// Contrib - Global HL
		if (m_htiShowGlobalHL) m_ctrlTreeOptions.SetItemText(m_htiShowGlobalHL, GetResString(IDS_SHOW_GLOBAL_HL)); // show global HL - Stulle
		if (m_htiShowFileHLconst) m_ctrlTreeOptions.SetItemText(m_htiShowFileHLconst, GetResString(IDS_SHOW_FILE_HL_CONST)); // show HL per file constantly
		// ==> Global Source Limit - Stulle
		if (m_htiGlobalHL) m_ctrlTreeOptions.SetItemText(m_htiGlobalHL, GetResString(IDS_SUC_ENABLED));
		if (m_htiGlobalHlLimit) m_ctrlTreeOptions.SetEditLabel(m_htiGlobalHlLimit, GetResString(IDS_GLOBAL_HL_LIMIT));
		// <== Global Source Limit - Stulle
// <-------- Global HL

// Contrib - retry connection attempts
		if (m_htiRetryConnectionAttempts) m_ctrlTreeOptions.SetItemText(m_htiRetryConnectionAttempts, GetResString(IDS_RETRYCONNECTIONATTEMPTS));
// <-------- retry connection attempts

// Contrib - drop sources
		// ==> drop sources - Stulle
		if (m_htiAutoNNS) m_ctrlTreeOptions.SetItemText(m_htiAutoNNS, GetResString(IDS_AUTO_NNS));
		if (m_htiAutoNNSTimer) m_ctrlTreeOptions.SetEditLabel(m_htiAutoNNSTimer, GetResString(IDS_NNS_TIMERLABEL));
		if (m_htiAutoNNSLimit) m_ctrlTreeOptions.SetEditLabel(m_htiAutoNNSLimit, GetResString(IDS_REMOVENNSLIMITLABEL));
		if (m_htiAutoFQS) m_ctrlTreeOptions.SetItemText(m_htiAutoFQS, GetResString(IDS_AUTO_FQS));
		if (m_htiAutoFQSTimer) m_ctrlTreeOptions.SetEditLabel(m_htiAutoFQSTimer, GetResString(IDS_FQS_TIMERLABEL));
		if (m_htiAutoFQSLimit) m_ctrlTreeOptions.SetEditLabel(m_htiAutoFQSLimit, GetResString(IDS_REMOVEFQSLIMITLABEL));
		if (m_htiAutoQRS) m_ctrlTreeOptions.SetItemText(m_htiAutoQRS, GetResString(IDS_AUTO_QRS));
		if (m_htiAutoQRSTimer) m_ctrlTreeOptions.SetEditLabel(m_htiAutoQRSTimer, GetResString(IDS_HQRS_TIMERLABEL));
		if (m_htiAutoQRSMax) m_ctrlTreeOptions.SetEditLabel(m_htiAutoQRSMax, GetResString(IDS_REMOVEQRSLABEL));
		if (m_htiAutoQRSLimit) m_ctrlTreeOptions.SetEditLabel(m_htiAutoQRSLimit, GetResString(IDS_REMOVEQRSLIMITLABEL));
		// <== drop sources - Stulle
// <-------- drop sources

// Contrib - SCC
		// ==> Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
		if (m_htiShowCatNames) m_ctrlTreeOptions.SetItemText(m_htiShowCatNames, GetResString(IDS_CAT_SHOWCATNAME));
		if (m_htiSelectCat) m_ctrlTreeOptions.SetItemText(m_htiSelectCat, GetResString(IDS_CAT_SHOWSELCATDLG));
		if (m_htiUseAutoCat) m_ctrlTreeOptions.SetItemText(m_htiUseAutoCat, GetResString(IDS_CAT_USEAUTOCAT));
        if (m_htiUseActiveCat) m_ctrlTreeOptions.SetItemText(m_htiUseActiveCat, GetResString(IDS_CAT_USEACTIVE));
		if (m_htiAutoSetResOrder) m_ctrlTreeOptions.SetItemText(m_htiAutoSetResOrder, GetResString(IDS_CAT_AUTORESUMEORD));
		if (m_htiSmallFileDLPush) m_ctrlTreeOptions.SetItemText(m_htiSmallFileDLPush, GetResString(IDS_CAT_SMALLFILEDLPUSH));
		if (m_htiResumeFileInNewCat) m_ctrlTreeOptions.SetEditLabel(m_htiResumeFileInNewCat, GetResString(IDS_CAT_STARTFILESONADD));
		// <== Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
// <-------- SCC

// Contrib - Inform Clients after IP Change
		if (m_htiIsreaskSourceAfterIPChange) m_ctrlTreeOptions.SetItemText(m_htiIsreaskSourceAfterIPChange, GetResString(IDS_RSAIC));
		if (m_htiInformQueuedClientsAfterIPChange) m_ctrlTreeOptions.SetItemText(m_htiInformQueuedClientsAfterIPChange, GetResString(IDS_IQCAOC));
// <-------- Inform Clients after IP Change

// Contrib - One-queue-per-file
		if (m_htiEnableMultiQueue) m_ctrlTreeOptions.SetItemText(m_htiEnableMultiQueue, GetResString(IDS_MULTIQUEUE));
// <-------- One-queue-per-file

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
//>>> WiZaRd::ClientAnalyzer
		if (m_htiCSNone) m_ctrlTreeOptions.SetItemText(m_htiCSNone, GetResString(IDS_CS_NONE));
		if (m_htiCSOffi) m_ctrlTreeOptions.SetItemText(m_htiCSOffi, GetResString(IDS_CS_OFFI));
		if (m_htiCSAnalyzer) m_ctrlTreeOptions.SetItemText(m_htiCSAnalyzer, GetResString(IDS_CS_ANALYZER));
//<<< WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

/*
// Contrib - SlotControl
		if (m_htiSlotSpeed) m_ctrlTreeOptions.SetEditLabel(m_htiSlotSpeed, GetResString(IDS_SLOT_SPEED));
// <-------- SlotControl
*/

// Contrib - corrupted blocks ban threshold
		if (m_htiBanThreshold) m_ctrlTreeOptions.SetEditLabel(m_htiBanThreshold, GetResString(IDS_BanThreshold));
// <-------- corrupted blocks ban threshold

// By Taz - ban
		if (m_htiBanVagaa) m_ctrlTreeOptions.SetItemText(m_htiBanVagaa, GetResString(IDS_BANVAGAA));
		if (m_htiBanBS) m_ctrlTreeOptions.SetItemText(m_htiBanBS, GetResString(IDS_BANBS));
		if (m_htiBanAJ) m_ctrlTreeOptions.SetItemText(m_htiBanAJ, GetResString(IDS_BANAJ));
		if (m_htiBanCommunity) m_ctrlTreeOptions.SetItemText(m_htiBanCommunity, GetResString(IDS_BANCOMMUNITY));
		if (m_htiBanCorrupt) m_ctrlTreeOptions.SetItemText(m_htiBanCorrupt, GetResString(IDS_BANCORRUPT));
// <------- ban

// Contrib - minRQR
//>>> WiZaRd::minRQR [WiZaRd]
		if(m_htiMinRQR) m_ctrlTreeOptions.SetItemText(m_htiMinRQR, GetResString(IDS_MINRQR_ENABLE));
//<<< WiZaRd::minRQR [WiZaRd]
// <-------- minRQR

// Contrib - Client Percentage
		if (m_htiShowClientPercentage) m_ctrlTreeOptions.SetItemText(m_htiShowClientPercentage, GetResString(IDS_SHOW_CLIENT_PERCENTAGE));
// <-------- Client Percentage

// Contrib - IP2Country
//>>> shadow2004::IP2Country [EastShare]
		if(m_htiI2CGroup) m_ctrlTreeOptions.SetItemText(m_htiI2CGroup, GetResString(IDS_IP2COUNTRY));
		if(m_htiI2C2Letter) m_ctrlTreeOptions.SetItemText(m_htiI2C2Letter, GetResString(IDS_IP2COUNTRY_2LETTERS));
		if(m_htiI2C3Letter) m_ctrlTreeOptions.SetItemText(m_htiI2C3Letter, GetResString(IDS_IP2COUNTRY_3LETTERS));
		if(m_htiI2CFullCaption) m_ctrlTreeOptions.SetItemText(m_htiI2CFullCaption, GetResString(IDS_IP2COUNTRY_FULLCAPTION));
		if(m_htiI2CShowFlag) m_ctrlTreeOptions.SetItemText(m_htiI2CShowFlag, GetResString(IDS_IP2COUNTRY_SHOWFLAGS));
//<<< shadow2004::IP2Country [EastShare]
// <-------- IP2Country

// By Taz - download color
		if(m_htiDownloadColor) m_ctrlTreeOptions.SetItemText(m_htiDownloadColor, GetResString(IDS_DOWNLOAD_COLOR));
		if(m_htiRedDownload) m_ctrlTreeOptions.SetEditLabel(m_htiRedDownload, GetResString(IDS_RED_DOWNLOAD));
		if(m_htiGreenDownload) m_ctrlTreeOptions.SetEditLabel(m_htiGreenDownload, GetResString(IDS_GREEN_DOWNLOAD));
		if(m_htiBlueDownload) m_ctrlTreeOptions.SetEditLabel(m_htiBlueDownload, GetResString(IDS_BLUE_DOWNLOAD));
// <------- download color

// Contrib - Advanced official preferences
		if (thePrefs.GetLanguageID() == LANGID_HE_IL && m_hti_m_bRTLWindowsLayout)
			m_ctrlTreeOptions.SetItemText(m_hti_m_bRTLWindowsLayout, GetResString(IDS_RTLWINDOWSLAYOUT));
// <-------- Advanced official preferences

		if(m_htiMoreTweaksGroup) m_ctrlTreeOptions.SetItemText(m_htiMoreTweaksGroup, GetResString(IDS_PW_MISC));

// Contrib - remove unused AICH-hashes
	if (m_htiremove_unused_AICH_hashes) m_ctrlTreeOptions.SetItemText(m_htiremove_unused_AICH_hashes, GetResString(IDS_REMEMBERAICH));
// <-------- remove unused AICH-hashes

// By Taz - startup sound
//		if(m_htiStartupSound) m_ctrlTreeOptions.SetItemText(m_htiStartupSound, GetResString(IDS_PW_STARTUPSOUND));
// <------- startup sound

	}
}

void CPPgMOD::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	Nullify();

	CPropertyPage::OnDestroy();
}

LRESULT CPPgMOD::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	if (wParam == IDC_MOD_OPTS)
	{
		//TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		//(void*) pton;

		SetModified();
	}
	return 0;
}

void CPPgMOD::OnHelp()
{

// Contrib - Mod link
//>>> WiZaRd:EMF Link
	theApp.emuledlg->SendMessage(WM_COMMAND, MP_HM_LINK4, 0);
//<<< WiZaRd:EMF Link
// <-------- Mod link

}

BOOL CPPgMOD::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgMOD::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

//all variables are to be reset in here
void	CPPgMOD::Nullify()
{

// Contrib - Mod Options arangement
	m_htiSystemGroup = NULL;
	m_htiDM = NULL;
	m_htiUM = NULL;
	m_htiDisplayGroup = NULL;
	m_htiMoreTweaksGroup = NULL;
// <-------- Mod Options arangement

// Contrib - version check
	m_htiModVersionCheck = NULL;
	m_htiModBetaCheck = NULL;
// <-------- version check

// Contrib - IntelliFlush
//>>> WiZaRd::IntelliFlush
	m_htiFileBufferGroup = NULL;
	m_htiFileBufferSize = NULL;
	m_htiFileBufferTime = NULL;
	m_htiIntelliFlushCheck = NULL;
	m_iFileBufferSize = 0;
	m_iFileBufferTime = 0;
	m_bIntelliFlush = false;
//<<< WiZaRd::IntelliFlush
// <-------- IntelliFlush

// Contrib - Connection Checker
//>>> WiZaRd::ConChecker [eWombat]
	m_htiConcheckerGroup = NULL;
	m_htiConcheckerActive = NULL;
	m_htiConcheckerPingtypeRadio = NULL;
	m_htiConcheckerPingICMP = NULL;
	m_htiConcheckerPingRAW = NULL;
	m_htiConcheckerTTL = NULL;
	m_htiConcheckerPingtimeout = NULL;
	m_bConcheckerActive = false;
	m_iConcheckerPingtype = 0;
	m_iConcheckerTTL = 0;
	m_iConcheckerPingtimeout = 0;
//<<< WiZaRd::ConChecker [eWombat]
// <-------- Connection Checker

// Contrib - Automatic shared files updater
		m_htiAUTO_SHARED_UPDATER = NULL;
		m_bAUTO_SHARED_UPDATER = false;
// <-------- Automatic shared files updater

// Contrib - SLS
//>>> JvA::SLS [enkeyDEV]
	m_htiSLSGroup = NULL;
	m_htiSLSCheck = NULL;
	m_htiSLSActivationLimit = NULL;
	m_htiSLSSaveValue = NULL;
	m_bSLSCheck = false;
	m_iSLSActivationLimit = 0;
	m_iSLSSaveValue = 0;
//<<< JvA::SLS [enkeyDEV]
// <-------- SLS

// Contrib - drop sources
	// ==> drop sources - Stulle
	m_htiDropDefaults = NULL;
	m_htiAutoNNS = NULL;
	m_htiAutoNNSTimer = NULL;
	m_htiAutoNNSLimit = NULL;
	m_htiAutoFQS = NULL;
	m_htiAutoFQSTimer = NULL;
	m_htiAutoFQSLimit = NULL;
	m_htiAutoQRS = NULL;
	m_htiAutoQRSTimer = NULL;
	m_htiAutoQRSMax = NULL;
	m_htiAutoQRSLimit = NULL;
	// <== drop sources - Stulle
// <-------- drop sources

// Contrib - retry connection attempts
	m_htiRetryConnectionAttempts = NULL;
	m_bRetryConnectionAttempts = false;
// <-------- retry connection attempts

// Contrib - Global HL
	// ==> Global Source Limit - Stulle
	m_htiGlobalHlGroup = NULL;
	m_htiGlobalHL = NULL;
	m_htiGlobalHlLimit = NULL;
	// <== Global Source Limit - Stulle
	m_bGlobalHL = false;
	m_iGlobalHL = 0;
	m_htiShowGlobalHL = NULL; // show global HL - Stulle
	m_htiShowFileHLconst = NULL; // show HL per file constantly
	m_bShowGlobalHL = false; // show global HL - Stulle
	m_bShowFileHLconst = false; // show HL per file constantly
// <-------- Global HL

/*
// Contrib - SlotControl
	m_htiSlotSpeed = NULL;
	m_fSlotSpeed = 0.0F;
// <-------- SlotControl
*/

// By Taz - download color
	m_htiDownloadColor = NULL;
	m_htiRedDownload = NULL;
	m_htiGreenDownload = NULL;
	m_htiBlueDownload = NULL;
	m_iDownloadRed = 0;
	m_iDownloadGreen = 0;
	m_iDownloadBlue = 0;
// <------- download color

// Contrib - SCC
	// ==> Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
	m_htiSCC = NULL;
	m_htiDlMode = NULL;
	m_htiDlNone = NULL;
	m_htiDlAlph = NULL;
	m_htiDlLP = NULL;
	m_htiShowCatNames = NULL;
	m_htiSelectCat = NULL;
	m_htiUseActiveCat = NULL;
	m_htiAutoSetResOrder = NULL;
	m_htiSmallFileDLPush = NULL;
	m_htiResumeFileInNewCat = NULL;
	m_htiUseAutoCat = NULL;
	// <== Smart Category Control (SCC) [khaos/SiRoB/Stulle] - Stulle
// <-------- SCC

// Contrib - Inform Clients after IP Change
	m_htiIsreaskSourceAfterIPChange = NULL;
	m_htiInformQueuedClientsAfterIPChange = NULL;
	m_bIsreaskSourceAfterIPChange = false;
	m_bInformQueuedClientsAfterIPChange = false;
// <-------- Inform Clients after IP Change

// Contrib - One-queue-per-file
	m_htiEnableMultiQueue = NULL;
	m_bEnableMultiQueue = false;
// <-------- One-queue-per-file

// Contrib - corrupted blocks ban threshold
	m_htiBanThreshold = NULL;
// <-------- corrupted blocks ban threshold

// By Taz - ban
	m_htiBanVagaa = NULL;
	m_bBanVagaa = false;
	m_htiBanBS = NULL;
	m_bBanBS = false;
	m_htiBanAJ = NULL;
	m_bBanAJ = false;
	m_htiBanCommunity = NULL;
	m_bBanCommunity = false;
	m_htiBanCorrupt = NULL;
	m_bBanCorrupt = false;
	m_htiBan = NULL;
// <------- ban

// Contrib - ClientAnalyzer
#ifdef CLIENTANALYZER
	m_iCreditSystem = 0; //>>> WiZaRd::ClientAnalyzer
//>>> WiZaRd::ClientAnalyzer
	m_htiCreditSystem = NULL;
	m_htiCSNone = NULL;
	m_htiCSOffi = NULL;
	m_htiCSAnalyzer = NULL;
//<<< WiZaRd::ClientAnalyzer
#endif
// <-------- ClientAnalyzer

// Contrib - minRQR
//>>> WiZaRd::minRQR [WiZaRd]
	m_htiMinRQR = NULL;
	m_bUseMinRQR = false;
//<<< WiZaRd::minRQR [WiZaRd]
// <-------- minRQR

// Contrib - Client Percentage
	m_htiShowClientPercentage = NULL;
	m_bShowClientPercentage = false;
// <-------- Client Percentage

// By Taz - Advanced official preferences
	m_hti_m_bRTLWindowsLayout=NULL;
	m_bRTLWindowsLayout=false;
// <------- Advanced official preferences

// Contrib - remove unused AICH-hashes
	m_htiremove_unused_AICH_hashes = NULL;
	m_bremove_unused_AICH_hashes = false;
// <-------- remove unused AICH-hashes

// Contrib - QuickStart
// NEO: QS - [QuickStart]
	m_htiQuickStart = NULL;
	m_htiQuickStartEnable = NULL;
	m_htiQuickStartTime = NULL;
	m_htiQuickMaxConperFive = NULL;
	m_htiQuickMaxHalfOpen = NULL;
	m_htiQuickMaxConnections = NULL;
	m_htiQuickStartOnIPChange = NULL; // NEO: QS - [QuickStart]
// NEO: QS END
	m_bQuickStart = false;
	m_bQuickStartOnIPChange = false; // NEO: QS - [QuickStart]
	m_iQuickStartTime = 0;
	m_iQuickMaxConperFive = 0;
	m_iQuickMaxHalfOpen = 0;
	m_iQuickMaxConnections = 0;
// <-------- QuickStart

}

/*
// Contrib - SlotControl
// X-Ray :: SlotControl :: Start
float CPPgMOD::CalculateMaxSlotSpeed()
{
	float fMaxUp = 10.0f;
	float fMaxSlotSpeed = 3.0f;
	if(thePrefs.GetMaxUpload() > 0)
		fMaxUp = (float)thePrefs.GetMaxUpload();
	if(fMaxUp < 6)
		fMaxSlotSpeed = 2.0f;
	if(fMaxUp >= 10)
		fMaxSlotSpeed=fMaxUp/(3+(fMaxUp-10)/20.0f);
	if(fMaxSlotSpeed > 15.0f)
		fMaxSlotSpeed = 15.0f;

// By Taz - adjust
	float desiredNumOfSlots = floor((float)thePrefs.GetMaxUpload() / fMaxSlotSpeed);

	if (desiredNumOfSlots < 1.0f)
		fMaxSlotSpeed = 0.0f;
	else
		fMaxSlotSpeed = floor((float)thePrefs.GetMaxUpload() * 100.0f / desiredNumOfSlots) / 100.0f;
// <------- adjust

	return fMaxSlotSpeed;
}
// X-Ray :: SlotControl :: End
// <-------- SlotControl
*/
