//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "emuleDlg.h"
#include "PPgASF.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Opcodes.h"
#include "ServerWnd.h"
#include ".\ppgasf.h"
#ifdef ASFVII
// By Taz - ASFv2
#include "ServerListCtrl.h"
// <------- ASFv2
#endif
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgASF, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgASF, CPropertyPage)
#ifdef ASFVII
// gomez82 >>> ASFv2
	ON_EN_CHANGE(IDC_FILTERNAME, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERDESC, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERUSERVAL, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERFILEVAL, OnSettingsChange)
	ON_BN_CLICKED(IDC_ASF_AUTOFILTER , OnSettingsChange)
	ON_BN_CLICKED(IDC_STATIC,OnBnClickedAckHelp)
// By Taz - ASFv2
	ON_BN_CLICKED(IDC_ASF_ON, OnBnClickedASF_ON)
	ON_BN_CLICKED(IDC_SERVERANALYZER_ON, OnBnClickedSERVERANALYZER_ON)
	ON_BN_CLICKED(IDC_ASF_AUTOFILTER, OnSettingsChange)
// <------- ASFv2
	ON_BN_CLICKED(IDC_ACKHELP,OnBnClickedAckHelp)
	ON_BN_CLICKED(IDC_ACKHELP2,OnBnClickedAckHelp2)//Mulo da Soma - restore 3button-link now pointing to AcKroNiC WiKi
	ON_BN_CLICKED(IDC_ACKHELP3,OnBnClickedAckHelp3)
// gomez82 >>> ASFv2
#else
	ON_EN_CHANGE(IDC_FILTERNAME, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERDESC, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERUSERVAL, OnSettingsChange)
	ON_EN_CHANGE(IDC_FILTERFILEVAL, OnSettingsChange)
	ON_BN_CLICKED(IDC_ASF_AUTOFILTER , OnSettingsChange)
	ON_BN_CLICKED(IDC_STATIC,OnBnClickedAsfHelp)
	ON_BN_CLICKED(IDC_ASFHELP,OnBnClickedAsfHelp)
#endif
	ON_WM_HSCROLL()
	ON_WM_DESTROY()
END_MESSAGE_MAP()

CPPgASF::CPPgASF()
	: CPropertyPage(CPPgASF::IDD)
{
#ifdef ASFVII
// By Taz - ASFv2
	m_iFilter = (thePrefs.ASF_ON() ? 0 : 1);
// <------- ASFv2
#endif
}

CPPgASF::~CPPgASF()
{
}

void CPPgASF::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
#ifdef ASFVII
// By Taz - ASFv2
	DDX_Radio(pDX, IDC_ASF_ON, m_iFilter);
// <------- ASFv2
#endif
}

BOOL CPPgASF::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);


	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}
void CPPgASF::LoadSettings(void)
{
#ifdef ASFVII
	GetDlgItem(IDC_FILTERNAME)->SetWindowText(thePrefs.ServerFilterVal);
	GetDlgItem(IDC_FILTERDESC)->SetWindowText(thePrefs.ServerFilterDesc);
	SetDlgItemInt(IDC_FILTERUSERVAL, thePrefs.ServerFilterByUsers, FALSE);
	SetDlgItemInt(IDC_FILTERFILEVAL, thePrefs.ServerFilterByFiles, FALSE);
// By Taz - ASFv2
	m_iFilter = (thePrefs.ASF_ON() ? 0 : 1);
	GetDlgItem(IDC_ASF_AUTOFILTER)->EnableWindow(thePrefs.ASF_ON());
	CheckRadioButton(IDC_ASF_AUTOFILTER, IDC_SERVERANALYZER_ON, IDC_ASF_AUTOFILTER + m_iFilter);

	if(!thePrefs.ASF_ON())
		thePrefs.SetASF_AutoFilter(false);
// <------- ASFv2
	if(thePrefs.ASF_AutoFilter())
		CheckDlgButton(IDC_ASF_AUTOFILTER,1);
	else
		CheckDlgButton(IDC_ASF_AUTOFILTER,0);
#else
	GetDlgItem(IDC_FILTERNAME)->SetWindowText(thePrefs.ServerFilterVal);
	GetDlgItem(IDC_FILTERDESC)->SetWindowText(thePrefs.ServerFilterDesc);
	SetDlgItemInt(IDC_FILTERUSERVAL, thePrefs.ServerFilterByUsers, FALSE);
	SetDlgItemInt(IDC_FILTERFILEVAL, thePrefs.ServerFilterByFiles, FALSE);
	if(thePrefs.filterserverbyip)
		CheckDlgButton(IDC_FILTERSERVERBYIPFILTER,1);
	else
		CheckDlgButton(IDC_FILTERSERVERBYIPFILTER,0);
#endif
}

BOOL CPPgASF::OnApply()
{
	if (!UpdateData())
		return FALSE;

	GetDlgItem(IDC_FILTERNAME)->GetWindowText(thePrefs.ServerFilterVal,ARRSIZE(thePrefs.ServerFilterVal));
	GetDlgItem(IDC_FILTERDESC)->GetWindowText(thePrefs.ServerFilterDesc,ARRSIZE(thePrefs.ServerFilterDesc));

	thePrefs.ServerFilterByUsers = GetDlgItemInt(IDC_FILTERUSERVAL, NULL, FALSE);
	/*if (thePrefs.ServerFilterByUsers < 0)// gomez82 fixed warning
		thePrefs.ServerFilterByUsers = 0;
	else*/// gomez82 fixed warning
	if (thePrefs.ServerFilterByUsers > 1000000000)
		thePrefs.ServerFilterByUsers = 1000000000;

	thePrefs.ServerFilterByFiles = GetDlgItemInt(IDC_FILTERFILEVAL, NULL, FALSE);
	/*if (thePrefs.ServerFilterByFiles < 0)// gomez82 fixed warning
		thePrefs.ServerFilterByFiles = 0;
	else*/// gomez82 fixed warning
	if (thePrefs.ServerFilterByFiles > 1000000000)
		thePrefs.ServerFilterByFiles = 1000000000;
#ifdef ASFVII
// By Taz - ASFv2
	if (thePrefs.ASF_ON()!= (m_iFilter == 0)){
		theApp.emuledlg->serverwnd->serverlistctrl.ShowServers();
		thePrefs.SetASF(m_iFilter == 0);
	}
// <------- ASFv2

	thePrefs.SetASF_AutoFilter(IsDlgButtonChecked(IDC_ASF_AUTOFILTER)!=0);

	if(thePrefs.ASF_AutoFilter())
		theApp.emuledlg->serverwnd->OnBnClickedServerFilterDlg();

	theApp.emuledlg->serverwnd->GetDlgItem(IDC_SRVFILTER_BTN)->EnableWindow((thePrefs.ASF_ON() && !thePrefs.ASF_AutoFilter())||!thePrefs.ASF_ON());// gomez82 >>>
#else
	thePrefs.filterserverbyip = IsDlgButtonChecked(IDC_FILTERSERVERBYIPFILTER)!=0;
	
	if(thePrefs.filterserverbyip)
		theApp.emuledlg->serverwnd->serverlistctrl.RemoveAllFilteredServers();
	
	theApp.emuledlg->serverwnd->GetDlgItem(IDC_SRVFILTER_BTN)->EnableWindow(thePrefs.filterserverbyip);
	theApp.emuledlg->serverwnd->serverlistctrl.ShowServers();
#endif
	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgASF::Localize(void)
{
	if (m_hWnd)
	{
#ifdef ASFVII
		GetDlgItem(IDC_ACKHELP)->SetWindowText(GetResString(IDS_ACKHELP));
		GetDlgItem(IDC_ACKHELP2)->SetWindowText(GetResString(IDS_ACKHELP2));//Mulo da Soma - Restore 3 button-link now pointing to AcKroNiC WiKi	
		GetDlgItem(IDC_ACKHELP3)->SetWindowText(GetResString(IDS_ACKHELP3));
#else
		GetDlgItem(IDC_ASFHELP)->SetWindowText(GetResString(IDS_ASFHELP));
#endif
		GetDlgItem(IDC_FILTERNAMELABEL)->SetWindowText(GetResString(IDS_FILTERNAMELABEL));
		GetDlgItem(IDC_FILTERDESCLABEL)->SetWindowText(GetResString(IDS_FILTERDESCLABEL));
		GetDlgItem(IDC_FILTERUSER)->SetWindowText(GetResString(IDS_FILTERUSERS_DESC));
		GetDlgItem(IDC_FILTERUSER2)->SetWindowText(GetResString(IDS_LUSERS));
		GetDlgItem(IDC_FILTERFILE)->SetWindowText(GetResString(IDS_FILTERUSERS_DESC));
		GetDlgItem(IDC_FILTERFILE2)->SetWindowText(GetResString(IDS_FILES));
#ifdef ASFVII
		GetDlgItem(IDC_ASF_AUTOFILTER)->SetWindowText(GetResString(IDS_ASF_AUTOFILTER));
// By Taz - ASFv2
		GetDlgItem(IDC_ASF_ON)->SetWindowText(GetResString(IDS_ASF_ON));
		GetDlgItem(IDC_SERVERANALYZER_ON)->SetWindowText(GetResString(IDS_SERVERANALYZER_ON));
		GetDlgItem(IDC_ASF_AUTOFILTER)->SetWindowText(GetResString(IDS_ASF_AUTOFILTER));
// <------- ASFv2
#else
		GetDlgItem(IDC_FILTERSERVERBYIPFILTER)->SetWindowText(GetResString(IDS_FILTERSERVERBYIPFILTER));
		GetDlgItem(IDC_ASFMSG2)->SetWindowText(GetResString(IDS_ASFMSG2));
		GetDlgItem(IDC_ASFSTATIC0)->SetWindowText(GetResString(IDS_ASFSTATIC0));
		GetDlgItem(IDC_ASFSTATIC1)->SetWindowText(GetResString(IDS_ASFSTATIC1));
#endif
	}
}
#ifdef ASFVII
//Ackronic START - Links
void CPPgASF::OnBnClickedAckHelp()
{

// Contrib - fix
/*
TCHAR link[64];
_tcscpy (link, _T("http://www.ackronic.net/ackws/guida/helpack4.html"));

ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
void CPPgMOD2::OnBnClickedAckHelp3()
{
TCHAR link[64];
_tcscpy (link, _T("http://www.emulesecurity.net/"));
*/
TCHAR link[128];//Mulo da Soma - add more blanks in text-area
// gomez82 >>> changed Links
//_tcscpy (link, L"http://www.ackronic.net/ackws/smf/index.php?cat=105");//Mulo da Soma - now link points to new guide link
_tcscpy (link, L"http://www.emulesecurity.net/");
// gomez82 <<< changed Links
ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
void CPPgASF::OnBnClickedAckHelp2()
{
TCHAR link[128];//Add by Mulo da Soma - new text-area about 3 link-button
// gomez82 >>> changed Links
//_tcscpy (link, L"http://wiki.darkforge.eu/wiki/index.php?title=EMule_AcKroNiC_Wiki_ITA");//added by Mulo da Soma - restore 3 link-button pointing to AcKroNiC WiKi
_tcscpy (link, L"http://sourceforge.net/projects/zzulplus/");
// gomez82 <<< changed Links
ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
void CPPgASF::OnBnClickedAckHelp3()
{
TCHAR link[128];//Mulo da Soma - add more blanks in text-area
// gomez82 >>> changed Links
//_tcscpy (link, L"http://www.ackronic.net/ackws/smf/index.php?board=40.0");//changed by Mulo da Soma - now link points to AcKroNiC forum
_tcscpy (link, L"http://forum.emule-project.net/index.php?showtopic=138837");
// gomez82 <<< changed Links
// <-------- fix

ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
//Ackronic END - Links

// By Taz - ASFv2
void CPPgASF::OnBnClickedASF_ON(){
	GetDlgItem(IDC_ASF_AUTOFILTER)->EnableWindow(TRUE);
	CheckRadioButton(IDC_ASF_AUTOFILTER, IDC_SERVERANALYZER_ON, IDC_ASF_AUTOFILTER);
	m_iFilter = 0;
	OnSettingsChange();
}

void CPPgASF::OnBnClickedSERVERANALYZER_ON(){
	GetDlgItem(IDC_ASF_AUTOFILTER)->EnableWindow(FALSE);
	CheckRadioButton(IDC_ASF_AUTOFILTER, IDC_SERVERANALYZER_ON, IDC_ASF_AUTOFILTER + 1);
	m_iFilter = 1;
	OnSettingsChange();
}
// <------- ASFv2
#else
void CPPgASF::OnBnClickedAsfHelp()
{
TCHAR link[64];
_tcscpy (link, _T("http://www.emulesecurity.net/"));
//ShellExecute(NULL, NULL, link, NULL, thePrefs.GetAppDir(), SW_SHOWDEFAULT);
ShellExecute(NULL, NULL, link, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);
}
#endif