//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "SearchDlg.h"
#include "PPgMLOptions.h"
#include "DownloadQueue.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "TransferWnd.h"
#include "emuledlg.h"
#include "SharedFilesWnd.h"
#include "ServerWnd.h"
#include "Log.h"
#include "UserMsgs.h"
#include "opcodes.h"
#include "sharedfilelist.h" // PowerShare [ZZ/MorphXT] - Stulle
#include "UploadQueue.h"
#include "Neo\GUI\CP\TreeOptionsCtrl.h"
#include "Neo\gui\cp\TreeFunctions.h"
#include "MuleToolBarCtrl.h"
#include "Neo\defaults.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
// gomez82 >>> MM - [NeoMiniMule]
class CTreeOptionsSpinCtrl255 : public CTreeOptionsSpinCtrl
{
public:
	CTreeOptionsSpinCtrl255();
	virtual ~CTreeOptionsSpinCtrl255();

protected:
	virtual void GetDefaultRange(int &lower, int& upper);

	//{{AFX_VIRTUAL(CTreeOptionsSpinCtrl255)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CTreeOptionsSpinCtrl255)
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CTreeOptionsSpinCtrl255)
};

IMPLEMENT_DYNCREATE(CTreeOptionsSpinCtrl255, CTreeOptionsSpinCtrl)

CTreeOptionsSpinCtrl255::CTreeOptionsSpinCtrl255()
{
}

CTreeOptionsSpinCtrl255::~CTreeOptionsSpinCtrl255()
{
}

BEGIN_MESSAGE_MAP(CTreeOptionsSpinCtrl255, CTreeOptionsSpinCtrl)
	//{{AFX_MSG_MAP(CTreeOptionsSpinCtrl255)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CTreeOptionsSpinCtrl255::GetDefaultRange(int &lower, int& upper)
{
	lower = 0;
	upper = 255;
}
// gomez82 >>> MM END

// gomez82 >>> IM - [InvisibelMode]
class CInvisibelModeHotKeyModifier : public CTreeOptionsCombo
{
public:
	CInvisibelModeHotKeyModifier();
	virtual ~CInvisibelModeHotKeyModifier();

protected:
	//{{AFX_VIRTUAL(CInvisibelModeHotKeyModifier)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CInvisibelModeHotKeyModifier)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CInvisibelModeHotKeyModifier)
};


IMPLEMENT_DYNCREATE(CInvisibelModeHotKeyModifier, CTreeOptionsCombo)

CInvisibelModeHotKeyModifier::CInvisibelModeHotKeyModifier()
{
}

CInvisibelModeHotKeyModifier::~CInvisibelModeHotKeyModifier()
{
}

BEGIN_MESSAGE_MAP(CInvisibelModeHotKeyModifier, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CInvisibelModeHotKeyModifier)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CInvisibelModeHotKeyModifier::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
	AddString(GetResString(IDS_X_CTRLKEY));
	AddString(GetResString(IDS_X_ALTKEY));
	AddString(GetResString(IDS_X_SHIFTKEY));
	AddString(GetResString(IDS_X_CTRLKEY) + _T(" + ") + GetResString(IDS_X_ALTKEY));
	AddString(GetResString(IDS_X_CTRLKEY) + _T(" + ") + GetResString(IDS_X_SHIFTKEY));
	AddString(GetResString(IDS_X_ALTKEY) + _T(" + ") + GetResString(IDS_X_SHIFTKEY));
	AddString(GetResString(IDS_X_CTRLKEY) + _T(" + ") + GetResString(IDS_X_ALTKEY) + _T(" + ") + GetResString(IDS_X_SHIFTKEY));

	return 0;
}


class CInvisibelModeHotKey : public CTreeOptionsCombo
{
public:
	CInvisibelModeHotKey();
	virtual ~CInvisibelModeHotKey();

protected:
	//{{AFX_VIRTUAL(CInvisibelModeHotKey)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CInvisibelModeHotKey)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CInvisibelModeHotKey)
};


IMPLEMENT_DYNCREATE(CInvisibelModeHotKey, CTreeOptionsCombo)

CInvisibelModeHotKey::CInvisibelModeHotKey()
{
}

CInvisibelModeHotKey::~CInvisibelModeHotKey()
{
}

BEGIN_MESSAGE_MAP(CInvisibelModeHotKey, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CInvisibelModeHotKey)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CInvisibelModeHotKey::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
	for(int i='A'; i<='Z'; i++)
		AddString(CString((char)(i)));
	for(int i='0'; i<='9'; i++)
		AddString(CString((char)(i)));
	
	return 0;
}
// gomez82 >>> IM END

IMPLEMENT_DYNAMIC(CPPgMLOptions, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgMLOptions, CPropertyPage)
	ON_WM_HSCROLL()
	ON_WM_DESTROY()
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify) // gomez82 >>> FIX - [TreeControl] 
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
END_MESSAGE_MAP()

CPPgMLOptions::CPPgMLOptions()
	: CPropertyPage(CPPgMLOptions::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	m_bInitializedTreeOpts = false;
	SetNull();
	m_ctrlTreeOptions.SetNeoStyle();

}

CPPgMLOptions::~CPPgMLOptions(){}
void CPPgMLOptions::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ML_OPTS, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
		int iImgPlus = 8;	
		int iImgPS = 8;	
		int iImgCS = 8;	
		int iImgPush = 8;	
		//int iImgXUC  = 8;
		int iImgDisp  = 8;
		int iImgCommunity = 8;
		//int iImgAntiMod	= 8;
		int iImgMiniMule = 8;			// default icon
		int iImgHideOS = 8;				// gomez82 >>> HideOS
		int iImgReaskOnIDChange = 8;	// gomez82 >>> RIC - [ReaskOnIDChange]
		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgPlus			=	piml->Add(CTempIconLoader(_T("AAAEMULEAPP")));	
			iImgPS				=	piml->Add(CTempIconLoader(_T("PS")));
			iImgCS				=	piml->Add(CTempIconLoader(_T("CS")));
			iImgPush			=	piml->Add(CTempIconLoader(_T("SPEED")));
			//iImgXUC			=	piml->Add(CTempIconLoader(_T("SERVER")));
			iImgDisp			=	piml->Add(CTempIconLoader(_T("DISPLAY")));
			iImgCommunity		=	piml->Add(CTempIconLoader(_T("FRIEND"))); 
 			//iImgAntiMod		=	piml->Add(CTempIconLoader(_T("TRAYLOWID")));
            iImgMiniMule		=	piml->Add(CTempIconLoader(_T("MINIMULE")));
			iImgHideOS			=	piml->Add(CTempIconLoader(_T("FILEHIDEOS")));
			iImgReaskOnIDChange =	piml->Add(CTempIconLoader(_T("REASKONIDCHANGE"))); // gomez82 >>> RIC - [ReaskOnIDChange]
	}

// gomez82 >>> 
		//>>> CA
		SetTreeGroup(m_ctrlTreeOptions,m_htiCreditSystem,GetResString(IDS_USECREDITSYSTEM),iImgCS, TVI_ROOT, GetResString(IDS_USECREDITSYSTEM_INFO));
		SetTreeRadio(m_ctrlTreeOptions, m_htiCSNone, GetResString(IDS_CS_NONE), m_htiCreditSystem,  GetResString(IDS_CS_NONE_INFO), FALSE, m_bCreditSystem == 0);
		SetTreeRadio(m_ctrlTreeOptions, m_htiCSNone, GetResString(IDS_CS_OFFICIAL), m_htiCreditSystem,  GetResString(IDS_CS_OFFICIAL_INFO), FALSE, m_bCreditSystem == 1);
		SetTreeRadio(m_ctrlTreeOptions, m_htiCSNone, GetResString(IDS_CS_CLIENTANALYZER), m_htiCreditSystem,  GetResString(IDS_CS_CLIENTANALYZER_INFO), FALSE, m_bCreditSystem == 2);
		#ifdef CB_MOD_FINECS_ENABLED
		SetTreeRadio(m_ctrlTreeOptions, m_htiCSNone, GetResString(IDS_CS_FINECS), m_htiCreditSystem,  GetResString(IDS_CS_FINECS_INFO), FALSE, m_bCreditSystem == 3);
		#endif
		//<<< CA
		// gomez82 >>> No PS for Leecher

		SetTreeGroup(m_ctrlTreeOptions,m_htiNoPSGroup,GetResString(IDS_X_PS_TWEAKS),iImgPS, TVI_ROOT, GetResString(IDS_X_PS_TWEAKS_INFO));
		SetTreeCheck(m_ctrlTreeOptions,m_htiPSNT,GetResString(IDS_X_PS_NT),m_htiNoPSGroup,GetResString(IDS_X_PS_NT_INFO),FALSE,m_bPSNT); 
		SetTreeCheck(m_ctrlTreeOptions,m_htiPSMT,GetResString(IDS_X_PS_MT),m_htiNoPSGroup,GetResString(IDS_X_PS_MT_INFO),FALSE,m_bPSMT); 
		SetTreeCheck(m_ctrlTreeOptions,m_htiPSFF,GetResString(IDS_X_PS_FF),m_htiNoPSGroup,GetResString(IDS_X_PS_FF_INFO),FALSE,m_bPSFF); 
		SetTreeCheck(m_ctrlTreeOptions,m_htiPSXSSpam,GetResString(IDS_X_PS_XSSPAM),m_htiNoPSGroup,GetResString(IDS_X_PS_XSSPAM_INFO),FALSE,m_bPSXSSpam); 
		SetTreeCheck(m_ctrlTreeOptions,m_htiPSXSExpl,GetResString(IDS_X_PS_XSEXPL),m_htiNoPSGroup,GetResString(IDS_X_PS_XSEXPL_INFO),FALSE,m_bPSXSExpl); 
		// gomez82 >>> No PS for Leecher
		// HideOvershareMen
		SetTreeGroup(m_ctrlTreeOptions,m_htiPowerMenu,GetResString(IDS_X_HIDEOS),iImgHideOS, TVI_ROOT, GetResString(IDS_X_HIDEOSGROUP_INFO));
		// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle
		SetTreeCheck(m_ctrlTreeOptions,m_htiSpreadBars,GetResString(IDS_SPREAD_BARS),m_htiPowerMenu,GetResString(IDS_SPREADBAR_DEFAULT_CHECKBOX_TIP),FALSE,m_bSpreadBars); // gomez82 >>> NFS - [NeoScoreSystem]
		SetTreeNumEdit(m_ctrlTreeOptions,m_htiHideOS,GetResString(IDS_HIDEOVERSHARES),m_htiPowerMenu,GetResString(IDS_HIDEOVERSHARES_TIP));
		SetTreeCheck(m_ctrlTreeOptions,m_htiSelectiveShare,GetResString(IDS_SELECTIVESHARE),m_htiPowerMenu,GetResString(IDS_SELECTIVESHARE_TIP),FALSE,m_bSelectiveShare); // gomez82 >>> NFS - [NeoScoreSystem]
		SetTreeCheck(m_ctrlTreeOptions,m_htiShareOnlyTheNeed,GetResString(IDS_SHAREONLYTHENEED),m_htiPowerMenu,GetResString(IDS_SHAREONLYTHENEED_TIP),FALSE,m_iShareOnlyTheNeed); // gomez82 >>> NFS - [NeoScoreSystem]
		// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle
		//Display Group >>>
		SetTreeGroup(m_ctrlTreeOptions,m_htiDisp,GetResString(IDS_PW_DISPLAY),iImgDisp, TVI_ROOT, GetResString(IDS_X_PW_DISPLAY_INFO));
		SetTreeCheck(m_ctrlTreeOptions,m_htiNeoTreeStyle,GetResString(IDS_X_NEOTREESTYLE),m_htiDisp,GetResString(IDS_X_NEOTREESTYLE_INFO),FALSE,m_bNeoTreeStyle); // gomez82 >>> NTS - [NeoTreeStyle]
		// gomez82 >>> Colors
		SetTreeCheck(m_ctrlTreeOptions,m_htiCommunityColor,GetResString(IDS_X_COLOR_COMMUNITY),m_htiDisp,GetResString(IDS_X_COLOR_COMMUNITY_INFO),FALSE,m_bCommunityColor); 
		m_htiCommunityColorChoose = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_COLOR_EDIT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiCommunityColor);
		m_ctrlTreeOptions.AddColorSelector(m_htiCommunityColorChoose, RUNTIME_CLASS(CTreeOptionsBrowseButton));
		SetTreeCheck(m_ctrlTreeOptions,m_htiFriendColor,GetResString(IDS_X_COLOR_FRIEND),m_htiDisp,GetResString(IDS_X_COLOR_FRIEND_INFO),FALSE,m_bFriendColor); 
		m_htiFriendColorChoose = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_COLOR_EDIT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFriendColor);
		m_ctrlTreeOptions.AddColorSelector(m_htiFriendColorChoose, RUNTIME_CLASS(CTreeOptionsBrowseButton));
		SetTreeCheck(m_ctrlTreeOptions,m_htiFriendSlotColor,GetResString(IDS_X_COLOR_FRIENDSLOT),m_htiDisp,GetResString(IDS_X_COLOR_FRIENDSLOT_INFO),FALSE,m_bFriendSlotColor); 
		m_htiFriendSlotColorChoose = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_COLOR_EDIT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFriendSlotColor);
		m_ctrlTreeOptions.AddColorSelector(m_htiFriendSlotColorChoose, RUNTIME_CLASS(CTreeOptionsBrowseButton));
		SetTreeCheck(m_ctrlTreeOptions,m_htiPowerShareColor,GetResString(IDS_X_COLOR_POWERSHARE),m_htiDisp,GetResString(IDS_X_COLOR_POWERSHARE_INFO),FALSE,m_bPowerShareColor); 
		m_htiPowerShareColorChoose = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_COLOR_EDIT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiPowerShareColor);
		m_ctrlTreeOptions.AddColorSelector(m_htiPowerShareColorChoose, RUNTIME_CLASS(CTreeOptionsBrowseButton));
		// gomez82 <<< Colors
		SetTreeCheck(m_ctrlTreeOptions,m_htiStaticTrayIcon,GetResString(IDS_X_STATICTRAY),m_htiDisp,GetResString(IDS_X_STATICTRAY_INFO),FALSE,m_bStaticTrayIcon); // gomez82 >>> STI - [StaticTray]
		// gomez82 >>> SI - [SysInfo]
		SetTreeCheck(m_ctrlTreeOptions,m_htiDrawSysInfoGraph,GetResString(IDS_X_USE_SYS_INFO),m_htiDisp,GetResString(IDS_X_USE_SYS_INFO_INFO),FALSE,m_bDrawSysInfoGraph);
		SetTreeCheck(m_ctrlTreeOptions,m_htiShowSysInfoOnTitle,GetResString(IDS_X_USE_SYS_INFO_TITLE),m_htiDisp,GetResString(IDS_X_USE_SYS_INFO_TITLE_INFO),FALSE,m_bShowSysInfoOnTitle);
		// gomez82 >>> SI END	
		// gomez82 >>> MM - [NeoMiniMule]
		SetTreeGroup(m_ctrlTreeOptions,m_htiMiniMule,GetResString(IDS_X_MINIMULE_PREF),iImgMiniMule, m_htiDisp, GetResString(IDS_X_MINIMULE_PREF_INFO));
		SetTreeCheck(m_ctrlTreeOptions,m_htiAutoShowMiniMule,GetResString(IDS_X_AUTO_MINIMULE),m_htiMiniMule,GetResString(IDS_X_AUTO_MINIMULE_INFO),FALSE,m_bAutoShowMiniMule);
		SetTreeCheck(m_ctrlTreeOptions,m_htiUpdateHidenMiniMule,GetResString(IDS_X_UDATE_HIDEN_MINIMULE),m_htiMiniMule,GetResString(IDS_X_UDATE_HIDEN_MINIMULE_INFO),FALSE,m_bUpdateHidenMiniMule);
		SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiMiniMuleTransparency,GetResString(IDS_X_MINIMULE_TRANSPARENCY),m_htiMiniMule,GetResString(IDS_X_MINIMULE_TRANSPARENCY_INFO),FALSE, m_iMiniMuleTransparency);
		// gomez82 >>> MM END	
		// gomez82 >>> IM - [InvisibelMode]
		SetTreeCheck(m_ctrlTreeOptions,m_htiInvisibelMode,GetResString(IDS_X_INVISIBLE_MODE),m_htiDisp,GetResString(IDS_X_INVISIBLE_MODE_INFO),FALSE,m_bAutoShowMiniMule);
		m_htiInvisibelModeHotKeyModifier = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_INVISIBLE_KEY_MOD), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiInvisibelMode);
		m_ctrlTreeOptions.AddComboBox(m_htiInvisibelModeHotKeyModifier,RUNTIME_CLASS(CInvisibelModeHotKeyModifier));
		m_ctrlTreeOptions.SetItemSize(m_htiInvisibelModeHotKeyModifier,15);
		m_ctrlTreeOptions.SetItemInfo(m_htiInvisibelModeHotKeyModifier,GetResString(IDS_X_INVISIBLE_KEY_MOD_INFO));
		m_htiInvisibelModeHotKey = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_INVISIBLE_KEY), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiInvisibelMode);
		m_ctrlTreeOptions.AddComboBox(m_htiInvisibelModeHotKey,RUNTIME_CLASS(CInvisibelModeHotKey));
		m_ctrlTreeOptions.SetItemSize(m_htiInvisibelModeHotKey,5);
		m_ctrlTreeOptions.SetItemInfo(m_htiInvisibelModeHotKey,GetResString(IDS_X_INVISIBLE_KEY_INFO));
		// gomez82 >>> IM ENDEnable Disable Community Visualisation here
		SetTreeCheck(m_ctrlTreeOptions,m_htiUsePlusSpeedMeter,GetResString(IDS_X_PLUS_METER),TVI_ROOT,GetResString(IDS_X_PLUS_METER_INFO),FALSE,m_bUsePlusSpeedMeter); // gomez82 >>> PSM - [PlusSpeedMeter]
		SetTreeGroup(m_ctrlTreeOptions,m_htiCommunityOptions, GetResString(IDS_X_COMMUNITYGROUP),iImgPush, TVI_ROOT,  GetResString(IDS_X_COMMUNITYGROUP_INFO));

		// gomez82 >>> Community visualization
		SetTreeCheckEdit(m_ctrlTreeOptions, m_htiCommunity, GetResString(IDS_X_COMMUNITYTAGS),  m_htiCommunityOptions, GetResString(IDS_COMMUNITY_TIP), FALSE, m_bCommunity);
		// gomez82 >>> PRSF - [PushSmallRareFiles]
		SetTreeGroup(m_ctrlTreeOptions,m_htiFilePushTweaks,GetResString(IDS_X_PUSH_GROUP),iImgPush, TVI_ROOT, GetResString(IDS_X_PUSH_SMALL_RARE_FILES_INFO));
		SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiPushSmallFiles,GetResString(IDS_X_PUSH_SMALL_FILES), m_htiFilePushTweaks, GetResString(IDS_X_PUSH_SMALL_FILES_INFO),FALSE, m_bPushSmallFiles);
		SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiPushRareFiles,GetResString(IDS_X_PUSH_RARE_FILES), m_htiFilePushTweaks, GetResString(IDS_X_PUSH_RARE_FILES_INFO),FALSE, m_bPushRareFiles);
		SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiPushRatioFiles,GetResString(IDS_X_PUSH_RATIO_FILES), m_htiFilePushTweaks, GetResString(IDS_X_PUSH_RATIO_FILES_INFO),FALSE, m_bPushRatioFiles);
		// gomez82 >>> PRSF END		
		SetTreeCheck(m_ctrlTreeOptions,m_htiL2HAC, GetResString(IDS_X_L2HAC),TVI_ROOT, GetResString(IDS_X_L2HAC_INFO),FALSE,m_bL2HAC); // L2HAC
		SetTreeCheck(m_ctrlTreeOptions,m_htiNeoScoreSystem,GetResString(IDS_X_NEO_SCORE_SYSTEM),TVI_ROOT,GetResString(IDS_X_NEO_SCORE_SYSTEM_INFO),FALSE,m_bNeoScoreSystem); // gomez82 >>> NFS - [NeoScoreSystem]
		// gomez82 >>> RIC - [ReaskOnIDChange]
		SetTreeGroup(m_ctrlTreeOptions,m_htiOnIDChange,GetResString(IDS_X_ON_ID_CHANGE),iImgReaskOnIDChange, TVI_ROOT, GetResString(IDS_X_ON_ID_CHANGE_INFO));
		SetTreeCheck(m_ctrlTreeOptions,m_htiCheckIPChange,GetResString(IDS_X_CHECK_ID_CHANGES),m_htiOnIDChange,GetResString(IDS_X_CHECK_ID_CHANGES_INFO),TRUE,m_uCheckIPChange);

		// gomez82 >>> RIC END
		m_ctrlTreeOptions.SetItemEnable(m_htiMiniMuleTransparency, m_iMiniMuleTransparency,TRUE,TRUE); // gomez82 >>> MM - [NeoMiniMule]

		// gomez82 >>> IM - [InvisibelMode]
		m_ctrlTreeOptions.SetItemEnable(m_htiInvisibelModeHotKeyModifier, m_bInvisibleMode);
		m_ctrlTreeOptions.SetItemEnable(m_htiInvisibelModeHotKey, m_bInvisibleMode);
		// gomez82 >>> IM END

		m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
        m_bInitializedTreeOpts = true;
	}
	DDX_TreeRadio(pDX, IDC_ML_OPTS, m_htiCreditSystem, m_bCreditSystem); //>>> CA

	// gomez82 >>> No PS for Leecher
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPSNT, m_bPSNT);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPSMT, m_bPSMT);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPSFF, m_bPSFF);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPSXSSpam, m_bPSXSSpam);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPSXSExpl, m_bPSXSExpl);
	// gomez82 >>> No PS for Leecher
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiSpreadBars, m_bSpreadBars); // Spread bars [Slugfiller/MorphXT] - Stulle
	// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle
	DDX_TreeEdit(pDX, IDC_ML_OPTS, m_htiHideOS, m_iHideOS);
	DDV_MinMaxInt(pDX, m_iHideOS, 0, INT_MAX);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiSelectiveShare, m_bSelectiveShare);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiShareOnlyTheNeed, m_iShareOnlyTheNeed);
	// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiNeoScoreSystem, m_bNeoScoreSystem); // gomez82 >>> NFS - [NeoScoreSystem]
	// gomez82 >>< Colors
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiCommunityColor, m_bCommunityColor); //2BC+ Community-Orange
	DDX_TreeColor(pDX, IDC_ML_OPTS, m_htiCommunityColorChoose, m_crCommunity);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiFriendColor, m_bFriendColor); 
	DDX_TreeColor(pDX, IDC_ML_OPTS, m_htiFriendColorChoose, m_crFriend);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiFriendSlotColor, m_bFriendSlotColor);
	DDX_TreeColor(pDX, IDC_ML_OPTS, m_htiFriendSlotColorChoose, m_crFriendSlot);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPowerShareColor, m_bPowerShareColor); 
	DDX_TreeColor(pDX, IDC_ML_OPTS, m_htiPowerShareColorChoose, m_crPowerShare);

	// gomez82 <<< Colors
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiNeoTreeStyle, m_bNeoTreeStyle);
	// gomez82 >>> Community visualization
	// gomez82 >>>
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiCommunity, m_bCommunity); //Community on-off
	DDX_TreeEdit(pDX, IDC_ML_OPTS, m_htiCommunity, m_sCommunityName);
	// gomez82 >>> PRSF - [PushSmallRareFiles]
	DDX_TreeEdit(pDX, IDC_ML_OPTS, m_htiPushSmallFiles, m_iPushSmallFilesSize);
	DDV_MinMaxInt(pDX, m_iPushSmallFilesSize, 180, 18432);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPushSmallFiles, m_bPushSmallFiles);
	DDX_TreeEdit(pDX, IDC_ML_OPTS, m_htiPushRareFiles, m_iPushRareFilesValue);
	DDV_MinMaxInt(pDX, m_iPushRareFilesValue, 4, 25);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPushRareFiles, m_bPushRareFiles);
	DDX_TreeEdit(pDX, IDC_ML_OPTS, m_htiPushRatioFiles, m_iPushRatioFilesValue);
	DDV_MinMaxInt(pDX, m_iPushRatioFilesValue, 2, 20);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiPushRatioFiles, m_bPushRatioFiles);
		// gomez82 >>> PRSF END

	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiL2HAC, m_bL2HAC);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiStaticTrayIcon,m_bStaticTrayIcon); // gomez82 >>> STI - [StaticTray]
	// gomez82 >>> SI - [SysInfo]
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiDrawSysInfoGraph,m_bDrawSysInfoGraph);
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiShowSysInfoOnTitle,m_bShowSysInfoOnTitle);
	// gomez82 >>> SI END	
	// gomez82 >>> MM - [NeoMiniMule]
	DDX_TreeCheck(pDX, IDC_ML_OPTS,m_htiAutoShowMiniMule,m_bAutoShowMiniMule);
	DDX_TreeCheck(pDX, IDC_ML_OPTS,m_htiUpdateHidenMiniMule,m_bUpdateHidenMiniMule);
	DDX_TreeEdit(pDX, IDC_ML_OPTS, m_htiMiniMuleTransparency, m_iMiniMuleTransparency);
	bool bMiniMuleTransparency = I2B(m_iMiniMuleTransparency);
	DDX_TreeCheck(pDX, IDC_ML_OPTS,m_htiMiniMuleTransparency,bMiniMuleTransparency);
	if(!bMiniMuleTransparency)
		m_iMiniMuleTransparency = 0;
	else if(!m_iMiniMuleTransparency)
		m_iMiniMuleTransparency = 64;
	// gomez82 >>> MM END
	// gomez82 >>> IM - [InvisibelMode]
	DDX_TreeCheck(pDX, IDC_ML_OPTS,m_htiInvisibelMode,m_bInvisibleMode);
	if (pDX->m_bSaveAndValidate)
	{
		CString sKeyMod;
		sKeyMod = m_ctrlTreeOptions.GetComboText(m_htiInvisibelModeHotKeyModifier);

		m_iInvisibleModeHotKeyModifier = 0;
		if (sKeyMod.Find(GetResString(IDS_X_CTRLKEY))!=-1)
			m_iInvisibleModeHotKeyModifier |= MOD_CONTROL;
		if (sKeyMod.Find(GetResString(IDS_X_ALTKEY))!=-1)
			m_iInvisibleModeHotKeyModifier |= MOD_ALT;
		if (sKeyMod.Find(GetResString(IDS_X_SHIFTKEY))!=-1)
			m_iInvisibleModeHotKeyModifier |= MOD_SHIFT;

		CString sKey;
		sKey = m_ctrlTreeOptions.GetComboText(m_htiInvisibelModeHotKey);

		m_cInvisibleModeHotKey = sKey[0];
	}
	else
	{
		m_ctrlTreeOptions.SetComboText(m_htiInvisibelModeHotKey,CString(m_cInvisibleModeHotKey));

		CString sKeyMod;
		bool bPlus = false;

		if(m_iInvisibleModeHotKeyModifier & MOD_CONTROL){
			sKeyMod.Format(GetResString(IDS_X_CTRLKEY));
			bPlus = true;
		}
		if(m_iInvisibleModeHotKeyModifier & MOD_ALT){
			if(bPlus)
				sKeyMod.Append(_T(" + "));
			sKeyMod.Append(GetResString(IDS_X_ALTKEY));
			bPlus = true;
		}
		if(m_iInvisibleModeHotKeyModifier & MOD_SHIFT){
			if(bPlus)
				sKeyMod.Append(_T(" + "));
			sKeyMod.Append(GetResString(IDS_X_SHIFTKEY));
			bPlus = true;
		}

		m_ctrlTreeOptions.SetComboText(m_htiInvisibelModeHotKeyModifier,sKeyMod);

		m_ctrlTreeOptions.SetComboText(m_htiInvisibelModeHotKey,CString(m_cInvisibleModeHotKey));
	}
	// gomez82 >>> IM END
	DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiUsePlusSpeedMeter,m_bUsePlusSpeedMeter); // gomez82 >>> PSM - [PlusSpeedMeter]
		// gomez82 >>> RIC - [ReaskOnIDChange]
		DDX_TreeCheck(pDX, IDC_ML_OPTS, m_htiCheckIPChange, m_uCheckIPChange);

		// gomez82 >>> RIC END
	
}

BOOL CPPgMLOptions::OnInitDialog()
{
	LoadSettings();

//	m_ctrlTreeOptions.SetImageListColorFlags(theApp.m_iDfltImageListColorFlags);
    CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	m_ctrlTreeOptions.SetItemHeight(m_ctrlTreeOptions.GetItemHeight() + 2);

	Localize();
	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}
void CPPgMLOptions::Localize(void)
{
	if (m_hWnd)
	{
	if (m_htiCreditSystem) m_ctrlTreeOptions.SetItemText(m_htiCreditSystem, GetResString(IDS_USECREDITSYSTEM));

	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	}
}
BOOL CPPgMLOptions::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

BOOL CPPgMLOptions::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();


	if (!UpdateData())
		return FALSE;
	// gomez82 >>>
	thePrefs.SetCreditSystem((uint8)m_bCreditSystem); //>>> CA

	// gomez82 >>> No PS for Leecher
	thePrefs.SetPSNT(m_bPSNT); 
	thePrefs.SetPSMT(m_bPSMT); 
	thePrefs.SetPSFF(m_bPSFF); 
	thePrefs.SetPSXSSpam(m_bPSXSSpam); 
	thePrefs.SetPSXSExpl(m_bPSXSExpl); 	
	// gomez82 >>> No PS for Leecher
	thePrefs.m_bSpreadbarSetStatus = m_bSpreadBars; // Spread bars [Slugfiller/MorphXT] - Stulle
	// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle
	thePrefs.hideOS = m_iHideOS;
	thePrefs.selectiveShare = m_bSelectiveShare;
	thePrefs.ShareOnlyTheNeed = m_iShareOnlyTheNeed!=0;
	// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle
	thePrefs.m_bNeoScoreSystem = m_bNeoScoreSystem; // gomez82 >>> NFS - [NeoScoreSystem]

	// gomez82 >>> PRSF - [PushSmallRareFiles]
	thePrefs.m_bPushSmallFiles = m_bPushSmallFiles;
	thePrefs.m_iPushSmallFilesSize = m_iPushSmallFilesSize;
	thePrefs.m_bPushRareFiles = m_bPushRareFiles;
	thePrefs.m_iPushRareFilesValue = m_iPushRareFilesValue;
	thePrefs.m_bPushRatioFiles = m_bPushRatioFiles;
	thePrefs.m_iPushRatioFilesValue = m_iPushRatioFilesValue;
		// gomez82 >>> PRSF END
	thePrefs.m_bUseTreeStyle = m_bNeoTreeStyle;
	// gomez82 >>> MM - [NeoMiniMule]
	thePrefs.m_bAutoShowMiniMule = m_bAutoShowMiniMule;
	thePrefs.m_bUpdateHidenMiniMule = m_bUpdateHidenMiniMule;
	thePrefs.m_uMiniMuleTransparency = (uint8)m_iMiniMuleTransparency;
	// gomez82 >>> MM END
	thePrefs.SetInvisibleMode(m_bInvisibleMode,m_iInvisibleModeHotKeyModifier,m_cInvisibleModeHotKey); // gomez82 >>> IM - [InvisibelMode]

	thePrefs.m_bL2HAC = m_bL2HAC;	

	// gomez82 >>> PSM - [PlusSpeedMeter]
	thePrefs.m_bUsePlusSpeedMeter = m_bUsePlusSpeedMeter;
	theApp.emuledlg->toolbar->ShowSpeedMeter(thePrefs.UsePlusSpeedMeter()); 
	// gomez82 >>> PSM END
	thePrefs.m_bStaticTrayIcon = m_bStaticTrayIcon; // gomez82 >>> STI - [StaticTray]

	// gomez82 >>> RIC - [ReaskOnIDChange]
	thePrefs.m_uireaskSourceAfterIPChange = m_uCheckIPChange;

	// gomez82 >>> RIC END
	// gomez82 >>> SI - [SysInfo]
	thePrefs.m_bDrawSysInfoGraph = m_bDrawSysInfoGraph;
	thePrefs.m_bShowSysInfoOnTitle = m_bShowSysInfoOnTitle;
	// gomez82 >>> SI END

	thePrefs.SetCommunityName(m_sCommunityName);
thePrefs.SetCommunity(m_bCommunity); //Community on-off

	// gomez82 >>> Colors
	thePrefs.m_bCommunityColor = m_bCommunityColor; //2BC+ Community-Orange
	thePrefs.m_crCommunity = m_crCommunity;
	thePrefs.m_bFriendColor = m_bFriendColor;
	thePrefs.m_crFriend = m_crFriend;
	thePrefs.m_bFriendSlotColor = m_bFriendSlotColor;
	thePrefs.m_crFriendSlot = m_crFriendSlot;
	thePrefs.m_bPowerShareColor = m_bPowerShareColor;
	thePrefs.m_crPowerShare = m_crPowerShare;
	// gomez82 <<< Colors

	SetModified(FALSE);
	theApp.emuledlg->toolbar->ShowSpeedMeter(thePrefs.UsePlusSpeedMeter()); // gomez82 >>> PSM - [PlusSpeedMeter]

	// gomez82 >>> STI - [StaticTray]
	if(thePrefs.UseStaticTrayIcon()) 
		theApp.emuledlg->TrayShow(true);
	// gomez82 >>> MOD END
	return CPropertyPage::OnApply();
}

void CPPgMLOptions::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	SetNull();
    
    CPropertyPage::OnDestroy();
}

LRESULT CPPgMLOptions::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_ML_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){
			// gomez82 >>> MM - [NeoMiniMule]
			if(m_htiMiniMuleTransparency && pton->hItem == m_htiMiniMuleTransparency){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMiniMuleTransparency, 0, 128, 255)) SetModified();
			}
			// gomez82 >>> MM END	
		}else if(pton->nmhdr.code == BN_CLICKED){
		UINT bCheck;
			// gomez82 >>> MM - [NeoMiniMule]
			if(m_htiMiniMuleTransparency && pton->hItem == m_htiMiniMuleTransparency){
				m_ctrlTreeOptions.GetCheckBox(m_htiMiniMuleTransparency, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiMiniMuleTransparency, bCheck,TRUE,TRUE);
				if(bCheck){
					if(m_ctrlTreeOptions.GetEditText(m_htiMiniMuleTransparency).IsEmpty())
						m_ctrlTreeOptions.SetEditText(m_htiMiniMuleTransparency,_T("128"));
				}
			}
			// gomez82 >>> MM END
			else
			// gomez82 >>> IM - [InvisibelMode]
			 if(m_htiInvisibelMode && pton->hItem == m_htiInvisibelMode){
				m_ctrlTreeOptions.GetCheckBox(m_htiInvisibelMode, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiInvisibelModeHotKeyModifier, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiInvisibelModeHotKey, bCheck);
			}
			// gomez82 >>> IM END
			 else
			// gomez82 >>> RIC - [ReaskOnIDChange]
			 if (m_htiCheckIPChange && pton->hItem == m_htiCheckIPChange){
				m_ctrlTreeOptions.GetCheckBox(m_htiCheckIPChange, bCheck);
			}
			// gomez82 >>> RIC END
			SetModified();
		}else{
			SetModified();
		}
	}
	return 0;
}
void CPPgMLOptions::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified();

	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}
void CPPgMLOptions::LoadSettings()
{
	CString strBuffer;

	m_bCreditSystem = thePrefs.UseCreditSystem(); //>>> CA

	// gomez82 >>> No PS for Leecher
	m_bPSNT = thePrefs.GetPSNT();
	m_bPSMT = thePrefs.GetPSMT();
	m_bPSFF = thePrefs.GetPSFF();
	m_bPSXSExpl = thePrefs.GetPSXSExpl();
	m_bPSXSSpam = thePrefs.GetPSXSSpam();
	// gomez82 >>> No PS for Leecher

	m_bUsePlusSpeedMeter = thePrefs.m_bUsePlusSpeedMeter; // gomez82 >>> PSM - [PlusSpeedMeter]
	m_bStaticTrayIcon = thePrefs.m_bStaticTrayIcon; // gomez82 >>> STI - [StaticTray]
	m_bNeoTreeStyle = thePrefs.UseTreeStyle();

	// gomez82
	m_bSpreadBars = thePrefs.GetSpreadbarSetStatus(); // Spread bars [Slugfiller/MorphXT] - Stulle
	m_crCommunity = thePrefs.m_crCommunity;
	m_crFriend = thePrefs.m_crFriend;
	m_crFriendSlot = thePrefs.m_crFriendSlot;
	m_crPowerShare = thePrefs.m_crPowerShare;

	// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle
	m_iHideOS = thePrefs.hideOS;
	m_bSelectiveShare = thePrefs.selectiveShare;
	m_iShareOnlyTheNeed = thePrefs.ShareOnlyTheNeed;
	// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle


	m_bL2HAC= thePrefs.m_bL2HAC;		
	// gomez82 >>> Community visualization
	m_sCommunityName = thePrefs.GetCommunityName();
	// gomez82 >>>
	m_bCommunity = thePrefs.GetCommunity(); //Community on-off
	// gomez82 >>> Colors
	m_bCommunityColor = thePrefs.GetCommunityColor(); //2BC+ Community-Orange
	m_bFriendColor = thePrefs.GetFriendColor();
	m_bFriendSlotColor = thePrefs.GetFriendSlotColor();
	m_bPowerShareColor = thePrefs.GetPowerShareColor();
	// gomez82 <<< Colors
	m_bUsePlusSpeedMeter = thePrefs.m_bUsePlusSpeedMeter; // gomez82 >>> PSM - [PlusSpeedMeter]
	m_bStaticTrayIcon = thePrefs.m_bStaticTrayIcon; // gomez82 >>> STI - [StaticTray]
	// gomez82 >>> SI - [SysInfo]
	m_bDrawSysInfoGraph = thePrefs.m_bDrawSysInfoGraph;
	m_bShowSysInfoOnTitle = thePrefs.m_bShowSysInfoOnTitle;
	// gomez82 >>> SI END
	// gomez82 >>> MM - [NeoMiniMule]
	m_bAutoShowMiniMule = thePrefs.m_bAutoShowMiniMule;
	m_bUpdateHidenMiniMule = thePrefs.m_bUpdateHidenMiniMule;
	m_iMiniMuleTransparency = thePrefs.m_uMiniMuleTransparency;
	// gomez82 >>> MM END
	// gomez82 >>> IM - [InvisibelMode]
	m_bInvisibleMode = thePrefs.m_bInvisibleMode;		
	m_iInvisibleModeHotKeyModifier = thePrefs.m_iInvisibleModeHotKeyModifier;
	m_cInvisibleModeHotKey = thePrefs.m_cInvisibleModeHotKey;
	// gomez82 >>> IM END
	// gomez82 >>> RIC - [ReaskOnIDChange]
	m_uCheckIPChange = thePrefs.m_uireaskSourceAfterIPChange;

	// gomez82 >>> RIC END
		m_bNeoScoreSystem = thePrefs.m_bNeoScoreSystem; // gomez82 >>> NFS - [NeoScoreSystem]

		// gomez82 >>> PRSF - [PushSmallRareFiles]
		m_bPushSmallFiles = thePrefs.m_bPushSmallFiles;
		m_iPushSmallFilesSize = thePrefs.m_iPushSmallFilesSize;

		m_bPushRareFiles = thePrefs.m_bPushRareFiles;
		m_iPushRareFilesValue = thePrefs.m_iPushRareFilesValue;

		m_bPushRatioFiles = thePrefs.m_bPushRatioFiles;
		m_iPushRatioFilesValue = thePrefs.m_iPushRatioFilesValue;
		// gomez82 >>> PRSF END


}
BOOL CPPgMLOptions::OnCommand(WPARAM wParam, LPARAM lParam){return __super::OnCommand(wParam, lParam);}

void CPPgMLOptions::SetNull(){
	
	m_htiCreditSystem = NULL;
	
	//>>> CA
	m_htiCSNone = NULL;
	m_htiCSOffi = NULL;
	m_htiCSAnalyzer = NULL;
	//<<< CA
	m_htiCSFine = NULL;

	// gomez82 >>> No PS for Leecher
	m_htiNoPSGroup = NULL;
	m_htiPSNT =  NULL;
	m_htiPSMT =  NULL;
	m_htiPSFF =  NULL;
	m_htiPSXSExpl =  NULL;
	m_htiPSXSSpam =  NULL;
	// gomez82 >>> No PS for Leecher

	m_htiNeoScoreSystem = NULL; // gomez82 >>> NFS - [NeoScoreSystem]

	// gomez82 >>> Colors
	m_htiCommunityColor = NULL; 
	m_htiFriendColor = NULL; 
	m_htiFriendSlotColor = NULL; 
	m_htiPowerShareColor = NULL; 
	m_htiCommunityColorChoose = NULL; 
	m_htiFriendColorChoose = NULL; 
	m_htiFriendSlotColorChoose = NULL; 
	m_htiPowerShareColorChoose = NULL; 
	// gomez82 <<< Colors

	m_htiSpreadBars = NULL; // Spread bars [Slugfiller/MorphXT] - Stulle

	// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle
	m_htiHideOS = NULL;
	m_htiSelectiveShare = NULL;
	m_htiShareOnlyTheNeed = NULL;
	// gomez82 >>> HideOS & SOTN [Slugfiller/ MorphXT] - Stulle

	// gomez82 >>> MM - [NeoMiniMule]
	m_htiMiniMule = NULL;
	m_htiAutoShowMiniMule = NULL;
	m_htiUpdateHidenMiniMule = NULL;
	m_htiMiniMuleTransparency = NULL;
	// gomez82 >>> MM END

	// gomez82 >>> IM - [InvisibelMode]
	m_htiInvisibelMode = NULL;
	m_htiInvisibelModeHotKeyModifier = NULL;
	m_htiInvisibelModeHotKey = NULL;
	// gomez82 >>> IM END

	m_htiNeoTreeStyle = NULL;

	m_htiUsePlusSpeedMeter = NULL; // gomez82 >>> PSM - [PlusSpeedMeter]

	m_htiStaticTrayIcon = NULL; // gomez82 >>> STI - [StaticTray]

	// gomez82 >>> PRSF - [PushSmallRareFiles]
	m_htiFilePushTweaks = NULL;
	m_htiPushSmallFiles = NULL;
	m_htiPushRareFiles = NULL;
	m_htiPushRatioFiles = NULL;
	// gomez82 >>> PRSF END

	m_htiL2HAC = NULL;

	// gomez82 >>> SI - [SysInfo]
	m_htiDrawSysInfoGraph = NULL;
	m_htiShowSysInfoOnTitle = NULL;
	// gomez82 >>> SI END

	m_htiUsePlusSpeedMeter = NULL; // gomez82 >>> PSM - [PlusSpeedMeter]

	m_htiDisp = NULL;

	m_htiCommunityName = NULL;

	// gomez82 >>> RIC - [ReaskOnIDChange]
	m_htiOnIDChange = NULL; 
	m_htiCheckIPChange = NULL;



}
LRESULT CPPgMLOptions::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_ML_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_ML_OPTS_INFO, *sInfo);
	}
	return FALSE;
}