/** @file		NetF_NoCast.h
 *  @brief	Templates to prevent compiler from doing automatic typecasting
 *  @author	netfinity
 */
#pragma once

template <class _T>
class NOCAST
{
public:
	NOCAST(_T& x) : m_x(x) {};
	operator _T& () {return m_x;}
private:
	_T	m_x;
};

template <class _T>
class ONLY_INT
{
public:
	ONLY_INT(const int& x) : m_x(x) {};
	ONLY_INT(const unsigned int& x) : m_x(x) {};
	ONLY_INT(const char& x) : m_x(x) {};
	ONLY_INT(const unsigned char& x) : m_x(x) {};
	ONLY_INT(const short& x) : m_x(x) {};
	ONLY_INT(const unsigned short& x) : m_x(x) {};
	ONLY_INT(const long& x) : m_x(x) {};
	ONLY_INT(const unsigned long& x) : m_x(x) {};
	ONLY_INT(const long long& x) : m_x(x) {};
	ONLY_INT(const unsigned long long& x) : m_x(x) {};
	operator _T& () {return m_x;}
private:
	_T	m_x;
};

template <class _T>
class ONLY_FLOAT
{
public:
	ONLY_FLOAT(const float& x) : m_x(x) {};
	ONLY_FLOAT(const double& x) : m_x(x) {};
	operator _T& () {return m_x;}
private:
	_T	m_x;
};

template <class _T>
class ONLY_NUM
{
public:
	ONLY_NUM(const int& x) : m_x(x) {};
	ONLY_NUM(const unsigned int& x) : m_x(x) {};
	ONLY_NUM(const char& x) : m_x(x) {};
	ONLY_NUM(const unsigned char& x) : m_x(x) {};
	ONLY_NUM(const short& x) : m_x(x) {};
	ONLY_NUM(const unsigned short& x) : m_x(x) {};
	ONLY_NUM(const long& x) : m_x(x) {};
	ONLY_NUM(const unsigned long& x) : m_x(x) {};
	ONLY_NUM(const long long& x) : m_x(x) {};
	ONLY_NUM(const unsigned long long& x) : m_x(x) {};
	ONLY_NUM(const float& x) : m_x(x) {};
	ONLY_NUM(const double& x) : m_x(x) {};
	operator _T& () {return m_x;}
private:
	_T	m_x;
};

