#pragma once
class Kademlia::CContact;
// BEGIN netfinity: Safe KAD - Ensure we are actually searching for these nodes
class Kademlia::CUInt128;
// END netfinity: Safe KAD

//>>> WiZaRd::Kad Security
#define _KAD_CHECK_EQUAL		0
#define _KAD_CHECK_BIGGER		1
#define _KAD_CHECK_SMALLER		2

//>>> WiZaRd::Kad Security
// the current implementation can and should be enhanced with more checks for 
// packets size to track down "bad" users/clients and shut them off the network
// these checks are a first step...
void _CheckPacketLength(LPCSTR func, const UINT uLenPacket, const UINT desired, const uint8 type);
void _CheckMessageBounce(LPCSTR func, const UINT uLenPacket, const UINT uIP, const uint16 uUDPPort, const uint8 byOpcode, const bool bDontRemove = false);
void _CheckPacketTracking(LPCSTR func, const UINT uLenPacket, const UINT uIP, const uint16 uUDPPort, const uint8 byOpcode, const bool bDontRemove = false);

//check whether additional bytes are in a packet
void _CheckPacketPos(LPCSTR func, const uint64& pos, const uint64& uLenPacket);
void _CheckPacketPos(LPCSTR func, const uint64& add);
//<<< WiZaRd::Kad Security
// BEGIN netfinity: Safe KAD - Ensure we are actually searching for these nodes
void _CheckForValidTarget(LPCSTR func, const Kademlia::CUInt128& uTarget);
// END netfinity: Safe KAD
//Check if a number appears to be constructed rather than randomly generated
bool IsGoodRandom(const Kademlia::CUInt128& ui);
void SetGoodRandom(Kademlia::CUInt128& ui);
// END netfinity: Safe KAD
