// webtool.cpp : implementation of the CWebTool class
//
#include "stdafx.h"
#include "emule.h"
#ifdef MOD_FUNCTIONS
#include "emuledlg.h"
#include "WebTool.h"
#include "./AntiLeech/ModName.h"
#include "WebBrowser.h" 
#include "Preferences.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#endif

IMPLEMENT_DYNAMIC(CWebTool, CDialog)
BEGIN_MESSAGE_MAP(CWebTool, CDialog)
	ON_BN_CLICKED(IDC_BACK, OnBnClickedBack)
	ON_BN_CLICKED(IDC_FORWARD, OnBnClickedNext)
	ON_BN_CLICKED(IDC_STOP, OnBnClickedStop)
	ON_BN_CLICKED(IDC_REFRESH, OnBnClickedRefresh)
	ON_BN_CLICKED(IDC_GOHOME, OnBnClickedGoHome)
	ON_WM_SIZE()
END_MESSAGE_MAP()

CWebTool::CWebTool(CHtmlView* pBrowserWnd, CWnd* pParent /*=NULL*/)
	: CDialog(CWebTool::IDD, pParent)
{
	m_pBrowserWnd = pBrowserWnd;
}

CWebTool::~CWebTool()
{
}

void CWebTool::DoDataExchange(CDataExchange* pDX)
{
	DDX_Control(pDX, IDC_BACK, m_ButtonBack);
	DDX_Control(pDX, IDC_FORWARD, m_ButtonNext);
	DDX_Control(pDX, IDC_STOP, m_ButtonStop);
	DDX_Control(pDX, IDC_REFRESH, m_ButtonRefresh);
	DDX_Control(pDX, IDC_GOHOME, m_ButtonGoHome);
	CDialog::DoDataExchange(pDX);
}

void CWebTool::OnBnClickedBack()
{
	/*theApp.emuledlg->*/m_pBrowserWnd->GoBack();
}

void CWebTool::OnBnClickedNext()
{
	/*theApp.emuledlg->*/m_pBrowserWnd->GoForward();
}

void CWebTool::OnBnClickedStop()
{
	/*theApp.emuledlg->*/m_pBrowserWnd->Stop();
}

void CWebTool::OnBnClickedRefresh()
{
	/*theApp.emuledlg->*/m_pBrowserWnd->Refresh();
}

void CWebTool::OnBnClickedGoHome()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
//	theApp.emuledlg->m_pBrowserWnd->GoHome();
	/*theApp.emuledlg->*/m_pBrowserWnd->Navigate2(MOD_BOARD_URL, 0, NULL);	
}

void CWebTool::DoLogin()
{
	if(!thePrefs.IsAuthenticated())
		return;
	
	const CString strCurURL = m_pBrowserWnd->GetLocationURL();

	//This doesn't work (yet)
	//I didn't get vB source code to check out how the login is done...
	CString strURL = L"";
	strURL.Format(MOD_LOGIN_URL, thePrefs.GetUserName(), thePrefs.GetUserPW());
	m_pBrowserWnd->Navigate2(strURL, 0, NULL);

	m_pBrowserWnd->Navigate2(strCurURL, 0, NULL);
}

void CWebTool::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	CRect rcClient;	
	theApp.emuledlg->GetClientRect(&rcClient);
#define TB_HEIGHT			66 //height of the MAIN bitmaps
#define WEBTOOL_HEIGHT		40
#define PADDING		9
	SetWindowPos(NULL, rcClient.left+PADDING, rcClient.top+TB_HEIGHT, rcClient.Width()-2*PADDING, WEBTOOL_HEIGHT, SWP_NOZORDER);
	// ưġ 
	if(m_ButtonGoHome.GetSafeHwnd())
	{
		int iOffSet = rcClient.Width()/2 - 100; 
		if(iOffSet < 0) 
			iOffSet = 0;
		m_ButtonBack.SetWindowPos(NULL, iOffSet+0, 0, 0, 0, SWP_NOSIZE); //ڷ ư
		m_ButtonNext.SetWindowPos(NULL, iOffSet+40, 0, 0, 0, SWP_NOSIZE); // ư
		m_ButtonStop.SetWindowPos(NULL, iOffSet+80, 0, 0, 0, SWP_NOSIZE); // ư
		m_ButtonRefresh.SetWindowPos(NULL, iOffSet+120, 0, 0, 0, SWP_NOSIZE); //ΰħ ư
		m_ButtonGoHome.SetWindowPos(NULL, iOffSet+160, 0, 0, 0, SWP_NOSIZE); //Ȩ ư
	}
	Invalidate();
}

BOOL CWebTool::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	m_ButtonBack.SetSkin(IDB_BACK1, IDB_BACK3, IDB_BACK2, IDB_BACK1, 0, 0, 0, 0, 0);
	m_ButtonNext.SetSkin(IDB_NEXT1, IDB_NEXT3, IDB_NEXT2, IDB_NEXT1, 0, 0, 0, 0, 0);
	m_ButtonRefresh.SetSkin(IDB_REFRESH1, IDB_REFRESH3, IDB_REFRESH2, IDB_REFRESH1, 0, 0, 0, 0, 0);
	m_ButtonGoHome.SetSkin(IDB_GOHOME1, IDB_GOHOME3, IDB_GOHOME2, IDB_GOHOME1, 0, 0, 0, 0, 0);
	m_ButtonStop.SetSkin(IDB_STOP1, IDB_STOP3, IDB_STOP2, IDB_STOP1, 0, 0, 0, 0, 0);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
#endif