//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "BarShader.h"
#include "MapKey.h" // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
#include "Neo\GUI\IP2Country.h"
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --

class CClientReqSocket;
class CPeerCacheDownSocket;
class CPeerCacheUpSocket;
class CFriend;
class CPartFile;
class CClientCredits;
class CAbstractFile;
class CKnownFile;
class Packet;
class CxImage;
struct Requested_Block_Struct;
class CSafeMemFile;
class CEMSocket;
class CAICHHash;
enum EUtf8Str;
class CClientFileStatus; // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
// NEO: XSF - [ExtendedSharedFiles] -- Xanatos -->
class CSearchFile;
class CClientDetailDialog; 
// NEO: XSF END <-- Xanatos --
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
class CFileDataIO;
class CTag;
#endif // NEO_SS // NEO: NSS END <-- Xanatos --
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] -- Xanatos -->
class CKnownSource;
#endif // NEO_CD // NEO: NCD END <-- Xanatos --

struct Pending_Block_Struct{
	Pending_Block_Struct()
	{
		block = NULL;
		zStream = NULL;
		totalUnzipped = 0;
		fZStreamError = 0;
		fRecovered = 0;
		fQueued = 0;
	}
	Requested_Block_Struct*	block;
	struct z_stream_s*      zStream;       // Barry - Used to unzip packets
	UINT					totalUnzipped; // Barry - This holds the total unzipped bytes for all packets so far
	UINT					fZStreamError : 1,
							fRecovered    : 1,
							fQueued		  : 3;
};

#pragma pack(1)
struct Requested_File_Struct{
	uchar	  fileid[16];
	uint32	  lastasked;
	uint8	  badrequests;
};
#pragma pack()

enum EUploadState{
	US_UPLOADING,
	US_ONUPLOADQUEUE,
	US_NONEEDEDPARTS, // NEO: SCT - [SubChunkTransfer] <-- Xanatos --
	US_WAITCALLBACK,
#ifdef NATTUNNELING // NEO: LUC - [LowIDUploadCallBack] -- Xanatos -->
	US_WAITCALLBACKKAD,
#endif //NATTUNNELING // NEO: LUC END <-- Xanatos --
#ifdef NATTUNNELING // NEO: XSB - [XSBuddy] -- Xanatos -->
	US_WAITCALLBACKXS,
#endif //NATTUNNELING // NEO: XSB END <-- Xanatos --
	US_CONNECTING,
	US_PENDING,
	US_LOWTOLOWIP,
	US_BANNED,
	US_ERROR,
	US_NONE
};

enum EDownloadState{
	DS_DOWNLOADING,
	DS_ONQUEUE,
	DS_REMOTEQUEUEFULL, // NEO: FIX - [SourceCount] -- Xanatos --
	DS_CONNECTED,
	DS_CONNECTING,
	DS_HALTED, // NEO: SD - [StandByDL] <-- Xanatos --
	DS_CONNECTIONRETRY, // NEO: TCR - [TCPConnectionRetry] <-- Xanatos --
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	DS_LOADED,
#endif // NEO_SS // NEO: NSS END <-- Xanatos --
	DS_CACHED, // NEO: XSC - [ExtremeSourceCache] <-- Xanatos --
	DS_WAITCALLBACK,
	DS_WAITCALLBACKKAD,
#ifdef NATTUNNELING // NEO: XSB - [XSBuddy] -- Xanatos -->
	DS_WAITCALLBACKXS,
#endif //NATTUNNELING // NEO: XSB END <-- Xanatos --
	DS_REQHASHSET,
	DS_NONEEDEDPARTS,
	DS_TOOMANYCONNS,
	DS_TOOMANYCONNSKAD,
	DS_LOWTOLOWIP,
	DS_BANNED,
	DS_ERROR,
	DS_NONE,
	//DS_REMOTEQUEUEFULL  // not used yet, except in statistics
};

enum EPeerCacheDownState{
	PCDS_NONE = 0,
	PCDS_WAIT_CLIENT_REPLY,
	PCDS_WAIT_CACHE_REPLY,
	PCDS_DOWNLOADING
};

enum EPeerCacheUpState{
	PCUS_NONE = 0,
	PCUS_WAIT_CACHE_REPLY,
	PCUS_UPLOADING
};

enum EChatState{
	MS_NONE,
	MS_CHATTING,
	MS_CONNECTING,
	MS_UNABLETOCONNECT
};

enum EKadState{
	KS_NONE,
	KS_QUEUED_FWCHECK,
	KS_CONNECTING_FWCHECK,
	KS_CONNECTED_FWCHECK,
	KS_QUEUED_BUDDY,
	KS_INCOMING_BUDDY,
	KS_CONNECTING_BUDDY,
	KS_CONNECTED_BUDDY
};

enum EClientSoftware{
	SO_EMULE			= 0,	// default
	SO_CDONKEY			= 1,	// ET_COMPATIBLECLIENT
	SO_XMULE			= 2,	// ET_COMPATIBLECLIENT
	SO_AMULE			= 3,	// ET_COMPATIBLECLIENT
	SO_SHAREAZA			= 4,	// ET_COMPATIBLECLIENT
	// NEO: ECR - [EnhancedClientRecognization] -- Xanatos -->
	SO_EMULEPLUS		= 5,
	SO_HYDRANODE		= 6,
	// NEO: ECR END <-- Xanatos --
	SO_MLDONKEY			= 10,	// ET_COMPATIBLECLIENT
	SO_LPHANT			= 20,	// ET_COMPATIBLECLIENT
	// NEO: ECR - [EnhancedClientRecognization] -- Xanatos -->
	SO_SHAREAZA2		= 28,
	SO_TRUSTYFILES		= 30,
	SO_SHAREAZA3		= 40,
	// NEO: ECR END <-- Xanatos --
	// other client types which are not identified with ET_COMPATIBLECLIENT
	SO_EDONKEYHYBRID	= 50,
	// NEO: ECR - [EnhancedClientRecognization] -- Xanatos -->
	SO_EDONKEY			= 51,
	SO_MLDONKEY2		= 52,
	SO_OLDEMULE			= 53,
	SO_SHAREAZA4		= 68,
	SO_MLDONKEY3		= 152,
	 // NEO: ECR END <-- Xanatos --
	//SO_EDONKEY,
	//SO_OLDEMULE,
	SO_URL,
	SO_UNKNOWN
};

enum ESecureIdentState{
	IS_UNAVAILABLE		= 0,
	IS_ALLREQUESTSSEND  = 0,
	IS_SIGNATURENEEDED	= 1,
	IS_KEYANDSIGNEEDED	= 2,
};

enum EInfoPacketState{
	IP_NONE				= 0,
	IP_EDONKEYPROTPACK  = 1,
	IP_EMULEPROTPACK	= 2,
	IP_BOTH				= 3,
};

enum ESourceFrom{
	SF_SERVER			= 0,
	SF_KADEMLIA			= 1,
	SF_SOURCE_EXCHANGE	= 2,
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	SF_STORAGE			= 3,
#endif // NEO_SS // NEO: NSS END <-- Xanatos --
#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
	SF_LANCAST			= 4,
#endif //LANCAST // NEO: NLC END <-- Xanatos --
#ifdef VOODOO // NEO: VOODOOx - [VoodooSourceExchange] -- Xanatos -->
	SF_VOODOO			= 5,
#endif // VOODOO // NEO: VOODOOx END <-- Xanatos --
	SF_PASSIVE			= 6,
	SF_LINK				= 7,
};

// NEO: FCC - [FixConnectionCollision] -- Xanatos -->
enum EHelloPacketState{
	HP_NONE			= 0,
	HP_HELLO		= 1,
	HP_HELLOANSWER  = 2,
	HP_BOTH			= 3,
};
// NEO: FCC END <-- Xanatos --

// NEO: USPS - [UnSolicitedPartStatus] -- Xanatos -->
enum EFileRequestState{
	FR_NONE			= 0,
	FR_INPROGRES	= 1,
	FR_COMPLETED	= 2,
	FR_STANDBY		= 3, // NEO: SD - [StandByDL]
};
// NEO: USPS END <-- Xanatos --

#ifdef NATTUNNELING // NEO: XSB - [XSBuddy] -- Xanatos -->
enum EXsBuddy{
	XB_NONE			= 0, // no buddy
	XB_CONNECTING	= 1, // connecting to HighID buddy
	XB_HIGH_BUDDY	= 2, // HighID accepted our request his our buddy now
	XB_LOW_BUDDY	= 3, // We are the buddy for a Low ID Cleint
	XB_DENIDED		= 4  // HighID dont want to be a buddy he have enough buddys already
};
#endif //NATTUNNELING // NEO: XSB END <-- Xanatos --

#ifdef _DEBUG
	// use the 'Enums' only for debug builds, each enum costs 4 bytes (3 unused)
#define _EClientSoftware	EClientSoftware
#define _EChatState			EChatState
#define _EKadState			EKadState
#define _ESecureIdentState	ESecureIdentState
#define _EUploadState		EUploadState
#define _EDownloadState		EDownloadState
#define _ESourceFrom		ESourceFrom
#ifdef NATTUNNELING // NEO: XSB - [XSBuddy] -- Xanatos -->
#define _EXsBuddy			EXsBuddy
#endif //NATTUNNELING // NEO: XSB END <-- Xanatos --
#define _EModClient			EModClient // NEO: MID - [ModID] <-- Xanatos -- 
#else
#define _EClientSoftware	uint8
#define _EChatState			uint8
#define _EKadState			uint8
#define _ESecureIdentState	uint8
#define _EUploadState		uint8
#define _EDownloadState		uint8
#define _ESourceFrom		uint8
#ifdef NATTUNNELING // NEO: XSB - [XSBuddy] -- Xanatos -->
#define _EXsBuddy			uint8
#endif //NATTUNNELING // NEO: XSB END <-- Xanatos --
#define _EModClient			uint8 // NEO: MID - [ModID] <-- Xanatos -- 
#endif

// NEO: MID - [ModID] -- Xanatos -->
enum EModClient{
	MOD_NONE			= 0,
	MOD_UNKNOWN			= 1,
	MOD_NEO				= 2,
	MOD_MORPH			= 3,
	MOD_SCAR			= 4,
	MOD_STULLE			= 5,
	MOD_MAXMOD			= 6,
	MOD_XTREME			= 7,
	MOD_EASTSHARE		= 8,
	MOD_IONIX			= 9,
	MOD_CYREX			= 10,
	MOD_NEXTEMF			= 11,
};
// NEO: MID END <-- Xanatos -- 

struct PartFileStamp{
	CPartFile*	file;
	DWORD		timestamp;
};

#define	MAKE_CLIENT_VERSION(mjr, min, upd) \
	((UINT)(mjr)*100U*10U*100U + (UINT)(min)*100U*10U + (UINT)(upd)*100U)

//#pragma pack(2)
class CUpDownClient : public CObject
{
	DECLARE_DYNAMIC(CUpDownClient)

	friend class CUploadQueue;
	friend class CemuleDlg; // NEO: RBT - [ReadBlockThread] <-- Xanatos --
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
	friend class CVoodooSocket; // NEO: RBT - [ReadBlockThread]
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
	friend class CQueueListCtrl; // NEO: UPC - [UploadingProblemClient] <-- Xanatos --

public:
    void PrintUploadStatus();

	//base
	CUpDownClient(CClientReqSocket* sender = 0);
	CUpDownClient(CPartFile* in_reqfile, uint16 in_port, uint32 in_userid, uint32 in_serverup, uint16 in_serverport, bool ed2kID = false);
	virtual ~CUpDownClient();

	void			StartDownload();
	virtual void	CheckDownloadTimeout();
	virtual void	SendCancelTransfer(Packet* packet = NULL);
	virtual bool	IsEd2kClient() const							{ return true; }
	virtual bool	Disconnected(LPCTSTR pszReason, bool bFromSocket = false);
	virtual bool	TryToConnect(bool bIgnoreMaxCon = false, CRuntimeClass* pClassSocket = NULL);
	virtual bool	Connect();
	virtual void	ConnectionEstablished();
	virtual void	OnSocketConnected(int nErrorCode);
	bool			CheckHandshakeFinished() const;
	void			CheckFailedFileIdReqs(const uchar* aucFileHash);
	uint32			GetUserIDHybrid() const							{ return m_nUserIDHybrid; }
	void			SetUserIDHybrid(uint32 val)						{ m_nUserIDHybrid = val; }
	LPCTSTR			GetUserName() const								{ return m_pszUsername; }
	void			SetUserName(LPCTSTR pszNewName);
	uint32			GetIP() const									{ return m_dwUserIP; }
	void			SetIP( uint32 val ) //Only use this when you know the real IP or when your clearing it.
						{
							m_dwUserIP = val;
							m_nConnectIP = val;
#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
							CheckOnLAN(val);
#endif //LANCAST // NEO: NLC END <-- Xanatos --
						}
#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
	void			CheckOnLAN( uint32 val );
#endif //LANCAST // NEO: NLC END <-- Xanatos --
	__inline bool	HasLowID() const								{ return (m_nUserIDHybrid < 16777216); }
	uint32			GetConnectIP() const							{ return m_nConnectIP; }
	void			SetConnectIP( uint32 val )						{ m_nConnectIP = val; } // NEO: MOD - [SetConnectIP] <-- Xanatos --
	uint16			GetUserPort() const								{ return m_nUserPort; }
	void			SetUserPort(uint16 val)							{ m_nUserPort = val; }
	UINT			GetTransferredUp() const						{ return m_nTransferredUp; }
	UINT			GetTransferredDown() const						{ return m_nTransferredDown; }
	uint32			GetServerIP() const								{ return m_dwServerIP; }
	void			SetServerIP(uint32 nIP)							{ m_dwServerIP = nIP; }
	uint16			GetServerPort() const							{ return m_nServerPort; }
	void			SetServerPort(uint16 nPort)						{ m_nServerPort = nPort; }
	const uchar*	GetUserHash() const								{ return (uchar*)m_achUserHash; }
	void			SetUserHash(const uchar* pUserHash);
	bool			HasValidHash() const
						{
							return ((const int*)m_achUserHash[0]) != 0 || ((const int*)m_achUserHash[1]) != 0 || ((const int*)m_achUserHash[2]) != 0 || ((const int*)m_achUserHash[3]) != 0;
						}
	int				GetHashType() const;
	const uchar*	GetBuddyID() const								{ return (uchar*)m_achBuddyID; }
	void			SetBuddyID(const uchar* m_achTempBuddyID);
	bool			HasValidBuddyID() const							{ return m_bBuddyIDValid; }
	void			SetBuddyIP( uint32 val )						{ m_nBuddyIP = val; }
	uint32			GetBuddyIP() const								{ return m_nBuddyIP; }
	void			SetBuddyPort( uint16 val )						{ m_nBuddyPort = val; }
	uint16			GetBuddyPort() const							{ return m_nBuddyPort; }
	EClientSoftware	GetClientSoft() const							{ return (EClientSoftware)m_clientSoft; }
	const CString&	GetClientSoftVer() const						{ return m_strClientSoftware; }
	const CString&	GetClientModVer() const							{ return m_strModVersion; }
	void			InitClientSoftwareVersion();
	UINT			GetVersion() const								{ return m_nClientVersion; }
	uint8			GetMuleVersion() const							{ return m_byEmuleVersion; }
	bool			ExtProtocolAvailable() const					{ return m_bEmuleProtocol; }
	bool			SupportMultiPacket() const						{ return m_bMultiPacket; }
	bool			SupportExtMultiPacket() const					{ return m_fExtMultiPacket; }
	bool			SupportPeerCache() const						{ return m_fPeerCache; }
	bool			SupportsLargeFiles() const						{ return m_fSupportsLargeFiles; }
	bool			IsEmuleClient() const							{ return m_byEmuleVersion!=0; }
	uint8			GetSourceExchange1Version() const				{ return m_bySourceExchange1Ver; }
	bool			SupportsSourceExchange2() const					{ return m_fSupportsSourceEx2; }
	CClientCredits* Credits() const									{ return credits; }
	bool			IsBanned() const;
	//const CString&	GetClientFilename() const						{ return m_strClientFilename; }
	//void			SetClientFilename(const CString& fileName)		{ m_strClientFilename = fileName; }
	const CString	GetClientFilename() const; // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
	uint16			GetUDPPort() const								{ return m_nUDPPort; }
	void			SetUDPPort(uint16 nPort)						{ m_nUDPPort = nPort; }
	uint8			GetUDPVersion() const							{ return m_byUDPVer; }
	bool			SupportsUDP() const								{ return GetUDPVersion() != 0 && m_nUDPPort != 0; }
	uint16			GetKadPort() const								{ return m_nKadPort; }
	void			SetKadPort(uint16 nPort)						{ m_nKadPort = nPort; }
	uint8			GetExtendedRequestsVersion() const				{ return m_byExtendedRequestsVer; }
	uint8			GetCommentVersion() const						{ return m_byAcceptCommentVer; } // NEO: MOD - [GetCommentVersion] <-- Xanatos --
	//void			RequestSharedFileList();
	//void			ProcessSharedFileList(const uchar* pachPacket, UINT nSize, LPCTSTR pszDirectory = NULL);
	// NEO: XSF - [ExtendedSharedFiles] -- Xanatos -->
	bool 			RequestSharedFileList(bool bForce = false);
	bool			SendDirRequest(CString path, bool bForce = false);
	void			ProcessSharedFileList(const uchar* pachPacket, UINT nSize, LPCTSTR pszDirectory = NULL);
	void			ProcessSharedDirsList(const uchar* pachPacket, uint32 nSize);
	CRBMap<CString, bool>	*GetListDirs() { return &m_listDirs; }
	CList<CSearchFile*>	*GetListFiles() { return &m_listFiles; }
	void			SetDeniesShare(bool in = true, bool updateTree = true);
	bool			GetDeniesShare() { return m_bDeniesShare; }
	// NEO: XSF END <-- Xanatos --

	void			ClearHelloProperties();
	bool			ProcessHelloAnswer(const uchar* pachPacket, UINT nSize);
	bool			ProcessHelloPacket(const uchar* pachPacket, UINT nSize);
	void			SendHelloAnswer();
	virtual bool	SendHelloPacket();
	void			SendMuleInfoPacket(bool bAnswer);
	void			ProcessMuleInfoPacket(const uchar* pachPacket, UINT nSize);
	void			ProcessMuleCommentPacket(const uchar* pachPacket, UINT nSize);
	void			ProcessEmuleQueueRank(const uchar* packet, UINT size);
	void			ProcessEdonkeyQueueRank(const uchar* packet, UINT size);
	void			CheckQueueRankFlood();
	bool			Compare(const CUpDownClient* tocomp, bool bIgnoreUserhash = false) const;
	void			ResetFileStatusInfo();
	uint32			GetLastSrcReqTime() const						{ return m_dwLastSourceRequest; }
	void			SetLastSrcReqTime()								{ m_dwLastSourceRequest = ::GetTickCount(); }
	uint32			GetLastSrcAnswerTime() const					{ return m_dwLastSourceAnswer; }
	void			SetLastSrcAnswerTime()							{ m_dwLastSourceAnswer = ::GetTickCount(); }
	uint32			GetLastAskedForSources() const					{ return m_dwLastAskedForSources; }
	void			SetLastAskedForSources()						{ m_dwLastAskedForSources = ::GetTickCount(); }
	bool			GetReleaseSlot(bool bIntern = false) const; // NEO: SRS - [SmartReleaseSharing] <-- Xanatos --
	//bool			GetFriendSlot() const;
	bool			GetFriendSlot(bool bIntern = false) const;		// NEO: NMFS - [NiceMultiFriendSlots] <-- Xanatos --
	void			SetFriendSlot(bool bNV)							{ m_bFriendSlot = bNV; }
	bool			IsFriend() const								{ return m_Friend != NULL; }
	void			SetCommentDirty(bool bDirty = true)				{ m_bCommentDirty = bDirty; }
	bool			GetSentCancelTransfer() const					{ return m_fSentCancelTransfer; }
	void			SetSentCancelTransfer(bool bVal)				{ m_fSentCancelTransfer = bVal; }
	void			ProcessPublicIPAnswer(const BYTE* pbyData, UINT uSize);
	void			SendPublicIPRequest();
	uint8			GetKadVersion()									{ return m_byKadVersion; }
	bool			SendBuddyPingPong()								{ return m_dwLastBuddyPingPongTime < ::GetTickCount(); }
	bool			AllowIncomeingBuddyPingPong()					{ return m_dwLastBuddyPingPongTime < (::GetTickCount()-(3*60*1000)); }
	void			SetLastBuddyPingPongTime()						{ m_dwLastBuddyPingPongTime = (::GetTickCount()+(10*60*1000)); }
	// secure ident
	void			SendPublicKeyPacket();
	void			SendSignaturePacket();
	void			ProcessPublicKeyPacket(const uchar* pachPacket, UINT nSize);
	void			ProcessSignaturePacket(const uchar* pachPacket, UINT nSize);
	uint8			GetSecureIdentState() const						{ return (uint8)m_SecureIdentState; }
	void			SendSecIdentStatePacket();
	void			ProcessSecIdentStatePacket(const uchar* pachPacket, UINT nSize);
	uint8			GetInfoPacketsReceived() const					{ return m_byInfopacketsReceived; }
	uint8			SupportSecIdent() const							{ return m_bySupportSecIdent; } // NEO: MOD - [SupportSecIdent] <-- Xanatos --
	void			InfoPacketsReceived();
	// preview
	void			SendPreviewRequest(const CAbstractFile* pForFile);
	void			SendPreviewAnswer(const CKnownFile* pForFile, CxImage** imgFrames, uint8 nCount);
	void			ProcessPreviewReq(const uchar* pachPacket, UINT nSize);
	void			ProcessPreviewAnswer(const uchar* pachPacket, UINT nSize);
	bool			GetPreviewSupport() const						{ return m_fSupportsPreview && GetViewSharedFilesSupport(); }
	bool			GetViewSharedFilesSupport() const				{ return m_fNoViewSharedFiles==0; }
	bool			SafeSendPacket(Packet* packet);
#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
	void			SetGPLEvilDoer()								{m_bGPLEvildoer = true;}
#endif // ARGOS // NEO: NA END <-- Xanatos --
	void			CheckForGPLEvilDoer();
	// Encryption / Obfuscation
	bool			SupportsCryptLayer() const						{ return m_fSupportsCryptLayer; }
	bool			RequestsCryptLayer() const						{ return SupportsCryptLayer() && m_fRequestsCryptLayer; }
	bool			RequiresCryptLayer() const						{ return RequestsCryptLayer() && m_fRequiresCryptLayer; }
	void			SetCryptLayerSupport(bool bVal)					{ m_fSupportsCryptLayer = bVal ? 1 : 0; }
	void			SetCryptLayerRequest(bool bVal)					{ m_fRequestsCryptLayer = bVal ? 1 : 0; }
	void			SetCryptLayerRequires(bool bVal)				{ m_fRequiresCryptLayer = bVal ? 1 : 0; }
	bool			IsObfuscatedConnectionEstablished() const;
	bool			ShouldReceiveCryptUDPPackets() const;

	//upload
	EUploadState	GetUploadState() const							{ return (EUploadState)m_nUploadState; }
	void			SetUploadState(EUploadState news);
	uint32			GetWaitStartTime() const;
	void 			SetWaitStartTime();
	void 			ClearWaitStartTime();
	uint32			GetWaitTime() const								{ return m_dwUploadTime - GetWaitStartTime(); }
	// NEO: SQ - [SaveUploadQueue] -- Xanatos -->
	void			SaveQueueWaitTime();
	void			ClearQueueWaitTime();
	// NEO: SQ END <-- Xanatos --
	bool			IsDownloading() const							{ return (m_nUploadState == US_UPLOADING); }
	bool			HasBlocks() const								{ return !m_BlockRequests_queue.IsEmpty(); }
    UINT            GetNumberOfRequestedBlocksInQueue() const       { return m_BlockRequests_queue.GetCount(); }
	UINT			GetDatarate() const								{ return m_nUpDatarate; }	
	UINT			GetFileScore(CKnownFile* currequpfile, bool isDownloading, uint32 downloadingTime) const; // NEO: MQ - [MultiQueue] <-- Xanatos --
	// NEO: PRSF - [PushSmallRareFiles] -- Xanatos -->
	float			GetRareFilePushRatio(CKnownFile* currequpfile) const;
	float			GetSmallFilePushRatio(CKnownFile* currequpfile) const;
	float			GetRatioFilePushRatio(CKnownFile* currequpfile) const;
	// NEO: PRSF END <-- Xanatos --
	UINT			GetScore(bool sysvalue, bool isdownloading = false, bool onlybasevalue = false, bool forceRandomScore = false) const; // NEO: RQ - [RandomQueue] <-- Xanatos --
	//UINT			GetScore(bool sysvalue, bool isdownloading = false, bool onlybasevalue = false) const;
	void			AddReqBlock(Requested_Block_Struct* reqblock);
	void			CreateNextBlockPackage();
	//uint32			GetUpStartTimeDelay() const						{ return ::GetTickCount() - m_dwUploadTime; }
	//void 			SetUpStartTime()								{ m_dwUploadTime = ::GetTickCount(); }
	// NEO: CUT - [CleanUploadTiming] -- Xanatos -->
	uint32			GetUpStartTimeDelay() const						{ return time(NULL) - m_dwUploadTime; }
	void 			SetUpStartTime()								{ m_dwUploadTime = time(NULL); }
	// NEO: CUT END <-- Xanatos --
	void			SendHashsetPacket(const uchar* fileid);
	const uchar*	GetUploadFileID() const							{ return requpfileid; }
	void			SetUploadFileID(CKnownFile* newreqfile);
	UINT			SendBlockData();
	void			ClearUploadBlockRequests();
	void			SendRankingInfo();
	void			SendCommentInfo(/*const*/ CKnownFile *file);
	void			AddRequestCount(const uchar* fileid);
	CTypedPtrList<CPtrList, Requested_File_Struct*>* GetRequestedFilesList()	{return &m_RequestedFiles_list;} // NEO: RFL - [RequestFileList] <-- Xanatos --
	void			UnBan();
	void			Ban(LPCTSTR pszReason = NULL);
	UINT			GetAskedCount() const							{ return m_cAsked; }
	void			AddAskedCount()									{ m_cAsked++; }
	void			SetAskedCount(UINT m_cInAsked)					{ m_cAsked = m_cInAsked; }
	void			FlushSendBlocks(); // call this when you stop upload, or the socket might be not able to send
	uint32			GetLastUpRequest() const						{ return m_dwLastUpRequest; }
	void			SetLastUpRequest()								{ m_dwLastUpRequest = ::GetTickCount(); }
	void			SetCollectionUploadSlot(bool bValue);
	bool			HasCollectionUploadSlot() const					{ return m_bCollectionUploadSlot; }

	UINT			GetSessionUp() const							{ return m_nTransferredUp - m_nCurSessionUp; }
	void			ResetSessionUp() {
						m_nCurSessionUp = m_nTransferredUp;
						m_addedPayloadQueueSession = 0;
						m_nCurQueueSessionPayloadUp = 0;
					}

	UINT			GetSessionDown() const							{ return m_nTransferredDown - m_nCurSessionDown; }
    UINT            GetSessionPayloadDown() const                   { return m_nCurSessionPayloadDown; }
	void			ResetSessionDown() {
						m_nCurSessionDown = m_nTransferredDown;
                        m_nCurSessionPayloadDown = 0;
					}
	UINT			GetQueueSessionPayloadUp() const				{ return m_nCurQueueSessionPayloadUp; }
    UINT			GetPayloadInBuffer() const						{ return m_addedPayloadQueueSession - GetQueueSessionPayloadUp(); }

	//bool			ProcessExtendedInfo(CSafeMemFile* packet, CKnownFile* tempreqfile);
	bool			ProcessExtendedInfo(CSafeMemFile* packet, CKnownFile* tempreqfile, bool bUDP = false); // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
	//void			DrawUpStatusBar(CDC* dc, RECT* rect, bool onlygreyrect, bool  bFlat) const;
	void			DrawUpStatusBar(CDC* dc, RECT* rect, const uchar* fileid, bool  bFlat) const; // NEO: MFSB - [MultiFileStatusBars] <-- Xanatos --
	// NEO: SCFS - [SmartClientFileStatus] -- Xanatos --
	/*uint16			GetUpPartCount() const							{ return m_nUpPartCount; }
	bool			IsUpPartAvailable(UINT iPart) const {
						return (iPart >= m_nUpPartCount || !m_abyUpPartStatus) ? false : m_abyUpPartStatus[iPart] != 0;
					}
	uint8*			GetUpPartStatus() const							{ return m_abyUpPartStatus; }*/
    float           GetCombinedFilePrioAndCredit();

	//download
	UINT			GetAskedCountDown() const						{ return m_cDownAsked; }
	void			AddAskedCountDown()								{ m_cDownAsked++; }
	void			SetAskedCountDown(UINT cInDownAsked)			{ m_cDownAsked = cInDownAsked; }
	EDownloadState	GetDownloadState() const						{ return (EDownloadState)m_nDownloadState; }
	void			SetDownloadState(EDownloadState nNewState, LPCTSTR pszReason = _T("Unspecified"));
	uint32			GetLastAskedTime(const CPartFile* partFile = NULL) const;
    void            SetLastAskedTime()								{ m_fileReaskTimes.SetAt(reqfile, ::GetTickCount()); }
	void            SetSpreadReaskModyfier(); // NEO: SR - [SpreadReask] <-- Xanatos --
	// NEO: DR - [DownloadReask] -- Xanatos -->
	uint32			GetReqFileReaskIntervals();
	void            SetNextAskedTime(uint32 uNextReask = 0);
	bool			SetSafeReAskTime();
	// NEO: DR END <-- Xanatos --
	// NEO: SCFS - [SmartClientFileStatus] -- Xanatos --
	/*bool			IsPartAvailable(UINT iPart) const {
						return (iPart >= m_nPartCount || !m_abyPartStatus) ? false : m_abyPartStatus[iPart] != 0;
					}
	uint8*			GetPartStatus() const							{ return m_abyPartStatus; }
	uint16			GetPartCount() const							{ return m_nPartCount; }*/
	UINT			GetDownloadDatarate() const						{ return m_nDownDatarate; }
	UINT			GetRemoteQueueRank() const						{ return m_nRemoteQueueRank; }
	UINT			GetRemoteQueueRankOld() const					{ return m_nRemoteQueueRankOld; } // NEO: CQR - [CollorQueueRank] <-- Xanatos --
	void			SetRemoteQueueRank(UINT nr, bool bUpdateDisplay = false);
	// NEO: FIX - [SourceCount] -- Xanatos --
	//bool			IsRemoteQueueFull() const						{ return m_bRemoteQueueFull; }
	//void			SetRemoteQueueFull(bool flag)					{ m_bRemoteQueueFull = flag; }
	//void			DrawStatusBar(CDC* dc, LPCRECT rect, bool onlygreyrect, bool  bFlat) const;
	void			DrawStatusBar(CDC* dc, LPCRECT rect, CPartFile* file, bool  bFlat) const; // NEO: MFSB - [MultiFileStatusBars] <-- Xanatos --
	bool			AskForDownload();
	virtual void	SendFileRequest();
	void			SendStartupLoadReq();
	void			ProcessFileInfo(CSafeMemFile* data, CPartFile* file);
	void			ProcessFileStatus(bool bUdpPacket, CSafeMemFile* data, CPartFile* file);
	void			ProcessModFileStatus(bool bUdpPacket, CPartFile* file); // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
	void			HandleFileStatus(CPartFile* file, bool bUdpPacket, bool bPartsNeeded, bool bCheckPassive = false); // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
	void			RequestHashset(); // NEO: MOD - [RequestHashset] <-- Xanaots --
	void			ProcessHashSet(const uchar* data, UINT size);
	void			ProcessAcceptUpload();
	bool			AddRequestForAnotherFile(CPartFile* file);
	void			CreateBlockRequests(int iMaxBlocks);
	virtual void	SendBlockRequests();
	POSITION		SendBlockRequestsPacket(POSITION startPos); // NEO: DBR - [DynamicBlockRequest] <-- Xanatos --
	virtual bool	SendHttpBlockRequests();
	virtual void	ProcessBlockPacket(const uchar* packet, UINT size, bool packed, bool bI64Offsets);
	virtual void	ProcessHttpBlockPacket(const BYTE* pucData, UINT uSize);
	void			ClearDownloadBlockRequests();
	void			SendOutOfPartReqsAndAddToWaitingQueue();
	// NEO: ASM - [AccurateSpeedMeasure] -- Xanatos -->
	void			AddDownloadSize(uint64 size)	{m_nSumForAvgDownDataRate += (UINT)size;}
	void			AddUploadedSize(uint64 size)	{m_nSumForAvgUpDataRate += (UINT)size;}
	UINT			CalculateDownloadRate();
	UINT			CalculateUploadRate(); 
	UINT			CheckUploadRate(int dataratestocheck);
	UINT			CheckDownloadRate(int dataratestocheck);
	// NEO: ASM END <-- Xanatos --
	//UINT			CalculateDownloadRate();
	uint16			GetAvailablePartCount() const;
	bool			SwapToAnotherFile(LPCTSTR pszReason, bool bIgnoreNoNeeded, bool ignoreSuspensions, bool bRemoveCompletely, CPartFile* toFile = NULL, bool allowSame = true, bool isAboutToAsk = false, bool debug = false); // ZZ:DownloadManager
	void			DontSwapTo(/*const*/ CPartFile* file);
	bool			IsSwapSuspended(const CPartFile* file, const bool allowShortReaskTime = false, const bool fileIsNNP = false) /*const*/; // ZZ:DownloadManager
    uint32          GetTimeUntilReask() const;
    uint32          GetTimeUntilReask(const CPartFile* file) const;
    uint32			GetTimeUntilReask(const CPartFile* file, const bool allowShortReaskTime, const bool useGivenNNP = false, const bool givenNNP = false) const;
	void			SendAcceptUpload(); // NEO: MOD - [SendAcceptUpload] <-- Xanatos --
	void			UDPReaskACK(uint16 nNewQR);
	void			UDPReaskFNF();
	void			UDPReaskForDownload();
	bool			UDPPacketPending() const						{ return m_bUDPPending; }
	bool			IsSourceRequestAllowed() const;
    bool            IsSourceRequestAllowed(CPartFile* partfile, bool sourceExchangeCheck = false) const; // ZZ:DownloadManager

	// NEO: SCFS - [SmartClientFileStatus] -- Xanatos -->
	CClientFileStatus* GetFileStatus(const CKnownFile* File, bool bAdd = false) const;
	void			ClearFileStatus(const CKnownFile* File);
	// NEO: SCFS END <-- Xanatos --

	// NEO: MCM - [ManualClientManagement] -- Xanatos -->
	bool			DoSwap(CPartFile* SwapTo, bool bRemoveCompletely, LPCTSTR reason, bool bHandleClientReq = false); // ZZ:DownloadManager
	void			DisableSwaping(bool bDisable)	{m_bDisableSwaping = bDisable;}
	bool			IsSwapingDisabled() const		{return m_bDisableSwaping;}
	// NEO: MCM END <-- Xanatos --

	bool			IsValidSource() const;
	bool			IsValidSource2() const; // NEO: MOD - [IsValidSource] <-- Xanatos --
	ESourceFrom		GetSourceFrom() const							{ return (ESourceFrom)m_nSourceFrom; }
	void			SetSourceFrom(ESourceFrom val)					{ m_nSourceFrom = (_ESourceFrom)val; }

	void			SetDownStartTime()								{ m_dwDownStartTime = ::GetTickCount(); }
	uint32			GetDownTimeDifference(boolean clear = true)	{
						uint32 myTime = m_dwDownStartTime;
						if(clear) m_dwDownStartTime = 0;
						return ::GetTickCount() - myTime;
					}
	bool			GetTransferredDownMini() const					{ return m_bTransferredDownMini; }
	void			SetTransferredDownMini()						{ m_bTransferredDownMini = true; }
	void			InitTransferredDownMini()						{ m_bTransferredDownMini = false; }
	UINT			GetA4AFCount() const							{ return m_OtherRequests_list.GetCount(); }

	// NEO: SCFS - [SmartClientFileStatus] -- Xanatos --
	//uint16			GetUpCompleteSourcesCount() const				{ return m_nUpCompleteSourcesCount; }
	//void			SetUpCompleteSourcesCount(uint16 n)				{ m_nUpCompleteSourcesCount = n; }

	//chat
	EChatState		GetChatState() const							{ return (EChatState)m_nChatstate; }
	void			SetChatState(EChatState nNewS)					{ m_nChatstate = (_EChatState)nNewS; }

	//KadIPCheck
	EKadState		GetKadState() const								{ return (EKadState)m_nKadState; }
	void			SetKadState(EKadState nNewS)					{ m_nKadState = (_EKadState)nNewS; }

	//File Comment
	// NEO: SCFS - [SmartClientFileStatus] -- Xanatos --
	/*bool			HasFileComment() const							{ return !m_strFileComment.IsEmpty(); }
    const CString&	GetFileComment() const							{ return m_strFileComment; } 
    void			SetFileComment(LPCTSTR pszComment)				{ m_strFileComment = pszComment; }

	bool			HasFileRating() const							{ return m_uFileRating > 0; }
    uint8			GetFileRating() const							{ return m_uFileRating; }
    void			SetFileRating(uint8 uRating)					{ m_uFileRating = uRating; }*/

	// Barry - Process zip file as it arrives, don't need to wait until end of block
	int				unzip(Pending_Block_Struct *block, const BYTE *zipped, UINT lenZipped, BYTE **unzipped, UINT *lenUnzipped, int iRecursion = 0);
	void			UpdateDisplayedInfo(bool force = false);
	int             GetFileListRequested() const					{ return m_iFileListRequested; }
    void            SetFileListRequested(int iFileListRequested)	{ m_iFileListRequested = iFileListRequested; }

	// message filtering
	uint8			GetMessagesReceived() const						{ return m_cMessagesReceived; }
	void			SetMessagesReceived(uint8 nCount)				{ m_cMessagesReceived = nCount; }
	void			IncMessagesReceived()							{ m_cMessagesReceived++; }
	uint8			GetMessagesSent() const							{ return m_cMessagesSent; }
	void			SetMessagesSent(uint8 nCount)					{ m_cMessagesSent = nCount; }
	void			IncMessagesSent()								{ m_cMessagesSent++; }
	bool			IsSpammer() const								{ return m_fIsSpammer; }
	void			SetSpammer(bool bVal);
	bool			GetMessageFiltered() const						{ return m_fMessageFiltered; }
	void			SetMessageFiltered(bool bVal);

	virtual void	SetRequestFile(CPartFile* pReqFile);
	CPartFile*		GetRequestFile() const							{ return reqfile; }

	// AICH Stuff
	void			SetReqFileAICHHash(CAICHHash* val);
	CAICHHash*		GetReqFileAICHHash() const						{ return m_pReqFileAICHHash; }
	bool			IsSupportingAICH() const						{ return m_fSupportsAICH & 0x01; }
	void			SendAICHRequest(CPartFile* pForFile, uint16 nPart);
	bool			IsAICHReqPending() const						{ return m_fAICHRequested; }
	void			ProcessAICHAnswer(const uchar* packet, UINT size);
	void			ProcessAICHRequest(const uchar* packet, UINT size);
	void			ProcessAICHFileHash(CSafeMemFile* data, CPartFile* file);

	EUtf8Str		GetUnicodeSupport() const;

	CString			GetDownloadStateDisplayString() const;
	CString			GetUploadStateDisplayString() const;

	LPCTSTR			DbgGetDownloadState() const;
	LPCTSTR			DbgGetUploadState() const;
	LPCTSTR			DbgGetKadState() const;
	CString			DbgGetClientInfo(bool bFormatIP = false) const;
	CString			DbgGetFullClientSoftVer() const;
	const CString&	DbgGetHelloInfo() const							{ return m_strHelloInfo; }
	const CString&	DbgGetMuleInfo() const							{ return m_strMuleInfo; }

// ZZ:DownloadManager -->
    const bool      IsInNoNeededList(const CPartFile* fileToCheck) const;
    const bool      SwapToRightFile(CPartFile* SwapTo, CPartFile* cur_file, bool ignoreSuspensions, bool SwapToIsNNPFile, bool isNNPFile, bool& wasSkippedDueToSourceExchange, bool doAgressiveSwapping = false, bool debug = false);
    const DWORD     getLastTriedToConnectTime() { return m_dwLastTriedToConnect; }
	const DWORD     IsLastTriedToConnectTimeOk(DWORD dwTime) { return m_dwLastTriedToConnect == 0 || (::GetTickCount()-m_dwLastTriedToConnect > dwTime); } // NEO: DRT - [DownloadReaskTweaks] <-- Xanatos --
// <-- ZZ:DownloadManager

	const DWORD		GetLastUsableDownloadState() { return m_dwLastUsableDownloadState; } // NEO: SDT - [SourcesDropTweaks] <-- Xanatos --

	// NEO: TCR - [TCPConnectionRetry] -- Xanatos -->
	void			SetForDelete()										{ m_uFaildCount = (uint16)-1; }

	void			IncrementFaildCount()								{ m_uFaildCount++; } 
	void			ResetFaildCount()									{ m_uFaildCount = 0; } 
	uint16			GetFaildCount()										{ return m_uFaildCount; } 

	bool			IsSourceConfirmed()									{ return (m_dwUserIP != 0); }
	// NEO: TCR END <-- Xanatos --

	// NEO: MOD - [IsSurceSuspended] -- Xanatos -->
	bool			IsSurceSuspended() const{ 
						return m_nDownloadState == DS_CACHED // NEO: XSC - [ExtremeSourceCache]
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
							|| m_nDownloadState == DS_LOADED
#endif // NEO_SS // NEO: NSS END
					; }
	// NEO: MOD END <-- Xanatos --
	// NEO: MOD - [LastSeen] -- Xanatos -->
	void			SetLastSeen()										{ m_uLastSeen = time(NULL); } 
	uint32			GetLastSeen() const									{ return m_uLastSeen; } // in secounds !!!
	// NEO: MOD END <-- Xanatos --

#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
	bool			IsLanClient() const									{ return m_bLanClient; }
#endif //LANCAST // NEO: NLC END <-- Xanatos --

	// NEO: RIC - [ReaskOnIDChange] -- Xanatos -->
	bool			NotifyIdChage(); 
	bool			WaitingNotifyIdChage()								{ return m_bWainingNotifyIdChage; }
	// NEO: RIC END <-- Xanatos --

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	void			StoreToFile(CFileDataIO* file);
	CPartFile*		CreateFromFile(CFileDataIO* file);

	bool			IsLongTermStorred();
#endif // NEO_SS // NEO: NSS END <-- Xanatos --

#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] -- Xanatos -->
	CKnownSource*	Source()											{ return source; }
	void			LinkSource(CKnownSource* Source);
	void			AttachSource(CKnownSource* Source);
#endif // NEO_CD // NEO: NCD END <-- Xanatos --

	// NEO: NMP - [NeoModProt] -- Xanatos -->
	void			ClearModInfoProperties();
	void			SendModInfoPacket();
	void			ProcessModInfoPacket(const uchar* pachPacket, uint32 nSize);

	bool			SupportsModProt() const							{ return m_fSupportsModProt; } 
	bool			SupportsNeoXS() const							{ return m_fSupportNeoXS; } // NEO: NXS - [NeoXS]
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	void			SetNatTraversalSupport(bool bVal, bool bKad = false, bool bSvr = false) { 
						m_fSupportsNatTraversal = bVal; 
						if(bKad) 
							m_bNeoKadNatT = true; 
						if(bSvr) 
							m_bSvrNatT = true;
					}
	bool			SupportsNatTraversal(bool bKad = false) const	{ return (m_fSupportsNatTraversal || m_bSvrNatT) && (!bKad || m_bNeoKadNatT); }
	// NEO: XSB - [XSBuddy]
	void			SetXsBuddyStatus(EXsBuddy Status)				{ m_nXsBuddyStatus = (_EXsBuddy)Status; }
	EXsBuddy		GetXsBuddyStatus() const						{ return (EXsBuddy) m_nXsBuddyStatus; }

	void			SetXsBuddyIP( uint32 val )						{ m_nXsBuddyIP = val; }
	uint32			GetXsBuddyIP() const							{ return m_nXsBuddyIP; }
	void			SetXsBuddyPort( uint16 val )					{ m_nXsBuddyPort = val; }
	uint16			GetXsBuddyPort() const							{ return m_nXsBuddyPort; }
	// NEO: XSB END
	bool			IsCallback(bool bReask = false);
#endif //NATTUNNELING // NEO: NATT END

	bool			IsExtendedComments() const						{ return m_fExtendedComments; }  // NEO: XC - [ExtendedComments]

	// NEO: L2HAC - [LowID2HighIDAutoCallback]
	bool			SupportsL2HAC() const							{ return m_fSupportL2HAC; } 
	bool			CanDoL2HAC() const								{ return m_dwNextL2HACTime < ::GetTickCount(); }
	void			SetNextL2HAC(uint32 next) 						{ m_dwNextL2HACTime = (::GetTickCount() + next); }
	// NEO: L2HAC END

	bool			IsLowIDUDPPingSupport() const					{ return m_fLowIDUDPPingSupport; } 
	bool			SupportUnsolicitedPartStatus() const			{ return m_fUnsolicitedPartStatus; } 

	bool			SupportsSubChunks() const						{ return m_fSubChunksSupport; } // NEO: SCT - [SubChunkTransfer]
	uint8			GetIncompletePartVersion() const				{ return m_fIncompletePartVer2 ? 2 : m_fIncompletePartVer1 ? 1 : 0; } // NEO: ICS - [InteligentChunkSelection]
	bool			SupportsExtUDPStatus() const					{ return m_fExtendedUDPStatus; }
	// NEO: NMP END <-- Xanatos --
	
	// Note: This is for ICSv1 BAckwards compatybility
	void			SendLegacyICSStatus(CKnownFile* file); // NEO: ICS - [InteligentChunkSelection] <-- Xanatos --

	// NEO: NMPm - [WriteModMultiPacket] -- Xanatos -->
	void			WriteModMultiPacket(CSafeMemFile* data_out, CKnownFile* file, bool bReq, bool bUDP = false);
	void			ReadModMultiPacket(CSafeMemFile* data_in, CKnownFile* file, uint8 opcode = 0);
	// NEO: NMPm END <-- Xanatos --

	// NEO: NXS - [NeoXS] -- Xanatos -->
	void			WriteNeoXSTags(CSafeMemFile* data) const;
	struct tNeoXSTags {
		tNeoXSTags() {Clear();}
		void Clear();
		void Attach(CUpDownClient* newcleint);

		bool bEmpty;

		uint32 dwServerIP;
		uint16 nServerPort;

		bool bBuddyID;
		uchar abyBuddyID[16];
		uint32 dwBuddyIP;
		uint16 nBuddyPort;

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
		uint8 uSupportsNatTraversal;
		// NEO: XSB - [XSBuddy]
		uint32 dwXsBuddyIP;
		uint16 nXsBuddyPort;
		// NEO: XSB END
#endif //NATTUNNELING // NEO: NATT END

		uint8 byCryptOptions;
	};
	static void		ReadNeoXSTags(CSafeMemFile* data, tNeoXSTags* NeoXSTags);
	// NEO: NXS END <-- Xanatos --

#ifdef NATTUNNELING // NEO: XSB - [XSBuddy] -- Xanatos -->
	void			SendXsBuddyRequest();
#endif //NATTUNNELING // NEO: XSB END <-- Xanatos --

#ifdef NATTUNNELING // NEO: RTP - [ReuseTCPPort] -- Xanatos -->
	// We try to reuse our incomming socket for outgoing communication to bypass some NAT Typet over TCP, therefor we need to know our extern port
	void			SendPublicPortRequest();
	void			ProcessPublicPortAnswer(const BYTE* pbyData, UINT uSize);
#endif //NATTUNNELING // NEO: RTP END <-- Xanatos --

#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
	void			IncXSReqs()		{m_uXSReqs++;}
	void			IncXSAnswer()	{m_uXSAnswer++;}
	bool			CheckXSAsk();
#endif // ARGOS // NEO: NA END <-- Xanatos --

	// NEO: MID - [ModID] -- Xanatos -->
	EModClient	GetMod() const	{ return (EModClient)m_nModClient; } 
	void		DetectMod();
	// NEO: MID END <-- Xanatos --

#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
	CString			GetCountryName(bool longName = false) const;
	int				GetCountryFlagIndex() const;
	void			ResetIP2Country(uint32 dwIP = 0);
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --

#ifdef NEWTOOLTIPS // NEO: NTT - [NewToolTips] -- Xanatos -->
	void GetTooltipBaseInfo(CString &info);
	void GetTooltipDownloadInfo(CString &info, bool a4af, CPartFile* file = NULL, bool base = true);
	void GetTooltipUploadInfo(CString &info, bool base = true);
	void GetTooltipQueueInfo(CString &info, bool base = true);
	void GetTooltipClientInfo(CString &info);
#endif // NEWTOOLTIPS // NEO: NTT END <-- Xanatos --

#ifdef _DEBUG
	// Diagnostic Support
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	CClientReqSocket* socket;
	CClientCredits*	credits;
	CFriend*		m_Friend;
	//uint8*			m_abyUpPartStatus; // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
	CTypedPtrList<CPtrList, CPartFile*> m_OtherRequests_list;
	CTypedPtrList<CPtrList, CPartFile*> m_OtherNoNeeded_list;
	uint16			m_lastPartAsked;
	//bool			m_bAddNextConnect; // NEO: MOD - [NewUploadState] <-- Xanatos --
	CStringList		m_Dirs2Update; // NEO: XSF - [ExtendedSharedFiles] <-- Xanatos --

#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
	CEMSocket*		GetFileDownloadSocket(bool bLog = false);
#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --
#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
	bool			HaveTrickleSlot() const;
#else
    void			SetSlotNumber(UINT newValue)					{ m_slotNumber = newValue; }
    UINT			GetSlotNumber() const							{ return m_slotNumber; }
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --
	CEMSocket*		GetFileUploadSocket(bool log = false);

	///////////////////////////////////////////////////////////////////////////
	// PeerCache client
	//
	bool IsDownloadingFromPeerCache() const;
	bool IsUploadingToPeerCache() const;
	void SetPeerCacheDownState(EPeerCacheDownState eState);
	void SetPeerCacheUpState(EPeerCacheUpState eState);
#ifdef NEO_UBT // NEO: NUSM - [NeoUploadSlotManagement] -- Xanatos -->
	bool HasCacheState() {return m_ePeerCacheUpState == PCUS_WAIT_CACHE_REPLY || m_ePeerCacheUpState == PCUS_UPLOADING;} 
#endif // NEO_UBT // NEO: NUSM END <-- Xanatos --

	int  GetHttpSendState() const									{ return m_iHttpSendState; }
	void SetHttpSendState(int iState)								{ m_iHttpSendState = iState; }

	bool SendPeerCacheFileRequest();
	bool ProcessPeerCacheQuery(const uchar* packet, UINT size);
	bool ProcessPeerCacheAnswer(const uchar* packet, UINT size);
	bool ProcessPeerCacheAcknowledge(const uchar* packet, UINT size);
	void OnPeerCacheDownSocketClosed(int nErrorCode);
	bool OnPeerCacheDownSocketTimeout();
	
	bool ProcessPeerCacheDownHttpResponse(const CStringAArray& astrHeaders);
	bool ProcessPeerCacheDownHttpResponseBody(const BYTE* pucData, UINT uSize);
	void ProcessPeerCacheUpHttpResponse(const CStringAArray& astrHeaders);
	UINT ProcessPeerCacheUpHttpRequest(const CStringAArray& astrHeaders);

	virtual bool ProcessHttpDownResponse(const CStringAArray& astrHeaders);
	virtual bool ProcessHttpDownResponseBody(const BYTE* pucData, UINT uSize);

	CPeerCacheDownSocket* m_pPCDownSocket;
	CPeerCacheUpSocket* m_pPCUpSocket;

protected:
	int		m_iHttpSendState;
	uint32	m_uPeerCacheDownloadPushId;
	uint32	m_uPeerCacheUploadPushId;
	uint32	m_uPeerCacheRemoteIP;
	bool	m_bPeerCacheDownHit;
	bool	m_bPeerCacheUpHit;
	EPeerCacheDownState m_ePeerCacheDownState;
	EPeerCacheUpState m_ePeerCacheUpState;

protected:
	// base
	void	Init();
	bool	ProcessHelloTypePacket(CSafeMemFile* data);
	void	SendHelloTypePacket(CSafeMemFile* data);
	void	CreateStandartPackets(byte* data, UINT togo, Requested_Block_Struct* currentblock, bool bFromPF = true);
	void	CreatePackedPackets(byte* data, UINT togo, Requested_Block_Struct* currentblock, bool bFromPF = true);

	uint32	m_nConnectIP;		// holds the supposed IP or (after we had a connection) the real IP
	uint32	m_dwUserIP;			// holds 0 (real IP not yet available) or the real IP (after we had a connection)
	uint32	m_dwServerIP;
	uint32	m_nUserIDHybrid;
	uint16	m_nUserPort;
	uint16	m_nServerPort;
	UINT	m_nClientVersion;
	//--group to aligned int32
	uint8	m_byEmuleVersion;
	uint8	m_byDataCompVer;
	bool	m_bEmuleProtocol;
	bool	m_bIsHybrid;
	//--group to aligned int32
	TCHAR*	m_pszUsername;
	uchar	m_achUserHash[16];
	uint16	m_nUDPPort;
	uint16	m_nKadPort;
	//--group to aligned int32
	uint8	m_byUDPVer;
	uint8	m_bySourceExchange1Ver;
	uint8	m_byAcceptCommentVer;
	uint8	m_byExtendedRequestsVer;
	//--group to aligned int32
	uint8	m_byCompatibleClient;
	bool	m_bFriendSlot;
	bool	m_bCommentDirty;
	bool	m_bIsML;
	//--group to aligned int32
	bool	m_bGPLEvildoer;
	//bool	m_bHelloAnswerPending;
	uint8	m_byHelloPacketState; // NEO: FCC - [FixConnectionCollision] <-- Xanatos --
	uint8	m_byInfopacketsReceived;	// have we received the edonkeyprot and emuleprot packet already (see InfoPacketsReceived() )
	uint8	m_bySupportSecIdent;
	//--group to aligned int32
	uint32	m_dwLastSignatureIP;
	CString m_strClientSoftware;
	CString m_strModVersion;
	uint32	m_dwLastSourceRequest;
	uint32	m_dwLastSourceAnswer;
	uint32	m_dwLastAskedForSources;
    int     m_iFileListRequested;
	// NEO: XSF - [ExtendedSharedFiles] -- Xanatos -->
	bool	m_bRequestingFileList;
	bool	m_bFileListRequested;
	bool	m_bDeniesShare;
	CRBMap<CString, bool>	m_listDirs;
	CList<CSearchFile *>	m_listFiles;
	// NEO: XSF END <-- Xanatos --
	// NEO: SCFS - [SmartClientFileStatus] -- Xanatos --
	//CString	m_strFileComment;
	//--group to aligned int32
	//uint8	m_uFileRating;
	uint8	m_cMessagesReceived;		// count of chatmessages he sent to me
	uint8	m_cMessagesSent;			// count of chatmessages I sent to him
	bool	m_bMultiPacket;
	//--group to aligned int32
	bool	m_bUnicodeSupport;
	bool	m_bBuddyIDValid;
	uint16	m_nBuddyPort;
	//--group to aligned int32
	uint32	m_nBuddyIP;
	uint32	m_dwLastBuddyPingPongTime;
	uchar	m_achBuddyID[16];
	CString m_strHelloInfo;
	CString m_strMuleInfo;
	uint8	m_byKadVersion;

	uint8	m_byFileRequestState; // NEO: USPS - [UnSolicitedPartStatus] <-- Xanatos --

#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
	bool	m_bLanClient;
#endif //LANCAST // NEO: NLC END <-- Xanatos --

	// NEO: RIC - [ReaskOnIDChange] -- Xanatos -->
	bool	m_bNotifyIdChage; 
	bool	m_bWainingNotifyIdChage;
	// NEO: RIC END <-- Xanatos --

	// NEO: NMP - [NeoModProt] -- Xanatos -->
	UINT m_fSupportsModProt			: 1,
		 m_fSupportL2HAC			: 1, // NEO: L2HAC - [LowID2HighIDAutoCallback]
		 m_fSupportNeoXS			: 1, // NEO: NXS - [NeoXS]
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
		 m_fSupportsNatTraversal	: 1,
#endif //NATTUNNELING // NEO: NATT END
		 m_fLowIDUDPPingSupport		: 1,
		 m_fUnsolicitedPartStatus	: 1,
		 m_fExtendedComments		: 1, // NEO: XC - [ExtendedComments]
		 // NEO: ICS - [InteligentChunkSelection]
		 m_fIncompletePartVer1		: 1,
		 m_fIncompletePartVer2		: 1,
		 // NEO: ICS END
		 m_fSubChunksSupport		: 1, // NEO: SCT - [SubChunkTransfer]
	     m_fExtendedUDPStatus		: 1;
	// NEO: NMP END <-- Xanatos --

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal] -- Xanatos -->
	bool m_bNeoKadNatT;
	bool m_bSvrNatT;
	
	bool m_NeedOurPublicPort; // NEO: RTP - [ReuseTCPPort]

	// NEO: XSB - [XSBuddy]
	_EXsBuddy m_nXsBuddyStatus; 
	uint32	m_nXsBuddyIP;
	uint16	m_nXsBuddyPort;
	// NEO: XSB END
#endif //NATTUNNELING // NEO: NATT END <-- Xanatos --

	uint32	m_dwNextL2HACTime; // NEO: L2HAC - [LowID2HighIDAutoCallback] <-- Xanatos --

	// States
	_EClientSoftware	m_clientSoft;
	_EChatState			m_nChatstate;
	_EKadState			m_nKadState;
	_ESecureIdentState	m_SecureIdentState;
	_EUploadState		m_nUploadState;
	_EDownloadState		m_nDownloadState;
	_ESourceFrom		m_nSourceFrom;

	CTypedPtrList<CPtrList, Packet*> m_WaitingPackets_list;
	CList<PartFileStamp> m_DontSwap_list;

	////////////////////////////////////////////////////////////////////////
	// Upload
	//
    int GetFilePrioAsNumber() const;

	UINT		m_nTransferredUp;
	uint32		m_dwUploadTime;
	UINT		m_cAsked;
	uint32		m_dwLastUpRequest;
	UINT		m_nCurSessionUp;
	UINT		m_nCurSessionDown;
    UINT		m_nCurQueueSessionPayloadUp;
    UINT		m_addedPayloadQueueSession;
	// NEO: SCFS - [SmartClientFileStatus] -- Xanatos --
	//uint16		m_nUpPartCount;
	//uint16		m_nUpCompleteSourcesCount;
	uchar		requpfileid[16];
#if !defined(NEO_UBT) // NEO: NUBT - [NeoUploadBandwidthThrottler] <-- Xanatos --
    UINT		m_slotNumber;
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --
	bool		m_bUpEndSoon; // NEO: NUSM - [NeoUploadSlotManagement] <-- Xanatos --
	bool		m_bCollectionUploadSlot;

	typedef struct TransferredData {
		UINT	datalen;
		DWORD	timestamp;
	};
	CTypedPtrList<CPtrList, Requested_Block_Struct*> m_BlockRequests_queue;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> m_DoneBlocks_list;
	CTypedPtrList<CPtrList, Requested_File_Struct*>	 m_RequestedFiles_list;

	//////////////////////////////////////////////////////////
	// Download
	//
	CPartFile*	reqfile;
	CAICHHash*  m_pReqFileAICHHash; 
	UINT		m_cDownAsked;
	// NEO: SCFS - [SmartClientFileStatus] -- Xanatos --
	//uint8*		m_abyPartStatus;
	//CString		m_strClientFilename;
	UINT		m_nTransferredDown;
    UINT        m_nCurSessionPayloadDown;
	uint32		m_dwDownStartTime;
	uint64		m_nLastBlockOffset;
	uint32		m_dwLastBlockReceived;
	UINT		m_nTotalUDPPackets;
	UINT		m_nFailedUDPPackets;
	UINT		m_nRemoteQueueRank;
	UINT		m_nRemoteQueueRankOld; // NEO: CQR - [CollorQueueRank] <-- Xanatos --
	//--group to aligned int32
	//bool		m_bRemoteQueueFull;
	bool		m_bCompleteSource;
	uint16		m_nPartCount;
	//--group to aligned int32
	//uint16		m_cShowDR; // NEO: ASM - [AccurateSpeedMeasure] <-- Xanatos --
	bool		m_bReaskPending;
	bool		m_bUDPPending;
	bool		m_bTransferredDownMini;
	DWORD		m_dwLastUsableDownloadState; // NEO: SDT - [SourcesDropTweaks] <-- Xanatos --

	// Download from URL
	CStringA	m_strUrlPath;
	uint64		m_uReqStart;
	uint64		m_uReqEnd;
	uint64		m_nUrlStartPos;


	//////////////////////////////////////////////////////////
	// Upload data rate computation
	//
	UINT		m_nUpDatarate;
	UINT		m_nSumForAvgUpDataRate;
	CList<TransferredData> m_AvarageUDR_list;

	//////////////////////////////////////////////////////////
	// Download data rate computation
	//
	UINT		m_nDownDatarate;
	UINT		m_nDownDataRateMS;
	UINT		m_nSumForAvgDownDataRate;
	CList<TransferredData> m_AvarageDDR_list;

	//////////////////////////////////////////////////////////
	// GUI helpers
	//
	static CBarShader s_StatusBar;
	static CBarShader s_UpStatusBar;
	DWORD		m_lastRefreshedDLDisplay;
    DWORD		m_lastRefreshedULDisplay;
    uint32      m_random_update_wait;

	// using bitfield for less important flags, to save some bytes
	UINT m_fHashsetRequesting : 1, // we have sent a hashset request to this client in the current connection
		 m_fSharedDirectories : 1, // client supports OP_ASKSHAREDIRS opcodes
		 m_fSentCancelTransfer: 1, // we have sent an OP_CANCELTRANSFER in the current connection
		 m_fNoViewSharedFiles : 1, // client has disabled the 'View Shared Files' feature, if this flag is not set, we just know that we don't know for sure if it is enabled
		 m_fSupportsPreview   : 1,
		 m_fPreviewReqPending : 1,
		 m_fPreviewAnsPending : 1,
		 m_fIsSpammer		  : 1,
		 m_fMessageFiltered   : 1,
		 m_fPeerCache		  : 1,
		 m_fQueueRankPending  : 1,
		 m_fUnaskQueueRankRecv: 2,
		 m_fFailedFileIdReqs  : 4, // nr. of failed file-id related requests per connection
		 m_fNeedOurPublicIP	  : 1, // we requested our IP from this client
		 m_fSupportsAICH	  : 3,
		 m_fAICHRequested     : 1,
		 m_fSentOutOfPartReqs : 1,
		 m_fSupportsLargeFiles: 1,
		 m_fExtMultiPacket	  : 1,
		 m_fRequestsCryptLayer: 1,
	     m_fSupportsCryptLayer: 1,
		 m_fRequiresCryptLayer: 1,
		 m_fSupportsSourceEx2 : 1;

	CTypedPtrList<CPtrList, Pending_Block_Struct*>	 m_PendingBlocks_list;
	//CTypedPtrList<CPtrList, Requested_Block_Struct*> m_DownloadBlocks_list; // NEO: DBR - [DynamicBlockRequest] <-- Xanatos --

    bool    m_bSourceExchangeSwapped; // ZZ:DownloadManager
    DWORD   lastSwapForSourceExchangeTick; // ZZ:DownloadManaager
    //bool    DoSwap(CPartFile* SwapTo, bool bRemoveCompletely, LPCTSTR reason); // ZZ:DownloadManager
    CMap<CPartFile*, CPartFile*, DWORD, DWORD> m_fileReaskTimes; // ZZ:DownloadManager (one resk timestamp for each file)
	CMap<CCKey, const CCKey&, CClientFileStatus*, CClientFileStatus*> m_fileStatusMap; // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
    DWORD   m_dwLastTriedToConnect; // ZZ:DownloadManager (one resk timestamp for each file)
    bool    RecentlySwappedForSourceExchange() { return ::GetTickCount()-lastSwapForSourceExchangeTick < 30*1000; } // ZZ:DownloadManager
    void    SetSwapForSourceExchangeTick() { lastSwapForSourceExchangeTick = ::GetTickCount(); } // ZZ:DownloadManager

	bool	m_fUpIsProblematic; // NEO: UPC - [UploadingProblemClient] <-- Xanatos --

	bool	m_bDisableSwaping; // NEO: MCM - [ManualClientManagement] <-- Xanatos --

	DWORD	m_uSpreadReaskModyfier; // NEO: SR - [SpreadReask] <-- Xanatos --
	uint16	m_uFaildCount; // NEO: TCR - [TCPConnectionRetry] <-- Xanatos --

	uint32	m_uLastSeen; // NEO: MOD - [LastSeen] <-- Xanatos --

#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
	uint8		m_faileddownloads;

	uint16		m_uFastXSCounter;
	uint16		m_uXSReqs;
	uint16		m_uXSAnswer;
#endif // ARGOS // NEO: NA END <-- Xanatos --

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	void ClearTags();

	CArray<CTag*, CTag*> taglist;
#endif // NEO_SS // NEO: NSS END <-- Xanatos --

#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] -- Xanatos -->
	CKnownSource* source;
#endif // NEO_CD // NEO: NCD END <-- Xanatos --

	_EModClient         m_nModClient; // NEO: MID - [ModID] <-- Xanatos -- 

#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
	IPRange_Struct2* m_structUserCountry;
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --
};
//#pragma pack()
