//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once

// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
class CIni;
//#include "Neo/System/SecuredVars.h" 
#include "Neo/PrefFunctions.h"
// NEO: NCFG END <-- Xanatos --

const CString strDefaultToolbar = _T("0099010203040506070899091011");

enum EViewSharedFilesAccess{
	vsfaEverybody = 0,
	vsfaFriends = 1,
	vsfaNobody = 2,
	vsfaCommunity = 3 // NEO: NC - [NiceCommunity] <-- Xanatos --
};

enum ENotifierSoundType{
	ntfstNoSound = 0,
	ntfstSoundFile = 1,
	ntfstSpeech = 2
};

enum EToolbarLabelType;
enum ELogFileFormat;
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl] -- Xanatos -->
enum ePingMode;
#endif // NEO_BC // NEO: NBC END <-- Xanatos --

// DO NOT EDIT VALUES like making a uint16 to uint32, or insert any value. ONLY append new vars
#pragma pack(1)
struct Preferences_Ext_Struct{
	uint8	version;
	uchar	userhash[16];
	WINDOWPLACEMENT EmuleWindowPlacement;
};
#pragma pack()

// deadlake PROXYSUPPORT
struct ProxySettings{
	uint16 type;
	uint16 port;
	CStringA	name;
	CStringA	user;
	CStringA	password;
	bool EnablePassword;
	bool UseProxy;
};

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
#pragma pack(1)
struct CategoryViewFilter_Struct{
	//		General View Filters
	//int		nFromCats;  // 0 == All; 1 == Unassigned; 2 == This Cat Only
	int		nFromCats;  // 0 == All; 1 == All+This Cat Only; 2 == This Cat Only // Lit Cat Filter
	bool	bSuspendFilters;
	//		File Type View Filters
	bool	bVideo;
	bool	bAudio;
	bool	bArchives;
	bool	bImages;
	//		File State View Filters
	bool	bWaiting;
	bool	bTransferring;
	bool	bPaused;
	bool	bStopped;
	bool	bStandby; // NEO: SD - [StandByDL]
	bool	bSuspend; // NEO: SC - [SuspendCollecting]
	bool	bComplete;
	bool	bHashing;
	bool	bErrorUnknown;
	bool	bCompleting;
	bool	bSeenComplet; //MORPH - Added by SiRoB, Seen Complet filter
	//		File Size View Filters
	uint64	nFSizeMin;
	uint64	nFSizeMax;
	uint64	nRSizeMin;
	uint64	nRSizeMax;
	//		Time Remaining Filters
	uint32	nTimeRemainingMin;
	uint32	nTimeRemainingMax;
	//		Source Count Filters
	int		nSourceCountMin;
	int		nSourceCountMax;
	int		nAvailSourceCountMin;
	int		nAvailSourceCountMax;
	//		Advanced Filter Mask
	CString	sAdvancedFilterMask;
};
#pragma pack()

#pragma pack(1)
struct CategorySelectionCriteria_Struct{
	bool	bFileSize;
	bool	bAdvancedFilterMask;
};
#pragma pack()
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

#pragma pack(1)
struct Category_Struct{
	TCHAR	incomingpath[MAX_PATH];
	TCHAR	title[64];
	TCHAR	comment[255];
	DWORD	color;
	UINT	prio;
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	// NEO: NRT - [NeoReleaserTweaks]
	UINT	boost;
	bool	release;
	// NEO: NRT END

	TCHAR	temppath[MAX_PATH]; // NEO: MTD - [MultiTempDirectories]
	UINT	iAdvA4AFMode;
	bool	bResumeFileOnlyInSameCat; 
	BOOL    downloadInAlphabeticalOrder; // ZZ:DownloadManager

	CategoryViewFilter_Struct viewfilters;
	CategorySelectionCriteria_Struct selectioncriteria;
#else
	CString autocat;
	bool	ac_regexpeval;

	BOOL    downloadInAlphabeticalOrder; // ZZ:DownloadManager
	int		filter;
	bool	filterNeg;
	bool	care4all;

	CString	regexp;
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
};
#pragma pack()

// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
#define DEF_TEMPDIR 100
#define AUTO_TEMPDIR 255 
// NEO: MTD END <-- Xanatos --

class CPreferences
{
public:
	static	CString	strNick;
	// ZZ:UploadSpeedSense -->
#ifndef NEO_BC // NEO: NBC -- Xanatos -->
	static	uint16	minupload;
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
	// ZZ:UploadSpeedSense <--
	static	uint16	maxupload;
	static	uint16	maxdownload;
	static	uint16	port;
	static	uint16	udpport;
	static	uint16	kadport; // NEO: KAX - [KadAuxPort] <-- Xanatos --
	static	uint16	nServerUDPPort;
	static	UINT	maxconnections;
	static	UINT	maxhalfconnections;
	static	bool	m_bConditionalTCPAccept;
	static	bool	reconnect;
	static	bool	m_bUseServerPriorities;
	static	bool	m_bUseUserSortedServerList;
	static	TCHAR	incomingdir[MAX_PATH];
	static	TCHAR	tempdir[MAX_PATH]; // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
	static	bool	ICH;
	static	bool	m_bAutoUpdateServerList;
	static	bool	updatenotify;
	static	bool	mintotray;
	static	bool	autoconnect;
	static	bool	m_bAutoConnectToStaticServersOnly; // Barry
	static	bool	autotakeed2klinks;	   // Barry
	static	bool	addnewfilespaused;	   // Barry
	static	UINT	depth3D;			   // Barry
	//static	bool	m_bEnableMiniMule; // NEO: MM - [NeoMiniMule] <-- Xanatos --
	static	int		m_iStraightWindowStyles;
	static	bool	m_bRTLWindowsLayout;
	static	CString	m_strSkinProfile;
	static	CString	m_strSkinProfileDir;
	static	bool	m_bAddServersFromServer;
	static	bool	m_bAddServersFromClients;
	//static	uint16	maxsourceperfile; // NEO: NST - [NeoSourceTweaks] <-- Xanatos --
	static	UINT	trafficOMeterInterval;
	static	UINT	statsInterval;
	static	uchar	userhash[16];
	static	WINDOWPLACEMENT EmuleWindowPlacement;
	static	int		maxGraphDownloadRate;
	static	int		maxGraphUploadRate;
	static	uint32	maxGraphUploadRateEstimated;
	static	bool	beepOnError;
	static	bool	confirmExit;
	static	DWORD	m_adwStatsColors[41]; // NEO: MOD - [NeoStats] // NEO: CTB - [CoolToolBar] // NEO: NSTI - [NewSystemTrayIcon] <-- Xanatos --
	static  bool	m_bIconflashOnNewMessage;

	static	bool	splashscreen;
	static	bool	filterLANIPs;
	static	bool	m_bAllocLocalHostIP;
	static	bool	onlineSig;

	// -khaos--+++> Struct Members for Storing Statistics

	// Saved stats for cumulative downline overhead...
	static	uint64	cumDownOverheadTotal;
	static	uint64	cumDownOverheadFileReq;
	static	uint64	cumDownOverheadSrcEx;
	static	uint64	cumDownOverheadServer;
	static	uint64	cumDownOverheadKad;
	static	uint64	cumDownOverheadTotalPackets;
	static	uint64	cumDownOverheadFileReqPackets;
	static	uint64	cumDownOverheadSrcExPackets;
	static	uint64	cumDownOverheadServerPackets;
	static	uint64	cumDownOverheadKadPackets;

	// Saved stats for cumulative upline overhead...
	static	uint64	cumUpOverheadTotal;
	static	uint64	cumUpOverheadFileReq;
	static	uint64	cumUpOverheadSrcEx;
	static	uint64	cumUpOverheadServer;
	static	uint64	cumUpOverheadKad;
	static	uint64	cumUpOverheadTotalPackets;
	static	uint64	cumUpOverheadFileReqPackets;
	static	uint64	cumUpOverheadSrcExPackets;
	static	uint64	cumUpOverheadServerPackets;
	static	uint64	cumUpOverheadKadPackets;

	// Saved stats for cumulative upline data...
	static	uint32	cumUpSuccessfulSessions;
	static	uint32	cumUpFailedSessions;
	static	uint32	cumUpAvgTime;
	// Cumulative client breakdown stats for sent bytes...
	static	uint64	cumUpData_EDONKEY;
	static	uint64	cumUpData_EDONKEYHYBRID;
	static	uint64	cumUpData_EMULE;
	static	uint64	cumUpData_MLDONKEY;
	static	uint64	cumUpData_AMULE;
	static	uint64	cumUpData_EMULECOMPAT;
	static	uint64	cumUpData_SHAREAZA;
	// Session client breakdown stats for sent bytes...
	static	uint64	sesUpData_EDONKEY;
	static	uint64	sesUpData_EDONKEYHYBRID;
	static	uint64	sesUpData_EMULE;
	static	uint64	sesUpData_MLDONKEY;
	static	uint64	sesUpData_AMULE;
	static	uint64	sesUpData_EMULECOMPAT;
	static	uint64	sesUpData_SHAREAZA;

	// Cumulative port breakdown stats for sent bytes...
	static	uint64	cumUpDataPort_4662;
	static	uint64	cumUpDataPort_OTHER;
	static	uint64	cumUpDataPort_PeerCache;
	// Session port breakdown stats for sent bytes...
	static	uint64	sesUpDataPort_4662;
	static	uint64	sesUpDataPort_OTHER;
	static	uint64	sesUpDataPort_PeerCache;

	// Cumulative source breakdown stats for sent bytes...
	static	uint64	cumUpData_File;
	static	uint64	cumUpData_Partfile;
	// Session source breakdown stats for sent bytes...
	static	uint64	sesUpData_File;
	static	uint64	sesUpData_Partfile;

	// Saved stats for cumulative downline data...
	static	uint32	cumDownCompletedFiles;
	static	uint32	cumDownSuccessfulSessions;
	static	uint32	cumDownFailedSessions;
	static	uint32	cumDownAvgTime;

	// Cumulative statistics for saved due to compression/lost due to corruption
	static	uint64	cumLostFromCorruption;
	static	uint64	cumSavedFromCompression;
	static	uint32	cumPartsSavedByICH;

	// Session statistics for download sessions
	static	uint32	sesDownSuccessfulSessions;
	static	uint32	sesDownFailedSessions;
	static	uint32	sesDownAvgTime;
	static	uint32	sesDownCompletedFiles;
	static	uint64	sesLostFromCorruption;
	static	uint64	sesSavedFromCompression;
	static	uint32	sesPartsSavedByICH;

	// Cumulative client breakdown stats for received bytes...
	static	uint64	cumDownData_EDONKEY;
	static	uint64	cumDownData_EDONKEYHYBRID;
	static	uint64	cumDownData_EMULE;
	static	uint64	cumDownData_MLDONKEY;
	static	uint64	cumDownData_AMULE;
	static	uint64	cumDownData_EMULECOMPAT;
	static	uint64	cumDownData_SHAREAZA;
	static	uint64	cumDownData_URL;
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	static	uint64	cumDownData_WEBCACHE;
#endif // NEO: WC END <-- Xanatos --
	// Session client breakdown stats for received bytes...
	static	uint64	sesDownData_EDONKEY;
	static	uint64	sesDownData_EDONKEYHYBRID;
	static	uint64	sesDownData_EMULE;
	static	uint64	sesDownData_MLDONKEY;
	static	uint64	sesDownData_AMULE;
	static	uint64	sesDownData_EMULECOMPAT;
	static	uint64	sesDownData_SHAREAZA;
	static	uint64	sesDownData_URL;
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	static	uint64	sesDownData_WEBCACHE;
	static  uint32	ses_WEBCACHEREQUESTS;
	static	uint32	ses_successfull_WCDOWNLOADS;
	static  uint32	ses_PROXYREQUESTS;
	static  uint32	ses_successfullPROXYREQUESTS;
#endif // NEO: WC END <-- Xanatos --

	// Cumulative port breakdown stats for received bytes...
	static	uint64	cumDownDataPort_4662;
	static	uint64	cumDownDataPort_OTHER;
	static	uint64	cumDownDataPort_PeerCache;
	// Session port breakdown stats for received bytes...
	static	uint64	sesDownDataPort_4662;
	static	uint64	sesDownDataPort_OTHER;
	static	uint64	sesDownDataPort_PeerCache;

	// Saved stats for cumulative connection data...
	static	float	cumConnAvgDownRate;
	static	float	cumConnMaxAvgDownRate;
	static	float	cumConnMaxDownRate;
	static	float	cumConnAvgUpRate;
	static	float	cumConnMaxAvgUpRate;
	static	float	cumConnMaxUpRate;
	static	time_t	cumConnRunTime;
	static	uint32	cumConnNumReconnects;
	static	uint32	cumConnAvgConnections;
	static	uint32	cumConnMaxConnLimitReached;
	static	uint32	cumConnPeakConnections;
	static	uint32	cumConnTransferTime;
	static	uint32	cumConnDownloadTime;
	static	uint32	cumConnUploadTime;
	static	uint32	cumConnServerDuration;

	// Saved records for servers / network...
	static	uint32	cumSrvrsMostWorkingServers;
	static	uint32	cumSrvrsMostUsersOnline;
	static	uint32	cumSrvrsMostFilesAvail;

	// Saved records for shared files...
	static	uint32	cumSharedMostFilesShared;
	static	uint64	cumSharedLargestShareSize;
	static	uint64	cumSharedLargestAvgFileSize;
	static	uint64	cumSharedLargestFileSize;

	// Save the date when the statistics were last reset...
	static	time_t	stat_datetimeLastReset;

	// Save new preferences for PPgStats
	static	UINT	statsConnectionsGraphRatio; // This will store the divisor, i.e. for 1:3 it will be 3, for 1:20 it will be 20.
	static	UINT	statsMemoryGraphRatio; // NEO: SI - [SysInfo] <-- Xanatos --
	static	UINT	statsTransferGraphRatio; // NEO: SI - [SysInfo] <-- Xanatos --
	static	UINT	statsSourceGraphRatio; // NEO: SI - [SysInfo] <-- Xanatos --
	// Save the expanded branches of the stats tree
	static	TCHAR	statsExpandedTreeItems[256];

	static	UINT	statsSaveInterval;
	static  bool	m_bShowVerticalHourMarkers;
	// <-----khaos- End Statistics Members


	// Original Stats Stuff
	static	uint64	totalDownloadedBytes;
	static	uint64	totalUploadedBytes;
	// End Original Stats Stuff
	static	WORD	m_wLanguageID;
	static	bool	transferDoubleclick;
	static	EViewSharedFilesAccess m_iSeeShares;
	static	UINT	m_iToolDelayTime;	// tooltip delay time in seconds
	static	bool	bringtoforeground;
	static	UINT	splitterbarPosition;
	static	UINT	splitterbarPositionSvr;

	static	UINT	m_uTransferWnd1;
	static	UINT	m_uTransferWnd2;
	static	UINT	m_uLastCategory; // NEO: MAC - [MorphA4AFCategories] <-- Xanatos --
	//MORPH START - Added by SiRoB, Splitting Bar [O]
	static	UINT	splitterbarPositionStat;
	static	UINT	splitterbarPositionStat_HL;
	static	UINT	splitterbarPositionStat_HR;
	static	UINT	splitterbarPositionFriend;
	static	UINT	splitterbarPositionIRC;
	static	UINT	splitterbarPositionShared;
	//MORPH END - Added by SiRoB, Splitting Bar [O]
	static	UINT	m_uDeadServerRetries;
	static	DWORD	m_dwServerKeepAliveTimeout;
	// -khaos--+++> Changed data type to avoid overflows
	static	UINT	statsMax;
	// <-----khaos-
	static	UINT	statsAverageMinutes;

	static	CString	notifierConfiguration;
	static	bool	notifierOnDownloadFinished;
	static	bool	notifierOnNewDownload;
	static	bool	notifierOnChat;
	static	bool	notifierOnLog;
	static	bool	notifierOnImportantError;
	static	bool	notifierOnEveryChatMsg;
	static	bool	notifierOnNewVersion;
	static	ENotifierSoundType notifierSoundType;
	static	CString	notifierSoundFile;

	static	TCHAR	m_sircserver[50];
	static	TCHAR	m_sircnick[30];
	static	TCHAR	m_sircchannamefilter[50];
	static	bool	m_bircaddtimestamp;
	static	bool	m_bircusechanfilter;
	static	UINT	m_iircchanneluserfilter;
	static	TCHAR	m_sircperformstring[255];
	static	bool	m_bircuseperform;
	static	bool	m_birclistonconnect;
	static	bool	m_bircacceptlinks;
	static	bool	m_bircacceptlinksfriends;
	static	bool	m_bircsoundevents;
	static	bool	m_bircignoremiscmessage;
	static	bool	m_bircignorejoinmessage;
	static	bool	m_bircignorepartmessage;
	static	bool	m_bircignorequitmessage;
	static	bool	m_bircignoreemuleprotoaddfriend;
	static	bool	m_bircallowemuleprotoaddfriend;
	static	bool	m_bircignoreemuleprotosendlink;
	static	bool	m_birchelpchannel;

	static	bool	m_bRemove2bin;
	static	bool	m_bShowCopyEd2kLinkCmd;
	static	bool	m_bpreviewprio;
	static	bool	m_bSmartServerIdCheck;
	static	uint8	smartidstate;
	static	bool	m_bSafeServerConnect;
	static	UINT	startMinimized; // NEO: MOD <-- Xanatos --
	static	bool	m_bAutoStart;
	static	bool	m_bRestoreLastMainWndDlg;
	static	int		m_iLastMainWndDlgID;
	static	bool	m_bRestoreLastLogPane;
	static	int		m_iLastLogPaneID;
	static	UINT	MaxConperFive;
	static	bool	checkDiskspace;
	static	UINT	m_uMinFreeDiskSpace;
	static	bool	m_bSparsePartFiles;
	static	CString	m_strYourHostname;
	static	bool	m_bEnableVerboseOptions;
	static	bool	m_bVerbose;
	static	bool	m_bFullVerbose;
	static  int		m_byLogLevel;
	static	bool	m_bDebugSourceExchange; // Sony April 23. 2003, button to keep source exchange msg out of verbose log
	static	bool	m_bLogBannedClients;
	static	bool	m_bLogRatingDescReceived;
	static	bool	m_bLogSecureIdent;
	static	bool	m_bLogFilteredIPs;
	static	bool	m_bLogFileSaving;
    static  bool    m_bLogA4AF; // ZZ:DownloadManager
	static	bool	m_bLogUlDlEvents;
	static	bool	m_bLogAICHEvents; // NEO: MOD - [LogAICH] <-- Xanatos --
	static	bool	m_bUseDebugDevice;
	static	int		m_iDebugServerTCPLevel;
	static	int		m_iDebugServerUDPLevel;
	static	int		m_iDebugServerSourcesLevel;
	static	int		m_iDebugServerSearchesLevel;
	static	int		m_iDebugClientTCPLevel;
	static	int		m_iDebugClientUDPLevel;
	static	int		m_iDebugClientKadUDPLevel;
	static	int		m_iDebugSearchResultDetailLevel;
	static	bool	m_bupdatequeuelist;
	static	bool	m_bManualAddedServersHighPriority;
	static	bool	m_btransferfullchunks;
	static	int		m_istartnextfile;
	static	bool	m_bshowoverhead;
	static	bool	m_bDAP;
	static	bool	m_bUAP;
	static	bool	m_bDisableKnownClientList;
	static	bool	m_bDisableQueueList;
	static	bool	m_bExtControls;
	static	bool	m_bTransflstRemain;

	static	UINT	versioncheckdays;
	static	bool	showRatesInTitle;

	static	TCHAR	TxtEditor[MAX_PATH];
	static	CString	m_strVideoPlayer;
	static	CString	m_strVideoPlayerArgs;
	static	bool	moviePreviewBackup;
	static	int		m_iPreviewSmallBlocks;
	static	bool	m_bPreviewCopiedArchives;
	static	int		m_iInspectAllFileTypes;
	static	bool	m_bPreviewOnIconDblClk;
	static	bool	indicateratings;
	static	bool	watchclipboard;
	static	bool	filterserverbyip;
	static	bool	m_bFirstStart;
	static	bool	m_bCreditSystem;

	static	bool	log2disk;
	static	bool	debug2disk;
	static	int		iMaxLogBuff;
	static	UINT	uMaxLogFileSize;
	static	ELogFileFormat m_iLogFileFormat;
	static	bool	scheduler;
	static	bool	dontcompressblocks;	// NEO: MOD  <-- Xanatos --
	static	bool	dontcompressavi;
	static	bool	msgonlyfriends;
	static	bool	msgsecure;

	static	UINT	filterlevel;
	static	UINT	m_iFileBufferSize;
	static	UINT	m_iFileBufferTime; // NEO: MOD - [BufferCustomisation] <-- Xanatos --
	static	UINT	m_iQueueSize;
	static	int		m_iCommitFiles;

	static	UINT	maxmsgsessions;
	static	uint32	versioncheckLastAutomatic;
	static	CString	messageFilter;
	static	CString	commentFilter;
	static	CString	filenameCleanups;
	static	TCHAR	datetimeformat[64];
	static	TCHAR	datetimeformat4log[64];
	static	LOGFONT m_lfHyperText;
	static	LOGFONT m_lfLogText;
	static	COLORREF m_crLogError;
	static	COLORREF m_crLogWarning;
	static	COLORREF m_crLogSuccess;
	static	int		m_iExtractMetaData;
	static	bool	m_bAdjustNTFSDaylightFileTime;
	static  bool    m_bAllocFull;

	// Web Server [kuchin]
	static	bool	m_bAdvWebsrv; // NEO: WAM - [WebInterfaceAccountManagement] <-- Xanatos --
	static	TCHAR	m_sWebPassword[256];
	static	TCHAR	m_sWebLowPassword[256];
	static	uint16	m_nWebPort;
	static	bool	m_bWebEnabled;
	static	bool	m_bWebUseGzip;
	static	int		m_nWebPageRefresh;
	static	bool	m_bWebLowEnabled;
	static	TCHAR	m_sWebResDir[MAX_PATH];
	static	int		m_iWebTimeoutMins;
	static	int		m_iWebFileUploadSizeLimitMB;

	static	TCHAR	m_sTemplateFile[MAX_PATH];
	static	ProxySettings proxy; // deadlake PROXYSUPPORT
	static  bool	m_bAllowAdminHiLevFunc;
	static	CUIntArray m_aAllowedRemoteAccessIPs;

	static	UINT	showCatTabInfos; // NEO: MOD - [MoreCategoryInfo] <-- Xanatos --
	//static	bool	resumeSameCat;
	static	bool	dontRecreateGraphs;
	static	bool	autofilenamecleanup;
	//static	int		allcatType;
	//static	bool	allcatTypeNeg;
	static	bool	m_bUseAutocompl;
	static	UINT	m_uShowDwlPercentage; // NEO: MOD - [Percentage] <-- Xanatos --
	static	bool	m_bRemoveFinishedDownloads;
	static	UINT	m_iMaxChatHistory;
	static	bool	m_bShowActiveDownloadsBold;

	static	int		m_iSearchMethod;
	static	bool	m_bAdvancedSpamfilter;
	static	bool	m_bUseSecureIdent;
	// mobilemule
	static	TCHAR	m_sMMPassword[256];
	static	bool	m_bMMEnabled;
	static	uint16	m_nMMPort;

	static	bool	networkkademlia;
	static	bool	networked2k;

	// toolbar
	static	EToolbarLabelType m_nToolbarLabels;
	static	CString	m_sToolbarBitmap;
	static	CString	m_sToolbarBitmapFolder;
	static	CString	m_sToolbarSettings;
	static	bool	m_bReBarToolbar;
	static	CSize	m_sizToolbarIconSize;

	static	bool	m_bWinaTransToolbar;

	//preview
	//static	bool	m_bPreviewEnabled;
	static	bool	m_bAutomaticArcPreviewStart;

#ifndef NEO_BC // NEO: NBC -- Xanatos -->
	// ZZ:UploadSpeedSense -->
	static	bool	m_bDynUpEnabled;
	static	int		m_iDynUpPingTolerance;
	static	int		m_iDynUpGoingUpDivider;
	static	int		m_iDynUpGoingDownDivider;
	static	int		m_iDynUpNumberOfPings;
	static  int		m_iDynUpPingToleranceMilliseconds;
	static  bool	m_bDynUpUseMillisecondPingTolerance;
	// ZZ:UploadSpeedSense <--
#endif // NEO_BC // NEO: NBC END <-- Xanatos --

    static bool     m_bA4AFSaveCpu; // ZZ:DownloadManager

    static bool     m_bHighresTimer;

	static	CStringList shareddir_list;
	static	CStringList sharedsubdir_list; // NEO: SSD - [ShareSubDirectories] <-- Xanatos --
	static	CStringList sharedfile_list; // NEO: SSF - [ShareSingleFiles] <-- Xanatos --
	static	CStringList addresses_list;
	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	static	CStringList tempdir_list;
	static	int		use_tempdir;
	// NEO: MTD END <-- Xanatos --

	// NEO: VSF - [VirtualSharedFiles] -- Xanatos -->
	static	CRBMap<CString, CString> *GetFileToVDirMap()	{ return &m_fileToVDir_map; }
	static	CRBMap<CString, CString> *GetDirToVDirMap()		{ return &m_dirToVDir_map; }
	static	CRBMap<CString, CString> *GetSubDirToVDirMap()	{ return &m_dirToVDirWithSD_map; }
	// NEO: VSF END <-- Xanatos --

	static	int		m_iDbgHeap;
	static	UINT	m_nWebMirrorAlertLevel;
	static	bool	m_bRunAsUser;
	static	bool	m_bPreferRestrictedOverUser;

	static  UINT	m_uUseOldTimeRemaining; // NEO: MOD <-- Xanatos --
 
	// PeerCache
	static	uint32	m_uPeerCacheLastSearch;
	static	bool	m_bPeerCacheWasFound;
	static	bool	m_bPeerCacheEnabled;
	static	uint16	m_nPeerCachePort;
	static	bool	m_bPeerCacheShow;

	// Firewall settings
	//static bool		m_bOpenPortsOnStartUp; // NEO: IFWS <-- Xanatos --

	//AICH Options
	static bool		m_bTrustEveryHash;
	static bool		m_bRememberAICH; // NEO: MOD - [RemoveUnusedAICHhashes] <-- Xanatos --
	
	// files
	static bool		m_bRememberCancelledFiles;
	static bool		m_bRememberDownloadedFiles;

	//emil notifier
	static bool		m_bNotifierSendMail;
	static CString	m_strNotifierMailServer;
	static CString	m_strNotifierMailSender;
	static CString	m_strNotifierMailReceiver;

	// encryption / obfuscation
	static bool		m_bCryptLayerRequested;
	static bool		m_bCryptLayerSupported;
	static bool		m_bCryptLayerRequired;




	friend class CPreferencesWnd;
	friend class CPPgGeneral;
	friend class CPPgConnection;
	friend class CPPgServer;
	friend class CPPgDirectories;
	friend class CPPgFiles;
	friend class CPPgNotify;
	friend class CPPgIRC;
	friend class Wizard;
	friend class CPPgTweaks;
	friend class CPPgTweaks2; // NEO: MOD <-- Xanatos --
	friend class CPPgDisplay;
	friend class CPPgSecurity;
	friend class CPPgScheduler;
	friend class CPPgDebug;
	// NCFG - [NeoConfiguration] -- Xanatos -->
	friend class CPPgNeo;
	friend class CPPgRelease;
	friend class CPPgSources;
#if defined(NEO_SK) || defined(NEO_SS) || defined(NEO_CD) // ||defined(NEO_SA) // NEO: NSS - [NeoSourceStorage]
	friend class CPPgSourceStorage;
#endif // NEO: NSS END
#ifdef ARGOS // NEO: NA - [NeoArgos]
	friend class CPPgArgos;
#endif // ARGOS // NEO: NA END
	friend class CPPgNetwork;
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	friend class CPPgBandwidth;
#endif // NEO_BC // NEO: NBC END
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	friend class CPPgLancast;
#endif //LANCAST // NEO: NLC END
	friend class CPPgInterface;
	friend class CPPgVirtual;
	friend class CPPgUpdate; // NEO: AU - [AutoUpdate]
	// NEO: NCFG END <-- Xanatos --

	CPreferences();
	~CPreferences();

	static	void	Init();
	static	void	Uninit();

	static	const CString& GetAppDir()				{return appdir;}
	static	LPCTSTR GetIncomingDir()				{return incomingdir;}
	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	//static	LPCTSTR GetTempDir()					{return tempdir;}
	static	LPCTSTR GetTempDir(int id=0){
														if(id==DEF_TEMPDIR) 
															id = use_tempdir; 
														if(id==0 || id==AUTO_TEMPDIR || id>tempdir_list.GetCount()) 
															return tempdir; 
														return (LPCTSTR)tempdir_list.GetAt(tempdir_list.FindIndex( id-1 ));
													}
	static	int		GetTempDirCount()				{return tempdir_list.GetCount()+1;}
	static	int		GetUsedTempDir()				{return use_tempdir;}
	static	void	SetUsedTempDir(int id)		{use_tempdir = id;}
	// NEO: MTD - END <-- Xanatos --
	static	bool	CanFSHandleLargeFiles();
	static	const CString& GetConfigDir()				{return configdir;}
	static	LPCTSTR GetConfigFile();
	static	const CString& GetWebServerDir()			{return m_strWebServerDir;}
	static	const CString& GetFileCommentsFilePath()	{return m_strFileCommentsFilePath;}
	static	const CString& GetLogDir()					{return m_strLogDir;}

	//static	bool	IsTempFile(const CString& rstrDirectory, const CString& rstrName); // NEO: SSH - [SlugFillerSafeHash] <-- Xanatos --
	static	bool	IsConfigFile(const CString& rstrDirectory, const CString& rstrName);
	static	bool	IsShareableDirectory(const CString& rstrDirectory);
	static	bool	IsInstallationDirectory(const CString& rstrDir);

	static	bool	Save();
	static	void	SaveCats();

	static	bool	GetUseServerPriorities()			{return m_bUseServerPriorities;}
	static	bool	GetUseUserSortedServerList()		{return m_bUseUserSortedServerList;}
	static	bool	Reconnect()							{return reconnect;}
	static	const CString& GetUserNick()				{return strNick;}
	static	void	SetUserNick(LPCTSTR pszNick);
	static	int		GetMaxUserNickLength()				{return 50;}

	static	uint16	GetPort()							{return port;}
	static	uint16	GetUDPPort()						{return udpport;}
	static	uint16	GetKADPort()						{if(kadport == 0xFFFF) return udpport; return kadport;} // NEO: KAX - [KadAuxPort] <-- Xanatos --
	static	uint16	GetServerUDPPort()					{return nServerUDPPort;}
	static	uchar*	GetUserHash()						{return userhash;}
	// ZZ:UploadSpeedSense -->
#ifndef NEO_BC // NEO: NBC -- Xanatos -->
	static	uint16	GetMinUpload()						{return minupload;}
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
	// ZZ:UploadSpeedSense <--
	static	uint16	GetMaxUpload()						{return maxupload;}
	static	bool	IsICHEnabled()						{return ICH;}
	static	bool	GetAutoUpdateServerList()			{return m_bAutoUpdateServerList;}
	static	bool	UpdateNotify()						{return updatenotify;}
	static	bool	GetMinToTray()						{return mintotray;}
	static	bool	DoAutoConnect()						{return autoconnect;}
	static	void	SetAutoConnect(bool inautoconnect)	{autoconnect = inautoconnect;}
	static	bool	GetAddServersFromServer()			{return m_bAddServersFromServer;}
	static	bool	GetAddServersFromClients()			{return m_bAddServersFromClients;}
	static	bool*	GetMinTrayPTR()						{return &mintotray;}
	static	UINT	GetTrafficOMeterInterval()			{return trafficOMeterInterval;}
	static	void	SetTrafficOMeterInterval(UINT in)	{trafficOMeterInterval=in;}
	static	UINT	GetStatsInterval()					{return statsInterval;}
	static	void	SetStatsInterval(UINT in)			{statsInterval=in;}

	// -khaos--+++> Many, many, many, many methods.
	static	void	SaveStats(int bBackUp = 0);
	static	void	SetRecordStructMembers();
	static	void	SaveCompletedDownloadsStat();
	static	bool	LoadStats(int loadBackUp = 0);
	static	void	ResetCumulativeStatistics();

	static	void	Add2DownCompletedFiles()			{cumDownCompletedFiles++;}
	static	void	SetConnMaxAvgDownRate(float in)		{cumConnMaxAvgDownRate = in;}
	static	void	SetConnMaxDownRate(float in)		{cumConnMaxDownRate = in;}
	static	void	SetConnAvgUpRate(float in)			{cumConnAvgUpRate = in;}
	static	void	SetConnMaxAvgUpRate(float in)		{cumConnMaxAvgUpRate = in;}
	static	void	SetConnMaxUpRate(float in)			{cumConnMaxUpRate = in;}
	static	void	SetConnPeakConnections(int in)		{cumConnPeakConnections = in;}
	static	void	SetUpAvgTime(int in)				{cumUpAvgTime = in;}
	static	void	Add2DownSAvgTime(int in)			{sesDownAvgTime += in;}
	static	void	SetDownCAvgTime(int in)				{cumDownAvgTime = in;}
	static	void	Add2ConnTransferTime(int in)		{cumConnTransferTime += in;}
	static	void	Add2ConnDownloadTime(int in)		{cumConnDownloadTime += in;}
	static	void	Add2ConnUploadTime(int in)			{cumConnUploadTime += in;}
	static	void	Add2DownSessionCompletedFiles()		{sesDownCompletedFiles++;}
	static	void	Add2SessionTransferData				(UINT uClientID, UINT uClientPort, BOOL bFromPF, BOOL bUpDown, uint32 bytes, bool privatTransferred = false, bool releaseTransferred = false); // NEO: BM - [BandwidthModeration] // NEO: PTM - [PrivatTransferManagement] <-- Xanatos --
	static	void	Add2DownSuccessfulSessions()		{sesDownSuccessfulSessions++;
														 cumDownSuccessfulSessions++;}
	static	void	Add2DownFailedSessions()			{sesDownFailedSessions++;
														 cumDownFailedSessions++;}
	static	void	Add2LostFromCorruption(uint64 in)	{sesLostFromCorruption += in;}
	static	void	Add2SavedFromCompression(uint64 in) {sesSavedFromCompression += in;}
	static	void	Add2SessionPartsSavedByICH(int in)	{sesPartsSavedByICH += in;}

	// Saved stats for cumulative downline overhead
	static	uint64	GetDownOverheadTotal()				{return cumDownOverheadTotal;}
	static	uint64	GetDownOverheadFileReq()			{return cumDownOverheadFileReq;}
	static	uint64	GetDownOverheadSrcEx()				{return cumDownOverheadSrcEx;}
	static	uint64	GetDownOverheadServer()				{return cumDownOverheadServer;}
	static	uint64	GetDownOverheadKad()				{return cumDownOverheadKad;}
	static	uint64	GetDownOverheadTotalPackets()		{return cumDownOverheadTotalPackets;}
	static	uint64	GetDownOverheadFileReqPackets()		{return cumDownOverheadFileReqPackets;}
	static	uint64	GetDownOverheadSrcExPackets()		{return cumDownOverheadSrcExPackets;}
	static	uint64	GetDownOverheadServerPackets()		{return cumDownOverheadServerPackets;}
	static	uint64	GetDownOverheadKadPackets()			{return cumDownOverheadKadPackets;}

	// Saved stats for cumulative upline overhead
	static	uint64	GetUpOverheadTotal()				{return cumUpOverheadTotal;}
	static	uint64	GetUpOverheadFileReq()				{return cumUpOverheadFileReq;}
	static	uint64	GetUpOverheadSrcEx()				{return cumUpOverheadSrcEx;}
	static	uint64	GetUpOverheadServer()				{return cumUpOverheadServer;}
	static	uint64	GetUpOverheadKad()					{return cumUpOverheadKad;}
	static	uint64	GetUpOverheadTotalPackets()			{return cumUpOverheadTotalPackets;}
	static	uint64	GetUpOverheadFileReqPackets()		{return cumUpOverheadFileReqPackets;}
	static	uint64	GetUpOverheadSrcExPackets()			{return cumUpOverheadSrcExPackets;}
	static	uint64	GetUpOverheadServerPackets()		{return cumUpOverheadServerPackets;}
	static	uint64	GetUpOverheadKadPackets()			{return cumUpOverheadKadPackets;}

	// Saved stats for cumulative upline data
	static	uint32	GetUpSuccessfulSessions()			{return cumUpSuccessfulSessions;}
	static	uint32	GetUpFailedSessions()				{return cumUpFailedSessions;}
	static	uint32	GetUpAvgTime()						{return cumUpAvgTime;}

	// Saved stats for cumulative downline data
	static	uint32	GetDownCompletedFiles()				{return cumDownCompletedFiles;}
	static	uint32	GetDownC_SuccessfulSessions()		{return cumDownSuccessfulSessions;}
	static	uint32	GetDownC_FailedSessions()			{return cumDownFailedSessions;}
	static	uint32	GetDownC_AvgTime()					{return cumDownAvgTime;}
	
	// Session download stats
	static	uint32	GetDownSessionCompletedFiles()		{return sesDownCompletedFiles;}
	static	uint32	GetDownS_SuccessfulSessions()		{return sesDownSuccessfulSessions;}
	static	uint32	GetDownS_FailedSessions()			{return sesDownFailedSessions;}
	static	uint32	GetDownS_AvgTime()					{return GetDownS_SuccessfulSessions() ? sesDownAvgTime / GetDownS_SuccessfulSessions() : 0;}

	// Saved stats for corruption/compression
	static	uint64	GetCumLostFromCorruption()			{return cumLostFromCorruption;}
	static	uint64	GetCumSavedFromCompression()		{return cumSavedFromCompression;}
	static	uint64	GetSesLostFromCorruption()			{return sesLostFromCorruption;}
	static	uint64	GetSesSavedFromCompression()		{return sesSavedFromCompression;}
	static	uint32	GetCumPartsSavedByICH()				{return cumPartsSavedByICH;}
	static	uint32	GetSesPartsSavedByICH()				{return sesPartsSavedByICH;}

	// Cumulative client breakdown stats for sent bytes
	static	uint64	GetUpTotalClientData()				{return   GetCumUpData_EDONKEY()
																+ GetCumUpData_EDONKEYHYBRID()
																+ GetCumUpData_EMULE()
																+ GetCumUpData_MLDONKEY()
																+ GetCumUpData_AMULE()
																+ GetCumUpData_EMULECOMPAT()
																+ GetCumUpData_SHAREAZA();}
	static	uint64	GetCumUpData_EDONKEY()				{return (cumUpData_EDONKEY +		sesUpData_EDONKEY );}
	static	uint64	GetCumUpData_EDONKEYHYBRID()		{return (cumUpData_EDONKEYHYBRID +	sesUpData_EDONKEYHYBRID );}
	static	uint64	GetCumUpData_EMULE()				{return (cumUpData_EMULE +			sesUpData_EMULE );}
	static	uint64	GetCumUpData_MLDONKEY()				{return (cumUpData_MLDONKEY +		sesUpData_MLDONKEY );}
	static	uint64	GetCumUpData_AMULE()				{return (cumUpData_AMULE +			sesUpData_AMULE );}
	static	uint64	GetCumUpData_EMULECOMPAT()			{return (cumUpData_EMULECOMPAT +	sesUpData_EMULECOMPAT );}
	static	uint64	GetCumUpData_SHAREAZA()				{return (cumUpData_SHAREAZA +		sesUpData_SHAREAZA );}
	
	// Session client breakdown stats for sent bytes
	static	uint64	GetUpSessionClientData()			{return   sesUpData_EDONKEY 
																+ sesUpData_EDONKEYHYBRID 
																+ sesUpData_EMULE 
																+ sesUpData_MLDONKEY 
																+ sesUpData_AMULE
																+ sesUpData_EMULECOMPAT
																+ sesUpData_SHAREAZA;}
	static	uint64	GetUpData_EDONKEY()					{return sesUpData_EDONKEY;}
	static	uint64	GetUpData_EDONKEYHYBRID()			{return sesUpData_EDONKEYHYBRID;}
	static	uint64	GetUpData_EMULE()					{return sesUpData_EMULE;}
	static	uint64	GetUpData_MLDONKEY()				{return sesUpData_MLDONKEY;}
	static	uint64	GetUpData_AMULE()					{return sesUpData_AMULE;}
	static	uint64	GetUpData_EMULECOMPAT()				{return sesUpData_EMULECOMPAT;}
	static	uint64	GetUpData_SHAREAZA()				{return sesUpData_SHAREAZA;}

	// Cumulative port breakdown stats for sent bytes...
	static	uint64	GetUpTotalPortData()				{return   GetCumUpDataPort_4662() 
																+ GetCumUpDataPort_OTHER()
																+ GetCumUpDataPort_PeerCache();}
	static	uint64	GetCumUpDataPort_4662()				{return (cumUpDataPort_4662 +		sesUpDataPort_4662 );}
	static	uint64	GetCumUpDataPort_OTHER()			{return (cumUpDataPort_OTHER +		sesUpDataPort_OTHER );}
	static	uint64	GetCumUpDataPort_PeerCache()		{return (cumUpDataPort_PeerCache +	sesUpDataPort_PeerCache );}

	// Session port breakdown stats for sent bytes...
	static	uint64	GetUpSessionPortData()				{return   sesUpDataPort_4662 
																+ sesUpDataPort_OTHER
																+ sesUpDataPort_PeerCache;}
	static	uint64	GetUpDataPort_4662()				{return sesUpDataPort_4662;}
	static	uint64	GetUpDataPort_OTHER()				{return sesUpDataPort_OTHER;}
	static	uint64	GetUpDataPort_PeerCache()			{return sesUpDataPort_PeerCache;}

	// Cumulative DS breakdown stats for sent bytes...
	static	uint64	GetUpTotalDataFile()				{return (GetCumUpData_File() +		GetCumUpData_Partfile() );}
	static	uint64	GetCumUpData_File()					{return (cumUpData_File +			sesUpData_File );}
	static	uint64	GetCumUpData_Partfile()				{return (cumUpData_Partfile +		sesUpData_Partfile );}
	// Session DS breakdown stats for sent bytes...
	static	uint64	GetUpSessionDataFile()				{return (sesUpData_File +			sesUpData_Partfile );}
	static	uint64	GetUpData_File()					{return sesUpData_File;}
	static	uint64	GetUpData_Partfile()				{return sesUpData_Partfile;}

	// Cumulative client breakdown stats for received bytes
	static	uint64	GetDownTotalClientData()			{return   GetCumDownData_EDONKEY() 
																+ GetCumDownData_EDONKEYHYBRID() 
																+ GetCumDownData_EMULE() 
																+ GetCumDownData_MLDONKEY() 
																+ GetCumDownData_AMULE()
																+ GetCumDownData_EMULECOMPAT()
																+ GetCumDownData_SHAREAZA()
																+ GetCumDownData_URL()
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
															 + GetCumDownData_WEBCACHE()
#endif // NEO: WC END <-- Xanatos --
															 ; }
	static	uint64	GetCumDownData_EDONKEY()			{return (cumDownData_EDONKEY +			sesDownData_EDONKEY);}
	static	uint64	GetCumDownData_EDONKEYHYBRID()		{return (cumDownData_EDONKEYHYBRID +	sesDownData_EDONKEYHYBRID);}
	static	uint64	GetCumDownData_EMULE()				{return (cumDownData_EMULE +			sesDownData_EMULE);}
	static	uint64	GetCumDownData_MLDONKEY()			{return (cumDownData_MLDONKEY +			sesDownData_MLDONKEY);}
	static	uint64	GetCumDownData_AMULE()				{return (cumDownData_AMULE +			sesDownData_AMULE);}
	static	uint64	GetCumDownData_EMULECOMPAT()		{return (cumDownData_EMULECOMPAT +		sesDownData_EMULECOMPAT);}
	static	uint64	GetCumDownData_SHAREAZA()			{return (cumDownData_SHAREAZA +			sesDownData_SHAREAZA);}
	static	uint64	GetCumDownData_URL()				{return (cumDownData_URL +				sesDownData_URL);}
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	static	uint64	GetCumDownData_WEBCACHE()			{ return (cumDownData_WEBCACHE +		sesDownData_WEBCACHE);} //jp webcache statistics
#endif // NEO: WC END <-- Xanatos --
	// Session client breakdown stats for received bytes
	static	uint64	GetDownSessionClientData()			{return   sesDownData_EDONKEY 
																+ sesDownData_EDONKEYHYBRID 
																+ sesDownData_EMULE 
																+ sesDownData_MLDONKEY 
																+ sesDownData_AMULE
																+ sesDownData_EMULECOMPAT
																+ sesDownData_SHAREAZA
																+ sesDownData_URL
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
																+ sesDownData_WEBCACHE
#endif // NEO: WC END <-- Xanatos --
															 ; }
	static	uint64	GetDownData_EDONKEY()				{return sesDownData_EDONKEY;}
	static	uint64	GetDownData_EDONKEYHYBRID()			{return sesDownData_EDONKEYHYBRID;}
	static	uint64	GetDownData_EMULE()					{return sesDownData_EMULE;}
	static	uint64	GetDownData_MLDONKEY()				{return sesDownData_MLDONKEY;}
	static	uint64	GetDownData_AMULE()					{return sesDownData_AMULE;}
	static	uint64	GetDownData_EMULECOMPAT()			{return sesDownData_EMULECOMPAT;}
	static	uint64	GetDownData_SHAREAZA()				{return sesDownData_SHAREAZA;}
	static	uint64	GetDownData_URL()					{return sesDownData_URL;}
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	static	uint64	GetDownData_WEBCACHE()				{ return sesDownData_WEBCACHE;} //jp webcache statistics
#endif // NEO: WC END <-- Xanatos --

	// Cumulative port breakdown stats for received bytes...
	static	uint64	GetDownTotalPortData()				{return   GetCumDownDataPort_4662() 
																+ GetCumDownDataPort_OTHER()
																+ GetCumDownDataPort_PeerCache();}
	static	uint64	GetCumDownDataPort_4662()			{return cumDownDataPort_4662		+ sesDownDataPort_4662;}
	static	uint64	GetCumDownDataPort_OTHER()			{return cumDownDataPort_OTHER		+ sesDownDataPort_OTHER;}
	static	uint64	GetCumDownDataPort_PeerCache()		{return cumDownDataPort_PeerCache	+ sesDownDataPort_PeerCache;}

	// Session port breakdown stats for received bytes...
	static	uint64	GetDownSessionDataPort()			{return   sesDownDataPort_4662 
																+ sesDownDataPort_OTHER
																+ sesDownDataPort_PeerCache;}
	static	uint64	GetDownDataPort_4662()				{return sesDownDataPort_4662;}
	static	uint64	GetDownDataPort_OTHER()				{return sesDownDataPort_OTHER;}
	static	uint64	GetDownDataPort_PeerCache()			{return sesDownDataPort_PeerCache;}

	// Saved stats for cumulative connection data
	static	float	GetConnAvgDownRate()				{return cumConnAvgDownRate;}
	static	float	GetConnMaxAvgDownRate()				{return cumConnMaxAvgDownRate;}
	static	float	GetConnMaxDownRate()				{return cumConnMaxDownRate;}
	static	float	GetConnAvgUpRate()					{return cumConnAvgUpRate;}
	static	float	GetConnMaxAvgUpRate()				{return cumConnMaxAvgUpRate;}
	static	float	GetConnMaxUpRate()					{return cumConnMaxUpRate;}
	static	time_t	GetConnRunTime()					{return cumConnRunTime;}
	static	uint32	GetConnNumReconnects()				{return cumConnNumReconnects;}
	static	uint32	GetConnAvgConnections()				{return cumConnAvgConnections;}
	static	uint32	GetConnMaxConnLimitReached()		{return cumConnMaxConnLimitReached;}
	static	uint32	GetConnPeakConnections()			{return cumConnPeakConnections;}
	static	uint32	GetConnTransferTime()				{return cumConnTransferTime;}
	static	uint32	GetConnDownloadTime()				{return cumConnDownloadTime;}
	static	uint32	GetConnUploadTime()					{return cumConnUploadTime;}
	static	uint32	GetConnServerDuration()				{return cumConnServerDuration;}

	// Saved records for servers / network
	static	uint32	GetSrvrsMostWorkingServers()		{return cumSrvrsMostWorkingServers;}
	static	uint32	GetSrvrsMostUsersOnline()			{return cumSrvrsMostUsersOnline;}
	static	uint32	GetSrvrsMostFilesAvail()			{return cumSrvrsMostFilesAvail;}

	// Saved records for shared files
	static	uint32	GetSharedMostFilesShared()			{return cumSharedMostFilesShared;}
	static	uint64	GetSharedLargestShareSize()			{return cumSharedLargestShareSize;}
	static	uint64	GetSharedLargestAvgFileSize()		{return cumSharedLargestAvgFileSize;}
	static	uint64	GetSharedLargestFileSize()			{return cumSharedLargestFileSize;}

	// Get the long date/time when the stats were last reset
	static	time_t GetStatsLastResetLng()				{return stat_datetimeLastReset;}
	static	CString GetStatsLastResetStr(bool formatLong = true);
	static	UINT	GetStatsSaveInterval()				{return statsSaveInterval;}

	// Get and Set our new preferences
	static	void	SetStatsMax(UINT in)				{statsMax = in;}
	static	void	SetStatsConnectionsGraphRatio(UINT in) {statsConnectionsGraphRatio = in;}
	static	UINT	GetStatsConnectionsGraphRatio()		{return statsConnectionsGraphRatio;}
	static	void	SetStatsMemoryGraphRatio(UINT in)	{ statsMemoryGraphRatio = in; } // NEO: SI - [SysInfo] <-- Xanatos --
	static	UINT	GetStatsMemoryGraphRatio()			{ return statsMemoryGraphRatio; } // NEO: SI - [SysInfo] <-- Xanatos --
	static	void	SetStatsTransferGraphRatio(UINT in)	{ statsTransferGraphRatio = in; } // NEO: SI - [SysInfo] <-- Xanatos --
	static	UINT	GetStatsTransferGraphRatio()		{ return statsTransferGraphRatio; } // NEO: SI - [SysInfo] <-- Xanatos --
	static	void	SetStatsSourceGraphRatio(UINT in)	{ statsSourceGraphRatio = in; } // NEO: SI - [SysInfo] <-- Xanatos --
	static	UINT	GetStatsSourceGraphRatio()			{ return statsSourceGraphRatio; } // NEO: SI - [SysInfo] <-- Xanatos --

	static	void	SetExpandedTreeItems(CString in)	{_stprintf(statsExpandedTreeItems,_T("%s"),in);}
	static	CString GetExpandedTreeItems()				{return statsExpandedTreeItems;}

	static	uint64	GetTotalDownloaded()				{return totalDownloadedBytes;}
	static	uint64	GetTotalUploaded()					{return totalUploadedBytes;}

	static	bool	IsErrorBeepEnabled()				{return beepOnError;}
	static	bool	IsConfirmExitEnabled()				{return confirmExit;}
	static	bool	UseSplashScreen()					{return splashscreen;}
	static	bool	FilterLANIPs()						{return filterLANIPs;}
	static	bool	GetAllowLocalHostIP()				{return m_bAllocLocalHostIP;}
	static	bool	IsOnlineSignatureEnabled()			{return onlineSig;}
	static	int		GetMaxGraphUploadRate(bool bEstimateIfUnlimited);
	static	int		GetMaxGraphDownloadRate()			{return maxGraphDownloadRate;}
	static	void	SetMaxGraphUploadRate(int in);
	static	void	SetMaxGraphDownloadRate(int in)		{maxGraphDownloadRate=(in)?in:96;}

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl] -- Xanatos -->
	static	uint16	GetMaxDownload()			{return maxdownload;}
#else
	static	uint16	GetMaxDownload();
	static	uint64	GetMaxDownloadInBytesPerSec(bool dynamic = false);
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
	// NEO: QS - [QuickStart] -- Xanatos --
	//static	UINT	GetMaxConnections()					{return maxconnections;}
	//static	UINT	GetMaxHalfConnections()				{return maxhalfconnections;}
	//static	UINT	GetMaxSourcePerFileDefault()		{return maxsourceperfile;} // NEO: NST - [NeoSourceTweaks] <-- Xanatos --
	static	UINT	GetDeadServerRetries()		{return m_uDeadServerRetries;}
	static	DWORD	GetServerKeepAliveTimeout() {return m_dwServerKeepAliveTimeout;}
	static	bool	GetConditionalTCPAccept()	{return m_bConditionalTCPAccept;}

	static	WORD	GetLanguageID();
	static	void	SetLanguageID(WORD lid);
	static	void	GetLanguages(CWordArray& aLanguageIDs);
	static	void	SetLanguage();
	static	const CString& GetLangDir()					{return m_strLangDir;}
	static	bool	IsLanguageSupported(LANGID lidSelected, bool bUpdateBefore);
	static	CString GetLangDLLNameByID(LANGID lidSelected);
	static	void	InitThreadLocale();
	static	void	SetRtlLocale(LCID lcid);
	static	CString GetHtmlCharset();

	static	bool	IsDoubleClickEnabled()				{return transferDoubleclick;}
	static	EViewSharedFilesAccess CanSeeShares(void)	{return m_iSeeShares;}
	static	UINT	GetToolTipDelay(void)				{return m_iToolDelayTime;}
	static	bool	IsBringToFront()					{return bringtoforeground;}

	static	UINT	GetSplitterbarPosition()			{return splitterbarPosition;}
	static	void	SetSplitterbarPosition(UINT pos)	{splitterbarPosition=pos;}
	static	UINT	GetSplitterbarPositionServer()		{return splitterbarPositionSvr;}
	static	void	SetSplitterbarPositionServer(UINT pos)	{splitterbarPositionSvr=pos;}
	static	UINT	GetTransferWnd1()					{return m_uTransferWnd1;}
	static	void	SetTransferWnd1(UINT uWnd1)			{m_uTransferWnd1 = uWnd1;}
	static	UINT	GetTransferWnd2()					{return m_uTransferWnd2;}
	static	void	SetTransferWnd2(UINT uWnd2)			{m_uTransferWnd2 = uWnd2;}
	// NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	static	UINT	GetLastCategory()					{return m_uLastCategory;}
	static	void	SetLastCategory(UINT uCategory)		{m_uLastCategory = uCategory;} 
	// NEO: MAC END <-- Xanatos --
	//MORPH START - Added by SiRoB, Splitting Bar [O]
	static	UINT	GetSplitterbarPositionStat()		{return splitterbarPositionStat;}
	static	void	SetSplitterbarPositionStat(UINT pos) {splitterbarPositionStat=pos;}
	static	UINT	GetSplitterbarPositionStat_HL()		{return splitterbarPositionStat_HL;}
	static	void	SetSplitterbarPositionStat_HL(UINT pos) {splitterbarPositionStat_HL=pos;}
	static	UINT	GetSplitterbarPositionStat_HR()		{return splitterbarPositionStat_HR;}
	static	void	SetSplitterbarPositionStat_HR(UINT pos) {splitterbarPositionStat_HR=pos;}
	static	UINT	GetSplitterbarPositionFriend()		{return splitterbarPositionFriend;}
	static	void	SetSplitterbarPositionFriend(UINT pos) {splitterbarPositionFriend=pos;}
	static	UINT	GetSplitterbarPositionIRC()			{return splitterbarPositionIRC;}
	static	void	SetSplitterbarPositionIRC(UINT pos) {splitterbarPositionIRC=pos;}
	static	UINT	GetSplitterbarPositionShared()		{return splitterbarPositionShared;}
	static	void	SetSplitterbarPositionShared(UINT pos) {splitterbarPositionShared=pos;}
	//MORPH END   - Added by SiRoB, Splitting Bar [O]
	// -khaos--+++> Changed datatype to avoid overflows
	static	UINT	GetStatsMax()						{return statsMax;}
	// <-----khaos-
	static	bool	UseFlatBar()						{return (depth3D==0);}
	static	int		GetStraightWindowStyles()			{return m_iStraightWindowStyles;}

	static	const CString& GetSkinProfile()				{return m_strSkinProfile;}
	static	void	SetSkinProfile(LPCTSTR pszProfile)	{m_strSkinProfile = pszProfile;}

	static	const CString& GetSkinProfileDir()			{return m_strSkinProfileDir;}
	static	void	SetSkinProfileDir(LPCTSTR pszDir)	{m_strSkinProfileDir = pszDir;}

	static	UINT	GetStatsAverageMinutes()			{return statsAverageMinutes;}
	static	void	SetStatsAverageMinutes(UINT in)	{statsAverageMinutes=in;}

	static	const CString& GetNotifierConfiguration()	{return notifierConfiguration;}
	static	void	SetNotifierConfiguration(LPCTSTR pszConfigPath) {notifierConfiguration = pszConfigPath;}
	static	bool	GetNotifierOnDownloadFinished()		{return notifierOnDownloadFinished;}
	static	bool	GetNotifierOnNewDownload()			{return notifierOnNewDownload;}
	static	bool	GetNotifierOnChat()					{return notifierOnChat;}
	static	bool	GetNotifierOnLog()					{return notifierOnLog;}
	static	bool	GetNotifierOnImportantError()		{return notifierOnImportantError;}
	static	bool	GetNotifierOnEveryChatMsg()			{return notifierOnEveryChatMsg;}
	static	bool	GetNotifierOnNewVersion()			{return notifierOnNewVersion;}
	static	ENotifierSoundType GetNotifierSoundType()	{return notifierSoundType;}
	static	const CString& GetNotifierSoundFile()		{return notifierSoundFile;}

	//static	bool	GetEnableMiniMule()					{return m_bEnableMiniMule;} // NEO: MM - [NeoMiniMule] <-- Xanatos --
	static	bool	GetRTLWindowsLayout()				{return m_bRTLWindowsLayout;}

	static	CString GetIRCNick()						{return m_sircnick;}
	static	void	SetIRCNick(LPCTSTR in_nick)			{_tcscpy(m_sircnick, in_nick);}
	static	CString GetIRCServer()						{return m_sircserver;}
	static	bool	GetIRCAddTimestamp()				{return m_bircaddtimestamp;}
	static	CString GetIRCChanNameFilter()				{return m_sircchannamefilter;}
	static	bool	GetIRCUseChanFilter()				{return m_bircusechanfilter;}
	static	UINT	GetIRCChannelUserFilter()			{return m_iircchanneluserfilter;}
	static	CString GetIrcPerformString()				{return m_sircperformstring;}
	static	bool	GetIrcUsePerform()					{return m_bircuseperform;}
	static	bool	GetIRCListOnConnect()				{return m_birclistonconnect;}
	static	bool	GetIrcAcceptLinks()					{return m_bircacceptlinks;}
	static	bool	GetIrcAcceptLinksFriends()			{return m_bircacceptlinksfriends;}
	static	bool	GetIrcSoundEvents()					{return m_bircsoundevents;}
	static	bool	GetIrcIgnoreMiscMessage()			{return m_bircignoremiscmessage;}
	static	bool	GetIrcIgnoreJoinMessage()			{return m_bircignorejoinmessage;}
	static	bool	GetIrcIgnorePartMessage()			{return m_bircignorepartmessage;}
	static	bool	GetIrcIgnoreQuitMessage()			{return m_bircignorequitmessage;}
	static	bool	GetIrcIgnoreEmuleProtoAddFriend()	{return m_bircignoreemuleprotoaddfriend;}
	static	bool	GetIrcAllowEmuleProtoAddFriend()	{return m_bircallowemuleprotoaddfriend;}
	static	bool	GetIrcIgnoreEmuleProtoSendLink()	{return m_bircignoreemuleprotosendlink;}
	static	bool	GetIrcHelpChannel()					{return m_birchelpchannel;}
	static	WORD	GetWindowsVersion();
	// NEO: MOD -- Xanatos -->
	static	bool	GetStartMinimized()					{return startMinimized != FALSE;}
	static	bool	GetStartMinimizedToTray()			{return startMinimized == TRUE;}
	static	void	SetStartMinimized( UINT instartMinimized) {startMinimized = instartMinimized;} 
	// NEO: MOD END <-- Xanatos --
	static	bool	GetAutoStart()						{return m_bAutoStart;}
	static	void	SetAutoStart( bool val)				{m_bAutoStart = val;}

	static	bool	GetRestoreLastMainWndDlg()			{return m_bRestoreLastMainWndDlg;}
	static	int		GetLastMainWndDlgID()				{return m_iLastMainWndDlgID;}
	static	void	SetLastMainWndDlgID(int iID)		{m_iLastMainWndDlgID = iID;}

	static	bool	GetRestoreLastLogPane()				{return m_bRestoreLastLogPane;}
	static	int		GetLastLogPaneID()					{return m_iLastLogPaneID;}
	static	void	SetLastLogPaneID(int iID)			{m_iLastLogPaneID = iID;}

	static	bool	GetSmartIdCheck()					{return m_bSmartServerIdCheck;}
	static	void	SetSmartIdCheck(bool in_smartidcheck) {m_bSmartServerIdCheck = in_smartidcheck;}
	static	uint8	GetSmartIdState()					{return smartidstate;}
	static	void	SetSmartIdState(uint8 in_smartidstate) {smartidstate = in_smartidstate;}
	static	bool	GetPreviewPrio()					{return m_bpreviewprio;}
	static	void	SetPreviewPrio(bool in)				{m_bpreviewprio=in;}
	static	bool	GetUpdateQueueList()				{return m_bupdatequeuelist;}
	static	bool	GetManualAddedServersHighPriority()	{return m_bManualAddedServersHighPriority;}
	static	bool	TransferFullChunks()				{return m_btransferfullchunks;}
	static	void	SetTransferFullChunks( bool m_bintransferfullchunks )				{m_btransferfullchunks = m_bintransferfullchunks;}
	static	int		StartNextFile()						{return m_istartnextfile;}
	static	bool	ShowOverhead()						{return m_bshowoverhead;}
	static	void	SetNewAutoUp(bool m_bInUAP)			{m_bUAP = m_bInUAP;}
	static	bool	GetNewAutoUp()						{return m_bUAP;}
	static	void	SetNewAutoDown(bool m_bInDAP)		{m_bDAP = m_bInDAP;}
	static	bool	GetNewAutoDown()					{return m_bDAP;}
	static	bool	IsKnownClientListDisabled()			{return m_bDisableKnownClientList;}
	static	bool	IsQueueListDisabled()				{return m_bDisableQueueList;}
	static	bool	IsFirstStart()						{return m_bFirstStart;}
	static	bool	UseCreditSystem()					{return m_bCreditSystem;}
	static	void	SetCreditSystem(bool m_bInCreditSystem) {m_bCreditSystem = m_bInCreditSystem;}

	static	TCHAR*	GetTxtEditor()						{return TxtEditor;}
	static	const CString& GetVideoPlayer()				{return m_strVideoPlayer;}
	static	const CString& GetVideoPlayerArgs()			{return m_strVideoPlayerArgs;}

	static	UINT	GetFileBufferSize()					{return m_iFileBufferSize;}
	static	UINT	GetFileBufferTime()					{return m_iFileBufferTime;} // NEO: MOD - [BufferCustomisation] <-- Xanatos --
	static	UINT	GetQueueSize()						{return m_iQueueSize;}
	static	int		GetCommitFiles()					{return m_iCommitFiles;}
	static	bool	GetShowCopyEd2kLinkCmd()			{return m_bShowCopyEd2kLinkCmd;}

	// Barry
	static	UINT	Get3DDepth()						{return depth3D;}
	static	bool	AutoTakeED2KLinks()					{return autotakeed2klinks;}
	static	bool	AddNewFilesPaused()					{return addnewfilespaused;}

	static	bool	TransferlistRemainSortStyle()		{return m_bTransflstRemain;}
	static	void	TransferlistRemainSortStyle(bool in){m_bTransflstRemain=in;}

	static	DWORD	GetStatsColor(int index)			{return m_adwStatsColors[index];}
	static	void	SetStatsColor(int index, DWORD value){m_adwStatsColors[index] = value;}
	static	int		GetNumStatsColors()					{return ARRSIZE(m_adwStatsColors);}
	static	void	GetAllStatsColors(int iCount, LPDWORD pdwColors);
	static	bool	SetAllStatsColors(int iCount, const DWORD* pdwColors);
	static	void	ResetStatsColor(int index);

	static	void	SetMaxConsPerFive(UINT in)			{MaxConperFive=in;}
	static	LPLOGFONT GetHyperTextLogFont()				{return &m_lfHyperText;}
	static	void	SetHyperTextFont(LPLOGFONT plf)		{m_lfHyperText = *plf;}
	static	LPLOGFONT GetLogFont()						{return &m_lfLogText;}
	static	void	SetLogFont(LPLOGFONT plf)			{m_lfLogText = *plf;}
	static	COLORREF GetLogErrorColor()					{return m_crLogError;}
	static	COLORREF GetLogWarningColor()				{return m_crLogWarning;}
	static	COLORREF GetLogSuccessColor()				{return m_crLogSuccess;}

	// NEO: QS - [QuickStart] -- Xanatos --
	//static	UINT	GetMaxConperFive()					{return MaxConperFive;}
	static	UINT	GetDefaultMaxConperFive();

	static	bool	IsSafeServerConnectEnabled()		{return m_bSafeServerConnect;}
	static	void	SetSafeServerConnectEnabled(bool in){m_bSafeServerConnect=in;}
	static	bool	IsMoviePreviewBackup()				{return moviePreviewBackup;}
	static	int		GetPreviewSmallBlocks()				{return m_iPreviewSmallBlocks;}
	static	bool	GetPreviewCopiedArchives()			{return m_bPreviewCopiedArchives;}
	static	int		GetInspectAllFileTypes()			{return m_iInspectAllFileTypes;}
	static	int		GetExtractMetaData()				{return m_iExtractMetaData;}
	static	bool	GetAdjustNTFSDaylightFileTime()		{return m_bAdjustNTFSDaylightFileTime;}

	static	const CString& GetYourHostname()			{return m_strYourHostname;}
	static	void	SetYourHostname(LPCTSTR pszHostname){m_strYourHostname = pszHostname;}
	static	bool	IsCheckDiskspaceEnabled()			{return checkDiskspace;}
	static	UINT	GetMinFreeDiskSpace()				{return m_uMinFreeDiskSpace;}
	static	bool	GetSparsePartFiles()				{return m_bSparsePartFiles;}
	static	void	SetSparsePartFiles(bool bEnable)	{m_bSparsePartFiles = bEnable;}

	static	void	SetMaxUpload(UINT in);
	static	void	SetMaxDownload(UINT in);

	static	WINDOWPLACEMENT GetEmuleWindowPlacement()	{return EmuleWindowPlacement;}
	static	void	SetWindowLayout(WINDOWPLACEMENT in) {EmuleWindowPlacement=in;}

	static	bool	GetAutoConnectToStaticServersOnly() {return m_bAutoConnectToStaticServersOnly;}
	static	UINT	GetUpdateDays()						{return versioncheckdays;}
	static	uint32	GetLastVC()							{return versioncheckLastAutomatic;}
	static	void	UpdateLastVC();
	static	int		GetIPFilterLevel()					{return filterlevel;}
	static	const CString& GetMessageFilter()			{return messageFilter;}
	static	const CString& GetCommentFilter()			{return commentFilter;}
	static	const CString& GetFilenameCleanups()		{return filenameCleanups;}

	static	bool	ShowRatesOnTitle()					{return showRatesInTitle;}
	static	void	LoadCats();
	static	CString GetDateTimeFormat()					{return CString(datetimeformat);}
	static	CString GetDateTimeFormat4Log()				{return CString(datetimeformat4log);}

	// Download Categories (Ornis)
	static	int		AddCat(Category_Struct* cat)		{catMap.Add(cat); return catMap.GetCount()-1;}
	static	bool	MoveCat(UINT from, UINT to);
	static	void	RemoveCat(int index);
	static	int		GetCatCount()						{return catMap.GetCount();}
#ifndef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	static  bool	SetCatFilter(int index, int filter);
	static  int		GetCatFilter(int index);
	static	bool	GetCatFilterNeg(int index);
	static	void	SetCatFilterNeg(int index, bool val);
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
	static	Category_Struct* GetCategory(int index) { 
		if (index>=0 && index<catMap.GetCount()){ 
			return catMap.GetAt(index); 
		}else { 
			return catMap.GetAt(0); // return default instad of NULL just for fail safe
		}
	}
	static	TCHAR*	GetCatPath(int index) { 
		// NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
		if (index>=0 && index<catMap.GetCount()){
			if(wcslen(catMap.GetAt(index)->incomingpath) == 0)
				return incomingdir;
			return catMap.GetAt(index)->incomingpath;
		}else
			return incomingdir;
		// NEO: MAC END <-- Xanatos --
	}
	static	DWORD	GetCatColor(int index)				{if (index>=0 && index<catMap.GetCount()) return catMap.GetAt(index)->color; else return 0;}

	static	bool	GetPreviewOnIconDblClk()			{return m_bPreviewOnIconDblClk;}
	static	bool	ShowRatingIndicator()				{return indicateratings;}
	static	bool	WatchClipboard4ED2KLinks()			{return watchclipboard;}
	static	bool	GetRemoveToBin()					{return m_bRemove2bin;}
	static	bool	GetFilterServerByIP()				{return filterserverbyip;}

	static	bool	GetLog2Disk()						{return log2disk;}
	static	bool	GetDebug2Disk()						{return m_bVerbose && debug2disk;}
	static	int		GetMaxLogBuff()						{return iMaxLogBuff;}
	static	UINT	GetMaxLogFileSize()					{return uMaxLogFileSize;}
	static	ELogFileFormat GetLogFileFormat()			{return m_iLogFileFormat;}

	// WebServer
	static	bool	UseAdvWebsrv()						{ return m_bAdvWebsrv; } // NEO: WAM - [WebInterfaceAccountManagement] <-- Xanatos --
	static	uint16	GetWSPort()							{return m_nWebPort;}
	static	void	SetWSPort(uint16 uPort)				{m_nWebPort=uPort;}
	static	CString GetWSPass()							{return CString(m_sWebPassword);}
	static	void	SetWSPass(CString strNewPass);
	static	bool	GetWSIsEnabled()					{return m_bWebEnabled;}
	static	void	SetWSIsEnabled(bool bEnable)		{m_bWebEnabled=bEnable;}
	static	bool	GetWebUseGzip()						{return m_bWebUseGzip;}
	static	void	SetWebUseGzip(bool bUse)			{m_bWebUseGzip=bUse;}
	static	int		GetWebPageRefresh()					{return m_nWebPageRefresh;}
	static	void	SetWebPageRefresh(int nRefresh)		{m_nWebPageRefresh=nRefresh;}
	static	bool	GetWSIsLowUserEnabled()				{return m_bWebLowEnabled;}
	static	void	SetWSIsLowUserEnabled(bool in)		{m_bWebLowEnabled=in;}
	static	CString GetWSLowPass()						{return CString(m_sWebLowPassword);}
	static	void	SetWSLowPass(CString strNewPass);
	static	int		GetWebTimeoutMins()					{return m_iWebTimeoutMins;}
	static  bool	GetWebAdminAllowedHiLevFunc()		{return m_bAllowAdminHiLevFunc;}
	static  const CUIntArray& GetAllowedRemoteAccessIPs(){return m_aAllowedRemoteAccessIPs;}
	static	uint32	GetMaxWebUploadFileSizeMB()			{return m_iWebFileUploadSizeLimitMB;}

	//static	void	SetMaxSourcesPerFile(UINT in)		{maxsourceperfile=in;}  // NEO: NST - [NeoSourceTweaks] <-- Xanatos --
	static	void	SetMaxConnections(UINT in)			{maxconnections =in;}
	static	void	SetMaxHalfConnections(UINT in)		{maxhalfconnections =in;}
	static	bool	IsSchedulerEnabled()				{return scheduler;}
	static	void	SetSchedulerEnabled(bool in)		{scheduler=in;}
	static	bool	GetDontCompressBlocks()				{return dontcompressblocks;} // NEO: MOD  <-- Xanatos --
	static	bool	GetDontCompressAvi()				{return dontcompressavi;}

	static	bool	MsgOnlyFriends()					{return msgonlyfriends;}
	static	bool	MsgOnlySecure()						{return msgsecure;}
	static	UINT	GetMsgSessionsMax()					{return maxmsgsessions;}
	static	bool	IsSecureIdentEnabled()				{return m_bUseSecureIdent;} // use clientcredits->CryptoAvailable() to check if crypting is really available and not this function
	static	bool	IsAdvSpamfilterEnabled()			{return m_bAdvancedSpamfilter;}
	static	CString GetTemplate()						{return CString(m_sTemplateFile);}
	static	void	SetTemplate(CString in)				{_stprintf(m_sTemplateFile,_T("%s"),in);}
	static	bool	GetNetworkKademlia()				{return networkkademlia;}
	static	void	SetNetworkKademlia(bool val);
	static	bool	GetNetworkED2K()					{return networked2k;}
	static	void	SetNetworkED2K(bool val)			{networked2k = val;}

	// mobileMule
	static	CString GetMMPass()							{return CString(m_sMMPassword);}
	static	void	SetMMPass(CString strNewPass);
	static	bool	IsMMServerEnabled()					{return m_bMMEnabled;}
	static	void	SetMMIsEnabled(bool bEnable)		{m_bMMEnabled=bEnable;}
	static	uint16	GetMMPort()							{return m_nMMPort;}
	static	void	SetMMPort(uint16 uPort)				{m_nMMPort=uPort;}

	// deadlake PROXYSUPPORT
	static	const ProxySettings& GetProxySettings()		{return proxy;}
	static	void	SetProxySettings(const ProxySettings& proxysettings) {proxy = proxysettings;}

	static	UINT	ShowCatTabInfos()					{return showCatTabInfos;} // NEO: MOD - [MoreCategoryInfo] <-- Xanatos --
	static	void	ShowCatTabInfos(UINT in)			{showCatTabInfos=in;} // NEO: MOD - [MoreCategoryInfo] <-- Xanatos --

	static	bool	AutoFilenameCleanup()				{return autofilenamecleanup;}
	static	void	AutoFilenameCleanup(bool in)		{autofilenamecleanup=in;}
	static	void	SetFilenameCleanups(CString in)		{filenameCleanups=in;}

	//static	bool	GetResumeSameCat()							{ return resumeSameCat;}
	static	bool	IsGraphRecreateDisabled()			{return dontRecreateGraphs;}
	static	bool	IsExtControlsEnabled()				{return m_bExtControls;}
	static	void	SetExtControls(bool in)				{m_bExtControls=in;}
	static	bool	GetRemoveFinishedDownloads()		{return m_bRemoveFinishedDownloads;}

	static	UINT	GetMaxChatHistoryLines()			{return m_iMaxChatHistory;}
	static	bool	GetUseAutocompletion()				{return m_bUseAutocompl;}
	static	UINT	GetUseDwlPercentage()				{return m_uShowDwlPercentage;} // NEO: MOD - [Percentage] <-- Xanatos --
	static	void	SetUseDwlPercentage(UINT in)		{m_uShowDwlPercentage=in;} // NEO: MOD - [Percentage] <-- Xanatos --
	static	bool	GetShowActiveDownloadsBold()		{return m_bShowActiveDownloadsBold;}

	//Toolbar
	static	const CString& GetToolbarSettings()					{return m_sToolbarSettings;}
	static	void	SetToolbarSettings(const CString& in)		{m_sToolbarSettings = in;}
	static	const CString& GetToolbarBitmapSettings()			{return m_sToolbarBitmap;}
	static	void	SetToolbarBitmapSettings(const CString& path){m_sToolbarBitmap = path;}
	static	const CString& GetToolbarBitmapFolderSettings()		{return m_sToolbarBitmapFolder;}
	static	void	SetToolbarBitmapFolderSettings(const CString& path){m_sToolbarBitmapFolder = path;}
	static	EToolbarLabelType GetToolbarLabelSettings()			{return m_nToolbarLabels;}
	static	void	SetToolbarLabelSettings(EToolbarLabelType eLabelType) {m_nToolbarLabels = eLabelType;}
	static	bool	GetReBarToolbar()							{return m_bReBarToolbar;}
	static	bool	GetUseReBarToolbar();
	static	CSize	GetToolbarIconSize()				{return m_sizToolbarIconSize;}
	static	void	SetToolbarIconSize(CSize siz)		{m_sizToolbarIconSize = siz;}

	static	bool	IsTransToolbarEnabled()				{return m_bWinaTransToolbar;}

	static	int		GetSearchMethod()					{return m_iSearchMethod;}
	static	void	SetSearchMethod(int iMethod)		{m_iSearchMethod = iMethod;}

#ifndef NEO_BC // NEO: NBC -- Xanatos -->
	// ZZ:UploadSpeedSense -->
	static	bool	IsDynUpEnabled();
	static	void	SetDynUpEnabled(bool newValue)		{m_bDynUpEnabled = newValue;}
	static	int		GetDynUpPingTolerance()				{return m_iDynUpPingTolerance;}
	static	int		GetDynUpGoingUpDivider()			{return m_iDynUpGoingUpDivider;}
	static	int		GetDynUpGoingDownDivider()			{return m_iDynUpGoingDownDivider;}
	static	int		GetDynUpNumberOfPings()				{return m_iDynUpNumberOfPings;}
    static  bool	IsDynUpUseMillisecondPingTolerance(){return m_bDynUpUseMillisecondPingTolerance;} // EastShare - Added by TAHO, USS limit
	static  int		GetDynUpPingToleranceMilliseconds() {return m_iDynUpPingToleranceMilliseconds;} // EastShare - Added by TAHO, USS limit
	static  void	SetDynUpPingToleranceMilliseconds(int in){m_iDynUpPingToleranceMilliseconds = in;}
	// ZZ:UploadSpeedSense <--
#endif // NEO_BC // NEO: NBC END <-- Xanatos --

    static bool     GetA4AFSaveCpu()                    {return m_bA4AFSaveCpu;} // ZZ:DownloadManager

    static bool     GetHighresTimer()                   {return m_bHighresTimer;}

	static	CString	GetHomepageBaseURL()				{return GetHomepageBaseURLForLevel(GetWebMirrorAlertLevel());}
	static	CString	GetVersionCheckBaseURL();					
	static	void	SetWebMirrorAlertLevel(uint8 newValue){m_nWebMirrorAlertLevel = newValue;}
	static	bool	IsDefaultNick(const CString strCheck);
	static	UINT	GetWebMirrorAlertLevel();
	static	UINT	UseSimpleTimeRemainingComputation()	{return m_uUseOldTimeRemaining;} // NEO: MOD <-- Xanatos --

	static	bool	IsRunAsUserEnabled();
	static	bool	IsPreferingRestrictedOverUser()		{return m_bPreferRestrictedOverUser;}

	// PeerCache
	static	bool	IsPeerCacheDownloadEnabled()		{return (m_bPeerCacheEnabled && !IsClientCryptLayerRequested());}
	static	uint32	GetPeerCacheLastSearch()			{return m_uPeerCacheLastSearch;}
	static	bool	WasPeerCacheFound()					{return m_bPeerCacheWasFound;}
	static	void	SetPeerCacheLastSearch(uint32 dwLastSearch) {m_uPeerCacheLastSearch = dwLastSearch;}
	static	void	SetPeerCacheWasFound(bool bFound)	{m_bPeerCacheWasFound = bFound;}
	static	uint16	GetPeerCachePort()					{return m_nPeerCachePort;}
	static	void	SetPeerCachePort(uint16 nPort)		{m_nPeerCachePort = nPort;}
	static	bool	GetPeerCacheShow()					{return m_bPeerCacheShow;}

	// Verbose log options
	static	bool	GetEnableVerboseOptions()			{return m_bEnableVerboseOptions;}
	static	bool	GetVerbose()						{return m_bVerbose;}
	static	bool	GetFullVerbose()					{return m_bVerbose && m_bFullVerbose;}
	static	bool	GetDebugSourceExchange()			{return m_bVerbose && m_bDebugSourceExchange;}
	static	bool	GetLogBannedClients()				{return m_bVerbose && m_bLogBannedClients;}
	static	bool	GetLogRatingDescReceived()			{return m_bVerbose && m_bLogRatingDescReceived;}
	static	bool	GetLogSecureIdent()					{return m_bVerbose && m_bLogSecureIdent;}
	static	bool	GetLogFilteredIPs()					{return m_bVerbose && m_bLogFilteredIPs;}
	static	bool	GetLogFileSaving()					{return m_bVerbose && m_bLogFileSaving;}
    static	bool	GetLogA4AF()    					{return m_bVerbose && m_bLogA4AF;} // ZZ:DownloadManager
	static	bool	GetLogUlDlEvents()					{return m_bVerbose && m_bLogUlDlEvents;}
	static	bool	GetLogAICHEvents()					{return m_bVerbose && m_bLogAICHEvents;} // NEO: MOD - [LogAICH] <-- Xanatos --
	static	bool	GetUseDebugDevice()					{return m_bUseDebugDevice;}
	static	int		GetDebugServerTCPLevel()			{return m_iDebugServerTCPLevel;}
	static	int		GetDebugServerUDPLevel() 			{return m_iDebugServerUDPLevel;}
	static	int		GetDebugServerSourcesLevel()		{return m_iDebugServerSourcesLevel;}
	static	int		GetDebugServerSearchesLevel()		{return m_iDebugServerSearchesLevel;}
	static	int		GetDebugClientTCPLevel()			{return m_iDebugClientTCPLevel;}
	static	int		GetDebugClientUDPLevel()			{return m_iDebugClientUDPLevel;}
	static	int		GetDebugClientKadUDPLevel()			{return m_iDebugClientKadUDPLevel;}
	static	int		GetDebugSearchResultDetailLevel()	{return m_iDebugSearchResultDetailLevel;}
	static	int		GetVerboseLogPriority()				{return	m_byLogLevel;}

	// Firewall settings
	//static  bool	IsOpenPortsOnStartupEnabled()		{return m_bOpenPortsOnStartUp;} // NEO: IFWS <-- Xanatos --
	
	//AICH Hash
	static	bool	IsTrustingEveryHash()				{return m_bTrustEveryHash;} // this is a debug option
	static	bool	GetRememberAICH()					{return m_bRememberAICH;} // NEO: MOD - [RemoveUnusedAICHhashes] <-- Xanatos --

	static	bool	IsRememberingDownloadedFiles()		{return m_bRememberDownloadedFiles;}
	static	bool	IsRememberingCancelledFiles()		{return m_bRememberCancelledFiles;}
	static	void	SetRememberDownloadedFiles(bool nv)	{m_bRememberDownloadedFiles = nv;}
	static	void	SetRememberCancelledFiles(bool nv)	{m_bRememberCancelledFiles = nv;}
	// mail notifier
	static	bool	IsNotifierSendMailEnabled()			{return m_bNotifierSendMail;}
	static	CString	GetNotifierMailServer()				{return m_strNotifierMailServer;}
	static	CString	GetNotifierMailSender()				{return m_strNotifierMailSender;}
	static	CString	GetNotifierMailReceiver()			{return m_strNotifierMailReceiver;}

	static	void	SetNotifierSendMail(bool nv)		{m_bNotifierSendMail = nv;}
	static  bool	DoFlashOnNewMessage()				{return m_bIconflashOnNewMessage;}

	static  void	ImportOldTableSetup();
	static  void	IniCopy(CString si, CString di);

	static	void	EstimateMaxUploadCap(uint32 nCurrentUpload);
	static  bool	GetAllocCompleteMode()				{return m_bAllocFull;}
	static  void	SetAllocCompleteMode(bool in)		{m_bAllocFull=in;}

	// encryption
	static bool		IsClientCryptLayerSupported()		{return m_bCryptLayerSupported;}
	static bool		IsClientCryptLayerRequested()		{return IsClientCryptLayerSupported() && m_bCryptLayerRequested;}
	static bool		IsClientCryptLayerRequired()		{return IsClientCryptLayerRequested() && m_bCryptLayerRequired;}
	static bool		IsClientCryptLayerRequiredStrict()	{return false;} // not even incoming test connections will be answered
	static bool		IsServerCryptLayerUDPEnabled()		{return IsClientCryptLayerSupported();}
	static bool		IsServerCryptLayerTCPRequested()	{return IsClientCryptLayerRequested();}

	static uint16	GetRandomTCPPort();
	static uint16	GetRandomUDPPort();

protected:
	friend class CSharedDirsTreeCtrl; // NEO: SSD - [ShareSubDirectories] <-- Xanatos --
	// NEO: VSF - [VirtualSharedFiles] -- Xanatos -->
	static	CRBMap<CString, CString>	m_fileToVDir_map;
	static	CRBMap<CString, CString>	m_dirToVDir_map;
	static	CRBMap<CString, CString>	m_dirToVDirWithSD_map;
	// NEO: VSF END <-- Xanatos --
	static	CString appdir;
	static	CString configdir;
	static	CString m_strWebServerDir;
	static	CString m_strLangDir;
	static	CString m_strFileCommentsFilePath;
	static	CString m_strLogDir;
	static	Preferences_Ext_Struct* prefsExt;
	static	WORD m_wWinVer;
	static	CArray<Category_Struct*,Category_Struct*> catMap;

	static void	CreateUserHash();
	static void	SetStandartValues();
	static int	GetRecommendedMaxConnections();
	static void LoadPreferences();
	static void SavePreferences();
	static CString GetHomepageBaseURLForLevel(int nLevel);

	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	static void	LoadTempDirs();
	static bool	SaveTempDirs();
	// NEO: MTD END <-- Xanatos --

	// NEO: SSD - [ShareSubDirectories] -- Xanatos -->
	static void	LoadSharedDirs();
	static bool	SaveSharedDirs();
	// NEO: SSD END <-- Xanatos --

	// NEO: SSF - [ShareSingleFiles] -- Xanatos -->
	static void LoadSharedFiles();
	static bool	SaveSharedFiles();
	// NEO: SSF END <-- Xanatos --

	// NEO: VSF - [VirtualSharedFiles] -- Xanatos -->
	static void	LoadVirtualDirs();
	static bool	SaveVirtualDirs();
	// NEO: VSF END <-- Xanatos --
};

/* Xanatos:
* All Neo Preferences Functions:
*/
// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
class CPreferencesEx: public CPreferences
{
public:
	// NEO: QS - [QuickStart]
	static	UINT	GetMaxConnections(bool bOriginal = false) {return (!bOriginal && m_bOnQuickStart) ? m_iQuickMaxConnections : maxconnections;}
	static	UINT	GetMaxHalfConnections(bool bOriginal = false) {return (!bOriginal && m_bOnQuickStart) ? m_iQuickMaxHalfOpen : maxhalfconnections;}
	static	UINT	GetMaxConperFive(bool bOriginal = false) {return (!bOriginal && m_bOnQuickStart) ? m_iQuickMaxConperFive : MaxConperFive;}
	// NEO: QS END

	// NEO: NST - [NeoSourceTweaks]
#define maxsourceperfile m_iHardLimit
	static	void	SetMaxSourcesPerFile(UINT in)		{maxsourceperfile=in;}
	static	UINT	GetMaxSourcePerFileDefault()		{return maxsourceperfile;}
	// NEO: NST END

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	static	bool	m_bManageConnections;
	static	float	m_fManageConnectionsFactor;

	static	UINT	m_uNAFCEnabled;
	static	bool	m_bISPCustomIP;
	static	DWORD	m_uISPZone;
	static	DWORD	m_uISPMask;
	static	bool	m_bBindToAdapter;


	static	bool	m_bCheckConnection;
	static	bool	m_bStaticLowestPing;
	static	int		m_iPingMode;
	static	bool	m_bNoTTL;
	static	bool	m_bManualHostToPing;
	static	CString m_sPingServer;

	static	bool	m_bAutoMSS;
	static	int		m_iMSS;

	static	bool	m_bUseDoubleSendSize;


	static	bool	m_bDirectDownload;
	static	bool	m_bDirectReceivingTCP;
	static	bool	m_bDirectReceivingUDP;
	static	int		m_iBCTimeDown;
	static	int		m_iBCPriorityDown;
	static	UINT	m_uSetDownloadBuffer;
	static	int		m_iDownloadBufferSize;

	//static	bool	m_bDirectUpload;
	static	UINT	m_uUseBlockedQueue;
	static	bool	m_bDirectSendingTCP;
	static	bool	m_bDirectSendingUDP;
	static	int		m_iBCTimeUp;
	static	int		m_iBCPriorityUp;
	static	UINT	m_uSetUploadBuffer;
	static	int		m_iUploadBufferSize;

	static	int		m_iDatarateSamples;


	static	bool	m_bIncludeOverhead;
	static	bool	m_bIncludeTCPAck;
	static	bool	m_bConnectionsOverHead;
	static	bool	m_bSessionRatio;


	static	int		m_iDownloadControl;
	static	float	m_fMinBCDownload;
	static	float	m_fMaxBCDownload;


	static	int		m_iUploadControl;
	static	float	m_fMinBCUpload;
	static	float	m_fMaxBCUpload;


	static	float	m_fMaxDownStream;
	static	float	m_fMaxUpStream;


	static	bool	m_bMinimizeOpenedSlots;
	static	UINT	m_uCumulateBandwidth;
	static	UINT	m_uBadwolfsUpload;

	static	int		m_iMaxReservedSlots;
	
	static	bool	m_bIncreaseTrickleSpeed;
	static	float	m_fIncreaseTrickleSpeed;

#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	static	UINT	m_uSeparateReleaseBandwidth;
	static	float	m_fReleaseSlotSpeed;
	static	float	m_fReleaseBandwidthPercentage;

	static	bool	m_bSeparateFriendBandwidth;
	static	float	m_fFriendSlotSpeed;
	static	float	m_fFriendBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END

	static	bool	m_bOpenMoreSlotsWhenNeeded;
	static	bool	m_bCheckSlotDatarate;

	static	bool	m_bIsTrickleBlocking;
	static	bool	m_bIsDropBlocking;

	//static	bool	m_bAllowOverSending;


	static	bool	m_bDynUpGoingDivider;
	static	int		m_iDynUpGoingUpDivider;
	static	int		m_iDynUpGoingDownDivider;

	static	int		m_iUpMaxPingMethod;
	static	int		m_iBasePingUp;
	static	int		m_iPingUpTolerance;
	static	int		m_iPingUpProzent;


	static	bool	m_bDynDownGoingDivider;
	static	int		m_iDynDownGoingUpDivider;
	static	int		m_iDynDownGoingDownDivider;
	
	static	int		m_iDownMaxPingMethod;
	static	int		m_iBasePingDown;
	static	int		m_iPingDownTolerance;
	static	int		m_iPingDownProzent;
#endif // NEO_BC // NEO: NBC END

	static bool		m_bOnlyCompleteFiles; // NEO: OCF - [OnlyCompleetFiles]
	static int		m_iToOldComplete;
	static bool		m_bUseCustomPermissions; // NEO: SSP - [ShowSharePermissions]
	static bool		m_bUseSaveComments; // NEO: XC - [ExtendedComments]
	static bool		m_bUseKnownComments; // NEO: XCk - [ExtendedKnownComments]
	static UINT		m_uInteligentChunkSelecting; // NEO: ICS - [InteligentChunkSelection]
	static UINT		m_uSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]
	static UINT		m_uSubChunkVerification; // NEO: SCV - [SubChunkVerification]
	static UINT		m_uRealPartStatus; // NEO: RPS - [RealPartStatus]
	static UINT		m_uShareAlsoEmptyFiles; // NEO: SEF - [ShareAlsoEmptyFiles]

	// NEO: NXI - [NeoExtraInfo]
	static	bool	m_bSendExtraInfo;
	static	bool	m_bSendExtraInfoBandwidth;
	static	UINT	m_uSendExtraInfoUpTime;
	static	bool	m_bSendExtraInfoDlFile;
	static	UINT	m_uSendExtraInfoUlFile;
	static	bool	m_bSendExtraInfoWaitingUsers;
	static	CString	m_sSendExtraInfoString;
	// NEO: NXI END
	static	DWORD	m_dAppPriority;
	// NEO: MOD - [NiceHash]
	static	bool	m_bUseHashingDelay;
	static	int		m_iHashingDelay;
	// NEO: MOD END
	// NEO: MOD - [RelaxCPU]
	static	bool	m_bUseProcessingDelay;
	static	int		m_iProcessingDelay;
	// NEO: MOD END
	// NEO: MOD - [RefreshShared]
	static	bool	m_bRefreshShared;
	static	int		m_iRefreshSharedIntervals;
	// NEO: MOD END
	static	bool	m_bPauseOnFileComplete; // NEO: POFC - [PauseOnFileComplete]
	static	bool	m_bEstimatedDownloadTime; // NEO: EDT - [EstimatedDownloadTime] 
	static	UINT	m_uLowID2HighIDAutoCallback; // NEO: L2H - [LowID2HighIDAutoCallback]
	static  UINT	m_uAntiHideOS; // NEO: AHOS - [AntiHideOS]
	// NEO: DKA - [DownloadKeepAlive]
	static	bool	m_bEnableDownloadKeepAlive;
	static	int		m_iDownloadKeepAliveTimeout;
	// NEO: DKA END
	// NEO: TCR - [TCPConnectionRetry]
	static	bool	m_bTCPConnectionRetry;
	static	int		m_iTCPConnectionRetry;
	// NEO: TCR END
	static	bool	m_bTCPDisableNagle;

	// NEO: NST - [NeoSourceTweaks]
	static int		m_iHardLimit;
	static int		m_iSwapLimit;
	static int		m_iCleanUpLimit;
	static bool		m_bCalcStandardLimits;

	static bool		m_bXSDisable;
	static int		m_iXSLimit;
	static int		m_iXSIntervals;
	static int		m_iXSClientIntervals;
	static int		m_iXSAnswerLimit;
	static int		m_iXSDelayValue;

	static bool		m_bSVRDisable;
	static int		m_iSVRLimit;
	static int		m_iSVRIntervals;

	static bool		m_bKADDisable;
	static int		m_iKADLimit;
	static int		m_iKADIntervals;
	static int		m_iKADAmount;
	static int		m_iKADDelayValue;

	static bool		m_bUDPDisable;
	static int		m_iUDPLimit;
	static int		m_iUDPIntervals;
	static int		m_iGlobalUDPIntervals;
	static int		m_iUDPAmount;
	// NEO: XUC - [ExtendedUdpCache]
	static UINT	m_uUDPCache;
	static int		m_iUDPCache;
	// NEO: XUC END
	static	int		m_iRareFileLimit;
	// NEO: NST END

	// NEO: NSD - [NeoSourceDrop]
	static int		m_iLow2LowCleanUpTime;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	static int		m_iBadCleanUpTime;
	static int		m_iGoneCleanUpTime;
	static int		m_iSuspendCleanUpTime;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	static int		m_iNnPCleanUpTime;
	static int		m_iFullQCleanUpTime;
	// NEO: NSD END

	// NEO: SR - [SpreadReask]
	static bool		m_bSpreadReask;
	static int		m_iSpreadReask;
	// NEO: SR END

	// NEO: OCC - [ObelixConnectionControl]
	static bool		m_bObelixConnectionControl;
	static int		m_iObelixConnectionControlValue;
	// NEO: OCC END

	// NEO: ASL - [AutoSoftLock]
	static bool		m_bAutoSoftLock;
	static int		m_iAutoSoftLockValue;
	// NEO: ASL END

	// NEO: AHL - [AutoHardLimit]
	static int		m_iAutoHardLimit;
	static int		m_iGlobalHardLimit;
	static int		m_iMinimalHardLimit;
	static int		m_iAutoHardLimitTimer;
	// NEO: AHL END

	// NEO: XSC - [ExtremeSourceCache]
	static bool		m_bSourceCache;
	static int		m_iSourceCacheLimit;
	static int		m_iSourceCacheTime;
	// NEO: XSC END

	// NEO: DR - [DownloadReask]
	static int		m_iReaskIntervals;

	static bool		m_bDontNnPReask;
	static int		m_iNnPReaskIntervals;

	static bool		m_bDontFullQReask;
	static int		m_iFullQReaskIntervals;
	// NEO: DR END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	static	bool	m_bEnableSourceKeeper;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	static	bool	m_bEnableSourceStorage;
	static	UINT	m_uAutoSaveSources;
	static	int		m_iAutoSaveSourcesIntervals;
	static	int		m_iSourceStorageLimit;
	static	UINT	m_bAutoLoadStoredSources;
	static	bool	m_bUseStorageBootstrap;
	static	int		m_iStorageBootstrapTime;
	static	int		m_iStorageBootstrapRequirement;
	static	bool	m_bStoreLowIDSources;
	static	bool	m_bStoreAlsoA4AFSources;
	static	UINT	m_uStoreSourcesFileStatus;

	static	bool	m_bAutoReaskStoredSources;
	static	int		m_iAutoReaskStoredSourcesLimit;
	static	bool	m_bTotalSourceRestore;
	static	bool	m_bUseAutoReaskStoredSourcesDelay;
	static	int		m_iAutoReaskStoredSourcesDelay;

	static	int		m_iAutoReaskLoadedSourcesDelay;

	static	bool	m_bGroupStoredSourceReask;
	static	int		m_iStoredSourceGroupIntervals;
	static	int		m_iStoredSourceGroupSize;

	static	bool	m_bUseSmoothOutOfDate;
	static	int		m_iMaxStoredFaildCount;
	static	int		m_iStoredOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	static	bool	m_bEnableSourceList;
	static	UINT	m_uSaveGlobalSourceList;
	static	int		m_iGlobalSourceListCleanUpTime;
	static	bool	m_bGlobalSourceListCleanUp;
	static	int		m_iGlobalSourceListCleanUpIntervals;
	static	bool	m_bFastSourceCleanUp;
	static	bool	m_bSaveSourceFileList;
	static	int		m_iSourceFileListCleanUpTime;
	static	bool	m_bSaveSourceDataInClient;

	static	bool	m_bIPZoneCheck;

	static	bool	m_bSourceHashMonitor;
	static	int		m_iSourceHashMonitorBadTime;
	static	int		m_iSourceHashMonitorMaxBad;

	static	int		m_iTableAmountToStore;

	static	int		m_iIgnoreUnreachableInterval;
	static	int		m_iIgnoreUndefinedInterval;
	static	int		m_iBeginNewTableInterval;
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	static	bool	m_bEnableSourceAnalizer;
	static	int		m_iAnaliseIntervals;
	static	int		m_iTableAmountToAnalise;

	static	bool	m_bDontStoreTemporarySources;

	static	int		m_iPropabilityMode;
	static	float	m_fEnhancedFactor;

	static	int		m_iReservePropability;
	static	int		m_iReaskPropability;

	static	bool	m_bAutoReserveReask;
	static	int		m_iReserveReaskPropability;
	static	bool	m_bUseReaskReserveSourcesDelay;
	static	int		m_iReaskReserveSourcesDelay;
	static	int		m_iReaskReserveSourcesLimit;

	static	bool	m_bAutoTemporaryReask;
	static	int		m_iTemporaryReaskPropability;
	static	bool	m_bUseReaskTemporarySourcesDelay;
	static	int		m_iReaskTemporarySourcesDelay;
	static	int		m_iReaskTemporarySourcesLimit;

	//static	int		m_iMinAnalisisQuality;

	//static	bool	m_bAutoUnsureReask;
	//static	bool	m_bUseReaskUnsureSourcesDelay;
	//static	int		m_iReaskUnsureSourcesDelay;
	//static	int		m_iReaskUnsureSourcesLimit;

	static	bool	m_bUseUnpredictedPropability;
	static	int		m_iUnpredictedPropability;
	static	bool	m_bUseReaskUnpredictedSourcesDelay;
	static	int		m_iReaskUnpredictedSourcesDelay;
	static	int		m_iReaskUnpredictedSourcesLimit;

	static	UINT	m_uFailTolerance;
	static	int		m_iMaxFailTolerance;
	static	UINT	m_uRetryUnreachable;
	static	int		m_iRetryUnreachableIntervals;
	static	int		m_iUnreachableReaskPropability;
	static	int		m_iReaskUnreachableSourcesLimit;

	static	bool	m_bHandleTableGaps;
	static	float	m_fPriorityGapRatio;
	static	int		m_iMaxGapSize;
	static	int		m_iMaxGapTime;
	static	bool	m_bCheckPriorityIP;
	static	float	m_fPriorityIPRatio;
	static	bool	m_bCheckPortIntegrity;
	static	float	m_fPortIntegrityRatio;
	static	float	m_fMaxMidleDiscrepanceHigh;
	static	float	m_fMaxMidleDiscrepanceLow;
	static	int		m_iLastSeenDurationThreshold;
	static	UINT	m_uLinkTimePropability;
	static	int		m_iLinkTimeThreshold;
	static	bool	m_bUseDualLinkedTableGravity;
	static	int		m_iDualLinkedTableGravity;
	static	bool	m_bReliableTimeMagnification;
	static	int		m_iMaxReliableTime;
	static	int		m_iTempralIPBorderLine;
#endif // NEO_SA // NEO: NSA END

	// NEO: DS - [DropSources]
	static UINT		m_uDropNnP;
	static int		m_iDropNnPLimit;
	static int		m_iDropNnPLimitMode;
	static int		m_iDropNnPTimer;

	static UINT		m_uDropFullQ;
	static int		m_iDropFullQLimit;
	static int		m_iDropFullQLimitMode;
	static int		m_iDropFullQTimer;

	static UINT		m_uDropHighQ;
	static int		m_iDropHighQValue;
	static int		m_iDropHighQLimit;
	static int		m_iDropHighQLimitMode;
	static int		m_iDropHighQTimer;

	static bool		m_bUseDontAskThisIP;
	static int		m_iDontAskThisIPTime;
	// NEO: DS END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	static bool		m_bDropUnreachable;
	static int		m_iDropUnreachableLimit;
	static int		m_iDropUnreachableLimitMode;
	static int		m_iDropUnreachableTimer;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	static bool		m_bDropOutOfDate;
	static bool		m_bDropOutOfDateSmooth;
	static int		m_iDropOutOfDateFails;
	static int		m_iDropOutOfDateTime;
	static int		m_iDropOutOfDateLimit;
	static int		m_iDropOutOfDateLimitMode;
	static int		m_iDropOutOfDateTimer;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	static bool		m_bDropRetired;
	static int		m_iDropRetiredLimit;
	static int		m_iDropRetiredLimitMode;
	static int		m_iDropRetiredTimer;

	static bool		m_bDropLoaded;
	static int		m_iDropLoadedLimit;
	static int		m_iDropLoadedLimitMode;
	static int		m_iDropLoadedTimer;
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	// NEO: NCAP - [NeoCustomAutoPriority]
	static bool		m_bDynamicAutoDownPriority;
	static float	m_fDynamicDownPriorityFactor;
	static int		m_iLowDownPrioThreshold;
	static int		m_iHighDownPrioThreshold;
	// NEO: NCAP END

	static UINT		m_uPartTraffic; // NEO: NPT - [NeoPartTraffic]
	static int		m_iPartTrafficColor; // NEO: NPT - [NeoPartTraffic]
	static bool		m_bClassicShareStatusBar;

	static bool		m_bSaveUploadQueueWaitTime; // NEO: SQ - [SaveUploadQueue]

	// NEO: TQ - [TweakUploadQueue]
	static bool		m_bInfiniteQueue;

	static UINT		m_uQueueOverFlowRelease;
	static int		m_iQueueOverFlowRelease;

	static UINT		m_uQueueOverFlowEx;
	static int		m_iQueueOverFlowEx;

	static UINT		m_uQueueOverFlowDef;
	static int		m_iQueueOverFlowDef;

	static UINT		m_uQueueOverFlowCF;
	static int		m_iQueueOverFlowCF;
	// NEO: TQ END

	static bool		m_bUseMultiQueue; // NEO: MQ - [MultiQueue]
	static bool		m_bUseRandomQueue; // NEO: RQ - [RandomQueue]

	static bool		m_bOldPrioritySystem;

	// NEO: NMFS - [NiceMultiFriendSlots]
	static bool		m_bFriendSlotLimit;
	static int		m_iFriendSlotLimit;
	// NEO: NMFS END

	// NEO: RT - [ReleaseTweaks]
	static	int		m_iReleaseLevel; 
	static	int		m_iReleaseMode;

	static int		m_iReleaseLimitMode; 
	static bool		m_bReleaseLimitUnion;
	static int		m_iReleaseLimitCompleteMode; 

	static int		m_iReleaseLimit; 
	static int		m_iReleaseLimitHigh; 
	static int		m_iReleaseLimitLow; 

	static int		m_iReleaseLimitComplete; 
	static int		m_iReleaseLimitCompleteHigh; 
	static int		m_iReleaseLimitCompleteLow; 

	static bool		m_bLimitUnion;

	static int		m_iSourceLimitMode; 
	static bool		m_bSourceLimitUnion;
	static int		m_iSourceLimitCompleteMode; 

	static int		m_iSourceLimit; 
	static int		m_iSourceLimitHigh; 
	static int		m_iSourceLimitLow; 

	static int		m_iSourceLimitComplete; 
	static int		m_iSourceLimitCompleteHigh; 
	static int		m_iSourceLimitCompleteLow; 

	static bool		m_bReleaseNeedComplete; 
	static int		m_iReleaseNeedCompleteLimit; 

	static UINT		m_uReleaseSlotLimit;
	static int		m_iReleaseSlotLimit;
	// NEO: RT END

	// NEO: NCAP - [NeoCustomAutoPriority]
	static bool		m_bDynamicAutoUpPriority;
	static float	m_fDynamicUpPriorityFactor;
	static int		m_iLowUpPrioThreshold;
	static int		m_iHighUpPrioThreshold;
	// NEO: NCAP END
	
	// NEO: PRSF - [PushSmallRareFiles]
	static bool		m_bPushSmallFiles;
	static int		m_iPushSmallFilesSize;

	static bool		m_bPushRareFiles;
	static int		m_iPushRareFilesValue;

	static bool		m_bPushRatioFiles;
	static int		m_iPushRatioFilesValue;
	// NEO: PRSF END

	static bool		m_bNeoScoreSystem; // NEO: NFS - [NeoScoreSystem]
	static bool		m_bNeoCreditSystem; // NEO: NCS - [NeoCreditSystem]
	static int		m_iOtherCreditSystem; // NEO: OCS - [OtherCreditSystems]

	// NEO: IPS - [InteligentPartSharing]
	static bool		m_bInteligentPartSharing;
	static int		m_iInteligentPartSharingTimer;
	static int		m_iMaxProzentToHide;

	static int		m_iHideOverAvaliblyParts;
	static int		m_iHideOverAvaliblyMode;
	static float	m_fHideOverAvaliblyValue;
	static int		m_iHideOverAvaliblyCatch;

	static int		m_iHideOverSharedParts;
	static int		m_iHideOverSharedMode;
	static float	m_fHideOverSharedValue;
	static int		m_iHideOverSharedCalc;
	
	static int		m_iDontHideUnderAvaliblyParts;
	static int		m_iDontHideUnderAvaliblyMode;
	static float	m_fDontHideUnderAvaliblyValue;

	static int		m_iBlockHighOverAvaliblyParts;
	static float	m_fBlockHighOverAvaliblyFactor;

	static int		m_iBlockHighOverSharedParts;
	static float	m_fBlockHighOverSharedFactor;

	static int		m_iShowAlwaysNeeded;
	static int		m_iShowAlwaysParts;

	static int		m_iShowAlwaysIncomplete;
	// NEO: IPS END

	static CString	m_sCommunity; // NEO: NC - [NiceCommunity]

#ifdef ARGOS // NEO: NA - [NeoArgos]
	static	bool	m_bUseArgosSystem;

	static	int		m_iCreditCompensation;

	static	bool	m_bTrustUnArgosHashThief;
	static	bool	m_bTrustUnArgosHashChanged;
	static	bool	m_bTrustUnArgosGhostMode;
	static	bool	m_bTrustUnArgosAgressiv;
	static	int		m_iArgosTrustTime;

	static	UINT	m_uCloseMaellaBackdoor;

	static	UINT	m_uDontBanFriends;
	static	UINT	m_uDontBanCommunity;

	static	int		m_iArgosProcessTime;
	static	int		m_iArgosTrackTime;
	static	int		m_iArgosGenericBanTime;
	static	int		m_iArgosCorruptedSenderTime;
	static	int		m_iArgosFileScannerTime;
	static	int		m_iArgosFileFakerTime;
	static	int		m_iArgosAgressionBanTime;
	static	int		m_iArgosOpCodeTime;
	static	int		m_iArgosHashChangedTime;
	static	int		m_iArgosRankFlooderTime;
	static	int		m_iArgosGhostModeTime;	
	static	int		m_iArgosFailedTime;
	static	int		m_iArgosXSExploitTime;
	static	int		m_iArgosNickChangerTime;
	static	int		m_iArgosModChangerTime;
	static	int		m_iArgosSpamTime;
	static	int		m_iArgosBadHelloTime;
	static	int		m_iArgosBadProtTime;

	static	int		m_iArgosGPLBreakerPunishment;
	static	int		m_iArgosHardLeecherPunishment;
	static	int		m_iArgosNormalLeecherPunishment;
	static	int		m_iArgosSoftLeecherPunishment;
	static	int		m_iArgosBadModPunishment;
	static	int		m_iArgosNickThiefPunishment;
	static	int		m_iArgosModThiefPunishment;
	static	int		m_iArgosHashThiefPunishment;
	static	int		m_iArgosCreditHackPunishment;
	static	int		m_iArgosHashChangedPunishment;
	static	int		m_iArgosGhostModePunishment;
	static	int		m_iArgosFakeClientPunishment;
	static	int		m_iArgosAgressonPunishment;
	static	int		m_iArgosFileScannerPunishment;
	static	int		m_iArgosFileFakerPunishment;
	static	int		m_iArgosCorruptedSenderPunishment;
	static	int		m_iArgosRankFlooderPunishment;
	static	int		m_iArgosFailedPunishment;
	static	int		m_iArgosXSExploitPunishment;
	static	int		m_iArgosNickChangerPunishment;
	static	int		m_iArgosModChangerPunishment;
	static	int		m_iArgosSpamPunishment;
	static	int		m_iArgosBadHelloPunishment;
	static	int		m_iArgosBadProtPunishment;

	static	bool	m_bArgosLeecherModDetection;
	static	UINT	m_uArgosLeecherNickDetection;
	static	int		m_iArgosDetectionLevel;
	static	bool	m_bArgosOpcodeDetection;
	static	bool	m_bArgosLeecherHashDetection;
	static	bool	m_bArgosNickThiefDetection;
	static	bool	m_bPlainAntiNickThief;
	static	bool	m_bArgosModThiefDetection;
	static	bool	m_bArgosHashThiefDetection;
	static	bool	m_bArgosThiefZoneDetection;
	static	bool	m_bArgosCreditHackDetection;
	static	bool	m_bHashChangeDetection;
	static	int 	m_iHashChangeDetectionMode;
	static	bool	m_bArgosGhostModDetection;
	static	UINT	m_uArgosFakeClientDetection;
	static	UINT	m_uAgressionDetection;
	static	int 	m_iAgressionIntervals;
	static	int 	m_iAgressionThreshold;
	static	bool	m_bFileScannerDetection;
	static	bool	m_bFileFakerDetection;
	static	bool	m_bBadSenderDetection;
	static	bool	m_bRankFloodDetection;
	static	bool	m_bFailedDetection;
	static	int 	m_iFailedTries;
	static	int 	m_iFailedThreshold;
	static	bool	m_bXSExploitDetection;
	static	int 	m_iXSExploitIntervals;
	static	int 	m_iXSExploitThreshold;
	static	bool	m_bNickChangerDetection;
	static	int 	m_iNickChangeIntervals;
	static	int 	m_iNickChangeThreshold;
	static	bool	m_bModChangerDetection;
	static	int 	m_iModChangeIntervals;
	static	int 	m_iModChangeThreshold;
	static	bool	m_bSpamDetection;
	static	bool	m_bBadHelloDetection;
	//static	bool	m_bMD4HelloDetection;
	static	UINT	m_ueMCryptDetection;
	static	bool	m_bBadProtDetection;
	static	UINT	m_uDLPDetection;

	static	bool	m_bArgosLogLeechers;
#endif // ARGOS // NEO: NA END

	static bool		m_bUseChunkDots; // NEO: MOD - [ChunkDots]
	static bool		m_bUseRelativeChunkDisplay; // NEO: MOD - [RelativeChunkDisplay]
	static bool		m_bUseTreeStyle; // NEO: NTS - [NeoTreeStyle]
	static bool		m_bShowFileTypeIcon; // NEO: NI - [NewIcons]
	static bool		m_bShowFileStatusIcons; // NEO: FSI - [FileStatusIcons]
	static bool		m_bCollorShareFiles;
	static bool		m_bShowBanner;
	static bool		m_bShowHashProgres;
	static UINT		m_uUsePlusSpeedMeter; // NEO: PSM - [PlusSpeedMeter]
	// NEO: NSTI - [NewSystemTrayIcon]
	static bool		m_bShowSystemTrayUpload;
	static bool		m_bThinSystemTrayBars;
	static int		m_iTrayBarsMaxCollor;
	// NEO: NSTI END
	static bool		m_bStaticTrayIcon; // NEO: STI - [StaticTray]
	static UINT		m_uDisableAutoSort; // NEO: SE - [SortExtension]
	static UINT		m_uShowClientPercentage; // NEO: MOD - [Percentage]

	// NEO: SI - [SysInfo]
	static	bool	m_bDrawSysInfoGraph;
	static	bool	m_bShowSysInfoOnTitle;
	// NEO: SI END

	// NEO: NTB - [NeoToolbarButtons]
	static	UINT	m_uNeoToolbar;
	static	int		m_iNeoToolbarButtonCount;
	static  CArray<UINT> m_NeoToolbarButtons;
	// NEO: NTB END

	// NEO: CTB - [CoolToolBar]
	static	bool	m_bCoolToolbar;
	static	UINT	m_uCoolToolbarText;
	static	int		m_iCoolToolbarCenter;
	static	int		m_iCoolToolbarRight;
	static	int		m_iCoolToolbarButtonCount;
	static  CArray<UINT> m_CoolToolbarButtons;
	// NEO: CTB END

	// NEO: NMX - [NeoMenuXP]
	static	bool	m_bShowXPSideBar;
	static	bool	m_bShowXPBitmap;
	static  int 	m_iXPMenuStyle;
	static	bool	m_bGrayMenuIcon;
	// NEO: NMX END

	// NEO: MM - [NeoMiniMule]
	static	bool	m_bEnableMiniMule;
	static	bool	m_bAutoShowMiniMule;
	static	bool	m_bMiniMuleOnTop;
	static	bool	m_bUpdateHidenMiniMule;
	static	UINT	m_uMiniMuleTransparency;
	static	bool	m_bMiniMuleBack;
	static	CString m_sMiniMuleLabel;
	// NEO: MM END

	// NEO: IM - [InvisibelMode]
	static	bool	m_bInvisibleMode;		
	static	UINT	m_iInvisibleModeHotKeyModifier;
	static	TCHAR	m_cInvisibleModeHotKey;
	// NEO: IM END

	// NEO: TPP - [TrayPasswordProtection]
	static	bool	m_bTrayPasswordProtection;
	static	CString	m_sTrayPassword;
	// NEO: TPP END

	static	bool	m_bShowMyFullInfo;

	static	bool	m_bSmoothStatisticsGraphs;

	// NEO: MMR - [MorphMassRemane]
	static int      m_SimpleCleanupOptions;
	static CString  m_SimpleCleanupSearch;
	static CString  m_SimpleCleanupReplace;
	static CString  m_SimpleCleanupSearchChars;
	static CString  m_SimpleCleanupReplaceChars;
	// NEO: MMR END

	// NEO: CRC - [MorphCRCTag]
	static bool		m_bDontAddCRCToFilename;
	static bool		m_bCRC32ForceUppercase;
	static bool		m_bCRC32ForceAdding;
	static CString	m_sCRC32Prefix;
	static CString	m_sCRC32Suffix;
	// NEO: CRC END

	static int		m_iMaxUploadSlots;
	static int		m_iMinUploadSlots;
	static float	m_fUploadPerSlots;

	// NEO: QS - [QuickStart]
	static UINT		m_uQuickStart;
	static int		m_iQuickStartTime;
	static int		m_iQuickStartTimePerFile;
	static UINT		m_iQuickMaxConperFive;
	static UINT		m_iQuickMaxHalfOpen;
	static UINT		m_iQuickMaxConnections;

	static bool		m_bOnQuickStart;
	// NEO: QS END

	// NEO: RIC - [ReaskOnIDChange]
	static UINT		m_uCheckIPChange;
	static bool		m_bInformOnIPChange;
	static bool		m_bReAskOnIPChange;
	static bool		m_bQuickStartOnIPChange; // NEO: QS - [QuickStart]
	static bool		m_bCheckL2HIDChange;
	static bool		m_bReconnectKadOnIPChange;
	static bool		m_bRebindSocketsOnIPChange;
	// NEO: RIC END

	// NEO: RKF - [RecheckKadFirewalled]
	static bool		m_bRecheckKadFirewalled;
	static int		m_iRecheckKadFirewalled;
	// NEO: RKF END

	// NEO: RLD - [ReconnectOnLowID]
	static bool		m_bReConnectOnLowID;
	static int		m_iReConnectOnLowID;
	// NEO: RLD END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	static	bool	m_bLancastEnabled;

	static	uint16	m_iMaxLanDownload;
	static	bool	m_bDirectLanDownload;
	static	bool	m_bSetLanDownloadBuffer;
	static	int		m_iLanDownloadBufferSize;

	static	uint16	m_iMaxLanUpload;
	static	bool	m_bDirectLanUpload;
	static	bool	m_bSetLanUploadBuffer;
	static	int		m_iLanUploadBufferSize;

	static	int		m_iMaxLanUploadSlots;

	static	bool	m_bCustomizedLanCast;
	static	CString	m_sLanCastGroup;
	static	uint16	m_uLanCastPort;

	static	bool	m_bCustomLanCastAdapter;
	static	DWORD	m_uLanCastAdapterIPAdress;
	static	DWORD	m_uLanCastAdapterSubNet;

	static	int		m_iLANIntervals;

	static	int		m_iLanReaskIntervals;
	static	int		m_iNnPLanReaskIntervals;

	static	bool	m_bAutoBroadcastLanFiles;
	static	int		m_iAutoBroadcastLanFiles;

	static	bool	m_bUseLanMultiTransfer;
#endif //LANCAST // NEO: NLC END

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	static	bool	m_bUseVoodooTransfer;
	static	bool	m_bSlaveAllowed;
	static	bool	m_bSlaveHosting;

	static	CString	m_sVoodooSpell;
	static	uint16	m_nVoodooPort;

	static	UINT	m_uAutoConnectVoodoo;

	static	UINT	m_uUseVirtualVoodooFiles;
	static	bool	m_bHideVoodooFiles;

	static	UINT	m_uUseVoodooSourceExchange;

	static	bool	m_bUseVoodooSearch;

	static	bool	m_bVoodooNeoCommands;
	static	bool	m_bVoodooNeoPreferences;

	static	UINT	m_uVoodooCastEnabled;

	static	UINT	m_uSearchForSlaves;
	static	UINT	m_uSearchForMaster;
	static	int		m_iVoodooSearchIntervals;
#endif // VOODOO // NEO: VOODOO END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	static bool		m_bShowCatNames;
	static UINT		m_uShowCategoryFlags;
	static bool		m_bActiveCatDefault;
	static bool		m_bSelCatOnAdd;
	static bool		m_bAutoSetResumeOrder;
	static bool		m_bSmallFileDLPush;
	static int		m_iSmallFileDLPush;
	static bool		m_bStartDLInEmptyCats;
	static int		m_iStartDLInEmptyCats;
	static bool		m_bUseAutoCat;
	static bool		m_bCheckAlreadyDownloaded;
	
	static bool		m_bStartNextFileByPriority;

	static bool		m_bSmartA4AFSwapping;
	static int		m_iAdvancedA4AFMode; // 0 = disabled, 1 = balance, 2 = stack
#endif // A4AF_CATS // NEO: MAC END

	static	UINT	m_uUseLugdunumCredits; // NEO: KLC - [KhaosLugdunumCredits]
	static	bool	m_bPreferShareAll; // NEO: PSA - [PreferShareAll]
	// NEO: ASF - [AdvancedServerFilter]
	static	bool	m_bDontRemoveStaticServers;
	static	bool	m_bServerFilterAutoDel;
	static	int		m_iServerFilter;
	static	CString m_sServerFilterVal;
	static	bool	m_bServerFilterDataless;
	// NEO: ASF END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	static	int		m_iIP2CountryNameMode; 
	static	UINT	m_uIP2CountryShowFlag; 
#endif // IP2COUNTRY // NEO: IP2C END
	static	bool	m_bUseFakeCheck; // NEO: FC - [FakeCheck]

	// NEO: FDC - [FileNameDisparityCheck]
	static	bool	m_bUseFileCheck;
	static	int		m_iFileCheckSensitivity;
	static	bool	m_bUseFileCheckThreshold;
	static	int		m_iFileCheckThreshold;
	static	int		m_iFileCheckAmount;
	// NEO: FDC END

	// NEO: FN - [FunnyNick]
	static	bool	m_bUseFunnyNick;
	static	CString m_sFunnyNickFilter;
	static	CString m_sFunnyNickSymbol;
	// NEO: FN END

	// NEO: AU - [AutoUpdate]
	static bool		m_bAutoRuntimeUpdate;
	static int		m_iRuntimeUpdateIntervals;

	static TCHAR	m_sUpdateURLIPFilter[256];
	static bool		m_bAutoUpdateIPFilter;
	static SYSTEMTIME m_IPFilterVersion;
	
#ifdef ARGOS // NEO: NA - [NeoArgos]
	static TCHAR	m_sUpdateURLLeechersList[256];
	static bool		m_bUpdateLeechersStartup;
	static SYSTEMTIME m_LeechersVersion;
#endif // ARGOS // NEO: NA END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	static TCHAR	m_sUpdateURLIP2Country[256];
	static bool		m_bAutoUpdateIP2Country; 
	static SYSTEMTIME m_IP2CountryVersion;
#endif // IP2COUNTRY // NEO: IP2C END

	// NEO: FC - [FakeCheck]
	static TCHAR	m_sUpdateURLFakeList[256];
	static bool		m_bUpdateFakeStartup;
	static SYSTEMTIME m_FakesVersion;
	// NEO: FC END
	// NEO: AU END

	// NEO: IFWS - [ICSFirewall]
	static UINT		m_uICFSupport;
	static bool		m_bICFClearOnClose;
	// NEO: IFWS END

	// NEO: UPNP - [UPnPNat]
	static UINT		m_uUPnPNat;
	static bool		m_bUPnPClearOnClose;
	static bool		m_bUPnPTryRandom;
	// NEO: UPNP END

	// NEO: NATS - [NatSupport]
	static bool		m_bNATSupportEnabled;
	static float	m_fNATPortRefreshIvterval;
	static int		m_iNATPortMaxLatencyTime;
	static int		m_iNATPortMaxFails;
	static bool		m_bNATPortFastRefresh;

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	static bool		m_bNATPortRelaiable;
	static bool		m_bNATTraversalEnabled;
	static bool		m_bDontTrustNatPorts;
	static int		m_iNatCharacteristic;
	static UINT		m_uLowIDUplaodCallBack; // NEO: LUC - [LowIDUplaodCallBack]
	static UINT		m_uReuseTCPPort;
#endif //NATTUNNELING // NEO: NATT END

	static uint32	m_uUDPPortPingTime;
	static uint16	m_uUDPPortPingFails;
	static uint32	m_iIPExternal;
	static bool		m_bUDPPingPending;
	static bool		m_bKADPingPending;

	static uint16	m_iTCPExternal;
	static uint16	m_iUDPExternal;
	static uint16	m_iKADExternal; // NEO: KAX - [KadAuxPort]
	// NEO: NATS END


#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	static	bool	IsManageConnections()			{return m_bManageConnections;}
	static	void	SetManageConnections(bool manage){m_bManageConnections = manage;}
	static	float	GetManageConnectionsFactor()	{return m_fManageConnectionsFactor;}
	static	void	SetManageConnectionsFactor(float Factor){m_fManageConnectionsFactor = Factor;}

	static	bool	IsNAFCEnabled()					{return I2B(m_uNAFCEnabled);}
	static	bool	IsCheckAdapter()				{return (m_uNAFCEnabled == 1 && m_bISPCustomIP);} // The default adapter is heare useles
	static	bool	IsISPCustomIP()					{return m_bISPCustomIP;}
	static	DWORD	GetISPZone()					{return m_uISPZone;}
	static	DWORD	GetISPMask()					{return m_uISPMask;}
	static	bool	IsBindToAdapter()				{return m_bBindToAdapter;}

	static	bool	IsCheckConnection()				{return m_bCheckConnection;}
	static	bool	IsStaticLowestPing()			{return m_bStaticLowestPing;}
	static	int		GetPingMode()					{return m_iPingMode;}
	static	bool	IsNoTTL()						{return m_bNoTTL;}
	static	bool	IsAutoHostToPing()				{return (!m_bManualHostToPing);}
	static	CString GetURLPing()					{return m_sPingServer;}

	static	bool	IsAutoMSS()						{return m_bAutoMSS;}
	static	int		GetMSS()						{return m_iMSS;}

	static	bool	UseDoubleSendSize()				{return m_bUseDoubleSendSize;}

	static	bool	IsDirectDownload()				{return m_bDirectDownload;}
	static	bool	IsDirectReceivingTCP()			{return m_bDirectReceivingTCP || m_bDirectDownload;}
	static	bool	IsDirectReceivingUDP()			{return m_bDirectReceivingUDP || m_bDirectDownload;}
	static	int		GetBCTimeDown()					{return m_iBCTimeDown;}
	static	int		GetBCPriorityDown()				{return m_iBCPriorityDown;}
	static	UINT	IsSetDownloadBuffer()			{return m_uSetDownloadBuffer;}
	static	int		GetDownloadBufferSize()			{return m_iDownloadBufferSize;}

	//static	bool	IsDirectUpload()				{return m_bDirectUpload;}
	static	UINT	UseBlockedQueue()				{return m_uUseBlockedQueue;}
	static	bool	IsDirectSendingTCP()			{return m_bDirectSendingTCP /*|| m_bDirectUpload*/;}
	static	bool	IsDirectSendingUDP()			{return m_bDirectSendingUDP /*|| m_bDirectUpload*/;}
	static	int		GetBCTimeUp()					{return m_iBCTimeUp;}
	static	int		GetBCPriorityUp()				{return m_iBCPriorityUp;}
	static	UINT	IsSetUploadBuffer()				{return m_uSetUploadBuffer;}
	static	int		GetUploadBufferSize()			{return m_iUploadBufferSize;}
	
	static	int		GetDatarateSamples()			{return m_iDatarateSamples;}

	static	bool	IsIncludeOverhead()				{return m_bIncludeOverhead;}
	static	void	SetIncludeOverhead(bool include){m_bIncludeOverhead = include;}
	static	bool	IsIncludeTCPAck()				{return m_bIncludeTCPAck;}
	static	bool	IsConnectionsOverHead()			{return m_bConnectionsOverHead;}

	static	bool	IsSessionRatio()				{return m_bSessionRatio;}
	
	static	void	SetDownloadControl(int ctrl)	{m_iDownloadControl = ctrl;}
	static	bool	IsNAFCDownload()				{return (m_iDownloadControl == 1);}
	static	bool	IsDSSEnabled()					{return (m_iDownloadControl == 2);}
	static	int		GetDownloadControl()			{return m_iDownloadControl;}
	static	float	GetMinBCDownload()				{return m_fMinBCDownload;}
	static	void	SetMinBCDownload(float down)	{m_fMinBCDownload = down;}
	static	float	GetMaxBCDownload()				{return m_fMaxBCDownload;}
	static	void	SetMaxBCDownload(float down)	{m_fMaxBCDownload = down;}
	static	bool	IsAutoMaxDownload()				{return (GetMaxBCDownload() == 0);}


	static	void	SetUploadControl(int ctrl)		{m_iUploadControl = ctrl;}
	static	bool	IsNAFCUpload()					{return (m_iUploadControl == 1);}
	static	bool	IsUSSEnabled()					{return (m_iUploadControl == 2);}
	static	int		GetUploadControl()				{return m_iUploadControl;}
	static	float	GetMinBCUpload()				{return m_fMinBCUpload;}
	static	void	SetMinBCUpload(float up)		{m_fMinBCUpload = up;}
	static	float	GetMaxBCUpload()				{return m_fMaxBCUpload;}
	static	void	SetMaxBCUpload(float up)		{m_fMaxBCUpload = up;}
	static	bool	IsAutoMaxUpload()				{return (GetMaxBCUpload() == 0);}

	static	void	SetMaxDownStream(float maxdown)	{m_fMaxDownStream = maxdown;}
	static	float	GetMaxDownStream()				{return m_fMaxDownStream;}
	static	void	SetMaxUpStream(float maxup)		{m_fMaxUpStream = maxup;}
	static	float	GetMaxUpStream()				{return m_fMaxUpStream;}

	static	bool	IsMinimizeOpenedSlots()			{return m_bMinimizeOpenedSlots;}
	static	UINT	IsCumulateBandwidth()			{return m_uCumulateBandwidth;}
	static	UINT	IsBadwolfsUpload()				{return m_uBadwolfsUpload;}

	static	int		GetMaxReservedSlots()			{return m_iMaxReservedSlots;}

	static	bool	IsIncreaseTrickleSpeed()		{return m_bIncreaseTrickleSpeed;}
	static	float	GetIncreaseTrickleSpeed()		{return m_fIncreaseTrickleSpeed;}

#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	static	UINT	IsSeparateReleaseBandwidth()	{return m_uSeparateReleaseBandwidth;}
	static	float	GetReleaseSlotSpeed()			{return m_fReleaseSlotSpeed;}
	static	float	GetReleaseBandwidthPercentage()	{return m_fReleaseBandwidthPercentage;}

	static	bool	IsSeparateFriendBandwidth()		{return m_bSeparateFriendBandwidth;}
	static	float	GetFriendSlotSpeed()			{return m_fFriendSlotSpeed;}
	static	float	GetFriendBandwidthPercentage()	{return m_fFriendBandwidthPercentage;}
#endif // NEO_UBT // NEO: BM END

	static	bool	IsOpenMoreSlotsWhenNeeded()		{return m_bOpenMoreSlotsWhenNeeded;}
	static	bool	IsCheckSlotDatarate()			{return m_bCheckSlotDatarate;}

	static	bool	IsTrickleBlocking()				{return m_bIsTrickleBlocking;}
	static	bool	IsDropBlocking()				{return m_bIsDropBlocking;}

	//static	bool	AllowOverSending()				{return m_bAllowOverSending;}

	static	bool	IsDynUpGoingDivider()			{return m_bDynUpGoingDivider;}
	static	int		GetDynUpGoingUpDivider()		{return m_iDynUpGoingUpDivider;}
	static	int		GetDynUpGoingDownDivider()		{return m_iDynUpGoingDownDivider;}

	static	int		GetUpMaxPingMethod()			{return m_iUpMaxPingMethod;}
	static	int		GetBasePingUp()					{return m_iBasePingUp;}
	static	void	SetBasePingUp(int ping)			{m_iBasePingUp = ping;}
	static	int		GetPingUpTolerance()			{return m_iPingUpTolerance;}
	static	void	SetPingUpTolerance(int tolerance){m_iPingUpTolerance = tolerance;}
	static	int		GetPingUpProzent()				{return m_iPingUpProzent;}
	static	void	SetPingUpProzent(int prozent)	{m_iPingUpProzent = prozent;}


	static	bool	IsDynDownGoingDivider()			{return m_bDynDownGoingDivider;}
	static	int		GetDynDownGoingUpDivider()		{return m_iDynDownGoingUpDivider;}
	static	int		GetDynDownGoingDownDivider()	{return m_iDynDownGoingDownDivider;}
	
	static	int		GetDownMaxPingMethod()			{return m_iDownMaxPingMethod;}
	static	int		GetBasePingDown()				{return m_iBasePingDown;}
	static	void	SetBasePingDown(int ping)		{m_iBasePingDown = ping;}
	static	int		GetPingDownTolerance()			{return m_iPingDownTolerance;}
	static	void	SetPingDownTolerance(int tolerance){m_iPingDownTolerance = tolerance;}
	static	int		GetPingDownProzent()			{return m_iPingDownProzent;}
	static	void	SetPingDownProzent(int prozent)	{m_iPingDownProzent = prozent;}
#endif // NEO_BC // NEO: NBC END

	static	bool	OnlyCompleteFiles()				{return m_bOnlyCompleteFiles;}// NEO: OCF - [OnlyCompleetFiles]
	static	int		ToOldComplete()					{return m_iToOldComplete;}
#define FALSE_ON_ANON
	static	bool	UseCustomPermissions()			{return m_bUseCustomPermissions;} // NEO: SSP - [ShowSharePermissions]
	static	bool	UseSaveComments()				{return m_bUseSaveComments; } // NEO: XC - [ExtendedComments]
	static	bool	UseKnownComments()				{return m_bUseKnownComments; } // NEO: XCk - [ExtendedKnownComments]
	static	UINT	UseInteligentChunkSelection()	{FALSE_ON_ANON return m_uInteligentChunkSelecting;} // NEO: ICS - [InteligentChunkSelection]
	static	UINT	UseSubChunkTransfer()			{FALSE_ON_ANON return m_uSubChunkTransfer;} // NEO: SCT - [SubChunkTransfer]
	static	UINT	UseSubChunkVerification()		{if(!UseSubChunkTransfer()) return FALSE; return m_uSubChunkVerification;} // NEO: SCV - [SubChunkVerification]
	static	UINT	UseRealPartStatus()				{FALSE_ON_ANON return m_uRealPartStatus;} // NEO: RPS - [RealPartStatus]
	static	UINT	IsShareAlsoEmptyFiles()			{return m_uShareAlsoEmptyFiles;} // NEO: SEF - [ShareAlsoEmptyFiles]

	// NEO: NXI - [NeoExtraInfo]
	static	bool	SendExtraInfo()					{FALSE_ON_ANON return m_bSendExtraInfo;}
	static	bool	SendExtraInfoBandwidth()		{return m_bSendExtraInfoBandwidth;}
	static	UINT	SendExtraInfoUpTime()			{return m_uSendExtraInfoUpTime;}
	static	bool	SendExtraInfoDlFile()			{return m_bSendExtraInfoDlFile;}
	static	UINT	SendExtraInfoUlFile()			{return m_uSendExtraInfoUlFile;}
	static	bool	SendExtraInfoWaitingUsers()		{return m_bSendExtraInfoWaitingUsers;}
	static	CString	SendExtraInfoString()			{return m_sSendExtraInfoString;}
	// NEO: NXI END
	static	DWORD	GetAppPriority()				{return m_dAppPriority;}
	// NEO: MOD - [NiceHash]
	static	bool	UseHashingDelay()				{return m_bUseHashingDelay;}
	static	int		GetHashingDelay()				{return m_iHashingDelay;}
	static	uint32	GetHashingDelayMs()				{return (GetHashingDelay()*10);}
	// NEO: MOD END
	// NEO: MOD - [RelaxCPU]
	static	bool	UseProcessingDelay()			{return m_bUseProcessingDelay;}
	static	int		GetProcessingDelay()			{return m_iProcessingDelay;}
	// NEO: MOD END
	// NEO: MOD - [RefreshShared]
	static	bool	IsRefreshShared()				{return m_bRefreshShared;}
	static	int		GetRefreshShared()				{return m_iRefreshSharedIntervals;}
	static	uint32	GetRefreshSharedMs()			{return MIN2MS(GetRefreshShared());}
	// NEO: MOD END
	static	bool	IsPauseOnFileComplete()			{return m_bPauseOnFileComplete;} // NEO: POFC - [PauseOnFileComplete]
	static	bool	UseEstimatedDownloadTime()		{FALSE_ON_ANON return m_bEstimatedDownloadTime;} // NEO: EDT - [EstimatedDownloadTime] 
	static	UINT	UseLowID2HighIDAutoCallback()	{FALSE_ON_ANON return m_uLowID2HighIDAutoCallback;} // NEO: L2H - [LowID2HighIDAutoCallback]
	static  UINT	UseAntiHideOS()					{return m_uAntiHideOS;} // NEO: AHOS - [AntiHideOS]
	// NEO: DKA - [DownloadKeepAlive]
	static	bool	IsEnableDownloadKeepAlive()		{return m_bEnableDownloadKeepAlive;}
	static	int		GetDownloadKeepAliveTimeout()	{return m_iDownloadKeepAliveTimeout;}
	static	uint32	GetDownloadKeepAliveTimeoutMs()	{return SEC2MS(GetDownloadKeepAliveTimeout());}
	// NEO: DKA END
	// NEO: TCR - [TCPConnectionRetry]
	static	bool	UseTCPConnectionRetry()			{return m_bTCPConnectionRetry;}
	static	int		GetTCPConnectionRetry()			{return m_iTCPConnectionRetry;}
	static	int		GetTCPNewConnectionRetry()		{return (m_iTCPConnectionRetry+1)/2;} // X?: Should this be configurable separatly?
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	static	int		GetTCPStoredConnectionRetry()	{return (m_iTCPConnectionRetry+2)/3;} // X?: Should this be configurable separatly?
#endif // NEO_SS // NEO: NSS END
	// NEO: TCR END
	static	bool	IsTCPDisableNagle()				{return m_bTCPDisableNagle;}

	// NEO: NST - [NeoSourceTweaks]
	static	int		GetHardLimit()					{return m_iHardLimit;}
	static	int		GetSwapLimit()					{return m_iSwapLimit;}
	static	int		GetCleanUpLimit()				{return m_iCleanUpLimit;}
	static	bool	IsCalcStandardLimits()			{return m_bCalcStandardLimits;}

	static	bool	IsXSDisable()					{return m_bXSDisable;}
	static	int		GetXSLimit()					{return m_iXSLimit;}
	static	int		GetXSIntervals()				{return m_iXSIntervals;}
	static	int		GetXSClientIntervals()			{return m_iXSClientIntervals;}
	static	uint32	GetXSClientIntervalsMs()		{return MIN2MS(m_iXSClientIntervals);}
	static	int		GetXSAnswerLimit()				{return m_iXSAnswerLimit;}
	static	int		GetXSDelayValue()				{return m_iXSDelayValue;}

	static	bool	IsSVRDisable()					{return m_bSVRDisable;}
	static	int		GetSVRLimit()					{return m_iSVRLimit;}
	static	int		GetSVRIntervals()				{return m_iSVRIntervals;}

	static	bool	IsKADDisable()					{return m_bKADDisable;}
	static	int		GetKADLimit()					{return m_iKADLimit;}
	static	int		GetKADIntervals()				{return m_iKADIntervals;}
	static	int		GetKADAmount()					{return m_iKADAmount;}
	static	int		GetKADDelayValue()				{return m_iKADDelayValue;}

	static	bool	IsUDPDisable()					{return m_bUDPDisable;}
	static	int		GetUDPLimit()					{return m_iUDPLimit;}
	static	int		GetUDPIntervals()				{return m_iUDPIntervals;}
	static	int		GetGlobalUDPIntervals()			{return m_iGlobalUDPIntervals;}
	static	uint32	GetGlobalUDPIntervalsMs()		{return MIN2MS(GetGlobalUDPIntervals());}
	static	int		GetUDPAmount()					{return m_iUDPAmount;}
	// NEO: XUC - [ExtendedUdpCache]
	static	UINT	UseUDPCache()					{return m_uUDPCache;}
	static	int		GetUDPCacheAmount()				{return m_iUDPCache;}
	// NEO: XUC END
	static	int		GetRareFileLimit()				{return m_iRareFileLimit;}
	// NEO: NST END

	// NEO: NSD - [NeoSourceDrop]
	int		GetLow2LowCleanUpTime()					{return m_iLow2LowCleanUpTime;}
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	int		GetBadCleanUpTime()						{return m_iBadCleanUpTime;}
	int		GetGoneCleanUpTime()					{return m_iGoneCleanUpTime;}
	int		GetSuspendCleanUpTime()					{return m_iSuspendCleanUpTime;}
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	int		GetNnPCleanUpTime()						{return m_iNnPCleanUpTime;}
	int		GetFullQCleanUpTime()					{return m_iFullQCleanUpTime;}
	// NEO: NSD END

	// NEO: SR - [SpreadReask]
	static	bool	UseSpreadReask()				{return m_bSpreadReask;}
	static	int		GetSpreadReaskValue()			{return m_iSpreadReask;}
	static	uint32	GetSpreadReaskValueMs()			{return MIN2MS(GetSpreadReaskValue());}
	// NEO: SR END

	// NEO: OCC - [ObelixConnectionControl]
	static	bool	UseObelixConnectionControl()	{return m_bObelixConnectionControl;}
	static	int		GetObelixConnectionControlValue() {return m_iObelixConnectionControlValue;}
	// NEO: OCC END

	// NEO: ASL - [AutoSoftLock]
	static	bool	UseAutoSoftLock()				{return m_bAutoSoftLock;}
	static	int		GetAutoSoftLockValue()			{return m_iAutoSoftLockValue;}
	// NEO: ASL END

	// NEO: AHL - [AutoHardLimit]
	static	int		UseAutoHardLimit()				{return m_iAutoHardLimit;}
	static	int		GetGlobalHardLimit()			{return m_iGlobalHardLimit;}
	static	int		GetMinimalHardLimit()			{return m_iMinimalHardLimit;}
	static	int		GetAutoHardLimitTimer()			{return m_iAutoHardLimitTimer;}
	// NEO: AHL END

	// NEO: XSC - [ExtremeSourceCache]
	static bool		UseSourceCache()				{return m_bSourceCache;}
	static int		GetSourceCacheLimit()			{return m_iSourceCacheLimit;}
	static int		GetSourceCacheTime()			{return m_iSourceCacheTime;}
	// NEO: XSC END

	// NEO: DR - [DownloadReask]
	static	int		GetReaskIntervals()				{return m_iReaskIntervals;}
	static	uint32	GetReaskIntervalsMs(bool bZZ = false)	{return MIN2MS(bZZ ? (GetReaskIntervals() * 7L) / 10L : GetReaskIntervals());}

	static	bool	DontNnPReask()					{return m_bDontNnPReask;}
	static	int		GetNnPReaskIntervals()			{return m_iNnPReaskIntervals;}

	static	bool	DontFullQReask()				{return m_bDontFullQReask;}
	static	int		GetFullQReaskIntervals()		{return m_iFullQReaskIntervals;}
	// NEO: DR END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	static	bool	EnableSourceKeeper()			{return m_bEnableSourceKeeper;}
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	static	bool	EnableSourceStorage()			{return m_bEnableSourceStorage;}
	static	UINT	AutoSaveSources()				{return m_uAutoSaveSources;}
	static	int		GetAutoSaveSourcesIntervals()	{return m_iAutoSaveSourcesIntervals;}
	static	int		GetSourceStorageLimit()			{return m_iSourceStorageLimit;}
	static	UINT	AutoLoadStoredSources()			{return m_bAutoLoadStoredSources;}
	static	bool	UseStorageBootstrap()			{return m_bUseStorageBootstrap;}
	static	int		GetStorageBootstrapTime()		{return m_iStorageBootstrapTime;}
	static	int		GetStorageBootstrapRequirement(){return m_iStorageBootstrapRequirement;}
	static	bool	StoreLowIDSources()				{return m_bStoreLowIDSources;}
	static	bool	StoreAlsoA4AFSources()			{return m_bStoreAlsoA4AFSources;}
	static	UINT	StoreSourcesFileStatus()		{return m_uStoreSourcesFileStatus;}

	static	bool	AutoReaskStoredSources()		{return m_bAutoReaskStoredSources;}
	static	int		GetAutoReaskStoredSourcesLimit(){return m_iAutoReaskStoredSourcesLimit;}
	static	bool	IsTotalSourceRestore()			{return m_bTotalSourceRestore;}
	static	bool	UseAutoReaskStoredSourcesDelay(){return m_bUseAutoReaskStoredSourcesDelay;}
	static	int		GetAutoReaskStoredSourcesDelay(){return m_iAutoReaskStoredSourcesDelay;}

	static	int		GetAutoReaskLoadedSourcesDelay(){return m_iAutoReaskLoadedSourcesDelay;}

	static	bool	GroupStoredSourceReask()		{return m_bGroupStoredSourceReask;}
	static	int		GetStoredSourceGroupIntervals(){return m_iStoredSourceGroupIntervals;}
	static	int		GetStoredSourceGroupSize()		{return m_iStoredSourceGroupSize;}

	static	bool	UseSmoothOutOfDate()			{return m_bUseSmoothOutOfDate;}
	static	int		GetMaxStoredFaildCount()		{return m_iMaxStoredFaildCount;}
	static	int		GetStoredOutOfDate()			{return m_iStoredOutOfDate;}
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	static	bool	EnableSourceList()				{return m_bEnableSourceList && (m_uSaveGlobalSourceList || m_bSaveSourceDataInClient);}
	static	UINT	SaveGlobalSourceList()			{if(!m_bEnableSourceList) return FALSE; return m_uSaveGlobalSourceList;}
	static	int		GetGlobalSourceListCleanUpTime(){return m_iGlobalSourceListCleanUpTime;}
	static	uint32	GetGlobalSourceListCleanUpTimeS(){return D2S(GetGlobalSourceListCleanUpTime());}
	static	bool	IsGlobalSourceListCleanUp()		{return m_bGlobalSourceListCleanUp;}
	static	int		GetGlobalSourceListCleanUpIntervals() {return m_iGlobalSourceListCleanUpIntervals;}
	static	uint32	GetGlobalSourceListCleanUpIntervalsMs() {return HR2MS(GetGlobalSourceListCleanUpIntervals());}
	static	bool	IsFastSourceCleanUp()			{return m_bFastSourceCleanUp && SaveSourceFileList();}
	static	bool	SaveSourceFileList()			{return m_bSaveSourceFileList && EnableSourceList();}
	static	int		GetSourceFileListCleanUpTime()	{return m_iSourceFileListCleanUpTime;}
	static	uint32	GetSourceFileListCleanUpTimeS() {return D2S(GetSourceFileListCleanUpTime());}
	static	bool	SaveSourceDataInClient()		{return m_bSaveSourceDataInClient && EnableSourceList();}

	static	int		GetTableAmountToStore()			{return m_iTableAmountToStore;}

	static	bool	UseIPZoneCheck()				{return m_bIPZoneCheck;}

	static	bool	UseSourceHashMonitor()			{return m_bSourceHashMonitor && EnableSourceList();}
	static	int		GetSourceHashMonitorBadTime()	{return m_iSourceHashMonitorBadTime;}
	static	uint32	GetSourceHashMonitorBadTimeMs()	{return MIN2MS(GetSourceHashMonitorBadTime());}
	static	int		GetSourceHashMonitorMaxBad()	{return m_iSourceHashMonitorMaxBad;}

	static	int		GetIgnoreUnreachableInterval()	{return m_iIgnoreUnreachableInterval;}
	static	uint32	GetIgnoreUnreachableIntervalS()	{return MIN2S(GetIgnoreUnreachableInterval()); }
	static	int		GetIgnoreUndefinedIntervall()	{return m_iIgnoreUndefinedInterval;}
	static	uint32	GetIgnoreUndefinedIntervallS()	{return MIN2S(GetIgnoreUndefinedIntervall()); }
	static	int		GetBeginNewTableInterval()		{return m_iBeginNewTableInterval;}
	static	uint32	GetBeginNewTableIntervalS()		{return HR2S(GetBeginNewTableInterval()); }
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	static	bool	EnableSourceAnalizer()			{return m_bEnableSourceAnalizer;}
	static	int		GetAnaliseIntervals()			{return m_iAnaliseIntervals;}
	static	int		GetTableAmountToAnalise()		{return m_iTableAmountToAnalise;}

	static	bool	DontStoreTemporarySources()		{return m_bDontStoreTemporarySources;}

	static	int		GetPropabilityMode()			{return m_iPropabilityMode;}
	static	float	GetEnhancedFactor()				{return m_fEnhancedFactor;}

	static	int		GetReaskPropability()			{return m_iReaskPropability;}
	static	int		GetReservePropability()			{return m_iReservePropability;}

	static	bool	AutoReserveReask()				{return m_bAutoReserveReask;}
	static	int		GetReserveReaskPropability()	{return m_iReserveReaskPropability;}
	static	bool	UseReaskReserveSourcesDelay()	{return m_bUseReaskReserveSourcesDelay;}
	static	int		GetReaskReserveSourcesDelay()	{return m_iReaskReserveSourcesDelay;}
	static	int		GetReaskReserveSourcesLimit()	{return m_iReaskReserveSourcesLimit;}

	static	bool	AutoTemporaryReask()			{return m_bAutoTemporaryReask;}
	static	int		GetTemporaryReaskPropability()	{return m_iTemporaryReaskPropability;}
	static	bool	UseReaskTemporarySourcesDelay() {return m_bUseReaskTemporarySourcesDelay;}
	static	int		GetReaskTemporarySourcesDelay()	{return m_iReaskTemporarySourcesDelay;}
	static	int		GetReaskTemporarySourcesLimit()	{return m_iReaskTemporarySourcesLimit;}

	//static	int		GetMinAnalisisQuality()			{return m_iMinAnalisisQuality;}

	//static	bool	AutoUnsureReask()				{return m_bAutoUnsureReask;}
	//static	bool	UseReaskUnsureSourcesDelay()	{return m_bUseReaskUnsureSourcesDelay;}
	//static	int		GetReaskUnsureSourcesDelay()	{return m_iReaskUnsureSourcesDelay;}
	//static	int		GetReaskUnsureSourcesLimit()	{return m_iReaskUnsureSourcesLimit;}

	static	bool	UseUnpredictedPropability()		{return m_bUseUnpredictedPropability;}
	static	int		GetUnpredictedPropability()		{return m_iUnpredictedPropability;}
	static	bool	UseReaskUnpredictedSourcesDelay(){return m_bUseReaskUnpredictedSourcesDelay;}
	static	int		GetReaskUnpredictedSourcesDelay(){return m_iReaskUnpredictedSourcesDelay;}
	static	int		GetReaskUnpredictedSourcesLimit(){return m_iReaskUnpredictedSourcesLimit;}

	static	UINT	IsFailTolerance()				{return m_uFailTolerance;}
	static	int		GetMaxFailTolerance()			{return m_iMaxFailTolerance;}
	static	UINT	RetryUnreachable()				{return m_uRetryUnreachable;}
	static	int		GetRetryUnreachableIntervals()	{return m_iRetryUnreachableIntervals;}
	static	int		GetUnreachableReaskPropability(){return m_iUnreachableReaskPropability;}
	static	int		GetReaskUnreachableSourcesLimit(){return m_iReaskUnreachableSourcesLimit;}

	static	bool	HandleTableGaps()				{return m_bHandleTableGaps;}
	static	float	GetPriorityGapRatio()			{return m_fPriorityGapRatio;}
	static	int		GetMaxGapSize()					{return m_iMaxGapSize;}
	static	int		GetMaxGapTime()					{return m_iMaxGapTime;}
	static	uint32	GetMaxGapTimeS()				{return HR2S(GetMaxGapTime()); }
	static	bool	CheckForPriorityIP()			{return m_bCheckPriorityIP;}
	static	float	GetPriorityIPRatio()			{return m_fPriorityIPRatio;}
	static	bool	CheckPortIntegrity()			{return m_bCheckPortIntegrity;}
	static	float	GetPortIntegrityRatio()			{return m_fPortIntegrityRatio;}
	static	float	GetMaxMidleDiscrepanceHigh()	{return m_fMaxMidleDiscrepanceHigh;}
	static	float	GetMaxMidleDiscrepanceLow()		{return m_fMaxMidleDiscrepanceLow;}
	static	int		GetLastSeenDurationThreshold()	{return m_iLastSeenDurationThreshold;}
	static	UINT	UseLinkTimePropability()		{return m_uLinkTimePropability;}
	static	int		GetLinkTimeThreshold()			{return m_iLinkTimeThreshold;}
	static	uint32	GetLinkTimeThresholdS()			{return MIN2S(GetLinkTimeThreshold());}
	static	bool	UseDualLinkedTableGravity()		{return m_bUseDualLinkedTableGravity;}
	static	int		GetDualLinkedTableGravity()		{return m_iDualLinkedTableGravity;}
	static	bool	UseReliableTimeMagnification()	{return m_bReliableTimeMagnification;}
	static	int		GetMaxReliableTime()			{return m_iMaxReliableTime;}
	static	uint32	GetMaxReliableTimeS()			{return HR2S(GetMaxReliableTime());}
	static	int		GetTempralIPBorderLine()		{return m_iTempralIPBorderLine;}
	static	uint32	GetTempralIPBorderLineS()		{return HR2S(GetTempralIPBorderLine()); }
	static	uint32	GetAnaliseIntervalsS()			{return HR2S(GetAnaliseIntervals()); }
#endif // NEO_SA // NEO: NSA END


	// NEO: DS - [DropSources]
	static	UINT	UseDropNnP()					{return m_uDropNnP;}
	static	int		GetDropNnPLimit()				{return m_iDropNnPLimit;}
	static	int		GetDropNnPLimitMode()			{return m_iDropNnPLimitMode;}
	static	int		GetDropNnPTimer()				{return m_iDropNnPTimer;}

	static	UINT	UseDropFullQ()					{return m_uDropFullQ;}
	static	int		GetDropFullQLimit()				{return m_iDropFullQLimit;}
	static	int		GetDropFullQLimitMode()			{return m_iDropFullQLimitMode;}
	static	int		GetDropFullQTimer()				{return m_iDropFullQTimer;}

	static	UINT	UseDropHighQ()					{return m_uDropHighQ;}
	static	int		GetDropHighQValue()				{return m_iDropHighQValue;}
	static	int		GetDropHighQLimit()				{return m_iDropHighQLimit;}
	static	int		GetDropHighQLimitMode()			{return m_iDropHighQLimitMode;}
	static	int		GetDropHighQTimer()				{return m_iDropHighQTimer;}

	static	bool	UseDontAskThisIPList()			{return m_bUseDontAskThisIP;}
	static	int		GetDontAskThisIPCleanUpTime()	{return m_iDontAskThisIPTime;}
	// NEO: DS END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	static bool		UseDropUnreachable()			{return m_bDropUnreachable;}
	static int		GetDropUnreachableLimit()		{return m_iDropUnreachableLimit;}
	static int		GetDropUnreachableLimitMode()	{return m_iDropUnreachableLimitMode;}
	static int		GetDropUnreachableTimer()		{return m_iDropUnreachableTimer;}
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	static bool		UseDropOutOfDate()				{return m_bDropOutOfDate;}
	static bool		UseDropOutOfDateSmooth()		{return m_bDropOutOfDateSmooth;}
	static int		GetDropOutOfDateFails()			{return m_iDropOutOfDateFails;}
	static int		GetDropOutOfDateTime()			{return m_iDropOutOfDateTime;}
	static int		GetDropOutOfDateLimit()			{return m_iDropOutOfDateLimit;}
	static int		GetDropOutOfDateLimitMode()		{return m_iDropOutOfDateLimitMode;}
	static int		GetDropOutOfDateTimer()			{return m_iDropOutOfDateTimer;}
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	static bool		UseDropRetired()				{return m_bDropRetired;}
	static int		GetDropRetiredLimit()			{return m_iDropRetiredLimit;}
	static int		GetDropRetiredLimitMode()		{return m_iDropRetiredLimitMode;}
	static int		GetDropRetiredTimer()			{return m_iDropRetiredTimer;}

	static bool		UseDropLoaded()					{return m_bDropLoaded;}
	static int		GetDropLoadedLimit()			{return m_iDropLoadedLimit;}
	static int		GetDropLoadedLimitMode()		{return m_iDropLoadedLimitMode;}
	static int		GetDropLoadedTimer()			{return m_iDropLoadedTimer;}
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	// NEO: NCAP - [NeoCustomAutoPriority]
	static bool		UseDynamicAutoDownPriority()	{return m_bDynamicAutoDownPriority;}
	static float	GetDynamicDownPriorityFactor()	{return m_fDynamicDownPriorityFactor;}
	static int		GetLowDownPrioThreshold()		{return m_iLowDownPrioThreshold;}
	static int		GetHighDownPrioThreshold()		{return m_iHighDownPrioThreshold;}
	// NEO: NCAP END

	static	UINT	UsePartTraffic()				{return m_uPartTraffic;} // NEO: NPT - [NeoPartTraffic]
	static	int		GetPartTrafficCollors()			{return m_iPartTrafficColor;} // NEO: NPT - [NeoPartTraffic]
	static	int		UseClassicShareStatusBar()		{return m_bClassicShareStatusBar;}

	static	bool	SaveUploadQueueWaitTime()		{return m_bSaveUploadQueueWaitTime;} // NEO: SQ - [SaveUploadQueue]

	// NEO: TQ - [TweakUploadQueue]
	static	bool	UseInfiniteQueue()				{return m_bInfiniteQueue;}

	static	UINT	IsQueueOverFlowRelease()		{return m_uQueueOverFlowRelease;}
	static	int		GetQueueOverFlowRelease()		{return m_iQueueOverFlowRelease;}

	static	UINT	IsQueueOverFlowEx()				{return m_uQueueOverFlowEx;}
	static	int		GetQueueOverFlowEx()			{return m_iQueueOverFlowEx;}

	static	UINT	IsQueueOverFlowDef()			{return m_uQueueOverFlowDef;}
	static	int		GetQueueOverFlowDef()			{return m_iQueueOverFlowDef;}

	static	UINT	IsQueueOverFlowCF()				{return m_uQueueOverFlowCF;}
	static	int		GetQueueOverFlowCF()			{return m_iQueueOverFlowCF;}
	// NEO: TQ END

	static	bool	UseMultiQueue()					{return m_bUseMultiQueue;} // NEO: MQ - [MultiQueue]
	static	bool	UseRandomQueue()				{return m_bUseRandomQueue;} // NEO: RQ - [RandomQueue]

	static	bool	UseOldPrioritySystem()			{return m_bOldPrioritySystem;}

	// NEO: NMFS - [NiceMultiFriendSlots]
	static	bool	IsFriendSlotLimit()				{return m_bFriendSlotLimit;}
	static	int		GetFriendSlotLimit()			{return m_iFriendSlotLimit;}
	// NEO: NMFS END

	// NEO: RT - [ReleaseTweaks]
	static	int		GetReleaseLevel()				{return m_iReleaseLevel;}
	static	int		GetReleaseMode()				{return m_iReleaseMode;}

	static	int		GetReleaseLimitMode()			{return m_iReleaseLimitMode;}
	static	bool	IsReleaseLimitUnion()			{return m_bReleaseLimitUnion;}
	static	int		GetReleaseLimitCompleteMode()			{return m_iReleaseLimitCompleteMode;}

	static	int		IsReleaseLimit()				{return m_iReleaseLimit;}
	static	int		GetReleaseLimitHigh()			{return m_iReleaseLimitHigh;}
	static	int		GetReleaseLimitLow()			{return m_iReleaseLimitLow;}

	static	int		IsReleaseLimitComplete()		{return m_iReleaseLimitComplete;}
	static	int		GetReleaseLimitCompleteHigh()	{return m_iReleaseLimitCompleteHigh;}
	static	int		GetReleaseLimitCompleteLow()	{return m_iReleaseLimitCompleteLow;}

	static	bool	IsLimitUnion()					{return m_bLimitUnion;}

	static	int		GetSourceLimitMode()			{return m_iSourceLimitMode;}
	static	bool	IsSourceLimitUnion()			{return m_bSourceLimitUnion;}
	static	int		GetSourceLimitCompleteMode()	{return m_iSourceLimitCompleteMode;}

	static	int		IsSourceLimit()					{return m_iSourceLimit;}
	static	int		GetSourceLimitHigh()			{return m_iSourceLimitHigh;}
	static	int		GetSourceLimitLow()				{return m_iSourceLimitLow;}

	static	int		IsSourceLimitComplete()			{return m_iSourceLimitComplete;}
	static	int		GetSourceLimitCompleteHigh()	{return m_iSourceLimitCompleteHigh;}
	static	int		GetSourceLimitCompleteLow()		{return m_iSourceLimitCompleteLow;}

	static	bool	IsReleaseNeedComplete()			{return m_bReleaseNeedComplete;}
	static	int		GetReleaseNeedCompleteLimit()	{return m_iReleaseNeedCompleteLimit;}

	static	UINT	IsReleaseSlotLimit()			{return m_uReleaseSlotLimit;}
	static	int		GetReleaseSlotLimit()			{return m_iReleaseSlotLimit;}
	// NEO: RT END

	// NEO: NCAP - [NeoCustomAutoPriority]
	static bool		UseDynamicAutoUpPriority()		{return m_bDynamicAutoUpPriority;}
	static float	GetDynamicUpPriorityFactor()	{return m_fDynamicUpPriorityFactor;}
	static int		GetLowUpPrioThreshold()			{return m_iLowUpPrioThreshold;}
	static int		GetHighUpPrioThreshold()		{return m_iHighUpPrioThreshold;}
	// NEO: NCAP END

	// NEO: PRSF - [PushSmallRareFiles]
	static	bool	IsPushSmallFiles()				{return m_bPushSmallFiles;}
	static	int		GetPushSmallFilesSize()			{return m_iPushSmallFilesSize;}

	static	bool	IsPushRareFiles()				{return m_bPushRareFiles;}
	static	int		GetPushRareFilesValue()			{return m_iPushRareFilesValue;}

	static	bool	IsPushRatioFiles()				{return m_bPushRatioFiles;}
	static	int		GetPushRatioFilesValue()			{return m_iPushRatioFilesValue;}
	// NEO: PRSF END 

	static	bool	UseNeoScoreSystem()				{return m_bNeoScoreSystem || m_iOtherCreditSystem > 0;} // NEO: NFS - [NeoScoreSystem]
	static	bool	UseNeoCreditSystem()			{return m_bNeoCreditSystem;} // NEO: NCS - [NeoCreditSystem]
	static	int		GetCreditSystem()				{return m_iOtherCreditSystem;} // NEO: OCS - [OtherCreditSystems]

	// NEO: IPS - [InteligentPartSharing]
	static	bool	IsInteligentPartSharing()			{return m_bInteligentPartSharing;}
	static	int		GetInteligentPartSharingTimer()		{return m_iInteligentPartSharingTimer;}
	static	uint32	GetInteligentPartSharingTimerMs()	{return MIN2MS(m_iInteligentPartSharingTimer);}
	static	int 	GetMaxProzentToHide()				{return m_iMaxProzentToHide;}

	static	int		IsHideOverAvaliblyParts()			{return m_iHideOverAvaliblyParts;}
	static	int		GetHideOverAvaliblyMode()			{return m_iHideOverAvaliblyMode;}
	static	float	GetHideOverAvaliblyValue()			{return m_fHideOverAvaliblyValue;}
	static	int		GetHideOverAvaliblyCatch()			{return m_iHideOverAvaliblyCatch;}

	static	int		IsHideOverSharedParts()				{return m_iHideOverSharedParts;}
	static	int		GetHideOverSharedMode()				{return m_iHideOverSharedMode;}
	static	float	GetHideOverSharedValue()			{return m_fHideOverSharedValue;}
	static	int		GetHideOverSharedCalc()				{return m_iHideOverSharedCalc;}
	
	static	int		IsDontHideUnderAvaliblyParts()		{return m_iDontHideUnderAvaliblyParts;}
	static	int		GetDontHideUnderAvaliblyMode()		{return m_iDontHideUnderAvaliblyMode;}
	static	float	GetDontHideUnderAvaliblyValue()		{return m_fDontHideUnderAvaliblyValue;}

	static	int		IsBlockHighOverAvaliblyParts()		{return m_iBlockHighOverAvaliblyParts;}
	static	float	GetBlockHighOverAvaliblyFactor()	{return m_fBlockHighOverAvaliblyFactor;}

	static	int		IsBlockHighOverSharedParts()		{return m_iBlockHighOverSharedParts;}
	static	float	GetBlockHighOverSharedFactor()		{return m_fBlockHighOverSharedFactor;}

	static	int		IsShowAlwaysNeeded()				{return m_iShowAlwaysNeeded;}
	static	int		GetShowAlwaysParts()				{return m_iShowAlwaysParts;}

	static	int		IsShowAlwaysIncomplete()			{return m_iShowAlwaysIncomplete;}
	// NEO: IPS END

	// NEO: NC - [NiceCommunity]
	static	bool	IsCommunityEnabled()				{return (!m_sCommunity.IsEmpty());} 
	static	CString& GetCommunityName()					{return m_sCommunity;} 
	// NEO: NC END
	
#ifdef ARGOS // NEO: NA - [NeoArgos]
	static	bool	UseArgosSystem()					{return m_bUseArgosSystem;}

	static	int		GetCreditCompensation()				{return m_iCreditCompensation;}

	static	bool	TrustUnArgosHashThief()				{return m_bTrustUnArgosHashThief;}
	static	bool	TrustUnArgosHashChanged()			{return m_bTrustUnArgosHashChanged;}
	static	bool	TrustUnArgosGhostMode()				{return m_bTrustUnArgosGhostMode;}
	static	bool	TrustUnArgosAgressiv()				{return m_bTrustUnArgosAgressiv;}
	static	bool	IsArgosTrustTest()					{return TrustUnArgosHashThief() || TrustUnArgosHashChanged() || TrustUnArgosGhostMode() || TrustUnArgosAgressiv();}
	static	int		GetArgosTrustTime()					{return m_iArgosTrustTime;}
	static	uint32	GetArgosTrustTimeMs(bool bProcess = false) {return MIN2MS(GetArgosTrustTime()/(bProcess ? 4 : 1));}

	static	UINT	CloseMaellaBackdoor()				{return m_uCloseMaellaBackdoor;}

	static	UINT	IsDontBanFriends()					{return m_uDontBanFriends;}
	static	UINT	IsDontBanCommunity()				{return m_uDontBanCommunity;}

	static	int		GetArgosProcessTime()				{return m_iArgosProcessTime;}
	static	uint32	GetArgosProcessTimeMs(bool bProcess = false) {return MIN2MS(GetArgosProcessTime()/(bProcess ? 2 : 1));}
	static	int		GetArgosTrackTime()					{return m_iArgosTrackTime;}
	static	uint32	GetArgosTrackTimeMs()				{return MIN2MS(GetArgosTrackTime());}
	static	int		GetArgosGenericBanTime() 			{return m_iArgosGenericBanTime;}
	static	uint32	GetArgosGenericBanTimeMs()			{return MIN2MS(GetArgosGenericBanTime());}
	static	int		GetArgosCorruptedSenderTime()		{return m_iArgosCorruptedSenderTime;}
	static	uint32	GetArgosCorruptedSenderTimeMs()		{return MIN2MS(GetArgosCorruptedSenderTime());}
	static	int		GetArgosFileScannerTime()			{return m_iArgosFileScannerTime;}
	static	uint32	GetArgosFileScannerTimeMs()			{return MIN2MS(GetArgosFileScannerTime());}
	static	int		GetArgosFileFakerTime()				{return m_iArgosFileFakerTime;}
	static	uint32	GetArgosFileFakerTimeMs()			{return MIN2MS(GetArgosFileFakerTime());}
	static	int		GetArgosAgressionBanTime()			{return m_iArgosAgressionBanTime;}
	static	uint32	GetArgosAgressionBanTimeMs()		{return MIN2MS(GetArgosAgressionBanTime());}
	static	int		GetArgosOpCodeTime()				{return m_iArgosOpCodeTime;}
	static	uint32	GetArgosOpCodeTimeMs()				{return MIN2MS(GetArgosOpCodeTime());}
	static	int		GetArgosHashChangedTime()			{return m_iArgosHashChangedTime;}
	static	uint32	GetArgosHashChangedTimeMs()			{return MIN2MS(GetArgosHashChangedTime());}
	static	int		GetArgosRankFlooderTime()			{return m_iArgosRankFlooderTime;}
	static	uint32	GetArgosRankFlooderTimeMs()			{return MIN2MS(GetArgosRankFlooderTime());}
	static	int		GetArgosGhostModeTime()				{return m_iArgosGhostModeTime;}
	static	uint32	GetArgosGhostModeTimeMs()			{return MIN2MS(GetArgosGhostModeTime());}
	static	int		GetArgosFailedTime()				{return m_iArgosFailedTime;}
	static	uint32	GetArgosFailedTimeMs()				{return MIN2MS(GetArgosFailedTime());}
	static	int		GetArgosXSExploitTime()				{return m_iArgosXSExploitTime;}
	static	uint32	GetArgosXSExploitTimeMs()			{return MIN2MS(GetArgosXSExploitTime());}
	static	int		GetArgosNickChangerTime()			{return m_iArgosNickChangerTime;}
	static	uint32	GetArgosNickChangerTimeMs()			{return MIN2MS(GetArgosNickChangerTime());}
	static	int		GetArgosModChangerTime()			{return m_iArgosModChangerTime;}
	static	uint32	GetArgosModChangerTimeMs()			{return MIN2MS(GetArgosModChangerTime());}
	static	int		GetArgosSpamTime()					{return m_iArgosSpamTime;}
	static	uint32	GetArgosSpamTimeMs()				{return MIN2MS(GetArgosSpamTime());}
	static	int		GetArgosBadHelloTime()				{return m_iArgosBadHelloTime;}
	static	uint32	GetArgosBadHelloTimeMs()			{return MIN2MS(GetArgosBadHelloTime());}
	static	int		GetArgosBadProtTime()				{return m_iArgosBadProtTime;}
	static	uint32	GetArgosBadProtTimeMs()				{return MIN2MS(GetArgosBadProtTime());}

	static	int		GetArgosGPLBreakerPunishment()		{return m_iArgosGPLBreakerPunishment;}
	static	int		GetArgosHardLeecherPunishment()		{return m_iArgosHardLeecherPunishment;}
	static	int		GetArgosNormalLeecherPunishment()	{return m_iArgosNormalLeecherPunishment;}
	static	int		GetArgosSoftLeecherPunishment()		{return m_iArgosSoftLeecherPunishment;}
	static	int		GetArgosBadModPunishment()			{return m_iArgosBadModPunishment;}
	static	int		GetArgosNickThiefPunishment()		{return m_iArgosNickThiefPunishment;}
	static	int		GetArgosModThiefPunishment()		{return m_iArgosModThiefPunishment;}
	static	int		GetArgosHashThiefPunishment()		{return m_iArgosHashThiefPunishment;}
	static	int		GetArgosCreditHackPunishment()		{return m_iArgosCreditHackPunishment;}
	static	int		GetArgosHashChangedPunishment()		{return m_iArgosHashChangedPunishment;}
	static	int		GetArgosGhostModePunishment()		{return m_iArgosGhostModePunishment;}
	static	int		GetArgosFakeClientPunishment()		{return m_iArgosFakeClientPunishment;}
	static	int		GetArgosAgressonPunishment()		{return m_iArgosAgressonPunishment;}
	static	int		GetArgosFileScannerPunishment()		{return m_iArgosFileScannerPunishment;}
	static	int		GetArgosFileFakerPunishment()		{return m_iArgosFileFakerPunishment;}
	static	int		GetArgosCorruptedSenderPunishment()	{return m_iArgosCorruptedSenderPunishment;}
	static	int		GetArgosRankFlooderPunishment()		{return m_iArgosRankFlooderPunishment;}
	static	int		GetArgosFailedPunishment()			{return m_iArgosFailedPunishment;}
	static	int		GetArgosXSExploitPunishment()		{return m_iArgosXSExploitPunishment;}
	static	int		GetArgosNickChangerPunishment()		{return m_iArgosNickChangerPunishment;}
	static	int		GetArgosModChangerPunishment()		{return m_iArgosModChangerPunishment;}
	static	int		GetArgosSpamPunishment()			{return m_iArgosSpamPunishment;}
	static	int		GetArgosBadHelloPunishment()		{return m_iArgosBadHelloPunishment;}
	static	int		GetArgosBadProtPunishment()			{return m_iArgosBadProtPunishment;}

	static	bool	UseArgosDetectionEngine()			{return (IsArgosLeecherModDetection() || IsArgosLeecherNickDetection() 
																|| IsArgosOpcodeDetection() || IsArgosFakeClientDetection() == TRUE 
																|| IsArgosSpamDetection() == TRUE) && UseArgosSystem() && (IsDLPDetection() != 2);} // dlp may be used in exclusiv mode
	static	bool	IsArgosLeecherModDetection()		{return m_bArgosLeecherModDetection && UseArgosSystem();}
	static	UINT	IsArgosLeecherNickDetection()		{if(!UseArgosSystem())return FALSE; return m_uArgosLeecherNickDetection;}
	static	int		GetArgosDetectionLevel()			{return m_iArgosDetectionLevel;}
	static	bool	IsArgosOpcodeDetection()			{return m_bArgosOpcodeDetection && UseArgosSystem();}
	static	bool	IsArgosLeecherHashDetection()		{return m_bArgosLeecherHashDetection && UseArgosSystem();}	
	static	bool	IsArgosNickThiefDetection()			{return m_bArgosNickThiefDetection && UseArgosSystem();}
	static	bool	IsPlainAntiNickThief()				{return m_bPlainAntiNickThief;}
	static	bool	IsArgosModThiefDetection()			{return m_bArgosModThiefDetection;}
	static	bool	IsArgosHashThiefDetection()			{return m_bArgosHashThiefDetection  && UseArgosSystem();}
	static	bool	UseHashThiefZoneDetection()			{return m_bArgosThiefZoneDetection && IsArgosHashThiefDetection();}
	static	bool	IsArgosCreditHackDetection()		{return m_bArgosCreditHackDetection;}
	static	bool	IsHashChangeDetection()				{return m_bHashChangeDetection;}
	static	bool	IsClassicHashChangeDetection()		{return IsHashChangeDetection() && !IsArgosHashChangeDetection();}
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	static	bool	IsArgosHashChangeDetection()		{return IsHashChangeDetection() && m_iHashChangeDetectionMode == 1 && UseSourceHashMonitor();}
#else
	static	bool	IsArgosHashChangeDetection()		{return IsHashChangeDetection() && m_iHashChangeDetectionMode == 1;}
#endif // NEO_CD // NEO: NCD END
	static	bool	IsArgosGhostModDetection()			{return m_bArgosGhostModDetection;}
	static	UINT	IsArgosFakeClientDetection()		{return m_uArgosFakeClientDetection;}
	static	UINT	IsAgressionDetection()				{return m_uAgressionDetection;}
	static	int		GetAgressionIntervals()				{return m_iAgressionIntervals;}
	static	uint32	GetAgressionIntervalsMs()			{return MIN2MS(GetAgressionIntervals());}
	static	int		GetAgressionThreshold()				{return m_iAgressionThreshold;}
	static	bool	IsFileScannerDetection()			{return m_bFileScannerDetection;}
	static	bool	IsFileFakerDetection()				{return m_bFileFakerDetection;}
	static	bool	IsBadSenderDetection()				{return m_bBadSenderDetection;}
	static	bool	IsRankFloodDetection()				{return m_bRankFloodDetection;}
	static	bool	IsFailedDetection()					{return m_bFailedDetection && UseArgosSystem();}
	static	int		GetFailedTries()					{return m_iFailedTries;}
	static	int		GetFailedThreshold()				{return m_iFailedThreshold;}
	static	bool	IsArgosXSExploitDetection()			{return m_bXSExploitDetection && UseArgosSystem();}
	static	int		GetArgosXSExploitIntervals()		{return m_iXSExploitIntervals;}
	static	uint32	GetArgosXSExploitIntervalsMs()		{return MIN2MS(GetArgosXSExploitIntervals());}
	static	int		GetArgosXSExploitThreshold()		{return m_iXSExploitThreshold;}
	static	bool	IsArgosNickChangerDetection()		{return m_bNickChangerDetection && UseArgosSystem();}
	static	int		GetArgosNickChangeIntervals()		{return m_iNickChangeIntervals;}
	static	uint32	GetArgosNickChangeIntervalsMs()		{return MIN2MS(GetArgosNickChangeIntervals());}
	static	int		GetArgosNickChangeThreshold()		{return m_iNickChangeThreshold;}
	static	bool	IsArgosModChangerDetection()		{return m_bModChangerDetection && UseArgosSystem();}
	static	int		GetArgosModChangeIntervals()		{return m_iModChangeIntervals;}
	static	uint32	GetArgosModChangeIntervalsMs()		{return MIN2MS(GetArgosModChangeIntervals());}
	static	int		GetArgosModChangeThreshold()		{return m_iModChangeThreshold;}
	static	bool	IsArgosSpamDetection()				{return m_bSpamDetection;}
	static	bool	IsArgosBadHelloDetection()			{return m_bBadHelloDetection;}
	//static	bool	IsArgosMD4HelloDetection()			{return m_bMD4HelloDetection;}
	static	UINT	IsArgoseMCryptDetection()			{return m_ueMCryptDetection;}
	static	bool	IsArgosBadProtDetection()			{return m_bBadProtDetection;}
	static	UINT	IsDLPDetection()					{if(!UseArgosSystem())return FALSE; return m_uDLPDetection;}

	static	bool	IsArgosLogLeechers()				{return m_bArgosLogLeechers;}
#endif // ARGOS // NEO: NA END

	static	bool	UseChunkDots()					{return m_bUseChunkDots;}// NEO: MOD - [ChunkDots]
	static	bool	UseRelativeChunkDisplay()		{return m_bUseRelativeChunkDisplay;} // NEO: MOD - [RelativeChunkDisplay]
	static	bool	UseTreeStyle()					{return m_bUseTreeStyle;} // NEO: NTS - [NeoTreeStyle]
	static	bool	ShowFileTypeIcon()				{return m_bShowFileTypeIcon;} // NEO: NI - [NewIcons]
	static	bool	ShowFileStatusIcons()			{return m_bShowFileStatusIcons;} // NEO: FSI - [FileStatusIcons]
	static	bool	CollorShareFiles()				{return m_bCollorShareFiles;}
	static	bool	ShowBanner()					{return m_bShowBanner;}
	static	bool	ShowHashProgres()				{return m_bShowHashProgres;}
	static	UINT	UsePlusSpeedMeter()				{return m_uUsePlusSpeedMeter;} // NEO: PSM - [PlusSpeedMeter]
	// NEO: NSTI - [NewSystemTrayIcon]
	static	bool	IsShowSystemTrayUpload()		{return m_bShowSystemTrayUpload;}
	static	bool	UseThinSystemTrayBars()			{return m_bThinSystemTrayBars;}
	static	int		GetTrayBarsMaxCollor()			{return m_iTrayBarsMaxCollor;}
	// NEO: NSTI END
	static	bool	UseStaticTrayIcon()				{return m_bStaticTrayIcon;} // NEO: STI - [StaticTray]
	static	UINT	DisableAutoSort()				{return m_uDisableAutoSort;} // NEO: SE - [SortExtension]
	static	UINT	ShowClientPercentage()			{return m_uShowClientPercentage;} // NEO: MOD - [Percentage]

	// NEO: SI - [SysInfo]
	static	bool	DrawSysInfoGraph()				{return m_bDrawSysInfoGraph;} 
	static	bool	ShowSysInfoOnTitle()			{return m_bShowSysInfoOnTitle;} 
	// NEO: SI END

	// NEO: NTB - [NeoToolbarButtons]
	static	UINT	UseNeoToolbar()					{return m_uNeoToolbar;} 
	static	int		GetNeoToolbarButtonCount()		{return m_iNeoToolbarButtonCount;} 
	static	UINT	GetNeoToolbarButton(int btn)	{if(btn<m_NeoToolbarButtons.GetCount()) return m_NeoToolbarButtons[btn]; else return 0;} 
	// NEO: NTB END
	
	// NEO: CTB - [CoolToolBar]
	static	bool	UseCoolToolbar()				{return m_bCoolToolbar;}
	static	UINT	UseCoolToolbarText()			{return m_uCoolToolbarText;}
	static	int		GetCoolToolbarCenter()			{return m_iCoolToolbarCenter;}
	static	int		GetCoolToolbarRight()			{return m_iCoolToolbarRight;}
	static	int		GetCoolToolbarButtonCount()		{return m_iCoolToolbarButtonCount;}
	static	UINT	GetCoolToolbarButton(int btn)	{if(btn<m_CoolToolbarButtons.GetCount()) return m_CoolToolbarButtons[btn]; else return 0;} 
	// NEO: CTB END

	// NEO: NMX - [NeoMenuXP]
	static	bool	GetXPSideBar()					{return m_bShowXPSideBar;}
	static	bool	GetXPBitmap()					{return	m_bShowXPBitmap;}
	static  int 	GetXPMenuStyle()				{return	m_iXPMenuStyle;}
	static	bool	UseGrayMenuIcons()				{return m_bGrayMenuIcon;}
	// NEO: NMX END

	// NEO: MM - [NeoMiniMule]
	static	bool 	EnableMiniMule()				{return m_bEnableMiniMule;} 
	static	bool 	AutoShowMiniMule()				{return m_bAutoShowMiniMule && m_bEnableMiniMule;} 

	static	bool	IsMiniMuleOnTop()				{return m_bMiniMuleOnTop;} 

	static	bool	IsMiniMuleUpdate()				{return m_bUpdateHidenMiniMule && m_bEnableMiniMule;} 
	static	UINT	GetMiniMuleTransparency()		{return m_uMiniMuleTransparency;} 

	static	bool 	UseMiniMuleBackground()			{return m_bMiniMuleBack;} 
	
	static	CString GetMiniMuleLabel()				{return m_sMiniMuleLabel;}
	// NEO: MM END

	// NEO: IM - [InvisibelMode] -- Xanatos -->
	static	bool	GetInvisibleMode()				{ return m_bInvisibleMode; }
	static	UINT	GetInvisibleModeHKKeyModifier()	{ return m_iInvisibleModeHotKeyModifier; }
	static	TCHAR	GetInvisibleModeHKKey()			{ return m_cInvisibleModeHotKey; }
	static	void	SetInvisibleMode(bool on, UINT keymodifier, TCHAR key);
	// NEO: IM END <-- Xanatos --

	// NEO: TPP - [TrayPasswordProtection]
	static	bool	IsTrayPasswordProtection()		{ return m_bTrayPasswordProtection; }
	static	CString	GetTrayPassword()				{ return m_sTrayPassword; }
	// NEO: TPP END

	static	bool	IsShowMyFullInfo()				{ return m_bShowMyFullInfo; }

	static	bool	SmoothStatisticsGraphs()		{ return m_bSmoothStatisticsGraphs; }

	// NEO: MMR - [MorphMassRemane]
	static	void	SetSimpleCleanupOptions(int SimpleCleanupOptions)				{ m_SimpleCleanupOptions = SimpleCleanupOptions; }
	static	int 	GetSimpleCleanupOptions()										{ return m_SimpleCleanupOptions; }
	static	void	SetSimpleCleanupSearch(CString SimpleCleanupSearch)				{ m_SimpleCleanupSearch = SimpleCleanupSearch; }
	static	CString	GetSimpleCleanupSearch()										{ return m_SimpleCleanupSearch; }
	static	void	SetSimpleCleanupReplace(CString SimpleCleanupReplace)			{ m_SimpleCleanupReplace = SimpleCleanupReplace; }
	static	CString	GetSimpleCleanupReplace()										{ return m_SimpleCleanupReplace; }
	static	void	SetSimpleCleanupSearchChars(CString SimpleCleanupSearchChars)	{ m_SimpleCleanupSearchChars = SimpleCleanupSearchChars; }
	static	CString	GetSimpleCleanupSearchChars()									{ return m_SimpleCleanupSearchChars; }
	static	void	SetSimpleCleanupReplaceChars(CString SimpleCleanupReplaceChars)	{ m_SimpleCleanupReplaceChars = SimpleCleanupReplaceChars; }
	static	CString	GetSimpleCleanupReplaceChars()									{ return m_SimpleCleanupReplaceChars; }
	// NEO: MMR END

	// NEO: CRC - [MorphCRCTag]
	static	bool    GetDontAddCRCToFilename ()								{ return m_bDontAddCRCToFilename; }
	static	void	SetDontAddCRCToFilename (bool DontAddCRCToFilename)		{ m_bDontAddCRCToFilename = DontAddCRCToFilename; }
	static	bool    GetCRC32ForceUppercase ()								{ return m_bCRC32ForceUppercase; }
	static	void	SetCRC32ForceUppercase (bool CRC32ForceUppercase)		{ m_bCRC32ForceUppercase = CRC32ForceUppercase; }
	static	bool    GetCRC32ForceAdding ()									{ return m_bCRC32ForceAdding; }
	static	void	SetCRC32ForceAdding (bool CRC32ForceAdding)				{ m_bCRC32ForceAdding = CRC32ForceAdding; }
	static	CString GetCRC32Prefix ()										{ return m_sCRC32Prefix; }
	static	void	SetCRC32Prefix (CString CRC32Prefix)					{ m_sCRC32Prefix = CRC32Prefix; }
	static	CString GetCRC32Suffix ()										{ return m_sCRC32Suffix; }
	static	void	SetCRC32Suffix (CString sCRC32Suffix)					{ m_sCRC32Suffix = sCRC32Suffix; }
	// NEO: CRC END

	static int		GetMaxUploadSlots()				{return m_iMaxUploadSlots;}
	static int		GetMinUploadSlots()				{return m_iMinUploadSlots;}
	static float	GetUploadPerSlots()				{return m_fUploadPerSlots;}
	static uint32	GetUploadPerSlotsB()			{return (uint32)KB2B(GetUploadPerSlots());}
	static uint32	GetUploadPerSlotsDrB()			{return (uint32)KB2B((GetUploadPerSlots()*2)/3);}

	// NEO: QS - [QuickStart]
	static	UINT	UseQuickStart()					{return m_uQuickStart;}
	static	int		GetQuickStartMaxTime()			{return m_iQuickStartTime;}
	static	int		GetQuickStartMaxTimeMs()		{return MIN2MS(m_iQuickStartTime);}
	static	int		GetQuickStartTimePerFile()		{return m_iQuickStartTimePerFile;}
	static	int		GetQuickStartTimePerFileMs()	{return SEC2MS(m_iQuickStartTimePerFile);}

	static	bool	OnQuickStart()					{return m_bOnQuickStart;}
	static	void	SetOnQuickStart(bool in)		{m_bOnQuickStart = in;}
	// NEO: QS END

	// NEO: RIC - [ReaskOnIDChange]
	static	UINT	IsCheckIPChange()				{return m_uCheckIPChange;}
	static	bool	IsInformOnIPChange()			{return m_bInformOnIPChange;}
	static	bool	IsReAskOnIPChange()				{return m_bReAskOnIPChange;}
	static	bool	UseQuickStartOnIPChange()		{return m_bQuickStartOnIPChange;} // NEO: QS - [QuickStart]
	static	bool	IsCheckL2HIDChange()			{return m_bCheckL2HIDChange;}
	static	bool	IsReconnectKadOnIPChange()		{return m_bReconnectKadOnIPChange;}
	static  bool	IsRebindSocketsOnIPChange()		{return m_bRebindSocketsOnIPChange;}
	// NEO: RIC END

	// NEO: RKF - [RecheckKadFirewalled]
	static	bool	IsRecheckKadFirewalled()		{return m_bRecheckKadFirewalled;}
	static	int		GetRecheckKadFirewalled()		{return m_iRecheckKadFirewalled;}
	static	uint32	GetRecheckKadFirewalledMs()		{return MIN2MS(GetRecheckKadFirewalled());}
	// NEO: RKF END

	// NEO: RLD - [ReconnectOnLowID]
	static bool		ReConnectOnLowID()				{return m_bReConnectOnLowID;}
	static int		GetLowIDRetrys()				{return m_iReConnectOnLowID;}
	// NEO: RLD END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	static	bool	IsLanSupportEnabled()			{return IsLancastEnabled() || IsVoodooEnabled();}
#else
	static	bool	IsLanSupportEnabled()			{return IsLancastEnabled();}
#endif // VOODOO // NEO: VOODOO END

	static	bool	IsLancastEnabled()				{return m_bLancastEnabled;}

	static	uint16	GetMaxLanDownload()				{return m_iMaxLanDownload ? m_iMaxLanDownload : UNLIMITED;}
	static	bool	IsDirectLanDownload()			{return m_bDirectLanDownload;}
	static	bool	IsSetLanDownloadBuffer()		{return m_bSetLanDownloadBuffer;}
	static	int		GetLanDownloadBufferSize()		{return m_iLanDownloadBufferSize;}

	static	uint16	GetMaxLanUpload()				{return m_iMaxLanUpload ? m_iMaxLanUpload : UNLIMITED;}
	static	bool	IsDirectLanUpload()				{return m_bDirectLanUpload;}
	static	bool	IsSetLanUploadBuffer()			{return m_bSetLanUploadBuffer;}
	static	int		GetLanUploadBufferSize()		{return m_iLanUploadBufferSize;}

	static	int		GetMaxLanUploadSlots()			{return m_iMaxLanUploadSlots;}

	static	bool	IsCustomizedLanCast()			{return m_bCustomizedLanCast;}
	static	CString	GetLanCastGroup();
	static	uint16	GetLanCastPort();

	static	bool	IsCustomLanCastAdapter()		{return m_bCustomLanCastAdapter;}
	static	DWORD	GetLanCastAdapterIPAdress()		{return m_uLanCastAdapterIPAdress;}
	static	DWORD	GetLanCastAdapterSubNet()		{return m_uLanCastAdapterSubNet;}

	static	int		GetLANIntervals()				{return m_iLANIntervals;}

	static	uint32	GetLanReaskIntervals()			{return m_iLanReaskIntervals;}
	static	uint32	GetNnPLanReaskIntervals()		{return m_iNnPLanReaskIntervals;}

	static	bool	IsAutoBroadcastLanFiles()		{return m_bAutoBroadcastLanFiles;}
	static	int		GetAutoBroadcastLanFiles()		{return m_iAutoBroadcastLanFiles;}
	static	uint32	GetAutoBroadcastLanFilesMs()	{return SEC2MS(GetAutoBroadcastLanFiles());}

	static	bool	UseLanMultiTransfer()			{return m_bUseLanMultiTransfer;}
#endif //LANCAST // NEO: NLC END

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	static	bool	IsVoodooEnabled()				{return UseVoodooTransfer() || IsSlaveAllowed();} // Voodoo generaly enabled
	static	bool	IsVoodooAllowed()				{return IsSlaveAllowed() || IsSlaveHosting();} // Allow incomming voodoo requests
	static	bool	UseVoodooTransfer()				{return m_bUseVoodooTransfer;} // use voodoo download
	static	bool	IsSlaveAllowed()				{return m_bSlaveAllowed;} // Allow using this clinet as slave
	static	bool	IsSlaveHosting()				{return m_bSlaveHosting;} // Allow slave to connect this master

	static	CString	GetVoodooSpell()				{return m_sVoodooSpell;} // voodoo spell, somethink like password
	static	uint16	GetVoodooPort()					{return m_nVoodooPort;} // Voodoo Port

	static	UINT	IsAutoConnectVoodoo()			{return m_uAutoConnectVoodoo;} // Connect to Voodl clinets ftom list

	static	UINT	UseVirtualVoodooFiles()			{return m_uUseVirtualVoodooFiles;} // dont create local copies of the voodoo data file
	static	bool	IsHideVoodooFiles()				{return m_bHideVoodooFiles;} // dont hide voodoo files form lists by default


	static	UINT	UseVoodooSourceExchange()		{if(!IsVoodooEnabled()) return FALSE; return m_uUseVoodooSourceExchange;} // exchange/export sources between clients

	static	bool	UseVoodooSearch(bool bSlaveSide = false) {return IsVoodooEnabled() && m_bUseVoodooSearch && (!bSlaveSide || m_bSlaveAllowed); } // voodoo search forwarding

	static	bool	IsVoodooNeoCommands()			{if(!IsVoodooEnabled()) return FALSE; return m_bVoodooNeoCommands;} // voodoo for Neo neo commands
	static	bool	IsVoodooNeoPreferences()		{if(!IsVoodooEnabled()) return FALSE; return m_bVoodooNeoPreferences;} // voodoo for Neo neo preferences

	static	UINT	IsVoodooCastEnabled()			{if(!IsVoodooAllowed()) return FALSE; return m_uVoodooCastEnabled;} // Enable Voofo lancast extension
	static	UINT	SearchForSlaves()				{if(!IsSlaveAllowed()) return FALSE; return m_uSearchForSlaves;} // Search lan for slavs
	static	UINT	SearchForMaster()				{if(!IsSlaveHosting()) return FALSE; return m_uSearchForMaster;} // Search lan for master
	static	int		VoodooSearchIntervals()			{return m_iVoodooSearchIntervals;}
	static	uint32	VoodooSearchIntervalsMs()		{return MIN2MS(VoodooSearchIntervals());}
#endif // VOODOO // NEO: VOODOO END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	static	bool	ShowCatNameInDownList()			{ return m_bShowCatNames; }
	static	UINT	ShowCategoryFlags()				{ return m_uShowCategoryFlags; }
	static	bool	SelectCatForNewDL()				{ return m_bSelCatOnAdd; }
	static	bool	UseActiveCatForLinks()			{ return m_bActiveCatDefault; }
	static	bool	AutoSetResumeOrder()			{ return m_bAutoSetResumeOrder; }
	static	bool	SmallFileDLPush()				{ return m_bSmallFileDLPush; }
	static	int 	SmallFileDLPushSize()			{ return m_iSmallFileDLPush; }
	static	EMFileSize 	SmallFileDLPushSizeB()		{ return KB2B((uint64)SmallFileDLPushSize()); }
	static	bool	StartDLInEmptyCats()			{ return m_bStartDLInEmptyCats; } 
	static	int 	StartDLInEmptyCatsAmount()		{ return m_iStartDLInEmptyCats; } // 0 = disabled, otherwise num to resume
	static	bool	UseAutoCat()					{ return m_bUseAutoCat; }
	static	bool	CheckAlreadyDownloaded()		{ return m_bCheckAlreadyDownloaded; }

	static	bool	IsStartNextFileByPriority()		{ return m_bStartNextFileByPriority; }

	static	bool	UseSmartA4AFSwapping()			{ return m_bSmartA4AFSwapping; } // only for NNP swaps and file completes, stops, cancels, etc.
	static	int 	AdvancedA4AFMode()				{ return m_iAdvancedA4AFMode; } // 0 = disabled, 1 = balance, 2 = stack -- controls the balancing routines for on queue sources
#endif // A4AF_CATS // NEO: MAC END

	static	UINT	UseLugdunumCredits()			{ return m_uUseLugdunumCredits; } // NEO: KLC - [KhaosLugdunumCredits]
	static	bool	IsPreferShareAll()				{ return m_bPreferShareAll; } // NEO: PSA - [PreferShareAll]
	// NEO: ASF - [AdvancedServerFilter]
	static	bool	IsDontRemoveStaticServers()		{ return m_bDontRemoveStaticServers; }
	static	bool	IsServerFilterAutoDelEnabled()	{ return m_bServerFilterAutoDel; }
	static	int		GetServerFilter()				{ return m_iServerFilter; }
	static	CString& GetServerFilterVal()			{ return m_sServerFilterVal; }
	static	bool	GetServerFilterDataless()		{ return m_bServerFilterDataless; }
	// NEO: ASF END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	static	int		GetIP2CountryNameMode()			{ return m_iIP2CountryNameMode; }
	static	UINT	IsIP2CountryShowFlag()			{ return m_uIP2CountryShowFlag; }
#endif // IP2COUNTRY // NEO: IP2C END
	static	bool	UseFakeCheck()					{ return m_bUseFakeCheck; } // NEO: FC - [FakeCheck]

	// NEO: FDC - [FileNameDisparityCheck]
	static	bool	UseFileCheck()					{ return m_bUseFileCheck; }
	static	int		GetFileCheckSensitivity()		{ return m_iFileCheckSensitivity; }
	static	bool	UseFileCheckThreshold()			{ return m_bUseFileCheckThreshold; }
	static	int		GetFileCheckThreshold()			{ return m_iFileCheckThreshold; }
	static	int		GetFileCheckAmount()			{ return m_iFileCheckAmount; }
	// NEO: FDC END

	// NEO: FN - [FunnyNick]
	static	bool	UseFunnyNick()					{ return m_bUseFunnyNick; }
	static	CString GetFunnyNickFilter()			{ return m_sFunnyNickFilter; }
	static	CString GetFunnyNickSymbol()			{ return m_sFunnyNickSymbol; }
	// NEO: FN END

	// NEO: AU - [AutoUpdate]
	static bool		IsAutoRuntimeUpdate()			{return m_bAutoRuntimeUpdate;}
	static int		GetRuntimeUpdateIntervals()		{return m_iRuntimeUpdateIntervals;}

	static	CString	GetUpdateURLIPFilter()			{return CString(m_sUpdateURLIPFilter);}
	static bool	IsAutoUPdateIPFilterEnabled()		{return m_bAutoUpdateIPFilter;}
	static LPSYSTEMTIME   GetIPFilterVersion()		{return &m_IPFilterVersion;}

#ifdef ARGOS // NEO: NA - [NeoArgos]
	static	CString	GetUpdateURLLeechersList()		{return CString(m_sUpdateURLLeechersList);}
	static	bool	IsUpdateLeechersStartupEnabled(){return m_bUpdateLeechersStartup;}
	static LPSYSTEMTIME   GetLeechersVersion()		{return &m_LeechersVersion;}
#endif // ARGOS // NEO: NA END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	static CString GetUpdateURLIP2Country()			{return CString(m_sUpdateURLIP2Country);}
	static bool IsAutoUPdateIP2CountryEnabled()		{return m_bAutoUpdateIP2Country;}
	static LPSYSTEMTIME   GetIP2CountryVersion()	{return &m_IP2CountryVersion;}
#endif // IP2COUNTRY // NEO: IP2C END

	// NEO: FC - [FakeCheck]
	static	CString	GetUpdateURLFakeList()			{return CString(m_sUpdateURLFakeList);}
	static	bool	IsUpdateFakeStartupEnabled()	{return m_bUpdateFakeStartup;}
	static LPSYSTEMTIME   GetFakesVersion()			{return &m_FakesVersion;}
	// NEO: FC END
	// NEO: AU END

	// NEO: IFWS - [ICSFirewall]
	static	void	SetICFSupport(BOOL on)			{ m_uICFSupport = on; }
	static	bool	GetICFSupport()					{ return m_uICFSupport == TRUE; }
	static	bool	GetICFSupportFirstTime()		{ return m_uICFSupport == 2; }
	static	bool	GetICFClearOnClose()			{ return m_bICFClearOnClose; }
	// NEO: IFWS END

	// NEO: UPNP - [UPnPNat]
	static	bool	IsUPnPEnabled()					{ return m_uUPnPNat != FALSE; }
	static	bool	GetUPnPNatWeb()					{ return m_uUPnPNat == TRUE; }
	static	bool	GetUPnPClearOnClose()			{ return m_bUPnPClearOnClose; }
	static	bool	GetUPnPNatTryRandom()			{ return m_bUPnPTryRandom; }
	// NEO: UPNP END

	// NEO: NATS - [NatSupport]
	static	bool	IsNATSupportEnabled()			{ return m_bNATSupportEnabled && !IsUPnPEnabled(); }  // when UPnP is enabled we don't need nat port detection/refresh

	// to prevent our router from dropping the NAT state we ping us self
	static	float	GetNATPortRefreshIvterval()		{ return m_fNATPortRefreshIvterval; }
	static	uint32	GetNATPortRefreshIvtervalMs()	{ return SEC2MS((uint32)(GetNATPortRefreshIvterval() * 60.0F)); }  
	// max port refresh latency (buddy latency)
	static	int		GetNATPortMaxLatencyTime()		{ return m_iNATPortMaxLatencyTime; }
	static	uint32	GetNATPortMaxLatencyTimeMs()	{ return SEC2MS(GetNATPortMaxLatencyTime()); }
	// max failed trys (befour switchung buddy/rescanning us self)
	static	int		GetNATPortMaxFails()			{ return m_iNATPortMaxFails; }
	// ping us self without a buddy
	static	bool	IsNATPortFastRefresh()			{ return m_bNATPortFastRefresh; }

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	// is our nat port reaialable, this we can only say if we are behind a hardware firewall
	static	bool	IsNATPortRelaiable()			{ return m_bNATPortRelaiable; }

	// can we use nat traversal at all (it is alos a firewall traversal)
	static	bool	IsNATTraversalEnabled()			{ return m_bNATTraversalEnabled; }

	// we always request a remote sync from the cleint we want connect
	static	bool	DontTrustNatPorts()				{ return m_bDontTrustNatPorts; }

	// 0 restricted cone nat
	// 1 full cone nat
	// 2 symetric nat, limited connectivity
	static	int		GetNatType()					{ return m_iNatCharacteristic; }

	// we don't send a ping and don't request a remote sync we only request a ping
	static	bool	IsFullConeNat()					{ return m_iNatCharacteristic == 1; }

	// we can connect only to full cone nat clients
	static	bool	IsSymetricNat()					{ return m_iNatCharacteristic == 2; }

	static	UINT	UseLowIDUplaodCallBack()		{ return m_uLowIDUplaodCallBack; } // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
	static	UINT	ReuseTCPPort()					{ return m_uReuseTCPPort; }

	static	void	SetUDPPortPingTime(uint32 set)	{ m_uUDPPortPingTime = set; }
	static	uint32	GetUDPPortPingTime()			{ return m_uUDPPortPingTime; }	

	static	void	ResetUDPPortPingFails()			{ m_uUDPPortPingFails = 0; }
	static	void	IncrUDPPortPingFails()			{ m_uUDPPortPingFails++; }
	static	uint16	GetUDPPortPingFails()			{ return m_uUDPPortPingFails; }

	static	void	SetIP(uint32 ip)				{ m_iIPExternal = ip; }
	static	uint32	GetIP()							{ return m_iIPExternal; }

	static	void	SetUDPPingPending(bool set, bool bKad = false) { if(bKad) m_bUDPPingPending = set; else m_bKADPingPending = set; } // NEO: KAX - [KadAuxPort]
	static	void	ResetUDPPingPending()			{ m_bUDPPingPending = false; m_bKADPingPending = false; } // NEO: KAX - [KadAuxPort]
	static	bool	IsUDPPingPending()				{ return m_bUDPPingPending || m_bKADPingPending; } // NEO: KAX - [KadAuxPort]

	static	void	PerformUDPPortPing(bool bForceBuddy = false, bool bKad = false); // NEO: KAX - [KadAuxPort]

	static	void	SetTCPPort(uint16 port) { m_iTCPExternal = port; }
	static	void	SetUDPPort(uint16 port, bool bKad = false) { if(bKad) m_iKADExternal = port; else m_iUDPExternal = port; } // NEO: KAX - [KadAuxPort]

	static	uint16	GetPort(bool bLocal = false)	{ return (m_iTCPExternal && !bLocal) ? m_iTCPExternal : port; }
	static	uint16	GetUDPPort(bool bLocal = false)	{ return (m_iUDPExternal && !bLocal) ? m_iUDPExternal : udpport; }
	static	uint16	GetKADPort(bool bLocal = false)	{ return (m_iKADExternal && !bLocal) ? m_iKADExternal : ((kadport == 0xFFFF) ? GetUDPPort(bLocal) : kadport); } // NEO: KAX - [KadAuxPort]

	static	uint16	GetUDPPortEx()					{ return m_iUDPExternal; }
	static	uint16	GetKADPortEx()					{ return m_iKADExternal; } // NEO: KAX - [KadAuxPort]
	// NEO: NATS END

#ifdef WEBCACHE // NEO: WC - [WebCache]
	static	bool	HighIDConfirmed;
	// Superlexx - webcache
	static	bool	WebCacheDisabledThisSession; //JP temp disabler
	static	uint32	WebCachePingSendTime;//jp check proxy config
	static	bool	expectingWebCachePing;//jp check proxy config

	static	CString	webcacheName;		//jp move these to private?? and make member functions to set and change them??
	static	uint16	webcachePort;
	static	uint16	webcacheBlockLimit;
	static	bool	webcacheExtraTimeout;
	static	bool	PersistentConnectionsForProxyDownloads;
	static	bool	WCAutoupdate;
	static	bool	webcacheCachesLocalTraffic;

	static	UINT	webcacheEnabled;
	static	bool	webcacheLimitles;
	static	bool	detectWebcacheOnStart;
	static	uint32	webcacheLastSearch;
	static	uint32	webcacheLastGlobalIP;
	static	uint8	webcacheTrustLevel;

	static	bool	m_bLogWebCacheEvents;
	//static	bool	m_bWebCacheShow;

	static	bool	IsWebCacheTestPossible(); //jp check proxy config
	static	CString	GetWebCacheName()					{return webcacheName;}
	static	uint16	GetWebCachePort()					{return webcachePort;}
	static	uint16	GetWebCacheBlockLimit()				{return webcacheBlockLimit;}
	static	bool	IsWebCacheEnabled()					{FALSE_ON_ANON return webcacheEnabled ? true : false;}
	static	bool	IsWebCacheDownloadEnabled()			{return webcacheEnabled == 1 && !WebCacheDisabledThisSession;} //jp
	static	bool	IsLimitlesWebCache()				{return webcacheLimitles;}
	static	bool	IsWebCacheExtraTimeout()			{return webcacheExtraTimeout;}
	static	bool	IsWebCacheCachesLocalTraffic()		{return webcacheCachesLocalTraffic;}
	static  bool	IsPersistentConnections()			{return PersistentConnectionsForProxyDownloads;}

	static	bool	WebCacheIsTransparent()				{return GetWebCacheName().GetLength() > 15 && GetWebCacheName().Left(12) == "transparent@";}
	static	void	SetWebCacheBlockLimit(uint16 limit) {webcacheBlockLimit = limit;}
	static	void	SetWebCacheExtraTimeout(bool value) {webcacheExtraTimeout = value;}
	static	void	SetWebCacheCachesLocalTraffic(bool value) {webcacheCachesLocalTraffic = value;}
	static	bool	UsesCachedTCPPort();	

	static	void	SetWebCacheLastSearch(uint32 time)	{webcacheLastSearch = time;}
	static	uint32	GetWebCacheLastSearch()				{return webcacheLastSearch;}

	static	void	SetWebCacheLastGlobalIP(uint32 IP)	{webcacheLastGlobalIP = IP;}
	static	uint32	GetWebCacheLastGlobalIP()			{return webcacheLastGlobalIP;}
	static	CString	webcacheLastResolvedName;
	static	void	SetLastResolvedName(CString name)	{webcacheLastResolvedName = name;}
	static	CString	GetLastResolvedName()				{return webcacheLastResolvedName;}

	static	bool	GetLogWebCacheEvents()				{return m_bVerbose && m_bLogWebCacheEvents;} //JP log webcache events
	static	bool	GetWebCacheShow()					{return m_bPeerCacheShow /*m_bWebCacheShow*/;}
#endif // NEO: WC END

	CPreferencesEx();
	//~CPreferencesEx();

	friend class CPPgNeo;
	friend class CPPgRelease;
	friend class CPPgSources;
#if defined(NEO_SK) || defined(NEO_SS) || defined(NEO_CD) // ||defined(NEO_SA) // NEO: NSS - [NeoSourceStorage]
	friend class CPPgSourceStorage;
#endif // NEO: NSS END
#ifdef ARGOS // NEO: NA - [NeoArgos]
	friend class CPPgArgos;
#endif // ARGOS // NEO: NA END
	friend class CPPgNetwork;
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	friend class CPPgBandwidth;
#endif // NEO_BC // NEO: NBC END
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	friend class CPPgLancast;
#endif //LANCAST // NEO: NLC END
	friend class CPPgInterface;
	friend class CPPgVirtual;
	friend class CPPgUpdate; // NEO: AU - [AutoUpdate]

protected:
	friend class CPreferences;

	static void LoadNeoPreferences();
	static void SaveNeoPreferences();
	static void CheckNeoPreferences();
};
// NEO: NCFG END <-- Xanatos --

extern CPreferencesEx thePrefs; // NEO: NCFG - [NeoConfiguration] <-- Xanatos --
extern bool g_bLowColorDesktop;
