//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "KnownFile.h"
#include "DeadSourceList.h"
#include "CorruptionBlackBox.h"
#include "Neo\BlockMaps.h" // NEO: SCT - [SubChunkTransfer] <-- Xanatos --

enum EPartFileStatus{
	PS_READY			= 0,
	PS_EMPTY			= 1,
	//PS_WAITINGFORHASH	= 2, // NEO: SSH - [SlugFillerSafeHash] <-- Xanatos --
	PS_HASHING			= 3, 
	PS_ERROR			= 4,
	PS_INSUFFICIENT		= 5,
	PS_UNKNOWN			= 6,
	PS_PAUSED			= 7,
	PS_COMPLETING		= 8,
	PS_COMPLETE			= 9,
	PS_MOVING			= 10, // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
	// NEO: FSI - [FileStatusIcons] -- Xanatos -->
	PS_WAITINGFORSOURCE	= 11,
	PS_DOWNLOADING		= 12,
	PS_STALLED			= 13,
	PS_STOPPED			= 14,
	PS_STANDBY			= 15,
	PS_SUSPEND			= 16,
	// NEO: FSI END <-- Xanatos --
	PS_IMPORTING		= 17 // NEO: PIX - [PartImportExport] <-- Xanatos --
};

#define PR_VERYLOW			4 // I Had to change this because it didn't save negative number correctly.. Had to modify the sort function for this change..
#define PR_LOW				0 //*
#define PR_NORMAL			1 // Don't change this - needed for edonkey clients and server!
#define PR_HIGH				2 //*
#define PR_VERYHIGH			3
#define PR_AUTO				5 //UAP Hunter
#define PR_RELEASE			6 // NEO: RT - [ReleaseTweaks] <-- Xanatos --

//#define BUFFER_SIZE_LIMIT 500000 // Max bytes before forcing a flush
//#define BUFFER_TIME_LIMIT	60000	// Max milliseconds before forcing a flush

#define	PARTMET_BAK_EXT	_T(".bak")
#define	PARTMET_TMP_EXT	_T(".backup")
#define	PARTMET_EXT		_T(".met") // NEO: MOD <-- Xanatos --

#define STATES_COUNT		25 /*17*/ // NEO: MOD <-- Xanatos --

enum EPartFileFormat{
	PMT_UNKNOWN			= 0,
	PMT_DEFAULTOLD,
	PMT_SPLITTED,
	PMT_NEWOLD,
	PMT_SHAREAZA,
	PMT_BADFORMAT	
};

#define	FILE_COMPLETION_THREAD_FAILED	0x0000
#define	FILE_COMPLETION_THREAD_SUCCESS	0x0001
#define	FILE_COMPLETION_THREAD_RENAMED	0x0002
// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
#define	FILE_MOVE_THREAD_FAILED			0x0000
#define	FILE_MOVE_THREAD_SUCCESS		0x0001
// NEO: MTD END <-- Xanatos --

enum EPartFileOp{
	PFOP_NONE = 0,
	PFOP_HASHING,
	PFOP_COPYING,
	PFOP_UNCOMPRESSING,
	PFOP_IMPORTING // NEO: PIX - [PartImportExport] <-- Xanatos --
};

class CSearchFile;
class CUpDownClient;
enum EDownloadState;
class CxImage;
class CSafeMemFile;
class CServer;	// NEO: XUC - [ExtendedUdpCache] <-- Xanatos --
//#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
//class CVoodooSocket;
//#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
struct ImportInfo; // NEO: PIX - [PartImportExport] <-- Xanatos --

#pragma pack(1)
struct Requested_Block_Struct
{
	uint64	StartOffset;
	uint64	EndOffset;
	uchar	FileID[16];
	uint64  transferred; // Barry - This counts bytes completed
	bool	unverified; // NEO: SCT - [SubChunkTransfer] <-- Xanatos --
	byte*	filedata; // NEO: RBT - [ReadBlockThread] <-- Xanatos --
};
#pragma pack()

struct Gap_Struct
{
	uint64 start;
	uint64 end;
};

struct PartFileBufferedData
{
	BYTE *data;						// Barry - This is the data to be written
	uint64 start;					// Barry - This is the start offset of the data
	uint64 end;						// Barry - This is the end offset of the data
	//Requested_Block_Struct *block;	// Barry - This is the requested block that this data relates to // NEO: MOD - [NotUsed] <-- Xanatos -- 
};

// NEO: FFT - [FileFlushThread] -- Xanatos -->
struct FlushDone_Struct
{
	bool	bIncreasedFile;
	bool	bForceICH;
	//bool	bNoAICH; // SLUGFILLER: SafeHash // NEO: SSH - [SlugFillerSafeHash] <-- Xanatos --
	bool*	changedPart;
};
// NEO: FFT END <-- Xanatos --

typedef CTypedPtrList<CPtrList, CUpDownClient*> CUpDownClientPtrList;

// NEO: MOD -- Xanatos --
// Moved from UploadClient.cpp
class CSyncHelper
{
public:
	CSyncHelper()
	{
		m_pObject = NULL;
	}
	~CSyncHelper()
	{
		if (m_pObject)
			m_pObject->Unlock();
	}
	CSyncObject* m_pObject;
};

// NEO: SSH - [SlugFillerSafeHash] -- Xanatos -->
// BEGIN SLUGFILLER: SafeHash
struct PartHashOrder
{
	PartHashOrder(uint16 uPart_,const uchar* Hash_,bool ICHused_ = false, bool AICHRecover_ = false, bool AICHok_ = false)
	{
		uPart = uPart_;
		md4cpy(&Hash[0],Hash_);
		ICHused = ICHused_;
		AICHRecover = AICHRecover_;
		AICHok = AICHok_;
	}
	uint16	uPart;
	uchar	Hash[16];
	bool	ICHused;
	bool	AICHRecover;
	bool	AICHok;
};
class CPartHashThread : public CWinThread
{
	DECLARE_DYNCREATE(CPartHashThread)
protected:
	CPartHashThread()	{}

	friend class CPartFile;
	CFile file;
public:
	virtual	BOOL	InitInstance() {return true;}
	virtual int		Run();
	void			SetPartFile(CPartFile* pOwner);
private:
	CPartFile*		m_pOwner;
	CString			fullname;
};
struct PartHashResult
{
	PartHashResult(uint16 uPart_,bool corrupted_,bool AICHRecover_, bool AICHok_) 
	{
		uPart = uPart_; 
		corrupted = corrupted_; 
		AICHRecover = AICHRecover_;
		AICHok = AICHok_;
	}
	uint16	uPart;
	bool	corrupted;
	bool	AICHRecover;
	bool	AICHok;
};
// END SLUGFILLER: SafeHash
// NEO: SSH END <-- Xanatos --

// NEO: SCV - [SubChunkVerification] -- Xanatos -->
struct BlockHashOrder
{
	BlockHashOrder(uint16 uPart_,bool AICHRecover_ = false, bool ForceMD4_ = false)
	{
		uPart = uPart_;
		AICHRecover = AICHRecover_;
		ForceMD4 = ForceMD4_;
	}
	uint16	uPart;
	CList<uint8,uint8> BlocksToHash;
	bool	AICHRecover;
	bool	ForceMD4;
};
class CBlockHashThread : public CWinThread
{
	DECLARE_DYNCREATE(CBlockHashThread)
protected:
	CBlockHashThread()	{}

	friend class CPartFile;
	CFile file;
public:
	virtual	BOOL	InitInstance() {return true;}
	virtual int		Run();
	void			SetPartFile(CPartFile* pOwner);
private:
	CPartFile*		m_pOwner;
	CString			fullname;
};
struct BlockHashResult
{
	BlockHashResult(uint16 uPart_,CMap<uint8,uint8,BOOL,BOOL>* resultMap_,bool AICHRecover_, bool ForceMD4_) 
	{
		resultMap = resultMap_; 
		uPart = uPart_; 
		AICHRecover = AICHRecover_;
		ForceMD4 = ForceMD4_;
	}
	CMap<uint8,uint8,BOOL,BOOL>* resultMap;
	uint16					uPart;
	bool					AICHRecover;
	bool					ForceMD4;
};
// NEO: SCV END <-- Xanatos --

// NEO: FFT - [FileFlushThread] -- Xanatos -->
class CPartFileFlushThread : public CWinThread
{
	DECLARE_DYNCREATE(CPartFileFlushThread)
protected:
	CPartFileFlushThread()	{}
public:
	virtual	BOOL	InitInstance() {return true;}
	virtual int		Run();
	void	SetPartFile(CPartFile* pOwner);
private:
	CPartFile*				m_partfile;
};
// NEO: FFT END <-- Xanatos --

// NEO: PIX - [PartImportExport] -- Xanatos -->
struct ImportPart_Struct {
	uint64 start;
	uint64 end;
	BYTE* data;
};
// NEO: PIX END <-- Xanatos --

class CPartFile : public CKnownFile
{
	DECLARE_DYNAMIC(CPartFile)

	friend class CPartFileConvert;
	friend class CPartHashThread;	// SLUGFILLER: SafeHash // NEO: SSH - [SlugFillerSafeHash] <-- Xanatos --
	friend class CBlockHashThread;	// NEO: SafeHash // NEO: SCV - [SubChunkVerification] <-- Xanatos --
	friend class CPartFileFlushThread;	// NEO: FFT - [FileFlushThread] <-- Xanatos --
public:
	CPartFile(UINT cat = 0);
	CPartFile(CSearchFile* searchresult, UINT cat = 0);
	CPartFile(CString edonkeylink, UINT cat = 0);
	CPartFile(class CED2KFileLink* fileLink, UINT cat = 0);
	virtual ~CPartFile();

	bool	IsPartFile() const { return !(status == PS_COMPLETE); }

	// eD2K filename
	virtual void SetFileName(LPCTSTR pszFileName, bool bReplaceInvalidFileSystemChars = false); // 'bReplaceInvalidFileSystemChars' is set to 'false' for backward compatibility!

	// part.met filename (without path!)
	const CString& GetPartMetFileName() const { return m_partmetfilename; }

	// full path to part.met file or completed file
	const CString& GetFullName() const { return m_fullname; }
	void	SetFullName(CString name) { m_fullname = name; }
	CString	GetTempPath() const;

	// local file system related properties
	bool	IsNormalFile() const { return (m_dwFileAttributes & (FILE_ATTRIBUTE_COMPRESSED | FILE_ATTRIBUTE_SPARSE_FILE)) == 0; }
	const bool	IsAllocating() const { return m_AllocateThread != NULL; }
	EMFileSize	GetRealFileSize() const;
	void	GetSizeToTransferAndNeededSpace(uint64& pui64SizeToTransfer, uint64& pui32NeededSpace) const;
	uint64	GetNeededSpace() const;

	// last file modification time (NT's version of UTC), to be used for stats only!
	CTime	GetCFileDate() const { return CTime(m_tLastModified); }
	uint32	GetFileDate() const { return m_tLastModified; }

	// file creation time (NT's version of UTC), to be used for stats only!
	CTime	GetCrCFileDate() const { return CTime(m_tCreated); }
	uint32	GetCrFileDate() const { return m_tCreated; }

	void	InitializeFromLink(CED2KFileLink* fileLink, UINT cat = 0);
	// NEO: FCFG - [FileConfiguration] -- Xanatos -->
	bool	LoadNeoFile();
	bool	SaveNeoFile();
	// NEO: FCF END <-- Xanatos --
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	bool	LoadSources(CString sFileName = _T(""));
 #ifdef VOODOO // NEO: VOODOOx - [VoodooSourceExchange]
	bool	LoadSources(CFileDataIO* file, bool bFromVoodoo = false);
 #else
	bool	LoadSources(CFileDataIO* file);
 #endif // VOODOO // NEO: VOODOOx END
	bool	SaveSources(CString sFileName = _T(""), bool bFullData = false);
 #ifdef VOODOO // NEO: VOODOOx - [VoodooSourceExchange]
	bool	SaveSources(CFileDataIO* file, bool bFullData = false, uint32 uSizeLimit = 0);
 #else
	bool	SaveSources(CFileDataIO* file, bool bFullData = false);
 #endif // VOODOO // NEO: VOODOOx END
	void	ExportSources(CString strSrcFile,CTypedPtrList<CPtrList, CUpDownClient*> &selectedList);
#endif // NEO_SS // NEO: NSS END <-- Xanatos --
	uint32	Process(uint32 reducedownload, UINT icounter);
	uint32	CalculateDownloadRate(); // NEO: ASM - [AccurateSpeedMeasure] <-- Xanatos --
	uint8	LoadPartFile(LPCTSTR in_directory, LPCTSTR filename, bool getsizeonly = false); //filename = *.part.met
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
	bool	LoadFromTempFile(CFileDataIO* file);
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
	bool	LoadTagsFromTempFile(CFileDataIO* file,bool getsizeonly = false, bool isnewstyle = false); // NEO: VOODOO - [UniversalPartfileInterface] <-- Xanatos --

	uint8	ImportShareazaTempfile(LPCTSTR in_directory,LPCTSTR in_filename , bool getsizeonly);

	bool	SavePartFile();
	bool	WriteToTempFile(CFileDataIO* file); // NEO: VOODOO - [UniversalPartfileInterface] <-- Xanatos --
	void	PartFileHashFinished(CKnownFile* result);
	// NEO: SSH - [SlugFillerSafeHash] -- Xanatos -->
	bool	SetSinglePartHash(uint16 part, bool ICHused = false, bool AICHRecover = false, bool AICHok = false);
	void	PartHashFinished(UINT partnumber, bool corrupt, bool AICHRecover = false, bool AICHok = false);
	// NEO: SSH END <-- Xanatos --
	// NEO: SCV - [SubChunkVerification] -- Xanatos -->
	uint8	GetBlocksInPart(uint16 part);
	bool	SetBlockPartHash(uint16 part, bool AICHRecover = false, bool ForceMD4 = false);
	void	BlockHashFinished(UINT partnumber, CMap<uint8,uint8,BOOL,BOOL>* resultMap, bool AICHRecover = false, bool ForceMD4 = false);
	// NEO: SCV END <-- Xanatos --
	//bool	HashSinglePart(UINT partnumber); // true = ok , false = corrupted
	// NEO: PIX - [PartImportExport] -- Xanatos -->
	bool	ImportParts(); 
	BOOL	PerformImportParts(ImportInfo* Instructions); 
	// NEO: PIX END <-- Xanatos --

	void	AddGap(uint64 start, uint64 end);
	void	FillGap(uint64 start, uint64 end);
	void	DrawStatusBar(CDC* dc, LPCRECT rect, bool bFlat) /*const*/;
	virtual void	DrawShareStatusBar(CDC* dc, LPCRECT rect, bool onlygreyrect, bool	 bFlat) const;
	virtual void	DrawShareStatusBarNew(CDC* dc, LPCRECT rect, bool onlygreyrect, bool	 bFlat) const; // NEO: MOD <-- Xanatos --
	
	virtual uint16	GetPartAvailibility(uint16 i) const			{return (IsPartFile() ? (m_SrcPartFrequency.IsEmpty()			? 0 : m_SrcPartFrequency[i])		: (m_AvailPartFrequency.IsEmpty()			? 0 : m_AvailPartFrequency[i])			);} // NEO: NPT - [NeoPartTraffic] <-- Xanatos --
	virtual uint16	GetIncPartAvailibility(uint16 i) const		{return (IsPartFile() ? (m_SrcIncPartFrequency.IsEmpty()		? 0 : m_SrcIncPartFrequency[i])		: (m_AvailIncPartFrequency.IsEmpty()		? 0 : m_AvailIncPartFrequency[i])		);} // NEO: ICS - [InteligentChunkSelection] <-- Xanatos --
	virtual uint16	GetHidenPartAvailibility(uint16 i) const	{return (IsPartFile() ? (m_SrcHidenPartFrequency.IsEmpty()		? 0 : m_SrcHidenPartFrequency[i])	: (m_AvailHidenPartFrequency.IsEmpty()		? 0 : m_AvailHidenPartFrequency[i])		);} // NEO: RPS - [RealPartStatus] <-- Xanatos --
	virtual uint16	GetBlockedPartAvailibility(uint16 i) const	{return (IsPartFile() ? (m_SrcBlockedPartFrequency.IsEmpty()	? 0 : m_SrcBlockedPartFrequency[i])	: (m_AvailBlockedPartFrequency.IsEmpty()	? 0 : m_AvailBlockedPartFrequency[i])	);} // NEO: RPS - [RealPartStatus] <-- Xanatos --
	virtual uint16	GetSeenPartAvailibility(uint16 i) const		{return (IsPartFile() ? (m_SrcSeenPartFrequency.IsEmpty()		? 0 : m_SrcSeenPartFrequency[i])	: (m_AvailSeenPartFrequency.IsEmpty()		? 0 : m_AvailSeenPartFrequency[i])		);} // NEO: AHOS - [AntiHideOS] <-- Xanatos --

	// X? : What is beter
	//virtual uint16	GetPartAvailibility(uint16 i) const			{return ((m_SrcPartFrequency.IsEmpty()			? 0 : m_SrcPartFrequency[i])		+ (m_AvailPartFrequency.IsEmpty()			? 0 : m_AvailPartFrequency[i])			);} // NEO: NPT - [NeoPartTraffic] <-- Xanatos --
	//virtual uint16	GetIncPartAvailibility(uint16 i) const		{return ((m_SrcIncPartFrequency.IsEmpty()		? 0 : m_SrcIncPartFrequency[i])		+ (m_AvailIncPartFrequency.IsEmpty()		? 0 : m_AvailIncPartFrequency[i])		);} // NEO: ICS - [InteligentChunkSelection] <-- Xanatos --
	//virtual uint16	GetHidenPartAvailibility(uint16 i) const	{return ((m_SrcHidenPartFrequency.IsEmpty()		? 0 : m_SrcHidenPartFrequency[i])	+ (m_AvailHidenPartFrequency.IsEmpty()		? 0 : m_AvailHidenPartFrequency[i])		);} // NEO: RPS - [RealPartStatus] <-- Xanatos --
	//virtual uint16	GetBlockedPartAvailibility(uint16 i) const	{return ((m_SrcBlockedPartFrequency.IsEmpty()	? 0 : m_SrcBlockedPartFrequency[i])	+ (m_AvailBlockedPartFrequency.IsEmpty()	? 0 : m_AvailBlockedPartFrequency[i])	);} // NEO: RPS - [RealPartStatus] <-- Xanatos --
	//virtual uint16	GetSeenPartAvailibility(uint16 i) const		{return ((m_SrcSeenPartFrequency.IsEmpty()		? 0 : m_SrcSeenPartFrequency[i])	+ (m_AvailSeenPartFrequency.IsEmpty()		? 0 : m_AvailSeenPartFrequency[i])		);} // NEO: AHOS - [AntiHideOS] <-- Xanatos --

	bool	IsComplete(uint64 start, uint64 end, bool bIgnoreBufferedData) const;
	bool	IsPureGap(uint64 start, uint64 end) const;
	bool	IsAlreadyRequested(uint64 start, uint64 end) const;
    bool    ShrinkToAvoidAlreadyRequested(uint64& start, uint64& end) const;
	bool	IsCorruptedPart(UINT partnumber) const;
	uint64	GetTotalGapSizeInRange(uint64 uRangeStart, uint64 uRangeEnd) const;
	uint64	GetTotalGapSizeInPart(UINT uPart) const;
	void	UpdateCompletedInfos();
	void	UpdateCompletedInfos(uint64 uTotalGaps);
	virtual void	UpdatePartsInfo(bool bFlag = false); // NEO: IPS - [InteligentPartSharing] <-- Xanatos --
	virtual void	UpdatePartsInfoEx(EPartStatus type); // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --

	// NEO: DBR - [DynamicBlockRequest] -- Xanatos -->
	bool	GetNextRequestedBlock(CUpDownClient* sender, Requested_Block_Struct** newblocks, uint16* count, uint32 blocksize) /*const*/;
	bool	GetNextRequestedBlockICS(CUpDownClient* sender, Requested_Block_Struct** newblocks, uint16* count, uint32 blocksize) /*const*/; // NEO: ICS - [InteligentChunkSelection]
	bool	GetNextRequestedBlockV4(CUpDownClient* sender, Requested_Block_Struct** newblocks, uint16* count, uint32 blocksize) /*const*/; // NEO: RC4 - [RareChunksV4]
	// NEO: DBR END <-- Xanatos --
	void	WritePartStatus(CSafeMemFile* file, CClientFileStatus* status = NULL) /*const*/; // NEO: IPS - [InteligentPartSharing] <-- Xanatos --
	void	WriteSubChunkMaps(CSafeMemFile* file, CClientFileStatus* status = NULL) /*const*/; // NEO: SCT - [SubChunkTransfer] <-- Xanatos --
	void	WriteIncPartStatus(CSafeMemFile* file) const; // NEO: ICS - [InteligentChunkSelection] <-- Xanatos --
	void	WriteCompleteSourcesCount(CSafeMemFile* file) const;
	static bool CheckSourceID(uint32 dwID); // NEO: MOD - [Improvement] <-- Xanatos --
	void	AddSources(CSafeMemFile* sources,uint32 serverip, uint16 serverport, bool bWithObfuscationAndHash);
	void	AddSource(LPCTSTR pszURL, uint32 nIP);
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal] -- Xanatos -->
	static bool CanAddSource(uint32 userid, uint16 port, uint32 serverip, uint16 serverport, UINT* pdebug_lowiddropped = NULL, bool Ed2kID = true, bool bNatT = false);
#else
	static bool CanAddSource(uint32 userid, uint16 port, uint32 serverip, uint16 serverport, UINT* pdebug_lowiddropped = NULL, bool Ed2kID = true);
#endif //NATTUNNELING // NEO: NATT END <-- Xanatos --
	
	EPartFileStatus	GetStatus(bool ignorepause = false) const;
	EPartFileStatus	GetPartFileStatus(); // NEO: FSI - [FileStatusIcons] <-- Xanatos --
	void	SetStatus(EPartFileStatus eStatus);		// set status and update GUI
	void	_SetStatus(EPartFileStatus eStatus);	// set status and do *not* update GUI
	void	NotifyStatusChange();
	// NEO: OCF - [OnlyCompleetFiles] -- Xanatos -->
	bool	NotSeenCompleteSource() const; 
	void	SetForced(bool bSet) { forced = bSet;}
	bool	GetForced() {return forced;}
	// NEO: OCF END <-- Xanatos --
	// NEO: SD - [StandByDL] -- Xanatos -->
	void	SetStandBy(bool bSet) { standby = bSet;}
	bool	GetStandBy() {return standby;}
	bool	IsStandBy() const; 
	// NEO: SD END <-- Xanatos --
	// NEO: SC - [SuspendCollecting] -- Xanatos -->
	void	SetSuspend(bool bSet) { suspend = bSet;}
	bool	GetSuspend() {return suspend;}
	// NEO: SC END <-- Xanatos --
	bool	IsStopped() const { return stopped; }
	bool	IsPaused() const { return paused; } // NEO: MOD <-- Xanatos --
	bool	GetCompletionError() const { return m_bCompletionError; }
	bool	GetCompletionBreak() const { return m_bCompletionBreak; } // NEO: POFC - [PauseOnFileComplete] <-- Xanatos --
	EMFileSize  GetCompletedSize() const { return completedsize; }
	CString getPartfileStatus() const;
	int		getPartfileStatusRang() const;
	void	SetActive(bool bActive);

	uint8	GetDownPriority() const { return m_iDownPriority; }
	void	SetDownPriority(uint8 iNewDownPriority, bool resort = true);
	bool	IsAutoDownPriority(void) const { return m_bAutoDownPriority; }
	void	SetAutoDownPriority(bool NewAutoDownPriority) { m_bAutoDownPriority = NewAutoDownPriority; }
	void	UpdateAutoDownPriority();

	void	UpdateSourceCount(); // NEO: FIX - [SourceCount] <-- Xanatos --
	UINT	GetSourceCount() const { return srclist.GetCount(); }
	UINT	GetSrcA4AFCount() const { return A4AFsrclist.GetCount(); }
	UINT	GetSrcStatisticsValue(EDownloadState nDLState) const;
	UINT	GetTransferringSrcCount() const;
	uint64	GetTransferred() const { return m_uTransferred; }
	uint64	GetTransferredSession() const { return m_uTransferredSession; } // MOD - [SessionDL] <-- Xanatos --
	uint32	GetDatarate() const { return datarate; }
#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
	uint32	GetLanDatarate() const { return landatarate; }
#endif //LANCAST // NEO: NLC END <-- Xanatos --
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
	uint32	GetVoodooDatarate() const { return voodoodatarate; }
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
	float	GetPercentCompleted() const { return percentcompleted; }
	float	GetPercentCompletedInitial() const { return percentcompletedinitial; } // NEO: MOD - [Percentage] <-- Xanatos --
	UINT	GetNotCurrentSourcesCount() const;
	UINT 	GetValidSourcesCount() const;
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	UINT	GetStoredSourceCount(bool bAll = false) const;
#endif // NEO_SS // NEO: NSS END <-- Xanatos --
	UINT	GetWaitingSourceCount() const; // NEO: ASL - [AutoSoftLock] <-- Xanatos --
	UINT	GetCheckedSourceCount() const; // NEO: MOD - [RelativeChunkDisplay] <-- Xanatos --
	UINT	GetAvailableSrcCount() const; // NEO: NCAP - [NeoCustomAutoPriority] <-- Xanatos --
#if defined(NEO_SS) || defined(NEO_SK) // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	UINT	GetActiveSourceCount() const;
#endif // NEO_SS // NEO_SK // NEO: NSS END <-- Xanatos --
	UINT	GetCachedSourceCount() const; // NEO: XSC - [ExtremeSourceCache] <-- Xanatos --
	// NEO: DS - [DropSources] -- Xanatos -->
	UINT	GetHighQSourceCount() const;
#ifdef NEO_SS // NEO: NSD - [NeoSourceDrop]
	UINT	GetOutOfDateSourceCount() const;
#endif // NEO_SS // NEO: NSD END
	// NEO: DS END <-- Xanatos --	
	bool	IsArchive(bool onlyPreviewable = false) const; // Barry - Also want to preview archives
    bool    IsPreviewableFileType() const;
	time_t	getTimeRemaining() const;
	time_t	getTimeRemainingSimple() const;
	uint32	GetDlActiveTime() const;

	// Barry - Added as replacement for BlockReceived to buffer data before writing to disk
	uint32	WriteToBuffer(uint64 transize, const BYTE *data, uint64 start, uint64 end, Requested_Block_Struct *block, uint32 clientIP); // NEO: VOODOO - [UniversalPartfileInterface] <-- Xanatos --
	void	FlushBuffer(bool forcewait=false, bool bForceICH = false, bool bNoAICH = false);
	// NEO: FFT - [FileFlushThread] -- Xanatos -->
	void	FlushDone();
	bool	IsFlushThread() { return m_FlushThread != NULL; };
	// NEO: FFT END <-- Xanatos --
	// Barry - This will invert the gap list, up to caller to delete gaps when done
	// 'Gaps' returned are really the filled areas, and guaranteed to be in order
	void	GetFilledList(CTypedPtrList<CPtrList, Gap_Struct*> *filled) const;

	CMutex*	GetSCV_mut()	{return &SCV_mut; } // NEO: SCV - [SubChunkVerification] <-- Xanatos --
	uint16	GetPartsHashing(bool bNoBlocks = true); // NEO: SSH - [SlugFillerSafeHash] <-- Xanatos --

	bool	GetBlockMap(uint16 part, tBlockMap** map);// NEO: SCT - [SubChunkTransfer] <-- Xanatos --

	// Barry - Added to prevent list containing deleted blocks on shutdown
	void	RemoveAllRequestedBlocks(void);
	bool	RemoveBlockFromList(uint64 start, uint64 end);
	bool	IsInRequestedBlockList(const Requested_Block_Struct* block) const;
	void	RemoveAllSources(bool bTryToSwap);

	bool	CanOpenFile() const;
	bool	IsReadyForPreview() const;
	bool	CanStopFile() const;
	bool	CanPauseFile() const;
	bool	CanResumeFile() const;

	void	OpenFile() const;
	void	PreviewFile();
	void	DeleteFile(bool bUnloadOnly = false, bool resort = true); // NEO: MTD - [MultiTempDirectories] <-- Xanatos -- // NEO: VOODOO - [UniversalPartfileInterface] <-- Xanatos --
	void	MovePartFile(CString newTempDir); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
	void	StopFile(bool bCancel = false, bool resort = true);
	void	PauseFile(bool bInsufficient = false, bool resort = true);
	void	StopPausedFile();
	void	ResumeFile(bool resort = true);
	void	ResumeFileInsufficient();

	virtual Packet* CreateSrcInfoPacket(const CUpDownClient* forClient) const;
	void	AddClientSources(CSafeMemFile* sources, uint8 uClientSXVersion, const CUpDownClient* pClient = NULL);

	UINT	GetAvailablePartCount() const { return availablePartsCount; }
	void	UpdateAvailablePartsCount();

	uint32	GetLastAnsweredTime() const	{ return m_ClientSrcAnswered; }
	void	SetLastAnsweredTime() { 
		m_ClientSrcAnswered = ::GetTickCount(); 
		// NEO: MSH - [ManualSourceHandling] -- Xanatos -->
		if(m_iCollectingXSSources > 0)
			m_iCollectingXSSources--;
		// NEO: MSH END <-- Xanatos --
	}
	void	SetLastAnsweredTimeTimeout();

	uint64	GetCorruptionLoss() const { return m_uCorruptionLoss; }
	uint64	GetCompressionGain() const { return m_uCompressionGain; }
	uint32	GetRecoveredPartsByICH() const { return m_uPartsSavedDueICH; }

	virtual void	UpdateFileRatingCommentAvail(bool bForceUpdate = false);

	void	AddDownloadingSource(CUpDownClient* client);
	void	RemoveDownloadingSource(CUpDownClient* client);

	CString GetProgressString(uint16 size) const;
	CString GetInfoSummary() const;

//	int		GetCommonFilePenalty() const;
	void	UpdateDisplayedInfo(bool force = false);


	// NEO: NSC - [NeoSharedCategories] -- Xanatos --
	//UINT	GetCategory() /*const*/;
	//void	SetCategory(UINT cat);
	bool	CheckShowItemInGivenCat(int inCategory) /*const*/;

	uint8*	MMCreatePartStatus();

	//preview
	virtual bool GrabImage(uint8 nFramesToGrab, double dStartTime, bool bReduceColor, uint16 nMaxWidth,void* pSender);
	virtual void GrabbingFinished(CxImage** imgResults, uint8 nFramesGrabbed, void* pSender);

	void	FlushBuffersExceptionHandler(CFileException* error);
	void	FlushBuffersExceptionHandler();

	void	PerformFileCompleteEnd(DWORD dwResult);

	void	SetFileOp(EPartFileOp eFileOp);
	EPartFileOp GetFileOp() const { return m_eFileOp; }
	void	SetFileOpProgress(UINT uProgress);
	UINT	GetFileOpProgress() const { return m_uFileOpProgress; }

	void	RequestAICHRecovery(UINT nPart);
	void	AICHRecoveryDataAvailable(UINT nPart);

	// NEO: MSH - [ManualSourceHandling] -- Xanatos -->
	void	CollectKADSources();

	void	SetXSSourcesCollecting(int Amount = 3)	{ m_iCollectingXSSources = Amount;}
	bool	IsCollectXSSources()					{ return m_iCollectingXSSources ? TRUE : FALSE; }
	// NEO: MSH END <-- Xanatos --

	// NEO: ICS - [InteligentChunkSelection] -- Xanatos -->
	uint16* CalcDownloadingParts(CUpDownClient* client);
	uint64	GetPartSizeToDownload(uint16 partNumber);
	// NEO: ICS END <-- Xanatos --

	uint32	m_LastSearchTime;
	uint32	m_LastSearchTimeUdp; // NEO: NST - [NeoSourceTweaks] <-- Xanatos --
	uint32	m_LastSearchTimeKad;
	uint8	m_TotalSearchesKad;
	uint64	m_iAllocinfo;
	CUpDownClientPtrList srclist;
	CUpDownClientPtrList A4AFsrclist; //<<-- enkeyDEV(Ottavio84) -A4AF-
	CTime	lastseencomplete;
	CFile	m_hpartfile;				// permanent opened handle to avoid write conflicts
	CMutex 	m_FileCompleteMutex;		// Lord KiRon - Mutex for file completion
	UINT	m_anStates[STATES_COUNT]; // NEO: MOD <-- Xanatos --
	// NEO: DS - [DropSources] -- Xanatos -->
	UINT	m_anStateHighQ;
#ifdef NEO_SS // NEO: NSD - [NeoSourceDrop]
	UINT	m_anOutOfDate;
#endif // NEO_SS // NEO: NSD END
	// NEO: DS END <-- Xanatos --
	uint16	src_stats[8]; // NEO: MOD <-- Xanatos --
	uint16  net_stats[3];
	volatile bool m_bPreviewing;
	volatile bool m_bRecoveringArchive; // Is archive recovery in progress
	bool	m_bLocalSrcReqQueued;
	bool	srcarevisible;				// used for downloadlistctrl
	bool	hashsetneeded;
	int		m_iCollectingXSSources;		// NEO: MSH - [ManualSourceHandling] <-- Xanatos --

    bool    AllowSwapForSourceExchange() { return ::GetTickCount()-lastSwapForSourceExchangeTick > 30*1000; } // ZZ:DownloadManager
    void    SetSwapForSourceExchangeTick() { lastSwapForSourceExchangeTick = ::GetTickCount(); } // ZZ:DownloadManager
	
	// NEO: NST - [NeoSourceTweaks] -- Xanatos --
	/*UINT	SetPrivateMaxSources(uint32 in)	{ return m_uMaxSources = in; } 
	UINT	GetPrivateMaxSources() const	{ return m_uMaxSources; } 
	UINT	GetMaxSources() const;
	UINT	GetMaxSourcePerFileSoft() const;
	UINT	GetMaxSourcePerFileUDP() const;*/

    bool    GetPreviewPrio() const { return m_bpreviewprio; }
	void    SetPreviewPrio(bool in) { m_bpreviewprio=in; }

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	static bool NextRightFileHasHigherPrio(const CPartFile* left, const CPartFile* right);
    static bool RightFileHasHigherPrio(const CPartFile* left, const CPartFile* right);
#else
    static bool RightFileHasHigherPrio(CPartFile* left, CPartFile* right);
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

	// NEO: ASL - [AutoSoftLock] -- Xanatos -->
	bool	IsCollectingHalted() const;
	bool	CheckSoftLock();
	// NEO: ASL END <-- Xanatos --

	// NEO: AHL - [AutoHardLimit] -- Xanatos -->
	void	CalculateHardLimitMax();
	void	CalculateHardLimitNew(); 
	void	CalculateHardLimitOld(); 

	void	SetAutoHardLimit(int NewLimit)	{m_iAutoHardLimit = NewLimit;}
	int		GetAutoHardLimit() const		{return m_iAutoHardLimit;}

	bool	GetAutoSoftLocked()	const		{return m_bSoftLocked; } // NEO: ASL - [AutoSoftLock] <-- Xanatos --

	void	IncreaseAutoHardLimit();
	void	DecreaseAutoHardLimit();

	// Global Source Limit [Max/Stulle]:
	void	IncrHL(UINT m_uSourcesDif);
	void	DecrHL()	{m_iAutoHardLimit = GetSourceCount() - GetCachedSourceCount();}
	void	SetPassiveHL(UINT m_uSourcesDif)	{m_iAutoHardLimit = (GetSourceCount() - GetCachedSourceCount()) + m_uSourcesDif;};
	UINT	GetFileHardLimit() const {return m_iAutoHardLimit;}
	void	InitHL();
	// NEO: AHL END <-- Xanatos --

	void	ReaskSources(EDownloadState nState); // NEO: MDR - [ManualDownloadReask] <-- Xanatos --

	// NEO: MCM - [ManualClientManagement] -- Xanatos -->
	uint16	CollectAllA4AF();
	uint16	ReleaseAllA4AF();
	// NEO: MCM END <-- Xanatos --

	// NEO: DS - [DropSources] -- Xanatos -->
	bool	CheckDropSourcesLimit(int Mode, int Limit, UINT Total, UINT Special);

	uint16	DropSources(EDownloadState nState, bool bTrySwap = false); // NEO: MDS - [ManualDropSources]
	void	DropHighQSources(bool bTrySwap = false);

	void	AddToDontAskThisIP(uint32 dwIP) {m_DontAskThisIPList.SetAt(dwIP,::GetTickCount());}
	bool	DontAskThisIP(uint32 dwIP);
	// NEO: DS END <-- Xanatos --

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	bool	IsStorageBoot(bool bUDP = false);
	
	void	ReaskNextGroup()			{ m_uLastLoadTime = 0; }

 #ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	bool	SortCompare(CUpDownClientPtrList* list, POSITION pos1, POSITION pos2);
	void	SortSwap(CUpDownClientPtrList* list, POSITION pos1, POSITION pos2);
	void	HeapSortList(CUpDownClientPtrList* list, UINT first, UINT last);
	void	SortSourceList(CUpDownClientPtrList* list);
 #endif // NEO_SA // NEO: NSA END

	void	DropOutOfDateSources(); // NEO: NSD - [NeoSourceDrop]
#endif // NEO_SS // NEO: NSS END <-- Xanatos --

	// NEO: MOD - [PreAllocate] -- Xanatos -->
	void	AllocateNeededSpace();
	bool	IncompleteAllocateSpace()	{ return ((m_hpartfile.m_hFile != INVALID_HANDLE_VALUE) && m_hpartfile.GetLength() < GetFileSize()); } 
	// NEO: MOD END <-- Xanatos --

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
	uint32	m_LastVoodooRequestTime;
	uint16	m_VoodooRequestCount;
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
	uint32	m_LastLanSearchTime;
#endif //LANCAST // NEO: NLC END <-- Xanatos --

	bool	Publishable(); // NEO: SEF - [ShareAlsoEmptyFiles] <-- Xanatos --

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
	CTypedPtrList<CPtrList, Gap_Struct*>& GetGapList() {return gaplist;}
	void	ReCombinateGapList();
	void	SetVoodoo() {m_isVoodooFile = true;}
	bool	IsVoodooFile() const;
	void	AddMaster(CVoodooSocket* Master);
	void	RemoveMaster(CVoodooSocket* Master);
	void	VoodooComplete(bool bFinal = false);
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
#if defined(VOODOO) || defined (WEBCACHE) // NEO: TCL - [ThrottledChunkList] -- Xanatos -->
	void	ReserveChunk(uint16 partNumber);
	void	UnReserveChunk(uint16 partNumber);
	void	ThrottleChunk(uint16 partNumber, bool bSoft = false);
	void	UnThrottleChunk(uint16 partNumber);
	bool	IsChunkThrottled(uint16 partNumber, bool bSoft = false);
	void	RemoveAllThrottledChunks();
#endif // NEO: TCL END <-- Xanatos --

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	void	SetCatResumeOrder(int order)	{ m_catResumeOrder = order; SavePartFile(); }
	int		GetCatResumeOrder() const		{ return m_catResumeOrder; }
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

	// NEO: FDC - [FileNameDisparityCheck] -- Xanatos -->
	void CheckFilename(CString FileName);
	bool DissimilarName();
	void ResetFDC() { m_iNameContinuityBad = 0; }
	// NEO: FDC END <-- Xanatos --

	virtual void GetTooltipFileInfo(CString &info); // NEO: NTT - [NewToolTips] <-- Xanatos --

#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	// JP added handling of proxy-sources on pause/cancel/resume START
	void	CancelProxyDownloads();
	void	PauseProxyDownloads();
	void	ResumeProxyDownloads();
	// JP added handling of proxy-sources on pause/cancel/resume END

	//JP webcache column START
	//JP added stuff from Gnaddelwarz
	UINT	GetWebcacheSourceCount() const;
	UINT	GetWebcacheSourceOurProxyCount() const;
	UINT	GetWebcacheSourceNotOurProxyCount() const;
	void	CountWebcacheSources() const;
	//JP webcache column END

	uint64  GetWebCacheDownDataThisFile() const {return WebCacheDownDataThisFile;}
	uint32	GetWebcacherequests() const {return Webcacherequests;}
	uint32	GetSuccessfulWebcacherequests() const {return SuccessfulWebcacherequests;}

	//JP webcache file detail dialogue START
	void	AddWebCachedBlockToStats( bool IsGood, uint64 bytes );
	//JP webcache file detail dialogue END

	//JP Throttle OHCB-production START
	uint32	GetNumberOfBlocksForThisFile();
	UINT	GetMaxNumberOfWebcacheConnectionsForThisFile();
	UINT	GetNumberOfCurrentWebcacheConnectionsForThisFile();
	//JP Throttle OHCB-production END
#endif // NEO: WC END <-- Xanatos --

	CPartPreferences PartPrefs; // NEO: FCFG - [FileConfiguration] <-- Xanatos --

	// NEO: XUC - [ExtendedUdpCache] -- Xanatos -->
	struct SServer {
		SServer() {
			m_nIP = 0;
			m_nPort = 0;
			m_uAvail = 0;
		}
		SServer(uint32 nIP, uint16 nPort) {
			m_nIP = nIP;
			m_nPort = nPort;
			m_uAvail = 0;
		}
		uint32	m_nIP;
		uint16	m_nPort;
		UINT	m_uAvail;
	};
	void		AddAvailServer(SServer server);
	CServer*	GetNextAvailServer();
	// NEO: XUC END <-- Xanatos --

	CDeadSourceList	m_DeadSourceList;

#ifdef _DEBUG
	// Diagnostic Support
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void	CreatePartFile(UINT cat = 0); // NEO: MOD <-- Xanatos --
protected:
	bool	GetNextEmptyBlockInPart(UINT partnumber, tBlockMap* blockmap, Requested_Block_Struct* result, uint32 blocksize) const; // NEO: SCT - [SubChunkTransfer] // NEO: DBR - [DynamicBlockRequest] <-- Xanatos --
	// NEO: SCT - [SubChunkTransfer] -- Xanatos -->
	void	PublishBlockMap(uint16 nPart = (uint16)-1);
	void	VerifyIncompletePart(uint16 partNumber); // NEO: SCV - [SubChunkVerification]
	// NEO: SCT END <-- Xanatos --
	void	CompleteFile(bool hashingdone);
	void	Init();

private:
	BOOL 		PerformFileComplete(); // Lord KiRon
	void		CleanUpTempFile(); // NEO: MOD <-- Xanatos --
	BOOL		PerformFileMove(); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
	static UINT CompleteThreadProc(LPVOID pvParams); // Lord KiRon - Used as separate thread to complete file
	static UINT MoveThreadProc(LPVOID pvParams); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
	static UINT AFX_CDECL AllocateSpaceThread(LPVOID lpParam);
	void		CharFillRange(CString* buffer,uint32 start, uint32 end, char color) const;
	void		ParseICHResult();	// SLUGFILLER: SafeHash // NEO: SSH - [SlugFillerSafeHash] <-- Xanatos --

	CCorruptionBlackBox	m_CorruptionBlackBox;
	static CBarShader s_LoadBar;
	static CBarShader s_ChunkBar;
	uint32	m_iLastPausePurge;
	uint16	count;
	//UINT	m_anStates[STATES_COUNT]; // NEO: MOD <-- Xanatos --
	EMFileSize	completedsize;
	uint64	m_uCorruptionLoss;
	uint64	m_uCompressionGain;
	uint32	m_uPartsSavedDueICH;
	uint32	datarate;
#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
	uint32	landatarate;
#endif //LANCAST // NEO: NLC END <-- Xanatos --
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
	uint32	voodoodatarate;
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
	CString m_fullname;
	CString m_partmetfilename;
	CString	m_strNewDirectory; // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
	uint64	m_uTransferred;
	uint64	m_uTransferredSession; // MOD - [SessionDL] <-- Xanatos --
	// UINT  m_uMaxSources; // NEO: NST - [NeoSourceTweaks] <-- Xanatos --
	bool	forced; // NEO: OCF - [OnlyCompleetFiles] <-- Xanatos --
	bool	standby; // NEO: SD - [StandByDL] <-- Xanatos --
	bool	suspend; // NEO: SC - [SuspendCollecting] <-- Xanatos --
	bool	paused;
	bool	stopped;
	bool	insufficient;
	bool	m_bCompletionError;
	bool	m_bCompletionBreak; // NEO: POFC - [PauseOnFileComplete] <-- Xanatos --
	uint8	m_iDownPriority;
	bool	m_bAutoDownPriority;
	EPartFileStatus	status;
	bool	newdate;	// indicates if there was a writeaccess to the .part file
	uint32	lastpurgetime;
	uint32	m_LastNoNeededCheck;
	CTypedPtrList<CPtrList, Gap_Struct*> gaplist;
	CBlockMaps m_BlockMaps; // NEO: SCT - [SubChunkTransfer] <-- Xanatos --
	CTypedPtrList<CPtrList, Requested_Block_Struct*> requestedblocks_list;
	CArray<uint16,uint16> m_SrcPartFrequency;
	CArray<uint16,uint16> m_SrcIncPartFrequency; // NEO: ICS - [InteligentChunkSelection] <-- Xanatos --
	CArray<uint16,uint16> m_SrcHidenPartFrequency; // NEO: RPS - [RealPartStatus] <-- Xanatos --
	CArray<uint16,uint16> m_SrcBlockedPartFrequency; // NEO: RPS - [RealPartStatus] <-- Xanatos --
	CArray<uint16,uint16> m_SrcSeenPartFrequency; // NEO: AHOS - [AntiHideOS] <-- Xanatos --
	// NEO: SSH - [SlugFillerSafeHash] -- Xanatos -->
	CWinThread* m_HashThread;
	CMap<uint16,uint16,PartHashOrder*,PartHashOrder*> m_PartsToHash;
	CCriticalSection m_PartsToHashLocker;
	CMutex	ICH_mut; // ICH locks the file
	CList<uint16,uint16> m_ICHPartsComplete;
	// NEO: SSH END <-- Xanatos --
	// NEO: SCV - [SubChunkVerification] -- Xanatos -->
	CWinThread* m_AICHHashThread;
	CMap<uint16,uint16,BlockHashOrder*,BlockHashOrder*> m_BlocksToHash;
	CCriticalSection m_BlocksToHashLocker;
	CMutex	SCV_mut; // For updating the block map and for hash AICH set operations
	// NEO: SCV END <-- Xanatos --
	float	percentcompleted;
	float   percentcompletedinitial; // NEO: MOD - [Percentage] <-- Xanatos --
	CList<uint16, uint16> corrupted_list;
	uint32	m_ClientSrcAnswered;
	UINT	availablePartsCount;
	CWinThread* m_AllocateThread;
	// NEO: FFT - [FileFlushThread] -- Xanatos -->
	CWinThread* m_FlushThread;
	FlushDone_Struct* m_FlushSetting;
	// NEO: FFT END <-- Xanatos --
	DWORD	m_lastRefreshedDLDisplay;
	CUpDownClientPtrList m_downloadingSourceList;
	//bool	m_bDeleteAfterAlloc; // NEO: MOD -- Xanatos --
    bool	m_bpreviewprio;
	// Barry - Buffered data to be written
	CTypedPtrList<CPtrList, PartFileBufferedData*> m_BufferedData_list;
	CTypedPtrList<CPtrList, PartFileBufferedData*> m_FlushData_list; // NEO: FFT - [FileFlushThread] <-- Xanatos --
	uint64	m_nTotalBufferData;
	uint32	m_nLastBufferFlushTime;
	//UINT	m_category; // NEO: NSC - [NeoSharedCategories] <-- Xanatos --
	DWORD	m_dwFileAttributes;
	time_t	m_tActivated;
	uint32	m_nDlActiveTime;
	uint32	m_tLastModified;	// last file modification time (NT's version of UTC), to be used for stats only!
	uint32	m_tCreated;			// file creation time (NT's version of UTC), to be used for stats only!
    uint32	m_random_update_wait;	
	int     m_ics_filemode; // NEO: ICS - [InteligentChunkSelection] <-- Xanatos --
	volatile EPartFileOp m_eFileOp;
	volatile UINT m_uFileOpProgress;

	bool	m_bNeedToFlush; // NEO: FFT - [FileFlushThread] <-- Xanatos --

	// NEO: ASL - [AutoSoftLock] -- Xanatos -->
	bool	m_bCollectingHalted;
	bool	m_bSoftLocked;
	// NEO: ASL END <-- Xanatos --

	// NEO: AHL - [AutoHardLimit] -- Xanatos -->
	uint32	m_uNextAutoHardLimitTime;
	int		m_iAutoHardLimit;
	bool	m_bPassiveMode;
	// NEO: AHL END <-- Xanatos --

	// NEO: DS - [DropSources] -- Xanatos -->
	uint32	m_uLastDropNnP;
	uint32	m_uLastDropFullQ;
	uint32	m_uLastDropHighQ;

	uint32	m_dwLastCleanUpDontAskThisIP;
	CMap<uint32, uint32, uint32, uint32> m_DontAskThisIPList;
	// NEO: DS END <-- Xanatos --

	// NEO: NSD - [NeoSourceDrop] -- Xanatos -->
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	uint32	m_uLastDropUnreachable;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	uint32	m_uLastDropOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	uint32	m_uLastDropRetired;
	uint32	m_uLastDropLoaded;
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END <-- Xanatos --

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	uint32	m_uLastSaveSource;
#endif // NEO_SS // NEO: NSS END <-- Xanatos --

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
	uint32	m_uLastLoadTime;
	uint16	m_uLastLoadCount;
#endif // NEO_SS // NEO: NSS END <-- Xanatos --

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
	bool	m_isVoodooFile;
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
#if defined(VOODOO) || defined (WEBCACHE) // NEO: TCL - [ThrottledChunkList] -- Xanatos -->
	struct ThrottledChunk{
		ThrottledChunk() {lockMode = NONE;}
		uint32	timeStamp;
		enum eThrottleMode {NONE = 0,HARD = 1,SOFT = 2} lockMode;
	};
	CMap<uint16, uint16, ThrottledChunk*, ThrottledChunk*> m_ThrottledChunkList;
#endif // NEO: TCL END <-- Xanatos --

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	int		m_catResumeOrder;
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

	int		m_iNameContinuityBad; // NEO: FDC - [FileNameDisparityCheck] -- Xanatos -->

#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	uint32	LastWebcacheSourceCountTime;

	//JP webcache column START
	//JP added stuff from Gnaddelwarz
	UINT	WebcacheSources;
	UINT	WebcacheSourcesOurProxy;
	UINT	WebcacheSourcesNotOurProxy;
	//JP webcache column END

	//JP webcache file detail dialogue START
	uint64  WebCacheDownDataThisFile;
	uint32	Webcacherequests;
	uint32	SuccessfulWebcacherequests;
	//JP webcache file detail dialogue END
#endif // NEO: WC END <-- Xanatos --

    DWORD   lastSwapForSourceExchangeTick; // ZZ:DownloadManaager

	CRBMultiMap<UINT, SServer>	m_preferredServers; // NEO: XUC - [ExtendedUdpCache] <-- Xanatos --
};

