#pragma once
#include "Neo/GUI/CP/TreeOptionsCtrl.h" // NEO: FIX - [TreeControl] <-- Xanatos --

#define	MAX_DETAIL_ITEMS	7
#define	MAX_INTEGER_ITEMS	1

class CPPgDebug : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgDebug)

public:
	CPPgDebug();
	virtual ~CPPgDebug();

// Dialog Data
	enum { IDD = IDD_PPG_DEBUG };

protected:
	HTREEITEM m_htiServer;
	HTREEITEM m_htiClient;

	// detail level items
	HTREEITEM m_cb[MAX_DETAIL_ITEMS];
	HTREEITEM m_lv[MAX_DETAIL_ITEMS];
	UINT m_checks[MAX_DETAIL_ITEMS]; // NEO: FIX - [TreeControl] <-- Xanatos --
	int m_levels[MAX_DETAIL_ITEMS];

	// integer items
	HTREEITEM m_htiInteger[MAX_INTEGER_ITEMS];
	int m_iValInteger[MAX_INTEGER_ITEMS];

	CTreeOptionsCtrl m_ctrlTreeOptions; // NEO: FIX - [TreeControl] <-- Xanatos --
	bool m_bInitializedTreeOpts;

	void ClearAllMembers();

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
};
