//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"

#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->

#include <math.h>
#include <string.h>
#include "emule.h"
#include "PPgWebcachesettings.h"
#include "wizard.h"
#include "Scheduler.h"
#include "OtherFunctions.h"
#include "emuledlg.h"
#include "Preferences.h"
#include "Opcodes.h"
#include "StatisticsDlg.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "HelpIDs.h"
#include "DownloadQueue.h"
#include "Statistics.h"
#include "webcache.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgWebcachesettings, CPropertyPage)
CPPgWebcachesettings::CPPgWebcachesettings()
	: CPropertyPage(CPPgWebcachesettings::IDD)
{
	guardian=false;
	bCreated = false;
	bCreated2 = false;
	showadvanced = true;
}

CPPgWebcachesettings::~CPPgWebcachesettings()
{
}

void CPPgWebcachesettings::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgWebcachesettings, CPropertyPage)
	ON_EN_CHANGE(IDC_webcacheName, OnSettingsChange) 
	ON_EN_CHANGE(IDC_webcachePort, OnSettingsChange)
	ON_EN_CHANGE(IDC_BLOCKS, OnSettingsChange)
	ON_BN_CLICKED(IDC_Activatewebcachedownloads, OnEnChangeActivatewebcachedownloads)
	ON_BN_CLICKED(IDC_DETECTWEBCACHE, OnBnClickedDetectWebCache)
	ON_BN_CLICKED(IDC_EXTRATIMEOUT, OnSettingsChange)
	ON_BN_CLICKED(IDC_LOCALTRAFFIC, OnSettingsChange)
	ON_BN_CLICKED(IDC_PERSISTENT_PROXY_CONNS, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATE_WCSETTINGS, OnSettingsChange)
	ON_BN_CLICKED(IDC_ADVANCEDCONTROLS, OnBnClickedAdvancedcontrols)
	ON_BN_CLICKED(IDC_TestProxy, OnBnClickedTestProxy)//JP TMP
	ON_WM_HSCROLL()
	ON_WM_HELPINFO()
END_MESSAGE_MAP()


// CPPgWebcachesettings message handlers

BOOL CPPgWebcachesettings::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	// create hyperlinks 	
	// note: there are better classes to create a pure hyperlink, however since it is only needed here
	//		 we rather use an already existing class

	// Create email-proxy-submission link. The current settings will be included in the email.
	// Superlexx - email proxy submissions are not available anymore, use the web form

	//JP hide advanced settings
	if (showadvanced)
	{
		GetDlgItem(IDC_ADVANCEDCONTROLS)->SetWindowText(GetResString(IDS_X_WC_HIDE_ADV));
		GetDlgItem(IDC_EXTRATIMEOUT)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_LOCALTRAFFIC)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_BLOCKS)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_webcacheLimitles)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_BLOCKSTEXT)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_BLOCKSTEXT2)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_UPDATE_WCSETTINGS)->ShowWindow(SW_SHOW);
	}
	else
	{
		GetDlgItem(IDC_ADVANCEDCONTROLS)->SetWindowText(GetResString(IDS_X_WC_ADVANCED));
		GetDlgItem(IDC_EXTRATIMEOUT)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_LOCALTRAFFIC)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BLOCKS)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_webcacheLimitles)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BLOCKSTEXT)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BLOCKSTEXT2)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_UPDATE_WCSETTINGS)->ShowWindow(SW_HIDE);
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgWebcachesettings::OnEnChangeActivatewebcachedownloads()
{

	if (guardian) 
		return;
	guardian=true;
	SetModified();
	if(IsDlgButtonChecked(IDC_Activatewebcachedownloads)!=0)
	{
		GetDlgItem(IDC_webcacheName)->EnableWindow(true);  
		GetDlgItem(IDC_webcachePort)->EnableWindow(true);
		GetDlgItem(IDC_DETECTWEBCACHE)->EnableWindow(true);
		GetDlgItem(IDC_BLOCKS)->EnableWindow(true);
		GetDlgItem(IDC_EXTRATIMEOUT)->EnableWindow(true);
		GetDlgItem(IDC_LOCALTRAFFIC)->EnableWindow(true);
		GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->EnableWindow(true);
		GetDlgItem(IDC_UPDATE_WCSETTINGS)->EnableWindow(true);
		GetDlgItem(IDC_webcacheLimitles)->EnableWindow(true);
		GetDlgItem(IDC_ADVANCEDCONTROLS)->EnableWindow(true);
	}
	else
	{
		GetDlgItem(IDC_webcacheName)->EnableWindow(false);  //disable all other windows if webcachedownload disabled
		GetDlgItem(IDC_webcachePort)->EnableWindow(false);
		GetDlgItem(IDC_DETECTWEBCACHE)->EnableWindow(false);
		GetDlgItem(IDC_BLOCKS)->EnableWindow(false);
		GetDlgItem(IDC_EXTRATIMEOUT)->EnableWindow(false);
		GetDlgItem(IDC_LOCALTRAFFIC)->EnableWindow(false);
		GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->EnableWindow(false);
		GetDlgItem(IDC_UPDATE_WCSETTINGS)->EnableWindow(false);
		GetDlgItem(IDC_webcacheLimitles)->EnableWindow(false);
		GetDlgItem(IDC_ADVANCEDCONTROLS)->EnableWindow(false);
	}
		guardian=false;
}

void CPPgWebcachesettings::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
		if (!(thePrefs.UsesCachedTCPPort()))	// if the user doesn't use a cacheable port, disable everything and disable webcachedownload
		{
			// remove check from DialogeBox
			CheckDlgButton(IDC_Activatewebcachedownloads,false);
			GetDlgItem(IDC_Activatewebcachedownloads)->EnableWindow(false);
			
			// enter name in webcachename and disable window
			strBuffer.Format(_T("%s"), thePrefs.GetWebCacheName());
			GetDlgItem(IDC_webcacheName)->SetWindowText(strBuffer);
			GetDlgItem(IDC_webcacheName)->EnableWindow(false);

			// enter port in webcacheport and disable window
			strBuffer.Format(_T("%d"), thePrefs.GetWebCachePort());
			GetDlgItem(IDC_webcachePort)->SetWindowText(strBuffer);
			GetDlgItem(IDC_webcachePort)->EnableWindow(false);

			// display wrong port warning
			GetDlgItem(IDC_WrongPortWarning)->ShowWindow(SW_SHOW);
			thePrefs.webcacheEnabled=2;

			// disable autodetection window
			GetDlgItem(IDC_DETECTWEBCACHE)->EnableWindow(false);

			// disable reconnect settings
			GetDlgItem(IDC_BLOCKS)->EnableWindow(false);

			// disable extratimeout
			GetDlgItem(IDC_EXTRATIMEOUT)->EnableWindow(false);

			// disable localtraffic
			GetDlgItem(IDC_LOCALTRAFFIC)->EnableWindow(false);

			// disable persistentproxyconns
			GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->EnableWindow(false);

			// disable advanced settings button
			GetDlgItem(IDC_ADVANCEDCONTROLS)->EnableWindow(false);

			// disable WC autoupdate
			GetDlgItem(IDC_UPDATE_WCSETTINGS)->EnableWindow(false);

			GetDlgItem(IDC_webcacheLimitles)->EnableWindow(false);

			return;
		}

		// check/uncheck webcache
		GetDlgItem(IDC_Activatewebcachedownloads)->EnableWindow(true);
		CheckDlgButton(IDC_Activatewebcachedownloads,thePrefs.webcacheEnabled);
		
		if(thePrefs.webcacheEnabled == 1)
		{
			GetDlgItem(IDC_webcacheName)->EnableWindow(true);
			GetDlgItem(IDC_webcachePort)->EnableWindow(true);
			// enable autodetection
			GetDlgItem(IDC_DETECTWEBCACHE)->EnableWindow(true);
			GetDlgItem(IDC_BLOCKS)->EnableWindow(true);
			GetDlgItem(IDC_EXTRATIMEOUT)->EnableWindow(true);
			GetDlgItem(IDC_LOCALTRAFFIC)->EnableWindow(true);
			GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->EnableWindow(true);
			GetDlgItem(IDC_webcacheLimitles)->EnableWindow(true);
			// show advanced settings button
			GetDlgItem(IDC_ADVANCEDCONTROLS)->EnableWindow(true);
		}
		else
		{
			GetDlgItem(IDC_webcacheName)->EnableWindow(false);
			GetDlgItem(IDC_webcachePort)->EnableWindow(false);
			// enable autodetection
			GetDlgItem(IDC_DETECTWEBCACHE)->EnableWindow(false);
			GetDlgItem(IDC_BLOCKS)->EnableWindow(false);
			GetDlgItem(IDC_EXTRATIMEOUT)->EnableWindow(false);
			GetDlgItem(IDC_LOCALTRAFFIC)->EnableWindow(false);
			GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->EnableWindow(false);
			GetDlgItem(IDC_webcacheLimitles)->EnableWindow(false);
			// show advanced settings button
			GetDlgItem(IDC_ADVANCEDCONTROLS)->EnableWindow(false);
		}

		// enable webcacheName box and enter name 
		strBuffer.Format(_T("%s"), thePrefs.GetWebCacheName());
		GetDlgItem(IDC_webcacheName)->SetWindowText(strBuffer);

		// enable webcachePort box and enter Port
		strBuffer.Format(_T("%d"), thePrefs.GetWebCachePort());		
		GetDlgItem(IDC_webcachePort)->SetWindowText(strBuffer);

		// hide wrong port warning
		GetDlgItem(IDC_WrongPortWarning)->ShowWindow(SW_HIDE);

		// load parts to download before reconnect
		strBuffer.Format(_T("%d"), thePrefs.GetWebCacheBlockLimit());
		GetDlgItem(IDC_BLOCKS)->SetWindowText(strBuffer);

		// load extratimeoutsetting
		CheckDlgButton(IDC_EXTRATIMEOUT,thePrefs.IsWebCacheExtraTimeout());

		// load localtrafficsettings
		CheckDlgButton(IDC_LOCALTRAFFIC, thePrefs.IsWebCacheCachesLocalTraffic()==false);

		// load persistent proxy conns
		CheckDlgButton(IDC_PERSISTENT_PROXY_CONNS, thePrefs.IsPersistentConnections());

		// load autoupdate
		GetDlgItem(IDC_UPDATE_WCSETTINGS)->EnableWindow(thePrefs.webcacheEnabled == 1);
		CheckDlgButton(IDC_UPDATE_WCSETTINGS, thePrefs.WCAutoupdate);

		// limitles
		CheckDlgButton(IDC_webcacheLimitles, thePrefs.webcacheLimitles);
	}
}

BOOL CPPgWebcachesettings::OnApply()
{
    //bool bRestartApp = false;
	CString buffer;

	// set thePrefs.GetWebCacheName()
	if(GetDlgItem(IDC_webcacheName)->GetWindowTextLength())
	{
		CString nNewwebcache;
		GetDlgItem(IDC_webcacheName)->GetWindowText(nNewwebcache);		
		thePrefs.webcacheName = nNewwebcache;
//		if (thePrefs.GetWebCacheName() != nNewwebcache)
//			bRestartApp = true;
	}

	// set thePrefs.GetWebCachePort()
	if(GetDlgItem(IDC_webcachePort)->GetWindowTextLength())
	{
		GetDlgItem(IDC_webcachePort)->GetWindowText(buffer);
		uint16 nNewPort = (uint16)_tstol(buffer);
		if (!nNewPort) nNewPort=0;
		if (nNewPort != thePrefs.webcachePort)
			thePrefs.webcachePort = nNewPort;
	}
	
	// set thePrefs.webcacheEnabled
	UINT webcacheEnabled = IsDlgButtonChecked(IDC_Activatewebcachedownloads);
	if(thePrefs.webcacheEnabled?true:false != webcacheEnabled?true:false){
		thePrefs.WebCacheDisabledThisSession = false;
		theApp.downloadqueue->ChangeGlobalWebCacheEnable(webcacheEnabled?true:false);
	}
	thePrefs.webcacheEnabled = webcacheEnabled;

	// set thePrefs.webcacheLimitles
	thePrefs.webcacheLimitles = IsDlgButtonChecked(IDC_webcacheLimitles)!=0;
	
	
	// set thePrefs.GetWebCacheBlockLimit()
	if(GetDlgItem(IDC_BLOCKS)->GetWindowTextLength())
	{
		GetDlgItem(IDC_BLOCKS)->GetWindowText(buffer);
		uint16 nNewBlocks = (uint16)_tstol(buffer);
		if ((!nNewBlocks) || (nNewBlocks > 50000) || (nNewBlocks < 0)) nNewBlocks=0;
		if (nNewBlocks != thePrefs.GetWebCacheBlockLimit())
			thePrefs.SetWebCacheBlockLimit(nNewBlocks);
	}
	
	// set thePrefs.IsWebCacheExtraTimeout()
	thePrefs.SetWebCacheExtraTimeout(IsDlgButtonChecked(IDC_EXTRATIMEOUT) != 0);

	// set thePrefs.IsWebCacheCachesLocalTraffic
	uint8 cachestraffic;
	cachestraffic = (uint8)IsDlgButtonChecked(IDC_LOCALTRAFFIC);
	if (cachestraffic == 1) thePrefs.SetWebCacheCachesLocalTraffic(0);
	else thePrefs.SetWebCacheCachesLocalTraffic(1);

	// set thePrefs.IsPersistenConnections()
	thePrefs.PersistentConnectionsForProxyDownloads = IsDlgButtonChecked(IDC_PERSISTENT_PROXY_CONNS) != 0;

	// set thePrefs.WCAutoupdate
	thePrefs.WCAutoupdate = IsDlgButtonChecked(IDC_UPDATE_WCSETTINGS) != 0;

	SetModified(FALSE);
	LoadSettings();

	/*if (bRestartApp)
	{
		if (AfxMessageBox(GetResString(IDS_SETTINGCHANGED_RESTART),MB_YESNO | MB_ICONEXCLAMATION,0)==IDYES)
			theApp.emuledlg->RestartMuleApp();
		thePrefs.WebCacheDisabledThisSession = true;
	}*/

	return CPropertyPage::OnApply();
}

void CPPgWebcachesettings::Localize(void)
{	
	if (m_hWnd){
		GetDlgItem(IDC_Webcache)->SetWindowText( GetResString(IDS_X_WEBCACHE_ISP) );
		GetDlgItem(IDC_STATIC_PORT)->SetWindowText( GetResString(IDS_X_WC_PORT) );
		GetDlgItem(IDC_STATIC_ADDRESS)->SetWindowText( GetResString(IDS_X_WC_ADDRESS) );
		GetDlgItem(IDC_STATIC_CONTROLS)->SetWindowText( GetResString(IDS_X_WC_CONTROLS) );
		GetDlgItem(IDC_Activatewebcachedownloads)->SetWindowText( GetResString(IDS_X_WC_ENABLE) );
		GetDlgItem(IDC_webcacheLimitles)->SetWindowText( GetResString(IDS_X_WC_LIMITLES) );
		GetDlgItem(IDC_WrongPortWarning)->SetWindowText( GetResString(IDS_X_WC_WRONGPORT) );
		GetDlgItem(IDC_DETECTWEBCACHE)->SetWindowText( GetResString(IDS_X_WC_AUTO) );
		GetDlgItem(IDC_BLOCKSTEXT)->SetWindowText( GetResString(IDS_X_WC_NRBLOCKS) );
		GetDlgItem(IDC_BLOCKSTEXT2)->SetWindowText( GetResString(IDS_X_WC_BLOCK) );
		GetDlgItem(IDC_EXTRATIMEOUT)->SetWindowText( GetResString(IDS_X_WC_TIMEOUT) );
		GetDlgItem(IDC_LOCALTRAFFIC)->SetWindowText( GetResString(IDS_X_WC_LOCAL) );
		GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->SetWindowText( GetResString(IDS_X_WC_PERSISTENT) );
		GetDlgItem(IDC_ADVANCEDCONTROLS)->SetWindowText( GetResString(IDS_X_WC_ADVANCED) );
		GetDlgItem(IDC_TestProxy)->SetWindowText( GetResString(IDS_X_WC_TEST) );
		GetDlgItem(IDC_UPDATE_WCSETTINGS)->SetWindowText( GetResString(IDS_X_UPDATE_WCSETTINGS) );
	}
}

void CPPgWebcachesettings::OnBnClickedDetectWebCache()
{

	WCInfo_Struct* detectedWebcache = new WCInfo_Struct();
	bool reaskedDNS;	// tells if a DNS reverse lookup has been performed during detection; unneeded since we don't show it anymore

	try
	{
		reaskedDNS = DetectWebCache(detectedWebcache);
	}
	catch(CString strError)
	{
		delete detectedWebcache;
		AfxMessageBox(strError ,MB_OK | MB_ICONINFORMATION,0);
		return;
	}
	catch (...)
	{
		delete detectedWebcache;
		AfxMessageBox(GetResString(IDS_X_WC_DETECT_FAILED) ,MB_OK | MB_ICONINFORMATION,0);
		return;
	}

	CString comment = detectedWebcache->comment;
	for (int i=1; i*45 < comment.GetLength(); i++) // some quick-n-dirty beautifying  
		comment = comment.Left(i*45) + _T(" \n\t\t\t") + comment.Right(comment.GetLength() - i*45);

	CString message =	_T("Your ISP is:\t\t") + detectedWebcache->isp + _T(", ") + detectedWebcache->country + _T("\n") +
		_T("Your proxy name is:\t") + detectedWebcache->webcache + _T("\n") +
						_T("The proxy port is:\t\t") + detectedWebcache->port + _T("\n") +
						(comment != _T("") ? _T("comment: \t\t") + comment : _T(""));
	if (detectedWebcache->active == "0")
		message += _T("\n\ndue to detection results, webcache downloading has been deactivated;\nsee the comment for more details");

	if (AfxMessageBox(message, MB_OKCANCEL | MB_ICONINFORMATION,0) == IDCANCEL)
	{
		delete detectedWebcache;
		return;
	}

	CheckDlgButton(IDC_Activatewebcachedownloads, detectedWebcache->active == "1" ? BST_CHECKED : BST_UNCHECKED);
	GetDlgItem(IDC_webcacheName)->SetWindowText(detectedWebcache->webcache);
	GetDlgItem(IDC_webcachePort)->SetWindowText(detectedWebcache->port);
	GetDlgItem(IDC_BLOCKS)->SetWindowText(detectedWebcache->blockLimit);
	CheckDlgButton(IDC_EXTRATIMEOUT, detectedWebcache->extraTimeout == "1" ? BST_CHECKED : BST_UNCHECKED);
	CheckDlgButton(IDC_LOCALTRAFFIC, detectedWebcache->cachesLocal == "0" ? BST_CHECKED : BST_UNCHECKED);
	CheckDlgButton(IDC_PERSISTENT_PROXY_CONNS, detectedWebcache->persistentconns == "1" ? BST_CHECKED : BST_UNCHECKED);

	delete detectedWebcache;
}

BOOL CPPgWebcachesettings::OnCommand(WPARAM wParam, LPARAM lParam)
{
	/*if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}*/
	return __super::OnCommand(wParam, lParam);
}

void CPPgWebcachesettings::OnBnClickedAdvancedcontrols(){

	showadvanced = !showadvanced;
	if (showadvanced)
	{
		GetDlgItem(IDC_ADVANCEDCONTROLS)->SetWindowText(GetResString(IDS_X_WC_HIDE_ADV));
		GetDlgItem(IDC_EXTRATIMEOUT)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_LOCALTRAFFIC)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_BLOCKS)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_webcacheLimitles)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_BLOCKSTEXT)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_BLOCKSTEXT2)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_UPDATE_WCSETTINGS)->ShowWindow(SW_SHOW);
	}
	else
	{
		GetDlgItem(IDC_ADVANCEDCONTROLS)->SetWindowText(GetResString(IDS_X_WC_ADVANCED));
		GetDlgItem(IDC_EXTRATIMEOUT)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_LOCALTRAFFIC)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BLOCKS)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_webcacheLimitles)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BLOCKSTEXT)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BLOCKSTEXT2)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_PERSISTENT_PROXY_CONNS)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_UPDATE_WCSETTINGS)->ShowWindow(SW_HIDE);
	}
}

//JP proxy configuration test
void CPPgWebcachesettings::OnBnClickedTestProxy()
{
	if (thePrefs.IsWebCacheTestPossible())
	{
		if (!thePrefs.expectingWebCachePing)
		{
			//get webcache name from IDC_webcacheName
			CString cur_WebCacheName;
			GetDlgItem(IDC_webcacheName)->GetWindowText(cur_WebCacheName);
			if (cur_WebCacheName.GetLength() > 15 && cur_WebCacheName.Left(12) == "transparent@") //doesn't work for transparent proxies
			{
				AfxMessageBox(GetResString(IDS_X_MSG_WEBCACHE_TRANSPAR)); // leuk_he to rc.
				// Proxy Test can not test Transparent proxies. Test Canceled!
				return;
			}
			//get webcache port from IDC_webcachePort
			CString buffer;			
			GetDlgItem(IDC_webcachePort)->GetWindowText(buffer);
			uint16 cur_WebCachePort = (uint16)_tstol(buffer);
			if (PingviaProxy(cur_WebCacheName, cur_WebCachePort))
			{
				thePrefs.WebCachePingSendTime = ::GetTickCount();
				thePrefs.expectingWebCachePing = true;
				AfxMessageBox(GetResString(IDS_X_MSG_WEBCACHE_TESTRUNNING  )); // leuk_he to rc
				//Performing Proxy Test! Please check the log in the serverwindow for the results!
			}
			else
				AfxMessageBox(GetResString(IDS_X_MSG_WEBCACHE_TESTERR)); // leuk_he to rc
		}
		else 
			AfxMessageBox(GetResString(IDS_X_MSG_WEBCACHE_ALREADYRUNNING));// leuk_he to rc
	}
	else
		AfxMessageBox(GetResString(IDS_X_MSG_WEBCACHE_TESTREQ));// leuk_he to rc
}


#endif // NEO: WC END <-- Xanatos --