//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
/*
* Ini File Emtries
*/

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
#define INI_MANAGE_CONNECTIONS		L"ManageConnections"
#define	INI_MANAGE_CONNECTIONS_FACTOR L"ManageConnectionsFactor"

#define INI_NAFC_ENABLED			L"NAFCEnabled"
#define INI_CHECK_ADAPTER			L"CheckAdapter"
#define INI_ISP_CUSTOM_IP			L"ISPCustomIP"
#define INI_ISP_ZONE				L"ISPZone"
#define INI_ISP_MASK				L"ISPMask"
#define INI_BIND_TO_ADAPTER			L"BindToAdapter"


#define INI_CHECK_CONNECTION		L"CheckConnection"
#define INI_STATIC_LOWEST_PING		L"StaticLowestPing"
#define INI_PING_MODE				L"PingMode"
#define INI_NO_TTL					L"NoTTL"
#define INI_MANUAL_HOST_TO_PING		L"ManualHostToPing"
#define INI_PING_SERVER				L"PingServer"

#define INI_AUTO_MSS				L"AutoMSS"
#define INI_MSS						L"MSS"

#define	INI_USE_DOUBLE_SEND_SIZE	L"UseDoubleSendSize"


#define INI_DIRECT_DOWNLOAD			L"DirectDownload"
#define INI_DIRECT_RECEIVING_TCP	L"DirectReceivingTCP"
#define INI_DIRECT_RECEIVING_UDP	L"DirectReceivingUDP"
#define INI_BC_TIME_DOWN			L"BCTimeDown"
#define INI_BC_PRIORITY_DOWN		L"BCPriorityDown"
#define INI_SET_DOWNLOAD_BUFFER		L"UseDownloadBuffer"
#define INI_DOWNLOAD_BUFFER_SIZE	L"DownloadBufferLimit"

//#define INI_DIRECT_UPLOAD			L"DirectUpload"
#define INI_USE_BLOCKED_QUEUE		L"UseBlockedQueue"
#define INI_DIRECT_SENDING_TCP		L"DirectSendingTCP"
#define INI_DIRECT_SENDING_UDP		L"DirectSendingUDP"
#define INI_BC_TIME_UP				L"BCTimeUp"
#define INI_BC_PRIORITY_UP			L"BCPriorityUp"
#define INI_SET_UPLOAD_BUFFER		L"UseUploadBuffer"
#define INI_UPLOAD_BUFFER_SIZE		L"UploadBufferLimit"

#define INI_DATARATE_SAMPLES		L"DatarateSamples"

#define INI_INCLUDE_OVERHEAD		L"IncludeOverhead"
#define INI_INCLUDE_TCP_ACK			L"IncludeTCPAck"
#define INI_CONNECTIONS_OVERHEAD	L"ConnectionsOverHead"
#define INI_ZZ_RATIO				L"SessionRatio"


#define INI_DOWNLOAD_CONTROL		L"DownloadControl"
#define INI_MIN_BC_DOWNLOAD			L"MinBCDownload"
#define INI_MAX_BC_DOWNLOAD			L"MaxBCDownload"


#define INI_UPLOAD_CONTROL			L"UploadControl"
#define INI_MIN_BC_UPLOAD			L"MinBCUpload"
#define INI_MAX_BC_UPLOAD			L"MaxBCUpload"


#define INI_MAX_DOWN_STREAM			L"MaxDownStream"
#define INI_MAX_UP_STREAM			L"MaxUpStream"


#define INI_MINIMIZE_OPENED_SLOTS	L"MinimizeOpenedSlots"
#define INI_CUMULATE_BANDWIDTH		L"CumulateBandwidth"
#define INI_BADWOLFS_UPLOAD			L"BadwolfsUpload"

#define INI_INCREASE_TRICKLE_SPEED	L"IncreaseTrickleSpeed"
#define INI_INCREASE_TRICKLE_SPEED_VALUE L"IncreaseTrickleSpeedValue"

#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
#define INI_SEPARATE_RELEASE_BANDWIDTH	L"SeparateReleaseBandwidth"
#define INI_RELEASE_SLOT_SPEED			L"ReleaseSlotSpeed"
#define INI_RELEASE_BANDWIDTH_PERCENTAGE L"ReleaseBandwidthPercentage"

#define INI_SEPARATE_FRIEND_BANDWIDTH	L"SeparateFriendBandwidth"
#define INI_FRIEND_SLOT_SPEED			L"riendSlotSpeed"
#define INI_FRIEND_BANDWIDTH_PERCENTAGE	L"FriendBandwidthPercentage"
#endif // NEO_UBT // NEO: BM END

#define INI_MAX_RESERVED_SLOTS		L"MaxReservedSlots"

#define	INI_OPEN_MORE_SLOTS_WHEN_NEEDED	L"OpenMoreSlotsWhenNeeded"
#define	INI_CHECK_SLOT_DATARATE 	L"CheckSlotDatarate"

#define	INI_TRICKLE_BLOCKING		L"IsTrickleBlocking"
#define	INI_DROP_BLOCKING			L"IsDropBlocking"

//#define	INI_ALLOW_OVER_SENDING		L"AllowOverSending"


#define INI_DYN_UP_GOING_DIVIDER		L"DynUpGoingDivider"
#define INI_DYN_UP_GOING_UP_DIVIDER		L"DynUpGoingUpDivider"
#define INI_DYN_UP_GOING_DOWN_DIVIDER	L"DynUpGoingDownDivider"

#define INI_UP_MAX_PING_METHOD		L"UpMaxPingMethod"
#define INI_BASE_PING_UP			L"BasePingUp"
#define INI_PING_UP_TOLERANCE		L"PingUpTolerance"
#define INI_PING_UP_PROZENT			L"PingUpProzent"


#define INI_DYN_DOWN_GOING_DIVIDER			L"DynDownGoingDivider"
#define INI_DYN_DOWN_GOING_UP_DIVIDER		L"DynDownGoingUpDivider"
#define INI_DYN_DOWN_GOING_DOWN_DIVIDER		L"DynDownGoingDownDivider"
	
#define INI_DOWN_MAX_PING_METHOD	L"DownMaxPingMethod"
#define INI_BASE_PING_DOWN			L"BasePingDown"
#define INI_PING_DOWN_TOLERANCE		L"PingDownTolerance"
#define INI_PING_DOWN_PROZENT		L"PingDownProzent"
#endif // NEO_BC // NEO: NBC END

#define INI_ONLY_COMPLETE_FILE		L"OnlyCompleteFile"
#define INI_TO_OLD_COMPLETE			L"ToOldComplete"
#define INI_CUSTOM_SHARE_VIWE_PERMISSIONS L"UseCustonViewSharePermissions"
#define INI_SAVE_COMMENTS			L"SaveComments" // NEO: XC - [ExtendedComments]
#define INI_KNOWN_COMMENTS			L"KnwonComments" // NEO: XCk - [ExtendedKnownComments]

// NEO: NST - [NeoSourceTweaks]
#define INI_HARD_LIMIT				L"HardLimit"
#define INI_SWAP_LIMIT				L"SwapLimit"
#define INI_CLEANUP_LIMIT			L"CleanUpLimit"
#define INI_CALC_LIMITS				L"CalculateLimits"

#define INI_XS_DISABLE				L"XSDisable"
#define INI_XS_LIMIT				L"XSLimit"
#define INI_XS_INTERVAL				L"XSInterval"
#define INI_XS_CLIENT_INTERVAL		L"XSClientInterval"
#define INI_XS_ANSWER_LIMIT			L"XSAnswerLimit"
#define INI_XS_DELAY_VALUE			L"XSDelayValue"

#define INI_SVR_DISABLE				L"SVRDisable"
#define INI_SVR_LIMIT				L"SVRLimit"
#define INI_SVR_INTERVAL			L"SVRInterval"

#define INI_KAD_DISABLE				L"KADDisable"
#define INI_KAD_LIMIT				L"KADLimit"
#define INI_KAD_INTERVAL			L"KADInterval"
#define INI_KAD_AMOUNT				L"KADAmount"
#define INI_KAD_DELAY_VALUE			L"KADDelayValue"

#define INI_UDP_DISABLE				L"UDPDisable"
#define INI_UDP_LIMIT				L"UDPLimit"
#define INI_UDP_INTERVAL			L"UDPInterval"
#define INI_GLOBAL_UDP_INTERVAL		L"GLOBALUDPInterval"
#define INI_UDP_AMOUNT				L"UDPAmount"
// NEO: XUC - [ExtendedUdpCache]
#define INI_UDP_CATCH				L"UDPCache"
#define INI_UDP_CATCH_AMOUNT		L"UDPCacheAmount"
// NEO: XUC END
#define INI_RARE_FILE				L"RareFileLimit"
// NEO: NST END

// NEO: NSD - [NeoSourceDrop]
#define INI_LOW2LOW_CLEANUP_TIME	L"Low2LowCleanUpTime"
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
#define INI_BAD_CLEANUP_TIME		L"BadCleanUpTime"
#define INI_GONE_CLEANUP_TIME		L"GoneCleanUpTime"
#define INI_SUSPEND_CLEANUP_TIME	L"SuspendCleanUpTime"
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
#define INI_NNP_CLEANUP_TIME		L"NnPCleanUpTime"
#define INI_FULLQ_CLEANUP_TIME		L"FullQCleanUpTime"
// NEO: NSD END

#define INI_USE_CHUNK_DOTS			L"UseChunkDots"
#define INI_USE_RELATIVE_CHUNK_DISPLAY L"m_bUseRelativeChunkDisplay"
#define INI_USE_TREES_TYLE			L"UseTreeStle"
#define INI_SHOW_FILE_TYPE_ICON		L"ShowFileTypeIcon"
#define INI_SHOW_FILE_STATUS_ICON	L"ShowFileStatusIcon"
#define INI_COLLOR_SHARE_FILES		L"ShowFileStatusIcons"
#define INI_SHOW_BANNER				L"ShowBanner"
#define INI_SHOW_HASH_PROGRES		L"ShowHashProgres"
#define INI_USE_PLUS_SPEEDMETER		L"UsePlusSpeedMeter"
// NEO: NSTI - [NewSystemTrayIcon]
#define INI_SHOW_SYSTEM_TRAY_UPLOAD L"ShowSystemTrayUpload"
#define INI_THIN_SYSTEM_TRAY_BARS	L"ThinSystemTrayBars"
#define INI_TRAY_BARS_MAX_COLLOR	L"TrayBarsMaxCollor"
// NEO: NSTI END
#define INI_STATIC_TRAY_ICON		L"StaticTrayIcon" // NEO: STI - [StaticTray]
#define INI_DISABLE_AUTO_SORT		L"DisableAutoSort" // NEO: SE - [SortExtension]
#define INI_SHOW_CLIENT_PERCENTAGE  L"ShowClientPercentage" // NEO: MOD - [Percentage]

// NEO: SI - [SysInfo]
#define INI_SYS_INFO_GRAPH			L"ShowSystemInfoGraph"
#define INI_SYS_INFO_TITLE			L"ShowSystemInfoInTitle"
// NEO: SI END
	
// NEO: NTB - [NeoToolbarButtons]
#define INI_NEO_TOOLBAR				L"NeoToolbar"
#define INI_NEO_TOOLBAR_BUTTONS		L"NeoToolbarButtons"
#define INI_NEO_TOOLBAR_BUTTON		L"NeoToolbarButton"
// NEO: NTB EBD

// NEO: CTB - [CoolToolBar]
#define INI_USE_COOL_TOOLBAR		L"CoolToolbar"
#define INI_USE_COOL_TOOLBAR_TEXT	L"CoolToolbarText" 
#define INI_COOL_TOOLBAR_CENTER		L"CoolToolbarCenter"
#define INI_COOL_TOOLBAR_RIGHT		L"CoolToolbarRight"
#define INI_COOL_TOOLBAR_BUTTONS	L"CoolToolbarButtons"
#define INI_COOL_TOOLBAR_BUTTON		L"CoolToolbarButton"
// NEO: CTB END

// NEO: NMX - [NeoMenuXP]
#define INI_SHOW_XP_SIDEBAR			L"ShowXPSideBar"
#define INI_SHOW_XP_BITMAP			L"ShowXPBitmap"
#define INI_XP_MENU_STYLE			L"XPMenuStyle"
#define INI_GRAY_MENU_ICON			L"GrayMenuIcon"
// NEO: NMX END 

// NEO: MM - [NeoMiniMule]
#define INI_ENABLE_MINIMULE			L"EnableMiniMule"
#define INI_AUTO_MINIMULE			L"AutoShowMiniMule"
#define INI_MINIMULE_ONTOP			L"MiniMuleOnTop"
#define INI_MINIMULE_UPDATE			L"AutoUpdateHidenMiniMule"
#define INI_MINIMULE_TRANSPARENCY	L"MiniMuleTransparency"
#define INI_MINIMULE_BACKGROUND		L"MiniMuleBack"
#define INI_MINIMULE_LABEL			L"MiniMuleLabel"
// NEO: MM END

// NEO: IM - [InvisibelMode]
#define INI_INVISIBLEMODE_ENABLE	L"InvisibleMode"
#define INI_INVISIBLEMODE_KEY		L"InvisibleModeHKKey"
#define INI_INVISIBLEMODE_KEY_MOD	L"InvisibleModeHKKeyModifier"
// NEO: IM END

// NEO: TPP - [TrayPasswordProtection]
#define INI_TRAY_PASSWORD_PROTECTION L"TrayPasswordProtection"
#define INI_TRAY_PASSWORD			L"TrayPassword"
// NEO: TPP END

#define INI_SHOW_MY_FULL_INFO		L"ShowMyFullInfo"

#define INI_SMOOTH_STATISTICS_GRAPHS L"SmoothStatisticsGraphs"

// NEO: MMR - [MorphMassRemane]
#define INI_SIMPLE_CLEANUP_OPTIONS		L"SimpleCleanupOptions"
#define INI_SIMPLE_CLEANUP_SEARCH		L"SimpleCleanupSearch"
#define INI_SIMPLE_CLEANUP_REPLACE		L"SimpleCleanupReplace"
#define INI_SIMPLE_CLEANUP_SEARCH_CHARS	L"SimpleCleanupSearchChars"
#define INI_SIMPLE_CLEANUP_REPLACE_CHARS L"SimpleCleanupReplaceChars"
// NEO: MMR END

// NEO: CRC - [MorphCRCTag] -- Xanatos -->
#define INI_DONT_ADD_CRC32_TO_FILENAME	L"DontAddCRCToFilename"
#define INI_FORCE_CRC32_UPPERCASE		L"CRC32ForceUppercase"
#define INI_FORCE_CRC32_ADDING			L"CRC32ForceAdding"
#define INI_LAST_CRC32_PREFIX			L"CRC32Prefix"
#define INI_LAST_CRC32_SUFFIX			L"CRC32Suffix"
// NEO: CRC END <-- Xanatos --

#define INI_PART_TRAFFIC			L"UsePartTraffic" // NEO: NPT - [NeoPartTraffic]
#define INI_PART_TRSFFIC_COLLOR		L"PartTrafficCollorStyle" // NEO: NPT - [NeoPartTraffic]
#define INI_CLASSIC_SHARED_BARS		L"UseClassicShareStatusBar"

#define INI_SAVE_QUEUE				L"SaveUploadQueueWaitTime" // NEO: SQ - [SaveUploadQueue]

// NEO: TQ - [TweakUploadQueue]
#define INI_INFINITE_QUEUE			L"UseInfiniteQueue"

#define INI_QUEUE_OVERFLOW_RELEASE			L"AlowQueueOverflowRelease"
#define INI_QUEUE_OVERFLOW_SOURCE_LIMIT	L"AlowQueueOverflowSourceLimit"

#define INI_QUEUE_OVERFLOW_EXTENDED			L"AlowQueueOverflowExtended"
#define INI_QUEUE_OVERFLOW_EXTENDED_LIMIT	L"AlowQueueOverflowExtendedLimit"

#define INI_QUEUE_OVERFLOW_DEFAULT			L"AlowQueueOverflowDefault"
#define INI_QUEUE_OVERFLOW_DEFAULT_LIMIT	L"AlowQueueOverflowDefaultLimit"

#define INI_QUEUE_OVERFLOW_COMFRIEND		L"AlowQueueOverflowComFriend"
#define INI_QUEUE_OVERFLOW_COMFRIEND_LIMIT	L"AlowQueueOverflowComFriendLimit"
// NEO: TQ END

#define INI_MULTI_QUEUE				L"UseOneQueuePerFile" // NEO: MQ - [MultiQueue]
#define INI_RANDOM_QUEUE			L"UseRandomQueue" // NEO: RQ - [RandomQueue]

#define INI_OLD_PRIOSYS				L"UseOldPriorityScore"

// NEO: NMFS - [NiceMultiFriendSlots]
#define INI_FRIEND_SLOT_LIMIT		L"UseFriendSlotLimit"
#define INI_FRIEND_SLOT_LIMIT_VALUE	L"FriendSlotLimitValue"
// NEO: NMFS END

// NEO: RT - [ReleaseTweaks]
#define INI_RELEASE_LEVEL			L"ReleaseLevel"
#define INI_RELEASE_MODE			L"ReleaseMode"

#define INI_RELEASE_LIMIT_MODE		L"ReleaseLimitMode"
#define INI_RELEASE_LIMIT_UNION		L"ReleaseLimitUnion"
#define INI_RELEASE_LIMIT_COMPLETE_MODE		L"ReleaseLimitCompleteMode"

#define INI_RELEASE_LIMIT			L"ReleaseLimit"
#define INI_RELEASE_LIMIT_HIGH		L"ReleaseLimitHigh"
#define INI_RELEASE_LIMIT_LOW		L"ReleaseLimitLow"

#define INI_RELEASE_LIMIT_COMPLETE	L"ReleaseLimitComplete"
#define INI_RELEASE_LIMIT_COMPLETE_HIGH L"ReleaseLimitCompleteHigh"
#define INI_RELEASE_LIMIT_COMPLETE_LOW L"ReleaseLimitCompleteLow"

#define INI_LIMIT_UNION				L"LimitUnion"

#define INI_SOURCE_LIMIT_MODE		L"SourceLimitMode"
#define INI_SOURCE_LIMIT_UNION		L"SourceLimitUnion"
#define INI_SOURCE_LIMIT_COMPLETE_MODE	L"SourceLimitCompleteMode"

#define INI_SOURCE_LIMIT			L"SourceLimit"
#define INI_SOURCE_LIMIT_HIGH		L"SourceLimitHigh"
#define INI_SOURCE_LIMIT_LOW		L"SourceLimitLow"

#define INI_SOURCE_COMPLETE_LIMIT	L"SourceLimitComplete"
#define INI_SOURCE_COMPLETE_LIMIT_HIGH L"SourceLimitCompleteHigh"
#define INI_SOURCE_COMPLETE_LIMIT_LOW L"SourceLimitCompleteLow"

#define INI_RELEASE_NEED_COMPLETE	L"ReleaseNeedComplete"
#define INI_RELEASE_NEED_COMPLETE_LIMIT	L"ReleaseNeedCompleteLimit" 

#define INI_RELEASE_SLOT_LIMIT			L"UseReleaseSlotLimit"
#define INI_RELEASE_SLOT_LIMIT_VALUE	L"ReleaseSlotLimitValue"
// NEO: RT END

// NEO: NCAP - [NeoCustomAutoPriority]
#define INI_DYNAMIC_AUTO_UP_PRIORITY	L"DynamicAutoUpPriority"
#define INI_DYNAMIC_UP_PRIORITY_FACTOR L"DynamicUpPriorityFactor"
#define INI_LOW_UP_PRIO_THRESHOLD L"LowUpPrioThreshold"
#define INI_HIGH_UP_PRIO_THRESHOLD L"HighUpPrioThreshold"
// NEO: NCAP END

// NEO: PRSF - [PushSmallRareFiles]
#define INI_PUSH_SMALL_FILES		L"PushSmallFiles"
#define INI_PUSH_SMALL_FILES_SIZE	L"PushSmallFilesSize"

#define INI_PUSH_RARE_FILES			L"PushRareFiles"
#define INI_PUSH_RARE_FILES_VALUE	L"PushRareFilesValue"

#define INI_PUSH_RATIO_FILES		L"PushRatioFiles"
#define INI_PUSH_RATIO_FILES_VALUE	L"PushRatioFilesValue"
// NEO: PRSF END

#define INI_USE_NEO_SCORE			L"NeoScoreSystem"// NEO: NFS - [NeoScoreSystem]
#define INI_USE_NEO_CREDIT			L"NeoCreditSystem"// NEO: NCS - [NeoCreditSystem]
#define INI_CREDIT_SYSTEM			L"CreditSystem" // NEO: OCS - [OtherCreditSystems]

#define INI_INTELIGENT_CHUNK_SELECTION L"UseInteligentChunkSelection" // NEO: ICS - [InteligentChunkSelection]
#define INI_REAL_PART_STATUS		L"UseRealPartStatus" // NEO: RPS - [RealPartStatus]
#define	INI_SUB_CHUNK_TRANSFER		L"SubChunkTransfer" // NEO: SCT - [SubChunkTransfer]
#define	INI_SUB_CHUNK_VERIFICATION	L"SubChunkVerification" // NEO: SCT - [SubChunkVerification]

#define INI_SHAREEMPTYFILES			L"ShareAlsoEmptyFiles" // NEO: SEF - [ShareAlsoEmptyFiles]

// NEO: NXI - [NeoExtraInfo]
#define INI_NXI_ENABLE				L"SendExtraInfo"
#define INI_NXI_BW					L"SendExtraBandwidthInfo"
#define INI_NXI_UP_TIME				L"SendEstraUpTimeInfo"
#define INI_NXI_DL_FILE				L"SendExtraDownloadFileInfo"
#define INI_NXI_UL_FILE				L"SendExtraUploadFileInfo"
#define INI_NXI_WAITING_USERS		L"SendExtraWaitingUsersInfo"
#define INI_NXI_SOME_INFO			L"SendExtraSomeInfoString"
// NEO: NXI END

#define INI_APP_PRIORITY			L"AppPriority"
// NEO: MOD - [NiceHash]
#define INI_USE_HASHING_DELAY		L"UseHashingDelay"
#define INI_HASHING_DELAY			L"HashingDelay"
// NEO: MOD END
// NEO: MOD - [RelaxCPU]
#define INI_USE_PROCESSING_DELAY	L"UseProcessingDelay"
#define INI_PROCESSING_DELAY		L"ProcessingDelay"
// NEO: MOD END
// NEO: MOD - [RefreshShared]
#define INI_REFRESH_SHARED			L"RefreshShared"
#define INI_REFRESH_SHARED_INTERVALS L"RefreshSharedIntervals"
// NEO: MOD END

#define INI_PAUSE_ON_FILE_COMPLETE L"m_bPauseOnFileComplete" // NEO: POFC - [PauseOnFileComplete]

#define INI_ESTIMATED_DL_TIME		L"UseEstimatedDownloadTime" // NEO: EDT - [EstimatedDownloadTime] 
#define INI_L2HAC					L"UseLowID2HighIDAutoCallback" // NEO: L2H - [LowID2HighIDAutoCallback]

#define INI_ANTI_HIDE_OS			L"UseAntiHideOS" // NEO: AHOS - [AntiHideOS]
// NEO: DKA - [DownloadKeepAlive]
#define	INI_ENABLE_DOWNLOAD_KEEP_ALIVE	L"EnableDownloadKeepAlive"
#define INI_DOWNLOAD_KEEP_ALIVE_TIMEOUT	L"DownloadKeepAliveTimeout"
// NEO: DKA END
// NEO: TCR - [TCPConnectionRetry]
#define INI_TCP_CON_RETRY_ENABLE	L"UseTCPConnectionRetry"
#define INI_TCP_CON_RETRY_VALUE		L"TCPConnectionRetrys"
// NEO: TCR END
#define INI_TCP_DISABLE_NAGLE		L"TCPDisableNagle"

// NEO: IPS - [InteligentPartSharing]
#define INI_IPS_ENABLE				L"InteligentPartSharing"
#define INI_IPS_TIMER				L"InteligentPartSharingTimer"
#define INI_IPS_MAXIMUM				L"MaxProzentToHide"

#define INI_IPS_HIDE_OA				L"HideOverAvaliblyParts"
#define INI_IPS_OA_MODE				L"HideOverAvaliblyMode"
#define INI_IPS_OA_VALUE			L"HideOverAvaliblyValue"
#define INI_IPS_OA_CATCH			L"HideOverAvaliblyCatch"

#define INI_IPS_HIDE_OS				L"HideOverSharedParts"
#define INI_IPS_OS_MODE				L"HideOverSharedMode"
#define INI_IPS_OS_VALUE			L"HideOverSharedValue"
#define INI_IPS_OS_CALC				L"HideOverSharedCalc"
	
#define INI_IPS_SHOW_UA				L"DontHideUnderAvaliblyParts"
#define INI_IPS_UA_MODE				L"DontHideUnderAvaliblyMode"
#define INI_IPS_UA_VALUE			L"DontHideUnderAvaliblyValue"

#define INI_IPS_BLOCK_OA			L"BlockHighOverAvaliblyParts"
#define INI_IPS_OA_FACTOR			L"BlockHighOverAvaliblyFactor"

#define INI_IPS_BLOCK_OS			L"BlockHighOverSharedParts"
#define INI_IPS_OS_FACTOR			L"BlockHighOverSharedFactor"

#define INI_IPS_SHOW_ALWAYS_NEEDED	L"ShowAlwaysNeeded"
#define INI_IPS_SHOW_ALWAYS_PARTS	L"ShowAlwaysNeededValue"

#define INI_IPS_SHOW_ALWAYS_INCOMPLETE L"ShowAlwaysIncomplete"
// NEO: IPS END

#define INI_COMMUNITY				L"Community" // NEO: NC - [NiceCommunity]

#ifdef ARGOS // NEO: NA - [NeoArgos]
#define INI_USE_ARGOS_SYSTEM				L"UseArgosSystem"

#define INI_CREDIT_COMPENSATION				L"CreditCompensation"

#define INI_TRUST_UNARGOS_HASH_THIEF		L"TrustUnArgosHashThief"
#define INI_TRUST_UNARGOS_HASH_CHANGED		L"TrustUnArgosHashChanged"
#define INI_TRUST_UNARGOS_GHOST_MODE		L"TrustUnArgosGhostMode"
#define INI_TRUST_UNARGOS_AGRESSIV			L"TrustUnArgosAgressiv"
#define INI_ARGOS_TRUST_TIME				L"ArgosTrustTime"

#define INI_CLOSE_MAELLA_BACKDOOR			L"CloseMaellaBackdoor"

#define INI_DONT_BAN_FRIENDS				L"DontBanFriends"
#define INI_DONT_BAN_COMMUNITY				L"DontBanCommunity"

#define INI_ARGOS_PROCESS_TIME				L"ArgosProcessTime"
#define INI_ARGOS_TRACK_TIME				L"ArgosTrackTime"
#define INI_ARGOS_GENERIC_BAN_TIME			L"ArgosGenericBanTime"
#define INI_ARGOS_CORRUPTED_SENDER_TIME		L"ArgosCorruptedSenderTime"
#define INI_ARGOS_FILE_SCANNER_TIME			L"ArgosFileScannerTime"
#define INI_ARGOS_FILE_FAKER_TIME			L"ArgosFileFakerTime"
#define INI_ARGOS_AGRESSION_TIME			L"ArgosAgressionBanTime"
#define INI_ARGOS_OPCODE_TIME				L"ArgosOpCodeTime"
#define INI_ARGOS_HASH_CHANGED_TIME			L"ArgosHashChangedTime"
#define INI_ARGOS_RANK_FLOODER_TIME			L"ArgosRankFlooderTime"
#define INI_ARGOS_GHOST_MODE_TIME			L"ArgosGhostModeTime"	
#define INI_ARGOS_FAILED_TIME				L"ArgosFailedTime"
#define INI_ARGOS_XS_EXPLOIT_TIME			L"ArgosXSExploitTime"
#define INI_ARGOS_NICK_CHANGER_TIME			L"ArgosNickChangerTime"
#define INI_ARGOS_MOD_CHANGER_TIME			L"ArgosModChangerTime"
#define INI_ARGOS_SPAMTIME_TIME				L"ArgosSpamTime"
#define INI_ARGOS_BAD_HELLO_TIME			L"ArgosBadHelloTime"
#define INI_ARGOS_BAD_PROT_TIME				L"ArgosBadProtTime"
		
#define INI_ARGOS_GPL_BREAKER_PUNISHMENT	L"ArgosGPLBreakerPunishment"
#define INI_ARGOS_HARD_LEECHER_PUNISHMENT	L"ArgosHardLeecherPunishment"
#define INI_ARGOS_NORMAL_LEECHER_PUNISHMENT	L"ArgosNormalLeecherPunishment"
#define INI_ARGOS_SOFT_LEECHER_PUNISHMENT	L"ArgosSoftLeecherPunishment"
#define INI_ARGOS_BAD_MOD_PUNISHMENT		L"ArgosBadModPunishment"
#define INI_ARGOS_NICK_THIEF_PUNISHMENT		L"ArgosNickThiefPunishment"
#define INI_ARGOS_MOD_THIEF_PUNISHMENT		L"ArgosModThiefPunishment"
#define INI_ARGOS_HASH_THIEF_PUNISHMENT		L"ArgosHashThiefPunishment"
#define INI_ARGOS_CREDIT_HACK_PUNISHMENT	L"ArgosCreditHackPunishment"
#define INI_ARGOS_HASH_CHANGED_PUNISHMENT	L"ArgosHashChangedPunishment"
#define INI_ARGOS_GHOST_MODE_PUNISHMENT		L"ArgosGhostModePunishment"
#define INI_ARGOS_FAKE_CLIENT_PUNISHMENT	L"ArgosFakeClientPunishment"
#define INI_ARGOS_AGRESSON_PUNISHMENT		L"ArgosAgressonPunishment"
#define INI_ARGOS_FILE_SCANNER_PUNISHMENT	L"ArgosFileScannerPunishment"
#define INI_ARGOS_FILE_FAKER_PUNISHMENT		L"ArgosFileFakerPunishment"
#define INI_ARGOS_CORRUPTED_SENDER_PUNISHMENT L"ArgosCorruptedSenderPunishment"
#define INI_ARGOS_RANK_FLOODER_PUNISHMENT	L"ArgosRankFlooderPunishment"
#define INI_ARGOS_FAILED_PUNISHMENT			L"ArgosFailedPunishment"
#define INI_ARGOS_XS_EXPLOIT_PUNISHMENT		L"ArgosXSExploitPunishment"
#define INI_ARGOS_NICK_CHANGER_PUNISHMENT	L"ArgosNickChangerPunishment"
#define INI_ARGOS_MOD_CHANGER_PUNISHMENT	L"ArgosModChangerPunishment"
#define INI_ARGOS_SPAM_PUNISHMENT			L"ArgosSpamPunishment"
#define INI_ARGOS_BAD_HELLO_PUNISHMENT		L"ArgosBadHelloPunishment"
#define INI_ARGOS_BAD_PROT_PUNISHMENT		L"ArgosBadProtPunishment"

#define INI_ARGOS_LEECHER_MOD_DETECTION		L"ArgosLeecherModDetection"
#define INI_ARGOS_LEECHER_NICK_DETECTION	L"ArgosLeecherNickDetection"
#define INI_ARGOS_DETECTION_LEVEL			L"ArgosDetectionLevel"
#define INI_ARGOS_OPCODE_DETECTION			L"ArgosOpcodeDetection"
#define INI_ARGOS_LEECHER_HASH_DETECTION	L"ArgosLeecherHashDetection"
#define INI_ARGOS_NICK_THIEF_DETECTION		L"ArgosNickThiefDetection"
#define	INI_PLAIN_ANTI_NICKT_HIEF			L"PlainAntiNickThief"
#define INI_ARGOS_MOD_THIEF_DETECTION		L"ArgosModThiefDetection"
#define INI_ARGOS_HASH_THIEF_DETECTION		L"ArgosHashThiefDetection"
#define INI_ARGOS_THIEF_ZONE_DETECTION		L"ArgosThiefZoneDetection"
#define INI_ARGOS_CREDIT_HACK_DETECTION		L"ArgosCreditHackDetection"
#define INI_HASH_CHANGE_DETECTION			L"HashChangeDetection"
#define INI_HASH_CHANGE_DETECTION_MODE		L"HashChangeDetectionMode"
#define INI_ARGOS_GHOST_MOD_DETECTION		L"ArgosGhostModDetection"
#define INI_ARGOS_FAKE_CLIENT_DETECTION		L"ArgosFakeClientDetection"
#define INI_AGRESSION_DETECTION				L"AgressionDetection"
#define INI_AGRESSION_TIME					L"AgressionIntervals"
#define	INI_AGRESSION_THRESHOLD				L"AgressionThreshold"
#define INI_FILE_SCANNER_DETECTION			L"FileScannerDetection"
#define INI_FILE_FAKER_DETECTION			L"FileFakerDetection"
#define INI_BAD_SENDER_DETECTION			L"BadSenderDetection"
#define INI_RANK_FLOOD_DETECTION			L"RankFloodDetection"
#define INI_FAILED_DETECTION				L"FailedDetection"
#define	INI_FAILED_TRIES					L"FailedTries"
#define	INI_FAILED_THRESHOLD				L"FailedThreshold"
#define	INI_XS_EXPLOIT_DETECTION			L"XSExploitDetection"
#define	INI_XS_EXPLOIT_INTERVALS			L"XSExploitIntervals"
#define	INI_XS_EXPLOIT_THRESHOLD			L"XSExploitThreshold"
#define	INI_NICK_CHANGER_DETECTION			L"NickChangerDetection"
#define	INI_NICK_CHANGE_INTERVALS			L"NickChangeIntervals"
#define	INI_NICK_CHANGE_THRESHOLD			L"NickChangeThreshold"
#define	INI_MOD_CHANGER_DETECTION			L"ModChangerDetection"
#define	INI_MOD_CHANGE_INTERVALS			L"ModChangeIntervals"
#define	INI_MOD_CHANGE_THRESHOLD			L"ModChangeThreshold"
#define	INI_SPAM_DETECTION					L"SpamDetection"
#define	INI_BAD_HELLO_DETECTION				L"BadHelloDetection"
//#define	INI_MD4_HELLO_DETECTION				L"md4HelloDetection"
#define INI_EMCRYPT_DETECTION				L"eMCryptDetection"
#define	INI_BAD_PROT_DETECTION				L"BadProtDetection"
#define	INI_DLP_DETECTION					L"DLPDetection"

#define INI_ARGOS_LOG_LEECHERS				L"ArgosLogLeechers"
#endif // ARGOS // NEO: NA END

//#define INI_RARE_FILE				L"RareFileValue"

// NEO: SR - [SpreadReask]
#define INI_SPREAD_REASK			L"UseSpreadReask"
#define INI_SPREAD_REASK_VALUE		L"SpreadReaskvalue"
// NEO: SR END

// NEO: OCC - [ObelixConnectionControl]
#define INI_OCC						L"UseObelixConnectionControl" 
#define INI_OCC_VALUE				L"ObelixConnectionControlValue" 
// NEO: OCC END

// NEO: ASL - [AutoSoftLock]
#define INI_ASL						L"UseAutoSiftLimit"
#define INI_ASL_VALUE				L"AutoSiftLimitValue"
// NEO: ASL END

// NEO: XSC - [ExtremeSourceCache]
#define INI_SOURCE_CACHE			L"SourceCache"
#define INI_SOURCE_CACHE_LIMIT		L"SourceCacheLimit"
#define INI_SOURCE_CACHE_TIME		L"SourceCacheTime"
// NEO: XSC END

// NEO: AHL - [AutoHardLimit]
#define INI_AHL						L"UseAutoHardLimit"
#define INI_AHL_MIN_SRC				L"MinimalHardLimit"
#define INI_AHL_GLOBAL_SRC			L"GlobalHardLimit"
#define INI_AHL_TIMER				L"AutoHardLimitIntervals"
// NEO: AHL END

// NEO: DR - [DownloadReask]
#define INI_REASK_TIME				L"ReaskIntervals"
#define INI_REASK_NNP_OFF			L"DontAskNoNeedPartSources"
#define INI_REASK_NNP_TIME			L"NoNeedPartReaskIntervals"
#define INI_REASK_FULLQ_OFF			L"DontAskFullQueueSources"
#define INI_REASK_FULLQ_TIME		L"FullQueueReaskIntervals"
// NEO: DR END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
#define INI_NEO_SOURCE_KEEPER		L"UseNeoSourceKeeper"
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
#define INI_NEO_SOURCE_STORAGE		L"UseNeoSourceStorage" 
#define INI_AUTO_SAVE_SOURCES		L"AutoSaveSources" 
#define INI_AUTO_SAVE_SOURCES_INTERVALS	L"AutoSaveSourcesInterval" 
#define INI_SOURCE_STORAGE_LIMIT	L"SourceStorageLimit"
#define INI_AUTO_LOAD_SOURCES		L"AutoLoadStoredSources"
#define INI_USE_STORAGE_BOOTSTRAP	L"UseStorageBootstrap"
#define INI_STORAGE_BOOTSTRAP_TIME	L"StorageBootstrapTime"
#define INI_STORAGE_BOOTSTRAP_REQUIREMENT	L"StorageBootstrapRequirement"
#define INI_STORE_LOW_ID			L"StoreLowIDSources"
#define INI_STORE_A4AF				L"StoreAlsoA4AFSources"
#define INI_STORE_FILE_STATUS		L"StoreSourcesFileStatus"

#define INI_AUTO_REASK_STORED_SOURCES		L"AutoReaskStoredSources"
#define INI_AUTO_REASK_STORED_SOURCES_LIMIT	L"AutoReaskStoredSourcesLimit"
#define INI_TOTAL_SOURCE_RESTORE	L"TotalSourceRestore"
#define INI_USE_AUTO_REASK_STORED_SOURCES_DELAY	L"UseAutoReaskStoredSourcesDelay"
#define INI_AUTO_REASK_STORED_SOURCES_DELAY	L"AutoReaskStoredSourcesDelay"

#define INI_AUTO_REASK_LOADED_SOURCES_DELAY	L"AutoReaskLoadedSourcesDelay"

#define INI_GROUP_STORAGE			L"GroupStoredSourceReask"
#define INI_GROUP_INTERVALS			L"StoredSourceGroupIntervals"
#define INI_GROUP_SIZE				L"StoredSourceGroupSize"

#define INI_USE_SMOOTH_OUTOFDATE	L"UseSmoothOutOfDate"
#define INI_OUTOFDATE_MAXFAILS		L"MaxStoredFaildCount"
#define INI_OUTOFDATE_MAXTIME		L"StoredOutOfDate"
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
#define INI_SOURCE_LIST				L"EnableSourceList"
#define INI_SAVE_GLOBAL_SOURCE_LIST	L"SaveGlobalSourceList"
#define INI_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME L"GlobalSourceListCleanUpTime"
#define INI_GLOBAL_SOURCE_LIST_CLEAN_UP	L"GlobalSourceListCleanUp"
#define INI_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS L"GlobalSourceListCleanUpIntervals"
#define INI_FAST_SOURCE_CLEAN_UP	L"FastSourceCleanUp"
#define INI_SAVE_SOURCE_FILE_LIST	L"SaveSourceFileList"
#define INI_SOURCE_FILE_LIST_CLEAN_UP_TIME L"SourceFileListCleanUpTime"
#define INI_SAVE_SOURCE_DATAS_IN_CLIENTS L"SaveSourceDataInClient"


#define INI_USE_IP_ZONE_CHECK			L"IPZoneCheck"

#define INI_USE_SOURCE_HASH_MONITOR			L"SourceHashMonitor"
#define INI_SOURCE_HASH_MONITOR_BAD_TIME	L"SourceHashMonitorBadTime"
#define INI_SOURCE_HASH_MONITOR_MAX_BAD		L"SourceHashMonitorMaxBad"

#define INI_TABLE_AMOUT_TO_STORE		L"TableAmountToStore"

#define INI_IGNORE_UNREACHABLE_INTERVAL	L"IgnoreUnreachableInterval"
#define INI_IGNORE_UNDEFINED_INTERVAL	L"IgnoreUndefinedInterval"
#define INI_BEGIN_NEW_TABLE_INTERVAL	L"BeginNewTableInterval"
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
#define INI_ENABLE_SOURCE_ANALISER	L"EnableSourceAnalizer"
#define INI_ANALISIS_INTERVALS		L"AnaliseIntervals"
#define INI_TABLE_AMOUT_TO_ANALISE	L"TableAmountToAnalise"

#define INI_DONT_STORE_TEMP_SOURCES	L"DontStoreTemporarySources"

#define INI_PROBABILITY_MODE		L"PriorityMode"
#define	INI_ENHANCED_FACTOR			L"EnhancedFactor"

#define INI_REASK_PROPABILITY		L"ReaskPropability"
#define INI_RESERVE_PROPABILITY		L"ReservePropability"

#define INI_AUTO_RESERVE_REASK		L"AutoReserveReask"
#define INI_RESERVE_REASK_PROPABILITY L"ReserveReaskPropability"
#define INI_USE_RESERVE_REASK_DELAY	L"UseReaskReserveSourcesDelay"
#define INI_RESERVE_REASK_DELAY		L"ReaskReserveSourcesDelay"
#define INI_RESERVE_REASK_LIMIT		L"ReaskReserveSourcesLimit"

#define INI_AUTO_TEMPORARY_REASK		L"AutoTemporaryReask"
#define INI_TEMPORARY_REASK_PROPABILITY L"TemporaryReaskPropability"
#define INI_USE_TEMPORARY_REASK_DELAY	L"UseReaskTemporarySourcesDelay"
#define INI_TEMPORARY_REASK_DELAY		L"ReaskTemporarySourcesDelay"
#define INI_TEMPORARY_REASK_LIMIT		L"ReaskTemporarySourcesLimit"

#define INI_RETRY_UNREAHABLE		L"RetryUnreachable"
#define INI_RETRY_UNREAHABLE_INTERVALS	L"RetryUnreachableIntervals"
#define INI_UNREACHABLE_REASK_PROPABILITY L"UnreachableReaskPropability"
#define INI_UNREACHABLE_REASK_LIMIT	L"ReaskUnreachableSourcesLimit"

//#define INI_MIN_ANALISIS_QUALITY	L"MinAnalisisQuality"

//#define INI_AUTO_UNSURE_REASK		L"AutoUnsureReask"
//#define INI_USE_UNSURE_REASK_DELAY	L"UseReaskUnsureSourcesDelay"
//#define INI_UNSURE_REASK_DELAY		L"ReaskUnsureSourcesDelay"
//#define INI_UNSURE_REASK_LIMIT		L"ReaskUnsureSourcesLimit"

#define INI_USE_UNPREDICTED_PROPABILITY	L"UseUnpredictedPropability"
#define INI_UNPREDICTED_PROPABILITY	L"UnpredictedPropability"
#define INI_USE_UNPREDICTED_REASK_DELAY	L"UseReaskUnpredictedSourcesDelay"
#define INI_UNPREDICTED_REASK_DELAY		L"ReaskUnpredictedSourcesDelay"
#define INI_UNPREDICTED_REASK_LIMIT		L"ReaskUnpredictedSourcesLimit"

#define INI_FAIL_TOLERANCE			L"FailTolerance"
#define INI_MAX_FAIL_TOLERANCE		L"MaxFailTolerance"

#define	INI_HANDLE_TABLE_GAPS		L"HandleTableGaps"
#define INI_PRIORITY_GAP_RATIO		L"PriorityGapRatio"
#define INI_MAX_GAP_SIZE			L"MaxGapSize"
#define INI_MAX_GAP_TIME			L"MaxGapTime"
#define	INI_CHECK_PRIORITY_IP		L"CheckPriorityIP"
#define INI_PRIORITY_IP_RATIO		L"PriorityIPRatio"
#define INI_CHECK_PORT_INTEGRITY	L"CheckPortIntegrity"
#define INI_PORT_INTEGRITY_RATIO 	L"PortIntegrityRatio"
#define INI_MAX_MIDLE_DISCREPANCE_HIGH	L"MaxMidleDiscrepanceHigh"
#define INI_MAX_MIDLE_DISCREPANCE_LOW	L"MaxMidleDiscrepanceLow"
#define INI_LAST_SEEN_DURATION_THRESHOLD	L"LastSeenDurationThreshold"
#define INI_LINK_TIME_PROPABILITY	L"UseLinkTimePropability"
#define INI_LINK_TIME_THRESHOLD		L"LinkTimeThreshold"
#define INI_USE_DUAL_LINKED_TABLE_GRAVITY L"UseDualLinkedTableGravity"
#define INI_DUAL_LINKED_TABLE_GRAVITY L"DualLinkedTableGravity"
#define INI_RELIABLE_TIME_MAGNIFICATION	L"ReliableTimeMagnification"
#define INI_MAX_RELIABLE_TIME		L"MaxReliableTime"
#define INI_TEMPORAL_IP_BORDERLINE	L"TempralIPBorderLine"
#endif // NEO_SA // NEO: NSA END

// NEO: DS - [DropSources]
#define INI_DROP_NNP				L"DropNoNeedPartSources"
#define INI_DROP_NNP_LIMIT			L"DropNoNeedPartSourcesLimit"
#define INI_DROP_NNP_LIMIT_MODE		L"DropNoNeedPartSourcesLimitMode"
#define INI_DROP_NNP_TIMER			L"DropNoNeedPartSourcesIvtervals"
#define INI_DROP_FULLQ				L"DropFullQueueSources"
#define INI_DROP_FULLQ_LIMIT		L"DropFullQueueSourcesLimit"
#define INI_DROP_FULLQ_LIMIT_MODE	L"DropFullQueueSourcesLimitMode"
#define INI_DROP_FULLQ_TIMER		L"DropFullQueueSourcesIvtervals"
#define INI_DROP_HIGHQ				L"DropHighQueueSources"
#define INI_DROP_HIGHQ_VALUE		L"DropHighQueueSourcesValue"
#define INI_DROP_HIGHQ_LIMIT		L"DropHighQueueSourcesLimit"
#define INI_DROP_HIGHQ_LIMIT_MODE	L"DropHighQueueSourcesLimitMode"
#define INI_DROP_HIGHQ_TIMER		L"DropHighQueueSourcesIvtervals"

#define INI_USE_DONT_ASK_THIS_IP	L"UseDontAskThisIP"
#define INI_DONT_ASK_THIS_IP_TIME	L"DontAskThisIPTime"
// NEO: DS END

// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
#define INI_DROP_UNREACHABLE		L"DropUnreachable"
#define INI_DROP_UNREACHABLE_LIMIT	L"DropUnreachableLimit"
#define INI_DROP_UNREACHABLE_LIMIT_MODE	L"DropUnreachableLimitMode"
#define INI_DROP_UNREACHABLE_TIMER	L"DropUnreachableTimer"
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
#define INI_DROP_OUTOFDATE			L"DropOutOfDate"
#define INI_DROP_OUTOFDATESMOOTH	L"DropOutOfDateSmooth"
#define INI_DROP_OUTOFDATE_FAILS	L"DropOutOfDateFails"
#define INI_DROP_OUTOFDATE_TIME		L"DropOutOfDateTime"
#define INI_DROP_OUTOFDATE_LIMIT	L"DropOutOfDateLimit"
#define INI_DROP_OUTOFDATE_LIMIT_MODE	L"DropOutOfDateLimitMode"
#define INI_DROP_OUTOFDATE_TIMER	L"DropOutOfDateTimer"
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
#define INI_DROP_RETIRED			L"DropRetired"
#define INI_DROP_RETIRED_LIMIT		L"DropRetiredLimit"
#define INI_DROP_RETIRED_LIMIT_MODE	L"DropRetiredLimitMode"
#define INI_DROP_RETIRED_TIMER		L"DropRetiredTimer"

#define INI_DROP_LOADED				L"DropLoaded"
#define INI_DROP_LOADED_LIMIT		L"DropLoadedLimit"
#define INI_DROP_LOADED_LIMIT_MODE	L"DropLoadedLimitMode"
#define INI_DROP_LOADED_TIMER		L"DropLoadedTimer"
#endif // NEO_SA // NEO: NSA END
// NEO: NSD END

// NEO: NCAP - [NeoCustomAutoPriority]
#define INI_DYNAMIC_AUTO_DOWN_PRIORITY	L"DynamicAutoDownPriority"
#define INI_DYNAMIC_DOWN_PRIORITY_FACTOR L"DynamicDownPriorityFactor"
#define INI_LOW_DOWN_PRIO_THRESHOLD L"LowDownPrioThreshold"
#define INI_HIGH_DOWN_PRIO_THRESHOLD L"HighDownPrioThreshold"
// NEO: NCAP END

#define INI_MAX_UL_SLOTS			L"MaxUploadSlots"
#define INI_MIN_UL_SLOTS			L"MinUploadSlots"
#define INI_UL_PER_SLOTS			L"MaxUploadPerSlot"

// NEO: QS - [QuickStart] -- Xanatos -->
#define INI_USE_QUICK_START			L"UseQuickStart"
#define INI_QUICK_START_TIME		L"QuickStartTime"
#define INI_QUICK_START_TIME_PF		L"QuickStartTimePerFile"
#define INI_QUICK_START_MAX_CON_PER	L"QuickMaxConperFive"
#define INI_QUICK_START_MAX_HALF_CON L"QuickMaxHalfOpen"
#define INI_QUICK_START_MAX_CON		L"QuickMaxConnections"
// NEO: QS END <-- Xanatos --


// NEO: RIC - [ReaskOnIDChange]
#define INI_CHECK_ID_CHANGE			L"CheckIDChanges"
#define INI_INFORM_ON_ID_CHANGE		L"InformClientsOnIDChange"
#define INI_REASK_ON_ID_CHANGE		L"ReaskSourcesOnIDChange"
#define INI_QUICK_START_ON_ID_CHANGE L"RedoQuickStartOnIDChange" // NEO: QS - [QuickStart]
#define INI_CHECK_L2H_ID_CHANGE		L"CheckLowID2HidhIDChanges"
#define	INI_RECONNECTKAD_ON_ID_CHANGE L"ReconnectKadOnIPChange"
#define INI_REBIND_SOCKETS_ON_IP_CHANGE L"RebindSocketsOnIPChange"
// NEO: RIC END

// NEO: RKF - [RecheckKadFirewalled]
#define	INI_RECHECK_KAD_FIREWALLED	L"RecheckKadFirewalled"
#define	INI_RECHECK_KAD_FIREWALLED_TIME L"RecheckKadFirewalledTime"
// NEO: RKF END

// NEO: RLD - [ReconnectOnLowID]
#define INI_RECONNECT_ON_LOWID		L"ReconnectOnLowId" 
#define INI_RECONNECT_ON_LOWID_TRYS L"ReconnectOnLowIdRetries" 
// NEO: RLD END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
#define INI_LANCAST_ENABLED			L"LancastEnabled"

#define INI_MAX_LAN_DOWNLOAD		L"MaxLanDownload" 
#define INI_DIRECT_LAN_DOWNLOAD		L"DirectLanDownload"
#define INI_SET_LAN_DOWNLOAD_BUFFER	L"SetLanDownloadBuffer"
#define INI_LAN_DOWNLOAD_BUFFER_SIZE L"LanDownloadBufferSize"

#define INI_MAX_LAN_UPLOAD			L"MaxLanUpload" 
#define INI_DIRECT_LAN_UPLOAD		L"DirectLanUpload"
#define INI_SET_LAN_UPLOAD_BUFFER	L"SetLanUploadBuffer"
#define INI_LAN_UPLOAD_BUFFER_SIZE	L"LanUploadBufferSize"

#define INI_MAX_LAN_UPLOAD_SLOTS	L"MaxLanUploadSlots" 

#define INI_CUSTOMIZED_LANCAST		L"CustomizedLanCast"
#define INI_LANCAST_GROUP			L"LanCastGroup"
#define INI_LANCAST_PORT			L"LanCastPort"

#define INI_CUSTOM_LANCAST_ADAPTER	L"CustomLanCastAdapter"
#define INI_LANCAST_ADAPTER_IPADRESS L"LanCastAdapterIPAdress"
#define INI_LANCAST_ADAPTER_SUBNET	L"LanCastAdapterSubNet"

#define INI_LANINTERVALS			L"LANIntervals" 

#define INI_LAN_REASK_INTERVALS		L"LanReaskIntervals" 
#define INI_NNP_LAN_REASK_INTERVALS L"NnPLanReaskIntervals" 

#define INI_AUTO_BROADCAST_LAN_FILES L"AutoBroadcastLanFiles"
#define INI_AUTO_BROADCAST_LAN_FILES_TIMER L"AutoBroadcastLanFilesTimer" 

#define INI_USE_LAN_MULTI_TRANSFER	L"UseLanMultiTransfer"
#endif //LANCAST // NEO: NLC END

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
#define INI_USE_VOODOO_TRANSFER		L"UseVoodooTransfer"
#define INI_SLAVE_ALLOWED			L"SlaveAllowed"
#define INI_SLAVE_HOSTING			L"SlaveHosting"

#define INI_VOODOO_SPELL			L"VoodooSpell"
#define INI_VOODOO_PORT				L"VoodooPort" 

#define INI_AUTO_CONNECT_VOODOO		L"AutoConnectVoodoo"

#define INI_USE_VIRTUAL_VOODOO_FILES L"UseVirtualVoodooFiles"
#define INI_HIDE_VOODOO_FILES		L"HideVoodooFiles"

#define INI_USE_VOODOO_SOURCE_EXCHANGE L"UseVoodooSourceExchange"

#define INI_USE_VOODOO_SEARCH		L"UseVoodooSearch"

#define INI_VOODOO_NEO_COMMANDS		L"VoodooNeoCommands"
#define INI_VOODOO_NEO_PREFERENCES	L"VoodooNeoPreferences"

#define INI_VOODOOCAST_ENABLED		L"VoodooCastEnabled"

#define INI_SEARCH_FOR_SLAVES		L"SearchForSlaves" 
#define INI_SEARCH_FOR_MASTER		L"SearchForMaster" 
#define INI_VOODOO_SEARCH_INTERVALS L"VoodooSearchIntervals" 
#endif // VOODOO // NEO: VOODOO END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
#define INI_SHOW_CAT_NAME			L"ShowCatNames"
#define INI_SHOW_CAT_FLAGS			L"ShowCatFlags"
#define INI_ACTIVE_CAT_DEFAULT		L"ActiveCatDefault"
#define INI_SEL_CAT_ON_ADD			L"SelCatOnAdd"
#define INI_AUTO_SET_RESUME_ORDER	L"AutoSetResumeOrder"
#define INI_SMALL_FILE_DL_PUSH		L"SmallFileDLPush"
#define INI_SMALL_FILE_DL_PUSH_VAL	L"SmallFileDLPushSize"
#define INI_START_DL_IN_EMPTY_CATS	L"StartDLInEmptyCats"
#define INI_START_DL_IN_EMPTY_CATS_AMOUNT L"StartDLInEmptyCatsAmount"
#define INI_USE_AUTO_CAT			L"UseAutoCat"
#define	INI_CHECK_ALREADY_DOWNLOADED L"CheckAlreadyDownloaded"

#define	INI_START_NEXT_FILE_BY_PRIORITY L"bStartNextFileByPriority"

#define INI_SMART_A4AF_SWAPPING		L"SmartA4AFSwapping"
#define INI_ADVANCED_A4AF_MODE		L"AdvancedA4AFMode"
#endif // A4AF_CATS // NEO: MAC END

#define INI_USE_LUGDUNUM_CREDITS	L"UseLugdunumCredits" // NEO: KLC - [KhaosLugdunumCredits]
#define INI_PREFER_SHARE_ALL		L"PreferShareAll" // NEO: PSA - [PreferShareAll]
// NEO: ASF - [AdvancedServerFilter]
#define INI_DONT_REMOVE_STATIC_SERVERS	L"DontRemoveStaticServers"
#define INI_SERVER_FILTER_AUTO_DEL	L"ServerFilterAutoDel"
#define INI_SERVER_FILTER			L"ServerFilter"
#define INI_SERVER_FILTER_VAL		L"ServerFilterVal"
#define INI_SERVER_FILTER_DATALESS	L"ServerFilterDataless"
// NEO: ASF END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
#define INI_IP2COUNTRY_NAME_MODE	L"IP2CountryNameMode"
#define INI_IP2COUNTRY_SHOW_FLAG	L"IP2CountryShowFlag"
#endif // IP2COUNTRY // NEO: IP2C END

#define INI_USE_FAKE_CHECK			L"UseFakeCheck" // NEO: FC - [FakeCheck]

// NEO: FDC - [FileNameDisparityCheck]
#define INI_USE_FILE_CHECK			L"UseFileCheck"
#define INI_FILE_CHECK_SENSITIVITY	L"FileCheckSensitivity"
#define	INI_USE_FILE_CHECK_THRESHOLD L"UseFileCheckThreshold"
#define INI_FILE_CHECK_THRESHOLD	L"FileCheckThreshold"
#define INI_FILE_CHECK_AMOUNT		L"FileCheckAmount"
// NEO: FDC END

// NEO: FN - [FunnyNick]
#define INI_USE_FUNNY_NICK			L"UseFunnyNick"
#define INI_FUNNY_NICK_FILTER		L"FunnyNickFilter"
#define INI_FUNNY_NICK_SYMBOL		L"FunnyNickSymbol"
// NEO: FN END

// NEO: AU - [AutoUpdate]
#define INI_AUTO_RUNTIME_UPDATE		L"AutoRuntimeUpdate"
#define INI_RUNTIME_UPDATE_INTERVALS L"RuntimeUpdateIntervals"

#define INI_UPDATE_URL_IP_FILTER	L"UpdateURLIPFilter"
#define INI_AUTO_UPDATE_IP_FILTER	L"AutoUpdateIPFilter"
#define INI_IP_FILTER_VERSION		L"IPFilterVersion"

#ifdef ARGOS // NEO: NA - [NeoArgos]
#define INI_UPDATE_URL_LEECHERS_LIST L"UpdateURLLeechersList"
#define INI_UPDATE_LEECHERS_STARTUP	L"UpdateLeechersStartup"
#define INI_LEECHERS_VERSION		L"LeechersVersion"
#endif // ARGOS // NEO: NA END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
#define INI_UPDATE_URL_IP2_COUNTRY	L"UpdateURLIP2Country"
#define INI_AUTO_UPDATE_IP2_COUNTRY L"AutoUpdateIP2Country"
#define INI_IP2_COUNTRY_VERSION		L"IP2CountryVersion"
#endif // IP2COUNTRY // NEO: IP2C END

// NEO: FC - [FakeCheck]
#define INI_UPDATE_URL_FAKE_LIST	L"UpdateURLFakeList"
#define INI_UPDATE_FAKE_STARTUP		L"UpdateFakeStartup"
#define INI_FAKES_VERSION			L"FakesVersion"
// NEO: FC END
// NEO: AU END

// NEO: IFWS - [ICSFirewall]
#define INI_ICF_SUPPORT				L"ICFSupport"
#define INI_ICF_CLEAR_ON_CLOSE		L"ICFClearOnClose"
// NEO: IFWS END

// NEO: UPNP - [UPnPNat]
#define INI_UPNP_NAT				L"UPnPNAT"
#define INI_UPNP_CLEAR_ON_CLOSE		L"UPnPClearOnClose"
#define INI_UPNP_TRY_RANDOM			L"UPnPTryRandom"
// NEO: UPNP END

// NEO: NATS - [NatSupport]
#define INI_NAT_SUPPORT_ENABLED			L"NATSupportEnabled"
#define INI_NAT_PORT_REFRESH_IVTERVAL	L"NATPortRefreshIvterval"
#define INI_NAT_PORT_MAX_LATENCY_TIME	L"NATPortMaxLatencyTime"
#define INI_NAT_PORT_MAX_FAILS			L"NATPortMaxFails"
#define INI_NAT_PORT_FAST_REFRESH		L"NATPortFastRefresh"

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
#define INI_NAT_PORT_RELAIABLE			L"NATPortRelaiable"
#define INI_NAT_TRAVERSAL_ENABLED		L"NATTraversalEnabled"
#define INI_DONT_TRUST_NAT_PORTS		L"DontTrustNatPorts"
#define INI_NAT_TYPE					L"NatCharacteristic"
#define	INI_LOWID_UPLAOD_CALLBACK		L"LowIDUplaodCallBack" // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
#define	INI_RE_USE_TCP_PORT				L"ReUseTCPPort"
// NEO: NATS END

#ifdef WEBCACHE // NEO: WC - [WebCache]
#define INI_WEBCACHE_NAME L"webcacheName"
#define INI_WEBCACHE_PORT L"webcachePort"
#define INI_WEBCACHE_BLOCK_LIMIT L"webcacheBlockLimit"	
#define INI_WEBCACHE_EXTRA_TIMEOUT L"webcacheExtraTimeout"	
#define INI_PERSISTENT_CONNECTIONS_FOR_PROXY_DOWNLOADS L"PersistentConnectionsForProxyDownloads"
#define INI_WCAUTO_UPDATE L"WCAutoupdate"
#define INI_WEBCACHE_CACHESLOCAL_TRAFFIC L"webcacheCachesLocalTraffic"
#define INI_WEBCACHE_ENABLED L"webcacheEnabled" //webcache disabled on first start so webcache detection on start gets called.
#define INI_WEBCACHE_LIMITLES L"webcacheLimitles"
#define INI_DETECT_WEBCACHE_ON_START L"detectWebcacheOnStart" // jp detect webcache on startup
#define INI_WEBCACHE_LAST_SEARCH L"webcacheLastSearch"
#define INI_WEBCACHE_LAST_GLOBAL_IP L"webcacheLastGlobalIP"
#define INI_WEBCACHE_LAST_RESOLVED_NAME L"webcacheLastResolvedName"
#define INI_WEBCACHE_TRUST_LEVEL L"webcacheTrustLevel"
#define INI_LOG_WEB_CACHE_EVENTS L"LogWebCacheEvents"
#define INI_WEB_CACHE_SHOW L"WebCacheShow"
#endif // NEO: WC END

// NEO: NCFG END <-- Xanatos --