//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "resource.h"
#include "emule.h"
#include "emuledlg.h"
#include "preferences.h"
#include "otherfunctions.h"
#include "NeoToolbarCtrl.h"
#include "chatwnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// NEO: CTB - [CoolToolBar] -- Xanatos -->

/////////////////////////////////////////////////////////////////////////////
// CNeoToolbarCtrl
CNeoToolbarCtrl::CNeoToolbarCtrl()
: m_strClassName(MTC_CLASSNAME),
m_bUseSpeedMeter(TRUE),
m_bCreated(FALSE)
{
	RegisterWndClass();
}

/////////////////////////////////////////////////////////////////////////////

CNeoToolbarCtrl::~CNeoToolbarCtrl()
{
}

/////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CNeoToolbarCtrl, CWnd)
	//{{AFX_MSG_MAP(CNeoToolbarCtrl)
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOLORCHANGE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNeoToolbarCtrl message handlers
/////////////////////////////////////////////////////////////////////////////

BOOL CNeoToolbarCtrl::Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID) 
{
	BOOL bResult = CWnd::Create(MTC_CLASSNAME, _T(""), dwStyle, rect, pParentWnd, nID, NULL);

	RECT srect = {25,25,50,50};
	m_co_UpTrafficGraph.CreateEx(NULL, NULL ,NULL, WS_CHILD | WS_VISIBLE, srect, this, 1234, NULL);
	m_co_DownTrafficGraph.CreateEx(NULL, NULL ,NULL, WS_CHILD | WS_VISIBLE, srect, this, 1235, NULL);
	SetSpeedMeterRange(thePrefs.GetMaxGraphUploadRate(true),thePrefs.GetMaxGraphDownloadRate());

	CreateButtons();

	m_bCreated = TRUE;

	return bResult;
}

void CNeoToolbarCtrl::CreateButtons()
{
	// of no toolbar is configured reset the default one
	if(thePrefs.GetCoolToolbarButtonCount() == 0)
	{
		thePrefs.m_iCoolToolbarButtonCount = 12;
		thePrefs.m_CoolToolbarButtons.SetSize(thePrefs.m_iCoolToolbarButtonCount);

		// large buttons
		thePrefs.m_CoolToolbarButtons[0] = 0;
		thePrefs.m_CoolToolbarButtons[1] = 1;
		thePrefs.m_CoolToolbarButtons[2] = 2;
		thePrefs.m_CoolToolbarButtons[3] = 3;
		thePrefs.m_CoolToolbarButtons[4] = 4;
		thePrefs.m_CoolToolbarButtons[5] = 5;

		// add a space
		thePrefs.m_CoolToolbarButtons[6] = ((34/*+5*/) << 8);

		// small buttons
		thePrefs.m_CoolToolbarButtons[7] = 6;
		thePrefs.m_CoolToolbarButtons[8] = 8;
		thePrefs.m_CoolToolbarButtons[9] = 9;
		thePrefs.m_CoolToolbarButtons[10] = 10;

		// spearator to the speed meter
		thePrefs.m_CoolToolbarButtons[11] = ((34/*+5*/) << 8);
	}

	for(int i=0; i<m_co_Buttons.GetSize(); i++)
		m_co_Buttons[i].DestroyWindow();
	m_co_Buttons.RemoveAll();

	m_co_Buttons.SetSize(thePrefs.GetCoolToolbarButtonCount());
	for(int i=0; i<m_co_Buttons.GetSize(); i++){
		int btn = thePrefs.GetCoolToolbarButton(i);
		if(uint8 separator = (uint8)((btn >> 8)))
		{
			m_co_Buttons[i].Create(_T(""),WS_CHILD,CRect(25,25,52,52),this,IDC_TOOLBARBUTTON + 20 + i);
			m_co_Buttons[i].m_Width = separator;
		}	
		else
		{
			m_co_Buttons[i].Create(_T(""),WS_VISIBLE | WS_CHILD | BS_PUSHBUTTON,CRect(25,25,52,52),this,IDC_TOOLBARBUTTON + (uint8)btn);
		}
	}

	UpdateSkin();
}

void CNeoToolbarCtrl::UpdateSkin()
{
	m_co_ToolLeft.DeleteObject();
	m_co_ToolLeft.Attach(theApp.LoadImage(_T("TOOLBAR_LEFT"),_T("JPG")));
	m_co_ToolMid.DeleteObject();
	m_co_ToolMid.Attach(theApp.LoadImage(_T("TOOLBAR_CENTER"),_T("JPG")));
	m_co_ToolRight.DeleteObject();
	m_co_ToolRight.Attach(theApp.LoadImage(_T("TOOLBAR_RIGHT"),_T("JPG")));

	CFont* font = theApp.emuledlg->GetFont();
	COLORREF color = RGB(255, 255, 255); // white text color
	theApp.LoadSkinColorAlt(_T("ToolbarLvBk"), _T("CoolbarLvBk"), color);

	RECT rect;
	GetClientRect(&rect);

	int left = 10;

	for(int i=0; i<m_co_Buttons.GetSize(); i++){
		switch(m_co_Buttons[i].GetDlgCtrlID())
		{
		case TBBTN_CONNECT: m_co_Buttons[i].SetSkin(_T("CONNECT_NORMAL"),_T("CONNECT_CLICK"),_T("CONNECT_OVER"),_T("CONNECT_CLICK"),0,0,0,0,0); break;
		case TBBTN_KAD: m_co_Buttons[i].SetSkin(_T("KADEMLIA_NORMAL"),_T("KADEMLIA_CLICK"),_T("KADEMLIA_OVER"),_T("KADEMLIA_CLICK"),0,0,0,0,0); break;
		case TBBTN_SERVER: m_co_Buttons[i].SetSkin(_T("SERVER_NORMAL"),_T("SERVER_CLICK"),_T("SERVER_OVER"),_T("SERVER_CLICK"),0,0,0,0,0); break;
		case TBBTN_TRANSFERS: m_co_Buttons[i].SetSkin(_T("TRANSFER_NORMAL"),_T("TRANSFER_CLICK"),_T("TRANSFER_OVER"),_T("TRANSFER_CLICK"),0,0,0,0,0); break;
		case TBBTN_SEARCH: m_co_Buttons[i].SetSkin(_T("SEARCH_NORMAL"),_T("SEARCH_CLICK"),_T("SEARCH_OVER"),_T("SEARCH_CLICK"),0,0,0,0,0); break;
		case TBBTN_SHARED: m_co_Buttons[i].SetSkin(_T("SHARED_NORMAL"),_T("SHARED_CLICK"),_T("SHARED_OVER"),_T("SHARED_CLICK"),0,0,0,0,0); break;
		case TBBTN_MESSAGES: m_co_Buttons[i].SetSkin(_T("MESSAGES_NORMAL"),_T("MESSAGES_CLICK"),_T("MESSAGES_OVER"),_T("MESSAGES_CLICK"),0,0,0,0,0); break;
		case TBBTN_IRC: m_co_Buttons[i].SetSkin(_T("IRC_NORMAL"),_T("IRC_CLICK"),_T("IRC_OVER"),_T("IRC_CLICK"),0,0,0,0,0); break;
		case TBBTN_STATS: m_co_Buttons[i].SetSkin(_T("STATISTIC_NORMAL"),_T("STATISTIC_CLICK"),_T("STATISTIC_OVER"),_T("STATISTIC_CLICK"),0,0,0,0,0); break;
		case TBBTN_OPTIONS: m_co_Buttons[i].SetSkin(_T("PREFERENCES_NORMAL"),_T("PREFERENCES_CLICK"),_T("PREFERENCES_OVER"),_T("PREFERENCES_CLICK"),0,0,0,0,0); break;
		case TBBTN_TOOLS: m_co_Buttons[i].SetSkin(_T("TOOLS_NORMAL"),_T("TOOLS_CLICK"),_T("TOOLS_OVER"),_T("TOOLS_CLICK"),0,0,0,0,0); break;
		case TBBTN_HELP: m_co_Buttons[i].SetSkin(_T("HELP_NORMAL"),_T("HELP_CLICK"),_T("HELP_OVER"),_T("HELP_CLICK"),0,0,0,0,0); break;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		case TBBTN_VOODOO: m_co_Buttons[i].SetSkin(_T("VOODOO_NORMAL"),_T("VOODOO_CLICK"),_T("VOODOO_OVER"),_T("VOODOO_CLICK"),0,0,0,0,0); break;
#endif // VOODOO // NEO: VOODOO END
		}

		// adapt the button size to the skin size
		int Width = m_co_Buttons[i].m_Width;
		int High = m_co_Buttons[i].m_High;
		int top = rect.bottom - High;
		m_co_Buttons[i].SetWindowPos(NULL,left,top,Width,High,SWP_NOZORDER);
		RECT trect = {0,49-top,Width,64-top};
		m_co_Buttons[i].Set_TextPos(trect);
		left += Width;

		m_co_Buttons[i].SetFont(font);
		m_co_Buttons[i].SetTextColor(color);
	}
	m_uMinSize = left;

	// speedmeter section
	BITMAP bmpInfo;
	m_co_ToolRight.GetBitmap(&bmpInfo);
	int width = bmpInfo.bmWidth-48;

	// speed graph
	RECT rect1,rect2;

	// set updateintervall of graphic rate display (in seconds)
	rect1.left = rect.right-width-8;
	rect1.top = rect.top+9;
	rect1.right = rect1.left+width;
	rect1.bottom = rect1.top+26;

	rect2.left = rect.right-width-8;
	rect2.top = rect.top+36;
	rect2.right = rect2.left+width;
	rect2.bottom = rect2.top+26;

	m_co_UpTrafficGraph.SetWindowPos(NULL,rect1.left,rect1.top,rect1.right-rect1.left,rect1.bottom-rect1.top,SWP_NOZORDER);
	m_co_DownTrafficGraph.SetWindowPos(NULL,rect2.left,rect2.top,rect2.right-rect2.left,rect2.bottom-rect2.top,SWP_NOZORDER);

	m_co_UpTrafficGraph.Init();
	m_co_DownTrafficGraph.Init();

	UpdateMeterColor();
	UpdateSize(rect.right);

	if(m_bCreated)
		RedrawWindow();
}

void CNeoToolbarCtrl::UpdateMeterColor()
{
	m_co_UpTrafficGraph.Init_Color(thePrefs.GetStatsColor(37),thePrefs.GetStatsColor(36),thePrefs.GetStatsColor(38),thePrefs.GetStatsColor(39),thePrefs.GetStatsColor(40));
	m_co_DownTrafficGraph.Init_Color(thePrefs.GetStatsColor(35),thePrefs.GetStatsColor(34),thePrefs.GetStatsColor(38),thePrefs.GetStatsColor(39),thePrefs.GetStatsColor(40));
}

void CNeoToolbarCtrl::UpdateSize(int width)
{
	if(width == 0){
		CRect rect;
		GetClientRect(&rect);
		width = rect.right;
	}

	CRect rc;
	m_co_UpTrafficGraph.GetWindowRect(&rc);
	ScreenToClient(&rc); 

	// speed meter
	int Shift = 0;
	if(width >= m_uMinSize+(rc.right-rc.left)+14)
	{
		Shift = (rc.right-rc.left)+14;
		
		if(m_bUseSpeedMeter == 2){
			m_bUseSpeedMeter = 1;
			ShowSpeedMeter(true);
		}

		m_co_UpTrafficGraph.SetWindowPos(NULL,width-(rc.right-rc.left)-7,9,0,0,SWP_NOZORDER | SWP_NOSIZE);
		m_co_DownTrafficGraph.SetWindowPos(NULL,width-(rc.right-rc.left)-7,36,0,0,SWP_NOZORDER | SWP_NOSIZE);
	}
	else if(m_bUseSpeedMeter == 1){
		ShowSpeedMeter(false);
		m_bUseSpeedMeter = 2;
	}

	// buttons on right
	int rightBtn = 0;
	int right = width-Shift;
	if(m_co_Buttons.GetSize() >= thePrefs.GetCoolToolbarRight())
	{
		rightBtn = m_co_Buttons.GetSize() - thePrefs.GetCoolToolbarRight();
		for(int i=m_co_Buttons.GetSize()-1; i>=rightBtn; i--)
		{
			m_co_Buttons[i].GetWindowRect(&rc);
			ScreenToClient(&rc); 
			m_co_Buttons[i].SetWindowPos(NULL,right - (rc.right-rc.left),rc.top,0,0,SWP_NOZORDER | SWP_NOSIZE);
			right -= rc.right-rc.left;
		}
	}

	// buttons in center
	int centerBtn = 0;
	if(rightBtn >= thePrefs.GetCoolToolbarCenter())
	{
		centerBtn = rightBtn - thePrefs.GetCoolToolbarCenter();
		
		int left = 10;
		if(centerBtn){
			m_co_Buttons[centerBtn-1].GetWindowRect(&rc);
			ScreenToClient(&rc); 
			left = rc.right;
		}

		int center = left + ((right-left) - (rc.right - rc.left)*thePrefs.GetCoolToolbarCenter())/2;
		for(int i=centerBtn; i<=rightBtn-1; i++)
		{
			m_co_Buttons[i].GetWindowRect(&rc);
			ScreenToClient(&rc); 
			m_co_Buttons[i].SetWindowPos(NULL,center,rc.top,0,0,SWP_NOZORDER | SWP_NOSIZE);
			center += rc.right-rc.left;
		}
	}

	int left = 10;
	for(int i=0; i<m_co_Buttons.GetSize()-thePrefs.GetCoolToolbarCenter()-thePrefs.GetCoolToolbarRight(); i++){
		m_co_Buttons[i].GetWindowRect(&rc);
		ScreenToClient(&rc); 
		m_co_Buttons[i].SetWindowPos(NULL,left,rc.top,0,0,SWP_NOZORDER | SWP_NOSIZE);
		left += rc.right-rc.left;
	}
}

BOOL CNeoToolbarCtrl::OnEraseBkgnd(CDC* pDC) 
{
	RECT rect;
	GetClientRect(&rect);

	BITMAP bmpInfo;
	CDC dcMemory1,dcMemory2,dcMemory3;

	m_co_ToolLeft.GetBitmap(&bmpInfo);
	dcMemory1.CreateCompatibleDC(pDC);
	CBitmap* pOldBitmap1 = dcMemory1.SelectObject(&m_co_ToolLeft);
	pDC->BitBlt(0,0, bmpInfo.bmWidth, bmpInfo.bmHeight, &dcMemory1, 0, 0, SRCCOPY);
	dcMemory1.SelectObject(pOldBitmap1);

	int left = bmpInfo.bmWidth;
	int right = rect.right;

	if(IsSpeedMeterEnabled()){
		m_co_ToolRight.GetBitmap(&bmpInfo);
		dcMemory2.CreateCompatibleDC(pDC);
		CBitmap* pOldBitmap2 = dcMemory2.SelectObject(&m_co_ToolRight);
		pDC->BitBlt((rect.right-rect.left)-bmpInfo.bmWidth,0, bmpInfo.bmWidth, bmpInfo.bmHeight, &dcMemory2, 0, 0, SRCCOPY);
		dcMemory2.SelectObject(pOldBitmap2);
		right -= bmpInfo.bmWidth;
	}

	m_co_ToolMid.GetBitmap(&bmpInfo);
	dcMemory3.CreateCompatibleDC(pDC);
	CBitmap* pOldBitmap3 = dcMemory3.SelectObject(&m_co_ToolMid);
	if(bmpInfo.bmWidth > 1){ // if the image have 2 dimensions replicate
		while(left < right){
			pDC->BitBlt(left,0, min(bmpInfo.bmWidth,right-left), bmpInfo.bmHeight, &dcMemory3, 0, 0, SRCCOPY);
			left += bmpInfo.bmWidth;
		}
	}else
		pDC->StretchBlt(left,0, right-left, bmpInfo.bmHeight, &dcMemory3,0,0, bmpInfo.bmWidth, bmpInfo.bmHeight ,SRCCOPY);
	dcMemory3.SelectObject(pOldBitmap3);

	return FALSE;
}

void CNeoToolbarCtrl::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType,cx,cy);

	if(m_bCreated)
		UpdateSize(cx);
}

BOOL CNeoToolbarCtrl::OnCommand(WPARAM wParam, LPARAM lParam)
{
	PressMuleButton(wParam);

	theApp.emuledlg->OnCommand(wParam,lParam);

	return TRUE;
}

BOOL CNeoToolbarCtrl::SetButtonInfo(int nID, TBBUTTONINFO* ptbbi)
{
	if(thePrefs.UseCoolToolbarText() == TRUE)
		SetDlgItemText(nID,ptbbi->pszText);

	for(int i=0; i<m_co_Buttons.GetSize(); i++)
	{
		if(m_co_Buttons[i].GetDlgCtrlID() != nID)
			continue;

		switch(ptbbi->iImage)
		{
		case 0: m_co_Buttons[i].SetSkin(_T("CONNECT_NORMAL"),_T("CONNECT_CLICK"),_T("CONNECT_OVER"),_T("IDB_CONNECT_CLICK"),0,0,0,0,0); break;
		case 1: m_co_Buttons[i].SetSkin(_T("CONNECT_CLICK"),_T("CONNECT_CLICK"),_T("DISCONNECT_OVER"),_T("CONNECT_CLICK"),0,0,0,0,0); break;
		case 2: m_co_Buttons[i].SetSkin(_T("CONNECT_CLICK"),_T("CONNECT_CLICK"),_T("DISCONNECT_OVER"),_T("CONNECT_CLICK"),0,0,0,0,0); break;
		}
		m_co_Buttons[i].RedrawWindow();

		return TRUE;
	}

	return FALSE;
}

void CNeoToolbarCtrl::PressMuleButton(int nID)
{
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	if(nID != TBBTN_CONNECT && nID != TBBTN_TOOLS && nID != TBBTN_OPTIONS && nID != TBBTN_HELP && nID != TBBTN_VOODOO)
#else
	if(nID != TBBTN_CONNECT && nID != TBBTN_TOOLS && nID != TBBTN_OPTIONS && nID != TBBTN_HELP)
#endif // VOODOO // NEO: VOODOO END
	{
		for(int i=0; i<m_co_Buttons.GetSize(); i++)
			m_co_Buttons[i].EnableWindow(m_co_Buttons[i].GetDlgCtrlID() != nID);
	}
}

void CNeoToolbarCtrl::OnContextMenu(CWnd* /*pWnd*/, CPoint /*point*/)
{
	theApp.emuledlg->ShowToolPopup(false);
}

void CNeoToolbarCtrl::Localize(void)
{
	m_MapAccelerator.RemoveAll();
	for(int i=0; i<m_co_Buttons.GetSize(); i++){
		LPCTSTR empty = (thePrefs.UseCoolToolbarText() != TRUE) ? _T("") : NULL;
		switch(m_co_Buttons[i].GetDlgCtrlID())
		{
		case TBBTN_CONNECT: 
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_MAIN_BTN_CONNECT)); 
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_MAIN_BTN_CONNECT));
			SetAccelerator(GetResString(IDS_MAIN_BTN_CONNECT),TBBTN_CONNECT);
			break;
		case TBBTN_KAD: 
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_EM_KADEMLIA));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_EM_KADEMLIA));
			SetAccelerator(GetResString(IDS_EM_KADEMLIA),TBBTN_KAD);
			break;
		case TBBTN_SERVER: 
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_EM_SERVER));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_EM_SERVER));
			SetAccelerator(GetResString(IDS_EM_SERVER),TBBTN_SERVER);
			break;
		case TBBTN_TRANSFERS:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_EM_TRANS));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_EM_TRANS));
			SetAccelerator(GetResString(IDS_EM_TRANS),TBBTN_TRANSFERS);
			break;
		case TBBTN_SEARCH:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_EM_SEARCH));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_EM_SEARCH));
			SetAccelerator(GetResString(IDS_EM_SEARCH),TBBTN_SEARCH);
			break;
		case TBBTN_SHARED:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_X_EM_SHARE));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_X_EM_SHARE));
			SetAccelerator(GetResString(IDS_X_EM_SHARE),TBBTN_SHARED);
			break;
		case TBBTN_MESSAGES:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_EM_MESSAGES));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_EM_MESSAGES));
			SetAccelerator(GetResString(IDS_EM_MESSAGES),TBBTN_MESSAGES);
			break;
		case TBBTN_IRC:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_IRC));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_IRC));
			SetAccelerator(GetResString(IDS_IRC),TBBTN_IRC);
			break;
		case TBBTN_STATS:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_EM_STATISTIC));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_EM_STATISTIC));
			SetAccelerator(GetResString(IDS_EM_STATISTIC),TBBTN_STATS);
			break;
		case TBBTN_OPTIONS:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_EM_PREFS));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_EM_PREFS));
			SetAccelerator(GetResString(IDS_EM_PREFS),TBBTN_OPTIONS);
			break;
		case TBBTN_TOOLS:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_TOOLS));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_TOOLS));
			SetAccelerator(GetResString(IDS_TOOLS),TBBTN_TOOLS);
			break;
		case TBBTN_HELP:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_EM_HELP));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_EM_HELP));
			SetAccelerator(GetResString(IDS_EM_HELP),TBBTN_HELP);
			break;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		case TBBTN_VOODOO:
			m_co_Buttons[i].SetWindowText(empty ? empty : GetResString(IDS_X_EM_VOODOO));
			m_co_Buttons[i].SetToolTipText(GetResString(IDS_X_EM_VOODOO));
			SetAccelerator(GetResString(IDS_X_EM_VOODOO),TBBTN_VOODOO);
			break;
#endif // VOODOO // NEO: VOODOO END
		}

	}
}

void CNeoToolbarCtrl::SetAccelerator(CString buff, UINT pIDBtn)
{
	int pos = buff.Find(_T('&'));
	if(pos != -1){
		TCHAR buff1 = buff.Mid(pos+1).MakeLower().GetAt(0);
		TCHAR buff2 = buff.Mid(pos+1).MakeUpper().GetAt(0);
		m_MapAccelerator.SetAt(buff1,pIDBtn);
		m_MapAccelerator.SetAt(buff2,pIDBtn);
	}
}

BOOL CNeoToolbarCtrl::MapAccelerator(TCHAR chAccel, UINT* pIDBtn)
{
	return m_MapAccelerator.Lookup(chAccel,*pIDBtn);
}

UINT CNeoToolbarCtrl::CommandToIndex(UINT nID) const 
{
	for(int i=0; i<m_co_Buttons.GetSize(); i++)
		if(m_co_Buttons[i].GetDlgCtrlID() == (int)nID)
			return i;
	return 0;
}

BOOL CNeoToolbarCtrl::GetButton(int nIndex, LPTBBUTTON lpButton) const 
{
	if(nIndex >= m_co_Buttons.GetSize())
		return FALSE;
	lpButton->idCommand = m_co_Buttons[nIndex].GetDlgCtrlID();
	return TRUE;
}

void CNeoToolbarCtrl::OnSysColorChange()
{
	CWnd::OnSysColorChange();
	UpdateSkin();
}

// NEO: CTB END <-- Xanatos --