#include "stdafx.h"
#include <share.h>
#include "emule.h"
#include "otherfunctions.h"
#include "Preferences.h"
#include "Funnynick.h"
#include "ClientList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DFLT_FUNNYNICK_FILENAME	_T("funnynick.dat")

CFunnynick::CFunnynick()
{
	ReloadDatabase();
}

CString* CFunnynick::GetFunnynick(const uchar* pUserHash, CString strUsername)
{
	if(!strUsername.IsEmpty())
	{
		CString strFilter = thePrefs.GetFunnyNickFilter();
		int pos = 0;
		for(CString strToken = strFilter.Tokenize(_T("|"), pos);!strToken.IsEmpty();strToken = strFilter.Tokenize(_T("|"), pos))
		{
			if(strUsername.Left(strToken.GetLength()) == strToken)
				return GenerateFunnynick(pUserHash);
		}
	}
	
	return NULL;
}

CString* CFunnynick::GenerateFunnynick(const uchar* pUserHash)
{
	uint32	x=0x7d726d62; // < xrmb :)
	uint8	a = pUserHash[5]  ^ pUserHash[7]  ^ pUserHash[15] ^ pUserHash[4];
	uint8	b = pUserHash[11] ^ pUserHash[9]  ^ pUserHash[12] ^ pUserHash[1];
	uint8	c = pUserHash[3]  ^ pUserHash[14] ^ pUserHash[6]  ^ pUserHash[13];
	uint8	d = pUserHash[2]  ^ pUserHash[0]  ^ pUserHash[10] ^ pUserHash[8];
	uint32	e = (a<<24) + (b<<16) + (c<<8) + d;
	srand(e^x);

	CString* strFunnynick = new CString;
	*strFunnynick = thePrefs.GetFunnyNickSymbol();
	if(!m_aFunnynickPrefix.IsEmpty())
		*strFunnynick += m_aFunnynickPrefix.GetAt(rand()%m_aFunnynickPrefix.GetSize());
	if(!m_aFunnynickSuffix.IsEmpty())
		*strFunnynick += m_aFunnynickSuffix.GetAt(rand()%m_aFunnynickSuffix.GetSize());

	//--- make the rand random again ---
	srand((unsigned)time(NULL));

	return strFunnynick;
}

void CFunnynick::ReloadDatabase()
{
	bool bPrefixLoaded = false;
	bool bLoadSuffix = false;
	m_aFunnynickPrefix.RemoveAll();
	m_aFunnynickSuffix.RemoveAll();

	FILE* readFile = _tfsopen(thePrefs.GetConfigDir() + DFLT_FUNNYNICK_FILENAME, _T("r"), _SH_DENYWR);
	if(readFile != NULL)
	{
		CString strBuffer;
		while(!feof(readFile))
		{
			TCHAR buffer[256];
			if(_fgetts(buffer, ARRSIZE(buffer), readFile) == NULL)
				break;
			strBuffer = buffer;
			strBuffer.Remove(_T('\n'));

			// ignore comments
			if(strBuffer.GetAt(0) == _T('#') || strBuffer.GetAt(0) == _T('/'))
				continue;

			if(strBuffer.IsEmpty())
			{
				if(bPrefixLoaded)
					bLoadSuffix = true;
				
				continue;
			}

			strBuffer.Replace(_T('_'), _T(' '));

			if(bLoadSuffix)
				m_aFunnynickSuffix.Add(strBuffer);
			else
			{
				m_aFunnynickPrefix.Add(strBuffer);
				bPrefixLoaded = true;
			}
		}
		fclose(readFile);
	}
	else
	{
		m_aFunnynickPrefix.Add(_T("ATX-"));
		m_aFunnynickPrefix.Add(_T("Gameboy "));
		m_aFunnynickPrefix.Add(_T("PS/2-"));
		m_aFunnynickPrefix.Add(_T("USB-"));
		m_aFunnynickPrefix.Add(_T("Angry "));
		m_aFunnynickPrefix.Add(_T("Atrocious "));
		m_aFunnynickPrefix.Add(_T("Attractive "));
		m_aFunnynickPrefix.Add(_T("Bad "));
		m_aFunnynickPrefix.Add(_T("Barbarious "));
		m_aFunnynickPrefix.Add(_T("Beautiful "));
		m_aFunnynickPrefix.Add(_T("Black "));
		m_aFunnynickPrefix.Add(_T("Blond "));
		m_aFunnynickPrefix.Add(_T("Blue "));
		m_aFunnynickPrefix.Add(_T("Bright "));
		m_aFunnynickPrefix.Add(_T("Brown "));
		m_aFunnynickPrefix.Add(_T("Cool "));
		m_aFunnynickPrefix.Add(_T("Cruel "));
		m_aFunnynickPrefix.Add(_T("Cubic "));
		m_aFunnynickPrefix.Add(_T("Cute "));
		m_aFunnynickPrefix.Add(_T("Dance "));
		m_aFunnynickPrefix.Add(_T("Dark "));
		m_aFunnynickPrefix.Add(_T("Dinky "));
		m_aFunnynickPrefix.Add(_T("Drunk "));
		m_aFunnynickPrefix.Add(_T("Dumb "));
		m_aFunnynickPrefix.Add(_T("E"));
		m_aFunnynickPrefix.Add(_T("Electro "));
		m_aFunnynickPrefix.Add(_T("Elite "));
		m_aFunnynickPrefix.Add(_T("Fast "));
		m_aFunnynickPrefix.Add(_T("Flying "));
		m_aFunnynickPrefix.Add(_T("Fourios "));
		m_aFunnynickPrefix.Add(_T("Frustraded "));
		m_aFunnynickPrefix.Add(_T("Funny "));
		m_aFunnynickPrefix.Add(_T("Furious "));
		m_aFunnynickPrefix.Add(_T("Giant "));
		m_aFunnynickPrefix.Add(_T("Giga "));
		m_aFunnynickPrefix.Add(_T("Green "));
		m_aFunnynickPrefix.Add(_T("Handsome "));
		m_aFunnynickPrefix.Add(_T("Hard "));
		m_aFunnynickPrefix.Add(_T("Harsh "));
		m_aFunnynickPrefix.Add(_T("Hiphop "));
		m_aFunnynickPrefix.Add(_T("Holy "));
		m_aFunnynickPrefix.Add(_T("Horny "));
		m_aFunnynickPrefix.Add(_T("Hot "));
		m_aFunnynickPrefix.Add(_T("House "));
		m_aFunnynickPrefix.Add(_T("I"));
		m_aFunnynickPrefix.Add(_T("Lame "));
		m_aFunnynickPrefix.Add(_T("Leaking "));
		m_aFunnynickPrefix.Add(_T("Lone "));
		m_aFunnynickPrefix.Add(_T("Lovely "));
		m_aFunnynickPrefix.Add(_T("Lucky "));
		m_aFunnynickPrefix.Add(_T("Micro "));
		m_aFunnynickPrefix.Add(_T("Mighty "));
		m_aFunnynickPrefix.Add(_T("Mini "));
		m_aFunnynickPrefix.Add(_T("Nice "));
		m_aFunnynickPrefix.Add(_T("Orange "));
		m_aFunnynickPrefix.Add(_T("Pretty "));
		m_aFunnynickPrefix.Add(_T("Red "));
		m_aFunnynickPrefix.Add(_T("Sexy "));
		m_aFunnynickPrefix.Add(_T("Slow "));
		m_aFunnynickPrefix.Add(_T("Smooth "));
		m_aFunnynickPrefix.Add(_T("Stinky "));
		m_aFunnynickPrefix.Add(_T("Strong "));
		m_aFunnynickPrefix.Add(_T("Super "));
		m_aFunnynickPrefix.Add(_T("Unholy "));
		m_aFunnynickPrefix.Add(_T("White "));
		m_aFunnynickPrefix.Add(_T("Wild "));
		m_aFunnynickPrefix.Add(_T("X"));
		m_aFunnynickPrefix.Add(_T("XBox "));
		m_aFunnynickPrefix.Add(_T("Yellow "));
		m_aFunnynickPrefix.Add(_T("Kentucky Fried "));
		m_aFunnynickPrefix.Add(_T("Mc"));
		m_aFunnynickPrefix.Add(_T("Alien "));
		m_aFunnynickPrefix.Add(_T("Bavarian "));
		m_aFunnynickPrefix.Add(_T("Crazy "));
		m_aFunnynickPrefix.Add(_T("Death "));
		m_aFunnynickPrefix.Add(_T("Drunken "));
		m_aFunnynickPrefix.Add(_T("Fat "));
		m_aFunnynickPrefix.Add(_T("Hazardous "));
		m_aFunnynickPrefix.Add(_T("Holy "));
		m_aFunnynickPrefix.Add(_T("Infested "));
		m_aFunnynickPrefix.Add(_T("Insane "));
		m_aFunnynickPrefix.Add(_T("Mutated "));
		m_aFunnynickPrefix.Add(_T("Nasty "));
		m_aFunnynickPrefix.Add(_T("Purple "));
		m_aFunnynickPrefix.Add(_T("Radioactive "));
		m_aFunnynickPrefix.Add(_T("Ugly "));
		m_aFunnynickPrefix.Add(_T("Green "));

		m_aFunnynickSuffix.Add(_T("16"));
		m_aFunnynickSuffix.Add(_T("3"));
		m_aFunnynickSuffix.Add(_T("6"));
		m_aFunnynickSuffix.Add(_T("7"));
		m_aFunnynickSuffix.Add(_T("Abe"));
		m_aFunnynickSuffix.Add(_T("Bee"));
		m_aFunnynickSuffix.Add(_T("Bird"));
		m_aFunnynickSuffix.Add(_T("Boy"));
		m_aFunnynickSuffix.Add(_T("Cat"));
		m_aFunnynickSuffix.Add(_T("Cow"));
		m_aFunnynickSuffix.Add(_T("Crow"));
		m_aFunnynickSuffix.Add(_T("DJ"));
		m_aFunnynickSuffix.Add(_T("Dad"));
		m_aFunnynickSuffix.Add(_T("Deer"));
		m_aFunnynickSuffix.Add(_T("Dog"));
		m_aFunnynickSuffix.Add(_T("Donkey"));
		m_aFunnynickSuffix.Add(_T("Duck"));
		m_aFunnynickSuffix.Add(_T("Eagle"));
		m_aFunnynickSuffix.Add(_T("Elephant"));
		m_aFunnynickSuffix.Add(_T("Fly"));
		m_aFunnynickSuffix.Add(_T("Fox"));
		m_aFunnynickSuffix.Add(_T("Frog"));
		m_aFunnynickSuffix.Add(_T("Girl"));
		m_aFunnynickSuffix.Add(_T("Girlie"));
		m_aFunnynickSuffix.Add(_T("Guinea Pig"));
		m_aFunnynickSuffix.Add(_T("Hasi"));
		m_aFunnynickSuffix.Add(_T("Hawk"));
		m_aFunnynickSuffix.Add(_T("Jackal"));
		m_aFunnynickSuffix.Add(_T("Lizard"));
		m_aFunnynickSuffix.Add(_T("MC"));
		m_aFunnynickSuffix.Add(_T("Men"));
		m_aFunnynickSuffix.Add(_T("Mom"));
		m_aFunnynickSuffix.Add(_T("Mouse"));
		m_aFunnynickSuffix.Add(_T("Mule"));
		m_aFunnynickSuffix.Add(_T("Pig"));
		m_aFunnynickSuffix.Add(_T("Rabbit"));
		m_aFunnynickSuffix.Add(_T("Rat"));
		m_aFunnynickSuffix.Add(_T("Rhino"));
		m_aFunnynickSuffix.Add(_T("Smurf"));
		m_aFunnynickSuffix.Add(_T("Snail"));
		m_aFunnynickSuffix.Add(_T("Snake"));
		m_aFunnynickSuffix.Add(_T("Star"));
		m_aFunnynickSuffix.Add(_T("Tiger"));
		m_aFunnynickSuffix.Add(_T("Wolf"));
		m_aFunnynickSuffix.Add(_T("Butterfly"));
		m_aFunnynickSuffix.Add(_T("Elk"));
		m_aFunnynickSuffix.Add(_T("Godzilla"));
		m_aFunnynickSuffix.Add(_T("Horse"));
		m_aFunnynickSuffix.Add(_T("Penguin"));
		m_aFunnynickSuffix.Add(_T("Pony"));
		m_aFunnynickSuffix.Add(_T("Reindeer"));
		m_aFunnynickSuffix.Add(_T("Sheep"));
		m_aFunnynickSuffix.Add(_T("Sock Puppet"));
		m_aFunnynickSuffix.Add(_T("Worm"));
		m_aFunnynickSuffix.Add(_T("Bermuda"));
	}
}