//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// NEO: FCFG - [FileConfiguration] -- Xanatos -->

#include "Neo/GUI/CP/KCSideBannerWnd.h" // NEO: NPB - [PrefsBanner]

#pragma once
#include "ResizableLib/ResizablePage.h"
#include "ResizableLib/ResizableSheet.h"
#include "emule.h"
#include "FileInfoDialog.h"
#include "CommentDialogLst.h"
#include "MetaDataDlg.h"
#include "MuleListCtrl.h"
#include "ED2kLinkDlg.h"
#include "Neo/GUI/Modeless.h" // NEO: MLD - [ModelesDialogs]
#include "ListBoxST.h"

#include "Neo\Cp\PPgFileTweaks.h"
#include "Neo\Cp\PPgRelease.h"
#include "Neo\Cp\PPgSources.h"
#if defined(NEO_SK) || defined(NEO_SS) || defined(NEO_CD) // ||defined(NEO_SA) // NEO: NSS - [NeoSourceStorage]
#include "Neo/CP/PPgSourceStorage.h"
#endif // NEO: NSS END

class CSearchFile;

///////////////////////////////////////////////////////////////////////////////
// CFilePreferencesDialog

#define IDC_PREFS_LISTBOX 222

class CFilePreferencesDialog : public CListViewWalkerModelessPreferenceSheet // NEO: MLD - [ModelesDialogs]
{
	DECLARE_DYNAMIC(CFilePreferencesDialog)

public:
	CFilePreferencesDialog(const CSimpleArray<CObject*>* paFiles, UINT uPshInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL); // NEO: MLD - [ModelesDialogs]
	/*CFilePreferencesDialog(CTypedPtrList<CPtrList, CKnownFile*>& paFiles, UINT uPshInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);
	//CFilePreferencesDialog(CTypedPtrList<CPtrList, CPartFile*>& paFiles, UINT uPshInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);
	CFilePreferencesDialog(const CSimpleArray<CPartFile*>* paFiles, UINT uInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);
	CFilePreferencesDialog(CTypedPtrList<CPtrList, CAbstractFile*>& paFiles, UINT uPshInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);
	CFilePreferencesDialog(CTypedPtrList<CPtrList, CSearchFile*>& paFiles, UINT uPshInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);*/
	virtual ~CFilePreferencesDialog();

protected:
	CPPgFileTweaks	m_wndFileTweaks;
	CPPgRelease		m_wndRelease;
	CPPgSources		m_wndSources;
#if defined(NEO_SK) || defined(NEO_SS) || defined(NEO_CD) // ||defined(NEO_SA) // NEO: NSS - [NeoSourceStorage]
	CPPgSourceStorage m_wndSourceStorage;
#endif // NEO: NSS END

	CListBoxST		m_listbox;
	CButton			m_groupbox;
	CImageList		ImageList;
	int				m_iPrevPage;

	void Localize();
	void OpenPage(UINT uResourceID);
	void AddPages(void);

	UINT m_uPshInvokePage;
	//static LPCTSTR m_pPshStartPage;

	void UpdateTitle();

	virtual BOOL OnInitDialog();
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT OnDataChanged(WPARAM, LPARAM);
	afx_msg void OnSelChanged();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

	UINT m_nActiveWnd;

	CKCSideBannerWnd m_banner; // NEO: NPB - [PrefsBanner]
};

// NEO: MLD - [ModelesDialogs]
///////////////////////////////////////////////////////////////////////////////
// CFilePreferencesDialogInterface

class CFilePreferencesDialogInterface : public CListViewWalkerModelessPreferenceSheetInterface
{
public:
	CFilePreferencesDialogInterface(CKnownFile* owner);
	CFilePreferencesDialogInterface(CPartFile* owner);
	CFilePreferencesDialogInterface(CSearchFile* owner);
	CFilePreferencesDialogInterface(CAbstractFile* owner);
	void	OpenPreferencesDialog(CTypedPtrList<CPtrList, CKnownFile*>& paFiles, UINT uInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);
	void	OpenPreferencesDialog(CTypedPtrList<CPtrList, CPartFile*>& paFiles, UINT uInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);
	void	OpenPreferencesDialog(CTypedPtrList<CPtrList, CSearchFile*>& paFiles, UINT uInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);
	void	OpenPreferencesDialog(CTypedPtrList<CPtrList, CAbstractFile*>& paFiles, UINT uInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);

protected:
	virtual CListViewWalkerModelessPreferenceSheet* CreatePreferencesSheet(va_list);
};
// NEO: MLD

// NEO: FCFG END <-- Xanatos --