//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// NEO: FCFG - [FileConfiguration] -- Xanatos -->

#include "stdafx.h"
#include "emule.h"
#include "OtherFunctions.h"
#include "FileInfoDialog.h"
#include "FilePreferencesDialog.h"
#include "Preferences.h"
#include "UpDownClient.h"
#include "Neo\GUI\XPMenu\MenuXP.h" // NEO: NMX - [NeoMenuXP] <-- Xanatos --
#include "MenuCmds.h"
#include "PartFile.h"
#include "AbstractFile.h"
#include "SearchFile.h"
#include "StringConversion.h"
#include "shahashset.h"
#include "HighColorTab.hpp"
#include "UserMsgs.h"
#include "EnBitmap.h"
#include "SharedFilesCtrl.h"
#include "DownloadListCtrl.h"
#include "SearchListCtrl.h"
#include "CollectionListCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CFilePreferencesDialog

//LPCTSTR CFilePreferencesDialog::m_pPshStartPage;

IMPLEMENT_DYNAMIC(CFilePreferencesDialog, CListViewWalkerModelessPreferenceSheet) // NEO: MLD - [ModelesDialogs]

BEGIN_MESSAGE_MAP(CFilePreferencesDialog, CListViewWalkerModelessPreferenceSheet) // NEO: MLD - [ModelesDialogs]
	ON_WM_DESTROY()
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
	ON_LBN_SELCHANGE(IDC_PREFS_LISTBOX,OnSelChanged)
	ON_WM_CTLCOLOR()
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CFilePreferencesDialog::CFilePreferencesDialog(const CSimpleArray<CObject*>* paFiles, UINT uPshInvokePage, CListCtrlItemWalk* pListCtrl)
	: CListViewWalkerModelessPreferenceSheet(pListCtrl) // NEO: MLD - [ModelesDialogs]
{
	m_uPshInvokePage = uPshInvokePage;
	for (int i = 0; i < paFiles->GetSize(); i++)
		m_aItems.Add((*paFiles)[i]);
	m_psh.dwFlags &= ~PSH_HASHELP;
	AddPages();
}

/*CFilePreferencesDialog::CFilePreferencesDialog(CTypedPtrList<CPtrList, CKnownFile*>& paFiles, UINT uPshInvokePage, CListCtrlItemWalk* pListCtrl)
	: CListViewWalkerModelessPreferenceSheet(pListCtrl) // NEO: MLD - [ModelesDialogs]

{
	m_uPshInvokePage = uPshInvokePage;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos)
		m_aItems.Add(paFiles.GetNext(pos));
	m_psh.dwFlags &= ~PSH_HASHELP;
	AddPages();
}

CFilePreferencesDialog::CFilePreferencesDialog(CTypedPtrList<CPtrList, CAbstractFile*>& paFiles, UINT uPshInvokePage, CListCtrlItemWalk* pListCtrl)
	: CListViewWalkerModelessPreferenceSheet(pListCtrl) // NEO: MLD - [ModelesDialogs]

{
	m_uPshInvokePage = uPshInvokePage;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos)
		m_aItems.Add(paFiles.GetNext(pos));
	m_psh.dwFlags &= ~PSH_HASHELP;
	AddPages();
}

CFilePreferencesDialog::CFilePreferencesDialog(CTypedPtrList<CPtrList, CSearchFile*>& paFiles, UINT uPshInvokePage, CListCtrlItemWalk* pListCtrl)
	: CListViewWalkerModelessPreferenceSheet(pListCtrl) // NEO: MLD - [ModelesDialogs]

{
	m_uPshInvokePage = uPshInvokePage;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos)
		m_aItems.Add(paFiles.GetNext(pos));
	m_psh.dwFlags &= ~PSH_HASHELP;
	AddPages();
}

CFilePreferencesDialog::CFilePreferencesDialog(const CSimpleArray<CPartFile*>* paFiles, UINT uPshInvokePage, CListCtrlItemWalk* pListCtrl)
	: CListViewWalkerModelessPreferenceSheet(pListCtrl) // NEO: MLD - [ModelesDialogs]

{
	m_uPshInvokePage = uPshInvokePage;
	for (int i = 0; i < paFiles->GetSize(); i++)
		m_aItems.Add((*paFiles)[i]);
	m_psh.dwFlags &= ~PSH_HASHELP;
	AddPages();
}*/

void CFilePreferencesDialog::AddPages(void)
{
	if(m_pListCtrl == NULL){
		ASSERT(0);
	}

	else if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CSharedFilesCtrl)))
	{
		m_wndRelease.m_psp.dwFlags &= ~PSP_HASHELP;
		//m_wndRelease.m_psp.dwFlags |= PSP_USEICONID;
		//m_wndRelease.m_psp.pszIcon = _T("FILEINFO");
		m_wndRelease.SetFiles(&m_aItems);
		AddPage(&m_wndRelease);
	}

	else if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CDownloadListCtrl)))
	{
		m_wndFileTweaks.m_psp.dwFlags &= ~PSP_HASHELP;
		//m_wndFileTweaks.m_psp.dwFlags |= PSP_USEICONID;
		//m_wndFileTweaks.m_psp.pszIcon = _T("FILEINFO");
		m_wndFileTweaks.SetFiles(&m_aItems);
		AddPage(&m_wndFileTweaks);

		m_wndRelease.m_psp.dwFlags &= ~PSP_HASHELP;
		//m_wndRelease.m_psp.dwFlags |= PSP_USEICONID;
		//m_wndRelease.m_psp.pszIcon = _T("FILEINFO");
		m_wndRelease.SetFiles(&m_aItems);
		AddPage(&m_wndRelease);

		m_wndSources.m_psp.dwFlags &= ~PSP_HASHELP;
		//m_wndSources.m_psp.dwFlags |= PSP_USEICONID;
		//m_wndSources.m_psp.pszIcon = _T("FILEINFO");
		m_wndSources.SetFiles(&m_aItems);
		AddPage(&m_wndSources);

#if defined(NEO_SK) || defined(NEO_SS) || defined(NEO_CD) // ||defined(NEO_SA) // NEO: NSS - [NeoSourceStorage]
		m_wndSourceStorage.m_psp.dwFlags &= ~PSP_HASHELP;
		//m_wndSourceStorage.m_psp.dwFlags |= PSP_USEICONID;
		//m_wndSourceStorage.m_psp.pszIcon = _T("FILEINFO");
		m_wndSourceStorage.SetFiles(&m_aItems);
		AddPage(&m_wndSourceStorage);
#endif // NEO: NSS END
	}

	else if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CSearchListCtrl)))
	{

	}

	else if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CCollectionListCtrl)))
	{
		/*m_wndRelease.m_psp.dwFlags &= ~PSP_HASHELP;
		//m_wndRelease.m_psp.dwFlags |= PSP_USEICONID;
		//m_wndRelease.m_psp.pszIcon = _T("FILEINFO");
		m_wndRelease.SetFiles(&m_aItems);
		AddPage(&m_wndRelease);*/
	}

	m_nActiveWnd = 0;
	m_iPrevPage = -1;

	/*LPCTSTR pPshStartPage = m_pPshStartPage;
	if (m_uPshInvokePage != 0)
		pPshStartPage = MAKEINTRESOURCE(m_uPshInvokePage);
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		CPropertyPage* pPage = GetPage(i);
		if (pPage->m_psp.pszTemplate == pPshStartPage)
		{
			m_psh.nStartPage = i;
			break;
		}
	}*/
}

CFilePreferencesDialog::~CFilePreferencesDialog()
{
}

void CFilePreferencesDialog::OnDestroy()
{
	/*if (m_uPshInvokePage == 0)
		m_pPshStartPage = GetPage(GetActiveIndex())->m_psp.pszTemplate;*/
	CListViewWalkerModelessPreferenceSheet::OnDestroy(); // NEO: MLD - [ModelesDialogs]
	m_nActiveWnd = GetActiveIndex();
}

BOOL CFilePreferencesDialog::OnInitDialog()
{		
	EnableStackedTabs(FALSE);
	BOOL bResult = CListViewWalkerModelessPreferenceSheet::OnInitDialog(); // NEO: MLD - [ModelesDialogs]
	//HighColorTab::UpdateImageList(*this);
	//InitWindowStyles(this);
	//EnableSaveRestore(_T("FilePreferencesDialog")); // call this after(!) OnInitDialog
	//UpdateTitle();

	m_listbox.CreateEx(WS_EX_CLIENTEDGE,_T("Listbox"),0,WS_CHILD|WS_VISIBLE|LBS_NOTIFY|WS_TABSTOP|LBS_HASSTRINGS|LBS_OWNERDRAWVARIABLE|WS_BORDER,CRect(0,0,0,0),this,IDC_PREFS_LISTBOX);
	::SendMessage(m_listbox.m_hWnd, WM_SETFONT, (WPARAM) ::GetStockObject(DEFAULT_GUI_FONT),0);
	m_groupbox.Create(0,BS_GROUPBOX|WS_CHILD|WS_VISIBLE|BS_FLAT,CRect(0,0,0,0),this,666);
	::SendMessage(m_groupbox.m_hWnd, WM_SETFONT, (WPARAM) ::GetStockObject(DEFAULT_GUI_FONT),0);
	InitWindowStyles(this);

	SetActivePage(m_nActiveWnd);

	// Localise ->
	ImageList.DeleteImageList();
	ImageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 0, 1);
	ImageList.Add(CTempIconLoader(_T("NEOTWEAKS"))); 
	ImageList.Add(CTempIconLoader(_T("RELEASE"))); 
	ImageList.Add(CTempIconLoader(_T("SOURCE"))); 
#if defined(NEO_SK) || defined(NEO_SS) || defined(NEO_CD) // ||defined(NEO_SA) // NEO: NSS - [NeoSourceStorage]
	ImageList.Add(CTempIconLoader(_T("SOURCESAVER")));
#endif // NEO: NSS END
	m_listbox.SetImageList(&ImageList);

	CString title = GetResString(IDS_EM_PREFS); 
	title.Remove(_T('&')); 
	SetTitle(title); 

	//m_wndSources.Localize(); // <- Here

	TC_ITEM item; 
	item.mask = TCIF_TEXT; 

	CStringArray buffer; 
	buffer.Add(GetResString(IDS_X_PW_NEO));
	buffer.Add(GetResString(IDS_X_PW_RELEASE));
	buffer.Add(GetResString(IDS_X_PW_SOURCE));
#if defined(NEO_SK) || defined(NEO_SS) || defined(NEO_CD) // ||defined(NEO_SA) // NEO: NSS - [NeoSourceStorage]
	buffer.Add(GetResString(IDS_X_PW_SOURCE_STORAGE));
#endif // NEO: NSS END

	for (int i = 0; i < buffer.GetCount(); i++)
		buffer[i].Remove(_T('&'));

	m_listbox.ResetContent();
	int width = 0;
	CTabCtrl* tab = GetTabControl();
	CClientDC dc(this);
	CFont *pOldFont = dc.SelectObject(m_listbox.GetFont());
	CSize sz;
	for(int i = 0; i < GetPageCount(); i++) 
	{ 
		item.pszText = buffer[i].GetBuffer(); 
		tab->SetItem (i, &item); 
		buffer[i].ReleaseBuffer();
		m_listbox.AddString(buffer[i].GetBuffer(),i);
		sz = dc.GetTextExtent(buffer[i]);
		if(sz.cx > width)
			width = sz.cx;
	}
	m_groupbox.SetWindowText(GetResString(IDS_PW_GENERAL));
	width+=50;
	CRect rectOld;
	m_listbox.GetWindowRect(&rectOld);
	int xoffset, yoffset;
	if(IsWindowVisible())
	{
		yoffset=0;
		xoffset=width-rectOld.Width();
	}
	else
	{
		xoffset=width-rectOld.Width()+10;
		tab->GetItemRect(0,rectOld);
		yoffset=-rectOld.Height();
	}
	GetWindowRect(rectOld);
	SetWindowPos(NULL,0,0,rectOld.Width()+xoffset,rectOld.Height()+yoffset,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
	tab->GetWindowRect (rectOld);
	ScreenToClient (rectOld);
	tab->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	CPropertyPage* activepage = GetActivePage();
	activepage->GetWindowRect(rectOld);
	ScreenToClient (rectOld);
	activepage->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	activepage->GetWindowRect(rectOld);
	ScreenToClient (rectOld);
	m_groupbox.SetWindowPos(NULL,rectOld.left,2,rectOld.Width()+4,rectOld.Height()+10,SWP_NOZORDER|SWP_NOACTIVATE);
	m_groupbox.GetWindowRect(rectOld);
	ScreenToClient(rectOld);
	m_listbox.SetWindowPos(NULL,6,rectOld.top+5,width,rectOld.Height()-4,SWP_NOZORDER|SWP_NOACTIVATE);
	int _PropSheetButtons[] = {100, 101, IDOK, IDCANCEL, ID_APPLY_NOW, IDHELP }; // 100, 101, List walking buttons
	CWnd* PropSheetButton;
	for (int i = 0; i < sizeof (_PropSheetButtons) / sizeof(_PropSheetButtons[0]); i++)
	{
		if ((PropSheetButton = GetDlgItem(_PropSheetButtons[i])) != NULL)
		{
			PropSheetButton->GetWindowRect (rectOld);
			ScreenToClient (rectOld);
			PropSheetButton->SetWindowPos (NULL, rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
		}
	}
	tab->ShowWindow(SW_HIDE);
	m_listbox.SetCurSel(GetActiveIndex());		
	CenterWindow();
	m_banner.UpdateSize(); // NEO: NPB - [PrefsBanner] <-- Xanatos --
	Invalidate();
	RedrawWindow();
	dc.SelectObject(pOldFont); //restore default font object
	// <- Localise

	UpdateTitle();

	m_listbox.SetFocus();
	CString currenttext;
	int curSel=m_listbox.GetCurSel();
	m_listbox.GetText(curSel,currenttext);
	m_groupbox.SetWindowText(currenttext);
	m_iPrevPage = curSel;

	// NEO: NPB - [PrefsBanner]
	if(thePrefs.ShowBanner()){
		//m_banner.SetColBkg2( RGB(0,0,0) );
		//m_banner.SetColBkg( RGB(0,0,0) );
		//m_banner.SetColEdge( RGB(0,0,0) );
		CEnBitmap bmp;
		bmp.LoadImage(_T("BANNER"),_T("JPG"));
		m_banner.SetTexture((HBITMAP)bmp.Detach());	
		m_banner.SetFillFlag(KCSB_FILL_TEXTURE);
		m_banner.SetSize(58);
		m_banner.SetTitle(_T(""));
		m_banner.SetCaption(_T(""));
		m_banner.Attach(this, KCSB_ATTACH_RIGHT);
		//int p = m_banner.GetSize();	
	}
	// NEO: NPB END

	return bResult;
}

void CFilePreferencesDialog::OnSelChanged()
{
	int curSel=m_listbox.GetCurSel();
	if (!SetActivePage(curSel)){
		if (m_iPrevPage != -1){
			m_listbox.SetCurSel(m_iPrevPage);
			return;
		}
	}
	CString currenttext;
	m_listbox.GetText(curSel,currenttext);
	m_groupbox.SetWindowText(currenttext);
	m_listbox.SetFocus();
	m_iPrevPage = curSel;
}

LRESULT CFilePreferencesDialog::OnDataChanged(WPARAM, LPARAM)
{
	UpdateTitle();
	return 1;
}

void CFilePreferencesDialog::UpdateTitle()
{
	if (m_aItems.GetSize() == 1){
		// NEO: MLD - [ModelesDialogs]
		if(!m_aItems[0]->IsKindOf(RUNTIME_CLASS(CKnownFile)))
			return;
		// NEO: MLD END
		SetWindowText(GetResString(IDS_DETAILS) + _T(": ") + STATIC_DOWNCAST(CKnownFile, m_aItems[0])->GetFileName());
	}else
		SetWindowText(GetResString(IDS_DETAILS));
}

HBRUSH CFilePreferencesDialog::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CPropertySheet::OnCtlColor(pDC, pWnd, nCtlColor);
	if (m_groupbox.m_hWnd == pWnd->m_hWnd) 
	{
		pDC->SetBkColor(GetSysColor(COLOR_BTNFACE));
		hbr = GetSysColorBrush(COLOR_BTNFACE);
	}
	return hbr;
}

void CFilePreferencesDialog::OnHelp()
{
	int iCurSel = m_listbox.GetCurSel();
	if (iCurSel >= 0)
	{
		CPropertyPage* pPage = GetPage(iCurSel);
		if (pPage)
		{
			HELPINFO hi = {0};
			hi.cbSize = sizeof hi;
			hi.iContextType = HELPINFO_WINDOW;
			hi.iCtrlId = 0;
			hi.hItemHandle = pPage->m_hWnd;
			hi.dwContextId = 0;
			pPage->SendMessage(WM_HELP, 0, (LPARAM)&hi);
			return;
		}
	}

	theApp.ShowHelp(0, HELP_CONTENTS);
}

BOOL CFilePreferencesDialog::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CFilePreferencesDialog::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

void CFilePreferencesDialog::OpenPage(UINT uResourceID)
{
	int iCurActiveWnd = m_nActiveWnd;
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		CPropertyPage* pPage = GetPage(i);
		if (pPage->m_psp.pszTemplate == MAKEINTRESOURCE(uResourceID))
		{
			m_nActiveWnd = i;
			break;
		}
	}
	DoModal();
	m_nActiveWnd = iCurActiveWnd;
}

// NEO: MLD - [ModelesDialogs]
///////////////////////////////////////////////////////////////////////////////
// CFilePreferencesDialogInterface
CFilePreferencesDialogInterface::CFilePreferencesDialogInterface(CKnownFile* owner)
	: CListViewWalkerModelessPreferenceSheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

CFilePreferencesDialogInterface::CFilePreferencesDialogInterface(CPartFile* owner)
	: CListViewWalkerModelessPreferenceSheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

CFilePreferencesDialogInterface::CFilePreferencesDialogInterface(CSearchFile* owner)
	: CListViewWalkerModelessPreferenceSheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

CFilePreferencesDialogInterface::CFilePreferencesDialogInterface(CAbstractFile* owner)
	: CListViewWalkerModelessPreferenceSheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

void CFilePreferencesDialogInterface::OpenPreferencesDialog(CTypedPtrList<CPtrList, CKnownFile*>& paFiles, UINT uInvokePage, CListCtrlItemWalk* pListCtrl)
{
	CSimpleArray<CListViewWalkerModelessPreferenceSheetInterface*> aInterfaces;
	CSimpleArray<CObject*> m_aItems;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos){
		m_aItems.Add(paFiles.GetAt(pos));
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPreferenceSheetInterface, paFiles.GetNext(pos)->GetPreferencesDialogInterface()));
	}
	OpenPreferenceSheet(&aInterfaces, &m_aItems, uInvokePage, pListCtrl);
}

void CFilePreferencesDialogInterface::OpenPreferencesDialog(CTypedPtrList<CPtrList, CPartFile*>& paFiles, UINT uInvokePage, CListCtrlItemWalk* pListCtrl)
{
	CSimpleArray<CListViewWalkerModelessPreferenceSheetInterface*> aInterfaces;
	CSimpleArray<CObject*> m_aItems;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos){
		m_aItems.Add(paFiles.GetAt(pos));
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPreferenceSheetInterface, paFiles.GetNext(pos)->GetPreferencesDialogInterface()));
	}
	OpenPreferenceSheet(&aInterfaces, &m_aItems, uInvokePage, pListCtrl);
}

void CFilePreferencesDialogInterface::OpenPreferencesDialog(CTypedPtrList<CPtrList, CSearchFile*>& paFiles, UINT uInvokePage, CListCtrlItemWalk* pListCtrl)
{
	CSimpleArray<CListViewWalkerModelessPreferenceSheetInterface*> aInterfaces;
	CSimpleArray<CObject*> m_aItems;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos){
		m_aItems.Add(paFiles.GetAt(pos));
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPreferenceSheetInterface, paFiles.GetNext(pos)->GetPreferencesDialogInterface()));
	}
	OpenPreferenceSheet(&aInterfaces, &m_aItems, uInvokePage, pListCtrl);
}

void CFilePreferencesDialogInterface::OpenPreferencesDialog(CTypedPtrList<CPtrList, CAbstractFile*>& paFiles, UINT uInvokePage, CListCtrlItemWalk* pListCtrl)
{
	CSimpleArray<CListViewWalkerModelessPreferenceSheetInterface*> aInterfaces;
	CSimpleArray<CObject*> m_aItems;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos){
		m_aItems.Add(paFiles.GetAt(pos));
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPreferenceSheetInterface, paFiles.GetNext(pos)->GetPreferencesDialogInterface()));
	}
	OpenPreferenceSheet(&aInterfaces, &m_aItems, uInvokePage, pListCtrl);
}

CListViewWalkerModelessPreferenceSheet* CFilePreferencesDialogInterface::CreatePreferencesSheet(va_list args)
{
	const CSimpleArray<CObject*>* paFiles = (const CSimpleArray<CObject*>*)va_arg(args, LPVOID);
	UINT uInvokePage = va_arg(args, UINT);
	CListCtrlItemWalk* pListCtrl = va_arg(args, CListCtrlItemWalk*);
	return STATIC_DOWNCAST(CListViewWalkerModelessPreferenceSheet, new CFilePreferencesDialog(paFiles, uInvokePage, pListCtrl));
}
// NEO: MLD

// NEO: FCFG END <-- Xanatos --