//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h" 
#include "emule.h"
#include "ArgosInfo.h"
#include "OtherFunctions.h"
#include "ClientList.h"
#include "DownloadQueue.h"
#include "UpDownClient.h"
#include "PartFile.h"
#include "UserMsgs.h"
#include "SharedFileList.h"
#include "ClientCredits.h"
#include "Preferences.h"
#include "Neo/Argos.h"
#include "Neo/Functions.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->

///////////////////////////////////////////////////////////////////////////////
// CClientArgosInfoPage

IMPLEMENT_DYNAMIC(CClientArgosInfoPage, CResizablePage)

BEGIN_MESSAGE_MAP(CClientArgosInfoPage, CResizablePage)
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()

CClientArgosInfoPage::CClientArgosInfoPage()
	: CResizablePage(CClientArgosInfoPage::IDD,0)
{
	m_paClients = NULL;
	m_bDataChanged = false;
	m_strCaption = GetResString(IDS_X_ARGOS);
	m_psp.pszTitle = m_strCaption;
	m_psp.dwFlags |= PSP_USETITLE;
}

CClientArgosInfoPage::~CClientArgosInfoPage()
{
}

void CClientArgosInfoPage::DoDataExchange(CDataExchange* pDX)
{
	CResizablePage::DoDataExchange(pDX);
}

BOOL CClientArgosInfoPage::OnInitDialog()
{
	CResizablePage::OnInitDialog();
	InitWindowStyles(this);

	AddAnchor(IDC_STATIC30, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_STATIC37, TOP_LEFT, TOP_RIGHT);
	//AddAnchor(IDC_, TOP_LEFT, TOP_RIGHT);

	Localize();
	return TRUE;
}

BOOL CClientArgosInfoPage::OnSetActive()
{
	if (!CResizablePage::OnSetActive())
		return FALSE;

	if (m_bDataChanged)
	{
		CUpDownClient* client = STATIC_DOWNCAST(CUpDownClient, (*m_paClients)[0]);

		TArgosClient* aClient = theApp.argos->GetArgosClient(client->GetConnectIP());
		if(aClient == NULL){
			DisableDialog();
			return TRUE;
		}
		DisableDialog(false);

		CString Buffer;

		GetDlgItem(IDC_DLMOD)->SetWindowText(thePrefs.IsArgosLeecherModDetection() ? (aClient->m_bArgosIsLeecherMod ? client->GetClientModVer() : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DLNICK)->SetWindowText(thePrefs.IsArgosLeecherNickDetection() ? (aClient->m_bArgosIsLeecherNick ? (client->GetUserName() ? client->GetUserName() : GetResString(IDS_UNKNOWN)) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		//GetDlgItem(IDC_DLOPCODE)->SetWindowText(thePrefs.IsArgosOpcodeDetection() ? (aClient->m_bArgosIsLeecherOpCode ? StrLine(_T("%ux%02X"),(uint8)(aClient->m_bArgosIsLeecherOpCode>>8), (uint8)aClient->m_bArgosIsLeecherOpCode) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DLOPCODE)->SetWindowText(thePrefs.IsArgosOpcodeDetection() ? (aClient->m_bArgosIsLeecherOpCode ? StrLine(_T("%ux%02X"),aClient->m_bArgosIsLeecherOpCode, aClient->m_uLeecherOpCode) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DLHASH)->SetWindowText(thePrefs.IsArgosLeecherHashDetection() ? (aClient->m_bArgosIsLeecherHash ? md4str(client->GetUserHash()) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		GetDlgItem(IDC_DNICKTHIEF)->SetWindowText(thePrefs.IsArgosNickThiefDetection() ? (aClient->m_bArgosIsNickThief ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DMODTHIEF)->SetWindowText(thePrefs.IsArgosModThiefDetection() ? (aClient->m_bArgosIsModThief ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		Buffer.Empty();
		if(aClient->m_bArgosIsHashThief){
			Buffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsHashThief & 1)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_TRUST));
			if(aClient->m_bArgosIsHashThief & 2)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_ZONE));
			if(aClient->m_bArgosIsHashThief & 4)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_SUI));
		}
		GetDlgItem(IDC_DHASHTHIEF)->SetWindowText(thePrefs.IsArgosHashThiefDetection() ? (Buffer.IsEmpty() ? GetResString(IDS_NO) : Buffer) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DCREDITHACK)->SetWindowText(thePrefs.IsArgosCreditHackDetection() ? (aClient->m_bArgosIsCreditHack ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		Buffer.Empty();
		if(aClient->m_bArgosIsHashChanged){
			Buffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsHashChanged & 1)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_DIRECT));
			if(aClient->m_bArgosIsHashChanged & 2)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_TRACK_LIST));
			if(aClient->m_bArgosIsHashChanged & 4)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_MONITOR));
		}
		GetDlgItem(IDC_DHASHCHANGED)->SetWindowText(thePrefs.IsHashChangeDetection() ? (Buffer.IsEmpty() ? GetResString(IDS_NO) : Buffer) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DGHOSTMODE)->SetWindowText(thePrefs.IsArgosGhostModDetection() ? (aClient->m_bArgosIsGhostMode ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		Buffer.Empty();
		if(aClient->m_bArgosIsFakeClient){
			Buffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsFakeClient & 1)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_PROTOCOL));
			if(aClient->m_bArgosIsFakeClient & 2)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_SOFTWARE));
		}
		GetDlgItem(IDC_DFAKECLIENT)->SetWindowText(thePrefs.IsArgosFakeClientDetection() ? (Buffer.IsEmpty() ? GetResString(IDS_NO) : Buffer) : GetResString(IDS_UNKNOWN));

		Buffer.Empty();
		if(aClient->m_bArgosIsAgressiv){
			Buffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsAgressiv & 1)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_FAST_TCP));
			if(aClient->m_bArgosIsAgressiv & 2)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_FAST_UDP));
		}
		GetDlgItem(IDC_DAGRESSIV)->SetWindowText(thePrefs.IsAgressionDetection() ? (Buffer.IsEmpty() ? GetResString(IDS_NO) : Buffer) : GetResString(IDS_UNKNOWN));

		GetDlgItem(IDC_DFILESCANNER)->SetWindowText(thePrefs.IsFileScannerDetection() ? (aClient->m_bArgosIsFileScanner ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DFILEFAKER)->SetWindowText(thePrefs.IsFileFakerDetection() ? (aClient->m_bArgosIsFileFaker ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DBADSENDER)->SetWindowText(thePrefs.IsBadSenderDetection() ? (aClient->m_bArgosIsCorruptedSender ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DRANKFLOODER)->SetWindowText(thePrefs.IsRankFloodDetection() ? (aClient->m_bArgosIsRankFlooder ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DFAILED)->SetWindowText(thePrefs.IsFailedDetection() ? (aClient->m_bArgosIsFailed ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DSPAM)->SetWindowText(thePrefs.IsArgosSpamDetection() ? (aClient->m_bArgosIsSpam ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		Buffer.Empty();
		if(aClient->m_bArgosIsXSExploit){
			Buffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsXSExploit & 1)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_ASK_FAST));
			if(aClient->m_bArgosIsXSExploit & 2)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_DONT_ANSWER));
		}
		GetDlgItem(IDC_DXSEXPLOIT)->SetWindowText(thePrefs.IsArgosXSExploitDetection() ? (Buffer.IsEmpty() ? GetResString(IDS_NO) : Buffer) : GetResString(IDS_UNKNOWN));


		GetDlgItem(IDC_DNICKCHANGER)->SetWindowText(thePrefs.IsArgosNickChangerDetection() ? (aClient->m_bArgosIsNickChanger ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_DMODCHANGER)->SetWindowText(thePrefs.IsArgosModChangerDetection() ? (aClient->m_bArgosIsModChanger ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		Buffer.Empty();
		if(aClient->m_bArgosIsBadHello){
			Buffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsBadHello & 1)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_EXTRA_BATES));
			if(aClient->m_bArgosIsBadHello & 2)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_BAD_ORDER));
			if(aClient->m_bArgosIsBadHello & 4)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_BAD_TAG));
			if(aClient->m_bArgosIsBadHello & 8)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_BAD_PORT));
			if(aClient->m_bArgosIsBadHello & 16)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_EMCRYPT));
		}
		GetDlgItem(IDC_DBADHELLO)->SetWindowText(thePrefs.IsArgosBadHelloDetection() ? (Buffer.IsEmpty() ? GetResString(IDS_NO) : Buffer) : GetResString(IDS_UNKNOWN));

		Buffer.Empty();
		if(aClient->m_bArgosIsBadProt){
			Buffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsBadProt & 1)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_BAD_HASH_SIZE));
			if(aClient->m_bArgosIsBadProt & 2)
				Buffer.AppendFormat(_T("; %s"),GetResString(IDS_X_BAD_PACKET));
		}
		GetDlgItem(IDC_DBADPROT)->SetWindowText(thePrefs.IsArgosBadProtDetection() ? (Buffer.IsEmpty() ? GetResString(IDS_NO) : Buffer) : GetResString(IDS_UNKNOWN));

		GetDlgItem(IDC_DLASTSEEN)->SetWindowText(CastSecondsToHM(MS2SEC(::GetTickCount() - aClient->m_uLastSeenTime)));
		GetDlgItem(IDC_DLASTDETECTION)->SetWindowText(aClient->m_uLastDetectionTime ? (CastSecondsToHM(MS2SEC(::GetTickCount() - aClient->m_uLastDetectionTime))) : GetResString(IDS_X_NONE));

		GetDlgItem(IDC_DPUNISCHMENT)->SetWindowText(aClient->m_uPunishment >= 100 ? GetResString(IDS_X_ARGOS_IP_BAN) : (aClient->m_uPunishment == 10 ? GetResString(IDS_X_ARGOS_UL_BAN) : (aClient->m_uPunishment == 0 ? GetResString(IDS_X_ARGOS_NO_BAN) : (StrLine(GetResString(IDS_X_ARGOS_SCORE), 10 - aClient->m_uPunishment) ))));

		if(thePrefs.GetCreditCompensation())
			GetDlgItem(IDC_DCOMPENSATION)->SetWindowText(
				aClient->m_uPunishment == 0 ? GetResString(client->IsFriend() ? IDS_X_FRIEND : client->IsCommunity() ? IDS_X_COMMUNITY : IDS_NO) : 
				((aClient->m_uPunishment == 10 && (thePrefs.GetCreditCompensation() < 10 || !theApp.argos->IsNullCompensation(client))) ? GetResString(IDS_X_ARGOS_UL_LOCK) : 
				StrLine(_T("%.2f"),theApp.argos->GetCompensation(client))
				));

		GetDlgItem(IDC_DTYPE)->SetWindowText(aClient->m_eLeecherType == LT_NO ? GetResString(IDS_X_NONE) : theApp.argos->GetLeecherTypeStr((ELeecherType)aClient->m_eLeecherType));
		GetDlgItem(IDC_DCOMMENT)->SetWindowText(aClient->Comment ? *aClient->Comment : GetResString(IDS_X_NONE));

		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CClientArgosInfoPage::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}

void CClientArgosInfoPage::Localize()
{
	GetDlgItem(IDC_STATIC30)->SetWindowText(GetResString(IDS_X_ARGOS_DETECTION));
	GetDlgItem(IDC_STATIC37)->SetWindowText(GetResString(IDS_X_ARGOS_SUMARY));
	GetDlgItem(IDC_STATIC62)->SetWindowText(GetResString(IDS_X_ARGOS_LEECHER_MOD));
	GetDlgItem(IDC_STATIC57)->SetWindowText(GetResString(IDS_X_ARGOS_LEECHER_NICK));
	GetDlgItem(IDC_STATIC63)->SetWindowText(GetResString(IDS_X_ARGOS_LEECHER_OPCODE));
	GetDlgItem(IDC_STATIC83)->SetWindowText(GetResString(IDS_X_ARGOS_LEECHER_HASH));
	GetDlgItem(IDC_STATIC73)->SetWindowText(GetResString(IDS_X_ARGOS_NICKTHIEF));
	GetDlgItem(IDC_STATIC64)->SetWindowText(GetResString(IDS_X_ARGOS_MODTHIEF));
	GetDlgItem(IDC_STATIC58)->SetWindowText(GetResString(IDS_X_ARGOS_HASHTHIEF));
	GetDlgItem(IDC_STATIC65)->SetWindowText(GetResString(IDS_X_ARGOS_CREDITHACK));
	GetDlgItem(IDC_STATIC59)->SetWindowText(GetResString(IDS_X_ARGOS_HASHCHANGE));
	GetDlgItem(IDC_STATIC66)->SetWindowText(GetResString(IDS_X_ARGOS_GHOSTMODE));
	GetDlgItem(IDC_STATIC60)->SetWindowText(GetResString(IDS_X_ARGOS_FAKECLIENT));
	GetDlgItem(IDC_STATIC67)->SetWindowText(GetResString(IDS_X_ARGOS_ASKAGRESSIV));
	GetDlgItem(IDC_STATIC61)->SetWindowText(GetResString(IDS_X_ARGOS_FILE_SCANNER));
	GetDlgItem(IDC_STATIC84)->SetWindowText(GetResString(IDS_X_ARGOS_FILE_FAKER));
	GetDlgItem(IDC_STATIC74)->SetWindowText(GetResString(IDS_X_ARGOS_BADSENDER));
	GetDlgItem(IDC_STATIC68)->SetWindowText(GetResString(IDS_X_ARGOS_RANK_FLOODER));
	GetDlgItem(IDC_STATIC79)->SetWindowText(GetResString(IDS_X_ARGOS_FAILED_SRC));
	GetDlgItem(IDC_STATIC80)->SetWindowText(GetResString(IDS_X_ARGOS_XSEXPLOIT_SRC));
	GetDlgItem(IDC_STATIC81)->SetWindowText(GetResString(IDS_X_ARGOS_SPAM_SRC));
	GetDlgItem(IDC_STATIC82)->SetWindowText(GetResString(IDS_X_ARGOS_BADHELLO_SRC));
	GetDlgItem(IDC_STATIC85)->SetWindowText(GetResString(IDS_X_ARGOS_BADPROT_SRC));
	GetDlgItem(IDC_STATIC86)->SetWindowText(GetResString(IDS_X_ARGOS_NICKCHANGER_SRC));
	GetDlgItem(IDC_STATIC87)->SetWindowText(GetResString(IDS_X_ARGOS_MODCHANGER_SRC));
	GetDlgItem(IDC_STATIC71)->SetWindowText(GetResString(IDS_X_ARGOS_LASTSEEN));
	GetDlgItem(IDC_STATIC75)->SetWindowText(GetResString(IDS_X_ARGOS_LASTDETECTION));
	GetDlgItem(IDC_STATIC70)->SetWindowText(GetResString(IDS_X_ARGOS_PUNISCHMENT));
	GetDlgItem(IDC_STATIC69)->SetWindowText(GetResString(IDS_X_ARGOS_COMPENSATION));
	GetDlgItem(IDC_STATIC76)->SetWindowText(GetResString(IDS_X_ARGOS_LEECHERTYPE));
	GetDlgItem(IDC_STATIC77)->SetWindowText(GetResString(IDS_X_ARGOS_COMMENT));

}

void CClientArgosInfoPage::DisableDialog(bool bDisable){
	GetDlgItem(IDC_STATIC30)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC37)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC62)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC57)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC83)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC63)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC73)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC64)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC58)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC65)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC59)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC66)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC60)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC67)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC61)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC84)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC74)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC68)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC79)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC80)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC81)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC82)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC85)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC86)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC87)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC71)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC75)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC70)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC69)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC76)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC77)->EnableWindow(!bDisable);

	GetDlgItem(IDC_DLMOD)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DLNICK)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DLOPCODE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DLHASH)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DNICKTHIEF)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DMODTHIEF)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DHASHTHIEF)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DCREDITHACK)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DHASHCHANGED)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DGHOSTMODE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DFAKECLIENT)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DAGRESSIV)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DFILESCANNER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DFILEFAKER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DBADSENDER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DRANKFLOODER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DFAILED)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DXSEXPLOIT)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DNICKCHANGER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DMODCHANGER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DSPAM)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DBADHELLO)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DBADPROT)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DLASTSEEN)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DLASTDETECTION)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DPUNISCHMENT)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DCOMPENSATION)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DTYPE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DCOMMENT)->EnableWindow(!bDisable);

	if(!bDisable)
		return;

	GetDlgItem(IDC_DLMOD)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DLNICK)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DLOPCODE)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DLHASH)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DNICKTHIEF)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DMODTHIEF)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DHASHTHIEF)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DCREDITHACK)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DHASHCHANGED)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DGHOSTMODE)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DFAKECLIENT)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DAGRESSIV)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DFILESCANNER)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DFILEFAKER)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DBADSENDER)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DRANKFLOODER)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DFAILED)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DXSEXPLOIT)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DNICKCHANGER)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DMODCHANGER)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DSPAM)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DBADHELLO)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DBADPROT)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DLASTSEEN)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_DLASTDETECTION)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_DPUNISCHMENT)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DCOMPENSATION)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_DTYPE)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_DCOMMENT)->SetWindowText(GetResString(IDS_NO));
}
#endif // ARGOS // NEO: NA END <-- Xanatos --