// EM Neo Backup
//
// License
// -------
// This code is provided "as is" with no expressed or implied warranty.
// 
// You may use this code in a non commercial open source product with 
// or without acknowledgement. You may not sell this code or any 
// modification of this code.
//
//
// Copyright (c) 2004 
// http://neomule.sourceforge.net 
// davidxanatos@lycos.at
////////////////////////////////////////////////////////////////////////

// NEO: NB - [NeoBackup] -- Xanatos -->

#pragma once

struct BackupCfg{
	bool	Enable;
	DWORD	FilesToBackup;

	bool	AutoBackup;
	DWORD	FilesToAutoRestore;

	WCHAR	BackupDir[MAX_PATH];

	bool	DoubleBackup;
	WCHAR	BackupDir2[MAX_PATH];
	bool	ExcludePartFiles;

	bool	RunTimeBackup;
	uint32	RunTimeBackupTime;
};

enum EConfigFiles{
	NullMet		= 0,
	KnownMet	= 1,
	CancelledMet = 2,
	ServerMet	= 3,
	ClientsMet	= 4,
	SourcesMet	= 5,
	FriendsMet	= 6,
	TrafficMet	= 7, 
	KnownPrefsMet = 8,  
	CommentsMet	= 9, 
};

enum ETempFiles{
	NullPartMet	= 0,
	PartMet		= 1,
	PartMetNeo	= 2, 
	PartMetSrc	= 3, 
};

#define EMB_ERROR_STATE_CORRECT			0
#define EMB_ERROR_STATE_UNRECOVERABLE	1
#define EMB_ERROR_STATE_RECOVERABLE		2

enum ETargetDir{
	Config = 0,
	Temp = 1
};

#define EMB_CFG_DAT					0x00000004L	
#define EMB_CFG_MET					0x00000008L	
#define EMB_CFG_INI					0x00000010L	

#define EMB_TMP_PART				0x00000020L	
#define EMB_TMP_PART_MET			0x00000040L	
#define EMB_TMP_PART_MET_NEO		0x00000080L	
#define EMB_TMP_PART_MET_SRC		0x00000100L	

#define EMB_CFG						0x00000100L	
#define EMB_CFG_MAIN				0x00000200L	
#define EMB_TMP						0x00000400L	

#define EMB_FILE_KNOWNMET			_T("Known.met")
#define EMB_FILE_CANCELLEDMET		_T("cancelled.met")
#define EMB_FILE_TRAFFICMET			_T("Traffic.met") 
#define EMB_FILE_KNOWNPREFSMET		_T("KnownPrefs.met") 
#define EMB_FILE_COMMENTSMET		_T("Comments.met") 
#define EMB_FILE_SERVERMET			_T("Server.met")
#define EMB_FILE_FRIENDSMET			_T("EmFriends.met")
#define EMB_FILE_CLIENTSMET			_T("Clients2.met") // Clients2.met is the format from SF
#define EMB_FILE_SOURCESMET			_T("Sourcess.met")

#define EMB_FILE_DAT				_T("*.dat")
#define EMB_FILE_MET				_T("*.met")
#define EMB_FILE_INI				_T("*.ini")

#define EMB_FILE_PART				_T("*.part")
#define EMB_FILE_PART_MET			_T("*.part.met")
#define EMB_FILE_PART_MET_NEO		_T("*.part.met.neo") 
#define EMB_FILE_PART_MET_SRC		_T("*.part.met.src") 

#define EMB_FILEEX_PART_MET			_T(".met")
#define EMB_FILEEX_PART_MET_NEO		_T(".met.neo") 
#define EMB_FILEEX_PART_MET_SRC		_T(".met.src") 

#define EMB_FILEEX_PART_NEO			_T(".neo") 
#define EMB_FILEEX_PART_SRC			_T(".src") 

#define EMB_FILEEX_BAK				_T(".bak")
#define EMB_FILEEX_BAK_OLD			_T(".old")
#define EMB_FILEEX_BAD				_T(".bad")

#define EMB_TEMP_FILE_PATH			_T("Temp")
#define EMB_CONFIG_FILE_PATH		_T("Config")

#define BACKUPINI	_T("%sbackup.ini")

#define MIN_BACKUP_TIME		MIN2MS(10)
#define DEF_BACKUP_TIME		MIN2MS(100)

class CEMBackup : public CObject
{

DECLARE_DYNCREATE(CEMBackup)

public:
	CEMBackup(void);
	~CEMBackup(void);

	void			Init();
	void			RunBackup();
	void			AutoBackup();
	void			RestoreTemp();

	BackupCfg		prefs;
	void			LoadPreferences();
	void			SavePreferences();

	int				Backup(DWORD FileTypes = NULL, bool AutoBackup = false);
	int				Restore(ETargetDir Target = Config);

	bool			RestoreFile(EConfigFiles File);
	bool			RestorePartMet(CString Path, CString FileName, ETempFiles File);
	bool			RestorePart(CString Path, CString FileName);
	void			DeleteFiles(CString Path, CString FileName); // NEO: MTD - [MultiTempDirectories]

	void			SetLastErrorState(int nState)		{m_iLastErrorState = nState;}

protected:
	CString			configdir;
	CString			appdir;

private:
	static UINT AFX_CDECL run(LPVOID lpParam);
	int				Backup2();

	int				BackupDirectory(CString SourcePath, CString BackupPath, DWORD Files = NULL, ETargetDir Target = Config);
	int				BackupDirectory(CString SourcePath, CString BackupPath, CString Files = _T("*.*"));
	int				MoveBackupDirectory(CString SourcePath, CString BackupPath, CString Files = _T("*.*"));

	int				RestoreConfigDirectory(CString TargetPath, CString BackupPath, CString Files = _T("*.*"));
	int				RestoreTempDirectory(CString TargetPath, CString BackupPath, CString Files = _T("*.*"));

	int				RestoreSingelFile(CString Path, CString FileName, int* Trys, ETargetDir Target = Config);
	int				RestoreFile(CString Path, CString FileName, CString BackupPath, ETargetDir Target = Config);

	bool			TestFile(CString OriginalFile, CString BackupFile);
	bool			CheckFile(CString File);

	int				BackupPartMetBack(CString FilePath);
	int				BackupBadMet(CString FilePath);

	int				m_iLastErrorState;

	uint32			LastBackupTime;

	bool			DoneBackup2;

	bool			BackupInProgres;
};

// NEO: NB END <-- Xanatos --