//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
/*
* Konstanten
*/

#include "opcodes.h"

#ifndef NEO_DEFAULTS
#define NEO_DEFAULTS

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
#define VAL_BC_TIME_DOWN_MIN	1
#define VAL_BC_TIME_DOWN_DEF	20
#define VAL_BC_TIME_DOWN_MAX	250	

#define VAL_BC_TIME_UP_MIN		1
#define VAL_BC_TIME_UP_DEF		10
#define VAL_BC_TIME_UP_MAX		250	

#define VAL_DOWNLOAD_BUFFER_MIN	4*1024
#define VAL_DOWNLOAD_BUFFER_DEF	65*1024
#define VAL_DOWNLOAD_BUFFER_MAX	1024*1024

#define VAL_UPLOAD_BUFFER_MIN	4*1024
#define VAL_UPLOAD_BUFFER_DEF	8*1024
#define VAL_UPLOAD_BUFFER_MAX	1024*1024

#define VAL_MAX_RESERVED_SLOTS_MIN	1
#define VAL_MAX_RESERVED_SLOTS_DEF	2
#define VAL_MAX_RESERVED_SLOTS_MAX	10

#define VAL_INCREASE_TRICKLE_SPEED_MIN	0.1F
#define VAL_INCREASE_TRICKLE_SPEED_DEF	0.5F
#define VAL_INCREASE_TRICKLE_SPEED_MAX	2.0F

#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
#define VAL_RELEASE_SLOT_SPEED_MIN	2.0F
#define VAL_RELEASE_SLOT_SPEED_DEF	5.0F
#define VAL_RELEASE_SLOT_SPEED_MAX	15.0F

#define VAL_RELEASE_BANDWIDTH_PERCENTAGE_MIN	25.0F
#define VAL_RELEASE_BANDWIDTH_PERCENTAGE_DEF	50.0F
#define VAL_RELEASE_BANDWIDTH_PERCENTAGE_MAX	75.0F

#define VAL_FRIEND_SLOT_SPEED_MIN	2.0F
#define VAL_FRIEND_SLOT_SPEED_DEF	3.0F
#define VAL_FRIEND_SLOT_SPEED_MAX	10.0F

#define VAL_FRIEND_BANDWIDTH_PERCENTAGE_MIN		10.0F
#define VAL_FRIEND_BANDWIDTH_PERCENTAGE_DEF		25.0F
#define VAL_FRIEND_BANDWIDTH_PERCENTAGE_MAX		50.0F
#endif // NEO_UBT // NEO: BM END

#define VAL_DYN_UP_GOING_UP_DIVIDER_MIN	100
#define VAL_DYN_UP_GOING_UP_DIVIDER_DEF	1000
#define VAL_DYN_UP_GOING_UP_DIVIDER_MAX	10000

#define VAL_DYN_UP_GOING_DOWN_DIVIDER_MIN	200
#define VAL_DYN_UP_GOING_DOWN_DIVIDER_DEF	2000
#define VAL_DYN_UP_GOING_DOWN_DIVIDER_MAX	20000

#define VAL_BASE_PING_UP_MIN 10
#define VAL_BASE_PING_UP_DEF 100
#define VAL_BASE_PING_UP_MAX 10000

#define VAL_PING_UP_TOLERANCE_MIN 1
#define VAL_PING_UP_TOLERANCE_DEF 12
#define VAL_PING_UP_TOLERANCE_MAX 24

#define VAL_PING_UP_PROZENT_MIN 50
#define VAL_PING_UP_PROZENT_DEF 500
#define VAL_PING_UP_PROZENT_MAX 5000

#define VAL_DYN_DOWN_GOING_UP_DIVIDER_MIN	200
#define VAL_DYN_DOWN_GOING_UP_DIVIDER_DEF	2000
#define VAL_DYN_DOWN_GOING_UP_DIVIDER_MAX	20000

#define VAL_DYN_DOWN_GOING_DOWN_DIVIDER_MIN	400
#define VAL_DYN_DOWN_GOING_DOWN_DIVIDER_DEF	4000
#define VAL_DYN_DOWN_GOING_DOWN_DIVIDER_MAX	40000

#define VAL_BASE_PING_DOWN_MIN 20
#define VAL_BASE_PING_DOWN_DEF 200
#define VAL_BASE_PING_DOWN_MAX 20000

#define VAL_PING_DOWN_TOLERANCE_MIN 1
#define VAL_PING_DOWN_TOLERANCE_DEF 12
#define VAL_PING_DOWN_TOLERANCE_MAX 24

#define VAL_PING_DOWN_PROZENT_MIN 100
#define VAL_PING_DOWN_PROZENT_DEF 1000
#define VAL_PING_DOWN_PROZENT_MAX 10000
#endif // NEO_BC // NEO: NBC END

#define TO_OLD_SOURCE_MIN		3 // In Days
#define TO_OLD_SOURCE_DEF		14 //14 days // NEO: OCF - [OnlyCompleetFiles] <-- Xanatos --
#define TO_OLD_SOURCE_MAX		30

// NEO: MOD - [NiceHash]
#define VAL_HASHING_DELAY_MIN	1
#define VAL_HASHING_DELAY_DEF	10
#define VAL_HASHING_DELAY_MAX	100
// NEO: MOD END

// NEO: MOD - [RelaxCPU]
#define VAL_PROCESSING_DELAY_MIN 3
#define VAL_PROCESSING_DELAY_DEF 10
#define VAL_PROCESSING_DELAY_MAX 30
// NEO: MOD END

// NEO: MOD - [RefreshShared]
#define TIM_REFRESH_SHARED_INTERVALS_MIN	60
#define TIM_REFRESH_SHARED_INTERVALS_DEF	120
#define TIM_REFRESH_SHARED_INTERVALS_MAX	480
// NEO: MOD END

// NEO: DKA - [DownloadKeepAlive]
#define VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_MIN	10
#define VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_DEF	20
#define VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_MAX	30
// NEO: DKA END

// NEO: TCR - [TCPConnectionRetry]
#define VAL_TCP_CON_RETRY_MIN	1
#define VAL_TCP_CON_RETRY_DEF	2
#define VAL_TCP_CON_RETRY_MAX	3
// NEO: TCR END

// NEO: NST - [NeoSourceTweaks]
#define VAL_HARD_LIMIT_MIN		100
#define VAL_HARD_LIMIT_DEF		1000
#define VAL_HARD_LIMIT_MAX		5000

#define VAL_SWAP_LIMIT_MIN		50
#define VAL_SWAP_LIMIT_DEF		MAX_SOURCES_FILE_SOFT
#define VAL_SWAP_LIMIT_MAX		VAL_SWAP_LIMIT_DEF

#define VAL_CLEANUP_LIMIT_MIN	50
#define VAL_CLEANUP_LIMIT_DEF	MAX_SOURCES_FILE_SOFT
#define VAL_CLEANUP_LIMIT_MAX	VAL_CLEANUP_LIMIT_DEF

#define VAL_XS_LIMIT_MIN		80
#define VAL_XS_LIMIT_DEF		MAX_SOURCES_FILE_SOFT
#define VAL_XS_LIMIT_MAX		VAL_XS_LIMIT_DEF

#define TIM_XS_INTERVAL_MIN		TIM_XS_INTERVAL_DEF
#define TIM_XS_INTERVAL_DEF		MS2MIN(SOURCECLIENTREASKF)
#define TIM_XS_INTERVAL_MAX		15

#define TIM_XS_CLIENT_INTERVAL_MIN		TIM_XS_CLIENT_INTERVAL_DEF
#define TIM_XS_CLIENT_INTERVAL_DEF		MS2MIN(SOURCECLIENTREASKS)
#define TIM_XS_CLIENT_INTERVAL_MAX		60

#define VAL_XS_ANSWER_LIMIT_MIN		400
#define VAL_XS_ANSWER_LIMIT_DEF		500
#define VAL_XS_ANSWER_LIMIT_MAX		1000

#define VAL_XS_DELAY_MIN		4
#define VAL_XS_DELAY_DEF		4
#define VAL_XS_DELAY_MAX		8

#define VAL_SVR_LIMIT_MIN		40
#define VAL_SVR_LIMIT_DEF		MAX_SOURCES_FILE_SOFT
#define VAL_SVR_LIMIT_MAX		VAL_SVR_LIMIT_DEF

#define TIM_SVR_INTERVAL_MIN	TIM_SVR_INTERVAL_DEF
#define TIM_SVR_INTERVAL_DEF	MS2MIN(SERVERREASKTIME)
#define TIM_SVR_INTERVAL_MAX	30


#define VAL_KAD_LIMIT_MIN		10
#define VAL_KAD_LIMIT_DEF		MAX_SOURCES_FILE_UDP
#define VAL_KAD_LIMIT_MAX		VAL_KAD_LIMIT_DEF

#define TIM_KAD_INTERVAL_MIN	TIM_KAD_INTERVAL_DEF
#define TIM_KAD_INTERVAL_DEF	MS2MIN(KADEMLIAREASKTIME)
#define TIM_KAD_INTERVAL_MAX	120

#define VAL_KAD_AMOUNT_MIN		3
#define VAL_KAD_AMOUNT_DEF		KADEMLIATOTALFILE
#define VAL_KAD_AMOUNT_MAX		VAL_KAD_AMOUNT_DEF

#define VAL_KAD_DELAY_MIN		VAL_KAD_DELAY_DEF
#define VAL_KAD_DELAY_DEF		7
#define VAL_KAD_DELAY_MAX		14

#define VAL_UDP_LIMIT_MIN		5
#define VAL_UDP_LIMIT_DEF		MAX_SOURCES_FILE_UDP
#define VAL_UDP_LIMIT_MAX		VAL_UDP_LIMIT_DEF

#define TIM_UDP_INTERVAL_MIN	TIM_UDP_INTERVAL_DEF
#define TIM_UDP_INTERVAL_DEF	MS2MIN(UDPSERVERREASKTIME)
#define TIM_UDP_INTERVAL_MAX	60

#define VAL_UDP_AMOUNT_MIN		25
#define VAL_UDP_AMOUNT_DEF		35
#define VAL_UDP_AMOUNT_MAX		62

// NEO: XUC - [ExtendedUdpCache]
#define VAL_UDP_CATCH_AMOUNT_MIN	5
#define VAL_UDP_CATCH_AMOUNT_DEF	10
#define VAL_UDP_CATCH_AMOUNT_MAX	20
// NEO: XUC END
// NEO: NST END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]

#define VAL_LAN_DOWNLOAD_BUFFER_MIN	4*1024
#define VAL_LAN_DOWNLOAD_BUFFER_DEF	512*1024
#define VAL_LAN_DOWNLOAD_BUFFER_MAX	1024*1024

#define VAL_LAN_UPLOAD_BUFFER_MIN	4*1024
#define VAL_LAN_UPLOAD_BUFFER_DEF	512*1024
#define VAL_LAN_UPLOAD_BUFFER_MAX	1024*1024

#define VAL_MAX_LAN_UPLOAD_SLOTS_MIN	10
#define VAL_MAX_LAN_UPLOAD_SLOTS_DEF	50
#define VAL_MAX_LAN_UPLOAD_SLOTS_MAX	100

#define	VAL_UPLOAD_PER_LAN_SLOTS_MIN	10
#define	VAL_UPLOAD_PER_LAN_SLOTS_DEF	100

#define TIM_AUTO_BROADCAST_LAN_FILES_MIN	1
#define TIM_AUTO_BROADCAST_LAN_FILES_DEF	5
#define TIM_AUTO_BROADCAST_LAN_FILES_MAX	15

#define TIM_LAN_INTERVAL_MIN	1
#define TIM_LAN_INTERVAL_DEF	10
#define TIM_LAN_INTERVAL_MAX	60

#define TIM_REASK_LAN_MIN		1
#define TIM_REASK_LAN_DEF		3
#define TIM_REASK_LAN_MAX		10

#define TIM_REASK_NNP_LAN_MIN	10
#define TIM_REASK_NNP_LAN_DEF	30
#define TIM_REASK_NNP_LAN_MAX	120
#endif //LANCAST // NEO: NLC END

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
#define	TIM_VOODOO_SEARCH_MIN	10
#define	TIM_VOODOO_SEARCH_DEF	60
#define	TIM_VOODOO_SEARCH_MAX	180
#endif // VOODOO // NEO: VOODOO END

// NEO: IPS - [InteligentPartSharing]
#define TIM_IPS_TIMER_MIN	10
#define TIM_IPS_TIMER_DEF	60
#define TIM_IPS_TIMER_MAX	120

#define VAL_IPS_MAX_MIN		1
#define VAL_IPS_MAX_DEF		75
#define VAL_IPS_MAX_MAX		100

#define VAL_IPS_OA_MIN1		1.10F
#define VAL_IPS_OA_DEF1		2.0F
#define VAL_IPS_OA_MAX1		20.0F

#define VAL_IPS_OA_MIN2		1.0F
#define VAL_IPS_OA_DEF2		5.0F
#define VAL_IPS_OA_MAX2		30.0F

#define VAL_IPS_OS_MIN1		1.1F
#define VAL_IPS_OS_DEF1		4.0F
#define VAL_IPS_OS_MAX1		20.0F

#define VAL_IPS_OS_MIN2		1.0F
#define VAL_IPS_OS_DEF2		5.0F
#define VAL_IPS_OS_MAX2		30.0F

#define VAL_IPS_UA_MIN1		1.1F
#define VAL_IPS_UA_DEF1		2.0F
#define VAL_IPS_UA_MAX1		10.0F

#define VAL_IPS_UA_MIN2		1.0F
#define VAL_IPS_UA_DEF2		5.0F
#define VAL_IPS_UA_MAX2		20.0F

#define VAL_IPS_OAF_MIN		1.5F
#define VAL_IPS_OAF_DEF		3.0F
#define VAL_IPS_OAF_MAX		10.0F

#define VAL_IPS_OSF_MIN		1.5F
#define VAL_IPS_OSF_DEF		3.0F
#define VAL_IPS_OSF_MAX		10.0F

#define VAL_SHOW_ALWAYS_PARTS_MIN	1
#define VAL_SHOW_ALWAYS_PARTS_DEF	2
#define VAL_SHOW_ALWAYS_PARTS_MAX	10
// NEO: IPS END

#ifdef ARGOS // NEO: NA - [NeoArgos]
#define TIM_ARGOS_TRUST_TIME_MIN		240
#define TIM_ARGOS_TRUST_TIME_DEF		360
#define TIM_ARGOS_TRUST_TIME_MAX		480

#define TIM_ARGOS_BAN_TIME_MIN			30
#define TIM_ARGOS_BAN_TIME_DEF			60
#define TIM_ARGOS_BAN_TIME_MAX			180

#define TIM_ARGOS_TRACK_TIME_MIN		60
#define TIM_ARGOS_TRACK_TIME_DEF		120
#define TIM_ARGOS_TRACK_TIME_MAX		720

#define TIM_ARGOS_GENERIC_BAN_TIME_MIN	60
#define TIM_ARGOS_GENERIC_BAN_TIME_DEF	120
#define TIM_ARGOS_GENERIC_BAN_TIME_MAX	240

#define TIM_ARGOS_BAN_BAD_TIME_MIN		60
#define TIM_ARGOS_BAN_TIME_CORRUPT_DEF	180
#define TIM_ARGOS_BAN_TIME_SCANNER_DEF	120
#define	TIM_ARGOS_BAN_TIME_FAILED_DEF	240
#define TIM_ARGOS_BAN_BAD_TIME_MAX		720

#define TIM_ARGOS_AGRESSION_INTERVALS_MIN	1
#define TIM_ARGOS_AGRESSION_INTERVALS_DEF	10
#define TIM_ARGOS_AGRESSION_INTERVALS_MAX	15

#define VAL_ARGOS_AGRESSION_THRESHOLD_MIN	2
#define VAL_ARGOS_AGRESSION_THRESHOLD_DEF	3
#define VAL_ARGOS_AGRESSION_THRESHOLD_MAX	5

#define VAL_ARGOS_FAILED_TRIES_MIN		2
#define VAL_ARGOS_FAILED_TRIES_DEF		3
#define VAL_ARGOS_FAILED_TRIES_MAX		5

#define VAL_ARGOS_FAILED_THRESHOLD_MIN	1
#define VAL_ARGOS_FAILED_THRESHOLD_DEF	12
#define VAL_ARGOS_FAILED_THRESHOLD_MAX	20

#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_MIN	10
#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_DEF	30
#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_MAX	30

#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MIN	2
#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_DEF	3
#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MAX	5

#define TIM_ARGOS_NICK_CHANGE_INTERVALS_MIN	60
#define TIM_ARGOS_NICK_CHANGE_INTERVALS_DEF	180
#define TIM_ARGOS_NICK_CHANGE_INTERVALS_MAX	180

#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_MIN	2
#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_DEF	3
#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_MAX	5

#define TIM_ARGOS_MOD_CHANGE_INTERVALS_MIN	30
#define TIM_ARGOS_MOD_CHANGE_INTERVALS_DEF	30
#define TIM_ARGOS_MOD_CHANGE_INTERVALS_MAX	60

#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_MIN	2
#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_DEF	4
#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_MAX	5

#endif // ARGOS // NEO: NA END

#define VAL_RARE_FILE_MIN	15
#define VAL_RARE_FILE_DEF	50
#define VAL_RARE_FILE_MAX	50

// NEO: SR - [SpreadReask]
#define	VAL_SPREAD_REASK_MIN 1
#define	VAL_SPREAD_REASK_DEF 2
#define	VAL_SPREAD_REASK_MAX 5
// NEO: SR END

// NEO: OCC - [ObelixConnectionControl]
#define	VAL_OCC_MIN			50
#define VAL_OCC_DEF			75
#define VAL_OCC_MAX			90
// NEO: OCC END

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
#define VAL_CON_CTRL_MIN	1.0F
#define VAL_CON_CTRL_DEF	2.0F
#define VAL_CON_CTRL_MAX	10.0F
#endif // NEO_BC // NEO: NBC END

// NEO: ASL - [AutoSoftLock]
#define VAL_ASL_MIN			10
#define VAL_ASL_DEF			100
#define VAL_ASL_MAX			200
// NEO: ASL END

// NEO: AHL - [AutoHardLimit]
#define TIM_AHL_MIN			100
#define TIM_AHL_DEF			300
#define TIM_AHL_MAX			600

#define VAL_AHL_MIN_SRC_MIN	50
#define VAL_AHL_MIN_SRC_DEF	200
#define VAL_AHL_MIN_SRC_MAX	2000

#define VAL_AHL_GLOBAL_SRC_MIN 1000
#define VAL_AHL_GLOBAL_SRC_DEF 10000
#define VAL_AHL_GLOBAL_SRC_MAX 50000	
// NEO: AHL END

// NEO: XSC - [ExtremeSourceCache]
#define VAL_SOURCE_CACHE_LIMIT_MIN	100
#define VAL_SOURCE_CACHE_LIMIT_DEF	200
#define VAL_SOURCE_CACHE_LIMIT_MAX	400

#define TIM_SOURCE_CACHE_TIME_MIN	10
#define TIM_SOURCE_CACHE_TIME_DEF	20
#define TIM_SOURCE_CACHE_TIME_MAX	40
// NEO: XSC END

// NEO: DR - [DownloadReask]
#define MAN_REQUESTTIME		29

#define TIM_REASK_MIN		TIM_REASK_DEF
#define TIM_REASK_DEF		29
#define TIM_REASK_MAX		58

#define TIM_REASK_NNP_MIN	TIM_REASK_NNP_DEF
#define TIM_REASK_NNP_DEF	58
#define TIM_REASK_NNP_MAX	87

#define TIM_REASK_FULLQ_MIN	TIM_REASK_FULLQ_DEF
#define TIM_REASK_FULLQ_DEF	29
#define TIM_REASK_FULLQ_MAX	39
// NEO: DR END

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
#define TIM_AUTO_SAVE_SOURCES_INTERVALS_MIN		20
#define TIM_AUTO_SAVE_SOURCES_INTERVALS_DEF		120
#define TIM_AUTO_SAVE_SOURCES_INTERVALS_MAX		240

#define SOURCE_STORAGE_LIMIT_MIN	25
#define SOURCE_STORAGE_LIMIT_DEF	1000
#define SOURCE_STORAGE_LIMIT_MAX	5000

#define STORAGE_BOOTSTRAP_TIME_MIN	1
#define STORAGE_BOOTSTRAP_TIME_DEF	3
#define STORAGE_BOOTSTRAP_TIME_MAX	5

#define STORAGE_BOOTSTRAP_REQUIREMENT_MIN	1
#define STORAGE_BOOTSTRAP_REQUIREMENT_DEF	50
#define STORAGE_BOOTSTRAP_REQUIREMENT_MAX	100

#define AUTO_REASK_STORED_SOURCES_LIMIT_MIN	10
#define AUTO_REASK_STORED_SOURCES_LIMIT_DEF	100
#define AUTO_REASK_STORED_SOURCES_LIMIT_MAX	250
#define	AUTO_REASK_STORED_SOURCES_LIMIT_RAW	25 // when the analyser is disabled we need a very low limit to prevent harmfule side efects

#define AUTO_REASK_STORED_SOURCES_DELAY_MIN	1 //Min
#define AUTO_REASK_STORED_SOURCES_DELAY_DEF 3
#define AUTO_REASK_STORED_SOURCES_DELAY_MAX 15

#define AUTO_REASK_LOADED_SOURCES_DELAY_MIN	1 //Sec
#define AUTO_REASK_LOADED_SOURCES_DELAY_DEF 10
#define AUTO_REASK_LOADED_SOURCES_DELAY_MAX MIN2S(2)

#define GROUP_INTERVALS_MIN 10  //Sec
#define GROUP_INTERVALS_DEF 20
#define GROUP_INTERVALS_MAX	MIN2S(1)

#define GROUP_SIZE_MIN 3
#define GROUP_SIZE_DEF 10
#define GROUP_SIZE_MAX 100

#define OUTOFDATE_MAXFAILS_MIN	1
#define OUTOFDATE_MAXFAILS_DEF	1
#define OUTOFDATE_MAXFAILS_MAX	3

#define OUTOFDATE_MAXTIME_MIN	1 // Days
#define OUTOFDATE_MAXTIME_DEF	1
#define OUTOFDATE_MAXTIME_MAX	2
#endif // NEO_SS // NEO: NSS END

#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
#define TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_MIN 10
#define TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_DEF 30
#define TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_MAX 100

#define TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_MIN	1
#define TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_DEF	24
#define TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_MAX	360

#define TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_MIN	3
#define TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_DEF	10
#define TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_MAX	30

#define TIM_SOURCE_HASH_MONITOR_BAD_TIME_MIN	3
#define TIM_SOURCE_HASH_MONITOR_BAD_TIME_DEF	10
#define TIM_SOURCE_HASH_MONITOR_BAD_TIME_MAX	20

#define SOURCE_HASH_MONITOR_MAX_BAD_MIN		2
#define SOURCE_HASH_MONITOR_MAX_BAD_DEF		3
#define SOURCE_HASH_MONITOR_MAX_BAD_MAX		4

#define TABLE_AMOUT_TO_STORE_MIN	20
#define TABLE_AMOUT_TO_STORE_DEF	50
#define TABLE_AMOUT_TO_STORE_MAX	100

#define IGNORE_UNREACHABLE_INTERVAL_MIN 30	// Min
#define IGNORE_UNREACHABLE_INTERVAL_DEF 60
#define IGNORE_UNREACHABLE_INTERVAL_MAX 180

#define IGNORE_UNDEFINED_INTERVAL_MIN 30	// Min
#define IGNORE_UNDEFINED_INTERVAL_DEF 120
#define IGNORE_UNDEFINED_INTERVAL_MAX 250

#define BEGIN_NEW_TABLE_INTERVAL_MIN 2 // Hr
#define BEGIN_NEW_TABLE_INTERVAL_DEF 3
#define BEGIN_NEW_TABLE_INTERVAL_MAX 4
#endif // NEO_CD // NEO: NCD END

#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
#define ANALISIS_INTERVALS_MIN	2 // Hr
#define ANALISIS_INTERVALS_DEF	6
#define ANALISIS_INTERVALS_MAX	24

#define TABLE_AMOUT_TO_ANALISE_MIN	10
#define TABLE_AMOUT_TO_ANALISE_DEF	25
#define TABLE_AMOUT_TO_ANALISE_MAX	50

#define VAL_ENHANCED_FACTOR_MIN	0.8F
#define VAL_ENHANCED_FACTOR_DEF	2.0F
#define VAL_ENHANCED_FACTOR_MAX	4.0F

#define REASK_PROPABILITY_MIN 1 //25 //1 // %
#define REASK_PROPABILITY_DEF 10 //50 //10
#define REASK_PROPABILITY_MAX 50 //75 //25

#define RESERVE_PROPABILITY_MIN	-30 //5 //-30 // %
#define RESERVE_PROPABILITY_DEF	-20 //10 //-20
#define RESERVE_PROPABILITY_MAX	20 //10

#define RESERVE_REASK_PROPABILITY_MIN -20 //10 //-20 // %
#define RESERVE_REASK_PROPABILITY_DEF -10 //25 //-10
#define RESERVE_REASK_PROPABILITY_MAX 30 //50 //10

#define RESERVE_REASK_DELAY_MIN	3 // Min
#define RESERVE_REASK_DELAY_DEF	10
#define RESERVE_REASK_DELAY_MAX	20

#define RESERVE_REASK_LIMIT_MIN	5
#define RESERVE_REASK_LIMIT_DEF	10
#define RESERVE_REASK_LIMIT_MAX	25

#define TEMPORARY_REASK_PROPABILITY_MIN	10 //50 //10	// %
#define TEMPORARY_REASK_PROPABILITY_DEF 20 //75 //25
#define TEMPORARY_REASK_PROPABILITY_MAX	50 //90 //50

#define TEMPORARY_REASK_DELAY_MIN 3	// Min
#define TEMPORARY_REASK_DELAY_DEF 10
#define TEMPORARY_REASK_DELAY_MAX 20

#define TEMPORARY_REASK_LIMIT_MIN 5
#define TEMPORARY_REASK_LIMIT_DEF 10
#define TEMPORARY_REASK_LIMIT_MAX 50

//#define MIN_ANALISIS_QUALITY_MIN	1
//#define MIN_ANALISIS_QUALITY_DEF	3
//#define MIN_ANALISIS_QUALITY_MAX	7

//#define UNSURE_REASK_DELAY_MIN	5
//#define UNSURE_REASK_DELAY_DEF	15
//#define UNSURE_REASK_DELAY_MAX	25

//#define UNSURE_REASK_LIMIT_MIN	5
//#define UNSURE_REASK_LIMIT_DEF	10
//#define UNSURE_REASK_LIMIT_MAX	25

#define UNPREDICTED_PROPABILITY_MIN	40 //50 //25 // %
#define UNPREDICTED_PROPABILITY_DEF	50 //75 //50
#define UNPREDICTED_PROPABILITY_MAX	75 //90 //75

#define UNPREDICTED_REASK_DELAY_MIN	5
#define UNPREDICTED_REASK_DELAY_DEF	15
#define UNPREDICTED_REASK_DELAY_MAX	25

#define UNPREDICTED_REASK_LIMIT_MIN	5
#define UNPREDICTED_REASK_LIMIT_DEF	10
#define UNPREDICTED_REASK_LIMIT_MAX	25

#define FAIL_TOLERANCE_MIN	1
#define FAIL_TOLERANCE_DEF	2
#define FAIL_TOLERANCE_MAX	4

#define RETRY_UNREAHABLE_INTERVALS_MIN	60 // Min
#define RETRY_UNREAHABLE_INTERVALS_DEF	120
#define RETRY_UNREAHABLE_INTERVALS_MAX	480

#define	UNREACHABLE_REASK_PROPABILITY_MIN 50 //50 //25 // %
#define UNREACHABLE_REASK_PROPABILITY_DEF 80 //75 //50
#define UNREACHABLE_REASK_PROPABILITY_MAX 95 //90 //75

#define	UNREACHABLE_REASK_LIMIT_MIN	3
#define	UNREACHABLE_REASK_LIMIT_DEF	25
#define	UNREACHABLE_REASK_LIMIT_MAX	50

#define PRIORITY_GAP_RATIO_MIN	0.7F
#define PRIORITY_GAP_RATIO_DEF	0.6F
#define PRIORITY_GAP_RATIO_MAX  0.5F

#define MAX_GAP_SIZE_MIN	1
#define MAX_GAP_SIZE_DEF	2
#define MAX_GAP_SIZE_MAX	4

#define MAX_GAP_TIME_MIN	2 // Hr
#define MAX_GAP_TIME_DEF	6
#define MAX_GAP_TIME_MAX	12

#define PRIORITY_IP_RATIO_MIN	0.01F
#define PRIORITY_IP_RATIO_DEF	0.1F
#define PRIORITY_IP_RATIO_MAX	0.4F

#define PORT_INTEGRITY_RATIO_MIN	0.01F
#define PORT_INTEGRITY_RATIO_DEF	0.1F
#define PORT_INTEGRITY_RATIO_MAX	0.4F

#define MAX_MIDLE_DISCREPANCE_HIGH_MIN	2.0F
#define MAX_MIDLE_DISCREPANCE_HIGH_DEF	4.0F
#define MAX_MIDLE_DISCREPANCE_HIGH_MAX	5.0F

#define MAX_MIDLE_DISCREPANCE_LOW_MIN	1.5F
#define MAX_MIDLE_DISCREPANCE_LOW_DEF	2.0F
#define MAX_MIDLE_DISCREPANCE_LOW_MAX	3.0F

#define LAST_SEEN_DURATION_THRESHOLD_MIN	1
#define LAST_SEEN_DURATION_THRESHOLD_DEF	3
#define LAST_SEEN_DURATION_THRESHOLD_MAX	4

#define LINK_TIME_THRESHOLD_MIN	30
#define LINK_TIME_THRESHOLD_DEF	60
#define LINK_TIME_THRESHOLD_MAX	120

#define DUAL_LINKED_TABLE_GRAVITY_MIN	2
#define DUAL_LINKED_TABLE_GRAVITY_DEF	2
#define DUAL_LINKED_TABLE_GRAVITY_MAX	4

#define MAX_RELIABLE_TIME_MIN	12
#define MAX_RELIABLE_TIME_DEF	18
#define MAX_RELIABLE_TIME_MAX	24

#define TEMPORAL_IP_BORDERLINE_MIN	6 // Hr
#define TEMPORAL_IP_BORDERLINE_DEF	24
#define TEMPORAL_IP_BORDERLINE_MAX	48

#define MAX_FAILD_COUNT_MIN	1
#define MAX_FAILD_COUNT_DEF	2
#define MAX_FAILD_COUNT_MAX	4
#endif // NEO_SA // NEO: NSA END

// NEO: DS - [DropSources]
#define TIM_DROP_MIN		30
#define TIM_DROP_DEF		60
#define TIM_DROP_MAX		180

#define VAL_DROP_LIMIT_MIN(mode)	((mode == 2) ? 25 : ((mode == 3) ? 10 : 100))
#define VAL_DROP_LIMIT_DEF(mode)	((mode == 2) ? 50 : ((mode == 3) ? 40 : 400))
#define VAL_DROP_LIMIT_MAX(mode)	((mode == 2) ? 75 : ((mode == 3) ? 50 : 500))

#define VAL_CLEAN_LIMIT_MIN(mode)	((mode == 2) ? 10 : ((mode == 3) ? 3 : 10))
#define VAL_CLEAN_LIMIT_DEF(mode)	((mode == 2) ? 75 : ((mode == 3) ? 10 : 40))
#define VAL_CLEAN_LIMIT_MAX(mode)	((mode == 2) ? 50 : ((mode == 3) ? 200 : 500))

#define VAL_DROP_HQ_VALUE_MIN 1000
#define VAL_DROP_HQ_VALUE_DEF 4000
#define VAL_DROP_HQ_VALUE_MAX 5000

#define VAL_DONT_ASK_THIS_IP_TIME_MIN	30
#define VAL_DONT_ASK_THIS_IP_TIME_DEF	60
#define VAL_DONT_ASK_THIS_IP_TIME_MAX	180
// NEO: DS END

// NEO: NSD - [NeoSourceDrop]
#define VAL_CLEANUP_TIME_MIN		3

#define VAL_CLEANUP_TIME_DEF_L2L	300
#define VAL_CLEANUP_TIME_DEF_BAD	30
#define VAL_CLEANUP_TIME_DEF_GON	200
#define	VAL_CLEANUP_TIME_DEF_SSP	900
#define VAL_CLEANUP_TIME_DEF_NNP	400
#define VAL_CLEANUP_TIME_DEF_FLQ	600

#define VAL_CLEANUP_TIME_MAX		1000
// NEO: NSD END

// NEO: NCAP - [NeoCustomAutoPriority]
#define VAL_LOW_DOWN_PRIO_THRESHOLD_MIN		20
#define VAL_LOW_DOWN_PRIO_THRESHOLD_DEF		100
#define VAL_LOW_DOWN_PRIO_THRESHOLD_MAX		400

#define VAL_HIGH_DOWN_PRIO_THRESHOLD_MIN	1
#define VAL_HIGH_DOWN_PRIO_THRESHOLD_DEF	20
#define VAL_HIGH_DOWN_PRIO_THRESHOLD_MAX	100
// NEO: NCAP END

#define VAL_MAX_UL_SLOTS_MIN	4
#define VAL_MAX_UL_SLOTS_DEF	250
#define VAL_MAX_UL_SLOTS_MAX	250

#define VAL_MIN_UL_SLOTS_MIN	2
#define VAL_MIN_UL_SLOTS_DEF	2
#define VAL_MIN_UL_SLOTS_MAX	20

#define VAL_UL_PER_SLOTS_MIN	2.0F
#define VAL_UL_PER_SLOTS_DEF	3.0F
#define VAL_UL_PER_SLOTS_MAX	10.0F

// NEO: QS - [QuickStart]
#define TIM_QUICK_START_MIN		3
#define TIM_QUICK_START_DEF		15
#define TIM_QUICK_START_MAX		30

#define VAL_QUICK_START_PF_MIN	10
#define VAL_QUICK_START_PF_DEF	30
#define VAL_QUICK_START_PF_MAX	180
// NEO: QS END

// NEO: RIC - [ReaskOnIDChange]
#define TIM_RECHECK_KAD_FIREWALLED_MIN	2
#define TIM_RECHECK_KAD_FIREWALLED_DEF	15
#define TIM_RECHECK_KAD_FIREWALLED_MAX	30
// NEO: RIC END

// NEO: RLD - [ReconnectOnLowID]
#define VAL_RECONNECT_ON_LOWID_TRYS_MIN 1
#define VAL_RECONNECT_ON_LOWID_TRYS_DEF 3
#define VAL_RECONNECT_ON_LOWID_TRYS_MAX 5
// NEO: RLD END

// NEO: TQ - [TweakUploadQueue]
#define VAL_QUEUE_OVERFLOW_MIN		1
#define VAL_QUEUE_OVERFLOW_DEF		25
#define VAL_QUEUE_OVERFLOW_MAX		100
// NEO: TQ END

// NEO: NMFS - [NiceMultiFriendSlots]
#define	VAL_FRIEND_SLOT_LIMIT_MIN 1
#define VAL_FRIEND_SLOT_LIMIT_DEF 2
#define VAL_FRIEND_SLOT_LIMIT_MAX 10
// NEO: NMFS END

// NEO: RT - [ReleaseTweaks]
#define VAL_RELEASE_LEVEL_MIN	2
#define VAL_RELEASE_LEVEL_DEF	10
#define VAL_RELEASE_LEVEL_MAX	200

#define VAL_RELEASE_LIMIT_MIN	100
#define VAL_RELEASE_LIMIT_DEF	200
#define VAL_RELEASE_LIMIT_MAX	1000

#define VAL_SOURCE_LIMIT_MIN	1
#define VAL_SOURCE_LIMIT_DEF	100
#define VAL_SOURCE_LIMIT_MAX	400

#define VAL_RELEASE_CLIMIT_MIN	1
#define VAL_RELEASE_CLIMIT_DEF	50
#define VAL_RELEASE_CLIMIT_MAX	200

#define VAL_RELEASE_CL_MIN		1
#define VAL_RELEASE_CL_DEF		3
#define VAL_RELEASE_CL_MAX		10

#define	VAL_RELEASE_SLOT_LIMIT_MIN 1
#define VAL_RELEASE_SLOT_LIMIT_DEF 2
#define VAL_RELEASE_SLOT_LIMIT_MAX 50
// NEO: RT END

// NEO: NCAP - [NeoCustomAutoPriority]
#define VAL_DYNAMIC_PRIORITY_FACTOR_MIN	1.0F
#define VAL_DYNAMIC_PRIORITY_FACTOR_DEF	2.0F
#define VAL_DYNAMIC_PRIORITY_FACTOR_MAX	3.0F

#define VAL_LOW_UP_PRIO_THRESHOLD_MIN	10
#define VAL_LOW_UP_PRIO_THRESHOLD_DEF	20
#define VAL_LOW_UP_PRIO_THRESHOLD_MAX	200

#define VAL_HIGH_UP_PRIO_THRESHOLD_MIN	1
#define VAL_HIGH_UP_PRIO_THRESHOLD_DEF	1
#define VAL_HIGH_UP_PRIO_THRESHOLD_MAX	50
// NEO: NCAP END

// NEO: PRSF - [PushSmallRareFiles]
#define VAL_PUSH_SMALL_FILES_SIZE_MIN	1
#define VAL_PUSH_SMALL_FILES_SIZE_DEF	9
#define VAL_PUSH_SMALL_FILES_SIZE_MAX	18

#define VAL_PUSH_RARE_FILES_VALUE_MIN	4
#define VAL_PUSH_RARE_FILES_VALUE_DEF	10
#define VAL_PUSH_RARE_FILES_VALUE_MAX	25

#define VAL_PUSH_RATIO_FILES_VALUE_MIN	2
#define VAL_PUSH_RATIO_FILES_VALUE_DEF	10
#define VAL_PUSH_RATIO_FILES_VALUE_MAX	20
// NEO: PRSF END

// NEO: FDC - [FileNameDisparityCheck]
#define VAL_FILE_CHECK_SENSITIVITY_MIN	6
#define VAL_FILE_CHECK_SENSITIVITY_DEF	19
#define VAL_FILE_CHECK_SENSITIVITY_MAX	30

#define VAL_FILE_CHECK_THRESHOLD_MIN	10
#define VAL_FILE_CHECK_THRESHOLD_DEF	50
#define VAL_FILE_CHECK_THRESHOLD_MAX	75

#define VAL_FILE_CHECK_AMOUNT_MIN		1
#define VAL_FILE_CHECK_AMOUNT_DEF		5
#define VAL_FILE_CHECK_AMOUNT_MAX		100
// NEO: FDC END

// NEO: NATS - [NatSupport]
#define VAL_NAT_PORT_REFRESH_IVTERVAL_MIN	0.5F // a half minute
#define VAL_NAT_PORT_REFRESH_IVTERVAL_MAX	1.0F // one minute
#define VAL_NAT_PORT_REFRESH_IVTERVAL_DEF	3.0F // three minutes

#define VAL_NAT_PORT_MAX_LATENCY_TIME_MIN	5 // sec
#define VAL_NAT_PORT_MAX_LATENCY_TIME_MAX	10
#define VAL_NAT_PORT_MAX_LATENCY_TIME_DEF	20

#define VAL_NAT_PORT_MAX_FAILS_MIN			2
#define VAL_NAT_PORT_MAX_FAILS_MAX			3
#define VAL_NAT_PORT_MAX_FAILS_DEF			5
// NEO: NATS END

// NEO: MM - [NeoMiniMule]
#define DEF_MINIMULE_LABEL	_T("%sn%n%id [%fw]%n%nActive Uploads: %au        Active Download: %ad%nUpload: %us(%uo) | Download: %ds(%do)%n Neo Mule")
// NEO: MM END

#define DEF_MSG_FILTER		_T("Your client has an infinite queue|Your client is connecting too fast|fastest download speed|ZamBoR|DI-Emule|Join the L33cher|eMule FX|FXeMule|Ketamine|robot from RIAA") // NEO: NA - [NeoArgos]

#define DEF_FUNNYNICK_FILTER _T("http://|0.4|www.|Li()Network.Net eMule v|emule|[CHN][VeryCD]yourname|0.44b [emule.de v16 webcache]")
#define DEF_FUNNYNICK_SYMBOL _T(":) ")

#endif NEO_DEFAULTS

// NEO: NCFG END <-- Xanatos --