// PPgUpdate.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgUpdate.h"
#include "emuleDlg.h"
#include "OtherFunctions.h"
#include "serverWnd.h"
#include "Neo/GUI/Fakecheck.h" // NEO: FC - [FakeCheck]
#include "IPFilter.h"
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
#include "Neo/GUI/IP2Country.h"
#endif // IP2COUNTRY // NEO: IP2C END
#ifdef ARGOS // NEO: NA - [NeoArgos]
#include "Neo/Argos.h"
#endif // ARGOS // NEO: NA END
#include "Neo/Functions.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#endif

// CPPgMorph dialog

// NEO: AU - [AutoUpdate]  -- Xanatos -->

IMPLEMENT_DYNAMIC(CPPgUpdate, CPropertyPage)
CPPgUpdate::CPPgUpdate()
: CPropertyPage(CPPgUpdate::IDD)
{
}

CPPgUpdate::~CPPgUpdate()
{
}

void CPPgUpdate::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgUpdate, CPropertyPage)
	// NEO: FC - [FakeCheck]
	ON_BN_CLICKED(IDC_UPDATEFAKELISTSTART, OnSettingsChange)
	ON_BN_CLICKED(IDC_RESETFAKESURL, OnBnClickedResetfakes)
	ON_BN_CLICKED(IDC_UPDATEFAKES, OnBnClickedUpdatefakes)
	ON_EN_CHANGE(IDC_UPDATE_URL_FAKELIST, OnSettingsChange)
	// NEO: FC END

	ON_EN_CHANGE(IDC_UPDATE_URL_IPFILTER, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATEIPFURL, OnBnClickedUpdateipfurl)
	ON_BN_CLICKED(IDC_RESETIPFURL, OnBnClickedResetipfurl)
	ON_BN_CLICKED(IDC_AUTOUPIPFILTER , OnSettingsChange)

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	ON_EN_CHANGE(IDC_UPDATE_URL_IP2COUNTRY, OnSettingsChange)
    ON_BN_CLICKED(IDC_UPDATEIPCURL, OnBnClickedUpdateipcurl)
	ON_BN_CLICKED(IDC_RESETIPCURL, OnBnClickedResetipcurl)
	ON_BN_CLICKED(IDC_AUTOUPIP2COUNTRY , OnSettingsChange)
#endif // IP2COUNTRY // NEO: IP2C END

#ifdef ARGOS // NEO: NA - [NeoArgos]
	ON_EN_CHANGE(IDC_UPDATE_URL_LEECHERSDAT, OnSettingsChange)
    ON_BN_CLICKED(IDC_UPDATELLURL, OnBnClickedUpdatellurl)
	ON_BN_CLICKED(IDC_RESETLLURL, OnBnClickedResetllurl)
	ON_BN_CLICKED(IDC_AUTOUPLEECHERSDAT , OnSettingsChange)
#endif // ARGOS // NEO: NA END

	ON_BN_CLICKED(IDC_RUNTIMEUPDATE, OnSettingsChange)
	ON_EN_CHANGE(IDC_RUNTIMEUPDATE_TIME, OnSettingsChange)
END_MESSAGE_MAP()


// CPPgMorph message handlers

BOOL CPPgUpdate::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void SysTimeToStr(LPSYSTEMTIME st, LPTSTR str)
{
	TCHAR sDate[15];
	sDate[0] = _T('\0');
	GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, st, NULL, sDate, 100);
	TCHAR sTime[15];
	sTime[0] = _T('\0');
	GetTimeFormat(LOCALE_USER_DEFAULT, 0, st, NULL ,sTime ,100);
	_stprintf(str, _T("%s %s"), sDate, sTime);
}

void CPPgUpdate::LoadSettings(void)
{
	GetDlgItem(IDC_RUNTIMEUPDATE_TIME)->SetWindowText(StrLine(_T("%i"),thePrefs.m_iRuntimeUpdateIntervals));
	if(thePrefs.m_bAutoRuntimeUpdate)
		CheckDlgButton(IDC_RUNTIMEUPDATE,1);
	else
		CheckDlgButton(IDC_RUNTIMEUPDATE,0);

	// NEO: FC - [FakeCheck]
	GetDlgItem(IDC_UPDATE_URL_FAKELIST)->SetWindowText(thePrefs.m_sUpdateURLFakeList);
	if(thePrefs.m_bUpdateFakeStartup)
		CheckDlgButton(IDC_UPDATEFAKELISTSTART,1);
	else
		CheckDlgButton(IDC_UPDATEFAKELISTSTART,0);
	// NEO: FC END

	GetDlgItem(IDC_UPDATE_URL_IPFILTER)->SetWindowText(thePrefs.m_sUpdateURLIPFilter);
	if(thePrefs.m_bAutoUpdateIPFilter)
		CheckDlgButton(IDC_AUTOUPIPFILTER,1);
	else
		CheckDlgButton(IDC_AUTOUPIPFILTER,0);

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	GetDlgItem(IDC_UPDATE_URL_IP2COUNTRY)->SetWindowText(thePrefs.m_sUpdateURLIP2Country);
	if(thePrefs.m_bAutoUpdateIP2Country)
		CheckDlgButton(IDC_AUTOUPIP2COUNTRY,1);
	else
		CheckDlgButton(IDC_AUTOUPIP2COUNTRY,0);
#endif // IP2COUNTRY // NEO: IP2C END

#ifdef ARGOS // NEO: NA - [NeoArgos]
	GetDlgItem(IDC_UPDATE_URL_LEECHERSDAT)->SetWindowText(thePrefs.m_sUpdateURLLeechersList);
	if(thePrefs.m_bUpdateLeechersStartup)
		CheckDlgButton(IDC_AUTOUPLEECHERSDAT,1);
	else
		CheckDlgButton(IDC_AUTOUPLEECHERSDAT,0);
#endif // ARGOS // NEO: NA END

	// NEO: FC - [FakeCheck]
	TCHAR sTime[30];
	sTime[0] = _T('\0');
	SysTimeToStr(thePrefs.GetIP2CountryVersion(), sTime);
	GetDlgItem(IDC_IP2COUNTRY_VERSION)->SetWindowText(sTime);
	// NEO: FC END

	sTime[0] = _T('\0');
	SysTimeToStr(thePrefs.GetFakesVersion(), sTime);
	GetDlgItem(IDC_FAKELIST_VERSION)->SetWindowText(sTime);
	
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	sTime[0] = _T('\0');
	SysTimeToStr(thePrefs.GetIPFilterVersion(), sTime);
	GetDlgItem(IDC_IPFILTER_VERSION)->SetWindowText(sTime);
#endif // IP2COUNTRY // NEO: IP2C END

#ifdef ARGOS // NEO: NA - [NeoArgos]
	sTime[0] = _T('\0');
	SysTimeToStr(thePrefs.GetIPFilterVersion(), sTime);
	GetDlgItem(IDC_LEECHERLIST_VERSION)->SetWindowText(sTime);
#endif // ARGOS // NEO: NA END
}

BOOL CPPgUpdate::OnApply()
{

	CString buffer;
	
	GetDlgItem(IDC_RUNTIMEUPDATE_TIME)->GetWindowText(buffer);
	thePrefs.m_iRuntimeUpdateIntervals = min(_tstoi(buffer),3);
	thePrefs.m_bAutoRuntimeUpdate = IsDlgButtonChecked(IDC_RUNTIMEUPDATE)!=0;

	// NEO: FC - [FakeCheck]
	GetDlgItem(IDC_UPDATE_URL_FAKELIST)->GetWindowText(buffer);
	_tcscpy(thePrefs.m_sUpdateURLFakeList, buffer);
	thePrefs.m_bUpdateFakeStartup = IsDlgButtonChecked(IDC_UPDATEFAKELISTSTART)!=0;
	// NEO: FC END

	
	GetDlgItem(IDC_UPDATE_URL_IPFILTER)->GetWindowText(buffer);
	_tcscpy(thePrefs.m_sUpdateURLIPFilter, buffer);
	thePrefs.m_bAutoUpdateIPFilter = IsDlgButtonChecked(IDC_AUTOUPIPFILTER)!=0;
	

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
    GetDlgItem(IDC_UPDATE_URL_IP2COUNTRY)->GetWindowText(buffer);
	_tcscpy(thePrefs.m_sUpdateURLIP2Country, buffer);
	thePrefs.m_bAutoUpdateIP2Country = IsDlgButtonChecked(IDC_AUTOUPIP2COUNTRY)!=0;
#endif // IP2COUNTRY // NEO: IP2C END

#ifdef ARGOS // NEO: NA - [NeoArgos]
    GetDlgItem(IDC_UPDATE_URL_LEECHERSDAT)->GetWindowText(buffer);
	_tcscpy(thePrefs.m_sUpdateURLLeechersList, buffer);
	thePrefs.m_bUpdateLeechersStartup = IsDlgButtonChecked(IDC_AUTOUPLEECHERSDAT)!=0;
#endif // ARGOS // NEO: NA END

	LoadSettings();
	SetModified(FALSE);
	
	return CPropertyPage::OnApply();
}
void CPPgUpdate::Localize(void)
{
	if(m_hWnd)
	{
		//SetWindowText(GetResString(IDS_MORPH2));
		
		// NEO: FC - [FakeCheck]
		GetDlgItem(IDC_UPDATE_FILE)->SetWindowText(GetResString(IDS_FILES));
		GetDlgItem(IDC_UPDATEFAKELISTSTART)->SetWindowText(GetResString(IDS_X_UPDATEFAKECHECKONSTART));
		GetDlgItem(IDC_UPDATEFAKES)->SetWindowText(GetResString(IDS_X_UPDATE));
		GetDlgItem(IDC_RESETFAKESURL)->SetWindowText(GetResString(IDS_X_RESET));
		// NEO: FC END
		
		GetDlgItem(IDC_UPDATE_SECURITY)->SetWindowText(GetResString(IDS_SECURITY));
		GetDlgItem(IDC_AUTOUPIPFILTER)->SetWindowText(GetResString(IDS_X_UPDATEIPFILTERONSTART));
		GetDlgItem(IDC_UPDATEIPFURL)->SetWindowText(GetResString(IDS_X_UPDATE));
		GetDlgItem(IDC_RESETIPFURL)->SetWindowText(GetResString(IDS_X_RESET));

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
		GetDlgItem(IDC_UPDATE_COUNTRY)->SetWindowText(GetResString(IDS_X_COUNTRY));
		GetDlgItem(IDC_AUTOUPIP2COUNTRY)->SetWindowText(GetResString(IDS_X_AUTOUPIP2COUNTRY));
		GetDlgItem(IDC_UPDATEIPCURL)->SetWindowText(GetResString(IDS_X_UPDATE));
		GetDlgItem(IDC_RESETIPCURL)->SetWindowText(GetResString(IDS_X_RESET));
#endif // IP2COUNTRY // NEO: IP2C END

#ifdef ARGOS // NEO: NA - [NeoArgos]
		GetDlgItem(IDC_UPDATE_PROTECTION)->SetWindowText(GetResString(IDS_X_PROTECTION));
		GetDlgItem(IDC_AUTOUPLEECHERSDAT)->SetWindowText(GetResString(IDS_X_AUTOUPLEECHERSDAT));
		GetDlgItem(IDC_UPDATELLURL)->SetWindowText(GetResString(IDS_X_UPDATE));
		GetDlgItem(IDC_RESETLLURL)->SetWindowText(GetResString(IDS_X_RESET));
#endif // ARGOS // NEO: NA END

		GetDlgItem(IDC_UPDATE_AUTO)->SetWindowText(GetResString(IDS_X_AUTO_UPDATE));
		GetDlgItem(IDC_RUNTIMEUPDATE)->SetWindowText(GetResString(IDS_X_RUNTIMEUPDATE));
	}
}

// NEO: FC - [FakeCheck]
void CPPgUpdate::OnBnClickedUpdatefakes()
{
	OnApply();
	theApp.FakeCheck->DownloadFakeList();
	TCHAR sBuffer[30];
	sBuffer[0] = _T('\0'); 
	SysTimeToStr(thePrefs.GetFakesVersion(), sBuffer);
	GetDlgItem(IDC_FAKELIST_VERSION)->SetWindowText(sBuffer);
}

void CPPgUpdate::OnBnClickedResetfakes()
{
	CString strBuffer = _T("http://neomule.sourceforge.net/Downloads/fakes.zip");
	GetDlgItem(IDC_UPDATE_URL_FAKELIST)->SetWindowText(strBuffer);
	memset(thePrefs.GetFakesVersion(), 0, sizeof(SYSTEMTIME));
	GetDlgItem(IDC_FAKELIST_VERSION)->SetWindowText(_T(""));
}
// NEO: FC END

void CPPgUpdate::OnBnClickedUpdateipfurl()
{
	OnApply();
	theApp.ipfilter->UpdateIPFilterURL();
	TCHAR sBuffer[30];
	sBuffer[0] = _T('\0'); 
	SysTimeToStr(thePrefs.GetIPFilterVersion(), sBuffer);
	GetDlgItem(IDC_IPFILTER_VERSION)->SetWindowText(sBuffer);
}

void CPPgUpdate::OnBnClickedResetipfurl()
{
	CString strBuffer = _T("http://neomule.sourceforge.net/Downloads/ipfilter.zip");
	GetDlgItem(IDC_UPDATE_URL_IPFILTER)->SetWindowText(strBuffer);
	memset(thePrefs.GetIPFilterVersion(), 0, sizeof(SYSTEMTIME));
	GetDlgItem(IDC_IPFILTER_VERSION)->SetWindowText(_T(""));
}

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
void CPPgUpdate::OnBnClickedUpdateipcurl()
{
	OnApply();
	theApp.ip2country->UpdateIP2CountryURL();
	TCHAR sBuffer[30];
	sBuffer[0] = _T('\0'); 
	SysTimeToStr(thePrefs.GetIP2CountryVersion(), sBuffer);
	GetDlgItem(IDC_IP2COUNTRY_VERSION)->SetWindowText(sBuffer);
}


void CPPgUpdate::OnBnClickedResetipcurl()
{
	CString strBuffer = _T("http://neomule.sourceforge.net/Downloads/country.zip");
	GetDlgItem(IDC_UPDATE_URL_IP2COUNTRY)->SetWindowText(strBuffer);
	memset(thePrefs.GetIP2CountryVersion(), 0, sizeof(SYSTEMTIME));
	GetDlgItem(IDC_IP2COUNTRY_VERSION)->SetWindowText(_T(""));
}
#endif // IP2COUNTRY // NEO: IP2C END

#ifdef ARGOS // NEO: NA - [NeoArgos]
void CPPgUpdate::OnBnClickedUpdatellurl()
{
	OnApply();
	theApp.argos->UpdateLeecherList();
	TCHAR sBuffer[30];
	sBuffer[0] = _T('\0'); 
	SysTimeToStr(thePrefs.GetLeechersVersion(), sBuffer);
	GetDlgItem(IDC_LEECHERLIST_VERSION)->SetWindowText(sBuffer);
}


void CPPgUpdate::OnBnClickedResetllurl()
{
	CString strBuffer = _T("http://neomule.sourceforge.net/Downloads/Leechers.zip");
	GetDlgItem(IDC_UPDATE_URL_LEECHERSDAT)->SetWindowText(strBuffer);
	memset(thePrefs.GetLeechersVersion(), 0, sizeof(SYSTEMTIME));
	GetDlgItem(IDC_LEECHERLIST_VERSION)->SetWindowText(_T(""));
}
#endif // ARGOS // NEO: NA END
// NEO: AU END  <-- Xanatos --