//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgSources.h"
#include "Preferences.h"
#include "PartFile.h"
#include "OtherFunctions.h"
#include "Neo/Functions.h"
#include "Neo/GUI/CP/TreeFunctions.h"
#include "Neo/Defaults.h"
#include "UserMsgs.h"
#include "downloadqueue.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


///////////////////////////////////////////////////////////////////////////////
// CPPgSources dialog

IMPLEMENT_DYNAMIC(CPPgSources, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgSources, CPropertyPage)
	ON_WM_TIMER() // NEO: FCFG - [FileConfiguration]
	ON_WM_DESTROY()
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged) // NEO: FCFG - [FileConfiguration]
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgSources::CPPgSources()
	: CPropertyPage(CPPgSources::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	// NEO: FCFG - [FileConfiguration]
	m_bFilePreferences = false;

	m_paFiles = NULL;
	m_bDataChanged = false;
	//m_strCaption = GetResString(IDS_FILEINFORMATION);
	//m_psp.pszTitle = m_strCaption;
	//m_psp.dwFlags |= PSP_USETITLE;
	m_timer = 0;
	// NEO: FCFG END
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgSources::~CPPgSources()
{
}

void CPPgSources::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;

	m_htiSourceCollecting = NULL;
		m_htiCollectingControl = NULL;
			m_htiHardLimit = NULL;
			m_htiSwapLimit = NULL;
			m_htiCleanUpLimit = NULL;
			// NEO: NSD - [NeoSourceDrop]
				m_htiLow2LowCleanUpTime = NULL;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
				m_htiBadCleanUpTime = NULL;
				m_htiGoneCleanUpTime = NULL;
				m_htiSuspendCleanUpTime = NULL;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
				m_htiNnPCleanUpTime = NULL;
				m_htiFullQCleanUpTime = NULL;
			// NEO: NSD END
			m_htiCalcStandardLimits = NULL;
				m_htiCalcStandardLimitsDefault = NULL;
				m_htiCalcStandardLimitsEnable = NULL;
				m_htiCalcStandardLimitsDisable = NULL;
			// NEO: AHL - [AutoHardLimit]
			m_htiAutoHardLimit = NULL;
				m_htiAutoHardLimitDefault = NULL;
				m_htiAutoHardLimitModeMax = NULL;
				m_htiAutoHardLimitModeNew = NULL;
				m_htiAutoHardLimitModeOld = NULL;
				m_htiAutoHardLimitDisable = NULL;
				m_htiMinimalHardLimit = NULL;
				m_htiGlobalHardLimit = NULL;
				m_htiAutoHardLimitTimer = NULL;
			// NEO: AHL END
			// NEO: ASL - [AutoSoftLock]
			m_htiAutoSoftLock = NULL;
				m_htiAutoSoftLockDefault = NULL;
				m_htiAutoSoftLockEnable = NULL;
				m_htiAutoSoftLockDisable = NULL;
				m_htiAutoSoftLockValue = NULL;
			// NEO: ASL END
			// NEO: XSC - [ExtremeSourceCache]
			m_htiSourceCache = NULL;
				m_htiSourceCacheDefault = NULL;
				m_htiSourceCacheEnable = NULL;
				m_htiSourceCacheDisable = NULL;
				m_htiSourceCacheLimit = NULL;
				m_htiSourceCacheTime = NULL;
			// NEO: XSC END
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
			m_htiAdvancedA4AFMode = NULL;
				m_htiAdvancedA4AFModeDisabled = NULL;
				m_htiAdvancedA4AFModeBalance = NULL;
				m_htiAdvancedA4AFModeStack = NULL;
				m_htiSmartA4AFSwapping = NULL;
#endif // A4AF_CATS // NEO: MAC END
			// NEO: NCAP - [NeoCustomAutoPriority]
			m_htiAutoDownPriority = NULL;
				m_htiDynamicAutoDownPriorityDefault = NULL;
				m_htiDynamicAutoDownPriorityEnable = NULL;
				m_htiDynamicAutoDownPriorityDisable = NULL;
				m_htiLowDownPrioThreshold = NULL;
				m_htiHighDownPrioThreshold = NULL;
			// NEO: NCAP END
			m_htiRareFileLimit = NULL;
		m_htiXSSources = NULL;
			m_htiXSDefault = NULL;
			m_htiXSEnable = NULL;
			m_htiXSDisable = NULL;
			m_htiXSLimit = NULL;
			m_htiXSIntervals = NULL;
			m_htiXSClientIntervals = NULL;
			m_htiXSDelay = NULL;
		m_htiSVRSources = NULL;
			m_htiSVRDefault = NULL;
			m_htiSVREnable = NULL;
			m_htiSVRDisable = NULL;
			m_htiSVRLimit = NULL;
			m_htiSVRIntervals = NULL;
		m_htiKADSources = NULL;
			m_htiKADDefault = NULL;
			m_htiKADEnable = NULL;
			m_htiKADDisable = NULL;
			m_htiKADLimit = NULL;
			m_htiKADIntervals = NULL;
			m_htiKADAmount = NULL;
			m_htiKADDelay = NULL;
		m_htiUDPSources = NULL;
			m_htiUDPDefault = NULL;
			m_htiUDPEnable = NULL;
			m_htiUDPDisable = NULL;
			m_htiUDPLimit = NULL;
			m_htiUDPIntervals = NULL;
			m_htiGlobalUDPIntervals = NULL;
			m_htiUDPAmount = NULL;
			m_htiUDPCache = NULL; // NEO: XUC - [ExtendedUdpCache]

	// NEO: DR - [DownloadReask]
	m_htiDownloadReask = NULL;
		m_htiSpreadReask = NULL; // NEO: SR - [SpreadReask]
		m_htiReask = NULL;
			m_htiReaskIntervals = NULL;
		m_htiNnPReask = NULL;
			m_htiReaskNnPDefault = NULL;
			m_htiReaskNnPEnable = NULL;
			m_htiReaskNnPDisable = NULL;
			m_htiReaskNnPIntervals = NULL;
		m_htiFullQReask = NULL;
			m_htiReaskFullQDefault = NULL;
			m_htiReaskFullQEnable = NULL;
			m_htiReaskFullQDisable = NULL;
			m_htiReaskFullQIntervals = NULL;
	// NEO: DR END

	// NEO: DS - [DropSources]
	m_htiDrop = NULL;
		m_htiUseDontAskThisIP = NULL;
			m_htiUseDontAskThisIPDefault = NULL;
			m_htiUseDontAskThisIPEnable = NULL;
			m_htiUseDontAskThisIPDisable = NULL;
			m_htiDontAskThisIPTime = NULL;
		m_htiDropNnP = NULL;
			m_htiDropNnPDefault = NULL;
			m_htiDropNnPEnable = NULL;
			m_htiDropNnPDisable = NULL;
			m_htiDropNnPLimit = NULL;
				m_htiDropNnPLimitDefault = NULL;
				m_htiDropNnPLimitTotal = NULL;
				m_htiDropNnPLimitRelativ = NULL;
				m_htiDropNnPLimitSpecyfic = NULL;
				m_htiDropNnPLimitDisable = NULL;
			m_htiDropNnPTimer = NULL;
		m_htiDropFullQ = NULL;
			m_htiDropFullQDefault = NULL;
			m_htiDropFullQEnable = NULL;
			m_htiDropFullQDisable = NULL;
			m_htiDropFullQLimit = NULL;
				m_htiDropFullQLimitDefault = NULL;
				m_htiDropFullQLimitTotal = NULL;
				m_htiDropFullQLimitRelativ = NULL;
				m_htiDropFullQLimitSpecyfic = NULL;
				m_htiDropFullQLimitDisable = NULL;
			m_htiDropFullQTimer = NULL;
		m_htiDropHighQ = NULL;
			m_htiDropHighQDefault = NULL;
			m_htiDropHighQEnable = NULL;
			m_htiDropHighQDisable = NULL;
			m_htiDropHighQValue = NULL;
			m_htiDropHighQLimit = NULL;
				m_htiDropHighQLimitDefault = NULL;
				m_htiDropHighQLimitTotal = NULL;
				m_htiDropHighQLimitRelativ = NULL;
				m_htiDropHighQLimitSpecyfic = NULL;
				m_htiDropHighQLimitDisable = NULL;
			m_htiDropHighQTimer = NULL;
	// NEO: DS END
}

void CPPgSources::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
		int iImgCollecting = 8;
		int iImgControl = 8;
		int iImgCL = 8;
		int iImgAHL = 8; // NEO: AHL - [AutoHardLimit]
		int iImgASL = 8; // NEO: ASL - [AutoSoftLock]
		int iImgXSC = 8; // NEO: XSC - [ExtremeSourceCache]
		int iImgXS = 8;
		int iImgSVR = 8;
		int iImgKAD = 8;
		int iImgUDP = 8;
		// NEO: DR - [DownloadReask]
		int iImgReask = 8;
		int iImgReaskSrc = 8;
		int iImgReaskNnP = 8;
		int iImgReaskFullQ = 8;
		// NEO: DR END
		// NEO: DS - [DropSources]
		int iImgDrop = 8;
		int iImgDropList = 8;
		int iImgDropNnP = 8;
		int iImgDropFullQ = 8;
		int iImgDropHighQ = 8;
		// NEO: DS END
		int iImgAutoPrio = 8;
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		int iImgA4AF = 8;
#endif // A4AF_CATS // NEO: MAC END
        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgCollecting = piml->Add(CTempIconLoader(_T("COLLECTING")));
			iImgControl = piml->Add(CTempIconLoader(_T("COLLECTINGCONTROL")));
			iImgCL = piml->Add(CTempIconLoader(_T("CALCSTANDARTLIMITS")));
			iImgAHL = piml->Add(CTempIconLoader(_T("AHL"))); // NEO: AHL - [AutoHardLimit]
			iImgASL = piml->Add(CTempIconLoader(_T("ASL"))); // NEO: ASL - [AutoSoftLock]
			iImgXSC = piml->Add(CTempIconLoader(_T("CACHE"))); // NEO: XSC - [ExtremeSourceCache]
			iImgXS = piml->Add(CTempIconLoader(_T("XSSRC")));
			iImgSVR = piml->Add(CTempIconLoader(_T("SVRSRC")));
			iImgKAD = piml->Add(CTempIconLoader(_T("KADSRC")));
			iImgUDP = piml->Add(CTempIconLoader(_T("UDPSRC")));
			// NEO: DR - [DownloadReask]
			iImgReask = piml->Add(CTempIconLoader(_T("REASKDL")));
			iImgReaskSrc = piml->Add(CTempIconLoader(_T("REASKSRC")));
			iImgReaskNnP = piml->Add(CTempIconLoader(_T("REASKNNP")));
			iImgReaskFullQ = piml->Add(CTempIconLoader(_T("REASKFULLQ")));
			// NEO: DR END
			// NEO: DS - [DropSources]
			iImgDrop = piml->Add(CTempIconLoader(_T("DROP")));
			iImgDropList = piml->Add(CTempIconLoader(_T("DROPLIST")));
			iImgDropNnP = piml->Add(CTempIconLoader(_T("DROPNNP")));
			iImgDropFullQ = piml->Add(CTempIconLoader(_T("DROPFULLQ")));
			iImgDropHighQ = piml->Add(CTempIconLoader(_T("DROPHIGHQ")));
			// NEO: DS END
			iImgAutoPrio = piml->Add(CTempIconLoader(_T("FILEPRIORITY")));
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
			iImgA4AF = piml->Add(CTempIconLoader(_T("ADVA4AF")));
#endif // A4AF_CATS // NEO: MAC END
		}

		SetTreeGroup(m_ctrlTreeOptions,m_htiSourceCollecting,GetResString(IDS_X_SOURCE_COLLECTING),iImgCollecting, TVI_ROOT, GetResString(IDS_X_SOURCE_COLLECTING_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiCollectingControl,GetResString(IDS_X_SOURCE_COLLECTING_CONTROL),iImgControl, m_htiSourceCollecting, GetResString(IDS_X_SOURCE_COLLECTING_CONTROL_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiHardLimit,GetResString(IDS_X_HARD_LIMIT),m_htiCollectingControl,GetResString(IDS_X_HARD_LIMIT_INFO));
				if(ForFile()){
					SetTreeGroup(m_ctrlTreeOptions,m_htiCalcStandardLimits,GetResString(IDS_X_CALC_LIMITS),iImgCL, m_htiCollectingControl, GetResString(IDS_X_CALC_LIMITS_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiCalcStandardLimitsDefault,GetResString(IDS_X_CALC_LIMITS_DEFAULT),m_htiCalcStandardLimits,GetResString(IDS_X_CALC_LIMITS_DEFAULT_INFO),TRUE,m_iCalcStandardLimits == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiCalcStandardLimitsEnable,GetResString(IDS_X_CALC_LIMITS_ENABLE),m_htiCalcStandardLimits,GetResString(IDS_X_CALC_LIMITS_ENABLE_INFO),TRUE,m_iCalcStandardLimits == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiCalcStandardLimitsDisable,GetResString(IDS_X_CALC_LIMITS_DISABLE),m_htiCalcStandardLimits,GetResString(IDS_X_CALC_LIMITS_DISABLE_INFO),TRUE,m_iCalcStandardLimits == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiCalcStandardLimits,GetResString(IDS_X_CALC_LIMITS),m_htiCollectingControl,GetResString(IDS_X_CALC_LIMITS_INFO),FALSE,m_bCalcStandardLimits);
				// NEO: AHL - [AutoHardLimit]
				SetTreeGroup(m_ctrlTreeOptions,m_htiAutoHardLimit,GetResString(IDS_X_AHL_TWEAKS),iImgAHL, m_htiCollectingControl, GetResString(IDS_X_AHL_TWEAKS_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoHardLimitDefault,GetResString(IDS_X_AHL_DEFAULT),m_htiAutoHardLimit,GetResString(IDS_X_AHL_DEFAULT_INFO),TRUE,m_iAutoHardLimit == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoHardLimitDisable,GetResString(IDS_X_AHL_DISABLE),m_htiAutoHardLimit,GetResString(IDS_X_AHL_DISABLE_INFO),FALSE,m_iAutoHardLimit == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiAutoHardLimitModeMax,GetResString(IDS_X_AHL_ENABLE_MAX),m_htiAutoHardLimit,GetResString(IDS_X_AHL_ENABLE_MAX_INFO),ForFile(),m_iAutoHardLimit == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiAutoHardLimitModeNew,GetResString(IDS_X_AHL_ENABLE_NEW),m_htiAutoHardLimit,GetResString(IDS_X_AHL_ENABLE_NEW_INFO),ForFile(),m_iAutoHardLimit == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiAutoHardLimitModeOld,GetResString(IDS_X_AHL_ENABLE_OLD),m_htiAutoHardLimit,GetResString(IDS_X_AHL_ENABLE_OLD_INFO),ForFile(),m_iAutoHardLimit == 3);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoHardLimitDisable,GetResString(IDS_X_AHL_DISABLE),m_htiAutoHardLimit,GetResString(IDS_X_AHL_DISABLE_INFO),TRUE,m_iAutoHardLimit == 4);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiMinimalHardLimit,GetResString(IDS_X_AHL_MIN_SRC), m_htiAutoHardLimit,GetResString(IDS_X_AHL_MIN_SRC_INFO));
					if(!ForFile())
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiGlobalHardLimit,GetResString(IDS_X_AHL_GLOBAL_SRC), m_htiAutoHardLimit,GetResString(IDS_X_AHL_GLOBAL_SRC_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiAutoHardLimitTimer,GetResString(IDS_X_AHL_TIMER), m_htiAutoHardLimit,GetResString(IDS_X_AHL_TIMER_INFO));
				// NEO: AHL END
				// NEO: ASL - [AutoSoftLock]
				SetTreeGroup(m_ctrlTreeOptions,m_htiAutoSoftLock,GetResString(IDS_X_ASL_TWEAKS),iImgASL, m_htiCollectingControl, GetResString(IDS_X_ASL_TWEAKS_INFO));
					if(ForFile()){
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoSoftLockDefault,GetResString(IDS_X_ASL_DEFAULT),m_htiAutoSoftLock,GetResString(IDS_X_ASL_DEFAULT_INFO),TRUE,m_iAutoSoftLock == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoSoftLockEnable,GetResString(IDS_X_ASL_ENABLE),m_htiAutoSoftLock,GetResString(IDS_X_ASL_ENABLE_INFO),TRUE,m_iAutoSoftLock == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoSoftLockDisable,GetResString(IDS_X_ASL_DISABLE),m_htiAutoSoftLock,GetResString(IDS_X_ASL_DISABLE_INFO),TRUE,m_iAutoSoftLock == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiAutoSoftLockEnable,GetResString(IDS_X_ASL_ENABLE),m_htiAutoSoftLock,GetResString(IDS_X_ASL_ENABLE_INFO),FALSE,m_bAutoSoftLock);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiAutoSoftLockValue,GetResString(IDS_X_ASL_VALUE), m_htiAutoSoftLock,GetResString(IDS_X_ASL_VALUE_INFO));
				// NEO: ASL END
				// NEO: XSC - [ExtremeSourceCache]
				SetTreeGroup(m_ctrlTreeOptions,m_htiSourceCache,GetResString(IDS_X_SOURCE_CACHE),iImgXSC, m_htiCollectingControl, GetResString(IDS_X_SOURCE_CACHE_INFO));
					if(ForFile()){
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceCacheDefault,GetResString(IDS_X_SOURCE_CACHE_DEFAULT),m_htiSourceCache,GetResString(IDS_X_SOURCE_CACHE_DEFAULT_INFO),TRUE,m_iSourceCache == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceCacheEnable,GetResString(IDS_X_SOURCE_CACHE_ENABLE),m_htiSourceCache,GetResString(IDS_X_SOURCE_CACHE_ENABLE_INFO),TRUE,m_iSourceCache == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceCacheDisable,GetResString(IDS_X_SOURCE_CACHE_DISABLE),m_htiSourceCache,GetResString(IDS_X_SOURCE_CACHE_DISABLE_INFO),TRUE,m_iSourceCache == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiSourceCacheEnable,GetResString(IDS_X_SOURCE_CACHE_ENABLE),m_htiSourceCache,GetResString(IDS_X_SOURCE_CACHE_ENABLE_INFO),FALSE,m_bSourceCache);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceCacheLimit,GetResString(IDS_X_SOURCE_CACHE_LIMIT), m_htiSourceCache,GetResString(IDS_X_SOURCE_CACHE_LIMIT_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceCacheTime,GetResString(IDS_X_SOURCE_CACHE_TIME), m_htiSourceCache,GetResString(IDS_X_SOURCE_CACHE_TIME_INFO));
				// NEO: XSC END
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiSwapLimit,GetResString(IDS_X_SWAP_LIMIT),m_htiCollectingControl,GetResString(IDS_X_SWAP_LIMIT_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiCleanUpLimit,GetResString(IDS_X_CLEANUP_LIMIT),m_htiCollectingControl,GetResString(IDS_X_CLEANUP_LIMIT_INFO));
					// NEO: NSD - [NeoSourceDrop]
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiLow2LowCleanUpTime,GetResString(IDS_X_CLEANUP_L2L),m_htiCleanUpLimit,GetResString(IDS_X_CLEANUP_L2L_INFO));
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiBadCleanUpTime,GetResString(IDS_X_CLEANUP_BAD),m_htiCleanUpLimit,GetResString(IDS_X_CLEANUP_BAD_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiGoneCleanUpTime,GetResString(IDS_X_CLEANUP_GON),m_htiCleanUpLimit,GetResString(IDS_X_CLEANUP_GON_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiSuspendCleanUpTime,GetResString(IDS_X_CLEANUP_SSP),m_htiCleanUpLimit,GetResString(IDS_X_CLEANUP_SSP_INFO));
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiNnPCleanUpTime,GetResString(IDS_X_CLEANUP_NNP),m_htiCleanUpLimit,GetResString(IDS_X_CLEANUP_NNP_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiFullQCleanUpTime,GetResString(IDS_X_CLEANUP_FLQ),m_htiCleanUpLimit,GetResString(IDS_X_CLEANUP_FLQ_INFO));
					// NEO: NSD END
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
				if(!ForFile()){
					SetTreeGroup(m_ctrlTreeOptions,m_htiAdvancedA4AFMode,GetResString(IDS_X_ADVANCED_A4AF_MODE),iImgA4AF, m_htiCollectingControl, GetResString(IDS_X_ADVANCED_A4AF_MODE_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiAdvancedA4AFModeDisabled,GetResString(IDS_X_ADVANCED_A4AF_MODE_DISABLED),m_htiAdvancedA4AFMode,GetResString(IDS_X_ADVANCED_A4AF_MODE_DISABLED_INFO),FALSE,m_iAdvancedA4AFMode == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAdvancedA4AFModeBalance,GetResString(IDS_X_ADVANCED_A4AF_MODE_BALANCE),m_htiAdvancedA4AFMode,GetResString(IDS_X_ADVANCED_A4AF_MODE_BALANCE_INFO),FALSE,m_iAdvancedA4AFMode == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAdvancedA4AFModeStack,GetResString(IDS_X_ADVANCED_A4AF_MODE_STACK),m_htiAdvancedA4AFMode,GetResString(IDS_X_ADVANCED_A4AF_MODE_STACK_INFO),FALSE,m_iAdvancedA4AFMode == 2);
						SetTreeCheck(m_ctrlTreeOptions,m_htiSmartA4AFSwapping,GetResString(IDS_X_SMART_A4AF_SWAPPING),m_htiAdvancedA4AFMode,GetResString(IDS_X_SMART_A4AF_SWAPPING_INFO),FALSE,m_bSmartA4AFSwapping);
				}
#endif // A4AF_CATS // NEO: MAC END
				// NEO: NCAP - [NeoCustomAutoPriority]
				SetTreeGroup(m_ctrlTreeOptions,m_htiAutoDownPriority,GetResString(IDS_X_DOWN_AUTO_PRIO),iImgAutoPrio, m_htiCollectingControl, GetResString(IDS_X_DOWN_AUTO_PRIO_INFO));
					if(ForFile()){
						SetTreeRadio(m_ctrlTreeOptions,m_htiDynamicAutoDownPriorityDefault,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_DEFAULT),m_htiAutoDownPriority,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_DEFAULT_INFO),TRUE,m_iDynamicAutoDownPriority == 0);
						SetTreeRadioNumEdit(m_ctrlTreeOptions,m_htiDynamicAutoDownPriorityEnable,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_ENABLE),m_htiAutoDownPriority,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_ENABLE_INFO),TRUE,m_iDynamicAutoDownPriority == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiDynamicAutoDownPriorityDisable,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_DISABLE),m_htiAutoDownPriority,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_DISABLE_INFO),TRUE,m_iDynamicAutoDownPriority == 2);
					}else
						SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiDynamicAutoDownPriorityEnable,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_ENABLE),m_htiAutoDownPriority,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_ENABLE_INFO),FALSE,m_bDynamicAutoDownPriority);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiLowDownPrioThreshold,GetResString(IDS_X_AUTO_PRIO_LOW), m_htiAutoDownPriority,GetResString(IDS_X_AUTO_PRIO_LOW_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiHighDownPrioThreshold,GetResString(IDS_X_AUTO_PRIO_HIGH), m_htiAutoDownPriority,GetResString(IDS_X_AUTO_PRIO_HIGH_INFO));
				// NEO: NCAP END
				if(!ForFile())
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiRareFileLimit,GetResString(IDS_X_RARE_FILE_LIMIT), m_htiCollectingControl,GetResString(IDS_X_RARE_FILE_LIMIT_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiXSSources,GetResString(IDS_X_XS_SOURCES),iImgXS, m_htiSourceCollecting,GetResString(IDS_X_XS_SOURCES_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiXSDefault,GetResString(IDS_X_XS_SOURCES_FORCE_DEFAULT),m_htiXSSources,GetResString(IDS_X_XS_SOURCES_FORCE_DEFAULT_INFO),TRUE,m_iXSState == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiXSEnable,GetResString(IDS_X_XS_SOURCES_FORCE_ENABLE),m_htiXSSources,GetResString(IDS_X_XS_SOURCES_FORCE_ENABLE_INFO),TRUE,m_iXSState == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiXSDisable,GetResString(IDS_X_XS_SOURCES_FORCE_DISABLE),m_htiXSSources,GetResString(IDS_X_XS_SOURCES_FORCE_DISABLE_INFO),TRUE,m_iXSState == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiXSDisable,GetResString(IDS_X_XS_SOURCES_DISABLE),m_htiXSSources,GetResString(IDS_X_XS_SOURCES_DISABLE_INFO),FALSE,m_bXSDisable);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiXSLimit,GetResString(IDS_X_XS_LIMIT), m_htiXSSources,GetResString(IDS_X_XS_LIMIT_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiXSIntervals,GetResString(IDS_X_XS_INTERVAL), m_htiXSSources,GetResString(IDS_X_XS_INTERVAL_INFO));
				if(!ForFile())
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiXSClientIntervals,GetResString(IDS_X_XS_CLIENT_INTERVAL), m_htiXSSources,GetResString(IDS_X_XS_CLIENT_INTERVAL_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiXSDelay,GetResString(IDS_X_XS_DELAY), m_htiXSSources,GetResString(IDS_X_XS_DELAY_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiSVRSources,GetResString(IDS_X_SVR_SOURCES),iImgSVR, m_htiSourceCollecting,GetResString(IDS_X_SVR_SOURCES_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiSVRDefault,GetResString(IDS_X_SVR_SOURCES_FORCE_DEFAULT),m_htiSVRSources,GetResString(IDS_X_SVR_SOURCES_FORCE_DEFAULT_INFO),TRUE,m_iSVRState == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSVREnable,GetResString(IDS_X_SVR_SOURCES_FORCE_ENABLE),m_htiSVRSources,GetResString(IDS_X_SVR_SOURCES_FORCE_ENABLE_INFO),TRUE,m_iSVRState == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSVRDisable,GetResString(IDS_X_SVR_SOURCES_FORCE_DISABLE),m_htiSVRSources,GetResString(IDS_X_SVR_SOURCES_FORCE_DISABLE_INFO),TRUE,m_iSVRState == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiSVRDisable,GetResString(IDS_X_SVR_SOURCES_DISABLE),m_htiSVRSources,GetResString(IDS_X_SVR_SOURCES_DISABLE_INFO),FALSE,m_bSVRDisable);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiSVRLimit,GetResString(IDS_X_SVR_LIMIT), m_htiSVRSources,GetResString(IDS_X_SVR_LIMIT_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiSVRIntervals,GetResString(IDS_X_SVR_INTERVAL), m_htiSVRSources,GetResString(IDS_X_SVR_INTERVAL_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiKADSources,GetResString(IDS_X_KAD_SOURCES),iImgKAD, m_htiSourceCollecting,GetResString(IDS_X_KAD_SOURCES_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiKADDefault,GetResString(IDS_X_KAD_SOURCES_FORCE_DEFAULT),m_htiKADSources,GetResString(IDS_X_KAD_SOURCES_FORCE_DEFAULT_INFO),TRUE,m_iKADState == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiKADEnable,GetResString(IDS_X_KAD_SOURCES_FORCE_ENABLE),m_htiKADSources,GetResString(IDS_X_KAD_SOURCES_FORCE_ENABLE_INFO),TRUE,m_iKADState == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiKADDisable,GetResString(IDS_X_KAD_SOURCES_FORCE_DISABLE),m_htiKADSources,GetResString(IDS_X_KAD_SOURCES_FORCE_DISABLE_INFO),TRUE,m_iKADState == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiKADDisable,GetResString(IDS_X_KAD_SOURCES_DISABLE),m_htiKADSources,GetResString(IDS_X_KAD_SOURCES_DISABLE_INFO),FALSE,m_bKADDisable);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiKADLimit,GetResString(IDS_X_KAD_LIMIT), m_htiKADSources,GetResString(IDS_X_KAD_LIMIT_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiKADIntervals,GetResString(IDS_X_KAD_INTERVAL), m_htiKADSources,GetResString(IDS_X_KAD_INTERVAL_INFO));
				if(!ForFile())
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiKADAmount,GetResString(IDS_X_KAD_AMOUNT), m_htiKADSources,GetResString(IDS_X_KAD_AMOUNT_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiKADDelay,GetResString(IDS_X_KAD_DELAY), m_htiKADSources,GetResString(IDS_X_KAD_DELAY_INFO));

			SetTreeGroup(m_ctrlTreeOptions,m_htiUDPSources,GetResString(IDS_X_UDP_SOURCES),iImgUDP, m_htiSourceCollecting,GetResString(IDS_X_UDP_SOURCES_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiUDPDefault,GetResString(IDS_X_UDP_SOURCES_FORCE_DEFAULT),m_htiUDPSources,GetResString(IDS_X_UDP_SOURCES_FORCE_DEFAULT_INFO),TRUE,m_iUDPState == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiUDPEnable,GetResString(IDS_X_UDP_SOURCES_FORCE_ENABLE),m_htiUDPSources,GetResString(IDS_X_UDP_SOURCES_FORCE_ENABLE_INFO),TRUE,m_iUDPState == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiUDPDisable,GetResString(IDS_X_UDP_SOURCES_FORCE_DISABLE),m_htiUDPSources,GetResString(IDS_X_UDP_SOURCES_FORCE_DISABLE_INFO),TRUE,m_iUDPState == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiUDPDisable,GetResString(IDS_X_UDP_SOURCES_DISABLE),m_htiUDPSources,GetResString(IDS_X_UDP_SOURCES_DISABLE_INFO),FALSE,m_bUDPDisable);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiUDPLimit,GetResString(IDS_X_UDP_LIMIT), m_htiUDPSources,GetResString(IDS_X_UDP_LIMIT_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiUDPIntervals,GetResString(IDS_X_UDP_INTERVAL), m_htiUDPSources,GetResString(IDS_X_UDP_INTERVAL_INFO));
				if(!ForFile()){
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiGlobalUDPIntervals,GetResString(IDS_X_UDP_INTERVAL_GLOBAL), m_htiUDPSources,GetResString(IDS_X_UDP_INTERVAL_GLOBAL_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiUDPAmount,GetResString(IDS_X_UDP_AMOUNT), m_htiUDPSources,GetResString(IDS_X_UDP_AMOUNT_INFO));
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiUDPCache,GetResString(IDS_X_UDP_CATCH), m_htiUDPSources,GetResString(IDS_X_UDP_CATCH_INFO),FALSE, m_uUDPCache); // NEO: XUC - [ExtendedUdpCache]
				}
		
		// NEO: DR - [DownloadReask]
		SetTreeGroup(m_ctrlTreeOptions,m_htiDownloadReask,GetResString(IDS_X_REASK_TWEAKS),iImgReask, TVI_ROOT,GetResString(IDS_X_REASK_TWEAKS_INFO));
			if(!ForFile())
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiSpreadReask,GetResString(IDS_X_SPREAD_REASK), m_htiDownloadReask,GetResString(IDS_X_SPREAD_REASK_INFO),FALSE, m_bSpreadReask); // NEO: SR - [SpreadReask]
			SetTreeGroup(m_ctrlTreeOptions,m_htiReask,GetResString(IDS_X_REASKSRC),iImgReaskSrc, m_htiDownloadReask,GetResString(IDS_X_REASKSRC_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskIntervals,GetResString(IDS_X_REASKSRC_INTERVALS), m_htiReask,GetResString(IDS_X_REASKSRC_INTERVALS_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiNnPReask,GetResString(IDS_X_REASKNNP),iImgReaskNnP, m_htiDownloadReask,GetResString(IDS_X_REASKNNP_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiReaskNnPDefault,GetResString(IDS_X_REASKNNP_DEFAULT),m_htiNnPReask,GetResString(IDS_X_REASKNNP_DEFAULT_INFO),TRUE,m_iNnPReask == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiReaskNnPEnable,GetResString(IDS_X_REASKNNP_ENABLE),m_htiNnPReask,GetResString(IDS_X_REASKNNP_ENABLE_INFO),TRUE,m_iNnPReask == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiReaskNnPDisable,GetResString(IDS_X_REASKNNP_DISABLE),m_htiNnPReask,GetResString(IDS_X_REASKNNP_DISABLE_INFO),TRUE,m_iNnPReask == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiReaskNnPDisable,GetResString(IDS_X_REASKNNP_DISABLE),m_htiNnPReask,GetResString(IDS_X_REASKNNP_DISABLE_INFO),FALSE,m_bDontNnPReask);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskNnPIntervals,GetResString(IDS_X_REASKNNP_INTERVALS), m_htiNnPReask,GetResString(IDS_X_REASKNNP_INTERVALS_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiFullQReask,GetResString(IDS_X_REASKFULLQ),iImgReaskFullQ, m_htiDownloadReask,GetResString(IDS_X_REASKFULLQ_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiReaskFullQDefault,GetResString(IDS_X_REASKFULLQ_DEFAULT),m_htiFullQReask,GetResString(IDS_X_REASKFULLQ_DEFAULT_INFO),TRUE,m_iFullQReask == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiReaskFullQEnable,GetResString(IDS_X_REASKFULLQ_ENABLE),m_htiFullQReask,GetResString(IDS_X_REASKFULLQ_ENABLE_INFO),TRUE,m_iFullQReask == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiReaskFullQDisable,GetResString(IDS_X_REASKFULLQ_DISABLE),m_htiFullQReask,GetResString(IDS_X_REASKFULLQ_DISABLE_INFO),TRUE,m_iFullQReask == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiReaskFullQDisable,GetResString(IDS_X_REASKFULLQ_DISABLE),m_htiFullQReask,GetResString(IDS_X_REASKFULLQ_DISABLE_INFO),FALSE,m_iFullQReask);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskFullQIntervals,GetResString(IDS_X_REASKFULLQ_INTERVALS), m_htiFullQReask,GetResString(IDS_X_REASKFULLQ_INTERVALS_INFO));
		// NEO: DR END

		// NEO: DS - [DropSources]
		SetTreeGroup(m_ctrlTreeOptions,m_htiDrop,GetResString(IDS_X_DROPSRC),iImgDrop, TVI_ROOT,GetResString(IDS_X_DROPSRC_INFO));
			if(ForFile()){
				SetTreeGroup(m_ctrlTreeOptions,m_htiUseDontAskThisIP,GetResString(IDS_X_DROP_LIST),iImgDropList, m_htiDrop,GetResString(IDS_X_DROPSRCNNP_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiUseDontAskThisIPDefault,GetResString(IDS_X_DROP_LIST_DEFAULT),m_htiUseDontAskThisIP,GetResString(IDS_X_DROP_LIST_DEFAULT_INFO),TRUE,m_iUseDontAskThisIP == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiUseDontAskThisIPEnable,GetResString(IDS_X_DROP_LIST_ENABLE),m_htiUseDontAskThisIP,GetResString(IDS_X_DROP_LIST_ENABLE_INFO),TRUE,m_iUseDontAskThisIP == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiUseDontAskThisIPDisable,GetResString(IDS_X_DROP_LIST_DISABLE),m_htiUseDontAskThisIP,GetResString(IDS_X_DROP_LIST_DISABLE_INFO),TRUE,m_iUseDontAskThisIP == 2);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDontAskThisIPTime,GetResString(IDS_X_DROP_LIST_TIME), m_htiUseDontAskThisIP,GetResString(IDS_X_DROP_LIST_TIME_INFO));
			}else
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiDontAskThisIPTime,GetResString(IDS_X_USE_DROP_LIST), m_htiDrop,GetResString(IDS_X_USE_DROP_LIST_INFO),FALSE, m_bUseDontAskThisIP);
			SetTreeGroup(m_ctrlTreeOptions,m_htiDropNnP,GetResString(IDS_X_DROPSRCNNP),iImgDropNnP, m_htiDrop,GetResString(IDS_X_DROPSRCNNP_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPDefault,GetResString(IDS_X_DROPSRCNNP_DEFAULT),m_htiDropNnP,GetResString(IDS_X_DROPSRCNNP_DEFAULT_INFO),TRUE,m_iDropNnP == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPEnable,GetResString(IDS_X_DROPSRCNNP_ENABLE_TTS),m_htiDropNnP,GetResString(IDS_X_DROPSRCNNP_ENABLE_TTS_INFO),TRUE,m_iDropNnP == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPEnable,GetResString(IDS_X_DROPSRCNNP_ENABLE),m_htiDropNnP,GetResString(IDS_X_DROPSRCNNP_ENABLE_INFO),TRUE,m_iDropNnP == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPDisable,GetResString(IDS_X_DROPSRCNNP_DISABLE),m_htiDropNnP,GetResString(IDS_X_DROPSRCNNP_DISABLE_INFO),TRUE,m_iDropNnP == 3);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiDropNnPEnable,GetResString(IDS_X_DROPSRCNNP_ENABLE),m_htiDropNnP,GetResString(IDS_X_DROPSRCNNP_ENABLE_INFO),TRUE,m_uDropNnP);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropNnPLimit,GetResString(IDS_X_DROPSRCNNP_LIMIT), m_htiDropNnP,GetResString(IDS_X_DROPSRCNNP_LIMIT_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPLimitDefault,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_DEFAULT),m_htiDropNnPLimit,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_DEFAULT_INFO),TRUE,m_iDropNnPLimitMode == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPLimitDisable,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_DISABLE),m_htiDropNnPLimit,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_DISABLE_INFO),FALSE,m_iDropNnPLimitMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPLimitTotal,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_TOTAL),m_htiDropNnPLimit,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_TOTAL_INFO),ForFile(),m_iDropNnPLimitMode == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPLimitRelativ,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_RELATIVE),m_htiDropNnPLimit,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_RELATIVE_INFO),ForFile(),m_iDropNnPLimitMode == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPLimitSpecyfic,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_SPECYFIC),m_htiDropNnPLimit,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_SPECYFIC_INFO),ForFile(),m_iDropNnPLimitMode == 3);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropNnPLimitDisable,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_DISABLE),m_htiDropNnPLimit,GetResString(IDS_X_DROPSRCNNP_LIMIT_MODE_DISABLE_INFO),TRUE,m_iDropNnPLimitMode == 4);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropNnPTimer,GetResString(IDS_X_DROPSRCNNP_TIMER), m_htiDropNnP,GetResString(IDS_X_DROPSRCNNP_TIMER_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiDropFullQ,GetResString(IDS_X_DROPSRCFULLQ),iImgDropFullQ, m_htiDrop,GetResString(IDS_X_DROPSRCFULLQ_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQDefault,GetResString(IDS_X_DROPSRCFULLQ_DEFAULT),m_htiDropFullQ,GetResString(IDS_X_DROPSRCFULLQ_DEFAULT_INFO),TRUE,m_iDropFullQ == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQEnable,GetResString(IDS_X_DROPSRCFULLQ_ENABLE_TTS),m_htiDropFullQ,GetResString(IDS_X_DROPSRCFULLQ_ENABLE_TTS_INFO),TRUE,m_iDropFullQ == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQEnable,GetResString(IDS_X_DROPSRCFULLQ_ENABLE),m_htiDropFullQ,GetResString(IDS_X_DROPSRCFULLQ_ENABLE_INFO),TRUE,m_iDropFullQ == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQDisable,GetResString(IDS_X_DROPSRCFULLQ_DISABLE),m_htiDropFullQ,GetResString(IDS_X_DROPSRCFULLQ_DISABLE_INFO),TRUE,m_iDropFullQ == 3);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiDropFullQEnable,GetResString(IDS_X_DROPSRCFULLQ_ENABLE),m_htiDropFullQ,GetResString(IDS_X_DROPSRCFULLQ_ENABLE_INFO),TRUE,m_uDropFullQ);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropFullQLimit,GetResString(IDS_X_DROPSRCFULLQ_LIMIT), m_htiDropFullQ,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQLimitDefault,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_DEFAULT),m_htiDropFullQLimit,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_DEFAULT_INFO),TRUE,m_iDropFullQLimitMode == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQLimitDisable,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_DISABLE),m_htiDropFullQLimit,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_DISABLE_INFO),FALSE,m_iDropFullQLimitMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQLimitTotal,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_TOTAL),m_htiDropFullQLimit,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_TOTAL_INFO),ForFile(),m_iDropFullQLimitMode == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQLimitRelativ,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_RELATIVE),m_htiDropFullQLimit,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_RELATIVE_INFO),ForFile(),m_iDropFullQLimitMode == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQLimitSpecyfic,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_SPECYFIC),m_htiDropFullQLimit,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_SPECYFIC_INFO),ForFile(),m_iDropFullQLimitMode == 3);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropFullQLimitDisable,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_DISABLE),m_htiDropFullQLimit,GetResString(IDS_X_DROPSRCFULLQ_LIMIT_MODE_DISABLE_INFO),TRUE,m_iDropFullQLimitMode == 4);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropFullQTimer,GetResString(IDS_X_DROPSRCFULLQ_TIMER), m_htiDropFullQ,GetResString(IDS_X_DROPSRCFULLQ_TIMER_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ),iImgDropHighQ, m_htiDrop,GetResString(IDS_X_DROPSRCHIGHQ_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQDefault,GetResString(IDS_X_DROPSRCHIGHQ_DEFAULT),m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ_DEFAULT_INFO),TRUE,m_iDropHighQ == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQEnable,GetResString(IDS_X_DROPSRCHIGHQ_ENABLE_TTS),m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ_ENABLE_TTS_INFO),TRUE,m_iDropHighQ == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQEnable,GetResString(IDS_X_DROPSRCHIGHQ_ENABLE),m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ_ENABLE_INFO),TRUE,m_iDropHighQ == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQDisable,GetResString(IDS_X_DROPSRCHIGHQ_DISABLE),m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ_DISABLE_INFO),TRUE,m_iDropHighQ == 3);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiDropHighQEnable,GetResString(IDS_X_DROPSRCHIGHQ_ENABLE),m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ_ENABLE_INFO),TRUE,m_uDropHighQ);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropHighQValue,GetResString(IDS_X_DROPSRCHIGHQ_VALUE), m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ_VALUE_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropHighQLimit,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT), m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQLimitDefault,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_DEFAULT),m_htiDropHighQLimit,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_DEFAULT_INFO),TRUE,m_iDropHighQLimitMode == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQLimitDisable,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_DISABLE),m_htiDropHighQLimit,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_DISABLE_INFO),FALSE,m_iDropHighQLimitMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQLimitTotal,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_TOTAL),m_htiDropHighQLimit,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_TOTAL_INFO),ForFile(),m_iDropHighQLimitMode == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQLimitRelativ,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_RELATIVE),m_htiDropHighQLimit,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_RELATIVE_INFO),ForFile(),m_iDropHighQLimitMode == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQLimitSpecyfic,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_SPECYFIC),m_htiDropHighQLimit,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_SPECYFIC_INFO),ForFile(),m_iDropHighQLimitMode == 3);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropHighQLimitDisable,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_DISABLE),m_htiDropHighQLimit,GetResString(IDS_X_DROPSRCHIGHQ_LIMIT_MODE_DISABLE_INFO),TRUE,m_iDropHighQLimitMode == 4);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropHighQTimer,GetResString(IDS_X_DROPSRCHIGHQ_TIMER), m_htiDropHighQ,GetResString(IDS_X_DROPSRCHIGHQ_TIMER_INFO));
		// NEO: DS END

		//CheckSLEnable();

		if(!ForFile())
			m_ctrlTreeOptions.SetItemEnable(m_htiUDPCache, m_uUDPCache, TRUE, TRUE); // NEO: XUC - [ExtendedUdpCache]

		m_ctrlTreeOptions.Expand(m_htiSourceCollecting, TVE_EXPAND);
		//m_ctrlTreeOptions.Expand(m_htiDownloadReask, TVE_EXPAND);
		//m_ctrlTreeOptions.Expand(m_htiDrop, TVE_EXPAND);
		m_bInitializedTreeOpts = true;
	}

		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiHardLimit, m_iHardLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSwapLimit, m_iSwapLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiCleanUpLimit, m_iCleanUpLimit);

		// NEO: NSD - [NeoSourceDrop]
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLow2LowCleanUpTime, m_iLow2LowCleanUpTime);
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiBadCleanUpTime, m_iBadCleanUpTime);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiGoneCleanUpTime, m_iGoneCleanUpTime);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSuspendCleanUpTime, m_iSuspendCleanUpTime);
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiNnPCleanUpTime, m_iNnPCleanUpTime);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFullQCleanUpTime, m_iFullQCleanUpTime);
		// NEO: NSD END

		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiCalcStandardLimits, m_iCalcStandardLimits);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCalcStandardLimits, m_bCalcStandardLimits);

		// NEO: AHL - [AutoHardLimit]
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoHardLimit, m_iAutoHardLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMinimalHardLimit, m_iMinimalHardLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiGlobalHardLimit, m_iGlobalHardLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAutoHardLimitTimer, m_iAutoHardLimitTimer);
		// NEO: AHL END
		// NEO: ASL - [AutoSoftLock]
		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoSoftLock, m_iAutoSoftLock);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoSoftLockEnable, m_bAutoSoftLock);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAutoSoftLockValue, m_iAutoSoftLockValue);
		// NEO: ASL END

		// NEO: XSC - [ExtremeSourceCache]
		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceCache, m_iSourceCache);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSourceCacheEnable, m_bSourceCache);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceCacheLimit, m_iSourceCacheLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceCacheTime, m_iSourceCacheTime);
		// NEO: XSC END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		if(!ForFile()){
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAdvancedA4AFMode, m_iAdvancedA4AFMode);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSmartA4AFSwapping, m_bSmartA4AFSwapping);
		}
#endif // A4AF_CATS // NEO: MAC END

		// NEO: NCAP - [NeoCustomAutoPriority]
		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoDownPriority, m_iDynamicAutoDownPriority);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDynamicAutoDownPriorityEnable, m_bDynamicAutoDownPriority);
		DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDynamicAutoDownPriorityEnable, m_fDynamicDownPriorityFactor);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLowDownPrioThreshold, m_iLowDownPrioThreshold);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiHighDownPrioThreshold, m_iHighDownPrioThreshold);
		// NEO: NCAP END
		if(!ForFile())
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiRareFileLimit, m_iRareFileLimit);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiXSSources, m_iXSState);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiXSDisable, m_bXSDisable);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiXSLimit, m_iXSLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiXSIntervals, m_iXSIntervals);
		if(!ForFile())
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiXSClientIntervals, m_iXSClientIntervals);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiXSDelay, m_iXSDelayValue);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSVRSources, m_iSVRState);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSVRDisable, m_bSVRDisable);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSVRLimit, m_iSVRLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSVRIntervals, m_iSVRIntervals);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiKADSources, m_iKADState);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiKADDisable, m_bKADDisable);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiKADLimit, m_iKADLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiKADIntervals, m_iKADIntervals);
		if(!ForFile())
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiKADAmount, m_iKADAmount);

		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiKADDelay, m_iKADDelayValue);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiUDPSources, m_iUDPState);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUDPDisable, m_bUDPDisable);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiUDPLimit, m_iUDPLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiUDPIntervals, m_iUDPIntervals);
		if(!ForFile()){
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiGlobalUDPIntervals, m_iGlobalUDPIntervals);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiUDPAmount, m_iUDPAmount);
			// NEO: XUC - [ExtendedUdpCache]
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUDPCache, m_uUDPCache);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiUDPCache, m_iUDPCache);
			// NEO: XUC END
		}

		// NEO: SR - [SpreadReask]
		if(!ForFile()){
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSpreadReask, m_iSpreadReask);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSpreadReask, m_bSpreadReask);
		}
		// NEO: SR END

		// NEO: DR - [DownloadReask]
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskIntervals, m_iReaskIntervals);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiNnPReask, m_iNnPReask);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReaskNnPDisable, m_bDontNnPReask);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskNnPIntervals, m_iNnPReaskIntervals);
	
		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiFullQReask, m_iFullQReask);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReaskFullQDisable, m_bDontFullQReask);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskFullQIntervals, m_iFullQReaskIntervals);
		// NEO: DR END

		// NEO: DS - [DropSources]
		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiUseDontAskThisIP, m_iUseDontAskThisIP);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDontAskThisIPTime, m_bUseDontAskThisIP);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDontAskThisIPTime, m_iDontAskThisIPTime);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropNnP, m_iDropNnP);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDropNnPEnable, m_uDropNnP);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropNnPLimit, m_iDropNnPLimit);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropNnPLimit, m_iDropNnPLimitMode);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropNnPTimer, m_iDropNnPTimer);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropFullQ, m_iDropFullQ);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDropFullQEnable, m_uDropFullQ);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropFullQLimit, m_iDropFullQLimit);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropFullQLimit, m_iDropFullQLimitMode);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropFullQTimer, m_iDropFullQTimer);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropHighQ, m_iDropHighQ);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDropHighQEnable, m_uDropHighQ);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropHighQValue, m_iDropHighQValue);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropHighQLimit, m_iDropHighQLimit);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropHighQLimit, m_iDropHighQLimitMode);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropHighQTimer, m_iDropHighQTimer);
		// NEO: DS END
}

BOOL CPPgSources::OnInitDialog()
{
	if(!m_bFilePreferences)
		LoadSettings();
	else
		RefreshData();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	// NEO: FCFG - [FileConfiguration]
	// no need to explicitly call 'RefreshData' here, 'OnSetActive' will be called right after 'OnInitDialog'

	// start time for calling 'RefreshData'
	if(m_bFilePreferences)
		VERIFY( (m_timer = SetTimer(301, 5000, 0)) != NULL );
	// NEO: FCFG END

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgSources::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	if(!m_bFilePreferences){
		/*
		* Globale Einstellungen Speichern
		*/
		if(m_iHardLimit) thePrefs.m_iHardLimit = m_iHardLimit;
		if(m_iSwapLimit) thePrefs.m_iSwapLimit = m_iSwapLimit;
		if(m_iCleanUpLimit) thePrefs.m_iCleanUpLimit = m_iCleanUpLimit;
		// NEO: NSD - [NeoSourceDrop]
		if(m_iLow2LowCleanUpTime) thePrefs.m_iLow2LowCleanUpTime = m_iLow2LowCleanUpTime;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
		if(m_iBadCleanUpTime) thePrefs.m_iBadCleanUpTime = m_iBadCleanUpTime;
		if(m_iGoneCleanUpTime) thePrefs.m_iGoneCleanUpTime = m_iGoneCleanUpTime;
		if(m_iSuspendCleanUpTime) thePrefs.m_iSuspendCleanUpTime = m_iSuspendCleanUpTime;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
		if(m_iNnPCleanUpTime) thePrefs.m_iNnPCleanUpTime = m_iNnPCleanUpTime;
		if(m_iFullQCleanUpTime) thePrefs.m_iFullQCleanUpTime = m_iFullQCleanUpTime;
		// NEO: NSD END

		thePrefs.m_bCalcStandardLimits = m_bCalcStandardLimits;
		// NEO: AHL - [AutoHardLimit]
		thePrefs.m_iAutoHardLimit = m_iAutoHardLimit;
		if(m_iMinimalHardLimit) thePrefs.m_iMinimalHardLimit = m_iMinimalHardLimit;
		if(m_iGlobalHardLimit) thePrefs.m_iGlobalHardLimit = m_iGlobalHardLimit;
		if(m_iAutoHardLimitTimer) thePrefs.m_iAutoHardLimitTimer = m_iAutoHardLimitTimer;
		// NEO: AHL END
		// NEO: ASL - [AutoSoftLock]
		thePrefs.m_bAutoSoftLock = m_bAutoSoftLock;
		if(m_iAutoSoftLockValue) thePrefs.m_iAutoSoftLockValue = m_iAutoSoftLockValue;
		// NEO: ASL END

		// NEO: XSC - [ExtremeSourceCache]
		thePrefs.m_bSourceCache = m_bSourceCache;
		if(m_iSourceCacheLimit) thePrefs.m_iSourceCacheLimit = m_iSourceCacheLimit;
		if(m_iSourceCacheTime) thePrefs.m_iSourceCacheTime = m_iSourceCacheTime;
		// NEO: XSC END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		thePrefs.m_bSmartA4AFSwapping = m_bSmartA4AFSwapping;
		thePrefs.m_iAdvancedA4AFMode = m_iAdvancedA4AFMode;
#endif // A4AF_CATS // NEO: MAC END

		// NEO: NCAP - [NeoCustomAutoPriority]
		thePrefs.m_bDynamicAutoDownPriority = m_bDynamicAutoDownPriority;
		if(m_fDynamicDownPriorityFactor) thePrefs.m_fDynamicDownPriorityFactor = m_fDynamicDownPriorityFactor;
		if(m_iLowDownPrioThreshold) thePrefs.m_iLowDownPrioThreshold = m_iLowDownPrioThreshold;
		if(m_iHighDownPrioThreshold) thePrefs.m_iHighDownPrioThreshold = m_iHighDownPrioThreshold;
		// NEO: NCAP END

		if(m_iRareFileLimit) thePrefs.m_iRareFileLimit = m_iRareFileLimit;

		thePrefs.m_bXSDisable = m_bXSDisable;
		if(m_iXSLimit) thePrefs.m_iXSLimit = m_iXSLimit;
		if(m_iXSIntervals) thePrefs.m_iXSIntervals = m_iXSIntervals;
		if(m_iXSClientIntervals) thePrefs.m_iXSClientIntervals = m_iXSClientIntervals;
		if(m_iXSDelayValue) thePrefs.m_iXSDelayValue = m_iXSDelayValue;

		thePrefs.m_bSVRDisable = m_bSVRDisable;
		if(m_iSVRLimit) thePrefs.m_iSVRLimit = m_iSVRLimit;
		if(m_iSVRIntervals) thePrefs.m_iSVRIntervals = m_iSVRIntervals;

		thePrefs.m_bKADDisable = m_bKADDisable;
		if(m_iKADLimit) thePrefs.m_iKADLimit = m_iKADLimit;
		if(m_iKADIntervals) thePrefs.m_iKADIntervals = m_iKADIntervals;
		if(m_iKADAmount) thePrefs.m_iKADAmount = m_iKADAmount;
		if(m_iKADDelayValue) thePrefs.m_iKADDelayValue = m_iKADDelayValue;

		thePrefs.m_bUDPDisable = m_bUDPDisable;
		if(m_iUDPLimit) thePrefs.m_iUDPLimit = m_iUDPLimit;
		if(m_iUDPIntervals) thePrefs.m_iUDPIntervals = m_iUDPIntervals;
		if(m_iGlobalUDPIntervals) thePrefs.m_iGlobalUDPIntervals = m_iGlobalUDPIntervals;
		if(m_iUDPAmount) thePrefs.m_iUDPAmount = m_iUDPAmount;
		// NEO: XUC - [ExtendedUdpCache]
		thePrefs.m_uUDPCache = m_uUDPCache;
		if(m_iUDPCache) thePrefs.m_iUDPCache = m_iUDPCache;
		// NEO: XUC END

		// NEO: SR - [SpreadReask]
		thePrefs.m_bSpreadReask = m_bSpreadReask;
		if(m_iSpreadReask) thePrefs.m_iSpreadReask = m_iSpreadReask;
		// NEO: SR END

		// NEO: DR - [DownloadReask]
		if(m_iReaskIntervals) thePrefs.m_iReaskIntervals = m_iReaskIntervals;

		thePrefs.m_bDontNnPReask = m_bDontNnPReask;
		if(m_iNnPReaskIntervals) thePrefs.m_iNnPReaskIntervals = m_iNnPReaskIntervals;

		thePrefs.m_bDontFullQReask = m_bDontFullQReask;
		if(m_iFullQReaskIntervals) thePrefs.m_iFullQReaskIntervals = m_iFullQReaskIntervals;
		// NEO: DR END

		// NEO: DS - [DropSources]
		thePrefs.m_bUseDontAskThisIP = m_bUseDontAskThisIP;
		if(m_iDontAskThisIPTime) thePrefs.m_iDontAskThisIPTime = m_iDontAskThisIPTime;

		thePrefs.m_uDropNnP = m_uDropNnP;
		if(m_iDropNnPLimit) thePrefs.m_iDropNnPLimit = m_iDropNnPLimit;
		thePrefs.m_iDropNnPLimitMode = m_iDropNnPLimitMode;
		if(m_iDropNnPTimer) thePrefs.m_iDropNnPTimer = m_iDropNnPTimer;

		thePrefs.m_uDropFullQ = m_uDropFullQ;
		if(m_iDropFullQLimit) thePrefs.m_iDropFullQLimit = m_iDropFullQLimit;
		thePrefs.m_iDropFullQLimitMode = m_iDropFullQLimitMode;
		if(m_iDropFullQTimer) thePrefs.m_iDropFullQTimer = m_iDropFullQTimer;

		thePrefs.m_uDropHighQ = m_uDropHighQ;
		if(m_iDropHighQValue) thePrefs.m_iDropHighQValue = m_iDropHighQValue;
		if(m_iDropHighQLimit) thePrefs.m_iDropHighQLimit = m_iDropHighQLimit;
		thePrefs.m_iDropHighQLimitMode = m_iDropHighQLimitMode;
		if(m_iDropHighQTimer) thePrefs.m_iDropHighQTimer = m_iDropHighQTimer;
		// NEO: DS END

		thePrefs.CheckNeoPreferences();
		LoadSettings();

	}else{
		/*
		* Datei Einstellungen Speichern
		*/
		// NEO: FCFG - [FileConfiguration]
		CPartFile* file;
		for (int i = 0; i < m_paFiles->GetSize(); i++)
		{
			file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[i]);


			//if (file->IsPartFile())

			if(m_iHardLimit) file->PartPrefs.m_iHardLimit = (m_iHardLimit != thePrefs.GetHardLimit()) ? m_iHardLimit : 0;
			if(m_iSwapLimit) file->PartPrefs.m_iSwapLimit = (m_iSwapLimit != thePrefs.GetSwapLimit()) ? m_iSwapLimit : 0;
			if(m_iCleanUpLimit) file->PartPrefs.m_iCleanUpLimit = (m_iCleanUpLimit != thePrefs.GetCleanUpLimit()) ? m_iCleanUpLimit : 0;
			// NEO: NSD - [NeoSourceDrop]
			if(m_iLow2LowCleanUpTime) file->PartPrefs.m_iLow2LowCleanUpTime = (m_iLow2LowCleanUpTime != thePrefs.GetLow2LowCleanUpTime()) ? m_iLow2LowCleanUpTime : 0;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
			if(m_iBadCleanUpTime) file->PartPrefs.m_iBadCleanUpTime = (m_iBadCleanUpTime != thePrefs.GetBadCleanUpTime()) ? m_iBadCleanUpTime : 0;
			if(m_iGoneCleanUpTime) file->PartPrefs.m_iGoneCleanUpTime = (m_iGoneCleanUpTime != thePrefs.GetGoneCleanUpTime()) ? m_iGoneCleanUpTime : 0;
			if(m_iSuspendCleanUpTime) file->PartPrefs.m_iSuspendCleanUpTime = (m_iSuspendCleanUpTime != thePrefs.GetSuspendCleanUpTime()) ? m_iSuspendCleanUpTime : 0;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
			if(m_iNnPCleanUpTime) file->PartPrefs.m_iNnPCleanUpTime = (m_iNnPCleanUpTime != thePrefs.GetNnPCleanUpTime()) ? m_iNnPCleanUpTime : 0;
			if(m_iFullQCleanUpTime) file->PartPrefs.m_iFullQCleanUpTime = (m_iFullQCleanUpTime != thePrefs.GetFullQCleanUpTime()) ? m_iFullQCleanUpTime : 0;
			// NEO: NSD END
			if(m_iCalcStandardLimits != -1) file->PartPrefs.m_iCalcStandardLimits = m_iCalcStandardLimits;
			// NEO: AHL - [AutoHardLimit]
			if(m_iAutoHardLimit != -1) file->PartPrefs.m_iAutoHardLimit = m_iAutoHardLimit;
			if(m_iMinimalHardLimit) file->PartPrefs.m_iMinimalHardLimit = (m_iMinimalHardLimit != thePrefs.GetMinimalHardLimit()) ? m_iMinimalHardLimit : 0;
			if(m_iAutoHardLimitTimer) file->PartPrefs.m_iAutoHardLimitTimer = (m_iAutoHardLimitTimer != thePrefs.GetAutoHardLimitTimer()) ? m_iAutoHardLimitTimer : 0;
			// NEO: AHL END
			// NEO: ASL - [AutoSoftLock]
			if(m_iAutoSoftLock != -1) file->PartPrefs.m_iAutoSoftLock = m_iAutoSoftLock;
			if(m_iAutoSoftLockValue) file->PartPrefs.m_iAutoSoftLockValue = (m_iAutoSoftLockValue != thePrefs.GetAutoSoftLockValue()) ? m_iAutoSoftLockValue : 0;
			// NEO: ASL END

			// NEO: XSC - [ExtremeSourceCache]
			if(m_iSourceCache != -1) file->PartPrefs.m_iSourceCache = m_iSourceCache;
			if(m_iSourceCacheLimit) file->PartPrefs.m_iSourceCacheLimit = (m_iSourceCacheLimit != thePrefs.GetSourceCacheLimit()) ? m_iSourceCacheLimit : 0;
			if(m_iSourceCacheTime) file->PartPrefs.m_iSourceCacheTime = (m_iSourceCacheTime != thePrefs.GetSourceCacheTime()) ? m_iSourceCacheTime : 0;
			// NEO: XSC END

			// NEO: NCAP - [NeoCustomAutoPriority]
			if(m_iDynamicAutoDownPriority != -1) file->PartPrefs.m_iDynamicAutoDownPriority = m_iDynamicAutoDownPriority;
			if(m_fDynamicDownPriorityFactor) file->PartPrefs.m_fDynamicDownPriorityFactor = (m_fDynamicDownPriorityFactor != thePrefs.GetDynamicDownPriorityFactor()) ? m_fDynamicDownPriorityFactor : 0;
			if(m_iLowDownPrioThreshold) file->PartPrefs.m_iLowDownPrioThreshold = (m_iLowDownPrioThreshold != thePrefs.GetLowDownPrioThreshold()) ? m_iLowDownPrioThreshold : 0;
			if(m_iHighDownPrioThreshold) file->PartPrefs.m_iHighDownPrioThreshold = (m_iHighDownPrioThreshold != thePrefs.GetHighDownPrioThreshold()) ? m_iHighDownPrioThreshold : 0;
			// NEO: NCAP END

			if(m_iXSState != -1) file->PartPrefs.m_iXSState = m_iXSState;
			if(m_iXSLimit) file->PartPrefs.m_iXSLimit = (m_iXSLimit != thePrefs.GetXSLimit()) ? m_iXSLimit : 0;
			if(m_iXSIntervals) file->PartPrefs.m_iXSIntervals = (m_iXSIntervals != thePrefs.GetXSIntervals()) ? m_iXSIntervals : 0;
			if(m_iXSDelayValue) file->PartPrefs.m_iXSDelayValue = (m_iXSDelayValue != thePrefs.GetXSDelayValue()) ? m_iXSDelayValue : 0;

			if(m_iSVRState != -1) file->PartPrefs.m_iSVRState = m_iSVRState;
			if(m_iSVRLimit) file->PartPrefs.m_iSVRLimit = (m_iSVRLimit != thePrefs.GetSVRLimit()) ? m_iSVRLimit : 0;
			if(m_iXSLimit) file->PartPrefs.m_iSVRIntervals = (m_iSVRIntervals != thePrefs.GetSVRIntervals()) ? m_iSVRIntervals : 0;

			if(m_iKADState != -1) file->PartPrefs.m_iKADState = m_iKADState;
			if(m_iKADLimit) file->PartPrefs.m_iKADLimit = (m_iKADLimit != thePrefs.GetKADLimit()) ? m_iKADLimit : 0;
			if(m_iKADLimit) file->PartPrefs.m_iKADIntervals = (m_iKADIntervals != thePrefs.GetKADIntervals()) ? m_iKADIntervals : 0;
			if(m_iKADDelayValue) file->PartPrefs.m_iKADDelayValue = (m_iKADDelayValue != thePrefs.GetKADDelayValue()) ? m_iKADDelayValue : 0;

			if(m_iUDPState != -1) file->PartPrefs.m_iUDPState = m_iUDPState;
			if(m_iUDPLimit) file->PartPrefs.m_iUDPLimit = (m_iUDPLimit != thePrefs.GetUDPLimit()) ? m_iUDPLimit : 0;
			if(m_iUDPIntervals) file->PartPrefs.m_iUDPIntervals = (m_iUDPIntervals != thePrefs.GetUDPIntervals()) ? m_iUDPIntervals : 0;

			// NEO: DR - [DownloadReask]
			if(m_iReaskIntervals) file->PartPrefs.m_iReaskIntervals = (m_iReaskIntervals != thePrefs.GetReaskIntervals()) ? m_iReaskIntervals : 0;

			if(m_iNnPReask != -1) file->PartPrefs.m_iNnPReask = m_iNnPReask;
			if(m_iNnPReaskIntervals) file->PartPrefs.m_iNnPReaskIntervals = (m_iNnPReaskIntervals != thePrefs.GetNnPReaskIntervals()) ? m_iNnPReaskIntervals : 0;

			if(m_iFullQReask != -1) file->PartPrefs.m_iFullQReask = m_iFullQReask;
			if(m_iFullQReaskIntervals) file->PartPrefs.m_iFullQReaskIntervals = (m_iFullQReaskIntervals != thePrefs.GetFullQReaskIntervals()) ? m_iFullQReaskIntervals : 0;
			// NEO: DR END

			// NEO: DS - [DropSources]
			if(m_iDropNnP != -1) file->PartPrefs.m_iDropNnP = m_iDropNnP;
			if(m_iDropNnPLimit) file->PartPrefs.m_iDropNnPLimit = (m_iDropNnPLimit != thePrefs.GetDropNnPLimit()) ? m_iDropNnPLimit : 0;
			if(m_iDropNnPLimitMode != -1) file->PartPrefs.m_iDropNnPLimitMode = m_iDropNnPLimitMode;
			if(m_iDropNnPTimer) file->PartPrefs.m_iDropNnPTimer = (m_iDropNnPTimer != thePrefs.GetDropNnPTimer()) ? m_iDropNnPTimer : 0;

			if(m_iDropFullQ != -1) file->PartPrefs.m_iDropFullQ = m_iDropFullQ;
			if(m_iDropFullQLimit) file->PartPrefs.m_iDropFullQLimit = (m_iDropFullQLimit != thePrefs.GetDropFullQLimit()) ? m_iDropFullQLimit : 0;
			if(m_iDropFullQLimitMode != -1) file->PartPrefs.m_iDropFullQLimitMode = m_iDropFullQLimitMode;
			if(m_iDropFullQTimer) file->PartPrefs.m_iDropFullQTimer = (m_iDropFullQTimer != thePrefs.GetDropFullQTimer()) ? m_iDropFullQTimer : 0;

			if(m_iDropHighQ != -1) file->PartPrefs.m_iDropHighQ = m_iDropHighQ;
			if(m_iDropHighQValue) file->PartPrefs.m_iDropHighQValue = (m_iDropHighQValue != thePrefs.GetDropHighQValue()) ? m_iDropHighQValue : 0;
			if(m_iDropHighQLimit) file->PartPrefs.m_iDropHighQLimit = (m_iDropHighQLimit != thePrefs.GetDropHighQLimit()) ? m_iDropHighQLimit : 0;
			if(m_iDropHighQLimitMode != -1) file->PartPrefs.m_iDropHighQLimitMode = m_iDropHighQLimitMode;
			if(m_iDropHighQTimer) file->PartPrefs.m_iDropHighQTimer = (m_iDropHighQTimer != thePrefs.GetDropHighQTimer()) ? m_iDropHighQTimer : 0;

			if(m_iUseDontAskThisIP != -1) file->PartPrefs.m_iUseDontAskThisIP = m_iUseDontAskThisIP;
			if(m_iDontAskThisIPTime) file->PartPrefs.m_iDontAskThisIPTime = (m_iDontAskThisIPTime != thePrefs.GetDontAskThisIPCleanUpTime()) ? m_iDontAskThisIPTime : 0;
			// NEO: DS END

			file->PartPrefs.CheckTweaks();
		}

		RefreshData();
		// NEO: FCFG END
	}

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgSources::LoadSettings()
{
	/*
	* Globale Einstellungen Laden
	*/
	m_iHardLimit = thePrefs.m_iHardLimit;
	m_iSwapLimit = thePrefs.m_iSwapLimit;
	m_iCleanUpLimit = thePrefs.m_iCleanUpLimit;
	// NEO: NSD - [NeoSourceDrop]
	m_iLow2LowCleanUpTime = thePrefs.m_iLow2LowCleanUpTime;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	m_iBadCleanUpTime = thePrefs.m_iBadCleanUpTime;
	m_iGoneCleanUpTime = thePrefs.m_iGoneCleanUpTime;
	m_iSuspendCleanUpTime = thePrefs.m_iSuspendCleanUpTime;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	m_iNnPCleanUpTime = thePrefs.m_iNnPCleanUpTime;
	m_iFullQCleanUpTime = thePrefs.m_iFullQCleanUpTime;
	// NEO: NSD END
	m_bCalcStandardLimits = thePrefs.m_bCalcStandardLimits;
	// NEO: AHL - [AutoHardLimit]
	m_iAutoHardLimit = thePrefs.m_iAutoHardLimit;
	m_iMinimalHardLimit = thePrefs.m_iMinimalHardLimit;
	m_iGlobalHardLimit = thePrefs.m_iGlobalHardLimit;
	m_iAutoHardLimitTimer = thePrefs.m_iAutoHardLimitTimer;
	// NEO: AHL END
	// NEO: ASL - [AutoSoftLock]
	m_bAutoSoftLock = thePrefs.m_bAutoSoftLock;
	m_iAutoSoftLockValue = thePrefs.m_iAutoSoftLockValue;
	// NEO: ASL END

	// NEO: XSC - [ExtremeSourceCache]
	m_bSourceCache = thePrefs.m_bSourceCache;
	m_iSourceCacheLimit = thePrefs.m_iSourceCacheLimit;
	m_iSourceCacheTime = thePrefs.m_iSourceCacheTime;
	// NEO: XSC END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	m_bSmartA4AFSwapping = thePrefs.m_bSmartA4AFSwapping;
	m_iAdvancedA4AFMode = thePrefs.m_iAdvancedA4AFMode;
#endif // A4AF_CATS // NEO: MAC END
	// NEO: NCAP - [NeoCustomAutoPriority]
	m_bDynamicAutoDownPriority = thePrefs.m_bDynamicAutoDownPriority;
	m_fDynamicDownPriorityFactor = thePrefs.m_fDynamicDownPriorityFactor;
	m_iLowDownPrioThreshold = thePrefs.m_iLowDownPrioThreshold;
	m_iHighDownPrioThreshold = thePrefs.m_iHighDownPrioThreshold;
	// NEO: NCAP END
	m_iRareFileLimit = thePrefs.m_iRareFileLimit;

	m_bXSDisable = thePrefs.m_bXSDisable;
	m_iXSLimit = thePrefs.m_iXSLimit;
	m_iXSIntervals = thePrefs.m_iXSIntervals;
	m_iXSClientIntervals = thePrefs.m_iXSClientIntervals;
	m_iXSDelayValue = thePrefs.m_iXSDelayValue;

	m_bSVRDisable = thePrefs.m_bSVRDisable;
	m_iSVRLimit = thePrefs.m_iSVRLimit;
	m_iSVRIntervals = thePrefs.m_iSVRIntervals;

	m_bKADDisable = thePrefs.m_bKADDisable;
	m_iKADLimit = thePrefs.m_iKADLimit;
	m_iKADIntervals = thePrefs.m_iKADIntervals;
	m_iKADAmount = thePrefs.m_iKADAmount;
	m_iKADDelayValue = thePrefs.m_iKADDelayValue;

	m_bUDPDisable = thePrefs.m_bUDPDisable;
	m_iUDPLimit = thePrefs.m_iUDPLimit;
	m_iUDPIntervals = thePrefs.m_iUDPIntervals;
	m_iGlobalUDPIntervals = thePrefs.m_iGlobalUDPIntervals;
	m_iUDPAmount = thePrefs.m_iUDPAmount;
	// NEO: XUC - [ExtendedUdpCache]
	m_uUDPCache = thePrefs.m_uUDPCache;
	m_iUDPCache = thePrefs.m_iUDPCache;
	// NEO: XUC END

	// NEO: SR - [SpreadReask]
	m_bSpreadReask = thePrefs.m_bSpreadReask;
	m_iSpreadReask = thePrefs.m_iSpreadReask;
	// NEO: SR END

	// NEO: DR - [DownloadReask]
	m_iReaskIntervals = thePrefs.m_iReaskIntervals;

	m_bDontNnPReask = thePrefs.m_bDontNnPReask;
	m_iNnPReaskIntervals = thePrefs.m_iNnPReaskIntervals;

	m_bDontFullQReask = thePrefs.m_bDontFullQReask;
	m_iFullQReaskIntervals = thePrefs.m_iFullQReaskIntervals;
	// NEO: DR END

	// NEO: DS - [DropSources]
	m_bUseDontAskThisIP = thePrefs.m_bUseDontAskThisIP;
	m_iDontAskThisIPTime = thePrefs.m_iDontAskThisIPTime;

	m_uDropNnP = thePrefs.m_uDropNnP;
	m_iDropNnPLimit = thePrefs.m_iDropNnPLimit;
	m_iDropNnPLimitMode = thePrefs.m_iDropNnPLimitMode;
	m_iDropNnPTimer = thePrefs.m_iDropNnPTimer;

	m_uDropFullQ = thePrefs.m_uDropFullQ;
	m_iDropFullQLimit = thePrefs.m_iDropFullQLimit;
	m_iDropFullQLimitMode = thePrefs.m_iDropFullQLimitMode;
	m_iDropFullQTimer = thePrefs.m_iDropFullQTimer;

	m_uDropHighQ = thePrefs.m_uDropHighQ;
	m_iDropHighQValue = thePrefs.m_iDropHighQValue;
	m_iDropHighQLimit = thePrefs.m_iDropHighQLimit;
	m_iDropHighQLimitMode = thePrefs.m_iDropHighQLimitMode;
	m_iDropHighQTimer = thePrefs.m_iDropHighQTimer;
	// NEO: DS END
}

// NEO: FCFG - [FileConfiguration]
void CPPgSources::RefreshData()
{
	/*
	* Datei Einstellungen Laden
	*/

	const CPartFile* file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[0]);

	//if (file->IsPartFile())
	m_iHardLimit = file->PartPrefs.m_iHardLimit;
	m_iSwapLimit = file->PartPrefs.m_iSwapLimit;
	m_iCleanUpLimit = file->PartPrefs.m_iCleanUpLimit;
	// NEO: NSD - [NeoSourceDrop]
	m_iLow2LowCleanUpTime = file->PartPrefs.m_iLow2LowCleanUpTime;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	m_iBadCleanUpTime = file->PartPrefs.m_iBadCleanUpTime;
	m_iGoneCleanUpTime = file->PartPrefs.m_iGoneCleanUpTime;
	m_iSuspendCleanUpTime = file->PartPrefs.m_iSuspendCleanUpTime;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	m_iNnPCleanUpTime = file->PartPrefs.m_iNnPCleanUpTime;
	m_iFullQCleanUpTime = file->PartPrefs.m_iFullQCleanUpTime;
	// NEO: NSD END
	m_iCalcStandardLimits = file->PartPrefs.m_iCalcStandardLimits;
	// NEO: AHL - [AutoHardLimit]
	m_iAutoHardLimit = file->PartPrefs.m_iAutoHardLimit;
	m_iMinimalHardLimit = file->PartPrefs.m_iMinimalHardLimit;
	m_iAutoHardLimitTimer = file->PartPrefs.m_iAutoHardLimitTimer;
	// NEO: AHL END
	// NEO: ASL - [AutoSoftLock]
	m_iAutoSoftLock = file->PartPrefs.m_iAutoSoftLock;
	m_iAutoSoftLockValue = file->PartPrefs.m_iAutoSoftLockValue;
	// NEO: ASL END

	// NEO: XSC - [ExtremeSourceCache]
	m_iSourceCache = file->PartPrefs.m_iSourceCache;
	m_iSourceCacheLimit = file->PartPrefs.m_iSourceCacheLimit;
	m_iSourceCacheTime = file->PartPrefs.m_iSourceCacheTime;
	// NEO: XSC END

	// NEO: NCAP - [NeoCustomAutoPriority]
	m_iDynamicAutoDownPriority = file->PartPrefs.m_iDynamicAutoDownPriority;
	m_fDynamicDownPriorityFactor = file->PartPrefs.m_fDynamicDownPriorityFactor;
	m_iLowDownPrioThreshold = file->PartPrefs.m_iLowDownPrioThreshold;
	m_iHighDownPrioThreshold = file->PartPrefs.m_iHighDownPrioThreshold;
	// NEO: NCAP END

	m_iXSState = file->PartPrefs.m_iXSState;
	m_iXSLimit = file->PartPrefs.m_iXSLimit;
	m_iXSIntervals = file->PartPrefs.m_iXSIntervals;
	m_iXSDelayValue = file->PartPrefs.m_iXSDelayValue;

	m_iSVRState = file->PartPrefs.m_iSVRState;
	m_iSVRLimit = file->PartPrefs.m_iSVRLimit;
	m_iSVRIntervals = file->PartPrefs.m_iSVRIntervals;

	m_iKADState = file->PartPrefs.m_iKADState;
	m_iKADLimit = file->PartPrefs.m_iKADLimit;
	m_iKADIntervals = file->PartPrefs.m_iKADIntervals;
	m_iKADDelayValue = file->PartPrefs.m_iKADDelayValue;

	m_iUDPState = file->PartPrefs.m_iUDPState;
	m_iUDPLimit = file->PartPrefs.m_iUDPLimit;
	m_iUDPIntervals = file->PartPrefs.m_iUDPIntervals;

	// NEO: DR - [DownloadReask]
	m_iReaskIntervals = file->PartPrefs.m_iReaskIntervals;

	m_iNnPReask = file->PartPrefs.m_iNnPReask;
	m_iNnPReaskIntervals = file->PartPrefs.m_iNnPReaskIntervals;

	m_iFullQReask = file->PartPrefs.m_iFullQReask;
	m_iFullQReaskIntervals = file->PartPrefs.m_iFullQReaskIntervals;
	// NEO: DR END

	// NEO: DS - [DropSources]
	m_iDropNnP = file->PartPrefs.m_iDropNnP;
	m_iDropNnPLimit = file->PartPrefs.m_iDropNnPLimit;
	m_iDropNnPLimitMode = file->PartPrefs.m_iDropNnPLimitMode;
	m_iDropNnPTimer = file->PartPrefs.m_iDropNnPTimer;

	m_iDropFullQ = file->PartPrefs.m_iDropFullQ;
	m_iDropFullQLimit = file->PartPrefs.m_iDropFullQLimit;
	m_iDropFullQLimitMode = file->PartPrefs.m_iDropFullQLimitMode;
	m_iDropFullQTimer = file->PartPrefs.m_iDropFullQTimer;

	m_iDropHighQ = file->PartPrefs.m_iDropHighQ;
	m_iDropHighQValue = file->PartPrefs.m_iDropHighQValue;
	m_iDropHighQLimit = file->PartPrefs.m_iDropHighQLimit;
	m_iDropHighQLimitMode = file->PartPrefs.m_iDropHighQLimitMode;
	m_iDropHighQTimer = file->PartPrefs.m_iDropHighQTimer;

	m_iUseDontAskThisIP = file->PartPrefs.m_iUseDontAskThisIP;
	m_iDontAskThisIPTime = file->PartPrefs.m_iDontAskThisIPTime;
	// NEO: DS END

	for (int i = 1; i < m_paFiles->GetSize(); i++)
	{
		file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[i]);

		//if (file->IsPartFile())
		if(m_iHardLimit != file->PartPrefs.m_iHardLimit) m_iHardLimit = UN_INT;
		if(m_iSwapLimit != file->PartPrefs.m_iSwapLimit) m_iSwapLimit = UN_INT;
		if(m_iCleanUpLimit != file->PartPrefs.m_iCleanUpLimit) m_iCleanUpLimit = UN_INT;
		// NEO: NSD - [NeoSourceDrop]
		if(m_iLow2LowCleanUpTime != file->PartPrefs.m_iLow2LowCleanUpTime) m_iLow2LowCleanUpTime = UN_INT;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
		if(m_iBadCleanUpTime != file->PartPrefs.m_iBadCleanUpTime) m_iBadCleanUpTime = UN_INT;
		if(m_iGoneCleanUpTime != file->PartPrefs.m_iGoneCleanUpTime) m_iGoneCleanUpTime = UN_INT;
		if(m_iSuspendCleanUpTime != file->PartPrefs.m_iSuspendCleanUpTime) m_iSuspendCleanUpTime = UN_INT;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
		if(m_iNnPCleanUpTime != file->PartPrefs.m_iNnPCleanUpTime) m_iNnPCleanUpTime = UN_INT;
		if(m_iFullQCleanUpTime != file->PartPrefs.m_iFullQCleanUpTime) m_iFullQCleanUpTime = UN_INT;
		// NEO: NSD END
		if(file->PartPrefs.m_iCalcStandardLimits != m_iCalcStandardLimits) m_iCalcStandardLimits = -1;

		// NEO: AHL - [AutoHardLimit]
		if(m_iAutoHardLimit != file->PartPrefs.m_iAutoHardLimit) m_iAutoHardLimit = -1;
		if(m_iMinimalHardLimit != file->PartPrefs.m_iMinimalHardLimit) m_iMinimalHardLimit = UN_INT;
		if(m_iAutoHardLimitTimer != file->PartPrefs.m_iAutoHardLimitTimer) m_iAutoHardLimitTimer = UN_INT;
		// NEO: AHL END
		// NEO: ASL - [AutoSoftLock]
		if(m_iAutoSoftLock != file->PartPrefs.m_iAutoSoftLock) m_iAutoSoftLock = -1;
		if(m_iAutoSoftLockValue != file->PartPrefs.m_iAutoSoftLockValue) m_iAutoSoftLockValue = UN_INT;
		// NEO: ASL END

		// NEO: XSC - [ExtremeSourceCache]
		if(m_iSourceCache != file->PartPrefs.m_iSourceCache) m_iSourceCache = -1;
		if(m_iSourceCacheLimit != file->PartPrefs.m_iSourceCacheLimit) m_iSourceCacheLimit = UN_INT;
		if(m_iSourceCacheTime != file->PartPrefs.m_iSourceCacheTime) m_iSourceCacheTime = UN_INT;
		// NEO: XSC END

		// NEO: NCAP - [NeoCustomAutoPriority]
		if(m_iDynamicAutoDownPriority != file->PartPrefs.m_iDynamicAutoDownPriority) m_iDynamicAutoDownPriority = -1;
		if(m_fDynamicDownPriorityFactor != file->PartPrefs.m_fDynamicDownPriorityFactor) m_fDynamicDownPriorityFactor = UN_FLOAT;
		if(m_iLowDownPrioThreshold != file->PartPrefs.m_iLowDownPrioThreshold) m_iLowDownPrioThreshold = UN_INT;
		if(m_iHighDownPrioThreshold != file->PartPrefs.m_iHighDownPrioThreshold) m_iHighDownPrioThreshold = UN_INT;
		// NEO: NCAP END

		if(m_iXSState != file->PartPrefs.m_iXSState) m_iXSState = -1;
		if(m_iXSLimit != file->PartPrefs.m_iXSLimit) m_iXSLimit = UN_INT;
		if(m_iXSIntervals != file->PartPrefs.m_iXSIntervals) m_iXSIntervals = UN_INT;
		if(m_iXSDelayValue != file->PartPrefs.m_iXSDelayValue) m_iXSDelayValue = UN_INT;

		if(m_iSVRState != file->PartPrefs.m_iSVRState) m_iSVRState = -1;
		if(m_iSVRLimit != file->PartPrefs.m_iSVRLimit) m_iSVRLimit = UN_INT;
		if(m_iSVRIntervals != file->PartPrefs.m_iSVRIntervals) m_iSVRIntervals = UN_INT;

		if(m_iKADState != file->PartPrefs.m_iKADState) m_iKADState = -1;
		if(m_iKADLimit != file->PartPrefs.m_iKADLimit) m_iKADLimit = UN_INT;
		if(m_iKADIntervals != file->PartPrefs.m_iKADIntervals) m_iKADIntervals = UN_INT;
		if(m_iKADDelayValue != file->PartPrefs.m_iKADDelayValue) m_iKADDelayValue = UN_INT;

		if(m_iUDPState != file->PartPrefs.m_iUDPState) m_iUDPState = -1;
		if(m_iUDPLimit != file->PartPrefs.m_iUDPLimit) m_iUDPLimit = UN_INT;
		if(m_iUDPIntervals != file->PartPrefs.m_iUDPIntervals) m_iUDPIntervals = UN_INT;

		// NEO: DR - [DownloadReask]
		if(m_iReaskIntervals != file->PartPrefs.m_iReaskIntervals) m_iReaskIntervals = UN_INT;

		if(m_iNnPReask != file->PartPrefs.m_iNnPReask) m_iNnPReask = -1;
		if(m_iNnPReaskIntervals != file->PartPrefs.m_iNnPReaskIntervals) m_iNnPReaskIntervals = UN_INT;

		if(m_iFullQReask != file->PartPrefs.m_iFullQReask) m_iFullQReask = -1;
		if(m_iFullQReaskIntervals != file->PartPrefs.m_iFullQReaskIntervals) m_iFullQReaskIntervals = UN_INT;
		// NEO: DR END

		// NEO: DS - [DropSources]
		if(m_iDropNnP != file->PartPrefs.m_iDropNnP) m_iDropNnP = -1;
		if(m_iDropNnPLimit != file->PartPrefs.m_iDropNnPLimit) m_iDropNnPLimit = UN_INT;
		if(m_iDropNnPLimitMode != file->PartPrefs.m_iDropNnPLimitMode) m_iDropNnPLimitMode = -1;
		if(m_iDropNnPTimer != file->PartPrefs.m_iDropNnPTimer) m_iDropNnPTimer = UN_INT;

		if(m_iDropFullQ != file->PartPrefs.m_iDropFullQ) m_iDropFullQ = -1;
		if(m_iDropFullQLimit != file->PartPrefs.m_iDropFullQLimit) m_iDropFullQLimit = UN_INT;
		if(m_iDropFullQLimitMode != file->PartPrefs.m_iDropFullQLimitMode) m_iDropFullQLimitMode = -1;
		if(m_iDropFullQTimer != file->PartPrefs.m_iDropFullQTimer) m_iDropFullQTimer = UN_INT;

		if(m_iDropHighQ != file->PartPrefs.m_iDropHighQ) m_iDropHighQ = -1;
		if(m_iDropHighQValue != file->PartPrefs.m_iDropHighQValue) m_iDropHighQValue = UN_INT;
		if(m_iDropHighQLimit != file->PartPrefs.m_iDropHighQLimit) m_iDropHighQLimit = UN_INT;
		if(m_iDropHighQLimitMode != file->PartPrefs.m_iDropHighQLimitMode) m_iDropHighQLimitMode = -1;
		if(m_iDropHighQTimer != file->PartPrefs.m_iDropHighQTimer) m_iDropHighQTimer = UN_INT;

		if(m_iUseDontAskThisIP != file->PartPrefs.m_iUseDontAskThisIP) m_iUseDontAskThisIP = -1;
		if(m_iDontAskThisIPTime != file->PartPrefs.m_iDontAskThisIPTime) m_iDontAskThisIPTime = UN_INT;
		// NEO: DS END
	}

	if(!m_iHardLimit)
		m_iHardLimit = thePrefs.GetHardLimit();
	else if(m_iHardLimit == UN_INT)
		m_iHardLimit = 0;

	if(!m_iSwapLimit)
		m_iSwapLimit = thePrefs.GetSwapLimit();
	else if(m_iSwapLimit == UN_INT)
		m_iSwapLimit = 0;

	if(!m_iCleanUpLimit)
		m_iCleanUpLimit = thePrefs.GetCleanUpLimit();
	else if(m_iCleanUpLimit == UN_INT)
		m_iCleanUpLimit = 0;

	// NEO: NSD - [NeoSourceDrop]
	if(!m_iLow2LowCleanUpTime)
		m_iLow2LowCleanUpTime = thePrefs.GetLow2LowCleanUpTime();
	else if(m_iLow2LowCleanUpTime == UN_INT)
		m_iLow2LowCleanUpTime = 0;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	if(!m_iBadCleanUpTime)
		m_iBadCleanUpTime = thePrefs.GetBadCleanUpTime();
	else if(m_iBadCleanUpTime == UN_INT)
		m_iBadCleanUpTime = 0;
	if(!m_iGoneCleanUpTime)
		m_iGoneCleanUpTime = thePrefs.GetGoneCleanUpTime();
	else if(m_iGoneCleanUpTime == UN_INT)
		m_iGoneCleanUpTime = 0;
	if(!m_iSuspendCleanUpTime)
		m_iSuspendCleanUpTime = thePrefs.GetSuspendCleanUpTime();
	else if(m_iSuspendCleanUpTime == UN_INT)
		m_iSuspendCleanUpTime = 0;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	if(!m_iNnPCleanUpTime)
		m_iNnPCleanUpTime = thePrefs.GetNnPCleanUpTime();
	else if(m_iNnPCleanUpTime == UN_INT)
		m_iNnPCleanUpTime = 0;
	if(!m_iFullQCleanUpTime)
		m_iFullQCleanUpTime = thePrefs.GetFullQCleanUpTime();
	else if(m_iFullQCleanUpTime == UN_INT)
		m_iFullQCleanUpTime = 0;
	// NEO: NSD END

	// NEO: AHL - [AutoHardLimit]
	if(!m_iMinimalHardLimit)
		m_iMinimalHardLimit = thePrefs.GetMinimalHardLimit();
	else if(m_iMinimalHardLimit == UN_INT)
		m_iMinimalHardLimit = 0;

	if(!m_iGlobalHardLimit)
		m_iGlobalHardLimit = thePrefs.GetGlobalHardLimit();
	else if(m_iGlobalHardLimit == UN_INT)
		m_iGlobalHardLimit = 0;

	if(!m_iAutoHardLimitTimer)
		m_iAutoHardLimitTimer = thePrefs.GetAutoHardLimitTimer();
	else if(m_iAutoHardLimitTimer == UN_INT)
		m_iAutoHardLimitTimer = 0;
	// NEO: AHL END
	// NEO: ASL - [AutoSoftLock]
	if(!m_iAutoSoftLockValue)
		m_iAutoSoftLockValue = thePrefs.GetAutoSoftLockValue();
	else if(m_iAutoSoftLockValue == UN_INT)
		m_iAutoSoftLockValue = 0;
	// NEO: ASL END

	// NEO: XSC - [ExtremeSourceCache]
	if(!m_iSourceCacheLimit)
		m_iSourceCacheLimit = thePrefs.GetSourceCacheLimit();
	else if(m_iSourceCacheLimit == UN_INT)
		m_iSourceCacheLimit = 0;

	if(!m_iSourceCacheTime)
		m_iSourceCacheTime = thePrefs.GetSourceCacheTime();
	else if(m_iSourceCacheTime == UN_INT)
		m_iSourceCacheTime = 0;
	// NEO: XSC END

	// NEO: NCAP - [NeoCustomAutoPriority]
	if (!m_fDynamicDownPriorityFactor)
		m_fDynamicDownPriorityFactor = thePrefs.GetDynamicDownPriorityFactor();
	else if(m_fDynamicDownPriorityFactor == UN_FLOAT)
		m_fDynamicDownPriorityFactor = 0;

	if (!m_iLowDownPrioThreshold)
		m_iLowDownPrioThreshold = thePrefs.GetLowDownPrioThreshold();
	else if(m_iLowDownPrioThreshold == UN_INT)
		m_iLowDownPrioThreshold = 0;

	if (!m_iHighDownPrioThreshold)
		m_iHighDownPrioThreshold = thePrefs.GetHighDownPrioThreshold();
	else if(m_iHighDownPrioThreshold == UN_INT)
		m_iHighDownPrioThreshold = 0;
	// NEO: NCAP END

	if(!m_iXSLimit)
		m_iXSLimit = thePrefs.GetXSLimit();
	else if(m_iXSLimit == UN_INT)
		m_iXSLimit = 0;
	if(!m_iXSIntervals)
		m_iXSIntervals = thePrefs.GetXSIntervals();
	else if(m_iXSIntervals == UN_INT)
		m_iXSIntervals = 0;
	if(!m_iXSDelayValue)
		m_iXSDelayValue = thePrefs.GetXSDelayValue();
	else if(m_iXSDelayValue == UN_INT)
		m_iXSDelayValue = 0;

	if(!m_iSVRLimit)
		m_iSVRLimit = thePrefs.GetSVRLimit();
	else if(m_iSVRLimit == UN_INT)
		m_iSVRLimit = 0;
	if(!m_iSVRIntervals)
		m_iSVRIntervals = thePrefs.GetSVRIntervals();
	else if(m_iSVRIntervals == UN_INT)
		m_iSVRIntervals = 0;

	if(!m_iKADLimit)
		m_iKADLimit = thePrefs.GetKADLimit();
	else if(m_iKADLimit == UN_INT)
		m_iKADLimit = 0;
	if(!m_iKADIntervals)
		m_iKADIntervals = thePrefs.GetKADIntervals();
	else if(m_iKADIntervals == UN_INT)
		m_iKADIntervals = 0;
	if(!m_iKADDelayValue)
		m_iKADDelayValue = thePrefs.GetKADDelayValue();
	else if(m_iKADDelayValue == UN_INT)
		m_iKADDelayValue = 0;


	if(!m_iUDPLimit)
		m_iUDPLimit = thePrefs.GetUDPLimit();
	else if(m_iUDPLimit == UN_INT)
		m_iUDPLimit = 0;

	if(!m_iUDPIntervals)
		m_iUDPIntervals = thePrefs.GetUDPIntervals();
	else if(m_iUDPIntervals == UN_INT)
		m_iUDPIntervals = 0;

	// NEO: DR - [DownloadReask]
	if(!m_iReaskIntervals)
		m_iReaskIntervals = thePrefs.GetReaskIntervals();
	else if(m_iReaskIntervals == UN_INT)
		m_iReaskIntervals = 0;

	if(!m_iNnPReaskIntervals)
		m_iNnPReaskIntervals = thePrefs.GetNnPReaskIntervals();
	else if(m_iNnPReaskIntervals == UN_INT)
		m_iNnPReaskIntervals = 0;

	if(!m_iFullQReaskIntervals)
		m_iFullQReaskIntervals = thePrefs.GetFullQReaskIntervals();
	else if(m_iFullQReaskIntervals == UN_INT)
		m_iFullQReaskIntervals = 0;
	// NEO: DR END

	// NEO: DS - [DropSources]
	if(!m_iDropNnPLimit)
		m_iDropNnPLimit = thePrefs.GetDropNnPLimit();
	else if(m_iDropNnPLimit == UN_INT)
		m_iDropNnPLimit = 0;
	if(!m_iDropNnPTimer)
		m_iDropNnPTimer = thePrefs.GetDropNnPTimer();
	else if(m_iDropNnPTimer == UN_INT)
		m_iDropNnPTimer = 0;

	if(!m_iDropFullQLimit)
		m_iDropFullQLimit = thePrefs.GetDropFullQLimit();
	else if(m_iDropFullQLimit == UN_INT)
		m_iDropFullQLimit = 0;
	if(!m_iDropFullQTimer)
		m_iDropFullQTimer = thePrefs.GetDropFullQTimer();
	else if(m_iDropFullQTimer == UN_INT)
		m_iDropFullQTimer = 0;

	if(!m_iDropFullQLimit)
		m_iDropFullQLimit = thePrefs.GetDropFullQLimit();
	else if(m_iDropFullQLimit == UN_INT)
		m_iDropFullQLimit = 0;

	if(!m_iDropHighQValue)
		m_iDropHighQValue = thePrefs.GetDropHighQValue();
	else if(m_iDropHighQValue == UN_INT)
		m_iDropHighQValue = 0;
	if(!m_iDropHighQLimit)
		m_iDropHighQLimit = thePrefs.GetDropHighQLimit();
	else if(m_iDropHighQLimit == UN_INT)
		m_iDropHighQLimit = 0;
	if(!m_iDropHighQTimer)
		m_iDropHighQTimer = thePrefs.GetDropHighQTimer();
	else if(m_iDropHighQTimer == UN_INT)
		m_iDropHighQTimer = 0;

	if(!m_iDontAskThisIPTime)
		m_iDontAskThisIPTime = thePrefs.GetDontAskThisIPCleanUpTime();
	else if(m_iDontAskThisIPTime == UN_INT)
		m_iDontAskThisIPTime = 0;
	// NEO: DS END

	UpdateData(FALSE);

}

void CPPgSources::OnTimer(UINT /*nIDEvent*/)
{
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
}

BOOL CPPgSources::OnSetActive()
{
	if (!CPropertyPage::OnSetActive())
		return FALSE;
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CPPgSources::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}
// NEO: FCFG END

void CPPgSources::OnDestroy()
{
	// NEO: FCFG - [FileConfiguration]
	if (m_timer){
		KillTimer(m_timer);
		m_timer = 0;
	}
	// NEO: FCFG END

	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

/*void CPPgSources::Localize()
{
}*/

BOOL CPPgSources::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

LRESULT CPPgSources::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){
			// NEO: FCFG - [FileConfiguration]
			if(m_htiHardLimit && pton->hItem == m_htiHardLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiHardLimit, VAL_HARD_LIMIT_MIN, ForFile() ? thePrefs.GetHardLimit() : VAL_HARD_LIMIT_DEF, VAL_HARD_LIMIT_MAX)) SetModified();
			} else
			if(m_htiSwapLimit && pton->hItem == m_htiSwapLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSwapLimit, VAL_SWAP_LIMIT_MIN, ForFile() ? thePrefs.GetSwapLimit() : VAL_SWAP_LIMIT_DEF, VAL_SWAP_LIMIT_MAX)) SetModified();
			} else
			if(m_htiCleanUpLimit && pton->hItem == m_htiCleanUpLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiCleanUpLimit, VAL_CLEANUP_LIMIT_MIN, ForFile() ? thePrefs.GetCleanUpLimit() : VAL_CLEANUP_LIMIT_DEF, VAL_CLEANUP_LIMIT_MAX)) SetModified();
			} else

			// NEO: NSD - [NeoSourceDrop]
			if(m_htiLow2LowCleanUpTime && pton->hItem == m_htiLow2LowCleanUpTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLow2LowCleanUpTime, VAL_CLEANUP_TIME_MIN, ForFile() ? thePrefs.GetLow2LowCleanUpTime() : VAL_CLEANUP_TIME_DEF_L2L, VAL_CLEANUP_TIME_MAX)) SetModified();
			} else
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
			if(m_htiBadCleanUpTime && pton->hItem == m_htiBadCleanUpTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiBadCleanUpTime, VAL_CLEANUP_TIME_MIN, ForFile() ? thePrefs.GetBadCleanUpTime() : VAL_CLEANUP_TIME_DEF_BAD, VAL_CLEANUP_TIME_MAX)) SetModified();
			} else
			if(m_htiGoneCleanUpTime && pton->hItem == m_htiGoneCleanUpTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiGoneCleanUpTime, VAL_CLEANUP_TIME_MIN, ForFile() ? thePrefs.GetGoneCleanUpTime() : VAL_CLEANUP_TIME_DEF_GON, VAL_CLEANUP_TIME_MAX)) SetModified();
			} else
			if(m_htiSuspendCleanUpTime && pton->hItem == m_htiSuspendCleanUpTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSuspendCleanUpTime, VAL_CLEANUP_TIME_MIN, ForFile() ? thePrefs.GetSuspendCleanUpTime() : VAL_CLEANUP_TIME_DEF_SSP, VAL_CLEANUP_TIME_MAX)) SetModified();
			} else
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
			if(m_htiNnPCleanUpTime && pton->hItem == m_htiNnPCleanUpTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiNnPCleanUpTime, VAL_CLEANUP_TIME_MIN, ForFile() ? thePrefs.GetNnPCleanUpTime() : VAL_CLEANUP_TIME_DEF_NNP, VAL_CLEANUP_TIME_MAX)) SetModified();
			} else
			if(m_htiFullQCleanUpTime && pton->hItem == m_htiFullQCleanUpTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFullQCleanUpTime, VAL_CLEANUP_TIME_MIN, ForFile() ? thePrefs.GetFullQCleanUpTime() : VAL_CLEANUP_TIME_DEF_FLQ, VAL_CLEANUP_TIME_MAX)) SetModified();
			} else
			// NEO: NSD END

			// NEO: AHL - [AutoHardLimit]
			if(m_htiMinimalHardLimit && pton->hItem == m_htiMinimalHardLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMinimalHardLimit, VAL_AHL_MIN_SRC_MIN, ForFile() ? thePrefs.GetMinimalHardLimit() : VAL_AHL_MIN_SRC_DEF, VAL_AHL_MIN_SRC_MAX)) SetModified();
			} else
			if(m_htiGlobalHardLimit && pton->hItem == m_htiGlobalHardLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiGlobalHardLimit, VAL_AHL_GLOBAL_SRC_MIN, ForFile() ? thePrefs.GetGlobalHardLimit() : VAL_AHL_GLOBAL_SRC_DEF, VAL_AHL_GLOBAL_SRC_MAX)) SetModified();
			} else
			if(m_htiAutoHardLimitTimer && pton->hItem == m_htiAutoHardLimitTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAutoHardLimitTimer, TIM_AHL_MIN, ForFile() ? thePrefs.GetAutoHardLimitTimer() : TIM_AHL_DEF, TIM_AHL_MAX)) SetModified();
			} else
			// NEO: AHL END
			// NEO: ASL - [AutoSoftLock]
			if(m_htiAutoSoftLockValue && pton->hItem == m_htiAutoSoftLockValue){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAutoSoftLockValue, VAL_ASL_MIN, ForFile() ? thePrefs.GetAutoSoftLockValue() : VAL_ASL_DEF, VAL_ASL_MAX)) SetModified();
			}
			// NEO: ASL END
			// NEO: XSC - [ExtremeSourceCache]
			if(m_htiSourceCacheLimit && pton->hItem == m_htiSourceCacheLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceCacheLimit, VAL_SOURCE_CACHE_LIMIT_MIN, ForFile() ? thePrefs.GetSourceCacheLimit() : VAL_SOURCE_CACHE_LIMIT_DEF, VAL_SOURCE_CACHE_LIMIT_MAX)) SetModified();
			}
			if(m_htiSourceCacheTime && pton->hItem == m_htiSourceCacheTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceCacheTime, TIM_SOURCE_CACHE_TIME_MIN, ForFile() ? thePrefs.GetSourceCacheTime() : TIM_SOURCE_CACHE_TIME_DEF, TIM_SOURCE_CACHE_TIME_MAX)) SetModified();
			}
			// NEO: XSC END
			// NEO: NCAP - [NeoCustomAutoPriority]
			else if(m_htiDynamicAutoDownPriorityEnable && pton->hItem == m_htiDynamicAutoDownPriorityEnable){
				if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiDynamicAutoDownPriorityEnable, VAL_DYNAMIC_PRIORITY_FACTOR_MIN, ForFile() ? thePrefs.GetDynamicDownPriorityFactor() : VAL_DYNAMIC_PRIORITY_FACTOR_DEF, VAL_DYNAMIC_PRIORITY_FACTOR_MAX)) SetModified();
			}
			else if(m_htiLowDownPrioThreshold && pton->hItem == m_htiLowDownPrioThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLowDownPrioThreshold, VAL_LOW_DOWN_PRIO_THRESHOLD_MIN, ForFile() ? thePrefs.GetLowDownPrioThreshold() : VAL_LOW_DOWN_PRIO_THRESHOLD_DEF, VAL_LOW_DOWN_PRIO_THRESHOLD_MAX)) SetModified();
			}
			else if(m_htiHighDownPrioThreshold && pton->hItem == m_htiHighDownPrioThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiHighDownPrioThreshold, VAL_HIGH_DOWN_PRIO_THRESHOLD_MIN, ForFile() ? thePrefs.GetHighDownPrioThreshold() : VAL_HIGH_DOWN_PRIO_THRESHOLD_DEF, VAL_HIGH_DOWN_PRIO_THRESHOLD_MAX)) SetModified();
			}
			// NEO: NCAP END
			else if(m_htiRareFileLimit && pton->hItem == m_htiRareFileLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiRareFileLimit, VAL_RARE_FILE_MIN, /*ForFile() ? thePrefs.GetHighDownPrioThreshold() :*/ VAL_RARE_FILE_DEF, VAL_RARE_FILE_MAX)) SetModified();
			}
				else if(m_htiXSLimit && pton->hItem == m_htiXSLimit){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiXSLimit, VAL_XS_LIMIT_MIN, ForFile() ? thePrefs.GetXSLimit() : VAL_XS_LIMIT_DEF, VAL_XS_LIMIT_MAX)) SetModified();
 				}else if(m_htiXSIntervals && pton->hItem == m_htiXSIntervals){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiXSIntervals, TIM_XS_INTERVAL_MIN, ForFile() ? thePrefs.GetXSIntervals() : TIM_XS_INTERVAL_DEF, TIM_XS_INTERVAL_MAX)) SetModified();
 				}else if(m_htiXSClientIntervals && pton->hItem == m_htiXSClientIntervals){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiXSClientIntervals, TIM_XS_CLIENT_INTERVAL_MIN, /*ForFile() ? thePrefs.GetXSClientIntervals() :*/ TIM_XS_CLIENT_INTERVAL_DEF, TIM_XS_CLIENT_INTERVAL_MAX)) SetModified();
 				}else if(m_htiXSDelay && pton->hItem == m_htiXSDelay){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiXSDelay, VAL_XS_DELAY_MIN, ForFile() ? thePrefs.GetXSDelayValue() : VAL_XS_DELAY_DEF, VAL_XS_DELAY_MAX)) SetModified();
 				}
				else if(m_htiSVRLimit && pton->hItem == m_htiSVRLimit){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSVRLimit, VAL_SVR_LIMIT_MIN, ForFile() ? thePrefs.GetSVRLimit() : VAL_SVR_LIMIT_DEF, VAL_SVR_LIMIT_MAX)) SetModified();
 				}else if(m_htiSVRIntervals && pton->hItem == m_htiSVRIntervals){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSVRIntervals, TIM_SVR_INTERVAL_MIN, ForFile() ? thePrefs.GetSVRIntervals() : TIM_SVR_INTERVAL_DEF, TIM_SVR_INTERVAL_MAX)) SetModified();
 				}
				else if(m_htiKADLimit && pton->hItem == m_htiKADLimit){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiKADLimit, VAL_KAD_LIMIT_MIN, ForFile() ? thePrefs.GetKADLimit() : VAL_KAD_LIMIT_DEF, VAL_KAD_LIMIT_MAX)) SetModified();
 				}else if(m_htiKADIntervals && pton->hItem == m_htiKADIntervals){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiKADIntervals, TIM_KAD_INTERVAL_MIN, ForFile() ? thePrefs.GetKADIntervals() : TIM_KAD_INTERVAL_DEF, TIM_KAD_INTERVAL_MAX)) SetModified();
 				}else if(m_htiKADAmount && pton->hItem == m_htiKADAmount){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiKADAmount, VAL_KAD_AMOUNT_MIN, /*ForFile() ? thePrefs.GetKADAmount() :*/ VAL_KAD_AMOUNT_DEF, VAL_KAD_AMOUNT_MAX)) SetModified();
 				}else if(m_htiKADDelay && pton->hItem == m_htiKADDelay){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiKADDelay, VAL_KAD_DELAY_MIN, ForFile() ? thePrefs.GetKADDelayValue() : VAL_KAD_DELAY_DEF, VAL_KAD_DELAY_MAX)) SetModified();
 				}
				else if(m_htiUDPLimit && pton->hItem == m_htiUDPLimit){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiUDPLimit, VAL_UDP_LIMIT_MIN, ForFile() ? thePrefs.GetUDPLimit() : VAL_UDP_LIMIT_DEF, VAL_UDP_LIMIT_MAX)) SetModified();
 				}else if(m_htiUDPIntervals && pton->hItem == m_htiUDPIntervals){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiUDPIntervals, TIM_UDP_INTERVAL_MIN, ForFile() ? thePrefs.GetUDPIntervals() : TIM_UDP_INTERVAL_DEF, TIM_UDP_INTERVAL_MAX)) SetModified();
 				}else if(m_htiGlobalUDPIntervals && pton->hItem == m_htiGlobalUDPIntervals){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiGlobalUDPIntervals, TIM_UDP_INTERVAL_MIN, /*ForFile() ? thePrefs.GetGlobalUDPIntervals() :*/ TIM_UDP_INTERVAL_DEF, TIM_UDP_INTERVAL_MAX)) SetModified();
 				}else if(m_htiUDPAmount && pton->hItem == m_htiUDPAmount){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiUDPAmount, VAL_UDP_AMOUNT_MIN, /*ForFile() ? thePrefs.GetUDPAmount() :*/ VAL_UDP_AMOUNT_DEF, VAL_UDP_AMOUNT_MAX)) SetModified();
				}
				// NEO: XUC - [ExtendedUdpCache]
				else if(m_htiUDPCache && pton->hItem == m_htiUDPCache){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiUDPCache, VAL_UDP_CATCH_AMOUNT_MIN, /*ForFile() ? thePrefs.GetUDPCacheAmount() :*/ VAL_UDP_CATCH_AMOUNT_DEF, VAL_UDP_CATCH_AMOUNT_MAX)) SetModified();
				}
				// NEO: XUC END
			// NEO: DR - [DownloadReask]
			// NEO: SR - [SpreadReask]
			else if(!ForFile() && m_htiSpreadReask && pton->hItem == m_htiSpreadReask){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSpreadReask, VAL_SPREAD_REASK_MIN, VAL_SPREAD_REASK_DEF, VAL_SPREAD_REASK_MAX)) SetModified();
			}
			// NEO: SR END
			else if(m_htiReaskIntervals && pton->hItem == m_htiReaskIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskIntervals, TIM_REASK_MIN, ForFile() ? thePrefs.GetReaskIntervals() : TIM_REASK_DEF, TIM_REASK_MAX)) SetModified();
			}
			else if(m_htiReaskNnPIntervals && pton->hItem == m_htiReaskNnPIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskNnPIntervals, TIM_REASK_NNP_MIN, ForFile() ? thePrefs.GetNnPReaskIntervals() : TIM_REASK_NNP_DEF, TIM_REASK_NNP_MAX)) SetModified();
			}
			else if(m_htiReaskFullQIntervals && pton->hItem == m_htiReaskFullQIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskFullQIntervals, TIM_REASK_FULLQ_MIN, ForFile() ? thePrefs.GetFullQReaskIntervals() : TIM_REASK_FULLQ_DEF, TIM_REASK_FULLQ_MAX)) SetModified();
			}
			// NEO: DR END
			// NEO: DS - [DropSources]
			else if(m_htiDontAskThisIPTime && pton->hItem == m_htiDontAskThisIPTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDontAskThisIPTime, VAL_DONT_ASK_THIS_IP_TIME_MIN, ForFile() ? thePrefs.GetDontAskThisIPCleanUpTime() : VAL_DONT_ASK_THIS_IP_TIME_DEF, VAL_DONT_ASK_THIS_IP_TIME_MAX)) SetModified();
			}
			else if(m_htiDropNnPLimit && pton->hItem == m_htiDropNnPLimit){
				int m_iLimitMode; HTREEITEM hDummy;
				m_ctrlTreeOptions.GetRadioButton(m_htiDropNnPLimit,m_iLimitMode,hDummy);
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropNnPLimit, VAL_DROP_LIMIT_MIN(m_iLimitMode), (ForFile() && m_iLimitMode == thePrefs.m_iDropNnPLimitMode)? thePrefs.GetDropNnPLimit() : VAL_DROP_LIMIT_DEF(m_iLimitMode), VAL_DROP_LIMIT_MAX(m_iLimitMode))) SetModified();
			}
			else if(m_htiDropNnPTimer && pton->hItem == m_htiDropNnPTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropNnPTimer, TIM_DROP_MIN, ForFile() ? thePrefs.GetDropNnPTimer() : TIM_DROP_DEF, TIM_DROP_MAX)) SetModified();
			}

			else if(m_htiDropFullQLimit && pton->hItem == m_htiDropFullQLimit){
				int m_iLimitMode; HTREEITEM hDummy;
				m_ctrlTreeOptions.GetRadioButton(m_htiDropFullQLimit,m_iLimitMode,hDummy);
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropFullQLimit, VAL_DROP_LIMIT_MIN(m_iLimitMode), (ForFile() && m_iLimitMode == thePrefs.m_iDropFullQLimitMode) ? thePrefs.GetDropFullQLimit() : VAL_DROP_LIMIT_DEF(m_iLimitMode), VAL_DROP_LIMIT_MAX(m_iLimitMode))) SetModified();
			}
			else if(m_htiDropFullQTimer && pton->hItem == m_htiDropFullQTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropFullQTimer, TIM_DROP_MIN, ForFile() ? thePrefs.GetDropFullQTimer() : TIM_DROP_DEF, TIM_DROP_MAX)) SetModified();
			}

			else if(m_htiDropHighQLimit && pton->hItem == m_htiDropHighQLimit){
				int m_iLimitMode; HTREEITEM hDummy;
				m_ctrlTreeOptions.GetRadioButton(m_htiDropHighQLimit,m_iLimitMode,hDummy);
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropHighQLimit, VAL_DROP_LIMIT_MIN(m_iLimitMode), (ForFile() && m_iLimitMode == thePrefs.m_iDropHighQLimitMode) ? thePrefs.GetDropHighQLimit() : VAL_DROP_LIMIT_DEF(m_iLimitMode), VAL_DROP_LIMIT_MAX(m_iLimitMode))) SetModified();
			}
			else if(m_htiDropHighQTimer && pton->hItem == m_htiDropHighQTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropHighQTimer, TIM_DROP_MIN, ForFile() ? thePrefs.GetDropHighQTimer() : TIM_DROP_DEF, TIM_DROP_MAX)) SetModified();
			}
			else if(m_htiDropHighQValue && pton->hItem == m_htiDropHighQValue){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropHighQValue, VAL_DROP_HQ_VALUE_MIN, ForFile() ? thePrefs.GetDropHighQValue() : VAL_DROP_HQ_VALUE_DEF, VAL_DROP_HQ_VALUE_MAX)) SetModified();
			}
			// NEO: DS END
			// NEO: FCFG END
			
		}else{
			UINT bCheck;
			// NEO: XUC - [ExtendedUdpCache]
			if (m_htiUDPCache && pton->hItem == m_htiUDPCache){
				m_ctrlTreeOptions.GetCheckBox(m_htiUDPCache, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiUDPCache, bCheck, TRUE, TRUE);
			}
			// NEO: XUC END
			/*else if (m_htiCalcStandardLimits && pton->hItem == m_htiCalcStandardLimits){
				CheckSLEnable();
			}
			else if (m_htiCalcStandardLimitsDefault && pton->hItem == m_htiCalcStandardLimitsDefault){
				CheckSLEnable();
			}
			else if (m_htiCalcStandardLimitsEnable && pton->hItem == m_htiCalcStandardLimitsEnable){
				CheckSLEnable();
			}
			else if (m_htiCalcStandardLimitsDisable && pton->hItem == m_htiCalcStandardLimitsDisable){
				CheckSLEnable();
			}*/
			// NEO: SR - [SpreadReask]
			if (!ForFile() && m_htiSpreadReask && pton->hItem == m_htiSpreadReask){
				m_ctrlTreeOptions.GetCheckBox(m_htiSpreadReask, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiSpreadReask, bCheck, TRUE, TRUE);
			}
			// NEO: SR END
			if (!ForFile() && m_htiDontAskThisIPTime && pton->hItem == m_htiDontAskThisIPTime){
				m_ctrlTreeOptions.GetCheckBox(m_htiDontAskThisIPTime, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiDontAskThisIPTime, bCheck, TRUE, TRUE);
			}
			SetModified();
		}
	}
	return 0;
}

// NEO: NST - [NeoSourceTweaks]
/*void CPPgSources::CheckSLEnable()
{
	UINT bCheck;
	if(!ForFile())
		m_ctrlTreeOptions.GetCheckBox(m_htiCalcStandardLimits, bCheck)
	else{
		int Index;
		m_ctrlTreeOptions.GetRadioButton(m_htiCalcStandardLimits, Index);
		if(Index == 1 || (Index == 0 && thePrefs.IsCalcStandardLimits()))
			bCheck = 1
		else
			bCheck = 0;
	}
	m_ctrlTreeOptions.SetItemEnable(m_htiXSLimit, bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiSVRLimit, bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiKADLimit, bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiUDPLimit, bCheck);
}*/
// NEO: NST END


LRESULT CPPgSources::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_MOD_OPTS_INFO, *sInfo);
	}
	return FALSE;
}

void CPPgSources::OnHelp()
{
	//theApp.ShowHelp(0);
}

BOOL CPPgSources::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgSources::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}
