//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "Neo\GUI\CP\TreeOptionsCtrl.h" // NEO - [TreeControl]

class CPPgSourceStorage : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgSourceStorage)

public:
	CPPgSourceStorage();
	virtual ~CPPgSourceStorage();

	void SetFiles(const CSimpleArray<CObject*>* paFiles) { m_paFiles = paFiles; m_bDataChanged = true; m_bFilePreferences = true; } // NEO: FCFG - [FileConfiguration]

	// Dialog Data
	enum { IDD = IDD_PPG_MOD };

protected:
	// NEO: FCFG - [FileConfiguration]
	//CString m_strCaption;
	const CSimpleArray<CObject*>* m_paFiles;
	bool m_bDataChanged;
	uint32 m_timer;
	static LPCTSTR sm_pszNotAvail;

	bool m_bFilePreferences; // We use the same dialog ro the Prefs and the File Prefs
	// NEO: FCFG END

	CTreeOptionsCtrl m_ctrlTreeOptions; // NEO - [TreeControl]
	bool m_bInitializedTreeOpts;

	HTREEITEM m_htiNeoSourceStorage;
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		HTREEITEM m_htiSourceKeeper;
			HTREEITEM m_htiSourceKeeperDefault;
			HTREEITEM m_htiSourceKeeperEnable;
			HTREEITEM m_htiSourceKeeperDisable;
#endif // NEO_SK // NEO: NSK END		
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		HTREEITEM m_htiSourceStorage;
			HTREEITEM m_htiUseSourceStorage;
				HTREEITEM m_htiUseSourceStorageDefault;
				HTREEITEM m_htiUseSourceStorageEnable;
				HTREEITEM m_htiUseSourceStorageDisable;
			HTREEITEM m_htiAutoSaveSources;
				HTREEITEM m_htiAutoSaveSourcesDefault;
				HTREEITEM m_htiAutoSaveSourcesEnable;
				HTREEITEM m_htiAutoSaveSourcesEnable2;
				HTREEITEM m_htiAutoSaveSourcesDisable;
				HTREEITEM m_htiAutoSaveSourcesIntervals;
			HTREEITEM m_htiSourceStorageLimit;
			HTREEITEM m_htiStoreSources;
				HTREEITEM m_htiStoreLowIDSources;
					HTREEITEM m_htiStoreLowIDSourcesDefault;
					HTREEITEM m_htiStoreLowIDSourcesEnable;
					HTREEITEM m_htiStoreLowIDSourcesDisable;
				HTREEITEM m_htiStoreAlsoA4AFSources;
					HTREEITEM m_htiStoreAlsoA4AFSourcesDefault;
					HTREEITEM m_htiStoreAlsoA4AFSourcesEnable;
					HTREEITEM m_htiStoreAlsoA4AFSourcesDisable;
				HTREEITEM m_htiStoreSourcesFileStatus;
					HTREEITEM m_htiStoreSourcesFileStatusDefault;
					HTREEITEM m_htiStoreSourcesFileStatusEnable;
					HTREEITEM m_htiStoreSourcesFileStatusSemiEnable;
					HTREEITEM m_htiStoreSourcesFileStatusDisable;
			HTREEITEM m_htiAutoLoadStoredSources;
				HTREEITEM m_htiAutoLoadStoredSourcesDefault;
				HTREEITEM m_htiAutoLoadStoredSourcesEnable;
				HTREEITEM m_htiAutoLoadStoredSourcesSemiEnable;
				HTREEITEM m_htiAutoLoadStoredSourcesDisable;
				HTREEITEM m_htiStorageBootstrap;
					HTREEITEM m_htiStorageBootstrapDefault;
					HTREEITEM m_htiStorageBootstrapEnable;
					HTREEITEM m_htiStorageBootstrapDisable;
					HTREEITEM m_htiStorageBootstrapTime;
					HTREEITEM m_htiStorageBootstrapRequirement;
			HTREEITEM m_htiAutoReaskStoredSources;
				HTREEITEM m_htiAutoReaskStoredSourcesDefault;
				HTREEITEM m_htiAutoReaskStoredSourcesEnable;
				HTREEITEM m_htiAutoReaskStoredSourcesDisable;
				HTREEITEM m_htiAutoReaskStoredSourcesLimit;
					HTREEITEM m_htiTotalSourceRestoreDefault;
					HTREEITEM m_htiTotalSourceRestoreEnable;
					HTREEITEM m_htiTotalSourceRestoreDisable;
				HTREEITEM m_htiAutoReaskStoredSourcesDelay;
					HTREEITEM m_htiAutoReaskStoredSourcesDelayDefault;
					HTREEITEM m_htiAutoReaskStoredSourcesDelayEnable;
					HTREEITEM m_htiAutoReaskStoredSourcesDelayDisable;
				HTREEITEM m_htiAutoReaskLoadedSourcesDelay;
				HTREEITEM m_htiGroupStoredSourceReask;
					HTREEITEM m_htiGroupStoredSourceReaskDefault;
					HTREEITEM m_htiGroupStoredSourceReaskEnable;
					HTREEITEM m_htiGroupStoredSourceReaskDisable;
					HTREEITEM m_htiStoredSourceGroupIntervals;
					HTREEITEM m_htiStoredSourceGroupSize;
			HTREEITEM m_htiOutOfDate;
				HTREEITEM m_htiUseSmoothOutOfDate;
					HTREEITEM m_htiUseSmoothOutOfDateDefault;
					HTREEITEM m_htiUseSmoothOutOfDateEnable;
					HTREEITEM m_htiUseSmoothOutOfDateDisable;
				HTREEITEM m_htiMaxStoredFaildCount;
				HTREEITEM m_htiStoredOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
		HTREEITEM m_htiClientDatabase;
			HTREEITEM m_htiEnableSourceList;
			HTREEITEM m_htiSaveGlobalSourceList;
				HTREEITEM m_htiGlobalSourceListCleanUpTime;
				HTREEITEM m_htiGlobalSourceListCleanUp;
				HTREEITEM m_htiFastSourceCleanUp;
			HTREEITEM m_htiSaveSourceFileList;
				HTREEITEM m_htiSourceFileListCleanUpTime;
			HTREEITEM m_htiSaveSourceDataInClient;

			HTREEITEM m_htiIPZoneCheck;

			HTREEITEM m_htiSourceHashMonitor;
				HTREEITEM m_htiSourceHashMonitorBadTime;
				HTREEITEM m_htiSourceHashMonitorMaxBad;

			HTREEITEM m_htiIPTables;
				HTREEITEM m_htiTableAmountToStore;

				HTREEITEM m_htiIgnoreUnreachableInterval;
				HTREEITEM m_htiIgnoreUndefinedInterval;
				HTREEITEM m_htiBeginNewTableInterval;
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		HTREEITEM m_htiSourceAnaliser;
			HTREEITEM m_htiSourceAnaliserDefault;
			HTREEITEM m_htiSourceAnaliserEnable;
			HTREEITEM m_htiSourceAnaliserDisable;
			HTREEITEM m_htiAnaliseIntervals;
			HTREEITEM m_htiTableAmountToAnalise;
			HTREEITEM m_htiDontStoreTemporarySources;
				HTREEITEM m_htiDontStoreTemporarySourcesDefault;
				HTREEITEM m_htiDontStoreTemporarySourcesEnable;
				HTREEITEM m_htiDontStoreTemporarySourcesDisable;
			HTREEITEM m_htiReaskManager;
				HTREEITEM m_htiPropabilityMode;
					HTREEITEM m_htiPropabilityModeDefault;
					HTREEITEM m_htiPropabilityModeNormal;
					HTREEITEM m_htiPropabilityModeHigh;
					HTREEITEM m_htiPropabilityModeAuto;
					HTREEITEM m_htiPropabilityModeEnhanced;
				HTREEITEM m_htiReaskPropability;
				HTREEITEM m_htiReservePropability;
					HTREEITEM m_htiAutoReserveReaskDefault;
					HTREEITEM m_htiAutoReserveReaskEnable;
					HTREEITEM m_htiAutoReserveReaskDisable;
					HTREEITEM m_htiReserveReaskPropability;
					HTREEITEM m_htiReaskReserveSourcesDelay;
						HTREEITEM m_htiReaskReserveSourcesDelayDefault;
						HTREEITEM m_htiReaskReserveSourcesDelayEnable;
						HTREEITEM m_htiReaskReserveSourcesDelayDisable;
					HTREEITEM m_htiReaskReserveSourcesLimit;
				HTREEITEM m_htiTemporarySources;
					HTREEITEM m_htiTemporarySourcesDefault;
					HTREEITEM m_htiTemporarySourcesEnable;
					HTREEITEM m_htiTemporarySourcesDisable;
					HTREEITEM m_htiTemporaryReaskPropability;
					HTREEITEM m_htiReaskTemporarySourcesDelay;
						HTREEITEM m_htiReaskTemporarySourcesDelayDefault;
						HTREEITEM m_htiReaskTemporarySourcesDelayEnable;
						HTREEITEM m_htiReaskTemporarySourcesDelayDisable;
					HTREEITEM m_htiReaskTemporarySourcesLimit;
				//HTREEITEM m_htiMinAnalisisQuality;
				//	HTREEITEM m_htiAutoUnsureReaskDefault;
				//	HTREEITEM m_htiAutoUnsureReaskEnable;
				//	HTREEITEM m_htiAutoUnsureReaskDisable;
				//	HTREEITEM m_htiReaskUnsureSourcesDelay;
				//		HTREEITEM m_htiReaskUnsureSourcesDelayDefault;
				//		HTREEITEM m_htiReaskUnsureSourcesDelayEnable;
				//		HTREEITEM m_htiReaskUnsureSourcesDelayDisable;
				//	HTREEITEM m_htiReaskUnsureSourcesLimit;
				HTREEITEM m_htiUnpredictedPropability;
					HTREEITEM m_htiUnpredictedPropabilityDefault;
					HTREEITEM m_htiUnpredictedPropabilityEnable;
					HTREEITEM m_htiUnpredictedPropabilityDisable;
					HTREEITEM m_htiUnpredictedPropabilityValue;
					HTREEITEM m_htiReaskUnpredictedSourcesDelay;
						HTREEITEM m_htiReaskUnpredictedSourcesDelayDefault;
						HTREEITEM m_htiReaskUnpredictedSourcesDelayEnable;
						HTREEITEM m_htiReaskUnpredictedSourcesDelayDisable;
					HTREEITEM m_htiReaskUnpredictedSourcesLimit;
				HTREEITEM m_htiFailTolerance;
					HTREEITEM m_htiFailToleranceDefault;
					HTREEITEM m_htiFailToleranceEnable;
					HTREEITEM m_htiFailToleranceDisable;
					HTREEITEM m_htiFailToleranceValue;
					HTREEITEM m_htiRetryUnreachable;
						HTREEITEM m_htiRetryUnreachableDefault;
						HTREEITEM m_htiRetryUnreachableEnable;
						HTREEITEM m_htiRetryUnreachableDisable;
						HTREEITEM m_htiRetryUnreachableIntervals;
					HTREEITEM m_htiUnreachableReaskPropability;
					HTREEITEM m_htiReaskUnreachableSourcesLimit;
			HTREEITEM m_htiAdvancedAnalyser;
				HTREEITEM m_htiDisturbanceHandling;
					HTREEITEM m_htiHandleTableGaps;
						HTREEITEM m_htiPriorityGapRatio;
						HTREEITEM m_htiMaxGapSize;
						HTREEITEM m_htiMaxGapTime;
					HTREEITEM m_htiCheckPriorityIP;
					HTREEITEM m_htiCheckPortIntegrity;
				HTREEITEM m_htiMaxMidleDiscrepanceHigh;
				HTREEITEM m_htiMaxMidleDiscrepanceLow;
				HTREEITEM m_htiLastSeenDurationThreshold;
				HTREEITEM m_htiLinkTimeThreshold;
				HTREEITEM m_htiDualLinkedTableGravity;
				HTREEITEM m_htiMaxReliableTime;
				HTREEITEM m_htiTempralIPBorderLine;
#endif // NEO_SA // NEO: NSA END

	// NEO: NSD - [NeoSourceDrop]
	HTREEITEM m_htiDropCleanUp;
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		HTREEITEM m_htiDropUnreachable;
			HTREEITEM m_htiDropUnreachableDefault;
			HTREEITEM m_htiDropUnreachableEnable;
			HTREEITEM m_htiDropUnreachableDisable;
			HTREEITEM m_htiDropUnreachableLimit;
				HTREEITEM m_htiDropUnreachableLimitDefault;
				HTREEITEM m_htiDropUnreachableLimitTotal;
				HTREEITEM m_htiDropUnreachableLimitRelativ;
				HTREEITEM m_htiDropUnreachableLimitSpecyfic;
				HTREEITEM m_htiDropUnreachableLimitDisable;
			HTREEITEM m_htiDropUnreachableTimer;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		HTREEITEM m_htiDropOutOfDate;
			HTREEITEM m_htiDropOutOfDateDefault;
			HTREEITEM m_htiDropOutOfDateEnable;
			HTREEITEM m_htiDropOutOfDateDisable;
			HTREEITEM m_htiDropOutOfDateLimit;
				HTREEITEM m_htiDropOutOfDateLimitDefault;
				HTREEITEM m_htiDropOutOfDateLimitTotal;
				HTREEITEM m_htiDropOutOfDateLimitRelativ;
				HTREEITEM m_htiDropOutOfDateLimitSpecyfic;
				HTREEITEM m_htiDropOutOfDateLimitDisable;
			HTREEITEM m_htiDropOutOfDateTimer;
			HTREEITEM m_htiDropOutOfDatePrefs;
				HTREEITEM m_htiDropOutOfDateSmooth;
					HTREEITEM m_htiDropOutOfDateSmoothDefault;
					HTREEITEM m_htiDropOutOfDateSmoothEnable;
					HTREEITEM m_htiDropOutOfDateSmoothDisable;
				HTREEITEM m_htiDropOutOfDateFails;
				HTREEITEM m_htiDropOutOfDateTime;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		HTREEITEM m_htiDropRetired;
			HTREEITEM m_htiDropRetiredDefault;
			HTREEITEM m_htiDropRetiredEnable;
			HTREEITEM m_htiDropRetiredDisable;
			HTREEITEM m_htiDropRetiredLimit;
				HTREEITEM m_htiDropRetiredLimitDefault;
				HTREEITEM m_htiDropRetiredLimitTotal;
				HTREEITEM m_htiDropRetiredLimitRelativ;
				HTREEITEM m_htiDropRetiredLimitSpecyfic;
				HTREEITEM m_htiDropRetiredLimitDisable;
			HTREEITEM m_htiDropRetiredTimer;

		HTREEITEM m_htiDropLoaded;
			HTREEITEM m_htiDropLoadedDefault;
			HTREEITEM m_htiDropLoadedEnable;
			HTREEITEM m_htiDropLoadedDisable;
			HTREEITEM m_htiDropLoadedLimit;
				HTREEITEM m_htiDropLoadedLimitDefault;
				HTREEITEM m_htiDropLoadedLimitTotal;
				HTREEITEM m_htiDropLoadedLimitRelativ;
				HTREEITEM m_htiDropLoadedLimitSpecyfic;
				HTREEITEM m_htiDropLoadedLimitDisable;
			HTREEITEM m_htiDropLoadedTimer;
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	int		m_iEnableSourceKeeper;
	bool	m_bEnableSourceKeeper;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	int		m_iEnableSourceStorage;
	bool	m_bEnableSourceStorage;
	int		m_iAutoSaveSources;
	UINT	m_uAutoSaveSources;
	int		m_iAutoSaveSourcesIntervals;
	int		m_iSourceStorageLimit;
	int		m_iStoreLowIDSources;
	bool	m_bStoreLowIDSources;
	int		m_iStoreAlsoA4AFSources;
	bool	m_bStoreAlsoA4AFSources;
	int		m_iStoreSourcesFileStatus;
	UINT	m_uStoreSourcesFileStatus;
	int		m_iAutoLoadStoredSources;
	UINT	m_bAutoLoadStoredSources;
	int		m_iUseStorageBootstrap;
	bool	m_bUseStorageBootstrap;
	int		m_iStorageBootstrapTime;
	int		m_iStorageBootstrapRequirement;

	int		m_iAutoReaskStoredSources;
	bool	m_bAutoReaskStoredSources;
	int		m_iAutoReaskStoredSourcesLimit;
	int		m_iTotalSourceRestore;
	bool	m_bTotalSourceRestore;
	int		m_iUseAutoReaskStoredSourcesDelay;
	bool	m_bUseAutoReaskStoredSourcesDelay;
	int		m_iAutoReaskStoredSourcesDelay;

	int		m_iAutoReaskLoadedSourcesDelay;

	int		m_iGroupStoredSourceReask;
	bool	m_bGroupStoredSourceReask;
	int		m_iStoredSourceGroupIntervals;
	int		m_iStoredSourceGroupSize;

	int		m_iUseSmoothOutOfDate;
	bool	m_bUseSmoothOutOfDate;
	int		m_iMaxStoredFaildCount;
	int		m_iStoredOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	bool	m_bEnableSourceList;
	UINT	m_uSaveGlobalSourceList;
	int		m_iGlobalSourceListCleanUpTime;
	bool	m_bGlobalSourceListCleanUp;
	int		m_iGlobalSourceListCleanUpIntervals;
	bool	m_bFastSourceCleanUp;
	bool	m_bSaveSourceFileList;
	int		m_iSourceFileListCleanUpTime;
	bool	m_bSaveSourceDataInClient;

	bool	m_bIPZoneCheck;

	bool	m_bSourceHashMonitor;
	int		m_iSourceHashMonitorBadTime;
	int		m_iSourceHashMonitorMaxBad;

	int		m_iTableAmountToStore;

	int		m_iIgnoreUnreachableInterval;
	int		m_iIgnoreUndefinedInterval;
	int		m_iBeginNewTableInterval;
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	int		m_iEnableSourceAnalizer;
	bool	m_bEnableSourceAnalizer;
	int		m_iAnaliseIntervals;
	int		m_iTableAmountToAnalise;

	int		m_iDontStoreTemporarySources;
	bool	m_bDontStoreTemporarySources;

	int		m_iPropabilityMode;
	float	m_fEnhancedFactor;

	int		m_iReaskPropability;
	int		m_iReservePropability;

	int		m_iAutoReserveReask;
	bool	m_bAutoReserveReask;
	int		m_iReserveReaskPropability;
	int		m_iUseReaskReserveSourcesDelay;
	bool	m_bUseReaskReserveSourcesDelay;
	int		m_iReaskReserveSourcesDelay;
	int		m_iReaskReserveSourcesLimit;

	int		m_iAutoTemporaryReask;
	bool	m_bAutoTemporaryReask;
	int		m_iTemporaryReaskPropability;
	int		m_iUseReaskTemporarySourcesDelay;
	bool	m_bUseReaskTemporarySourcesDelay;
	int		m_iReaskTemporarySourcesDelay;
	int		m_iReaskTemporarySourcesLimit;

	//int		m_iMinAnalisisQuality;

	//int		m_iAutoUnsureReask;
	//bool	m_bAutoUnsureReask;
	//int		m_iUseReaskUnsureSourcesDelay;
	//bool	m_bUseReaskUnsureSourcesDelay;
	//int		m_iReaskUnsureSourcesDelay;
	//int		m_iReaskUnsureSourcesLimit;

	int		m_iUseUnpredictedPropability;
	bool	m_bUseUnpredictedPropability;
	int		m_iUnpredictedPropability;
	int		m_iUseReaskUnpredictedSourcesDelay;
	bool	m_bUseReaskUnpredictedSourcesDelay;
	int		m_iReaskUnpredictedSourcesDelay;
	int		m_iReaskUnpredictedSourcesLimit;

	int		m_iFailTolerance;
	UINT	m_uFailTolerance;
	int		m_iMaxFailTolerance;
	int		m_iRetryUnreachable;
	UINT	m_uRetryUnreachable;
	int		m_iRetryUnreachableIntervals;
	int		m_iUnreachableReaskPropability;
	int		m_iReaskUnreachableSourcesLimit;

	bool	m_bHandleTableGaps;
	float	m_fPriorityGapRatio;
	int		m_iMaxGapSize;
	int		m_iMaxGapTime;
	bool	m_bCheckPriorityIP;
	float	m_fPriorityIPRatio;
	bool	m_bCheckPortIntegrity;
	float	m_fPortIntegrityRatio;
	float	m_fMaxMidleDiscrepanceHigh;
	float	m_fMaxMidleDiscrepanceLow;
	int		m_iLastSeenDurationThreshold;
	UINT	m_uLinkTimePropability;
	int		m_iLinkTimeThreshold;
	bool	m_bUseDualLinkedTableGravity;
	int		m_iDualLinkedTableGravity;
	bool	m_bReliableTimeMagnification;
	int		m_iMaxReliableTime;
	int		m_iTempralIPBorderLine;
#endif // NEO_SA // NEO: NSA END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	int		m_iDropUnreachable;
	bool	m_bDropUnreachable;
	int		m_iDropUnreachableLimit;
	int		m_iDropUnreachableLimitMode;
	int		m_iDropUnreachableTimer;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	int		m_iDropOutOfDate;
	bool	m_bDropOutOfDate;
	int		m_iDropOutOfDateSmooth;
	bool	m_bDropOutOfDateSmooth;
	int		m_iDropOutOfDateFails;
	int		m_iDropOutOfDateTime;
	int		m_iDropOutOfDateLimit;
	int		m_iDropOutOfDateLimitMode;
	int		m_iDropOutOfDateTimer;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	int		m_iDropRetired;
	bool	m_bDropRetired;
	int		m_iDropRetiredLimit;
	int		m_iDropRetiredLimitMode;
	int		m_iDropRetiredTimer;

	int		m_iDropLoaded;
	bool	m_bDropLoaded;
	int		m_iDropLoadedLimit;
	int		m_iDropLoadedLimitMode;
	int		m_iDropLoadedTimer;
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	void ClearAllMembers();

	//void Localize();
	void LoadSettings();
	void RefreshData(); // NEO: FCFG - [FileConfiguration]

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnSetActive(); // NEO: FCFG - [FileConfiguration]

	DECLARE_MESSAGE_MAP()
	afx_msg void OnTimer(UINT nIDEvent); // NEO: FCFG - [FileConfiguration]
	afx_msg void OnDestroy();
	afx_msg LRESULT OnDataChanged(WPARAM, LPARAM); // NEO: FCFG - [FileConfiguration]

	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT DrawTreeItemHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

private:
	bool	ForFile() {return m_bFilePreferences;}
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	BOOL	CheckNCDBEnable();
#endif // NEO_CD // NEO: NCD END
};
