//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "Neo\GUI\CP\TreeOptionsCtrl.h" // NEO - [TreeControl] <-- Xanatos --

class CPPgRelease : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgRelease)

public:
	CPPgRelease();
	virtual ~CPPgRelease();

	void SetFiles(const CSimpleArray<CObject*>* paFiles) { m_paFiles = paFiles; m_bDataChanged = true; m_bFilePreferences = true; } // NEO: FCFG - [FileConfiguration]

	// Dialog Data
	enum { IDD = IDD_PPG_MOD };

protected:
	// NEO: FCFG - [FileConfiguration]
	//CString m_strCaption;
	const CSimpleArray<CObject*>* m_paFiles;
	bool m_bDataChanged;
	uint32 m_timer;
	static LPCTSTR sm_pszNotAvail;

	bool m_bFilePreferences; // We use the same dialog ro the Prefs and the File Prefs
	// NEO: FCFG END

	CTreeOptionsCtrl m_ctrlTreeOptions; // NEO - [TreeControl]
	bool m_bInitializedTreeOpts;

	HTREEITEM m_htiReleaseTweaks;
		HTREEITEM m_htiPartTraffic; // NEO: NPT - [NeoPartTraffic]

		// NEO: TQ - [TweakUploadQueue]
		HTREEITEM m_htiTweakUploadQueue;
			HTREEITEM m_htiSaveUploadQueueWaitTime; // NEO: SQ - [SaveUploadQueue]
			HTREEITEM m_htiUseMultiQueue; // NEO: MQ - [MultiQueue]
			HTREEITEM m_htiNeoScoreSystem; // NEO: NFS - [NeoScoreSystem]
			// NEO: OCS - [OtherCreditSystems]
			HTREEITEM m_htiCreditSystem;
				HTREEITEM m_htiOfficialCreditSystem;
				HTREEITEM m_htiNeoCreditSystem; // NEO: NCS - [NeoCreditSystem]
				HTREEITEM m_htiOtherCreditSystem; 
			// NEO: OCS END
			HTREEITEM m_htiUseRandomQueue; // NEO: RQ - [RandomQueue]
			HTREEITEM m_htiInfiniteQueue;
			HTREEITEM m_htiUploadQueueOverFlow;
				HTREEITEM m_htiQueueOverFlowRelease;
				HTREEITEM m_htiQueueOverFlowEx;
				HTREEITEM m_htiQueueOverFlowDef;
				HTREEITEM m_htiQueueOverFlowCF;
			HTREEITEM m_htiOldPrioritySystem;
			// NEO: NMFS - [NiceMultiFriendSlots]
			HTREEITEM m_htiFriendUpload;
				HTREEITEM m_htiFriendSlotLimit;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
				HTREEITEM m_htiSeparateFriendBandwidth;
					HTREEITEM m_htiFriendSlotSpeed;
					HTREEITEM m_htiFriendBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END
			// NEO: NMFS END
		// NEO: TQ END

		// NEO: PRSF - [PushSmallRareFiles]
		HTREEITEM m_htiFilePushTweaks;
			HTREEITEM m_htiPushSmallFiles;
			HTREEITEM m_htiPushRareFiles;
			HTREEITEM m_htiPushRatioFiles;
		// NEO: PRSF END

		// NEO: NCAP - [NeoCustomAutoPriority]
		HTREEITEM m_htiAutoUpPriority;
			HTREEITEM m_htiDynamicAutoUpPriorityDefault;
			HTREEITEM m_htiDynamicAutoUpPriorityEnable;
			HTREEITEM m_htiDynamicAutoUpPriorityDisable;
			HTREEITEM m_htiLowUpPrioThreshold;
			HTREEITEM m_htiHighUpPrioThreshold;
		// NEO: NCAP END

		// NEO: RT - [ReleaseTweaks]
		HTREEITEM m_htiReleasePriority;
			HTREEITEM m_htiReleasePriorityLevel;
			HTREEITEM m_htiReleaseUpload;
				HTREEITEM m_htiReleaseSlotLimit;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
				HTREEITEM m_htiSeparateReleaseBandwidth;
					HTREEITEM m_htiReleaseSlotSpeed;
					HTREEITEM m_htiReleaseBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END
			HTREEITEM m_htiReleasePriorityMode;
				HTREEITEM m_htiReleasePriorityModeDefault;
				HTREEITEM m_htiReleasePriorityModeMixed;
				HTREEITEM m_htiReleasePriorityModeBoost;
				HTREEITEM m_htiReleasePriorityModePower;


			HTREEITEM m_htiReleaseLimitRoot;
				HTREEITEM m_htiReleaseLimit;
					HTREEITEM m_htiReleaseLimitDefault;
					HTREEITEM m_htiReleaseLimitEnable1;
					HTREEITEM m_htiReleaseLimitEnable2;
					HTREEITEM m_htiReleaseLimitDisable;
					HTREEITEM m_htiReleaseLimitHigh;
					HTREEITEM m_htiReleaseLimitLow;
					HTREEITEM m_htiReleaseLimitMode;
						HTREEITEM m_htiReleaseLimitModeDefault;
						HTREEITEM m_htiReleaseLimitModeSimply;
						HTREEITEM m_htiReleaseLimitModeExponential;
						HTREEITEM m_htiReleaseLimitModeLinear;
				HTREEITEM m_htiReleaseLimitUnion;
					HTREEITEM m_htiReleaseLimitUnionDefault;
					HTREEITEM m_htiReleaseLimitUnionEnable;
					HTREEITEM m_htiReleaseLimitUnionDisable;
				HTREEITEM m_htiReleaseLimitComplete;
					HTREEITEM m_htiReleaseLimitCompleteDefault;
					HTREEITEM m_htiReleaseLimitCompleteEnable1;
					HTREEITEM m_htiReleaseLimitCompleteEnable2;
					HTREEITEM m_htiReleaseLimitCompleteDisable;
					HTREEITEM m_htiReleaseLimitCompleteHigh;
					HTREEITEM m_htiReleaseLimitCompleteLow;
					HTREEITEM m_htiReleaseLimitCompleteMode;
						HTREEITEM m_htiReleaseLimitCompleteModeDefault;
						HTREEITEM m_htiReleaseLimitCompleteModeSimply;
						HTREEITEM m_htiReleaseLimitCompleteModeExponential;
						HTREEITEM m_htiReleaseLimitCompleteModeLinear;

			HTREEITEM m_htiLimitUnion;
				HTREEITEM m_htiLimitUnionDefault;
				HTREEITEM m_htiLimitUnionEnable;
				HTREEITEM m_htiLimitUnionDisable;

			HTREEITEM m_htiSourceLimitRoot;
				HTREEITEM m_htiSourceLimit;
					HTREEITEM m_htiSourceLimitDefault;
					HTREEITEM m_htiSourceLimitEnable1;
					HTREEITEM m_htiSourceLimitEnable2;
					HTREEITEM m_htiSourceLimitDisable;
					HTREEITEM m_htiSourceLimitHigh;
					HTREEITEM m_htiSourceLimitLow;
					HTREEITEM m_htiSourceLimitMode;
						HTREEITEM m_htiSourceLimitModeDefault;
						HTREEITEM m_htiSourceLimitModeSimply;
						HTREEITEM m_htiSourceLimitModeExponential;
						HTREEITEM m_htiSourceLimitModeLinear;
				HTREEITEM m_htiSourceLimitUnion;
					HTREEITEM m_htiSourceLimitUnionDefault;
					HTREEITEM m_htiSourceLimitUnionEnable;
					HTREEITEM m_htiSourceLimitUnionDisable;
				HTREEITEM m_htiSourceLimitComplete;
					HTREEITEM m_htiSourceLimitCompleteDefault;
					HTREEITEM m_htiSourceLimitCompleteEnable1;
					HTREEITEM m_htiSourceLimitCompleteEnable2;
					HTREEITEM m_htiSourceLimitCompleteDisable;
					HTREEITEM m_htiSourceLimitCompleteHigh;
					HTREEITEM m_htiSourceLimitCompleteLow;
					HTREEITEM m_htiSourceLimitCompleteMode;
						HTREEITEM m_htiSourceLimitCompleteModeDefault;
						HTREEITEM m_htiSourceLimitCompleteModeSimply;
						HTREEITEM m_htiSourceLimitCompleteModeExponential;
						HTREEITEM m_htiSourceLimitCompleteModeLinear;
				HTREEITEM m_htiReleasePriorityNeedComplete;
		// NEO: RT END

		// NEO: IPS - [InteligentPartSharing]
		HTREEITEM m_htiInteligentPartSharing;
			HTREEITEM m_htiInteligentPartSharingEnable;
			HTREEITEM m_htiInteligentPartSharingTimer;
			HTREEITEM m_htiMaxProzentToHide;
			HTREEITEM m_htiHideOverAvaliblyParts;
				HTREEITEM m_htiHideOverAvaliblyPartsDefault;
				HTREEITEM m_htiHideOverAvaliblyPartsEnable;
				HTREEITEM m_htiHideOverAvaliblyPartsEnableAll;
				HTREEITEM m_htiHideOverAvaliblyPartsDisable;
				HTREEITEM m_htiHideOverAvaliblyValue;
				HTREEITEM m_htiHideOverAvaliblyMode;
					HTREEITEM m_htiHideOverAvaliblyMode0;
					HTREEITEM m_htiHideOverAvaliblyMode1;
					HTREEITEM m_htiHideOverAvaliblyMode2;
				HTREEITEM m_htiBlockHighOverAvaliblyParts;
					HTREEITEM m_htiBlockHighOverAvaliblyPartsDefault;
					HTREEITEM m_htiBlockHighOverAvaliblyPartsEnable;
					HTREEITEM m_htiBlockHighOverAvaliblyPartsEnableAll;
					HTREEITEM m_htiBlockHighOverAvaliblyPartsDisable;
					HTREEITEM m_htiBlockHighOverAvaliblyFactor;
				// NEO: NPC - [NeoPartCatch]
				HTREEITEM m_htiHideOverAvaliblyCatch;
					HTREEITEM m_htiHideOverAvaliblyCatchDefault;
					HTREEITEM m_htiHideOverAvaliblyCatchReal;
					HTREEITEM m_htiHideOverAvaliblyCatchRealHiden;
					HTREEITEM m_htiHideOverAvaliblyCatchHiden;
					HTREEITEM m_htiHideOverAvaliblyCatchDisable;
				// NEO: NPC END
			HTREEITEM m_htiHideOverSharedParts;
				HTREEITEM m_htiHideOverSharedPartsDefault;
				HTREEITEM m_htiHideOverSharedPartsEnable;
				HTREEITEM m_htiHideOverSharedPartsEnableAll;
				HTREEITEM m_htiHideOverSharedPartsDisable;
				HTREEITEM m_htiHideOverSharedValue;
				HTREEITEM m_htiHideOverSharedMode;
					HTREEITEM m_htiHideOverSharedMode0;
					HTREEITEM m_htiHideOverSharedMode1;
					HTREEITEM m_htiHideOverSharedMode2;
				HTREEITEM m_htiDontHideUnderAvaliblyParts;
					HTREEITEM m_htiDontHideUnderAvaliblyPartsDefault;
					HTREEITEM m_htiDontHideUnderAvaliblyPartsEnable;
					HTREEITEM m_htiDontHideUnderAvaliblyPartsEnableAll;
					HTREEITEM m_htiDontHideUnderAvaliblyPartsDisable;
					HTREEITEM m_htiDontHideUnderAvaliblyValue;
					HTREEITEM m_htiDontHideUnderAvaliblyMode;
						HTREEITEM m_htiDontHideUnderAvaliblyMode0;
						HTREEITEM m_htiDontHideUnderAvaliblyMode1;
						HTREEITEM m_htiDontHideUnderAvaliblyMode2;
				HTREEITEM m_htiBlockHighOverSharedParts;
					HTREEITEM m_htiBlockHighOverSharedPartsDefault;
					HTREEITEM m_htiBlockHighOverSharedPartsEnable;
					HTREEITEM m_htiBlockHighOverSharedPartsEnableAll;
					HTREEITEM m_htiBlockHighOverSharedPartsDisable;
					HTREEITEM m_htiBlockHighOverSharedFactor;
				HTREEITEM m_htiHideOverSharedCalc;
					HTREEITEM m_htiHideOverSharedCalcDefault;
					HTREEITEM m_htiHideOverSharedCalcHigh;
					HTREEITEM m_htiHideOverSharedCalcLow;
			HTREEITEM m_htiShowAlwaysNeeded;
				HTREEITEM m_htiShowAlwaysNeededDefault;
				HTREEITEM m_htiShowAlwaysNeededEnable;
				HTREEITEM m_htiShowAlwaysNeededEnableAll;
				HTREEITEM m_htiShowAlwaysNeededDisable;
				HTREEITEM m_htiShowAlwaysNeededValue;
				HTREEITEM m_htiShowAlwaysIncomplete;
					HTREEITEM m_htiShowAlwaysIncompleteDefault;
					HTREEITEM m_htiShowAlwaysIncompleteEnable;
					HTREEITEM m_htiShowAlwaysIncompleteEnableAll;
					HTREEITEM m_htiShowAlwaysIncompleteDisable;
	// NEO: IPS END
	// NEO: RP - [RestrictivPublishing]
		HTREEITEM m_htiPublishing;
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
			HTREEITEM m_htiDisableSendLAN;
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
			HTREEITEM m_htiDisableVoodoo;
#endif // VOODOO
	// NEO: RP END
		HTREEITEM m_htiXSAnswerLimit; // NEO: NST - [NeoSourceTweaks]

	UINT	m_uPartTraffic; // NEO: NPT - [NeoPartTraffic]
	int		m_iPartTrafficColor; // NEO: NPT - [NeoPartTraffic]

	bool	m_bSaveUploadQueueWaitTime; // NEO: SQ - [SaveUploadQueue]

	// NEO: TQ - [TweakUploadQueue]
	bool	m_bInfiniteQueue;

	UINT	m_uQueueOverFlowRelease;
	int		m_iQueueOverFlowRelease;

	UINT	m_uQueueOverFlowEx;
	int		m_iQueueOverFlowEx;

	UINT	m_uQueueOverFlowDef;
	int		m_iQueueOverFlowDef;

	UINT	m_uQueueOverFlowCF;
	int		m_iQueueOverFlowCF;
	// NEO: TQ END

	// NEO: PRSF - [PushSmallRareFiles]
	bool	m_bPushSmallFiles;
	int		m_iPushSmallFilesSize;

	bool	m_bPushRareFiles;
	int		m_iPushRareFilesValue;

	bool	m_bPushRatioFiles;
	int		m_iPushRatioFilesValue;
	// NEO: PRSF END

	// NEO: NCAP - [NeoCustomAutoPriority]
	int		m_iDynamicAutoUpPriority;
	bool	m_bDynamicAutoUpPriority;
	float	m_fDynamicUpPriorityFactor;
	int		m_iLowUpPrioThreshold;
	int		m_iHighUpPrioThreshold;
	// NEO: NCAP END

	bool	m_bUseMultiQueue; // NEO: MQ - [MultiQueue]
	bool	m_bUseRandomQueue; // NEO: RQ - [RandomQueue]

	bool	m_bNeoScoreSystem; // NEO: NFS - [NeoScoreSystem]
	//bool	m_bNeoCreditSystem; // NEO: NCS - [NeoCreditSystem]
	// NEO: OCS - [OtherCreditSystems]
	int		m_iCreditSystem;
	int		m_iOtherCreditSystem;
	// NEO: OCS END

	bool	m_bOldPrioritySystem;

	// NEO: NMFS - [NiceMultiFriendSlots]
	bool	m_bFriendSlotLimit;
	int		m_iFriendSlotLimit;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	bool	m_bSeparateFriendBandwidth;
	float	m_fFriendSlotSpeed;
	float	m_fFriendBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END
	// NEO: NMFS END

	// NEO: RT - [ReleaseTweaks]
	int		m_iReleaseLevel; 
	int		m_iReleaseMode; 

	int		m_iReleaseLimitMode; 
	bool	m_bReleaseLimitUnion;
	int		m_iReleaseLimitUnion;
	int		m_iReleaseLimitCompleteMode; 

	UINT	m_uReleaseLimit; 
	int		m_iReleaseLimit;
	int		m_iReleaseLimitHigh; 
	int		m_iReleaseLimitLow; 

	UINT	m_uReleaseLimitComplete; 
	int		m_iReleaseLimitComplete; 
	int		m_iReleaseLimitCompleteHigh; 
	int		m_iReleaseLimitCompleteLow; 

	bool	m_bLimitUnion;
	int		m_iLimitUnion;

	int		m_iSourceLimitMode; 
	bool	m_bSourceLimitUnion;
	int		m_iSourceLimitUnion;
	int		m_iSourceLimitCompleteMode; 

	UINT	m_uSourceLimit; 
	int		m_iSourceLimit;
	int		m_iSourceLimitHigh; 
	int		m_iSourceLimitLow; 

	UINT	m_uSourceLimitComplete; 
	int		m_iSourceLimitComplete; 
	int		m_iSourceLimitCompleteHigh; 
	int		m_iSourceLimitCompleteLow; 

	bool	m_bReleaseNeedComplete; 
	UINT	m_iReleaseNeedComplete; 
	int		m_iReleaseNeedCompleteLimit; 

	UINT	m_uReleaseSlotLimit;
	int		m_iReleaseSlotLimit;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	UINT	m_uSeparateReleaseBandwidth;
	float	m_fReleaseSlotSpeed;
	float	m_fReleaseBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END
	// NEO: RT END

	// NEO: IPS - [InteligentPartSharing]
	bool	m_bInteligentPartSharing;
	int		m_iInteligentPartSharingTimer;
	int		m_iMaxProzentToHide;

	int		m_iHideOverAvaliblyParts;
	int		m_iHideOverAvaliblyMode;
	float	m_fHideOverAvaliblyValue;
	int		m_iHideOverAvaliblyCatch;

	int		m_iHideOverSharedParts;
	int		m_iHideOverSharedMode;
	float	m_fHideOverSharedValue;
	int		m_iHideOverSharedCalc;
	
	int		m_iDontHideUnderAvaliblyParts;
	int		m_iDontHideUnderAvaliblyMode;
	float	m_fDontHideUnderAvaliblyValue;

	int		m_iBlockHighOverAvaliblyParts;
	float	m_fBlockHighOverAvaliblyFactor;

	int		m_iBlockHighOverSharedParts;
	float	m_fBlockHighOverSharedFactor;

	int		m_iShowAlwaysNeeded;
	int		m_iShowAlwaysParts;

	int		m_iShowAlwaysIncomplete;
	// NEO: IPS END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	UINT	m_bDisableSendLAN;
#endif //LANCAST // NEO: NLC END
	// NEO: RP END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	UINT	m_bDisableVoodoo;
#endif // VOODOO
	// NEO: RP - [RestrictivPublishing]
	// NEO: NST - [NeoSourceTweaks]
	int		m_iXSAnswerLimit;
	UINT	m_bEnableSendXS;
	// NEO: NST END

	void ClearAllMembers();

	//void Localize();
	void LoadSettings();
	void RefreshData(); // NEO: FCFG - [FileConfiguration]

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnSetActive(); // NEO: FCFG - [FileConfiguration]

	DECLARE_MESSAGE_MAP()
	afx_msg void OnTimer(UINT nIDEvent); // NEO: FCFG - [FileConfiguration]
	afx_msg void OnDestroy();
	afx_msg LRESULT OnDataChanged(WPARAM, LPARAM); // NEO: FCFG - [FileConfiguration]

	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT DrawTreeItemHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

private:
	bool	ForFile() {return m_bFilePreferences;}
	bool	CheckIPSEnable(); // NEO: IPS - [InteligentPartSharing]
};
