//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "Neo\GUI\CP\TreeOptionsCtrl.h" // NEO - [TreeControl] <-- Xanatos --

class CPPgNeo : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgNeo)

public:
	CPPgNeo();
	virtual ~CPPgNeo();

// Dialog Data
	enum { IDD = IDD_PPG_MOD };

protected:
	CTreeOptionsCtrl m_ctrlTreeOptions; // NEO - [TreeControl] <-- Xanatos --
	bool m_bInitializedTreeOpts;
	HTREEITEM m_htiMain;
		HTREEITEM m_htiUseSaveComments; // NEO: XC - [ExtendedComments]
		HTREEITEM m_htiUseKnownComments; // NEO: XCk - [ExtendedKnownComments]
		HTREEITEM m_htiInteligentChunkSelecting; // NEO: ICS - [InteligentChunkSelection]
		HTREEITEM m_htiSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]
			HTREEITEM m_htiSubChunkVerification; // NEO: SCV - [SubChunkVerification]
		HTREEITEM m_htiRealPartStatus; // NEO: RPS - [RealPartStatus]
		HTREEITEM m_htiAntiHideOS; // NEO: AHOS - [AntiHideOS]
		HTREEITEM m_htiEstimatedDownloadTime; // NEO: EDT - [EstimatedDownloadTime] 
		HTREEITEM m_htiLowID2HighIDAutoCallback; // NEO: L2H - [LowID2HighIDAutoCallback]
		HTREEITEM m_htiShareAlsoEmptyFiles; // NEO: SEF - [ShareAlsoEmptyFiles]
		HTREEITEM m_htiOnlyCompleteFiles; // NEO: OCF - [OnlyCompleetFiles]
		HTREEITEM m_htiUseLugdunumCredits; // NEO: KLC - [KhaosLugdunumCredits]
		HTREEITEM m_htiPreferShareAll; // NEO: PSA - [PreferShareAll]
		// NEO: ASF - [AdvancedServerFilter]
		HTREEITEM m_htiAdvancedServerFilter;
			HTREEITEM m_htiDontRemoveStaticServers;
			HTREEITEM m_htiServerFilterAutoDel;
			HTREEITEM m_htiServerFilter;
			HTREEITEM m_htiServerFilterVal;
			HTREEITEM m_htiServerFilterDataless;
		// NEO: ASF END
		HTREEITEM m_htiUseCustomPermissions; // NEO: SSP - [ShowSharePermissions]
		HTREEITEM m_htiCommunity; // NEO: NC - [NiceCommunity]
		// NEO: NXI - [NeoExtraInfo]
		HTREEITEM m_htiSendExtraInfo;
			HTREEITEM m_htiSendExtraInfoEnable;
			HTREEITEM m_htiSendExtraInfoBandwidth;
			HTREEITEM m_htiSendExtraInfoUpTime;
			HTREEITEM m_htiSendExtraInfoDlFile;
			HTREEITEM m_htiSendExtraInfoUlFile;
			HTREEITEM m_htiSendExtraInfoWaitingUsers;
			HTREEITEM m_htiSendExtraInfoString;
		// NEO: NXI END
		HTREEITEM m_htiAppPriority;
		HTREEITEM m_htiHashingDelay; // NEO: MOD - [NiceHash]
		HTREEITEM m_htiProcessingDelay; // NEO: MOD - [RelaxCPU]
		HTREEITEM m_htiRefreshShared; // NEO: MOD - [RefreshShared]
		HTREEITEM m_htiPauseOnFileComplete; // NEO: POFC - [PauseOnFileComplete]

	bool	m_bUseSaveComments; // NEO: XC - [ExtendedComments]
	bool	m_bUseKnownComments; // NEO: XCk - [ExtendedKnownComments]
	UINT	m_uInteligentChunkSelecting; // NEO: ICS - [InteligentChunkSelection]
	UINT	m_uSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]
	UINT	m_uSubChunkVerification; // NEO: SCV - [SubChunkVerification]
	UINT	m_uRealPartStatus; // NEO: RPS - [RealPartStatus]
	UINT	m_uAntiHideOS; // NEO: AHOS - [AntiHideOS]
	bool	m_bEstimatedDownloadTime; // NEO: EDT - [EstimatedDownloadTime] 
	UINT	m_uLowID2HighIDAutoCallback; // NEO: L2H - [LowID2HighIDAutoCallback]
	UINT	m_uShareAlsoEmptyFiles; // NEO: SEF - [ShareAlsoEmptyFiles]
	bool	m_bOnlyCompleteFiles; // NEO: OCF - [OnlyCompleetFiles]
	int		m_iToOldComplete;
	UINT	m_uUseLugdunumCredits; // NEO: KLC - [KhaosLugdunumCredits]
	bool	m_bPreferShareAll; // NEO: PSA - [PreferShareAll]
	// NEO: ASF - [AdvancedServerFilter]
	bool	m_bDontRemoveStaticServers;
	bool	m_bServerFilterAutoDel;
	int		m_iServerFilter;
	CString m_sServerFilterVal;
	bool	m_bServerFilterDataless;
	// NEO: ASF END
	bool	m_bUseCustomPermissions; // NEO: SSP - [ShowSharePermissions]
	CString	m_sCommunity; // NEO: NC - [NiceCommunity]
	// NEO: NXI - [NeoExtraInfo]
	bool	m_bSendExtraInfo;
	bool	m_bSendExtraInfoBandwidth;
	UINT	m_uSendExtraInfoUpTime;
	bool	m_bSendExtraInfoDlFile;
	UINT	m_uSendExtraInfoUlFile;
	bool	m_bSendExtraInfoWaitingUsers;
	CString	m_sSendExtraInfoString;
	// NEO: NXI END
	DWORD	m_dAppPriority;
	// NEO: MOD - [NiceHash]
	bool	m_bUseHashingDelay;
	int		m_iHashingDelay;
	// NEO: MOD END
	// NEO: MOD - [RelaxCPU]
	bool	m_bUseProcessingDelay;
	int		m_iProcessingDelay;
	// NEO: MOD END
	// NEO: MOD - [RefreshShared]
	bool	m_bRefreshShared;
	int		m_iRefreshSharedIntervals;
	// NEO: MOD END
	bool	m_bPauseOnFileComplete; // NEO: POFC - [PauseOnFileComplete]


	void ClearAllMembers();

	//void Localize();
	void LoadSettings();

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT DrawTreeItemHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

private:
	void CheckNXI(); // NEO: NXI - [NeoExtraInfo]
};
