//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgNeo.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "Neo/Functions.h"
#include "Neo/GUI/CP/TreeFunctions.h"
#include "Neo/Defaults.h"
#include "KnownFileList.h"
#include "Opcodes.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// NEO: ASF - [AdvancedServerFilter]
class CServerFilterOperator : public CTreeOptionsCombo
{
public:
	CServerFilterOperator();
	virtual ~CServerFilterOperator();

protected:
	//{{AFX_VIRTUAL(CServerFilterOperator)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CServerFilterOperator)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CServerFilterOperator)
};


IMPLEMENT_DYNCREATE(CServerFilterOperator, CTreeOptionsCombo)

CServerFilterOperator::CServerFilterOperator()
{
}

CServerFilterOperator::~CServerFilterOperator()
{
}

BEGIN_MESSAGE_MAP(CServerFilterOperator, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CServerFilterOperator)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CServerFilterOperator::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
	AddString(GetResString(IDS_PING));
	AddString(GetResString(IDS_UUSERS));
	AddString(GetResString(IDS_MAXCLIENT));
	AddString(GetResString(IDS_FILES));
	AddString(GetResString(IDS_HARDFILES));
	AddString(GetResString(IDS_SOFTFILES));
	AddString(GetResString(IDS_FAILED));
	AddString(GetResString(IDS_SL_SERVERNAME));
	AddString(GetResString(IDS_DESCRIPTION));

	return 0;
}
// NEO: ASF END

///////////////////////////////////////////////////////////////////////////////
// CPPgNeo dialog

IMPLEMENT_DYNAMIC(CPPgNeo, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgNeo, CPropertyPage)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgNeo::CPPgNeo()
	: CPropertyPage(CPPgNeo::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgNeo::~CPPgNeo()
{
}

void CPPgNeo::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;
	
	m_htiMain = NULL;
		m_htiUseSaveComments = NULL; // NEO: XC - [ExtendedComments]
		m_htiUseKnownComments = NULL; // NEO: XCk - [ExtendedKnownComments]
		m_htiInteligentChunkSelecting = NULL; // NEO: ICS - [InteligentChunkSelection]
		m_htiSubChunkTransfer = NULL; // NEO: SCT - [SubChunkTransfer]
			m_htiSubChunkVerification = NULL; // NEO: SCV - [SubChunkVerification]
		m_htiRealPartStatus = NULL; // NEO: RPS - [RealPartStatus]
		m_htiAntiHideOS = NULL; // NEO: AHOS - [AntiHideOS]
		m_htiEstimatedDownloadTime = NULL; // NEO: EDT - [EstimatedDownloadTime] 
		m_htiLowID2HighIDAutoCallback = NULL; // NEO: L2H - [LowID2HighIDAutoCallback]
		m_htiShareAlsoEmptyFiles = NULL; // NEO: SEF - [ShareAlsoEmptyFiles]
		m_htiOnlyCompleteFiles = NULL; // NEO: OCF - [OnlyCompleetFiles]
		m_htiUseLugdunumCredits = NULL; // NEO: KLC - [KhaosLugdunumCredits]
		m_htiPreferShareAll = NULL; // NEO: PSA - [PreferShareAll]
		// NEO: ASF - [AdvancedServerFilter]
		m_htiAdvancedServerFilter = NULL;
			m_htiDontRemoveStaticServers = NULL;
			m_htiServerFilterAutoDel = NULL;
			m_htiServerFilter = NULL;
			m_htiServerFilterVal = NULL;
			m_htiServerFilterDataless = NULL;
		// NEO: ASF END
		m_htiUseCustomPermissions = NULL; // NEO: SSP - [ShowSharePermissions]
		m_htiCommunity = NULL; // NEO: NC - [NiceCommunity]
		// NEO: NXI - [NeoExtraInfo]
		m_htiSendExtraInfo = NULL;
			m_htiSendExtraInfoEnable = NULL;
			m_htiSendExtraInfoBandwidth = NULL;
			m_htiSendExtraInfoUpTime = NULL;
			m_htiSendExtraInfoDlFile = NULL;
			m_htiSendExtraInfoUlFile = NULL;
			m_htiSendExtraInfoWaitingUsers = NULL;
			m_htiSendExtraInfoString = NULL;
		// NEO: NXI END
		m_htiAppPriority = NULL;
		m_htiHashingDelay = NULL; // NEO: MOD - [NiceHash]
		m_htiProcessingDelay = NULL; // NEO: MOD - [RelaxCPU]
		m_htiRefreshShared = NULL; // NEO: MOD - [RefreshShared]
		m_htiPauseOnFileComplete = NULL; // NEO: POFC - [PauseOnFileComplete]
}

void CPPgNeo::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
		int iImgMain = 8;
		int iImgServer = 8; // NEO: ASF - [AdvancedServerFilter]
		int iImgNXI = 8; 
        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgMain = piml->Add(CTempIconLoader(_T("MAINTWEAKS")));
			iImgServer = piml->Add(CTempIconLoader(_T("Server"))); // NEO: ASF - [AdvancedServerFilter]
			iImgNXI = piml->Add(CTempIconLoader(_T("CLIENTEXTRAINFO")));
		}
		
		SetTreeGroup(m_ctrlTreeOptions,m_htiMain,GetResString(IDS_X_MAIN_TWEAKS),iImgMain, TVI_ROOT, GetResString(IDS_X_MAIN_TWEAKS_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseSaveComments,GetResString(IDS_X_SAVE_COMMENTS),m_htiMain,GetResString(IDS_X_SAVE_COMMENTS_INFO),FALSE,m_bUseSaveComments); // NEO: XC - [ExtendedComments]
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseKnownComments,GetResString(IDS_X_KNOWN_COMMENTS),m_htiMain,GetResString(IDS_X_KNOWN_COMMENTS_INFO),FALSE,m_bUseKnownComments); // NEO: XCk - [ExtendedKnownComments]
			SetTreeCheck(m_ctrlTreeOptions,m_htiInteligentChunkSelecting,GetResString(IDS_X_ICS),m_htiMain,GetResString(IDS_X_ICS_INFO),TRUE,m_uInteligentChunkSelecting); // NEO: ICS - [InteligentChunkSelection]
			SetTreeCheck(m_ctrlTreeOptions,m_htiSubChunkTransfer,GetResString(IDS_X_SCT),m_htiMain,GetResString(IDS_X_SCT_INFO),TRUE,m_uSubChunkTransfer); // NEO: SCT - [SubChunkTransfer]
				SetTreeCheck(m_ctrlTreeOptions,m_htiSubChunkVerification,GetResString(IDS_X_SCV),m_htiSubChunkTransfer,GetResString(IDS_X_SCV_INFO),TRUE,m_uSubChunkVerification); // NEO: SCV - [SubChunkVerification]
			SetTreeCheck(m_ctrlTreeOptions,m_htiRealPartStatus,GetResString(IDS_X_RPS),m_htiMain,GetResString(IDS_X_RPS_INFO),TRUE,m_uRealPartStatus); // NEO: RPS - [RealPartStatus]
			SetTreeCheck(m_ctrlTreeOptions,m_htiAntiHideOS,GetResString(IDS_X_ANTI_HIDE_OS),m_htiMain,GetResString(IDS_X_ANTI_HIDE_OS_INFO),TRUE,m_uAntiHideOS); // NEO: AHOS - [AntiHideOS]
			SetTreeCheck(m_ctrlTreeOptions,m_htiEstimatedDownloadTime,GetResString(IDS_X_ESTIMATED_DL_TIME),m_htiMain,GetResString(IDS_X_ESTIMATED_DL_TIME_INFO),TRUE,m_bEstimatedDownloadTime); // NEO: EDT - [EstimatedDownloadTime]
			SetTreeCheck(m_ctrlTreeOptions,m_htiLowID2HighIDAutoCallback,GetResString(IDS_X_L2HAC),m_htiMain,GetResString(IDS_X_L2HAC_INFO),TRUE,m_uLowID2HighIDAutoCallback); // NEO: L2H - [LowID2HighIDAutoCallback]
			SetTreeCheck(m_ctrlTreeOptions,m_htiShareAlsoEmptyFiles,GetResString(IDS_X_SHAREALSOEMPTYFILES),m_htiMain,GetResString(IDS_X_SHAREALSOEMPTYFILES_INFO),FALSE,m_uShareAlsoEmptyFiles); // NEO: SEF - [ShareAlsoEmptyFiles]
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiOnlyCompleteFiles,GetResString(IDS_X_ONLY_COMPLETE), m_htiMain,GetResString(IDS_X_ONLY_COMPLETE_INFO),FALSE, m_bOnlyCompleteFiles); // NEO: OCF - [OnlyCompleetFiles]
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseLugdunumCredits,GetResString(IDS_X_USE_LUGDUNUM_CREDITS),m_htiMain,GetResString(IDS_X_USE_LUGDUNUM_CREDITS_INFO),TRUE,m_uUseLugdunumCredits); // NEO: KLC - [KhaosLugdunumCredits]
			SetTreeCheck(m_ctrlTreeOptions,m_htiPreferShareAll,GetResString(IDS_X_PREFERSHAREALL),m_htiMain,GetResString(IDS_X_PREFERSHAREALL_INFO),FALSE,m_bPreferShareAll); // NEO: PSA - [PreferShareAll]
			// NEO: ASF - [AdvancedServerFilter]
			SetTreeGroup(m_ctrlTreeOptions,m_htiAdvancedServerFilter,GetResString(IDS_X_ADVANCED_SERVER_FILTER_MAIN),iImgServer, m_htiMain, GetResString(IDS_X_ADVANCED_SERVER_FILTER_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiDontRemoveStaticServers,GetResString(IDS_X_DONT_REMOVE_STATIC_SERVERS),m_htiAdvancedServerFilter,GetResString(IDS_X_DONT_REMOVE_STATIC_SERVERS_INFO),FALSE,m_bDontRemoveStaticServers);
				SetTreeCheck(m_ctrlTreeOptions,m_htiServerFilterAutoDel,GetResString(IDS_X_SERVER_FILTER_AUTO_DEL),m_htiAdvancedServerFilter,GetResString(IDS_X_SERVER_FILTER_AUTO_DEL_INFO),FALSE,m_bServerFilterAutoDel);
				m_htiServerFilter = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_SERVER_FILTER), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAdvancedServerFilter);
				m_ctrlTreeOptions.AddComboBox(m_htiServerFilter,RUNTIME_CLASS(CServerFilterOperator));
				//m_ctrlTreeOptions.SetItemSize(m_htiServerFilter,15);
				m_ctrlTreeOptions.SetItemInfo(m_htiServerFilter,GetResString(IDS_X_SERVER_FILTER_INFO));
				SetTreeEdit(m_ctrlTreeOptions,m_htiServerFilterVal,GetResString(IDS_X_SERVER_FILTER_VAL), m_htiAdvancedServerFilter,GetResString(IDS_X_SERVER_FILTER_VAL_INFO)); 
				//m_ctrlTreeOptions.SetItemSize(m_htiServerFilterVal,15);
				SetTreeCheck(m_ctrlTreeOptions,m_htiServerFilterDataless,GetResString(IDS_X_SERVER_FILTER_DATALESS),m_htiAdvancedServerFilter,GetResString(IDS_X_SERVER_FILTER_DATALESS_INFO),FALSE,m_bServerFilterDataless);
			// NEO: ASF END
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseCustomPermissions,GetResString(IDS_X_SHOW_SHARE),m_htiMain,GetResString(IDS_X_SHOW_SHARE_INFO),FALSE,m_bUseCustomPermissions); // NEO: SSP - [ShowSharePermissions]
			SetTreeEdit(m_ctrlTreeOptions,m_htiCommunity,GetResString(IDS_X_COMMUNITY), m_htiMain,GetResString(IDS_X_COMMUNITY_INFO)); // NEO: NC - [NiceCommunity]
			// NEO: NXI - [NeoExtraInfo]
			SetTreeGroup(m_ctrlTreeOptions,m_htiSendExtraInfo,GetResString(IDS_X_NXI_MAIN),iImgNXI, m_htiMain, GetResString(IDS_X_NXI_MAIN_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiSendExtraInfoEnable,GetResString(IDS_X_NXI_ENABLE),m_htiSendExtraInfo,GetResString(IDS_X_NXI_ENABLE_INFO),FALSE,m_bSendExtraInfo); 
				SetTreeCheck(m_ctrlTreeOptions,m_htiSendExtraInfoBandwidth,GetResString(IDS_X_NXI_BW),m_htiSendExtraInfo,GetResString(IDS_X_NXI_BW_INFO),FALSE,m_bSendExtraInfoBandwidth); 
				SetTreeCheck(m_ctrlTreeOptions,m_htiSendExtraInfoUpTime,GetResString(IDS_X_NXI_UP_TIME),m_htiSendExtraInfo,GetResString(IDS_X_NXI_UP_TIME_INFO),TRUE,m_uSendExtraInfoUpTime); 
				SetTreeCheck(m_ctrlTreeOptions,m_htiSendExtraInfoDlFile,GetResString(IDS_X_NXI_DL_FILE),m_htiSendExtraInfo,GetResString(IDS_X_NXI_DL_FILE_INFO),FALSE,m_bSendExtraInfoDlFile); 
				SetTreeCheck(m_ctrlTreeOptions,m_htiSendExtraInfoUlFile,GetResString(IDS_X_NXI_UL_FILE),m_htiSendExtraInfo,GetResString(IDS_X_NXI_UL_FILE_INFO),TRUE,m_uSendExtraInfoUlFile); 
				SetTreeCheck(m_ctrlTreeOptions,m_htiSendExtraInfoWaitingUsers,GetResString(IDS_X_NXI_WQ),m_htiSendExtraInfo,GetResString(IDS_X_NXI_WQ_INFO),FALSE,m_bSendExtraInfoWaitingUsers); 
				SetTreeEdit(m_ctrlTreeOptions,m_htiSendExtraInfoString,GetResString(IDS_X_NXI_SI), m_htiSendExtraInfo,GetResString(IDS_X_NXI_SI_INFO)); 
				m_ctrlTreeOptions.SetItemSize(m_htiSendExtraInfoString,25,3,MAX_CLIENT_MSG_LEN*3);
			// NEO: NXI END
			SetTreePriority(m_ctrlTreeOptions,m_htiAppPriority,GetResString(IDS_X_APP_PRIORITY), m_htiMain,GetResString(IDS_X_APP_PRIORITY_INFO));
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiHashingDelay,GetResString(IDS_X_HASHING_DELAY), m_htiMain,GetResString(IDS_X_HASHING_DELAY_INFO),FALSE, m_bUseHashingDelay); // NEO: MOD - [NiceHash]
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiProcessingDelay,GetResString(IDS_X_PROCESSING_DELAY), m_htiMain,GetResString(IDS_X_PROCESSING_DELAY_INFO),FALSE, m_bUseProcessingDelay); // NEO: MOD - [RelaxCPU]
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiRefreshShared,GetResString(IDS_X_SHARE_REFRESH), m_htiMain,GetResString(IDS_X_SHARE_REFRESH_INFO),FALSE, m_bRefreshShared); // NEO: MOD - [RefreshShared]
			SetTreeCheck(m_ctrlTreeOptions,m_htiPauseOnFileComplete,GetResString(IDS_X_PAUSE_ON_FILE_COMPLETE), m_htiMain,GetResString(IDS_X_PAUSE_ON_FILE_COMPLETE_INFO),FALSE, m_bPauseOnFileComplete); // NEO: POFC - [PauseOnFileComplete]

		CheckNXI(); // NEO: NXI - [NeoExtraInfo]

		UINT bCheck;
		// NEO: MOD - [NiceHash]
		m_ctrlTreeOptions.GetCheckBox(m_htiHashingDelay, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiHashingDelay, bCheck,FALSE,TRUE);
		// NEO: MOD END
		// NEO: MOD - [RelaxCPU]
		m_ctrlTreeOptions.GetCheckBox(m_htiProcessingDelay, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiProcessingDelay, bCheck,FALSE,TRUE);
		// NEO: MOD END
		// NEO: MOD - [RefreshShared]
		m_ctrlTreeOptions.GetCheckBox(m_htiRefreshShared, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiRefreshShared, bCheck,FALSE,TRUE);
		// NEO: MOD END

		m_ctrlTreeOptions.Expand(m_htiMain, TVE_EXPAND);
		m_bInitializedTreeOpts = true;
	}

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseSaveComments, m_bUseSaveComments); // NEO: XC - [ExtendedComments]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseKnownComments, m_bUseKnownComments); // NEO: XCk - [ExtendedKnownComments]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiInteligentChunkSelecting, m_uInteligentChunkSelecting); // NEO: ICS - [InteligentChunkSelection]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSubChunkTransfer, m_uSubChunkTransfer); // NEO: SCT - [SubChunkTransfer]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSubChunkVerification, m_uSubChunkVerification); // NEO: SCV - [SubChunkVerification]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiRealPartStatus, m_uRealPartStatus); // NEO: RPS - [RealPartStatus]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAntiHideOS, m_uAntiHideOS); // NEO: AHOS - [AntiHideOS]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiEstimatedDownloadTime, m_bEstimatedDownloadTime); // NEO: EDT - [EstimatedDownloadTime] 
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiLowID2HighIDAutoCallback, m_uLowID2HighIDAutoCallback); // NEO: L2H - [LowID2HighIDAutoCallback]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShareAlsoEmptyFiles, m_uShareAlsoEmptyFiles); // NEO: SEF - [ShareAlsoEmptyFiles]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiOnlyCompleteFiles, m_bOnlyCompleteFiles); // NEO: OCF - [OnlyCompleetFiles]
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiOnlyCompleteFiles, m_iToOldComplete); // NEO: OCF - [OnlyCompleetFiles]

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseLugdunumCredits, m_uUseLugdunumCredits); // NEO: KLC - [KhaosLugdunumCredits]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiPreferShareAll, m_bPreferShareAll); // NEO: PSA - [PreferShareAll]
		// NEO: ASF - [AdvancedServerFilter]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDontRemoveStaticServers, m_bDontRemoveStaticServers);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiServerFilterAutoDel, m_bServerFilterAutoDel);

		if (pDX->m_bSaveAndValidate)
		{
			CString sOperator;
			sOperator = m_ctrlTreeOptions.GetComboText(m_htiServerFilter);
			if(sOperator.Compare(GetResString(IDS_PING)) == 0)
				m_iServerFilter = 0;
			else if(sOperator.Compare(GetResString(IDS_UUSERS)) == 0)
				m_iServerFilter = 1;
			else if(sOperator.Compare(GetResString(IDS_MAXCLIENT)) == 0)
				m_iServerFilter = 2;
			else if(sOperator.Compare(GetResString(IDS_FILES)) == 0)
				m_iServerFilter = 3;
			else if(sOperator.Compare(GetResString(IDS_HARDFILES)) == 0)
				m_iServerFilter = 4;
			else if(sOperator.Compare(GetResString(IDS_SOFTFILES)) == 0)
				m_iServerFilter = 5;
			else if(sOperator.Compare(GetResString(IDS_FAILED)) == 0)
				m_iServerFilter = 6;
			else if(sOperator.Compare(GetResString(IDS_SL_SERVERNAME)) == 0)
				m_iServerFilter = 7;
			else if(sOperator.Compare(GetResString(IDS_DESCRIPTION)) == 0)
				m_iServerFilter = 8;
			else 
				ASSERT(0);
		}
		else
		{
			if(m_iServerFilter == 0)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_PING));
			else if(m_iServerFilter == 1)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_UUSERS));
			else if(m_iServerFilter == 2)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_MAXCLIENT));
			else if(m_iServerFilter == 3)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_FILES));
			else if(m_iServerFilter == 4)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_HARDFILES));
			else if(m_iServerFilter == 5)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_SOFTFILES));
			else if(m_iServerFilter == 6)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_FAILED));
			else if(m_iServerFilter == 7)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_SL_SERVERNAME));
			else if(m_iServerFilter == 8)
				m_ctrlTreeOptions.SetComboText(m_htiServerFilter,GetResString(IDS_DESCRIPTION));
			else
				ASSERT(0);
		}

		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiServerFilterVal, m_sServerFilterVal);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiServerFilterDataless, m_bServerFilterDataless);
		// NEO: ASF END

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseCustomPermissions, m_bUseCustomPermissions); // NEO: SSP - [ShowSharePermissions]
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiCommunity, m_sCommunity); // NEO: NC - [NiceCommunity]
	// NEO: NXI - [NeoExtraInfo]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSendExtraInfoEnable, m_bSendExtraInfo);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSendExtraInfoBandwidth, m_bSendExtraInfoBandwidth);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSendExtraInfoUpTime, m_uSendExtraInfoUpTime);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSendExtraInfoDlFile, m_bSendExtraInfoDlFile);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSendExtraInfoUlFile, m_uSendExtraInfoUlFile);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSendExtraInfoWaitingUsers, m_bSendExtraInfoWaitingUsers);
		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiSendExtraInfoString, m_sSendExtraInfoString);
	// NEO: NXI END
	DDX_PriorityC(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAppPriority, m_dAppPriority);

	// NEO: MOD - [NiceHash]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiHashingDelay, m_bUseHashingDelay);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiHashingDelay, m_iHashingDelay);
	// NEO: MOD END

	// NEO: MOD - [RelaxCPU]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiProcessingDelay, m_bUseProcessingDelay);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiProcessingDelay, m_iProcessingDelay);
	// NEO: MOD END

	// NEO: MOD - [RefreshShared]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiRefreshShared, m_bRefreshShared);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiRefreshShared, m_iRefreshSharedIntervals);
	// NEO: MOD END

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiPauseOnFileComplete, m_bPauseOnFileComplete); // NEO: POFC - [PauseOnFileComplete]
}

BOOL CPPgNeo::OnInitDialog()
{
	LoadSettings();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgNeo::LoadSettings()
{
	/*
	* Globale Einstellungen Laden
	*/

	m_bUseSaveComments = thePrefs.m_bUseSaveComments; // NEO: XC - [ExtendedComments]
	m_bUseKnownComments = thePrefs.m_bUseKnownComments; // NEO: XCk - [ExtendedKnownComments]
	m_uInteligentChunkSelecting = thePrefs.m_uInteligentChunkSelecting; // NEO: ICS - [InteligentChunkSelection]
	m_uSubChunkTransfer = thePrefs.m_uSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]
	m_uSubChunkVerification = thePrefs.m_uSubChunkVerification; // NEO: SCV - [SubChunkVerification]
	m_uRealPartStatus = thePrefs.m_uRealPartStatus; // NEO: RPS - [RealPartStatus]
	m_uAntiHideOS = thePrefs.m_uAntiHideOS; // NEO: AHOS - [AntiHideOS]
	m_bEstimatedDownloadTime = thePrefs.m_bEstimatedDownloadTime; // NEO: EDT - [EstimatedDownloadTime] 
	m_uLowID2HighIDAutoCallback = thePrefs.m_uLowID2HighIDAutoCallback; // NEO: L2H - [LowID2HighIDAutoCallback]
	m_uShareAlsoEmptyFiles = thePrefs.m_uShareAlsoEmptyFiles; // NEO: SEF - [ShareAlsoEmptyFiles]
	m_bOnlyCompleteFiles = thePrefs.m_bOnlyCompleteFiles; // NEO: OCF - [OnlyCompleetFiles]
	m_iToOldComplete = thePrefs.m_iToOldComplete; // NEO: OCF - [OnlyCompleetFiles]
	m_uUseLugdunumCredits = thePrefs.m_uUseLugdunumCredits; // NEO: KLC - [KhaosLugdunumCredits]
	m_bPreferShareAll = thePrefs.m_bPreferShareAll; // NEO: PSA - [PreferShareAll]
	// NEO: ASF - [AdvancedServerFilter]
	m_bDontRemoveStaticServers = thePrefs.m_bDontRemoveStaticServers;
	m_bServerFilterAutoDel = thePrefs.m_bServerFilterAutoDel;
	m_iServerFilter = thePrefs.m_iServerFilter;
	m_sServerFilterVal = thePrefs.m_sServerFilterVal;
	m_bServerFilterDataless = thePrefs.m_bServerFilterDataless;
	// NEO: ASF END
	m_bUseCustomPermissions = thePrefs.m_bUseCustomPermissions; // NEO: SSP - [ShowSharePermissions]
	m_sCommunity = thePrefs.m_sCommunity; // NEO: NC - [NiceCommunity]
	// NEO: NXI - [NeoExtraInfo]
	m_bSendExtraInfo = thePrefs.m_bSendExtraInfo;
	m_bSendExtraInfoBandwidth = thePrefs.m_bSendExtraInfoBandwidth;
	m_uSendExtraInfoUpTime = thePrefs.m_uSendExtraInfoUpTime;
	m_bSendExtraInfoDlFile = thePrefs.m_bSendExtraInfoDlFile;
	m_uSendExtraInfoUlFile = thePrefs.m_uSendExtraInfoUlFile;
	m_bSendExtraInfoWaitingUsers = thePrefs.m_bSendExtraInfoWaitingUsers;
	m_sSendExtraInfoString = thePrefs.m_sSendExtraInfoString;
	// NEO: NXI END
	m_dAppPriority = thePrefs.m_dAppPriority;
	// NEO: MOD - [NiceHash]
	m_bUseHashingDelay = thePrefs.m_bUseHashingDelay;
	m_iHashingDelay = thePrefs.m_iHashingDelay;
	// NEO: MOD END
	// NEO: MOD - [RelaxCPU]
	m_bUseProcessingDelay = thePrefs.m_bUseProcessingDelay;
	m_iProcessingDelay = thePrefs.m_iProcessingDelay;
	// NEO: MOD END
	// NEO: MOD - [RefreshShared]
	m_bRefreshShared = thePrefs.m_bRefreshShared;
	m_iRefreshSharedIntervals = thePrefs.m_iRefreshSharedIntervals;
	// NEO: MOD END
	m_bPauseOnFileComplete = thePrefs.m_bPauseOnFileComplete; // NEO: POFC - [PauseOnFileComplete]
}

BOOL CPPgNeo::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	/*
	* Globale Einstellungen Speichern
	*/

	// NEO: XC - [ExtendedComments]
	bool OldSCState = thePrefs.m_bUseSaveComments;
	thePrefs.m_bUseSaveComments = m_bUseSaveComments; 
	if (OldSCState != thePrefs.m_bUseSaveComments && thePrefs.m_bUseSaveComments
	 && !theApp.knownfiles->IsCommentsLoaded())
		theApp.knownfiles->LoadComments();
	// NEO: XC END
	thePrefs.m_bUseKnownComments = m_bUseKnownComments; // NEO: XCk - [ExtendedKnownComments]
	thePrefs.m_uInteligentChunkSelecting = m_uInteligentChunkSelecting; // NEO: ICS - [InteligentChunkSelection]
	thePrefs.m_uSubChunkTransfer = m_uSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]
	thePrefs.m_uSubChunkVerification = m_uSubChunkVerification; // NEO: SCV - [SubChunkVerification]
	thePrefs.m_uRealPartStatus = m_uRealPartStatus; // NEO: RPS - [RealPartStatus]
	thePrefs.m_uAntiHideOS = m_uAntiHideOS; // NEO: AHOS - [AntiHideOS]
	thePrefs.m_bEstimatedDownloadTime = m_bEstimatedDownloadTime; // NEO: EDT - [EstimatedDownloadTime] 
	thePrefs.m_uLowID2HighIDAutoCallback = m_uLowID2HighIDAutoCallback; // NEO: L2H - [LowID2HighIDAutoCallback]
	thePrefs.m_uShareAlsoEmptyFiles = m_uShareAlsoEmptyFiles; // NEO: SEF - [ShareAlsoEmptyFiles]
	thePrefs.m_bOnlyCompleteFiles = m_bOnlyCompleteFiles; // NEO: OCF - [OnlyCompleetFiles]
	if(m_iToOldComplete) thePrefs.m_iToOldComplete = m_iToOldComplete; // NEO: OCF - [OnlyCompleetFiles]
	thePrefs.m_uUseLugdunumCredits = m_uUseLugdunumCredits; // NEO: KLC - [KhaosLugdunumCredits]
	thePrefs.m_bPreferShareAll = m_bPreferShareAll; // NEO: PSA - [PreferShareAll]
	// NEO: ASF - [AdvancedServerFilter]
	thePrefs.m_bDontRemoveStaticServers = m_bDontRemoveStaticServers;
	thePrefs.m_bServerFilterAutoDel = m_bServerFilterAutoDel;
	thePrefs.m_iServerFilter = m_iServerFilter;
	thePrefs.m_sServerFilterVal = m_sServerFilterVal;
	thePrefs.m_bServerFilterDataless = m_bServerFilterDataless;
	// NEO: ASF END
	thePrefs.m_bUseCustomPermissions = m_bUseCustomPermissions; // NEO: SSP - [ShowSharePermissions]
	thePrefs.m_sCommunity = m_sCommunity; // NEO: NC - [NiceCommunity]
	// NEO: NXI - [NeoExtraInfo]
	thePrefs.m_bSendExtraInfo = m_bSendExtraInfo;
	thePrefs.m_bSendExtraInfoBandwidth = m_bSendExtraInfoBandwidth;
	thePrefs.m_uSendExtraInfoUpTime = m_uSendExtraInfoUpTime;
	thePrefs.m_bSendExtraInfoDlFile = m_bSendExtraInfoDlFile;
	thePrefs.m_uSendExtraInfoUlFile = m_uSendExtraInfoUlFile;
	thePrefs.m_bSendExtraInfoWaitingUsers = m_bSendExtraInfoWaitingUsers;
	thePrefs.m_sSendExtraInfoString = m_sSendExtraInfoString;
	// NEO: NXI END

	if(thePrefs.m_dAppPriority != m_dAppPriority)
		SetPriorityClass(GetCurrentProcess(), m_dAppPriority);
	thePrefs.m_dAppPriority = m_dAppPriority;

	// NEO: MOD - [NiceHash]
	thePrefs.m_bUseHashingDelay = m_bUseHashingDelay;
	thePrefs.m_iHashingDelay = m_iHashingDelay;
	// NEO: MOD END
	// NEO: MOD - [RelaxCPU]
	thePrefs.m_bUseProcessingDelay = m_bUseProcessingDelay;
	thePrefs.m_iProcessingDelay = m_iProcessingDelay;
	// NEO: MOD END
	// NEO: MOD - [RefreshShared]
	thePrefs.m_bRefreshShared = m_bRefreshShared;
	thePrefs.m_iRefreshSharedIntervals = m_iRefreshSharedIntervals;
	// NEO: MOD END
	thePrefs.m_bPauseOnFileComplete = m_bPauseOnFileComplete; // NEO: POFC - [PauseOnFileComplete]

	thePrefs.CheckNeoPreferences();
	LoadSettings();

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

BOOL CPPgNeo::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

void CPPgNeo::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

LRESULT CPPgNeo::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){
			// NEO: OCF - [OnlyCompleetFiles]
			if(m_htiOnlyCompleteFiles && pton->hItem == m_htiOnlyCompleteFiles){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiOnlyCompleteFiles, TO_OLD_SOURCE_MIN, TO_OLD_SOURCE_DEF, TO_OLD_SOURCE_MAX)) SetModified();
			}
			// NEO: OCF END
			// NEO: MOD - [NiceHash]
			if(m_htiHashingDelay && pton->hItem == m_htiHashingDelay){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiHashingDelay, VAL_HASHING_DELAY_MIN, VAL_HASHING_DELAY_DEF, VAL_HASHING_DELAY_MAX)) SetModified();
			}
			// NEO: MOD END
			// NEO: MOD - [RelaxCPU]
			if(m_htiProcessingDelay && pton->hItem == m_htiProcessingDelay){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiProcessingDelay, VAL_PROCESSING_DELAY_MIN, VAL_PROCESSING_DELAY_DEF, VAL_PROCESSING_DELAY_MAX)) SetModified();
			}
			// NEO: MOD END
			// NEO: MOD - [RefreshShared]
			if(m_htiRefreshShared && pton->hItem == m_htiRefreshShared){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiRefreshShared, TIM_REFRESH_SHARED_INTERVALS_MIN, TIM_REFRESH_SHARED_INTERVALS_DEF, TIM_REFRESH_SHARED_INTERVALS_MAX)) SetModified();
			}
			// NEO: MOD END
		}else{
			UINT bCheck;
			// NEO: SCV - [SubChunkVerification]
			if (m_htiSubChunkTransfer && pton->hItem == m_htiSubChunkTransfer){
				UINT uCheck;
				m_ctrlTreeOptions.GetCheckBox(m_htiSubChunkTransfer, uCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiSubChunkVerification, uCheck);
			}
			// NEO: SCV END
			// NEO: NXI - [NeoExtraInfo]
			else if (m_htiSendExtraInfoEnable && pton->hItem == m_htiSendExtraInfoEnable){
				CheckNXI();
			}
			// NEO: NXI END
			// NEO: MOD - [NiceHash]
			else if (m_htiHashingDelay && pton->hItem == m_htiHashingDelay){
				m_ctrlTreeOptions.GetCheckBox(m_htiHashingDelay, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiHashingDelay, bCheck,FALSE,TRUE);
			}
			// NEO: MOD END
			// NEO: MOD - [RelaxCPU]
			else if (m_htiProcessingDelay && pton->hItem == m_htiProcessingDelay){
				m_ctrlTreeOptions.GetCheckBox(m_htiProcessingDelay, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiProcessingDelay, bCheck,FALSE,TRUE);
			}
			// NEO: MOD END
			// NEO: MOD - [RefreshShared]
			else if (m_htiRefreshShared && pton->hItem == m_htiRefreshShared){
				m_ctrlTreeOptions.GetCheckBox(m_htiRefreshShared, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiRefreshShared, bCheck,FALSE,TRUE);
			}
			// NEO: MOD END
			SetModified();
		}
	}
	return 0;
}


// NEO: NXI - [NeoExtraInfo]
void CPPgNeo::CheckNXI(){
	UINT bCheck;

	m_ctrlTreeOptions.GetCheckBox(m_htiSendExtraInfoEnable, bCheck);

	m_ctrlTreeOptions.SetItemEnable(m_htiSendExtraInfoBandwidth, bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiSendExtraInfoUpTime, bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiSendExtraInfoDlFile, bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiSendExtraInfoUlFile, bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiSendExtraInfoWaitingUsers, bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiSendExtraInfoString, bCheck);
}
// NEO: NXI END

LRESULT CPPgNeo::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_MOD_OPTS_INFO, *sInfo);
	}
	return FALSE;
}

void CPPgNeo::OnHelp()
{
	//theApp.ShowHelp(0);
}

BOOL CPPgNeo::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgNeo::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}
